/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.editor.impl.DrawLine;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class Loop {
    public int x;
    public int y;
    public int w;
    public int h;
    public Point anchor;
    public Point anch0;
    public Point anch1;
    public Point anch2;
    public Point anch3;
    public Point anch4;
    public int anchorID;
    public static final int CENTER = 0;
    public static final int UPPER_LEFT = 1;
    public static final int UPPER_RIGHT = 2;
    public static final int BOTTOM_RIGHT = 3;
    public static final int BOTTOM_LEFT = 4;
    public static final int DEFAULT_SIZE = 14;
    public static final int MOVE_ANCHOR_SIZE = 8;
    private Color col = new Color(0, 0, 0);
    private int min = 14;

    public Loop(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.anch1 = new Point(x, y);
        this.anch2 = new Point(x + w, y);
        this.anch3 = new Point(x + w, y + h);
        this.anch4 = new Point(x, y + h);
        this.anch0 = new Point(x + w / 2, y + h / 2);
        this.anchorID = 1;
        this.anchor = this.anch1;
    }

    public void setLoop(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.anch1 = new Point(x, y);
        this.anch2 = new Point(x + w, y);
        this.anch3 = new Point(x + w, y + h);
        this.anch4 = new Point(x, y + h);
        this.anch0 = new Point(x + w / 2, y + h / 2);
        this.anchorID = 1;
        this.anchor = this.anch1;
    }

    public Point getAnchor(int id) {
        Point myAnchor = null;
        switch (id) {
            case 0: {
                myAnchor = this.anch0;
                break;
            }
            case 1: {
                myAnchor = this.anch1;
                break;
            }
            case 2: {
                myAnchor = this.anch2;
                break;
            }
            case 3: {
                myAnchor = this.anch3;
                break;
            }
            case 4: {
                myAnchor = this.anch4;
                break;
            }
            default: {
                myAnchor = this.anch1;
            }
        }
        return myAnchor;
    }

    public boolean isUPPER_LEFT() {
        return this.anchor.x == this.anch1.x && this.anchor.y == this.anch1.y;
    }

    public boolean isUPPER_RIGHT() {
        return this.anchor.x == this.anch2.x && this.anchor.y == this.anch2.y;
    }

    public boolean isBOTTOM_RIGHT() {
        return this.anchor.x == this.anch3.x && this.anchor.y == this.anch3.y;
    }

    public boolean isBOTTOM_LEFT() {
        return this.anchor.x == this.anch4.x && this.anchor.y == this.anch4.y;
    }

    public void setColor(Color aColor) {
        this.col = aColor;
    }

    private void drawLoop(Graphics g) {
        g.setColor(Color.black);
        g.drawLine(this.anch1.x, this.anch1.y, this.anch2.x, this.anch2.y);
        g.drawLine(this.anch2.x, this.anch2.y, this.anch3.x, this.anch3.y);
        g.drawLine(this.anch3.x, this.anch3.y, this.anch4.x, this.anch4.y);
        g.drawLine(this.anch4.x, this.anch4.y, this.anch1.x, this.anch1.y);
    }

    public void drawSolidLoop(Graphics g) {
        this.drawLoop(g);
        g.setColor(Color.black);
    }

    public void drawColorSolidLoop(Graphics g) {
        g.setColor(this.col);
        DrawLine drawLine = new DrawLine(g, this.anch1.x, this.anch1.y, this.anch2.x, this.anch2.y);
        drawLine = new DrawLine(g, this.anch2.x, this.anch2.y, this.anch3.x, this.anch3.y);
        drawLine = new DrawLine(g, this.anch3.x, this.anch3.y, this.anch4.x, this.anch4.y);
        drawLine = new DrawLine(g, this.anch4.x, this.anch4.y, this.anch1.x, this.anch1.y);
    }

    public void drawColorDotLoop(Graphics g) {
        g.setColor(this.col);
        DrawLine drawLine = new DrawLine(g, 2, this.anch1.x, this.anch1.y, this.anch2.x, this.anch2.y);
        drawLine = new DrawLine(g, 2, this.anch2.x, this.anch2.y, this.anch3.x, this.anch3.y);
        drawLine = new DrawLine(g, 2, this.anch3.x, this.anch3.y, this.anch4.x, this.anch4.y);
        drawLine = new DrawLine(g, 2, this.anch4.x, this.anch4.y, this.anch1.x, this.anch1.y);
    }

    public void drawColorDashLoop(Graphics g) {
        g.setColor(this.col);
        DrawLine drawLine = new DrawLine(g, 1, this.anch1.x, this.anch1.y, this.anch2.x, this.anch2.y);
        drawLine = new DrawLine(g, 1, this.anch2.x, this.anch2.y, this.anch3.x, this.anch3.y);
        drawLine = new DrawLine(g, 1, this.anch3.x, this.anch3.y, this.anch4.x, this.anch4.y);
        drawLine = new DrawLine(g, 1, this.anch4.x, this.anch4.y, this.anch1.x, this.anch1.y);
    }

    public void drawMoveAnchor(Graphics grs, int anchorKey) {
        Graphics2D g = (Graphics2D)grs;
        Color lastColor = g.getColor();
        g.setPaint(Color.black);
        if (anchorKey == 1) {
            g.fill(new Rectangle(this.anch1.x - 4, this.anch1.y - 4, 8, 8));
        }
        g.setPaint(lastColor);
    }

    public void move(Rectangle r, int anchorID, int dx, int dy) {
        this.anchorID = anchorID;
        if (anchorID == 0) {
            this.anchor = this.anch0;
        } else if (anchorID == 1) {
            this.anchor = this.anch1;
        } else if (anchorID == 2) {
            this.anchor = this.anch2;
        } else if (anchorID == 3) {
            this.anchor = this.anch3;
        } else if (anchorID == 4) {
            this.anchor = this.anch4;
        }
        if (anchorID == 0) {
            this.moveMe(r, dx, dy);
        } else {
            this.resizeMe(r, dx, dy);
        }
    }

    private void moveMe(Rectangle r, int dx, int dy) {
        if (this.testAnchors(r, dx, dy)) {
            this.x += dx;
            this.y += dy;
        }
    }

    private void moveMe(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    private void resizeMe(Rectangle r, int dx, int dy) {
        if (this.anchorID == 1) {
            if (this.testActiveAnchor(r, dx, dy)) {
                if (dx < 0 && dy < 0) {
                    this.x += dx;
                    this.y += dy;
                    this.w += Math.abs(dx);
                    this.h += Math.abs(dy);
                } else if (dx >= 0 && dy >= 0) {
                    this.x += dx;
                    this.y += dy;
                    this.w -= dx;
                    this.h -= dy;
                }
            }
        } else if (this.anchorID == 2) {
            if (this.testActiveAnchor(r, dx, dy)) {
                if (dx > 0 && dy < 0) {
                    this.y += dy;
                    this.w += dx;
                    this.h += Math.abs(dy);
                } else if (dx < 0 && dy > 0) {
                    this.y += dy;
                    this.w += dx;
                    this.h -= dy;
                }
            }
        } else if (this.anchorID == 3) {
            if (this.testActiveAnchor(r, dx, dy) && (dx > 0 && dy > 0 || dx < 0 && dy < 0)) {
                this.w += dx;
                this.h += dy;
            }
        } else if (this.anchorID == 4 && this.testActiveAnchor(r, dx, dy)) {
            if (dx < 0 && dy > 0) {
                this.x += dx;
                this.w += Math.abs(dx);
                this.h += dy;
            } else if (dx > 0 && dy < 0) {
                this.x += dx;
                this.w -= dx;
                this.h += dy;
            }
        }
        if (this.x + this.w >= r.x + r.width) {
            this.w -= (this.x + this.w - (r.x + r.width)) * 2;
        }
        if (this.y + this.h >= r.y + r.height) {
            this.h -= (this.y + this.h - (r.y + r.height)) * 2;
        }
    }

    public boolean contains(Point p) {
        Rectangle r = new Rectangle(this.anch1.x - 5, this.anch1.y - 5, 10, 10);
        return r.contains(p.x, p.y);
    }

    private boolean testActiveAnchor(Rectangle r, int dx, int dy) {
        Point a1 = new Point(this.anch1.x, this.anch1.y);
        Point a2 = new Point(this.anch2.x, this.anch2.y);
        Point a3 = new Point(this.anch3.x, this.anch3.y);
        Point a4 = new Point(this.anch4.x, this.anch4.y);
        int wl = 0;
        int hl = 0;
        if (this.anchorID == 1) {
            a1.x += dx;
            a1.y += dy;
            a4.x += dx;
            a2.y += dy;
            if (dx < 0 && dy < 0) {
                wl = this.w + Math.abs(dx);
                hl = this.h + Math.abs(dy);
                return this.inside(r, a1, a2, a3, a4) && this.outside(r, a1, a2, a3, a4) && this.minWidth(wl) && this.minHeight(hl);
            }
            wl = this.w - dx;
            hl = this.h - dy;
            r.setSize((int)(r.getWidth() + 1.0), (int)(r.getHeight() + 1.0));
            return this.inside(r, a1, a2, a3, a4) && this.outside(r, a1, a2, a3, a4) && this.minWidth(wl) && this.minHeight(hl);
        }
        if (this.anchorID == 2) {
            a2.x += dx;
            a2.y += dy;
            a1.y += dy;
            a3.x += dx;
            if (dx > 0 && dy < 0) {
                wl = this.w + dx;
                hl = this.h + Math.abs(dy);
                return this.inside(r, a1, a2, a3, a4) && this.outside(r, a1, a2, a3, a4) && this.minWidth(wl) && this.minHeight(hl);
            }
            wl = this.w + dx;
            hl = this.h - dy;
            r.setSize((int)(r.getWidth() + 1.0), (int)(r.getHeight() + 1.0));
            return this.inside(r, a1, a2, a3, a4) && this.outside(r, a1, a2, a3, a4) && this.minWidth(wl) && this.minHeight(hl);
        }
        if (this.anchorID == 3) {
            a3.x += dx;
            a3.y += dy;
            a4.x += dx;
            a2.y += dy;
            if (dx > 0 && dy > 0 || dx < 0 && dy < 0) {
                wl = this.w + dx;
                hl = this.h + dy;
            }
            return this.inside(r, a1, a2, a3, a4) && this.outside(r, a1, a2, a3, a4) && this.minWidth(wl) && this.minHeight(hl);
        }
        if (this.anchorID == 4) {
            a4.x += dx;
            a4.y += dy;
            a3.y += dy;
            a1.x += dx;
            if (dx < 0 && dy > 0) {
                wl = this.w + Math.abs(dx);
                hl = this.h + dy;
                return this.inside(r, a1, a2, a3, a4) && this.outside(r, a1, a2, a3, a4) && this.minWidth(wl) && this.minHeight(hl);
            }
            wl = this.w - dx;
            hl = this.h + dy;
            r.setSize((int)(r.getWidth() + 1.0), (int)(r.getHeight() + 1.0));
            return this.inside(r, a1, a2, a3, a4) && this.outside(r, a1, a2, a3, a4) && this.minWidth(wl) && this.minHeight(hl);
        }
        return false;
    }

    private boolean inside(Rectangle r, Point a1, Point a2, Point a3, Point a4) {
        return r.contains(a1.x, a1.y) || r.contains(a2.x, a2.y) || r.contains(a3.x, a3.y) || r.contains(a4.x, a4.y);
    }

    public boolean outside(Rectangle r, Point a1, Point a2, Point a3, Point a4) {
        return !r.contains(a1.x, a1.y) || !r.contains(a2.x, a2.y) || !r.contains(a3.x, a3.y) || !r.contains(a4.x, a4.y);
    }

    private boolean testAnchors(Rectangle r, int dx, int dy) {
        Point a1 = new Point(this.anch1.x, this.anch1.y);
        Point a2 = new Point(this.anch2.x, this.anch2.y);
        Point a3 = new Point(this.anch3.x, this.anch3.y);
        Point a4 = new Point(this.anch4.x, this.anch4.y);
        a1.x += dx;
        a1.y += dy;
        a2.x += dx;
        a2.y += dy;
        a3.x += dx;
        a3.y += dy;
        a4.x += dx;
        a4.y += dy;
        return this.inside(r, a1, a2, a3, a4) && this.outside(r, a1, a2, a3, a4);
    }

    private void setActiveAnchor(Point p) {
        Rectangle r1 = new Rectangle(this.anch1.x - 4, this.anch1.y - 4, 8, 8);
        Rectangle r2 = new Rectangle(this.anch2.x - 4, this.anch2.y - 4, 8, 8);
        Rectangle r3 = new Rectangle(this.anch3.x - 4, this.anch3.y - 4, 8, 8);
        Rectangle r4 = new Rectangle(this.anch4.x - 4, this.anch4.y - 4, 8, 8);
        Rectangle r0 = new Rectangle(this.x, this.y, this.w, this.h);
        if (r1.contains(p.x, p.y)) {
            this.anchor = this.anch1;
            this.anchorID = 1;
        } else if (r2.contains(p.x, p.y)) {
            this.anchor = this.anch2;
            this.anchorID = 2;
        } else if (r3.contains(p.x, p.y)) {
            this.anchor = this.anch3;
            this.anchorID = 3;
        } else if (r4.contains(p.x, p.y)) {
            this.anchor = this.anch4;
            this.anchorID = 4;
        } else if (r0.contains(p.x, p.y)) {
            this.anchor = this.anch0;
            this.anchorID = 0;
        } else {
            this.anchor = null;
            this.anchorID = -1;
        }
    }

    private boolean minWidth(int wl) {
        return wl >= this.min;
    }

    private boolean minHeight(int hl) {
        return hl >= this.min;
    }
}

