/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.gui.AGGAppl;
import agg.gui.AGGConstraints;
import agg.gui.CriticalPairAnalysis;
import agg.gui.DefectManagement;
import agg.gui.GraGraTreeView;
import agg.gui.TerminationAnalysis;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class AGGAnalyzer
implements EditEventListener,
MenuListener {
    private CriticalPairAnalysis criticalPairAnalysis;
    private AGGConstraints aggConstraints;
    private TerminationAnalysis terminationAnalysis;
    private JMenu menu;
    private Vector menus;
    private GraGraTreeView treeView;
    private DefectManagement defectManagement;

    public AGGAnalyzer(AGGAppl appl, GraGraTreeView tree) {
        this.treeView = tree;
        this.menus = new Vector(1);
        this.menu = new JMenu("Analyzer", true);
        this.menu.setMnemonic('a');
        this.menus.addElement(this.menu);
    }

    public void addCriticalPairAnalysis(CriticalPairAnalysis cpa) {
        this.criticalPairAnalysis = cpa;
        Enumeration e = cpa.getMenus();
        while (e.hasMoreElements()) {
            this.menu.add((JMenu)e.nextElement());
        }
    }

    public void addDefectManagement(DefectManagement dm) {
        this.defectManagement = dm;
        Enumeration e = dm.getMenus();
        while (e.hasMoreElements()) {
            this.menu.add((JMenu)e.nextElement());
        }
        this.menu.addMenuListener(this);
    }

    public void addConstraints(AGGConstraints constraints) {
        this.aggConstraints = constraints;
        Enumeration e = constraints.getMenus();
        while (e.hasMoreElements()) {
            this.menu.add((JMenu)e.nextElement());
        }
    }

    public void addTerminationAnalysis(TerminationAnalysis term) {
        this.menu.add(term.getMenuItem());
    }

    public Enumeration getMenus() {
        return this.menus.elements();
    }

    public CriticalPairAnalysis getCriticalPairAnalysis() {
        return this.criticalPairAnalysis;
    }

    public DefectManagement getDefectManagement() {
        return this.defectManagement;
    }

    public AGGConstraints getConstraints() {
        return this.aggConstraints;
    }

    public void editEventOccurred(EditEvent e) {
        if (e.getMsg() == -10 && e.getMessage().equals("Analyzer")) {
            this.menu.doClick();
        }
    }

    public void menuSelected(MenuEvent e) {
    }

    public void menuDeselected(MenuEvent e) {
    }

    public void menuCanceled(MenuEvent e) {
    }
}

