/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.gui.AGGAnalyzer;
import agg.gui.AGGConstraints;
import agg.gui.AGGParser;
import agg.gui.AGGPreferences;
import agg.gui.CriticalPairAnalysis;
import agg.gui.DebugFrame;
import agg.gui.DefectManagement;
import agg.gui.GraGraEditor;
import agg.gui.GraGraHelp;
import agg.gui.GraGraTreeView;
import agg.gui.GraphicsExportJPEG;
import agg.gui.StatusBar;
import agg.gui.TerminationAnalysis;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import agg.xt_basis.Version;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class AGGAppl
extends JFrame
implements Serializable,
EditEventListener {
    public static int WIDTH = 800;
    public static int HEIGHT = 550;
    public static int INITIAL_WIDTH = 350;
    public static int INITIAL_HEIGHT = 400;
    public static int totalPanels = 4;
    public static int currentProgressValue;
    public static JLabel progressLabel;
    public static JProgressBar progressBar;
    private static AGGAppl instance;
    private static String ver;
    private static ImageIcon icon;
    private static JMenuBar menuBar;
    private static JPanel toolBarPanel;
    private static JPanel contentPanel;
    private static JPanel mainPanel;
    private static JSplitPane splitPane;
    private static JPanel editPanel;
    private static GraGraTreeView treeView;
    private static GraGraEditor editor;
    private static StatusBar statusBar;
    private static JMenu helpMenu;
    private static final boolean DEBUGFRAME = false;
    private AGGAnalyzer aggAnalyzer;
    private TerminationAnalysis terminationAnalysis;
    private CriticalPairAnalysis criticalPairAnalysis;
    private AGGConstraints aggConstraints;
    private AGGParser aggParser;
    private AGGPreferences aggPreferences;
    private GraphicsExportJPEG exportJPEG;
    DefectManagement defectManagement;

    public AGGAppl() {
        instance = this;
        currentProgressValue = 0;
    }

    public void createApplContent() {
        contentPanel = new JPanel(new BorderLayout(), true);
        menuBar = new JMenuBar();
        progressBar.setValue(++currentProgressValue);
        toolBarPanel = new JPanel(new GridLayout(2, 1));
        statusBar = new StatusBar();
        statusBar.setFrame(this);
        progressBar.setValue(++currentProgressValue);
        contentPanel.add((Component)statusBar, "South");
        this.exportJPEG = new GraphicsExportJPEG(this);
        editor = new GraGraEditor();
        progressBar.setValue(++currentProgressValue);
        editor.setFrame(this);
        editor.addEditEventListener(this);
        editor.addEditEventListener(statusBar);
        editor.setExportJPEG(this.exportJPEG);
        treeView = new GraGraTreeView();
        progressBar.setValue(++currentProgressValue);
        treeView.setFrame(this);
        treeView.setExportJPEG(this.exportJPEG);
        treeView.addSaveEventListener(statusBar);
        treeView.addLoadEventListener(statusBar);
        treeView.addTreeViewEventListener(statusBar);
        treeView.addTreeViewEventListener(editor);
        treeView.addTreeModelListener(editor);
        editor.addEditEventListener(treeView.getPrint());
        editor.addEditEventListener(treeView);
        editor.getGraGraTransform().addTransformEventListener(treeView);
        toolBarPanel.add(treeView.getToolBar());
        toolBarPanel.add(editor.getToolBar());
        this.aggParser = new AGGParser(instance, treeView);
        this.aggParser.addStatusMessageListener(statusBar);
        this.aggParser.addParserEventListener(statusBar);
        editor.addEditEventListener(this.aggParser);
        this.aggAnalyzer = new AGGAnalyzer(instance, treeView);
        editor.addEditEventListener(this.aggAnalyzer);
        this.criticalPairAnalysis = new CriticalPairAnalysis(instance, treeView);
        this.aggAnalyzer.addCriticalPairAnalysis(this.criticalPairAnalysis);
        treeView.addTreeViewEventListener(this.criticalPairAnalysis);
        this.criticalPairAnalysis.addCPAnalysisEventListener(statusBar);
        this.criticalPairAnalysis.addStatusMessageListener(statusBar);
        this.criticalPairAnalysis.setLayerOption(this.aggParser.getLayerOption());
        this.criticalPairAnalysis.setParserOption(this.aggParser.getParserOption());
        this.criticalPairAnalysis.setGUIOption(this.aggParser.getParserGUIOption());
        this.criticalPairAnalysis.setExportJPEG(this.exportJPEG);
        this.aggParser.setCriticalPairOption(this.criticalPairAnalysis.getCriticalPairOption());
        this.defectManagement = new DefectManagement(instance, treeView, editor);
        treeView.addTreeViewEventListener(this.defectManagement);
        this.aggAnalyzer.addDefectManagement(this.defectManagement);
        this.defectManagement.addStatusMessageListener(statusBar);
        this.defectManagement.addDMListener(statusBar);
        this.aggConstraints = new AGGConstraints(instance, treeView);
        this.aggAnalyzer.addConstraints(this.aggConstraints);
        this.terminationAnalysis = new TerminationAnalysis(instance, treeView);
        this.aggAnalyzer.addTerminationAnalysis(this.terminationAnalysis);
        treeView.addTreeViewEventListener(this.terminationAnalysis);
        this.aggPreferences = new AGGPreferences(this);
        this.aggPreferences.getOptionGUI().addGUI(editor.getTransformOptionGUI());
        this.aggPreferences.getOptionGUI().addGUI(editor.getGraphLayouterOptionGUI());
        this.aggPreferences.getOptionGUI().addGUI(this.aggParser.getParserOptionGUI());
        this.aggPreferences.getOptionGUI().addGUI(this.aggAnalyzer.getCriticalPairAnalysis().getCriticalPairOptionGUI());
        this.aggPreferences.addActionListenerOfDefaults(editor);
        editor.getTransformOptionGUI().addActionListener(this.aggAnalyzer.getCriticalPairAnalysis().getCriticalPairOptionGUI());
        this.aggAnalyzer.getCriticalPairAnalysis().getCriticalPairOptionGUI().addActionListener(editor.getTransformOptionGUI());
        editor.getTransformOptionGUI().addOptionListener(this.aggParser);
        editor.getTransformOptionGUI().addOptionListener(this.aggAnalyzer.getCriticalPairAnalysis());
        editor.getTransformOptionGUI().addOptionListener("layered", treeView);
        mainPanel = new JPanel(new BorderLayout(), true);
        mainPanel.setPreferredSize(new Dimension(WIDTH, HEIGHT));
        mainPanel.add((Component)toolBarPanel, "North");
        splitPane = new JSplitPane(1, treeView, editor);
        progressBar.setValue(++currentProgressValue);
        splitPane.setPreferredSize(new Dimension(WIDTH, HEIGHT));
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(true);
        mainPanel.add((Component)splitPane, "Center");
        mainPanel.revalidate();
        contentPanel.add((Component)mainPanel, "Center");
        contentPanel.revalidate();
        this.addMenus(treeView.getMenus());
        this.addMenus(editor.getMenus());
        this.addMenus(this.aggParser.getMenus());
        this.addMenus(this.aggAnalyzer.getMenus());
        this.addMenus(this.aggPreferences.getMenus());
        this.addHelpMenu();
    }

    public static void main(String[] args) {
        String javaVers = System.getProperty("java.version");
        if (javaVers.compareTo("1.5.0") < 0) {
            System.out.println("WARNING : AGG must be run with the 1.5.0 version of the JVM.");
        }
        ver = Version.getID();
        AGGAppl appl = new AGGAppl();
        appl.setTitle("AGG  " + ver);
        WindowAdapter wl = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        ComponentAdapter cl = new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                editor.setTypePanelDividerLocation(editor.getWidth() - 100);
            }
        };
        appl.setBackground(Color.lightGray);
        appl.addComponentListener(cl);
        appl.getContentPane().setLayout(new BorderLayout());
        JOptionPane.setRootFrame(appl);
        JFrame logoFrame = new JFrame();
        logoFrame.setBackground(Color.lightGray);
        logoFrame.getContentPane().setLayout(new BorderLayout());
        logoFrame.setSize(INITIAL_WIDTH, INITIAL_HEIGHT);
        ImageIcon image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/AGG_LOGO.gif"));
        if (image == null) {
            System.out.println("AGG_LOGO.gif not found!");
        } else {
            JLabel gragraLogo = new JLabel();
            gragraLogo.setIcon(image);
            gragraLogo.setPreferredSize(new Dimension(image.getIconWidth(), image.getIconHeight()));
            gragraLogo.revalidate();
            logoFrame.getContentPane().add((Component)gragraLogo, "Center");
        }
        icon = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/AGG_ICON64.gif"));
        if (icon == null || icon.getImage() == null) {
            System.out.println("AGG_ICON64.gif not found!");
        } else {
            appl.setIconImage(icon.getImage());
        }
        JPanel progressPanel = new JPanel(){

            public Insets getInsets() {
                return new Insets(30, 10, 10, 10);
            }
        };
        progressPanel.setLayout(new BoxLayout(progressPanel, 1));
        progressPanel.setBackground(Color.white);
        Dimension d = new Dimension(300, 20);
        progressLabel = new JLabel("Loading, please wait...");
        progressLabel.setAlignmentX(0.5f);
        progressLabel.setMaximumSize(d);
        progressLabel.setPreferredSize(d);
        progressPanel.add(progressLabel);
        progressPanel.add(Box.createRigidArea(new Dimension(300, 5)));
        progressBar = new JProgressBar();
        progressLabel.setLabelFor(progressBar);
        progressBar.setAlignmentX(0.5f);
        progressBar.setMinimum(0);
        progressBar.setMaximum(totalPanels);
        progressBar.setValue(0);
        progressBar.setPreferredSize(new Dimension(300, 20));
        progressPanel.add(progressBar);
        progressPanel.revalidate();
        logoFrame.getContentPane().add((Component)progressPanel, "South");
        logoFrame.getRootPane().revalidate();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        logoFrame.setLocation(screenSize.width / 2 - INITIAL_WIDTH / 2, screenSize.height / 2 - INITIAL_HEIGHT / 2);
        logoFrame.setCursor(Cursor.getPredefinedCursor(3));
        logoFrame.pack();
        logoFrame.setVisible(true);
        appl.createApplContent();
        appl.addWindowListener(wl);
        appl.setJMenuBar(menuBar);
        appl.getContentPane().add((Component)contentPanel, "Center");
        appl.setCursor(Cursor.getPredefinedCursor(0));
        appl.setLocation(screenSize.width / 2 - WIDTH / 2, screenSize.height / 2 - HEIGHT / 2 - 100);
        appl.pack();
        appl.getRootPane().revalidate();
        logoFrame.setVisible(false);
        logoFrame.dispose();
        appl.setVisible(true);
        if (args.length == 1) {
            if (args[0].indexOf(".ggx") == -1) {
                System.out.println("AGG cannot load a file! \nThe file: " + args[0] + "  is not a GGX (.ggx) file!");
                JOptionPane.showMessageDialog(appl, "AGG cannot load a file! \nThe file: " + args[0] + "  is not a GGX ( .ggx ) file!");
            } else {
                treeView.loadGraGra(args[0]);
            }
        }
        appl.getGraGraEditor().requestFocusInWindow();
        appl.getGraGraTreeView().requestFocusInWindow();
        Runtime.getRuntime().gc();
    }

    public static AGGAppl sharedInstance() {
        return instance;
    }

    public void addMenus(Enumeration menus) {
        while (menus.hasMoreElements()) {
            menuBar.add((JMenu)menus.nextElement());
        }
    }

    public void addMenu(JMenu menu) {
        menuBar.add(menu);
    }

    public void removeMenus(Enumeration menus) {
        JMenuBar mbar = new JMenuBar();
        while (menus.hasMoreElements()) {
            JMenu m = (JMenu)menus.nextElement();
            this.removeMenu(m);
        }
    }

    public void removeMenu(JMenu menu) {
        JMenuBar mbar = new JMenuBar();
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            JMenu m = menuBar.getMenu(i);
            if (m == menu) continue;
            mbar.add(m);
        }
        this.setJMenuBar(mbar);
        menuBar = this.getJMenuBar();
    }

    public void setMenuEnabled(int indx, boolean enabled) {
        menuBar.getMenu(indx).setEnabled(enabled);
    }

    public void extendHelp(JMenuItem item) {
        if (helpMenu != null) {
            helpMenu.add(item);
        }
    }

    public void removeHelp(JMenuItem item) {
        if (helpMenu != null) {
            helpMenu.remove(item);
        }
    }

    public void setMainContent(Component comp) {
        mainPanel.removeAll();
        mainPanel.add(comp, "Center");
        this.validate();
        this.repaint();
    }

    public static void resetMainContent() {
        mainPanel.removeAll();
        mainPanel.add((Component)toolBarPanel, "North");
        mainPanel.add((Component)splitPane, "Center");
        statusBar.setMode(editor.getEditMode(), new EditEvent(new Object(), editor.getEditMode()).getMessage());
    }

    public void removeMainContent() {
        mainPanel.removeAll();
    }

    public void addIconsToIconBar(Enumeration icons) {
        while (icons.hasMoreElements()) {
        }
    }

    private void addHelpMenu() {
        GraGraHelp gragraHelp = new GraGraHelp();
        helpMenu = gragraHelp;
        menuBar.add(helpMenu);
    }

    private void addDebugMenu() {
        JMenu debug = menuBar.add(new JMenu("DEBUG", true));
        debug.setMnemonic('D');
        JMenuItem mi = debug.add(new JMenuItem("DebugPrefs"));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugFrame df = new DebugFrame();
                df.setVisible(true);
            }
        });
    }

    public void addToolBar(JToolBar aToolBar) {
        toolBarPanel.add(aToolBar);
    }

    public GraGraTreeView getGraGraTreeView() {
        return treeView;
    }

    public GraGraEditor getGraGraEditor() {
        return editor;
    }

    public JPanel getMainPanel() {
        return mainPanel;
    }

    public void exportJPEG() {
        this.exportJPEG.save(editor);
    }

    public void editEventOccurred(EditEvent e) {
        if (e.getMsg() == -10 && e.getMessage().equals("Help")) {
            helpMenu.doClick();
        }
    }

    static {
        ver = "";
    }
}

