/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.attribute.impl.AttrTupleManager;
import agg.editor.impl.EdGraGra;
import agg.gui.AGGAppl;
import agg.gui.GraGraTreeView;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import agg.gui.parser.GUIExchange;
import agg.gui.parser.LayerGUI;
import agg.gui.parser.LayerOptionGUI;
import agg.gui.parser.ParserDesktop;
import agg.gui.parser.ParserDialog;
import agg.gui.parser.ParserGUIOption;
import agg.gui.parser.ParserOptionGUI;
import agg.gui.parser.event.OptionEvent;
import agg.gui.parser.event.OptionListener;
import agg.gui.parser.event.StatusMessageEvent;
import agg.gui.parser.event.StatusMessageListener;
import agg.parser.CriticalPairOption;
import agg.parser.ExcludePairContainer;
import agg.parser.ExcludeParser;
import agg.parser.Layer;
import agg.parser.LayerFunction;
import agg.parser.LayerOption;
import agg.parser.LayeredExcludePairContainer;
import agg.parser.LayeredPairContainer;
import agg.parser.PairContainer;
import agg.parser.Parser;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import agg.parser.ParserFactory;
import agg.parser.ParserMessageEvent;
import agg.parser.ParserOption;
import agg.parser.SimpleParser;
import agg.xt_basis.OrdinaryMorphism;
import com.objectspace.jgl.Pair;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class AGGParser
implements ParserEventListener,
OptionListener,
EditEventListener {
    private GUIExchange changer;
    private ParserGUIOption option;
    private ParserOptionGUI pOptionGUI;
    private ParserOption pOption;
    private LayerOptionGUI lOptionGUI;
    private LayerOption lOption;
    private CriticalPairOption cpOption;
    private ParserDesktop parserDesktop;
    private ParserDialog parserStartDialog;
    private Parser excludeParser;
    private PairContainer tmpPairs;
    private JMenu menu;
    private JMenuItem openP;
    private JMenuItem startP;
    private JMenuItem stopP;
    private JMenuItem backP;
    private JMenuItem editP;
    private Vector listener;
    private Vector pmlistener;
    private boolean activeParser;
    private boolean generateCP;
    private AGGAppl parent;
    private EdGraGra pairsGraGra;
    private EdGraGra hostGraphGrammar;
    private EdGraGra stopGraphGrammar;
    private LayerFunction lf;
    private GraGraTreeView treeView;
    private Vector menus;

    public AGGParser(AGGAppl appl, GraGraTreeView treeView) {
        this.parent = appl;
        this.treeView = treeView;
        this.listener = new Vector();
        this.pmlistener = new Vector();
        this.option = new ParserGUIOption();
        this.lOption = new LayerOption();
        this.lOptionGUI = new LayerOptionGUI(this.lOption);
        this.lOption.addOptionListener(this.lOptionGUI);
        this.pOption = new ParserOption();
        this.pOptionGUI = new ParserOptionGUI(this.option, this.pOption, this.cpOption);
        this.parserDesktop = new ParserDesktop(this, this.option, null, null, null);
        this.menus = new Vector(2);
        this.createParserMenu();
        this.addParserEventListener(this);
        this.changer = new GUIExchange(this.parent);
    }

    public void editEventOccurred(EditEvent e) {
        if (e.getMsg() == -10) {
            if (e.getMessage().equals("Parser")) {
                this.menu.doClick();
            } else if (e.getMessage().equals("Parser Open")) {
                this.openParserDialog();
            }
        }
    }

    public Enumeration getMenus() {
        return this.menus.elements();
    }

    public ParserGUIOption getParserGUIOption() {
        return this.option;
    }

    public LayerOption getLayerOption() {
        return this.lOption;
    }

    public LayerOptionGUI getLayerOptionGUI() {
        return this.lOptionGUI;
    }

    public ParserOption getParserOption() {
        return this.pOption;
    }

    public ParserOptionGUI getParserOptionGUI() {
        return this.pOptionGUI;
    }

    public void setCriticalPairOption(CriticalPairOption cpOption) {
        this.cpOption = cpOption;
        this.pOptionGUI.setCriticalPairOption(cpOption);
        cpOption.addOptionListener(this.pOptionGUI);
    }

    public void parserEventOccured(ParserEvent e) {
        if (e.getMessage().indexOf("Critical") != -1 && e.getMessage().indexOf("finished") != -1) {
            if (this.activeParser && this.generateCP) {
                this.generateCP = false;
            }
            this.fireParserEvent(new ParserMessageEvent(this, " Please choice menu  - Parser / Start -  to start parsing"));
        } else if (e.getMessage().indexOf("Parsing") != -1 && e.getMessage().indexOf("finished") != -1) {
            this.parserDesktop.hostFrameResetIcon();
            this.startP.setEnabled(false);
            this.stopP.setEnabled(false);
            this.pairsGraGra.setChanged(false);
            this.hostGraphGrammar.setChanged(false);
            this.stopGraphGrammar.setChanged(false);
        }
    }

    public void optionEventOccurred(OptionEvent e) {
        JCheckBox cb;
        if (e.getSource() instanceof JCheckBox && (cb = (JCheckBox)e.getSource()).getText().equals("NACs")) {
            this.cpOption.enableNacs(cb.isSelected());
        }
    }

    protected void createParserMenu() {
        this.menu = new JMenu("Parser", true);
        this.menu.setMnemonic('r');
        this.openP = new JMenuItem("Open        Shift+Alt+P");
        this.openP.setEnabled(true);
        this.menu.add(this.openP);
        this.openP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AGGParser.this.openParserDialog();
            }
        });
        this.startP = new JMenuItem("Start         Shift+Alt+S");
        this.startP.setEnabled(false);
        this.menu.add(this.startP);
        this.startP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AGGParser.this.startParser();
            }
        });
        this.stopP = new JMenuItem("Stop         Shift+Alt+Q");
        this.stopP.setEnabled(false);
        this.menu.add(this.stopP);
        this.stopP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AGGParser.this.stopParser();
            }
        });
        this.backP = new JMenuItem("back         Shift+Alt+Z");
        this.backP.setEnabled(false);
        this.menu.add(this.backP);
        this.backP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AGGParser.this.backToGUI();
            }
        });
        this.menus.addElement(this.menu);
    }

    public void openParserDialog() {
        this.parserStartDialog = new ParserDialog(this.parent, this.treeView, this.pOption, this.cpOption, this.lOption);
        this.parserStartDialog.showDialog();
        if (this.parserStartDialog.isReadyToParse()) {
            this.hostGraphGrammar = this.parserStartDialog.getHostGraphGrammar();
            this.stopGraphGrammar = this.parserStartDialog.getStopGraphGrammar();
            this.tmpPairs = this.parserStartDialog.getCriticalPairs();
            this.pairsGraGra = this.stopGraphGrammar;
            if (this.pairsGraGra.getBasisGraGra() == null) {
                JOptionPane.showMessageDialog(null, "Parsing grammar does not exist.", "Warning", 0);
                this.fireParserEvent(new ParserMessageEvent(this, "Thread - Parsing -  was stopped."));
                return;
            }
            if (this.pOption.getSelectedParser() != 0 && (this.hostGraphGrammar.getBasisGraGra().getTypeSet().usesInheritance() || this.pairsGraGra.getBasisGraGra().getTypeSet().usesInheritance())) {
                JOptionPane.showMessageDialog(null, "Sorry!\nParsing based on critical pairs is not possible \nfor graph grammars with node type inheritance.\nPlease select:\n \"Backtracking without optimization\" algoritm for parser.", "Warning", 2);
                this.fireParserEvent(new ParserMessageEvent(this, "Thread - Parsing -  was stopped."));
                return;
            }
            this.lf = null;
            if (this.tmpPairs == null) {
                if (!this.checkIfReadyToTransform(this.pairsGraGra)) {
                    return;
                }
                if (this.pOption.getSelectedParser() != 0) {
                    if (this.pOption.layerEnabled()) {
                        this.lf = ParserFactory.createLayerFunction(this.pairsGraGra.getBasisGraGra(), this.lOption);
                        LayerGUI lg = new LayerGUI(this.parent, this.lf);
                        lg.showGUI();
                        if (!this.lf.isValid()) {
                            this.pOption.enableLayer(false);
                            this.pOptionGUI.update();
                            JOptionPane.showMessageDialog(this.parent, "The layer function is wrong.\nSo falling back to non-layered.", "Wrong Layering", 2);
                        }
                    }
                    this.tmpPairs = ParserFactory.createEmptyCriticalPairs(this.pairsGraGra.getBasisGraGra(), this.lf, this.cpOption);
                    if (this.tmpPairs == null) {
                        JOptionPane.showMessageDialog(null, "Generating of critical pairs is failed.", "Warning", 0);
                        this.fireParserEvent(new ParserMessageEvent(this, "Thread - Parsing -  was stopped."));
                        return;
                    }
                    this.generateCP = true;
                    for (int i = 0; i < this.listener.size(); ++i) {
                        if (this.tmpPairs instanceof LayeredExcludePairContainer) {
                            ((LayeredExcludePairContainer)this.tmpPairs).addPairEventListener((ParserEventListener)this.listener.elementAt(i));
                            continue;
                        }
                        if (!(this.tmpPairs instanceof ExcludePairContainer)) continue;
                        ((ExcludePairContainer)this.tmpPairs).addPairEventListener((ParserEventListener)this.listener.elementAt(i));
                    }
                    this.fireParserEvent(new ParserMessageEvent(this, "Generate critical pairs. Please wait ..."));
                    ParserFactory.generateCriticalPairs(this.tmpPairs);
                } else {
                    this.generateCP = false;
                    if (this.pOption.layerEnabled()) {
                        this.lf = ParserFactory.createLayerFunction(this.pairsGraGra.getBasisGraGra(), this.lOption);
                        LayerGUI lg = new LayerGUI(this.parent, this.lf);
                        lg.showGUI();
                        if (!this.lf.isValid()) {
                            this.pOption.enableLayer(false);
                            this.pOptionGUI.update();
                            JOptionPane.showMessageDialog(this.parent, "The layer function is wrong.\nSo falling back to non-layered.", "Wrong Layering", 2);
                        }
                    }
                }
                if (this.option.getParserDisplay() != 0 && !this.changer.isSet()) {
                    this.changer.changeWith(this.parserDesktop.getComponent());
                }
            } else {
                this.generateCP = false;
                if (this.tmpPairs instanceof LayeredPairContainer) {
                    this.lf = ((Layer)((Object)this.tmpPairs)).getLayer();
                }
                if (this.lf != null && this.lf.isValid()) {
                    this.pOption.enableLayer(true);
                    this.pOptionGUI.update();
                } else {
                    this.pOption.enableLayer(false);
                    this.pOptionGUI.update();
                }
                if (this.option.getParserDisplay() != 0 && !this.changer.isSet()) {
                    this.changer.changeWith(this.parserDesktop.getComponent());
                }
                if (this.pairsGraGra == null) {
                    this.pairsGraGra = new EdGraGra(this.tmpPairs.getGrammar());
                } else if (!this.pairsGraGra.getBasisGraGra().compareTo(this.tmpPairs.getGrammar())) {
                    this.pairsGraGra = new EdGraGra(this.tmpPairs.getGrammar());
                    System.out.println("WARNING! The grammar loaded with critical pairs has some differences to the loaded stop grammar with parsing rules. The critical pairs grammar will be used for parsing.");
                }
                if (this.pairsGraGra == null || this.pairsGraGra.getBasisGraGra() == null) {
                    JOptionPane.showMessageDialog(null, "Parsing rules are not exist.", "Warning", 0);
                    this.fireParserEvent(new ParserMessageEvent(this, "Thread - Parser -  was stopped."));
                    return;
                }
            }
            if (!this.checkIfReadyToTransform(this.hostGraphGrammar)) {
                return;
            }
            ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
            OrdinaryMorphism om = this.hostGraphGrammar.getBasisGraGra().getGraph().isomorphicCopy();
            this.excludeParser = ParserFactory.createParser(this.pairsGraGra.getBasisGraGra(), om.getImage(), this.stopGraphGrammar.getBasisGraGra().getGraph(), this.tmpPairs, this.pOption, this.lf);
            if (this.excludeParser == null) {
                JOptionPane.showMessageDialog(null, "Creating parser is failed.", "Warning", 0);
                this.fireParserEvent(new ParserMessageEvent(this, "Thread - Parsing -  was stopped."));
                return;
            }
            for (int i = 0; i < this.listener.size(); ++i) {
                if (this.excludeParser instanceof ExcludeParser) {
                    ((ExcludeParser)this.excludeParser).addParserEventListener((ParserEventListener)this.listener.elementAt(i));
                    continue;
                }
                if (!(this.excludeParser instanceof SimpleParser)) continue;
                ((SimpleParser)this.excludeParser).addParserEventListener((ParserEventListener)this.listener.elementAt(i));
            }
            this.parserDesktop.setLayout(this.hostGraphGrammar);
            this.parserDesktop.setParser(this.excludeParser, om);
            this.fireStatusMessageEvent(new StatusMessageEvent(this, ""));
            if (!this.generateCP) {
                this.fireParserEvent(new ParserMessageEvent(this, "Please choice menu  - Parser / Start -  to start parsing"));
            }
            this.activeParser = true;
            this.openP.setEnabled(false);
            this.startP.setEnabled(true);
            this.stopP.setEnabled(false);
            this.backP.setEnabled(true);
        }
    }

    public void startParser() {
        if (this.generateCP) {
            this.fireParserEvent(new ParserMessageEvent(this, "Generating critical pairs ...  Please wait."));
            return;
        }
        this.openP.setEnabled(false);
        this.startP.setEnabled(false);
        this.stopP.setEnabled(true);
        this.backP.setEnabled(true);
        this.parserDesktop.hostFrameSetAnimationIcon();
        this.fireParserEvent(new ParserMessageEvent(this, "Starting parser ..."));
        Thread t = new Thread((Runnable)((Object)this.excludeParser));
        t.setPriority(3);
        t.start();
    }

    public void stopParser() {
        if (this.tmpPairs != null) {
            ((ExcludePairContainer)this.tmpPairs).stop();
        }
        if (this.excludeParser instanceof ExcludeParser) {
            ((ExcludeParser)this.excludeParser).stop();
        } else if (this.excludeParser instanceof SimpleParser) {
            ((SimpleParser)this.excludeParser).stop();
        }
        this.startP.setEnabled(true);
        this.stopP.setEnabled(false);
    }

    public void backToGUI() {
        if (this.changer.isSet()) {
            int i;
            this.changer.restore();
            for (i = 0; i < this.listener.size(); ++i) {
                if (this.tmpPairs instanceof LayeredExcludePairContainer) {
                    ((LayeredExcludePairContainer)this.tmpPairs).stop();
                    ((LayeredExcludePairContainer)this.tmpPairs).removePairEventListener((ParserEventListener)this.listener.elementAt(i));
                    continue;
                }
                if (!(this.tmpPairs instanceof ExcludePairContainer)) continue;
                ((ExcludePairContainer)this.tmpPairs).stop();
                ((ExcludePairContainer)this.tmpPairs).removePairEventListener((ParserEventListener)this.listener.elementAt(i));
            }
            for (i = 0; i < this.listener.size(); ++i) {
                if (this.excludeParser instanceof ExcludeParser) {
                    ((ExcludeParser)this.excludeParser).stop();
                    ((ExcludeParser)this.excludeParser).removeParserEventListener((ParserEventListener)this.listener.elementAt(i));
                    continue;
                }
                if (!(this.excludeParser instanceof SimpleParser)) continue;
                ((SimpleParser)this.excludeParser).stop();
                ((SimpleParser)this.excludeParser).removeParserEventListener((ParserEventListener)this.listener.elementAt(i));
            }
            this.activeParser = false;
            this.openP.setEnabled(true);
            this.startP.setEnabled(false);
            this.stopP.setEnabled(false);
            this.backP.setEnabled(false);
            this.fireParserEvent(new ParserMessageEvent(this, "back to AGG editor"));
        }
    }

    private boolean checkIfReadyToTransform(EdGraGra gra) {
        Pair pair = gra.getBasisGraGra().isReadyToTransform();
        Object test = null;
        if (pair != null) {
            test = pair.first;
        }
        if (test != null) {
            JOptionPane.showMessageDialog(null, "Parsing failed!  \nGrammar  \"" + gra.getName() + "\"  is not OK.\n" + (String)pair.second, "Warning", 0);
            this.fireParserEvent(new ParserMessageEvent(this, "Thread - Parsing -  was stopped."));
            return false;
        }
        return true;
    }

    public void addStatusMessageListener(StatusMessageListener l) {
        if (!this.pmlistener.contains(l)) {
            this.pmlistener.add(0, l);
        }
        this.parserDesktop.addStatusMessageListener(l);
    }

    private void fireStatusMessageEvent(StatusMessageEvent e) {
        for (int i = 0; i < this.pmlistener.size(); ++i) {
            ((StatusMessageListener)this.pmlistener.elementAt(i)).newMessage(e);
        }
    }

    public void addParserEventListener(ParserEventListener l) {
        if (!this.listener.contains(l)) {
            this.listener.add(0, l);
        }
    }

    public void removeParserEventListener(ParserEventListener l) {
        if (this.listener.contains(l)) {
            this.listener.removeElement(l);
        }
    }

    private synchronized void fireParserEvent(ParserEvent e) {
        for (int i = 0; i < this.listener.size(); ++i) {
            ((ParserEventListener)this.listener.elementAt(i)).parserEventOccured(e);
        }
    }
}

