/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.gui.OptionGUI;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class AGGPreferences
implements EditEventListener {
    private Vector menus;
    private JMenu menu;
    private JMenu defaultsMenu;
    private OptionGUI optionGUI = new OptionGUI(null, " Options ", false);

    public AGGPreferences(JFrame f) {
        this.menus = new Vector(2);
        this.createPreferencesMenu();
    }

    public void editEventOccurred(EditEvent e) {
        if (e.getMsg() == -10 && e.getMessage().equals("Preferences")) {
            this.menu.doClick();
        }
    }

    public Enumeration getMenus() {
        return this.menus.elements();
    }

    public OptionGUI getOptionGUI() {
        return this.optionGUI;
    }

    protected JMenu createPreferencesMenu() {
        JMenu menu = new JMenu("Preferences", true);
        menu.setMnemonic('P');
        menu.setEnabled(true);
        JMenuItem options = new JMenuItem("Options...");
        menu.add(options);
        options.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                if (!AGGPreferences.this.optionGUI.isVisible()) {
                    AGGPreferences.this.optionGUI.setVisible(true);
                    AGGPreferences.this.optionGUI.toFront();
                } else {
                    AGGPreferences.this.optionGUI.setVisible(false);
                    AGGPreferences.this.optionGUI.setVisible(true);
                    AGGPreferences.this.optionGUI.toFront();
                }
            }
        });
        this.menus.addElement(menu);
        menu.add(this.createDefaultsMenu());
        return menu;
    }

    public void addActionListenerOfDefaults(ActionListener al) {
        for (int i = 0; i < this.defaultsMenu.getItemCount(); ++i) {
            JMenu m = (JMenu)this.defaultsMenu.getItem(i);
            for (int j = 0; j < m.getItemCount(); ++j) {
                JMenuItem mi = m.getItem(j);
                mi.addActionListener(al);
            }
        }
    }

    private JMenu createDefaultsMenu() {
        this.defaultsMenu = new JMenu("Defaults", true);
        this.defaultsMenu.setMnemonic('D');
        JMenu scale = new JMenu("Scale", true);
        String[] scaleLabels = new String[]{"0.5", "0.7", "1.0", "1.5", "2.0"};
        String[] scaleCommands = new String[]{"0.5", "0.7", "1.0", "1.5", "2.0"};
        for (int i = 0; i < scaleLabels.length; ++i) {
            JMenuItem mi = new JMenuItem(scaleLabels[i]);
            mi.setEnabled(true);
            mi.setActionCommand(scaleCommands[i]);
            scale.add(mi);
        }
        JMenu font = new JMenu("Font", true);
        String[] fontLabels = new String[]{"Bold", "Plain"};
        String[] fontCommands = new String[]{"bold", "plain"};
        for (int i = 0; i < fontLabels.length; ++i) {
            JMenuItem mi = new JMenuItem(fontLabels[i]);
            mi.setActionCommand(fontCommands[i]);
            font.add(mi);
        }
        this.defaultsMenu.add(font);
        JMenu size = new JMenu("Font Size", true);
        String[] sizeLabels = new String[]{"LARGE", "large", "small", "tiny"};
        String[] sizeCommands = new String[]{"LARGE", "large", "small", "tiny"};
        for (int i = 0; i < sizeLabels.length; ++i) {
            JMenuItem mi = new JMenuItem(sizeLabels[i]);
            mi.setActionCommand(sizeCommands[i]);
            size.add(mi);
        }
        this.defaultsMenu.add(size);
        return this.defaultsMenu;
    }
}

