/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdType;
import agg.editor.impl.EdTypeSet;
import agg.gui.ArcTypePopupMenu;
import agg.gui.TypeCardinalityGUI;
import agg.gui.TypePalette;
import agg.gui.event.TypeEvent;
import agg.gui.event.TypeEventListener;
import agg.gui.icons.ColorDashLineIcon;
import agg.gui.icons.ColorDotLineIcon;
import agg.gui.icons.ColorSolidLineIcon;
import agg.xt_basis.TypeException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class ArcTypeComboBox
extends JPanel
implements ActionListener {
    private JComboBox custom;
    private CustomComboBoxModel customModel;
    private Icon typeIcon;
    private JLabel typeIconLabel;
    private int selIndex;
    private EdGraGra eGra;
    private EdTypeSet typeSet;
    private String arcTypeName = "";
    private int arcTypeShape = 61;
    private Color arcTypeColor = Color.black;
    private ArcTypePopupMenu arcTypePopupMenu;
    private boolean redefineMode = false;
    private Vector typeEventListeners;
    private TypeCardinalityGUI multiplicity;

    public ArcTypeComboBox() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(150, 20));
        this.typeIconLabel = new JLabel(" ", null, 2);
        this.typeIconLabel.setToolTipText("Color/Shape Menu");
        this.add((Component)this.typeIconLabel, "West");
        this.customModel = new CustomComboBoxModel(this);
        this.custom = new JComboBox(this.customModel);
        this.customModel.setComboBox(this.custom);
        this.custom.setEditor(new CustomEditor());
        this.custom.setEnabled(false);
        this.custom.setEditable(false);
        this.custom.setRenderer(new MyCellRenderer(this.custom));
        this.add((Component)this.custom, "Center");
        this.arcTypePopupMenu = new ArcTypePopupMenu();
        this.arcTypePopupMenu.setTypeIconLabel(this.typeIconLabel);
        this.arcTypePopupMenu.setComboBox(this);
        this.typeIconLabel.setIcon(this.customModel.getArcTypeIcon(61, Color.black));
        this.typeIconLabel.setEnabled(false);
        this.selIndex = -1;
        this.typeIconLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getSource() instanceof JLabel && ArcTypeComboBox.this.arcTypePopupMenu.invoked(e.getX(), e.getY())) {
                    ArcTypeComboBox.this.arcTypePopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.getSource() instanceof JLabel && ArcTypeComboBox.this.arcTypePopupMenu.invoked(e.getX(), e.getY())) {
                    ArcTypeComboBox.this.arcTypePopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.custom.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ArcTypeComboBox.this.typeSet != null) {
                    String str = (String)ArcTypeComboBox.this.custom.getEditor().getItem();
                    String nameStr = str.replaceAll(" ", "");
                    ArcTypeComboBox.this.arcTypeName = nameStr;
                    ArcTypeComboBox.this.arcTypeShape = ArcTypeComboBox.this.arcTypePopupMenu.getSelectedShape();
                    ArcTypeComboBox.this.arcTypeColor = ArcTypeComboBox.this.arcTypePopupMenu.getSelectedColor();
                    ArcTypeComboBox.this.typeIcon = ArcTypeComboBox.this.customModel.getArcTypeIcon(ArcTypeComboBox.this.arcTypeShape, ArcTypeComboBox.this.arcTypeColor);
                    if (ArcTypeComboBox.this.redefineMode && ArcTypeComboBox.this.typeSet.getArcTypes().isEmpty()) {
                        ArcTypeComboBox.this.redefineMode = false;
                        ArcTypeComboBox.this.arcTypePopupMenu.setRedefine(false);
                    }
                    if (ArcTypeComboBox.this.redefineMode) {
                        int selIndx = ArcTypeComboBox.this.customModel.getSelectedIndex();
                        if (ArcTypeComboBox.this.redefineType(selIndx, ArcTypeComboBox.this.arcTypeName, ArcTypeComboBox.this.arcTypeShape, ArcTypeComboBox.this.arcTypeColor, "")) {
                            ArcTypeComboBox.this.customModel.reiconizeItemAt(selIndx, ArcTypeComboBox.this.typeIcon);
                            ArcTypeComboBox.this.customModel.renameItemAt(selIndx, ArcTypeComboBox.this.arcTypeName);
                            ArcTypeComboBox.this.customModel.setSelectedIndex(selIndx);
                            ArcTypeComboBox.this.fireTypeEvent(new TypeEvent(this, 3));
                            EdType et = (EdType)ArcTypeComboBox.this.typeSet.getArcTypes().elementAt(selIndx);
                            ArcTypeComboBox.this.fireTypeEvent(new TypeEvent(this, et, selIndx, 12));
                        }
                    } else {
                        EdType t = ArcTypeComboBox.this.typeSet.createArcType(ArcTypeComboBox.this.arcTypeName, ArcTypeComboBox.this.arcTypeShape, ArcTypeComboBox.this.arcTypeColor);
                        if (t != null) {
                            JLabel l = new JLabel(ArcTypeComboBox.this.arcTypeName, ArcTypeComboBox.this.typeIcon, 2);
                            ArcTypeComboBox.this.customModel.getTable().put(l, t);
                            ArcTypeComboBox.this.customModel.addItem(l);
                            ArcTypeComboBox.this.setTypeIcon(ArcTypeComboBox.this.typeIcon);
                            ArcTypeComboBox.this.customModel.setSelectedIndex(ArcTypeComboBox.this.selIndex);
                            ArcTypeComboBox.this.eGra.setChanged(true);
                            ArcTypeComboBox.this.fireTypeEvent(new TypeEvent(this, t, ArcTypeComboBox.this.selIndex, 13));
                        }
                    }
                }
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton && ((JButton)e.getSource()).getText().equals("Set") && this.multiplicity.isMultiplicitySet()) {
            this.fireTypeEvent(new TypeEvent(this, 3));
        }
    }

    public synchronized void addTypeEventListener(TypeEventListener l) {
        Vector v;
        Vector vector = v = this.typeEventListeners == null ? new Vector(2) : (Vector)this.typeEventListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.typeEventListeners = v;
        }
    }

    public synchronized void removeTypeEventListener(TypeEventListener l) {
        if (this.typeEventListeners != null && this.typeEventListeners.contains(l)) {
            Vector v = (Vector)this.typeEventListeners.clone();
            v.removeElement(l);
            this.typeEventListeners = v;
        }
    }

    private void fireTypeEvent(TypeEvent e) {
        if (this.typeEventListeners != null) {
            Vector listeners = this.typeEventListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((TypeEventListener)listeners.elementAt(i)).typeEventOccurred(e);
            }
        }
    }

    public void setEnabled(boolean enable) {
        this.custom.setEnabled(enable);
        this.custom.setEditable(enable);
        this.typeIconLabel.setEnabled(enable);
    }

    public JComboBox getCustom() {
        return this.custom;
    }

    public CustomComboBoxModel getCustomModel() {
        return this.customModel;
    }

    public void setTypeIcon(Icon icon) {
        this.typeIconLabel.setIcon(icon);
    }

    public void setTypePalette(TypePalette palette) {
        this.customModel.setTypePalette(palette);
    }

    public void setGraGra(EdGraGra egra) {
        this.eGra = egra;
        if (egra != null) {
            this.typeSet = egra.getTypeSet();
            this.setEnabled(true);
            this.arcTypePopupMenu.setRedefine(false);
        } else {
            this.typeSet = null;
            this.setEnabled(false);
        }
    }

    public void setTypeSet(EdTypeSet types) {
        this.typeSet = types;
    }

    public ArcTypePopupMenu getPopupMenu() {
        return this.arcTypePopupMenu;
    }

    public void setRedefineMode(boolean value) {
        this.redefineMode = value;
    }

    public void renameType(String newName) {
        int selIndx;
        if (this.typeSet != null && (selIndx = this.customModel.getSelectedIndex()) >= 0) {
            EdType et = (EdType)this.typeSet.getArcTypes().elementAt(selIndx);
            this.typeSet.renameType(et, newName);
            this.customModel.renameItemAt(selIndx, newName);
            this.eGra.setChanged(true);
        }
    }

    public boolean redefineType(int selIndx, String newName, int newShape, Color newColor, String newImageFileName) {
        EdType et;
        if (this.typeSet != null && selIndx >= 0 && this.typeSet.redefineType(et = (EdType)this.typeSet.getArcTypes().elementAt(selIndx), newName, newShape, newColor, "")) {
            this.eGra.setChanged(true);
            return true;
        }
        return false;
    }

    public void deleteType() {
        int selIndx;
        if (this.typeSet != null && (selIndx = this.customModel.getSelectedIndex()) >= 0) {
            EdType et = (EdType)this.typeSet.getArcTypes().elementAt(selIndx);
            int answer = 1;
            if (this.typeSet.isUsed(et)) {
                if (this.typeSet.getBasisTypeSet().getLevelOfTypeGraphCheck() != 0) {
                    JOptionPane.showMessageDialog(null, "Please disable the type graph before delete a type.", "Type graph enabled", 0);
                    return;
                }
                Object[] options = new Object[]{"Delete", "Cancel"};
                answer = JOptionPane.showOptionDialog(null, "Are you sure you want to delete this type?\nThere are objects of it.", "Warning", -1, 2, null, options, options[0]);
                if (answer == 0) {
                    this.typeSet.deleteGraphObjectsOfType(et.getBasisType(), true);
                    this.fireTypeEvent(new TypeEvent(this, 6));
                }
            }
            if (!this.typeSet.isUsed(et) || answer == 0) {
                try {
                    if (this.eGra.getStartGraph() != null) {
                        this.eGra.getStartGraph().deleteObjects(et);
                    }
                    this.eGra.destroyUndoGraph();
                    int index = selIndx;
                    this.typeSet.removeArcType(et);
                    this.eGra.setChanged(true);
                    this.fireTypeEvent(new TypeEvent(this, 6));
                    this.fireTypeEvent(new TypeEvent(this, et, index, 14));
                }
                catch (TypeException e) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Type Graph Error", 0);
                    return;
                }
                this.selIndex = this.customModel.removeItemAt(selIndx);
                if (this.selIndex == -1) {
                    this.arcTypeName = "";
                    this.arcTypePopupMenu.setSelectedShapeIndex(0);
                    this.arcTypePopupMenu.setSelectedColorIndex(0);
                    this.arcTypeShape = this.arcTypePopupMenu.getSelectedShape();
                    this.arcTypeColor = this.arcTypePopupMenu.getSelectedColor();
                    this.typeIcon = this.customModel.getArcTypeIcon(this.arcTypeShape, this.arcTypeColor);
                    this.setTypeIcon(this.typeIcon);
                } else {
                    this.arcTypeName = ((EdType)this.typeSet.getArcTypes().elementAt((int)this.selIndex)).name;
                    this.arcTypeShape = ((EdType)this.typeSet.getArcTypes().elementAt((int)this.selIndex)).shape;
                    this.arcTypeColor = ((EdType)this.typeSet.getArcTypes().elementAt((int)this.selIndex)).color;
                    this.typeIcon = this.customModel.getArcTypeIcon(this.arcTypeShape, this.arcTypeColor);
                    this.setTypeIcon(this.typeIcon);
                    this.arcTypePopupMenu.setSelectedShape(this.arcTypeShape);
                    this.arcTypePopupMenu.setSelectedColor(this.arcTypeColor);
                }
            }
        }
    }

    public Vector getArcTypes() {
        return this.customModel.getTypes();
    }

    class CustomEditor
    extends BasicComboBoxEditor {
        public void setItem(Object anObject) {
            if (anObject instanceof String) {
                super.setItem(anObject);
            } else if (anObject instanceof JLabel) {
                super.setItem(((JLabel)anObject).getText());
            }
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        JComboBox comboBox;

        public MyCellRenderer(JComboBox x) {
            this.comboBox = x;
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList listbox, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Vector types = null;
            ComboBoxModel model = this.comboBox.getModel();
            if (model instanceof CustomComboBoxModel) {
                types = ((CustomComboBoxModel)model).getTypes();
            }
            if (types == null) {
                return this;
            }
            if (value == null) {
                this.setIcon(null);
                this.setText("");
                ArcTypeComboBox.this.selIndex = -1;
                return this;
            }
            JLabel l = value instanceof JLabel ? (JLabel)value : (JLabel)types.elementAt(index);
            this.setForeground(Color.black);
            if (isSelected) {
                this.setBackground(Color.lightGray);
            } else {
                this.setBackground(Color.white);
            }
            this.setIcon(l.getIcon());
            this.setText(l.getText());
            this.setToolTipText(l.getText());
            this.setOpaque(true);
            ((CustomComboBoxModel)this.comboBox.getModel()).setCurrentValue(l);
            return this;
        }
    }

    class CustomComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private ArcTypeComboBox typeBox;
        private Object currentValue;
        private Object currentObj;
        private JComboBox comboBox;
        private Vector types;
        private Hashtable table;
        private TypePalette palette;

        public CustomComboBoxModel(ArcTypeComboBox myBox) {
            this.typeBox = myBox;
            this.types = new Vector();
            this.table = new Hashtable();
        }

        public void setComboBox(JComboBox comboBox) {
            this.comboBox = comboBox;
        }

        public void setTypePalette(TypePalette palette) {
            this.palette = palette;
        }

        public void setCurrentValue(JLabel l) {
            this.currentValue = l;
        }

        public void setSelectedIndex(int index) {
            if (index != -1) {
                ArcTypeComboBox.this.selIndex = index;
                this.comboBox.setSelectedIndex(index);
            }
        }

        public void setSelectedItem(Object anObject) {
            ArcTypeComboBox.this.selIndex = this.getSelectedIndex();
            if (ArcTypeComboBox.this.typeSet != null && ArcTypeComboBox.this.typeSet.getArcTypes().size() != 0 && ArcTypeComboBox.this.selIndex >= 0 && ArcTypeComboBox.this.selIndex < ArcTypeComboBox.this.typeSet.getArcTypes().size()) {
                if (anObject instanceof String) {
                    this.currentObj = (String)anObject;
                }
                if (anObject instanceof JLabel) {
                    this.currentValue = (JLabel)this.types.elementAt(ArcTypeComboBox.this.selIndex);
                    this.currentObj = ((JLabel)this.currentValue).getText();
                }
                if (this.currentValue != null) {
                    ArcTypeComboBox.this.typeSet.setSelectedArcType((EdType)this.table.get((JLabel)this.currentValue));
                } else {
                    ArcTypeComboBox.this.typeSet.setSelectedArcType((EdType)ArcTypeComboBox.this.typeSet.getArcTypes().elementAt(ArcTypeComboBox.this.selIndex));
                }
                EdType t = ArcTypeComboBox.this.typeSet.getSelectedArcType();
                ArcTypeComboBox.this.typeSet.setSelectedArcType(t);
                this.comboBox.getEditor().setItem(t.name);
                ArcTypeComboBox.this.typeIcon = this.getArcTypeIcon(t);
                this.typeBox.setTypeIcon(ArcTypeComboBox.this.typeIcon);
                this.typeBox.getPopupMenu().setSelectedShape(t.shape);
                this.typeBox.getPopupMenu().setSelectedColor(t.color);
                this.palette.setSelectedEdgeTypeIndex(ArcTypeComboBox.this.selIndex);
            }
        }

        public Vector getTypes() {
            return this.types;
        }

        public Hashtable getTable() {
            return this.table;
        }

        public int getSelectedIndex() {
            int i = this.comboBox.getSelectedIndex();
            if (i != -1) {
                ArcTypeComboBox.this.selIndex = i;
            }
            return ArcTypeComboBox.this.selIndex;
        }

        public Object getSelectedItem() {
            return this.currentValue;
        }

        public Object getElementAt(int index) {
            if (index >= 0 && index < this.types.size()) {
                JLabel l = (JLabel)this.types.elementAt(index);
                if (l != null) {
                    this.currentValue = l;
                    this.currentObj = l.getText();
                }
                return this.currentValue;
            }
            return new JLabel("");
        }

        public int getSize() {
            return this.types.size();
        }

        public Object addItem(JLabel l) {
            if (l != null) {
                ArcTypeComboBox.this.selIndex = this.addSorted(l);
                this.currentValue = l;
                this.currentObj = l.getText();
                if (this.palette != null) {
                    this.palette.addEdgeType(l, ArcTypeComboBox.this.selIndex);
                }
                this.fireContentsChanged(this, -1, -1);
            } else {
                this.currentValue = new JLabel("undefined");
                this.currentObj = new String("undefined");
            }
            return this.currentValue;
        }

        public Object addItem(EdType t, JLabel l, boolean sorted) {
            if (l != null) {
                if (!sorted) {
                    this.types.addElement(l);
                    this.table.put(l, t);
                    ArcTypeComboBox.this.selIndex = this.types.size() - 1;
                } else {
                    ArcTypeComboBox.this.selIndex = this.addSorted(l);
                    this.table.put(l, t);
                }
                this.currentValue = l;
                this.currentObj = l.getText();
                if (this.palette != null) {
                    this.palette.addEdgeType(l, ArcTypeComboBox.this.selIndex);
                }
                this.fireContentsChanged(this, -1, -1);
            } else {
                this.currentValue = new JLabel("undefined");
                this.currentObj = new String("undefined");
            }
            return this.currentValue;
        }

        public Object addItem(EdType t) {
            if (t != null) {
                JLabel l = new JLabel();
                l.setIcon(this.getArcTypeIcon(t));
                l.setText(t.name);
                this.table.put(l, t);
                JLabel ll = (JLabel)this.addItem(l);
                return ll;
            }
            return null;
        }

        private int addSorted(JLabel l) {
            int indx = -1;
            String name = l.getText();
            if (this.types.isEmpty()) {
                this.types.add(l);
            } else {
                for (int i = 0; i < this.types.size(); ++i) {
                    JLabel t = (JLabel)this.types.get(i);
                    String n = t.getText();
                    if (name.compareTo(n) > 0) continue;
                    this.types.add(i, l);
                    break;
                }
                if (this.types.indexOf(l) == -1) {
                    this.types.add(l);
                }
            }
            indx = this.types.indexOf(l);
            return indx;
        }

        public void renameItemAt(int index, String newName) {
            if (index >= 0 && index < this.types.size()) {
                JLabel l = (JLabel)this.types.elementAt(index);
                l.setText(newName);
                this.currentValue = l;
                this.currentObj = l.getText();
                this.setSelectedItem((String)this.currentObj);
                this.palette.changeEdgeType(l, index);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void reiconizeItemAt(int index, Icon newIcon) {
            if (index >= 0 && index < this.types.size()) {
                JLabel l = (JLabel)this.types.elementAt(index);
                l.setIcon(newIcon);
                this.currentValue = l;
                this.currentObj = l.getText();
                this.palette.changeEdgeType(l, index);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public int removeItemAt(int index) {
            if (index >= 0 && index < this.types.size()) {
                JLabel elem = (JLabel)this.types.get(index);
                this.types.removeElementAt(index);
                if (this.palette != null) {
                    this.palette.removeEdgeType(elem, index);
                }
                if (index == this.types.size()) {
                    --index;
                }
                if (index >= 0) {
                    this.setSelectedIndex(index);
                    JLabel l = (JLabel)this.types.elementAt(index);
                    this.currentValue = l;
                    this.currentObj = l.getText();
                    this.fireContentsChanged(this, -1, -1);
                    this.comboBox.getEditor().setItem((String)this.currentObj);
                } else {
                    this.comboBox.getEditor().setItem("");
                    ArcTypeComboBox.this.typeSet.setSelectedArcType(null);
                    this.currentValue = null;
                    this.currentObj = null;
                    index = -1;
                }
            }
            return index;
        }

        public void removeAllItems() {
            for (int i = this.types.size() - 1; i >= 0; --i) {
                this.types.removeElementAt(i);
            }
            this.currentValue = null;
            this.currentObj = null;
            ArcTypeComboBox.this.selIndex = -1;
            this.comboBox.getEditor().setItem("");
        }

        public boolean hasMoreElements() {
            return this.types.size() != 0;
        }

        public Icon getArcTypeIcon(EdType et) {
            Icon icon = null;
            switch (et.shape) {
                case 61: {
                    icon = new ColorSolidLineIcon(et.color);
                    break;
                }
                case 62: {
                    icon = new ColorDashLineIcon(et.color);
                    break;
                }
                case 63: {
                    icon = new ColorDotLineIcon(et.color);
                    break;
                }
            }
            return icon;
        }

        public Icon getArcTypeIcon(int shape, Color color) {
            Icon icon = null;
            switch (shape) {
                case 61: {
                    icon = new ColorSolidLineIcon(color);
                    break;
                }
                case 62: {
                    icon = new ColorDashLineIcon(color);
                    break;
                }
                case 63: {
                    icon = new ColorDotLineIcon(color);
                    break;
                }
            }
            return icon;
        }
    }
}

