/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.attribute.impl.AttrTupleManager;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNode;
import agg.gui.AGGAppl;
import agg.gui.CriticalPairAnalysisSeparated;
import agg.gui.GraGraTreeView;
import agg.gui.GraphicsExportJPEG;
import agg.gui.event.TreeViewEvent;
import agg.gui.event.TreeViewEventListener;
import agg.gui.parser.ConflictsDependenciesGraph;
import agg.gui.parser.CriticalPairAnalysisGUI;
import agg.gui.parser.CriticalPairOptionGUI;
import agg.gui.parser.CriticalPairPanel;
import agg.gui.parser.GUIExchange;
import agg.gui.parser.GraphDesktop;
import agg.gui.parser.LayerGUI;
import agg.gui.parser.PairIOGUI;
import agg.gui.parser.ParserGUIOption;
import agg.gui.parser.ParserOptionGUI;
import agg.gui.parser.event.OptionEvent;
import agg.gui.parser.event.OptionListener;
import agg.gui.parser.event.ParserGUIEvent;
import agg.gui.parser.event.ParserGUIListener;
import agg.gui.parser.event.StatusMessageEvent;
import agg.gui.parser.event.StatusMessageListener;
import agg.parser.ConflictsDependenciesContainer;
import agg.parser.CriticalPairOption;
import agg.parser.DependencyPairContainer;
import agg.parser.ExcludePairContainer;
import agg.parser.LayerFunction;
import agg.parser.LayerOption;
import agg.parser.LayeredDependencyPairContainer;
import agg.parser.LayeredExcludePairContainer;
import agg.parser.OptionEventListener;
import agg.parser.PairContainer;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import agg.parser.ParserFactory;
import agg.parser.ParserMessageEvent;
import agg.parser.ParserOption;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Rule;
import com.objectspace.jgl.Pair;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class CriticalPairAnalysis
implements TreeViewEventListener,
ParserEventListener,
OptionListener,
OptionEventListener,
ParserGUIListener,
ActionListener,
MenuListener,
StatusMessageListener {
    private static CriticalPairAnalysis cpa;
    private GUIExchange changer;
    private ParserGUIOption option;
    private ParserOptionGUI pOptionGUI;
    private ParserOption pOption;
    private LayerOption lOption;
    private CriticalPairOptionGUI cpOptionGUI;
    private CriticalPairOption cpOption;
    private CriticalPairAnalysisGUI pairsGUI;
    private PairContainer pairsContainer;
    private PairContainer pairsContainer2;
    private ConflictsDependenciesGraph conflictDependGraph;
    private EdGraph cpaGraph;
    private PairIOGUI pairsIOGUI;
    private JMenu pairsMenu;
    private JMenu startCP;
    private JMenu loadCP;
    private JMenu cpaGraphCP;
    private JMenu showCP;
    private JMenuItem resetCP;
    private JMenuItem unlockCP;
    private JMenuItem startCPconflicts;
    private JMenuItem startCPdependencies;
    private JMenuItem stopCP;
    private JMenuItem reduceCP;
    private JMenuItem consistCP;
    private JMenuItem debugCP;
    private JMenuItem emptyCP;
    private JMenuItem loadCPcpx;
    private JMenuItem loadCPdpx;
    private JMenuItem loadSeparateCPcpx;
    private JMenuItem loadSeparateCPdpx;
    private JMenuItem saveCP;
    private JMenuItem showConflictCP;
    private JMenuItem showDependencyCP;
    private JMenuItem cpaCombiGraphCP;
    private JMenuItem checkHostGraphCP;
    private JMenuItem backCP;
    private Vector listener;
    private Vector pmlistener;
    private AGGAppl parent;
    private EdGraGra pairsGraGra;
    private LayerFunction lf;
    private GraGraTreeView treeView;
    private EdGraGra selectedGraGra;
    private Vector menus;
    protected Hashtable gragraIsChanged = new Hashtable();
    protected boolean isWarned = false;
    protected boolean isLocked = true;
    private Hashtable separatedFrames = new Hashtable();
    private CriticalPairAnalysisSeparated hostGraphCPA;
    private JFrame hostGraphFrame;
    private Hashtable overlapGraphs;
    private Graph overlapGraph;
    private Vector hostGraphMappings;
    private JButton nextMatchAtHostGraphButton;
    private GraphDesktop graphDesktop;
    private int x = 100;
    private int y = 50;
    protected int mouseX = -1;
    protected int mouseY = -1;
    private WindowListener wl;
    protected JFrame lastActiveFrame;
    boolean pairsSaved = false;
    private GraphicsExportJPEG exportJPEG;

    public CriticalPairAnalysis(AGGAppl appl, GraGraTreeView graTreeView) {
        this.parent = appl;
        this.treeView = graTreeView;
        this.listener = new Vector();
        this.pmlistener = new Vector();
        this.cpOption = new CriticalPairOption();
        this.cpOption.addOptionListener(this);
        this.cpOptionGUI = new CriticalPairOptionGUI(this.cpOption, this.option, this.pOption);
        this.pairsGUI = new CriticalPairAnalysisGUI(this.option);
        this.pairsIOGUI = new PairIOGUI(this.parent);
        this.menus = new Vector(2);
        this.createAnalysisMenu();
        this.addCPAnalysisEventListener(this);
        this.pairsGUI.addStatusMessageListener(this);
        this.changer = new GUIExchange(this.parent);
        cpa = this;
        this.wl = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (e.getSource() instanceof JFrame) {
                    if ((JFrame)e.getSource() == CriticalPairAnalysis.this.hostGraphFrame) {
                        EdGraph hostg = CriticalPairAnalysis.this.treeView.getCurrentGraGra().getGraph();
                        Enumeration en = hostg.getBasisGraph().getElements();
                        while (en.hasMoreElements()) {
                            GraphObject o = (GraphObject)en.nextElement();
                            o.setCritical(false);
                            EdNode n = hostg.findNode(o);
                            if (n != null) {
                                n.createMorphismMark();
                                continue;
                            }
                            EdArc a = hostg.findArc(o);
                            if (a == null) continue;
                            a.createMorphismMark();
                        }
                        hostg.deselectAll();
                        hostg.update();
                        CriticalPairAnalysis.this.treeView.graphDidChange();
                        if (CriticalPairAnalysis.this.overlapGraphs != null) {
                            CriticalPairAnalysis.this.overlapGraphs.clear();
                            CriticalPairAnalysis.this.overlapGraphs = null;
                        }
                        if (CriticalPairAnalysis.this.hostGraphCPA.getPairContainer(0) != null) {
                            if (CriticalPairAnalysis.this.pairsGUI.getCriticalPairPanel(0) != null) {
                                CriticalPairAnalysis.this.pairsGUI.getCriticalPairPanel(0).refreshView();
                            }
                            CriticalPairAnalysis.this.hostGraphCPA.getPairContainer(0).enableUseHostGraph(false, null, null);
                        } else if (CriticalPairAnalysis.this.hostGraphCPA.getPairContainer(1) != null) {
                            if (CriticalPairAnalysis.this.pairsGUI.getCriticalPairPanel(1) != null) {
                                CriticalPairAnalysis.this.pairsGUI.getCriticalPairPanel(1).refreshView();
                            }
                            CriticalPairAnalysis.this.hostGraphCPA.getPairContainer(1).enableUseHostGraph(false, null, null);
                        }
                        CriticalPairAnalysis.this.pairsGraGra.setChanged(false);
                        CriticalPairAnalysis.this.resetRuleApplicable(CriticalPairAnalysis.this.pairsGraGra.getBasisGraGra());
                        if (CriticalPairAnalysis.this.selectedGraGra != null) {
                            CriticalPairAnalysis.this.selectedGraGra.setChanged(false);
                            CriticalPairAnalysis.this.resetRuleApplicable(CriticalPairAnalysis.this.selectedGraGra.getBasisGraGra());
                        }
                        CriticalPairAnalysis.this.treeView.getTree().treeDidChange();
                        CriticalPairAnalysis.this.pairsSaved = true;
                        CriticalPairAnalysis.this.separatedFrames.remove((JFrame)e.getSource());
                    } else {
                        CriticalPairAnalysis.this.separatedFrames.remove((JFrame)e.getSource());
                    }
                }
            }

            public void windowActivated(WindowEvent e) {
            }
        };
        this.parent.addWindowListener(this.wl);
    }

    protected Pair getConflictsContainer() {
        Pair result = null;
        ExcludePairContainer c = (ExcludePairContainer)this.pairsContainer;
        if (c != null) {
            if (c.getKindOfConflict() != 0) {
                c = null;
            } else {
                result = new Pair(c, this.parent);
            }
        }
        ExcludePairContainer cSeparated = null;
        Pair res = null;
        Enumeration e = this.separatedFrames.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            CriticalPairAnalysisSeparated sep = (CriticalPairAnalysisSeparated)this.separatedFrames.get(key);
            ExcludePairContainer cSep = sep.getPairContainer();
            if (cSep.getKindOfConflict() != 0) continue;
            cSeparated = cSep;
            res = new Pair(cSeparated, sep.getFrame());
        }
        if (c != null && cSeparated != null) {
            result = res;
        } else if (cSeparated != null) {
            result = res;
        }
        return result;
    }

    protected Pair getDependenciesContainer() {
        Pair result = null;
        ExcludePairContainer c = (ExcludePairContainer)this.pairsContainer;
        if (c != null) {
            if (c.getKindOfConflict() != 1) {
                c = null;
            } else {
                result = new Pair(c, this.parent);
            }
        }
        ExcludePairContainer cSeparated = null;
        Pair res = null;
        Enumeration e = this.separatedFrames.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            CriticalPairAnalysisSeparated sep = (CriticalPairAnalysisSeparated)this.separatedFrames.get(key);
            ExcludePairContainer cSep = sep.getPairContainer();
            if (cSep.getKindOfConflict() != 1) continue;
            cSeparated = cSep;
            res = new Pair(cSeparated, sep.getFrame());
        }
        if (c != null && cSeparated != null) {
            result = res;
        } else if (cSeparated != null) {
            result = res;
        }
        return result;
    }

    public Enumeration getMenus() {
        return this.menus.elements();
    }

    public CriticalPairAnalysisGUI getCriticalPairAnalysisGUI() {
        return this.pairsGUI;
    }

    public CriticalPairOption getCriticalPairOption() {
        return this.cpOption;
    }

    public CriticalPairOptionGUI getCriticalPairOptionGUI() {
        return this.cpOptionGUI;
    }

    public void setCriticalPairOption(CriticalPairOption cpOption) {
        this.cpOption = cpOption;
    }

    public void setCriticalPairOptionGUI(CriticalPairOptionGUI cpOptionGUI) {
        this.cpOptionGUI = cpOptionGUI;
    }

    public void setLayerOption(LayerOption lo) {
        this.lOption = lo;
    }

    public void setParserOption(ParserOption pOption) {
        this.pOption = pOption;
        this.cpOptionGUI.setParserOption(pOption);
        pOption.addOptionListener(this.cpOptionGUI);
    }

    public void setGUIOption(ParserGUIOption guiOption) {
        this.option = guiOption;
        this.cpOptionGUI.setGUIOption(guiOption);
        this.pairsGUI.setGUIOption(guiOption);
    }

    public void setGraGra(EdGraGra gra) {
        this.pairsGraGra = gra;
        this.pairsGUI.setGraGra(this.pairsGraGra);
        this.pairsContainer = null;
        this.pairsContainer2 = null;
        this.conflictDependGraph = null;
        this.cpaGraph = null;
        if (this.pairsGraGra != null) {
            this.resetCP.setEnabled(true);
            this.startCP.setEnabled(true);
            this.debugCP.setEnabled(true);
            if (this.pairsGraGra.getBasisGraGra().isLayered()) {
                this.cpOptionGUI.initLayers(this.pairsGraGra.getBasisGraGra().getLayers());
            }
            this.gragraIsChanged.put(this.pairsGraGra, new Boolean(this.pairsGraGra.isChanged()));
        } else {
            this.resetCP.setEnabled(false);
            this.unlockCP.setEnabled(false);
            this.startCP.setEnabled(false);
            this.stopCP.setEnabled(false);
            this.debugCP.setEnabled(false);
            this.emptyCP.setEnabled(false);
            this.loadCP.setEnabled(true);
            this.saveCP.setEnabled(false);
            this.backCP.setEnabled(false);
        }
    }

    public void setExportJPEG(GraphicsExportJPEG jpg) {
        this.exportJPEG = jpg;
        if (this.pairsGUI != null) {
            this.pairsGUI.getGraphDesktop().setExportJPEG(this.exportJPEG);
        }
    }

    public void treeViewEventOccurred(TreeViewEvent e) {
        int msgkey = e.getMsg();
        if (msgkey == 61 && e.getData().isGraGra) {
            this.selectedGraGra = e.getData().getGraGra();
            if (this.pairsGraGra == null) {
                this.setGraGra(this.selectedGraGra);
            } else if (this.pairsGUI.getGraphDesktop().hasEmptyComponents()) {
                this.setGraGra(this.selectedGraGra);
            } else if (this.pairsSaved && (!this.pairsGraGra.getBasisGraGra().compareTo(this.selectedGraGra.getBasisGraGra(), true) || this.layerUsed() != this.cpOption.layeredEnabled())) {
                this.setGraGra(this.selectedGraGra);
            }
        }
        if (msgkey == 7 && e.getData().isGraGra && this.pairsGraGra == e.getData().getGraGra()) {
            this.pairsGUI.reinitGraphDesktop();
            this.setGraGra(null);
            this.pairsSaved = true;
        }
    }

    public void parserEventOccured(ParserEvent e) {
        if (e.getMessage().indexOf("Critical") != -1 && e.getMessage().indexOf("finished") != -1) {
            this.pairsSaved = false;
            this.updateCPAgraph();
            this.startCP.setEnabled(true);
            this.stopCP.setEnabled(false);
            this.reduceCP.setEnabled(true);
            this.consistCP.setEnabled(true);
            this.loadCP.setEnabled(true);
            this.saveCP.setEnabled(true);
            this.showCP.setEnabled(true);
            this.checkHostGraphCP.setEnabled(true);
            if (!this.backCP.isEnabled()) {
                this.unlockCP.setEnabled(true);
                this.resetCP.setEnabled(true);
                this.debugCP.setEnabled(true);
                this.checkHostGraphCP.setEnabled(true);
            } else {
                this.emptyCP.setEnabled(true);
            }
            this.fireParserEvent(new ParserMessageEvent(this, " You can select a pair of rules to see results."));
        } else if (e.getMessage().indexOf("rule pair") != -1) {
            this.pairsSaved = false;
            if (!this.stopCP.isEnabled()) {
                if (e.getMessage().indexOf("done") == -1) {
                    this.startCP.setEnabled(false);
                    this.loadCP.setEnabled(false);
                    if (this.backCP.isEnabled()) {
                        this.reduceCP.setEnabled(false);
                        this.consistCP.setEnabled(false);
                        this.saveCP.setEnabled(false);
                        this.showCP.setEnabled(false);
                        this.checkHostGraphCP.setEnabled(false);
                    }
                } else if (e.getMessage().indexOf("done") != -1) {
                    this.startCP.setEnabled(true);
                    this.loadCP.setEnabled(true);
                    if (this.backCP.isEnabled()) {
                        this.reduceCP.setEnabled(true);
                        this.consistCP.setEnabled(true);
                        this.saveCP.setEnabled(true);
                        this.showCP.setEnabled(true);
                        this.checkHostGraphCP.setEnabled(true);
                    }
                }
            }
        } else if (e.getMessage().indexOf("Critical") != -1 && e.getMessage().indexOf("stopped") != -1) {
            this.pairsSaved = false;
            this.updateCPAgraph();
        }
    }

    public void optionEventOccurred(OptionEvent e) {
        JCheckBox cb;
        if (e.getSource() instanceof JCheckBox && (cb = (JCheckBox)e.getSource()).getText().equals("NACs")) {
            this.cpOption.enableNacs(cb.isSelected());
        }
    }

    public void optionEventOccurred(EventObject e) {
        if (e.getSource() instanceof CriticalPairOption) {
            if (this.pairsContainer != null) {
                ((ExcludePairContainer)this.pairsContainer).enableComplete(this.cpOption.completeEnabled());
                ((ExcludePairContainer)this.pairsContainer).enableReduce(this.cpOption.reduceEnabled());
                ((ExcludePairContainer)this.pairsContainer).enableNACs(this.cpOption.nacsEnabled());
                ((ExcludePairContainer)this.pairsContainer).enableConsistent(this.cpOption.consistentEnabled());
                if (this.pairsContainer instanceof LayeredExcludePairContainer) {
                    ((LayeredExcludePairContainer)this.pairsContainer).setLayer(this.cpOption.getLayer());
                }
            }
            if (this.pairsContainer2 != null) {
                ((ExcludePairContainer)this.pairsContainer2).enableComplete(this.cpOption.completeEnabled());
                ((ExcludePairContainer)this.pairsContainer2).enableReduce(this.cpOption.reduceEnabled());
                ((ExcludePairContainer)this.pairsContainer2).enableNACs(this.cpOption.nacsEnabled());
                ((ExcludePairContainer)this.pairsContainer2).enableConsistent(this.cpOption.consistentEnabled());
                if (this.pairsContainer2 instanceof LayeredDependencyPairContainer) {
                    ((LayeredDependencyPairContainer)this.pairsContainer2).setLayer(this.cpOption.getLayer());
                }
            }
        }
        Enumeration en = this.separatedFrames.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            CriticalPairAnalysisSeparated cpas = (CriticalPairAnalysisSeparated)this.separatedFrames.get(key);
            ExcludePairContainer excludePC = cpas.getPairContainer(0);
            ExcludePairContainer excludePC2 = cpas.getPairContainer(1);
            if (excludePC != null) {
                excludePC.enableComplete(this.cpOption.completeEnabled());
                excludePC.enableReduce(this.cpOption.reduceEnabled());
                excludePC.enableNACs(this.cpOption.nacsEnabled());
                excludePC.enableConsistent(this.cpOption.consistentEnabled());
                if (excludePC instanceof LayeredExcludePairContainer) {
                    // empty if block
                }
            }
            if (excludePC2 == null) continue;
            excludePC2.enableComplete(this.cpOption.completeEnabled());
            excludePC2.enableReduce(this.cpOption.reduceEnabled());
            excludePC2.enableNACs(this.cpOption.nacsEnabled());
            excludePC2.enableConsistent(this.cpOption.consistentEnabled());
            if (!(excludePC2 instanceof LayeredDependencyPairContainer)) continue;
        }
    }

    protected void createAnalysisMenu() {
        this.pairsMenu = new JMenu("Critical Pair Analysis");
        this.resetCP = new JMenuItem("Reset");
        this.resetCP.setEnabled(false);
        this.pairsMenu.add(this.resetCP);
        this.resetCPaddActionListener();
        this.unlockCP = new JMenuItem("Unlock");
        this.unlockCP.setEnabled(false);
        this.pairsMenu.add(this.unlockCP);
        this.unlockCPaddActionListener();
        this.startCP = new JMenu("Generate");
        this.startCPconflicts = new JMenuItem("Conflicts");
        this.startCPdependencies = new JMenuItem("Dependencies");
        this.startCP.add(this.startCPconflicts);
        this.startCP.add(this.startCPdependencies);
        this.startCP.setEnabled(false);
        this.pairsMenu.add(this.startCP);
        this.startCPaddActionListener();
        this.stopCP = new JMenuItem("Stop");
        this.stopCP.setEnabled(false);
        this.pairsMenu.add(this.stopCP);
        this.stopCPaddActionListener();
        this.reduceCP = new JMenuItem("Reduce");
        this.reduceCP.setEnabled(false);
        this.reduceCPaddActionListener();
        this.consistCP = new JMenuItem("Check Consistency");
        this.consistCP.setEnabled(false);
        this.pairsMenu.add(this.consistCP);
        this.consistCPaddActionListener();
        this.emptyCP = new JMenuItem("Empty");
        this.emptyCP.setEnabled(false);
        this.pairsMenu.add(this.emptyCP);
        this.emptyCPaddActionListener();
        this.debugCP = new JMenuItem("Debug");
        this.debugCP.setEnabled(false);
        this.pairsMenu.add(this.debugCP);
        this.debugCPaddActionListener();
        this.saveCP = new JMenuItem("Save");
        this.saveCP.setEnabled(false);
        this.pairsMenu.add(this.saveCP);
        this.saveCPaddActionListener();
        this.loadCP = new JMenu("Load");
        this.pairsMenu.add(this.loadCP);
        this.loadCPcpx = new JMenuItem("In This Window");
        this.loadSeparateCPcpx = new JMenuItem("In New Window");
        this.loadCP.add(this.loadCPcpx);
        this.loadCP.add(this.loadSeparateCPcpx);
        this.loadCPaddActionListener();
        this.showCP = new JMenu("Show");
        this.showConflictCP = this.showCP.add(new JMenuItem("Conflicts"));
        this.showDependencyCP = this.showCP.add(new JMenuItem("Dependencies"));
        this.cpaCombiGraphCP = this.showCP.add(new JMenuItem("CPA Graph"));
        this.pairsMenu.add(this.showCP);
        this.showCPaddActionListener();
        this.checkHostGraphCP = new JMenuItem("Check Host Graph");
        this.checkHostGraphCP.setEnabled(true);
        this.pairsMenu.add(this.checkHostGraphCP);
        this.checkHostGraphCPaddActionListener();
        this.backCP = new JMenuItem("back");
        this.backCP.setEnabled(false);
        this.pairsMenu.add(this.backCP);
        this.backCPaddActionListener();
        this.menus.addElement(this.pairsMenu);
    }

    public void menuSelected(MenuEvent e) {
    }

    public void menuDeselected(MenuEvent e) {
    }

    public void menuCanceled(MenuEvent e) {
    }

    private void resetCPaddActionListener() {
        this.resetCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysis.this.resetCPAGraGra(CriticalPairAnalysis.this.selectedGraGra);
            }
        });
    }

    private void resetCPAGraGra(EdGraGra selGraGra) {
        if (this.resetGraGra(this.selectedGraGra) && this.selectedGraGra.getBasisGraGra().isLayered()) {
            this.cpOptionGUI.initLayers(this.selectedGraGra.getBasisGraGra().getLayers());
        }
    }

    private boolean resetGraGra(EdGraGra selGraGra) {
        if (!this.backCP.isEnabled()) {
            if (selGraGra == null) {
                return false;
            }
            if (selGraGra.getBasisGraGra().getTypeSet().usesInheritance()) {
                this.inheritanceWarning();
                return false;
            }
            if (!this.areRulesInjective(this.pairsGraGra.getBasisGraGra())) {
                return false;
            }
            if (!this.checkIfReadyToTransform(selGraGra)) {
                return false;
            }
            if (this.pairsGUI.getGraGra() != null) {
                if (this.pairsGUI.isOnePairThreadAlive()) {
                    this.pairsGUI.stopOnePairThread();
                }
                if (!this.stopCP.isEnabled()) {
                    this.removeEventListenersFromPairContainer(this.pairsContainer);
                    this.removeEventListenersFromPairContainer(this.pairsContainer2);
                    this.pairsGUI.reinitGraphDesktop();
                    this.pairsContainer = null;
                    this.pairsContainer2 = null;
                    this.cpaGraph = null;
                    this.conflictDependGraph = null;
                    this.pairsGraGra = selGraGra;
                    this.gragraIsChanged.put(this.pairsGraGra, new Boolean(this.pairsGraGra.isChanged()));
                    this.pairsGUI.setGraGra(this.pairsGraGra);
                    this.pairsSaved = true;
                    this.isLocked = true;
                } else {
                    JOptionPane.showMessageDialog(null, "Critical pair computation is running!.\nPlease wait or stop the computation.", "Warning", 2);
                }
                this.startCP.setEnabled(true);
            }
        }
        return true;
    }

    private void unlockCPaddActionListener() {
        this.unlockCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!CriticalPairAnalysis.this.backCP.isEnabled()) {
                    Enumeration keys = CriticalPairAnalysis.this.gragraIsChanged.keys();
                    while (keys.hasMoreElements()) {
                        EdGraGra gra = (EdGraGra)keys.nextElement();
                        Boolean bool = (Boolean)CriticalPairAnalysis.this.gragraIsChanged.get(gra);
                        gra.setEditable(true);
                        gra.setChanged(bool);
                    }
                    CriticalPairAnalysis.this.gragraIsChanged.clear();
                    ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
                    if (CriticalPairAnalysis.this.selectedGraGra != null) {
                        CriticalPairAnalysis.this.selectedGraGra.updateRules();
                    }
                    CriticalPairAnalysis.this.isLocked = false;
                    CriticalPairAnalysis.this.fireParserEvent(new ParserMessageEvent(this, "Grammar isn't locked anymore."));
                }
            }
        });
    }

    private void startCPaddActionListener() {
        this.startCPconflicts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysis.this.generateConflicts();
            }
        });
        this.startCPdependencies.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysis.this.generateDependencies();
            }
        });
    }

    private boolean compareCurrentGraGraToSelectedGraGra() {
        if (this.selectedGraGra == null || this.pairsGraGra == null) {
            return true;
        }
        if (this.pairsGraGra == this.selectedGraGra) {
            return !this.cpOption.layeredEnabled() || this.cpOption.layeredEnabled() == this.layerUsed();
        }
        if (!this.pairsGraGra.getBasisGraGra().compareTo(this.selectedGraGra.getBasisGraGra(), true) && !this.pairsSaved) {
            return false;
        }
        if (this.cpOption.layeredEnabled() && !this.layerUsed() && !this.pairsSaved) {
            return false;
        }
        return this.cpOption.layeredEnabled() || !this.layerUsed() || this.pairsSaved;
    }

    private void generateConflicts() {
        if (!this.compareCurrentGraGraToSelectedGraGra()) {
            int answer = this.gragraWarning("");
            if (answer == 0) {
                this.saveCriticalPairs();
            } else if (answer == 2) {
                return;
            }
            if (!this.resetGraGra(this.selectedGraGra)) {
                JOptionPane.showMessageDialog(null, "Something gone wrong. Cannot set selected grammar", "Grammar failed.", 2);
                return;
            }
        } else if (!this.isLocked) {
            this.resetWarning();
        }
        if (this.pairsGraGra == null || this.pairsGraGra.getBasisGraGra() == null) {
            JOptionPane.showMessageDialog(null, "No graph grammar is available.", "Warning", 2);
            return;
        }
        if (this.pairsGraGra.getBasisGraGra().getTypeSet().usesInheritance()) {
            this.inheritanceWarning();
            return;
        }
        if (!this.areRulesInjective(this.pairsGraGra.getBasisGraGra())) {
            return;
        }
        if (!this.changer.isSet()) {
            if (this.checkIfReadyToTransform(this.pairsGraGra)) {
                this.cpOption.setCriticalPairAlgorithm(0);
                this.cpOptionGUI.update();
                this.pairsContainer = this.generateNew(this.pairsContainer);
                this.changer.changeWith(this.pairsGUI.getContainer());
            }
        } else {
            this.cpOption.setCriticalPairAlgorithm(0);
            this.cpOptionGUI.update();
            if (this.pairsContainer == null) {
                this.pairsContainer = this.generateNew(this.pairsContainer);
            } else {
                this.generate(this.pairsContainer);
            }
        }
    }

    private void generateDependencies() {
        if (!this.compareCurrentGraGraToSelectedGraGra()) {
            int answer = this.gragraWarning("");
            if (answer == 0) {
                this.saveCriticalPairs();
            } else if (answer == 2) {
                return;
            }
            if (!this.resetGraGra(this.selectedGraGra)) {
                JOptionPane.showMessageDialog(null, "Something gone wrong. Cannot set selected grammar.", "Grammar failed", 2);
                return;
            }
        } else if (!this.isLocked) {
            this.resetWarning();
        }
        if (this.pairsGraGra == null || this.pairsGraGra.getBasisGraGra() == null) {
            JOptionPane.showMessageDialog(null, "No graph grammar is available.", "Warning", 2);
            return;
        }
        if (this.pairsGraGra.getBasisGraGra().getTypeSet().usesInheritance()) {
            this.inheritanceWarning();
            return;
        }
        if (!this.areRulesInjective(this.pairsGraGra.getBasisGraGra())) {
            return;
        }
        if (!this.changer.isSet()) {
            if (this.checkIfReadyToTransform(this.pairsGraGra)) {
                this.cpOption.setCriticalPairAlgorithm(1);
                this.cpOptionGUI.update();
                this.pairsContainer2 = this.generateNew(this.pairsContainer2);
                this.changer.changeWith(this.pairsGUI.getContainer());
            }
        } else {
            this.cpOption.setCriticalPairAlgorithm(1);
            this.cpOptionGUI.update();
            if (this.pairsContainer2 == null) {
                this.pairsContainer2 = this.generateNew(this.pairsContainer2);
            } else {
                this.generate(this.pairsContainer2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private PairContainer generateNew(PairContainer pc) {
        if (pc != null) {
            this.changer.changeWith(this.pairsGUI.getContainer());
            this.generate(pc);
            return pc;
        }
        this.resetLayerFunction();
        pc = this.makeEmptyCriticalPairs(this.cpOption.getCriticalPairAlgorithm());
        if (pc == null) {
            JOptionPane.showMessageDialog(null, "Generating critical pairs is failed.", "Warning", 2);
            return null;
        }
        if (this.checkIfReadyToTransform(this.pairsGraGra)) {
            this.resetCP_GUI(this.pairsGraGra, pc, true);
            this.resetCP.setEnabled(false);
            this.unlockCP.setEnabled(false);
            this.debugCP.setEnabled(false);
            this.backCP.setEnabled(true);
            this.changer.changeWith(this.pairsGUI.getContainer());
            this.pairsGraGra.setEditable(false);
            this.isLocked = true;
            ParserFactory.generateCriticalPairs(pc);
            this.fireParserEvent(new ParserMessageEvent(this, "Generate critical pairs ...  Please wait ..."));
            this.startCP.setEnabled(false);
            this.stopCP.setEnabled(true);
            this.emptyCP.setEnabled(false);
            this.reduceCP.setEnabled(false);
            this.consistCP.setEnabled(false);
            this.loadCP.setEnabled(false);
            this.saveCP.setEnabled(false);
            this.showCP.setEnabled(false);
            this.checkHostGraphCP.setEnabled(false);
            return pc;
        }
        JOptionPane.showMessageDialog(null, "Generating critical pairs is failed.", "Warning", 2);
        this.backCP.setEnabled(true);
        return null;
    }

    private void generate(PairContainer pc) {
        if (pc != null && pc.isAlive()) {
            JOptionPane.showMessageDialog(null, "Generating is already running.", "Warning", 2);
            return;
        }
        this.fireParserEvent(new ParserMessageEvent(this, "Generating critical pairs ... "));
        if (((ExcludePairContainer)pc).isComputed()) {
            this.resetCP.setEnabled(false);
            this.unlockCP.setEnabled(false);
            this.startCP.setEnabled(true);
            this.stopCP.setEnabled(false);
            this.emptyCP.setEnabled(true);
            this.reduceCP.setEnabled(true);
            this.consistCP.setEnabled(true);
            this.loadCP.setEnabled(true);
            this.saveCP.setEnabled(true);
            this.showCP.setEnabled(true);
            this.checkHostGraphCP.setEnabled(true);
            this.backCP.setEnabled(true);
            this.fireParserEvent(new ParserMessageEvent(this, "Generate critical pairs ... Done"));
        } else if (this.pairsGUI.isOnePairThreadAlive()) {
            this.resetCP.setEnabled(false);
            this.unlockCP.setEnabled(false);
            this.startCP.setEnabled(false);
            this.stopCP.setEnabled(true);
            this.emptyCP.setEnabled(true);
            this.reduceCP.setEnabled(false);
            this.consistCP.setEnabled(false);
            this.loadCP.setEnabled(false);
            this.saveCP.setEnabled(false);
            this.showCP.setEnabled(false);
            this.checkHostGraphCP.setEnabled(false);
            this.backCP.setEnabled(true);
            this.fireParserEvent(new ParserMessageEvent(this, "Generating critical pairs of the selected rules is still running ..."));
        } else if (this.checkIfReadyToTransform(this.pairsGraGra)) {
            this.pairsGraGra.setEditable(false);
            this.isLocked = true;
            PairContainer pc_tmp = null;
            if (this.resetLayerFunction()) {
                pc_tmp = this.makeEmptyCriticalPairs(this.cpOption.getCriticalPairAlgorithm());
                if (pc_tmp == null) {
                    JOptionPane.showMessageDialog(null, "Generating critical pairs is failed.", "Warning", 2);
                    return;
                }
                if (pc_tmp.getKindOfConflict() == 0) {
                    this.pairsContainer = pc_tmp;
                } else if (pc_tmp.getKindOfConflict() == 1) {
                    this.pairsContainer2 = pc_tmp;
                }
            }
            if (pc_tmp != null) {
                this.resetCP_GUI(this.pairsGraGra, pc_tmp, false);
                ParserFactory.generateCriticalPairs(pc_tmp);
            } else {
                this.resetCP_GUI(this.pairsGraGra, pc, false);
                ParserFactory.generateCriticalPairs(pc);
            }
            this.resetCP.setEnabled(false);
            this.unlockCP.setEnabled(false);
            this.startCP.setEnabled(false);
            this.stopCP.setEnabled(true);
            this.emptyCP.setEnabled(false);
            this.reduceCP.setEnabled(false);
            this.consistCP.setEnabled(false);
            this.loadCP.setEnabled(false);
            this.saveCP.setEnabled(false);
            this.showCP.setEnabled(false);
            this.checkHostGraphCP.setEnabled(false);
            this.backCP.setEnabled(true);
            this.fireParserEvent(new ParserMessageEvent(this, "Generating critical pairs ... Please wait ..."));
        } else {
            JOptionPane.showMessageDialog(null, "Generating critical pairs is failed.", "Warning", 2);
            this.fireParserEvent(new ParserMessageEvent(this, "Generating critical pairs is failed. "));
            this.backCP.setEnabled(true);
            return;
        }
    }

    private void stopCPaddActionListener() {
        this.stopCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PairContainer pc = CriticalPairAnalysis.this.pairsGUI.getActivePairContainer();
                if (pc != null && pc.isAlive()) {
                    pc.stop();
                } else {
                    if (CriticalPairAnalysis.this.pairsContainer != null && CriticalPairAnalysis.this.pairsContainer.isAlive()) {
                        CriticalPairAnalysis.this.pairsContainer.stop();
                    }
                    if (CriticalPairAnalysis.this.pairsContainer2 != null && CriticalPairAnalysis.this.pairsContainer2.isAlive()) {
                        CriticalPairAnalysis.this.pairsContainer2.stop();
                    }
                }
                if (!CriticalPairAnalysis.this.backCP.isEnabled()) {
                    CriticalPairAnalysis.this.resetCP.setEnabled(true);
                    CriticalPairAnalysis.this.unlockCP.setEnabled(true);
                    CriticalPairAnalysis.this.startCP.setEnabled(true);
                    CriticalPairAnalysis.this.stopCP.setEnabled(false);
                    CriticalPairAnalysis.this.debugCP.setEnabled(true);
                    CriticalPairAnalysis.this.emptyCP.setEnabled(false);
                    CriticalPairAnalysis.this.reduceCP.setEnabled(false);
                    CriticalPairAnalysis.this.consistCP.setEnabled(false);
                    CriticalPairAnalysis.this.loadCP.setEnabled(true);
                    CriticalPairAnalysis.this.saveCP.setEnabled(false);
                    CriticalPairAnalysis.this.showCP.setEnabled(true);
                    CriticalPairAnalysis.this.checkHostGraphCP.setEnabled(true);
                } else {
                    CriticalPairAnalysis.this.startCP.setEnabled(true);
                    CriticalPairAnalysis.this.stopCP.setEnabled(false);
                    CriticalPairAnalysis.this.emptyCP.setEnabled(true);
                    CriticalPairAnalysis.this.reduceCP.setEnabled(true);
                    CriticalPairAnalysis.this.consistCP.setEnabled(true);
                    CriticalPairAnalysis.this.loadCP.setEnabled(true);
                    CriticalPairAnalysis.this.saveCP.setEnabled(true);
                    CriticalPairAnalysis.this.showCP.setEnabled(true);
                    CriticalPairAnalysis.this.checkHostGraphCP.setEnabled(true);
                }
            }
        });
    }

    private void reduceCPaddActionListener() {
        this.reduceCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CriticalPairAnalysis.this.changer.isSet()) {
                    PairContainer pc = CriticalPairAnalysis.this.pairsGUI.getActivePairContainer();
                    if (pc == null) {
                        if (CriticalPairAnalysis.this.pairsContainer != null && CriticalPairAnalysis.this.pairsContainer2 == null) {
                            pc = CriticalPairAnalysis.this.pairsContainer;
                        } else if (CriticalPairAnalysis.this.pairsContainer2 != null && CriticalPairAnalysis.this.pairsContainer == null) {
                            pc = CriticalPairAnalysis.this.pairsContainer2;
                        }
                    }
                    if (pc != null) {
                        if (!pc.isEmpty() && ((ExcludePairContainer)CriticalPairAnalysis.this.pairsContainer).reduceCriticalPairs()) {
                            CriticalPairAnalysis.this.pairsGUI.setCriticalPairs(CriticalPairAnalysis.this.pairsContainer);
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, "Cannot reduce. \nPlease select a pair table first.", "", 2);
                    }
                }
            }
        });
    }

    private void consistCPaddActionListener() {
        this.consistCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CriticalPairAnalysis.this.changer.isSet()) {
                    PairContainer pc = CriticalPairAnalysis.this.pairsGUI.getActivePairContainer();
                    if (pc == null) {
                        if (CriticalPairAnalysis.this.pairsContainer != null && CriticalPairAnalysis.this.pairsContainer2 == null) {
                            pc = CriticalPairAnalysis.this.pairsContainer;
                        } else if (CriticalPairAnalysis.this.pairsContainer2 != null && CriticalPairAnalysis.this.pairsContainer == null) {
                            pc = CriticalPairAnalysis.this.pairsContainer2;
                        }
                    }
                    if (pc == CriticalPairAnalysis.this.pairsContainer) {
                        if (!CriticalPairAnalysis.this.pairsContainer.isEmpty()) {
                            Thread t = new Thread(){

                                public void run() {
                                    ((ExcludePairContainer)CriticalPairAnalysis.this.pairsContainer).checkConsistency();
                                }
                            };
                            t.setPriority(4);
                            t.start();
                            while (t.isAlive()) {
                            }
                            CriticalPairAnalysis.this.pairsGUI.setCriticalPairs(CriticalPairAnalysis.this.pairsContainer);
                        }
                    } else if (pc == CriticalPairAnalysis.this.pairsContainer2) {
                        if (!CriticalPairAnalysis.this.pairsContainer2.isEmpty()) {
                            Thread t = new Thread(){

                                public void run() {
                                    ((ExcludePairContainer)CriticalPairAnalysis.this.pairsContainer2).checkConsistency();
                                }
                            };
                            t.setPriority(4);
                            t.start();
                            while (t.isAlive()) {
                            }
                            CriticalPairAnalysis.this.pairsGUI.setCriticalPairs(CriticalPairAnalysis.this.pairsContainer2);
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, "Cannot check. \nPlease select a pair table first.", "", 2);
                    }
                }
            }
        });
    }

    private void emptyCPaddActionListener() {
        this.emptyCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CriticalPairAnalysis.this.backCP.isEnabled()) {
                    PairContainer pc;
                    if (CriticalPairAnalysis.this.pairsGUI.isOnePairThreadAlive()) {
                        CriticalPairAnalysis.this.pairsGUI.stopOnePairThread();
                    }
                    if ((pc = CriticalPairAnalysis.this.pairsGUI.getActivePairContainer()) == null) {
                        if (CriticalPairAnalysis.this.pairsContainer != null && CriticalPairAnalysis.this.pairsContainer2 == null) {
                            pc = CriticalPairAnalysis.this.pairsContainer;
                        } else if (CriticalPairAnalysis.this.pairsContainer2 != null && CriticalPairAnalysis.this.pairsContainer == null) {
                            pc = CriticalPairAnalysis.this.pairsContainer2;
                        }
                    }
                    if (pc != null) {
                        int answer = 0;
                        if (pc.isComputed() || !pc.isEmpty()) {
                            answer = CriticalPairAnalysis.this.emptyWarning("Rule Conflicts");
                        }
                        if (answer == 0) {
                            pc.clear();
                            if (pc.getKindOfConflict() == 0) {
                                CriticalPairAnalysis.this.pairsGUI.getGraphDesktop().getConflictPairPanel().refreshView();
                            } else {
                                CriticalPairAnalysis.this.pairsGUI.getGraphDesktop().getDependPairPanel().refreshView();
                            }
                            CriticalPairAnalysis.this.pairsGUI.update();
                            CriticalPairAnalysis.this.fireParserEvent(new ParserMessageEvent(this, "Empty critical pairs generated. Choose a pair of rules to check it. "));
                            CriticalPairAnalysis.this.startCP.setEnabled(true);
                            CriticalPairAnalysis.this.loadCP.setEnabled(true);
                            CriticalPairAnalysis.this.saveCP.setEnabled(true);
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, "Cannot make empty. \nPlease select a pair table first.", "", 2);
                    }
                }
            }
        });
    }

    private void showPairContainer(int kindOfConflict) {
        if (kindOfConflict == 0) {
            if (this.pairsContainer == null) {
                this.pairsContainer = this.makeEmptyCriticalPairs(0);
                this.resetCP_GUI(this.pairsGraGra, this.pairsContainer, true);
                this.fireParserEvent(new ParserMessageEvent(this, "Empty critical pairs generated. Choose a pair of rules to check it. "));
            } else {
                this.pairsGUI.getGraphDesktop().addCriticalPairTable(this.pairsGUI.getGraphDesktop().getConflictPairPanel(), "");
            }
            this.startCP.setEnabled(true);
            this.loadCP.setEnabled(true);
            this.saveCP.setEnabled(true);
        } else if (kindOfConflict == 1) {
            if (this.pairsContainer2 == null) {
                this.pairsContainer2 = this.makeEmptyCriticalPairs(1);
                this.resetCP_GUI(this.pairsGraGra, this.pairsContainer2, true);
                this.fireParserEvent(new ParserMessageEvent(this, "Empty critical pairs generated. Choose a pair of rules to check it. "));
            } else {
                this.pairsGUI.getGraphDesktop().addCriticalPairTable(this.pairsGUI.getGraphDesktop().getDependPairPanel(), "");
            }
            this.startCP.setEnabled(true);
            this.loadCP.setEnabled(true);
            this.saveCP.setEnabled(true);
        }
    }

    private int emptyWarning(String obj) {
        Object[] options = new Object[]{"YES", "NO"};
        int answer = JOptionPane.showOptionDialog(null, "Are you sure, you want to delete already computed rule pairs?", "Delete   " + obj, -1, 2, null, options, options[1]);
        return answer;
    }

    private int gragraWarning(String obj) {
        Object[] options = new Object[]{"YES", "NO", "CANCEL"};
        String s = "";
        if (obj != null && !obj.equals("")) {
            s = "\n( " + obj + " )";
        }
        int answer = JOptionPane.showOptionDialog(null, "Currently selected grammar is different from the grammar of critical pairs." + s + "\nCritical pairs are not empty. You can lose results." + "\nDo you want to save the results first?", "Different grammar   ", -1, 2, null, options, options[0]);
        return answer;
    }

    private void saveCPaddActionListener() {
        this.saveCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CriticalPairAnalysis.this.pairsGUI.isGenerating()) {
                    CriticalPairAnalysis.this.fireParserEvent(new ParserMessageEvent(this, "Cannot save.  Computing is still running ..."));
                    return;
                }
                if (CriticalPairAnalysis.this.pairsGUI.isOnePairThreadAlive()) {
                    CriticalPairAnalysis.this.fireParserEvent(new ParserMessageEvent(this, "Cannot save.  Computing is still running ..."));
                    return;
                }
                if (CriticalPairAnalysis.this.changer.isSet()) {
                    CriticalPairAnalysis.this.saveCriticalPairs();
                }
            }
        });
    }

    private void saveCriticalPairs() {
        ConflictsDependenciesContainer cdPC = new ConflictsDependenciesContainer(this.pairsContainer, this.pairsContainer2, this.cpaGraph);
        this.pairsIOGUI.setCriticalPairContainer(cdPC);
        this.pairsIOGUI.save();
        if (this.pairsIOGUI.fileIsSaved()) {
            this.treeView.setFileDirectory(this.pairsIOGUI.getDirectoryName());
            this.fireParserEvent(new ParserMessageEvent(this, "Critical pairs are saved."));
            this.pairsSaved = true;
        }
        this.pairsSaved = true;
    }

    private void debugCPaddActionListener() {
        this.debugCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CriticalPairAnalysis.this.pairsGraGra == null || CriticalPairAnalysis.this.pairsGraGra.getBasisGraGra() == null) {
                    JOptionPane.showMessageDialog(null, "No graph grammar is available.", "Warning", 2);
                    return;
                }
                if (CriticalPairAnalysis.this.pairsGraGra.getBasisGraGra().getTypeSet().usesInheritance()) {
                    CriticalPairAnalysis.this.inheritanceWarning();
                    return;
                }
                if (!CriticalPairAnalysis.this.areRulesInjective(CriticalPairAnalysis.this.pairsGraGra.getBasisGraGra())) {
                    return;
                }
                if (!CriticalPairAnalysis.this.changer.isSet()) {
                    if (!CriticalPairAnalysis.this.compareCurrentGraGraToSelectedGraGra()) {
                        int answer = CriticalPairAnalysis.this.gragraWarning("");
                        if (answer == 0) {
                            CriticalPairAnalysis.this.saveCriticalPairs();
                        } else if (answer == 2) {
                            return;
                        }
                        CriticalPairAnalysis.this.setGraGra(CriticalPairAnalysis.this.selectedGraGra);
                        if (!CriticalPairAnalysis.this.resetGraGra(CriticalPairAnalysis.this.selectedGraGra)) {
                            JOptionPane.showMessageDialog(null, "Something gone wrong. Cannot set selected grammar", "Grammar failed.", 2);
                            return;
                        }
                    } else if (!CriticalPairAnalysis.this.isLocked) {
                        CriticalPairAnalysis.this.resetWarning();
                    }
                    if (!CriticalPairAnalysis.this.checkIfReadyToTransform(CriticalPairAnalysis.this.pairsGraGra)) {
                        return;
                    }
                    CriticalPairAnalysis.this.pairsGraGra.setEditable(false);
                    CriticalPairAnalysis.this.isLocked = true;
                    CriticalPairAnalysis.this.changer.changeWith(CriticalPairAnalysis.this.pairsGUI.getContainer());
                    CriticalPairAnalysis.this.resetCP.setEnabled(false);
                    CriticalPairAnalysis.this.unlockCP.setEnabled(false);
                    CriticalPairAnalysis.this.debugCP.setEnabled(false);
                    CriticalPairAnalysis.this.emptyCP.setEnabled(true);
                    CriticalPairAnalysis.this.reduceCP.setEnabled(true);
                    CriticalPairAnalysis.this.consistCP.setEnabled(true);
                    CriticalPairAnalysis.this.saveCP.setEnabled(true);
                    CriticalPairAnalysis.this.showCP.setEnabled(true);
                    CriticalPairAnalysis.this.checkHostGraphCP.setEnabled(true);
                    CriticalPairAnalysis.this.backCP.setEnabled(true);
                    if (CriticalPairAnalysis.this.pairsContainer == null && CriticalPairAnalysis.this.cpOption.getCriticalPairAlgorithm() == 0) {
                        CriticalPairAnalysis.this.resetLayerFunction();
                        CriticalPairAnalysis.this.pairsContainer = CriticalPairAnalysis.this.makeEmptyCriticalPairs(CriticalPairAnalysis.this.cpOption.getCriticalPairAlgorithm());
                        if (CriticalPairAnalysis.this.pairsContainer == null) {
                            JOptionPane.showMessageDialog(null, "Creating empty critical pairs is failed.", "Warning", 2);
                            return;
                        }
                        CriticalPairAnalysis.this.resetCP_GUI(CriticalPairAnalysis.this.pairsGraGra, CriticalPairAnalysis.this.pairsContainer, true);
                        CriticalPairAnalysis.this.fireParserEvent(new ParserMessageEvent(this, "Choose a pair of rules to check it."));
                    } else if (CriticalPairAnalysis.this.pairsContainer2 == null && CriticalPairAnalysis.this.cpOption.getCriticalPairAlgorithm() == 1) {
                        CriticalPairAnalysis.this.resetLayerFunction();
                        CriticalPairAnalysis.this.pairsContainer2 = CriticalPairAnalysis.this.makeEmptyCriticalPairs(CriticalPairAnalysis.this.cpOption.getCriticalPairAlgorithm());
                        if (CriticalPairAnalysis.this.pairsContainer2 == null) {
                            JOptionPane.showMessageDialog(null, "Creating empty critical pairs is failed.", "Warning", 2);
                            return;
                        }
                        CriticalPairAnalysis.this.resetCP_GUI(CriticalPairAnalysis.this.pairsGraGra, CriticalPairAnalysis.this.pairsContainer2, true);
                        CriticalPairAnalysis.this.fireParserEvent(new ParserMessageEvent(this, "Choose a pair of rules to check it."));
                    } else if (CriticalPairAnalysis.this.pairsGUI.pairsComputed()) {
                        CriticalPairAnalysis.this.saveCP.setEnabled(true);
                        CriticalPairAnalysis.this.fireParserEvent(new ParserMessageEvent(this, "Generating critical pairs ... Done"));
                    } else if (CriticalPairAnalysis.this.pairsGUI.isOnePairThreadAlive()) {
                        CriticalPairAnalysis.this.pairsGUI.getCriticalPairPanel().refreshView();
                        CriticalPairAnalysis.this.pairsGUI.getCriticalPairPanel2().refreshView();
                        CriticalPairAnalysis.this.stopCP.setEnabled(true);
                        CriticalPairAnalysis.this.startCP.setEnabled(false);
                        CriticalPairAnalysis.this.emptyCP.setEnabled(true);
                        CriticalPairAnalysis.this.reduceCP.setEnabled(false);
                        CriticalPairAnalysis.this.consistCP.setEnabled(false);
                        CriticalPairAnalysis.this.loadCP.setEnabled(false);
                        CriticalPairAnalysis.this.saveCP.setEnabled(false);
                        CriticalPairAnalysis.this.showCP.setEnabled(false);
                        CriticalPairAnalysis.this.checkHostGraphCP.setEnabled(false);
                        CriticalPairAnalysis.this.fireParserEvent(new ParserMessageEvent(this, "Generating critical pairs of the selected rule pair is still running ..."));
                    } else if (CriticalPairAnalysis.this.stopCP.isEnabled()) {
                        CriticalPairAnalysis.this.emptyCP.setEnabled(false);
                        CriticalPairAnalysis.this.reduceCP.setEnabled(false);
                        CriticalPairAnalysis.this.consistCP.setEnabled(false);
                        CriticalPairAnalysis.this.loadCP.setEnabled(false);
                        CriticalPairAnalysis.this.saveCP.setEnabled(false);
                        CriticalPairAnalysis.this.showCP.setEnabled(false);
                        CriticalPairAnalysis.this.checkHostGraphCP.setEnabled(false);
                        CriticalPairAnalysis.this.fireParserEvent(new ParserMessageEvent(this, "Generating critical pairs ... Continuing ..."));
                    } else {
                        CriticalPairAnalysis.this.fireParserEvent(new ParserMessageEvent(this, "Please choose a pair of rules to check it. "));
                        CriticalPairAnalysis.this.startCP.setEnabled(true);
                        CriticalPairAnalysis.this.emptyCP.setEnabled(true);
                        CriticalPairAnalysis.this.reduceCP.setEnabled(true);
                        CriticalPairAnalysis.this.consistCP.setEnabled(true);
                        CriticalPairAnalysis.this.loadCP.setEnabled(true);
                        CriticalPairAnalysis.this.saveCP.setEnabled(true);
                        CriticalPairAnalysis.this.showCP.setEnabled(true);
                        CriticalPairAnalysis.this.checkHostGraphCP.setEnabled(true);
                    }
                }
            }
        });
    }

    private void loadCPaddActionListener() {
        this.loadCPcpx.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysis.this.loadPairContainer(".cpx");
            }
        });
        this.loadSeparateCPcpx.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysis.this.loadPairContainerSeparated(".cpx");
            }
        });
    }

    private void checkHostGraphCPaddActionListener() {
        this.checkHostGraphCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CriticalPairAnalysis.this.treeView.getCurrentGraGra() != null) {
                    if (CriticalPairAnalysis.this.pairsGUI.isOnePairThreadAlive()) {
                        return;
                    }
                    if (CriticalPairAnalysis.this.pairsGUI.isGenerating()) {
                        return;
                    }
                    if (CriticalPairAnalysis.this.treeView.getCurrentGraGra().getBasisGraGra().getTypeSet().usesInheritance()) {
                        CriticalPairAnalysis.this.inheritanceWarning();
                        return;
                    }
                    int kind = 0;
                    if (CriticalPairAnalysis.this.pairsContainer == null && CriticalPairAnalysis.this.pairsContainer2 == null) {
                        CriticalPairAnalysis.this.hostGraphCPA = new CriticalPairAnalysisSeparated((JFrame)CriticalPairAnalysis.this.parent, CriticalPairAnalysis.this.pairsIOGUI, CriticalPairAnalysis.this.cpOptionGUI, CriticalPairAnalysis.this.cpOption, CriticalPairAnalysis.this.lOption, CriticalPairAnalysis.this.pOption, CriticalPairAnalysis.this.option);
                    } else if (CriticalPairAnalysis.this.pairsContainer != null && CriticalPairAnalysis.this.pairsContainer2 != null) {
                        if (CriticalPairAnalysis.this.pairsGUI.getActivePairContainer() != null) {
                            kind = CriticalPairAnalysis.this.pairsGUI.getActivePairContainer().getKindOfConflict();
                        }
                        if (kind == 0) {
                            CriticalPairAnalysis.this.hostGraphCPA = new CriticalPairAnalysisSeparated((JFrame)CriticalPairAnalysis.this.parent, (ExcludePairContainer)CriticalPairAnalysis.this.pairsContainer, null, CriticalPairAnalysis.this.cpOption, CriticalPairAnalysis.this.lOption, CriticalPairAnalysis.this.pOption, CriticalPairAnalysis.this.option);
                        } else if (kind == 1) {
                            CriticalPairAnalysis.this.hostGraphCPA = new CriticalPairAnalysisSeparated((JFrame)CriticalPairAnalysis.this.parent, null, (ExcludePairContainer)CriticalPairAnalysis.this.pairsContainer2, CriticalPairAnalysis.this.cpOption, CriticalPairAnalysis.this.lOption, CriticalPairAnalysis.this.pOption, CriticalPairAnalysis.this.option);
                        }
                    } else if (CriticalPairAnalysis.this.pairsContainer != null && !CriticalPairAnalysis.this.pairsContainer.isEmpty()) {
                        CriticalPairAnalysis.this.hostGraphCPA = new CriticalPairAnalysisSeparated((JFrame)CriticalPairAnalysis.this.parent, (ExcludePairContainer)CriticalPairAnalysis.this.pairsContainer, null, CriticalPairAnalysis.this.cpOption, CriticalPairAnalysis.this.lOption, CriticalPairAnalysis.this.pOption, CriticalPairAnalysis.this.option);
                    } else if (CriticalPairAnalysis.this.pairsContainer2 != null && !CriticalPairAnalysis.this.pairsContainer2.isEmpty()) {
                        kind = 1;
                        CriticalPairAnalysis.this.hostGraphCPA = new CriticalPairAnalysisSeparated((JFrame)CriticalPairAnalysis.this.parent, null, (ExcludePairContainer)CriticalPairAnalysis.this.pairsContainer2, CriticalPairAnalysis.this.cpOption, CriticalPairAnalysis.this.lOption, CriticalPairAnalysis.this.pOption, CriticalPairAnalysis.this.option);
                    } else {
                        JOptionPane.showMessageDialog(null, "Sorry. There is nothing to check.", "Warning", 2);
                        return;
                    }
                    if (CriticalPairAnalysis.this.hostGraphCPA != null) {
                        if (CriticalPairAnalysis.this.changer.isSet()) {
                            CriticalPairAnalysis.this.backToMainGUI(true);
                        }
                        CriticalPairAnalysis.this.hostGraphFrame = CriticalPairAnalysis.this.hostGraphCPA.getFrame();
                        CriticalPairAnalysis.this.separatedFrames.put(CriticalPairAnalysis.this.hostGraphFrame, CriticalPairAnalysis.this.hostGraphCPA);
                        CriticalPairAnalysis.this.hostGraphFrame.addWindowListener(CriticalPairAnalysis.this.wl);
                        CriticalPairAnalysis.this.x = CriticalPairAnalysis.this.x + 100;
                        CriticalPairAnalysis.this.y = 50;
                        CriticalPairAnalysis.this.hostGraphCPA.setLocation(CriticalPairAnalysis.this.x, CriticalPairAnalysis.this.y);
                        CriticalPairAnalysis.this.fireParserEvent(new ParserMessageEvent(this, "Critical pairs are loaded. Checking the host graph. Please wait ..."));
                        if (CriticalPairAnalysis.this.hostGraphCPA.getCriticalPairAnalysisGUI().getCriticalPairPanel(kind) != null) {
                            CriticalPairAnalysis.this.hostGraphCPA.getCriticalPairAnalysisGUI().getGraphDesktop().addParserGUIListener(cpa);
                            CriticalPairAnalysis.this.hostGraphCPA.getCriticalPairAnalysisGUI().getCriticalPairPanel(kind).addParserGUIListener(cpa);
                            ExcludePairContainer epc = CriticalPairAnalysis.this.hostGraphCPA.getPairContainer(kind);
                            if (epc != null) {
                                if (CriticalPairAnalysis.this.treeView.getCurrentGraGra().getBasisGraGra().getTypeSet().contains(epc.getGrammar().getTypeSet())) {
                                    epc.enableUseHostGraph(true, CriticalPairAnalysis.this.treeView.getCurrentGraGra().getBasisGraGra().getGraph(), CriticalPairAnalysis.this.treeView.getCurrentGraGra().getBasisGraGra().getMorphismCompletionStrategy());
                                    if (CriticalPairAnalysis.this.treeView.getCurrentGraGra().getBasisGraGra().isGraphReadyForTransform()) {
                                        ParserFactory.generateCriticalPairs(epc);
                                        while (epc.isAlive()) {
                                        }
                                        CriticalPairAnalysis.this.fireParserEvent(new ParserMessageEvent(this, " "));
                                        CriticalPairAnalysis.this.startCP.setEnabled(true);
                                        CriticalPairAnalysis.this.stopCP.setEnabled(false);
                                        CriticalPairAnalysis.this.emptyCP.setEnabled(true);
                                        CriticalPairAnalysis.this.reduceCP.setEnabled(true);
                                        CriticalPairAnalysis.this.consistCP.setEnabled(true);
                                        CriticalPairAnalysis.this.loadCP.setEnabled(true);
                                        CriticalPairAnalysis.this.saveCP.setEnabled(true);
                                        CriticalPairAnalysis.this.showCP.setEnabled(true);
                                        CriticalPairAnalysis.this.checkHostGraphCP.setEnabled(true);
                                        CriticalPairAnalysis.this.hostGraphCPA.getCriticalPairAnalysisGUI().getGraphDesktop().setIconOfCPAGraph(true);
                                        CriticalPairAnalysis.this.hostGraphCPA.getCriticalPairAnalysisGUI().getGraphDesktop().setIconOfPairTable(CriticalPairAnalysis.this.hostGraphCPA.getCriticalPairAnalysisGUI().getCriticalPairPanel2(), true);
                                        CriticalPairAnalysis.this.hostGraphCPA.showFrame();
                                    } else {
                                        CriticalPairAnalysis.this.separatedFrames.remove(CriticalPairAnalysis.this.hostGraphFrame);
                                        CriticalPairAnalysis.this.hostGraphFrame.dispose();
                                        JOptionPane.showMessageDialog(null, " There isn't possible to check the host graph.\nMaybe not all attributes of the host graph are set.", "Warning", 2);
                                    }
                                } else {
                                    CriticalPairAnalysis.this.separatedFrames.remove(CriticalPairAnalysis.this.hostGraphFrame);
                                    CriticalPairAnalysis.this.hostGraphFrame.dispose();
                                    JOptionPane.showMessageDialog(null, "There isn't possible to check the host graph.\nMismatch between types of the host graph and a CPA-grammar.", "Warning", 2);
                                }
                            }
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "There isn't any graph to check.", "Warning", 2);
                }
            }
        });
    }

    private void showCPaddActionListener() {
        this.showConflictCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysis.this.showPairContainer(0);
            }
        });
        this.showDependencyCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysis.this.showPairContainer(1);
            }
        });
        this.showCPAGraphCPaddActionListener();
    }

    private void showCPAGraphCPaddActionListener() {
        this.cpaCombiGraphCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysis.this.showCPAGraph();
            }
        });
    }

    private void showCPAGraph() {
        if (this.pairsContainer != null || this.pairsContainer2 != null) {
            if (this.cpaGraph != null) {
                if (this.conflictDependGraph != null) {
                    if (this.pairsContainer != null) {
                        this.pairsGUI.getGraphDesktop().getConflictPairPanel().removeParserGUIListener(this.conflictDependGraph);
                    }
                    if (this.pairsContainer2 != null) {
                        this.pairsGUI.getGraphDesktop().getDependPairPanel().removeParserGUIListener(this.conflictDependGraph);
                    }
                    this.pairsGUI.getGraphDesktop().removeActionListenerToCPAGraphMenu(this.conflictDependGraph);
                }
                this.conflictDependGraph = new ConflictsDependenciesGraph((ExcludePairContainer)this.pairsContainer, (ExcludePairContainer)this.pairsContainer2, this.cpaGraph, false);
                if (this.pairsContainer != null) {
                    this.pairsGUI.getGraphDesktop().getConflictPairPanel().addParserGUIListener(this.conflictDependGraph);
                }
                if (this.pairsContainer2 != null) {
                    this.pairsGUI.getGraphDesktop().getDependPairPanel().addParserGUIListener(this.conflictDependGraph);
                }
                this.pairsGUI.getGraphDesktop().addActionListenerToCPAGraphMenu(this.conflictDependGraph);
                this.conflictDependGraph.setGraphDesktop(this.pairsGUI.getGraphDesktop());
                this.pairsGUI.getGraphDesktop().removeCPAGraphFrame();
                this.pairsGUI.getGraphDesktop().getDesktop().repaint();
                try {
                    this.pairsGUI.getGraphDesktop().addGraph(this.cpaGraph, 400, 300).setIcon(false);
                }
                catch (PropertyVetoException pve) {}
            } else {
                this.conflictDependGraph = new ConflictsDependenciesGraph((ExcludePairContainer)this.pairsContainer, (ExcludePairContainer)this.pairsContainer2);
                this.cpaGraph = this.conflictDependGraph.getConflictsDependenciesGraph();
                if (this.cpaGraph == null) {
                    this.cpaGraph = this.conflictDependGraph.getConflictsGraph();
                }
                if (this.cpaGraph == null) {
                    this.cpaGraph = this.conflictDependGraph.getDependenciesGraph();
                }
                if (this.cpaGraph != null) {
                    if (this.pairsContainer != null) {
                        this.pairsGUI.getGraphDesktop().getConflictPairPanel().addParserGUIListener(this.conflictDependGraph);
                    }
                    if (this.pairsContainer2 != null) {
                        this.pairsGUI.getGraphDesktop().getDependPairPanel().addParserGUIListener(this.conflictDependGraph);
                    }
                    this.pairsGUI.getGraphDesktop().addActionListenerToCPAGraphMenu(this.conflictDependGraph);
                    this.conflictDependGraph.setGraphDesktop(this.pairsGUI.getGraphDesktop());
                    this.pairsGUI.getGraphDesktop().getDesktop().repaint();
                    try {
                        this.pairsGUI.getGraphDesktop().addGraph(this.cpaGraph, 400, 300).setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    JOptionPane.showMessageDialog(null, "There is nothing to show.", "Warning", 2);
                }
            }
        } else {
            this.loadPairContainerSeparated(".cpx");
        }
    }

    private void backCPaddActionListener() {
        this.backCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
                if (CriticalPairAnalysis.this.changer.isSet()) {
                    CriticalPairAnalysis.this.backToMainGUI(false);
                }
            }
        });
    }

    private void backToMainGUI(boolean warning) {
        Object[] options;
        int answer;
        if (warning && (answer = JOptionPane.showOptionDialog(null, "Do you want to change to graph editor to observe the host graph?", "", -1, 2, null, options = new Object[]{"YES", "NO"}, options[1])) != 0) {
            return;
        }
        this.changer.restore();
        if (!this.stopCP.isEnabled()) {
            this.resetCP.setEnabled(true);
            this.unlockCP.setEnabled(true);
            this.debugCP.setEnabled(true);
            this.emptyCP.setEnabled(false);
        } else {
            this.resetCP.setEnabled(false);
            this.unlockCP.setEnabled(false);
            this.debugCP.setEnabled(true);
            this.emptyCP.setEnabled(false);
            this.loadCP.setEnabled(false);
        }
        this.reduceCP.setEnabled(false);
        this.consistCP.setEnabled(false);
        this.saveCP.setEnabled(false);
        this.backCP.setEnabled(false);
        if (this.pairsContainer instanceof LayeredExcludePairContainer || this.pairsContainer2 instanceof LayeredDependencyPairContainer) {
            this.treeView.getTreeModel().ruleNameChanged(this.pairsGraGra, true);
            this.treeView.getTree().treeDidChange();
        }
        this.pairsGraGra.update();
        this.fireParserEvent(new ParserMessageEvent(this, "back to AGG editor ... The grammar  <" + this.pairsGraGra.getName() + ">  is still locked by CPA."));
    }

    private void updateCPAgraph() {
        if (this.cpaGraph != null && this.conflictDependGraph != null) {
            this.conflictDependGraph.updateGraphAlongPairContainer();
            this.cpaGraph.update();
            this.pairsGUI.getGraphDesktop().refresh();
        }
    }

    public void occured(ParserGUIEvent e) {
        if (e.getSource() instanceof CriticalPairPanel) {
            this.overlapGraphs = null;
        }
        if (e.getSource() instanceof GraphDesktop) {
            this.graphDesktop = (GraphDesktop)e.getSource();
            if (e.getData() instanceof Graph) {
                if (this.overlapGraphs == null) {
                    this.overlapGraphs = new Hashtable();
                }
                this.overlapGraph = (Graph)e.getData();
                if (this.overlapGraphs.get(this.overlapGraph) == null) {
                    Hashtable ht;
                    Vector vec;
                    ExcludePairContainer epc = this.hostGraphCPA.getPairContainer(0);
                    if (epc == null) {
                        epc = this.hostGraphCPA.getPairContainer(1);
                    }
                    if ((vec = (Vector)(ht = epc.getExcludeContainerForTestGraph()).get(this.overlapGraph)) != null) {
                        this.hostGraphMappings = (Vector)vec.clone();
                    }
                    if (this.hostGraphMappings != null) {
                        if (this.hostGraphMappings.size() > 1) {
                            this.nextMatchAtHostGraphButton = this.graphDesktop.addNextButton(this.overlapGraph, "Click here to get next match at host graph");
                            this.nextMatchAtHostGraphButton.addActionListener(this);
                        } else {
                            this.nextMatchAtHostGraphButton = null;
                        }
                        Pair p = new Pair(this.hostGraphMappings, this.nextMatchAtHostGraphButton);
                        this.overlapGraphs.put(this.overlapGraph, p);
                        if (this.hostGraphMappings.size() > 0) {
                            Vector objs = (Vector)this.hostGraphMappings.elementAt(0);
                            this.showCriticalObjects(this.treeView.getCurrentGraGra().getGraph(), this.graphDesktop.getInternalLayoutGraph(this.overlapGraph), objs);
                            this.treeView.graphDidChange();
                            this.hostGraphMappings.removeElementAt(0);
                        }
                    }
                } else {
                    Pair p = (Pair)this.overlapGraphs.get(this.overlapGraph);
                    this.hostGraphMappings = (Vector)p.first;
                    this.nextMatchAtHostGraphButton = p.second != null ? (JButton)p.second : null;
                    if (this.hostGraphMappings != null && this.hostGraphMappings.size() > 0) {
                        Vector objs = (Vector)this.hostGraphMappings.elementAt(0);
                        this.showCriticalObjects(this.treeView.getCurrentGraGra().getGraph(), this.graphDesktop.getInternalLayoutGraph(this.overlapGraph), objs);
                        this.treeView.graphDidChange();
                        this.hostGraphMappings.removeElementAt(0);
                    }
                }
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton && (JButton)e.getSource() == this.nextMatchAtHostGraphButton) {
            if (this.hostGraphMappings != null && this.hostGraphMappings.size() > 0) {
                Vector objs = (Vector)this.hostGraphMappings.elementAt(0);
                this.showCriticalObjects(this.treeView.getCurrentGraGra().getGraph(), this.graphDesktop.getInternalLayoutGraph(this.overlapGraph), objs);
                this.treeView.graphDidChange();
                this.hostGraphMappings.removeElementAt(0);
            } else {
                JOptionPane.showMessageDialog(this.hostGraphFrame, "No more matches.");
            }
        }
    }

    public void newMessage(StatusMessageEvent sme) {
        if (sme.getMessage().indexOf("is running") >= 0) {
            this.stopCP.setEnabled(true);
        } else if (sme.getMessage().indexOf("finished") >= 0) {
            this.stopCP.setEnabled(false);
        }
    }

    protected boolean loadPairContainer(String filefilter) {
        if (this.pairsGUI.isOnePairThreadAlive()) {
            this.pairsGUI.stopOnePairThread();
        }
        this.pairsIOGUI.setFileFilter(filefilter);
        this.pairsIOGUI.setDirectoryName(this.treeView.getFileDirectory(), "");
        Object o = this.pairsIOGUI.load(true);
        if (o == null) {
            this.cpOption.enableLayered(false);
            return false;
        }
        this.treeView.setFileDirectory(this.pairsIOGUI.getDirectoryName());
        String fullFileName = this.pairsIOGUI.getDirectoryName() + this.pairsIOGUI.getFileName();
        boolean pcExists = false;
        boolean pc2Exists = false;
        if (this.pairsIOGUI.isCombined()) {
            ConflictsDependenciesContainer cdc = (ConflictsDependenciesContainer)o;
            if (this.cpaGraph != null) {
                if (this.conflictDependGraph != null) {
                    if (this.pairsContainer != null) {
                        this.pairsGUI.getGraphDesktop().getConflictPairPanel().removeParserGUIListener(this.conflictDependGraph);
                    }
                    if (this.pairsContainer2 != null) {
                        this.pairsGUI.getGraphDesktop().getDependPairPanel().removeParserGUIListener(this.conflictDependGraph);
                    }
                    this.pairsGUI.getGraphDesktop().removeActionListenerToCPAGraphMenu(this.conflictDependGraph);
                    this.conflictDependGraph = null;
                }
                this.cpaGraph = null;
            }
            if (this.pairsContainer != null) {
                this.removeEventListenersFromPairContainer(this.pairsContainer);
            }
            if (this.pairsContainer2 != null) {
                this.removeEventListenersFromPairContainer(this.pairsContainer2);
            }
            this.pairsGUI.reinitGraphDesktop();
            this.pairsContainer = null;
            this.pairsContainer2 = null;
            this.pairsGUI.getGraphDesktop().getDesktop().repaint();
            if (!cdc.isLayered()) {
                if (cdc.getExcludePairContainer() != null) {
                    this.pairsContainer = cdc.getExcludePairContainer();
                }
                if (cdc.getDependencyPairContainer() != null) {
                    this.pairsContainer2 = cdc.getDependencyPairContainer();
                }
                this.cpOption.enableLayered(false);
            } else {
                if (cdc.getLayeredExcludePairContainer() != null) {
                    this.pairsContainer = cdc.getLayeredExcludePairContainer();
                }
                if (cdc.getLayeredDependencyPairContainer() != null) {
                    this.pairsContainer2 = cdc.getLayeredDependencyPairContainer();
                }
                this.cpOption.enableLayered(true);
            }
            if (cdc.getContainerCount() == 2) {
                this.pairsGraGra = new EdGraGra(this.pairsContainer.getGrammar());
                this.pairsGUI.setGraGra(this.pairsGraGra);
                this.resetCP_GUI(this.pairsGraGra, this.pairsContainer, true);
                this.resetCP_GUI(this.pairsGraGra, this.pairsContainer2, true);
            } else if (cdc.getContainerCount() == 1) {
                if (this.pairsContainer != null) {
                    this.pairsGraGra = new EdGraGra(this.pairsContainer.getGrammar());
                    this.pairsGUI.setGraGra(this.pairsGraGra);
                    this.resetCP_GUI(this.pairsGraGra, this.pairsContainer, true);
                } else if (this.pairsContainer2 != null) {
                    this.pairsGraGra = new EdGraGra(this.pairsContainer2.getGrammar());
                    this.pairsGUI.setGraGra(this.pairsGraGra);
                    this.resetCP_GUI(this.pairsGraGra, this.pairsContainer2, true);
                }
            }
            this.cpaGraph = cdc.getCPAGraph();
            if (this.cpaGraph != null) {
                this.conflictDependGraph = new ConflictsDependenciesGraph((ExcludePairContainer)this.pairsContainer, (ExcludePairContainer)this.pairsContainer2, this.cpaGraph, true);
                if (this.pairsContainer != null) {
                    this.pairsGUI.getGraphDesktop().getConflictPairPanel().addParserGUIListener(this.conflictDependGraph);
                }
                if (this.pairsContainer2 != null) {
                    this.pairsGUI.getGraphDesktop().getDependPairPanel().addParserGUIListener(this.conflictDependGraph);
                }
                this.pairsGUI.getGraphDesktop().addActionListenerToCPAGraphMenu(this.conflictDependGraph);
                this.conflictDependGraph.setGraphDesktop(this.pairsGUI.getGraphDesktop());
                try {
                    this.pairsGUI.getGraphDesktop().addGraph(this.cpaGraph, 400, 300).setIcon(false);
                }
                catch (PropertyVetoException pve) {
                    // empty catch block
                }
                this.conflictDependGraph.updatePairsContainerAlongCPAgraph();
                this.pairsGUI.getGraphDesktop().refresh();
            }
            if (this.pairsGraGra != null) {
                this.pairsGraGra.setChanged(false);
                if (this.pairsGraGra.getBasisGraGra().isLayered()) {
                    this.cpOptionGUI.initLayers(this.pairsGraGra.getBasisGraGra().getLayers());
                }
            }
            if (!this.changer.isSet()) {
                this.changer.changeWith(this.pairsGUI.getContainer());
                this.resetCP.setEnabled(false);
                this.startCP.setEnabled(true);
                this.stopCP.setEnabled(false);
                this.debugCP.setEnabled(false);
                this.emptyCP.setEnabled(true);
                this.reduceCP.setEnabled(true);
                this.consistCP.setEnabled(true);
                this.saveCP.setEnabled(true);
                this.backCP.setEnabled(true);
                this.showCP.setEnabled(true);
                this.checkHostGraphCP.setEnabled(true);
            }
            this.fireParserEvent(new ParserMessageEvent(this, "Critical pairs are loaded."));
            this.pairsSaved = true;
            this.pairsGraGra.setChanged(false);
            return true;
        }
        this.fireParserEvent(new ParserMessageEvent(this, "Load ritical pairs failed."));
        return false;
    }

    protected void loadPairContainerSeparated(String filefilter) {
        this.pairsIOGUI.setDirectoryName(this.treeView.getFileDirectory(), "");
        this.pairsIOGUI.setFileFilter(filefilter);
        CriticalPairAnalysisSeparated separatedFrame = new CriticalPairAnalysisSeparated((JFrame)this.parent, this.pairsIOGUI, this.cpOptionGUI, this.cpOption, this.lOption, this.pOption, this.option);
        if (separatedFrame != null && separatedFrame.isReady()) {
            separatedFrame.setExportJPEG(this.exportJPEG);
            this.x += 100;
            this.y = 50;
            separatedFrame.setLocation(this.x, this.y);
            separatedFrame.showFrame();
            this.separatedFrames.put(separatedFrame.getFrame(), separatedFrame);
            separatedFrame.getFrame().addWindowListener(this.wl);
            this.fireParserEvent(new ParserMessageEvent(this, "Critical pairs are loaded."));
            this.treeView.setFileDirectory(this.pairsIOGUI.getDirectoryName());
        }
    }

    protected void inheritanceWarning() {
        JOptionPane.showMessageDialog(null, "Sorry!\nThis item is not available for the graph grammar \nwith node type inheritance.", "Warning", 2);
    }

    protected void resetWarning() {
        Object[] options = new Object[]{"Reset", "Keep"};
        int answer = JOptionPane.showOptionDialog(null, "Do you want to reset the grammar for critical pair analysis?", "Warning", -1, 3, null, options, options[0]);
        if (answer == 0) {
            this.resetCPAGraGra(this.selectedGraGra);
        }
    }

    private void showCriticalObjects(EdGraph hostg, EdGraph overlapg, Vector objs) {
        int i;
        EdNode n;
        hostg.deselectAll();
        Enumeration en = hostg.getBasisGraph().getElements();
        while (en.hasMoreElements()) {
            GraphObject o = (GraphObject)en.nextElement();
            o.setCritical(false);
            n = hostg.findNode(o);
            if (n != null) {
                n.createMorphismMark();
                continue;
            }
            EdArc a = hostg.findArc(o);
            if (a == null) continue;
            a.createMorphismMark();
        }
        en = objs.elements();
        while (en.hasMoreElements()) {
            EdArc ai;
            Pair p = (Pair)en.nextElement();
            GraphObject o = (GraphObject)p.first;
            GraphObject i2 = (GraphObject)p.second;
            i2.setCritical(true);
            EdNode no = overlapg.findNode(o);
            if (no != null) {
                EdNode ni = hostg.findNode(i2);
                if (ni == null) continue;
                ni.addMorphismMark(no.getMorphismMark());
                continue;
            }
            EdArc ao = overlapg.findArc(o);
            if (ao == null || (ai = hostg.findArc(i2)) == null) continue;
            ai.addMorphismMark(ao.getMorphismMark());
        }
        for (i = 0; i < hostg.getNodes().size(); ++i) {
            n = (EdNode)hostg.getNodes().elementAt(i);
            if (!n.getBasisNode().isCritical()) continue;
            hostg.setSelectedNode(n);
        }
        for (i = 0; i < hostg.getArcs().size(); ++i) {
            EdArc a = (EdArc)hostg.getArcs().elementAt(i);
            if (!a.getBasisArc().isCritical()) continue;
            hostg.setSelectedArc(a);
        }
        hostg.update();
    }

    public void addCPAnalysisEventListener(ParserEventListener l) {
        if (!this.listener.contains(l)) {
            this.listener.add(0, l);
        }
    }

    public void removeCPAnalysisEventListener(ParserEventListener l) {
        if (this.listener.contains(l)) {
            this.listener.removeElement(l);
        }
    }

    private synchronized void fireParserEvent(ParserEvent e) {
        for (int i = 0; i < this.listener.size(); ++i) {
            ((ParserEventListener)this.listener.elementAt(i)).parserEventOccured(e);
        }
    }

    public void addStatusMessageListener(StatusMessageListener l) {
        if (!this.pmlistener.contains(l)) {
            this.pmlistener.add(0, l);
        }
        this.pairsGUI.addStatusMessageListener(l);
    }

    private void fireStatusMessageEvent(StatusMessageEvent e) {
        for (int i = 0; i < this.pmlistener.size(); ++i) {
            ((StatusMessageListener)this.pmlistener.elementAt(i)).newMessage(e);
        }
    }

    private boolean resetLayerFunction() {
        if (this.cpOption.layeredEnabled()) {
            if (!(this.pairsContainer != null && this.pairsContainer.getLayer() != null || this.pairsContainer2 != null && this.pairsContainer2.getLayer() != null)) {
                this.lf = ParserFactory.createLayerFunction(this.pairsGraGra.getBasisGraGra(), this.lOption);
                LayerGUI lgui = new LayerGUI(this.parent, this.lf);
                lgui.showGUI();
                if (lgui.isCancelled()) {
                    this.cpOption.enableLayered(false);
                    this.cpOptionGUI.update();
                    this.lf = null;
                }
                return true;
            }
            return false;
        }
        return this.pairsContainer != null && this.pairsContainer.getLayer() != null || this.pairsContainer2 != null && this.pairsContainer2.getLayer() != null;
    }

    protected PairContainer makeEmptyCriticalPairs(int kindOfAlgorithm) {
        if (kindOfAlgorithm == 0) {
            if (this.pairsContainer != null) {
                this.pairsContainer.clear();
                return this.pairsContainer;
            }
            PairContainer pc = ParserFactory.createEmptyCriticalPairs(this.pairsGraGra.getBasisGraGra(), kindOfAlgorithm, this.cpOption.layeredEnabled());
            if (this.conflictDependGraph != null && pc != null) {
                pc.addPairEventListener(this.conflictDependGraph);
                this.conflictDependGraph.setConflictPairContainer(pc);
            }
            return pc;
        }
        if (kindOfAlgorithm == 1) {
            if (this.pairsContainer2 != null) {
                this.pairsContainer2.clear();
                return this.pairsContainer2;
            }
            PairContainer pc = ParserFactory.createEmptyCriticalPairs(this.pairsGraGra.getBasisGraGra(), kindOfAlgorithm, this.cpOption.layeredEnabled());
            if (this.conflictDependGraph != null && pc != null) {
                pc.addPairEventListener(this.conflictDependGraph);
                this.conflictDependGraph.setDependencyPairContainer(pc);
            }
            return pc;
        }
        return null;
    }

    private void resetCP_GUI(EdGraGra gragra, PairContainer pc, boolean newpc) {
        if (gragra == null || gragra.getRules().isEmpty()) {
            return;
        }
        if (pc != null && this.pairsGUI.getGraGra() == gragra) {
            if (newpc) {
                this.addEventListenersToPairContainer(pc);
                this.pairsGUI.setCriticalPairs(pc);
            } else {
                this.pairsGUI.update();
            }
            ((ExcludePairContainer)pc).enableComplete(this.cpOption.completeEnabled());
            ((ExcludePairContainer)pc).enableReduce(this.cpOption.reduceEnabled());
            ((ExcludePairContainer)pc).enableNACs(this.cpOption.nacsEnabled());
            ((ExcludePairContainer)pc).enableConsistent(this.cpOption.consistentEnabled());
            if (pc instanceof LayeredExcludePairContainer) {
                ((LayeredExcludePairContainer)pc).setLayer(this.cpOption.getLayer());
            } else if (pc instanceof LayeredDependencyPairContainer) {
                ((LayeredDependencyPairContainer)pc).setLayer(this.cpOption.getLayer());
            }
        }
        for (int i = 0; i < this.separatedFrames.size(); ++i) {
            if (this.separatedFrames.get(i) == null) continue;
            CriticalPairAnalysisSeparated cpas = (CriticalPairAnalysisSeparated)this.separatedFrames.get(i);
            ExcludePairContainer excludePC = cpas.getPairContainer(0);
            ExcludePairContainer excludePC2 = cpas.getPairContainer(1);
            if (excludePC != null) {
                excludePC.enableComplete(this.cpOption.completeEnabled());
                excludePC.enableReduce(this.cpOption.reduceEnabled());
                excludePC.enableNACs(this.cpOption.nacsEnabled());
                excludePC.enableConsistent(this.cpOption.consistentEnabled());
            }
            if (excludePC2 == null) continue;
            excludePC2.enableComplete(this.cpOption.completeEnabled());
            excludePC2.enableReduce(this.cpOption.reduceEnabled());
            excludePC2.enableNACs(this.cpOption.nacsEnabled());
            excludePC2.enableConsistent(this.cpOption.consistentEnabled());
        }
    }

    private boolean checkIfReadyToTransform(EdGraGra gragra) {
        Pair pair = gragra.getBasisGraGra().isReadyToTransform();
        Object test = null;
        if (pair != null) {
            test = pair.first;
        }
        if (test != null) {
            JOptionPane.showMessageDialog(null, "Cannot set grammar to analyze.\n" + (String)pair.second, "Warning", 2);
            return false;
        }
        return true;
    }

    private void removeEventListenersFromPairContainer(PairContainer pc) {
        if (pc == null) {
            return;
        }
        for (int i = 0; i < this.listener.size(); ++i) {
            if (pc instanceof LayeredDependencyPairContainer) {
                ((LayeredDependencyPairContainer)pc).stop();
                ((LayeredDependencyPairContainer)pc).removePairEventListener((ParserEventListener)this.listener.elementAt(i));
                continue;
            }
            if (pc instanceof LayeredExcludePairContainer) {
                ((LayeredExcludePairContainer)pc).stop();
                ((LayeredExcludePairContainer)pc).removePairEventListener((ParserEventListener)this.listener.elementAt(i));
                continue;
            }
            if (pc instanceof DependencyPairContainer) {
                ((DependencyPairContainer)pc).stop();
                ((DependencyPairContainer)pc).removePairEventListener((ParserEventListener)this.listener.elementAt(i));
                continue;
            }
            if (!(pc instanceof ExcludePairContainer)) continue;
            ((ExcludePairContainer)pc).stop();
            ((ExcludePairContainer)pc).removePairEventListener((ParserEventListener)this.listener.elementAt(i));
        }
    }

    private void addEventListenersToPairContainer(PairContainer pc) {
        for (int i = 0; i < this.listener.size(); ++i) {
            if (pc instanceof LayeredDependencyPairContainer) {
                ((LayeredDependencyPairContainer)pc).addPairEventListener((ParserEventListener)this.listener.elementAt(i));
                continue;
            }
            if (pc instanceof LayeredExcludePairContainer) {
                ((LayeredExcludePairContainer)pc).addPairEventListener((ParserEventListener)this.listener.elementAt(i));
                continue;
            }
            if (pc instanceof DependencyPairContainer) {
                ((DependencyPairContainer)pc).addPairEventListener((ParserEventListener)this.listener.elementAt(i));
                continue;
            }
            if (!(pc instanceof ExcludePairContainer)) continue;
            ((ExcludePairContainer)pc).addPairEventListener((ParserEventListener)this.listener.elementAt(i));
        }
    }

    private boolean layerUsed() {
        if (this.pairsContainer != null && this.pairsContainer instanceof LayeredExcludePairContainer) {
            return true;
        }
        if (this.pairsContainer2 != null && this.pairsContainer2 instanceof LayeredDependencyPairContainer) {
            return true;
        }
        return this.pairsContainer == null && this.pairsContainer2 == null;
    }

    private void resetRuleApplicable(GraGra gra) {
        for (int i = 0; i < gra.getRulesVec().size(); ++i) {
            Rule r = (Rule)gra.getRulesVec().elementAt(i);
            r.setApplicable(true);
        }
    }

    private boolean areRulesInjective(GraGra gra) {
        Vector noninjectives = gra.getNonInjectiveRules();
        String text = "\n[ ";
        for (int i = 0; i < noninjectives.size(); ++i) {
            text = text + ((Rule)noninjectives.get(i)).getName() + "  ";
        }
        text = text + "]";
        if (!gra.getNonInjectiveRules().isEmpty()) {
            JOptionPane.showMessageDialog(null, "Sorry!\nThis item isn't available for the graph grammar \nwith non-injective rules." + text, "Warning", 2);
            return false;
        }
        return true;
    }
}

