/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.gui.GraphicsExportJPEG;
import agg.gui.parser.ConflictsDependenciesGraph;
import agg.gui.parser.CriticalPairAnalysisGUI;
import agg.gui.parser.CriticalPairOptionGUI;
import agg.gui.parser.LayerGUI;
import agg.gui.parser.PairIOGUI;
import agg.gui.parser.ParserGUIOption;
import agg.gui.parser.ParserOptionGUI;
import agg.gui.parser.event.OptionEvent;
import agg.gui.parser.event.OptionListener;
import agg.parser.ConflictsDependenciesContainer;
import agg.parser.CriticalPairOption;
import agg.parser.ExcludePairContainer;
import agg.parser.LayerFunction;
import agg.parser.LayerOption;
import agg.parser.PairContainer;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import agg.parser.ParserFactory;
import agg.parser.ParserOption;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;

public class CriticalPairAnalysisSeparated
implements ParserEventListener,
OptionListener {
    private ParserGUIOption option;
    private ParserOptionGUI pOptionGUI;
    private ParserOption pOption;
    private LayerOption lOption;
    private CriticalPairOptionGUI cpOptionGUI;
    private CriticalPairOption cpOption;
    private CriticalPairAnalysisGUI pairsGUI;
    private PairIOGUI pairsIOGUI;
    private PairContainer excludePC;
    private PairContainer dependPC;
    private ConflictsDependenciesGraph conflictDependGraph;
    private EdGraph cpaGraph;
    private EdGraGra pairsGraGra;
    private GraGra emptyGraGra;
    private LayerFunction lf;
    private JMenu menu;
    private JMenu showCP;
    private JMenuItem startCP;
    private JMenuItem stopCP;
    private JMenuItem reduceCP;
    private JMenuItem consistCP;
    private JMenuItem emptyCP;
    private JMenuItem saveCP;
    private JMenuItem showConflictCP;
    private JMenuItem showDependencyCP;
    private JMenuItem cpaCombiGraphCP;
    private Vector listener;
    private Vector pmlistener;
    private JFrame parent;
    private JFrame frame;
    private JLabel label;
    private int x;
    private int y;
    private boolean ready;
    private boolean needToLoad;
    private boolean loaded;
    private GraphicsExportJPEG exportJPEG;

    public CriticalPairAnalysisSeparated(JFrame parent, PairIOGUI pairsIOGUI, CriticalPairOptionGUI cpOptionGUI, CriticalPairOption cpOption, LayerOption lOption, ParserOption pOption, ParserGUIOption option) {
        this.parent = parent;
        this.pairsIOGUI = pairsIOGUI;
        this.cpOptionGUI = cpOptionGUI;
        this.needToLoad = true;
        this.createCriticalPairAnalysis(cpOption, lOption, pOption, option);
    }

    public CriticalPairAnalysisSeparated(JFrame parent, ExcludePairContainer conflictContainer, ExcludePairContainer dependContainer, CriticalPairOption cpOption, LayerOption lOption, ParserOption pOption, ParserGUIOption option) {
        this.parent = parent;
        this.excludePC = conflictContainer;
        this.dependPC = dependContainer;
        this.needToLoad = false;
        this.createCriticalPairAnalysis(cpOption, lOption, pOption, option);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createCriticalPairAnalysis(CriticalPairOption cpOption, LayerOption lOption, ParserOption pOption, ParserGUIOption option) {
        this.cpOption = cpOption;
        this.lOption = lOption;
        this.pOption = pOption;
        this.option = option;
        this.frame = new JFrame("Critical Pair Analysis");
        JMenuBar menuBar = new JMenuBar();
        this.label = new JLabel("          ");
        this.frame.getContentPane().add((Component)this.label, "South");
        this.createAnalysisMenu("Critical Pair Analysis / Show");
        menuBar.add(this.menu);
        this.frame.setJMenuBar(menuBar);
        this.createCriticalPairAnalysisGUI();
        if (!this.needToLoad || this.loadCriticalPairs()) {
            if (!this.loaded) {
                if (this.excludePC != null && this.dependPC != null) {
                    if (!this.excludePC.getGrammar().compareTo(this.dependPC.getGrammar())) {
                        JOptionPane.showMessageDialog(null, "Show CPA Graph failed!\nConflicts and Dependencies use different grammars!", "CPA Graph", 0);
                        return;
                    }
                    this.pairsGraGra = new EdGraGra(this.excludePC.getGrammar());
                    this.pairsGUI.setGraGra(this.pairsGraGra);
                    this.pairsGUI.setCriticalPairs(this.excludePC);
                    this.pairsGUI.setCriticalPairs(this.dependPC);
                } else {
                    if (this.excludePC != null) {
                        this.pairsGraGra = new EdGraGra(this.excludePC.getGrammar());
                        this.pairsGUI.setGraGra(this.pairsGraGra);
                        this.pairsGUI.setCriticalPairs(this.excludePC);
                    }
                    if (this.dependPC != null) {
                        this.pairsGraGra = new EdGraGra(this.dependPC.getGrammar());
                        this.pairsGUI.setGraGra(this.pairsGraGra);
                        this.pairsGUI.setCriticalPairs(this.dependPC);
                    }
                }
            }
            this.showCP.setEnabled(true);
            this.showCPaddActionListener();
            this.saveCP.setEnabled(true);
            this.saveCPaddActionListener();
            this.ready = true;
        } else {
            this.ready = false;
        }
        this.frame.getContentPane().setSize(600, 500);
        this.frame.pack();
        this.frame.getRootPane().revalidate();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public ExcludePairContainer getPairContainer() {
        return (ExcludePairContainer)this.excludePC;
    }

    public ExcludePairContainer getPairContainer(int kindOfConflict) {
        if (kindOfConflict == 0) {
            return (ExcludePairContainer)this.excludePC;
        }
        if (kindOfConflict == 1) {
            return (ExcludePairContainer)this.dependPC;
        }
        return null;
    }

    public CriticalPairAnalysisGUI getCriticalPairAnalusisGUI() {
        return this.pairsGUI;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setExportJPEG(GraphicsExportJPEG jpg) {
        this.exportJPEG = jpg;
        if (this.pairsGUI != null) {
            this.pairsGUI.getGraphDesktop().setExportJPEG(this.exportJPEG);
        }
    }

    public void showFrame() {
        this.frame.setLocation(this.x, this.y);
        this.frame.setVisible(true);
    }

    public void disposeFrame() {
        this.frame.dispose();
    }

    private void createAnalysisMenu(String title) {
        this.menu = new JMenu(title);
        this.showCP = new JMenu("Show");
        this.showCP.setEnabled(false);
        this.showConflictCP = this.showCP.add(new JMenuItem("Conflicts"));
        this.showDependencyCP = this.showCP.add(new JMenuItem("Dependencies"));
        this.cpaCombiGraphCP = this.showCP.add(new JMenuItem("CPA Graph"));
        this.menu.add(this.showCP);
        this.saveCP = new JMenuItem("Save");
        this.saveCP.setEnabled(false);
        this.menu.add(this.saveCP);
    }

    private void createCriticalPairAnalysisGUI() {
        this.pairsGUI = new CriticalPairAnalysisGUI(this.option);
        ((JSplitPane)this.pairsGUI.getContainer()).setPreferredSize(new Dimension(550, 450));
        this.frame.getContentPane().add((Component)this.pairsGUI.getContainer(), "Center");
        if (this.needToLoad) {
            this.emptyGraGra = BaseFactory.theFactory().createGraGra();
            this.lf = ParserFactory.createLayerFunction(this.emptyGraGra, this.lOption);
            this.cpOption.enableLayered(true);
            if (this.pairsIOGUI == null) {
                this.excludePC = ParserFactory.createEmptyCriticalPairs(this.emptyGraGra, this.cpOption.getCriticalPairAlgorithm(), this.cpOption.layeredEnabled());
            }
        }
    }

    private boolean loadCriticalPairs() {
        Object o;
        if (this.pairsIOGUI == null) {
            this.pairsIOGUI = new PairIOGUI(this.parent);
        }
        if ((o = this.pairsIOGUI.load(true)) == null) {
            this.cpOption.enableLayered(false);
            return false;
        }
        String fullFileName = this.pairsIOGUI.getDirectoryName() + this.pairsIOGUI.getFileName();
        boolean pcExists = false;
        boolean pc2Exists = false;
        if (this.pairsIOGUI.isCombined()) {
            ConflictsDependenciesContainer cdc = (ConflictsDependenciesContainer)o;
            if (this.cpaGraph != null && this.conflictDependGraph != null) {
                if (this.excludePC != null) {
                    this.pairsGUI.getGraphDesktop().getConflictPairPanel().removeParserGUIListener(this.conflictDependGraph);
                }
                if (this.dependPC != null) {
                    this.pairsGUI.getGraphDesktop().getDependPairPanel().removeParserGUIListener(this.conflictDependGraph);
                }
                this.pairsGUI.getGraphDesktop().removeActionListenerToCPAGraphMenu(this.conflictDependGraph);
            }
            this.pairsGUI.reinitGraphDesktop();
            this.excludePC = null;
            this.dependPC = null;
            this.pairsGUI.getGraphDesktop().getDesktop().repaint();
            if (!cdc.isLayered()) {
                if (cdc.getExcludePairContainer() != null) {
                    this.excludePC = cdc.getExcludePairContainer();
                }
                if (cdc.getDependencyPairContainer() != null) {
                    this.dependPC = cdc.getDependencyPairContainer();
                }
                this.cpOption.enableLayered(false);
            } else {
                if (cdc.getLayeredExcludePairContainer() != null) {
                    this.excludePC = cdc.getLayeredExcludePairContainer();
                }
                if (cdc.getLayeredDependencyPairContainer() != null) {
                    this.dependPC = cdc.getLayeredDependencyPairContainer();
                }
                this.cpOption.enableLayered(true);
            }
            if (cdc.getContainerCount() == 2) {
                this.pairsGraGra = new EdGraGra(this.excludePC.getGrammar());
                this.pairsGUI.setGraGra(this.pairsGraGra);
                this.resetCP_GUI(this.pairsGraGra, this.excludePC, true);
                this.resetCP_GUI(this.pairsGraGra, this.dependPC, true);
            } else if (cdc.getContainerCount() == 1) {
                if (this.excludePC != null) {
                    this.pairsGraGra = new EdGraGra(this.excludePC.getGrammar());
                    this.pairsGUI.setGraGra(this.pairsGraGra);
                    this.resetCP_GUI(this.pairsGraGra, this.excludePC, true);
                } else if (this.dependPC != null) {
                    this.pairsGraGra = new EdGraGra(this.dependPC.getGrammar());
                    this.pairsGUI.setGraGra(this.pairsGraGra);
                    this.resetCP_GUI(this.pairsGraGra, this.dependPC, true);
                }
            }
            this.cpaGraph = cdc.getCPAGraph();
            if (this.cpaGraph != null) {
                this.conflictDependGraph = new ConflictsDependenciesGraph((ExcludePairContainer)this.excludePC, (ExcludePairContainer)this.dependPC, this.cpaGraph, true);
                if (this.excludePC != null) {
                    this.pairsGUI.getGraphDesktop().getConflictPairPanel().addParserGUIListener(this.conflictDependGraph);
                }
                if (this.dependPC != null) {
                    this.pairsGUI.getGraphDesktop().getDependPairPanel().addParserGUIListener(this.conflictDependGraph);
                }
                this.pairsGUI.getGraphDesktop().addActionListenerToCPAGraphMenu(this.conflictDependGraph);
                this.conflictDependGraph.setGraphDesktop(this.pairsGUI.getGraphDesktop());
                try {
                    this.pairsGUI.getGraphDesktop().addGraph(this.cpaGraph, 400, 300).setIcon(false);
                }
                catch (PropertyVetoException pve) {
                    // empty catch block
                }
                this.conflictDependGraph.updatePairsContainerAlongCPAgraph();
                this.pairsGUI.getGraphDesktop().refresh();
            }
            this.loaded = true;
        }
        return true;
    }

    private void resetCP_GUI(EdGraGra gragra, PairContainer pc, boolean newpc) {
        if (gragra == null || gragra.getRules().isEmpty()) {
            return;
        }
        if (pc != null) {
            if (newpc) {
                if (this.pairsGUI.getGraGra() != gragra) {
                    this.pairsGUI.setGraGra(gragra);
                }
                this.pairsGUI.setCriticalPairs(pc);
            } else {
                this.pairsGUI.update();
            }
            ((ExcludePairContainer)pc).enableComplete(this.cpOption.completeEnabled());
            ((ExcludePairContainer)pc).enableReduce(this.cpOption.reduceEnabled());
            ((ExcludePairContainer)pc).enableNACs(this.cpOption.nacsEnabled());
            ((ExcludePairContainer)pc).enableConsistent(this.cpOption.consistentEnabled());
        }
    }

    public void parserEventOccured(ParserEvent e) {
        if (e.getMessage().indexOf("Critical") != -1 && e.getMessage().indexOf("finished") != -1) {
            this.updateCPAgraph();
            this.startCP.setEnabled(true);
            this.stopCP.setEnabled(false);
            this.emptyCP.setEnabled(true);
            this.reduceCP.setEnabled(true);
            this.consistCP.setEnabled(true);
            this.saveCP.setEnabled(true);
        } else if (e.getMessage().indexOf("rule pair") != -1) {
            if (!this.stopCP.isEnabled() && e.getMessage().indexOf("done") == -1) {
                this.startCP.setEnabled(false);
                this.reduceCP.setEnabled(false);
                this.consistCP.setEnabled(false);
                this.saveCP.setEnabled(false);
            }
        } else if (e.getMessage().indexOf("done") != -1) {
            this.startCP.setEnabled(true);
            this.reduceCP.setEnabled(true);
            this.consistCP.setEnabled(true);
            this.saveCP.setEnabled(true);
        }
    }

    private void updateCPAgraph() {
        if (this.cpaGraph != null && this.conflictDependGraph != null) {
            this.conflictDependGraph.updateGraphAlongPairContainer();
            this.cpaGraph.update();
            this.pairsGUI.getGraphDesktop().refresh();
        }
    }

    public void optionEventOccurred(OptionEvent e) {
        JCheckBox cb;
        if (e.getSource() instanceof JCheckBox && (cb = (JCheckBox)e.getSource()).getText().equals("NACs")) {
            this.cpOption.enableNacs(cb.isSelected());
        }
    }

    public CriticalPairAnalysisGUI getCriticalPairAnalysisGUI() {
        return this.pairsGUI;
    }

    public boolean isReady() {
        return this.ready;
    }

    private void startCPaddActionListener() {
        this.startCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CriticalPairAnalysisSeparated.this.pairsGraGra == null || CriticalPairAnalysisSeparated.this.pairsGraGra.getBasisGraGra() == null) {
                    return;
                }
                PairContainer oldPC = CriticalPairAnalysisSeparated.this.pairsGUI.getCriticalPairs();
                if (oldPC instanceof ExcludePairContainer) {
                    if (((ExcludePairContainer)oldPC).isComputed()) {
                        CriticalPairAnalysisSeparated.this.startCP.setEnabled(true);
                        CriticalPairAnalysisSeparated.this.stopCP.setEnabled(false);
                        CriticalPairAnalysisSeparated.this.emptyCP.setEnabled(true);
                        CriticalPairAnalysisSeparated.this.reduceCP.setEnabled(true);
                        CriticalPairAnalysisSeparated.this.consistCP.setEnabled(true);
                        CriticalPairAnalysisSeparated.this.saveCP.setEnabled(true);
                    } else if (CriticalPairAnalysisSeparated.this.pairsGUI.isOnePairThreadAlive()) {
                        CriticalPairAnalysisSeparated.this.startCP.setEnabled(false);
                        CriticalPairAnalysisSeparated.this.emptyCP.setEnabled(true);
                        CriticalPairAnalysisSeparated.this.reduceCP.setEnabled(false);
                        CriticalPairAnalysisSeparated.this.consistCP.setEnabled(false);
                        CriticalPairAnalysisSeparated.this.saveCP.setEnabled(false);
                    } else {
                        CriticalPairAnalysisSeparated.this.resetLayerFunction();
                        CriticalPairAnalysisSeparated.this.excludePC = ParserFactory.createEmptyCriticalPairs(CriticalPairAnalysisSeparated.this.pairsGraGra.getBasisGraGra(), CriticalPairAnalysisSeparated.this.cpOption.getCriticalPairAlgorithm(), CriticalPairAnalysisSeparated.this.cpOption.layeredEnabled());
                        if (CriticalPairAnalysisSeparated.this.excludePC == null) {
                            return;
                        }
                        CriticalPairAnalysisSeparated.this.pairsGUI.setGraGra(CriticalPairAnalysisSeparated.this.pairsGraGra);
                        CriticalPairAnalysisSeparated.this.pairsGUI.setCriticalPairs(CriticalPairAnalysisSeparated.this.excludePC);
                        ParserFactory.generateCriticalPairs(CriticalPairAnalysisSeparated.this.excludePC);
                        CriticalPairAnalysisSeparated.this.label.setText("Generate critical pairs ...  Please wait ...");
                        CriticalPairAnalysisSeparated.this.startCP.setEnabled(false);
                        CriticalPairAnalysisSeparated.this.stopCP.setEnabled(true);
                        CriticalPairAnalysisSeparated.this.emptyCP.setEnabled(false);
                        CriticalPairAnalysisSeparated.this.reduceCP.setEnabled(false);
                        CriticalPairAnalysisSeparated.this.consistCP.setEnabled(false);
                        CriticalPairAnalysisSeparated.this.saveCP.setEnabled(false);
                    }
                }
            }
        });
    }

    private void stopCPaddActionListener() {
        this.stopCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((ExcludePairContainer)CriticalPairAnalysisSeparated.this.excludePC).stop();
                CriticalPairAnalysisSeparated.this.startCP.setEnabled(true);
                CriticalPairAnalysisSeparated.this.stopCP.setEnabled(false);
                CriticalPairAnalysisSeparated.this.emptyCP.setEnabled(true);
                CriticalPairAnalysisSeparated.this.reduceCP.setEnabled(true);
                CriticalPairAnalysisSeparated.this.consistCP.setEnabled(true);
                CriticalPairAnalysisSeparated.this.saveCP.setEnabled(true);
                CriticalPairAnalysisSeparated.this.label.setText("Generating critical pairs was stopped. The current pair will be finished. Please wait.");
            }
        });
    }

    private void reduceCPaddActionListener() {
        this.reduceCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CriticalPairAnalysisSeparated.this.excludePC != null && ((ExcludePairContainer)CriticalPairAnalysisSeparated.this.excludePC).reduceCriticalPairs()) {
                    CriticalPairAnalysisSeparated.this.pairsGUI.setCriticalPairs(CriticalPairAnalysisSeparated.this.excludePC);
                }
            }
        });
    }

    private void consistCPaddActionListener() {
        this.consistCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CriticalPairAnalysisSeparated.this.excludePC != null) {
                    Thread t = new Thread(){

                        public void run() {
                            ((ExcludePairContainer)CriticalPairAnalysisSeparated.this.excludePC).checkConsistency();
                        }
                    };
                    t.setPriority(4);
                    t.start();
                    while (t.isAlive()) {
                    }
                    CriticalPairAnalysisSeparated.this.pairsGUI.setCriticalPairs(CriticalPairAnalysisSeparated.this.excludePC);
                }
            }
        });
    }

    private void emptyCPaddActionListener() {
        this.emptyCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CriticalPairAnalysisSeparated.this.pairsGUI.isOnePairThreadAlive()) {
                    CriticalPairAnalysisSeparated.this.pairsGUI.stopOnePairThread();
                }
                CriticalPairAnalysisSeparated.this.resetLayerFunction();
                CriticalPairAnalysisSeparated.this.excludePC = ParserFactory.createEmptyCriticalPairs(CriticalPairAnalysisSeparated.this.pairsGraGra.getBasisGraGra(), CriticalPairAnalysisSeparated.this.cpOption.getCriticalPairAlgorithm(), CriticalPairAnalysisSeparated.this.cpOption.layeredEnabled());
                if (CriticalPairAnalysisSeparated.this.excludePC != null) {
                    CriticalPairAnalysisSeparated.this.pairsGUI.setGraGra(CriticalPairAnalysisSeparated.this.pairsGraGra);
                    CriticalPairAnalysisSeparated.this.pairsGUI.setCriticalPairs(CriticalPairAnalysisSeparated.this.excludePC);
                    CriticalPairAnalysisSeparated.this.startCP.setEnabled(true);
                    CriticalPairAnalysisSeparated.this.saveCP.setEnabled(true);
                }
            }
        });
    }

    private void saveCPaddActionListener() {
        this.saveCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CriticalPairAnalysisSeparated.this.pairsGUI.isGenerating()) {
                    return;
                }
                if (CriticalPairAnalysisSeparated.this.pairsGUI.isOnePairThreadAlive()) {
                    return;
                }
                if (CriticalPairAnalysisSeparated.this.pairsIOGUI == null) {
                    CriticalPairAnalysisSeparated.this.pairsIOGUI = new PairIOGUI(CriticalPairAnalysisSeparated.this.parent);
                }
                ConflictsDependenciesContainer cdPC = new ConflictsDependenciesContainer(CriticalPairAnalysisSeparated.this.excludePC, CriticalPairAnalysisSeparated.this.dependPC, CriticalPairAnalysisSeparated.this.cpaGraph);
                CriticalPairAnalysisSeparated.this.pairsIOGUI.setCriticalPairContainer(cdPC);
                CriticalPairAnalysisSeparated.this.pairsIOGUI.save();
            }
        });
    }

    protected PairContainer makeEmptyCriticalPairs(int kindOfAlgorithm) {
        if (kindOfAlgorithm == 0) {
            if (this.excludePC != null) {
                this.excludePC.clear();
                return this.excludePC;
            }
            PairContainer pc = ParserFactory.createEmptyCriticalPairs(this.pairsGraGra.getBasisGraGra(), kindOfAlgorithm, this.cpOption.layeredEnabled());
            if (this.conflictDependGraph != null && pc != null) {
                pc.addPairEventListener(this.conflictDependGraph);
                this.conflictDependGraph.setConflictPairContainer(pc);
            }
            return pc;
        }
        if (kindOfAlgorithm == 1) {
            if (this.dependPC != null) {
                this.dependPC.clear();
                return this.dependPC;
            }
            PairContainer pc = ParserFactory.createEmptyCriticalPairs(this.pairsGraGra.getBasisGraGra(), kindOfAlgorithm, this.cpOption.layeredEnabled());
            if (this.conflictDependGraph != null && pc != null) {
                pc.addPairEventListener(this.conflictDependGraph);
                this.conflictDependGraph.setDependencyPairContainer(pc);
            }
            return pc;
        }
        return null;
    }

    private void showCPaddActionListener() {
        this.showConflictCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysisSeparated.this.showPairContainer(0);
            }
        });
        this.showDependencyCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysisSeparated.this.showPairContainer(1);
            }
        });
        this.showCPAGraphCPaddActionListener();
    }

    private void showPairContainer(int kindOfConflict) {
        if (kindOfConflict == 0) {
            if (this.excludePC == null) {
                this.excludePC = this.makeEmptyCriticalPairs(0);
                this.resetCP_GUI(this.pairsGraGra, this.excludePC, true);
            } else {
                this.pairsGUI.getGraphDesktop().addCriticalPairTable(this.pairsGUI.getGraphDesktop().getConflictPairPanel(), "");
            }
        } else if (kindOfConflict == 1) {
            if (this.dependPC == null) {
                this.dependPC = this.makeEmptyCriticalPairs(1);
                this.resetCP_GUI(this.pairsGraGra, this.dependPC, true);
            } else {
                this.pairsGUI.getGraphDesktop().addCriticalPairTable(this.pairsGUI.getGraphDesktop().getDependPairPanel(), "");
            }
        }
    }

    private void showCPAGraphCPaddActionListener() {
        this.cpaCombiGraphCP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CriticalPairAnalysisSeparated.this.cpaGraph != null) {
                    if (CriticalPairAnalysisSeparated.this.conflictDependGraph != null) {
                        if (CriticalPairAnalysisSeparated.this.excludePC != null) {
                            CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getConflictPairPanel().removeParserGUIListener(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                        }
                        if (CriticalPairAnalysisSeparated.this.dependPC != null) {
                            CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getDependPairPanel().removeParserGUIListener(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                        }
                        CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().removeActionListenerToCPAGraphMenu(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                    }
                    CriticalPairAnalysisSeparated.this.conflictDependGraph = new ConflictsDependenciesGraph((ExcludePairContainer)CriticalPairAnalysisSeparated.this.excludePC, (ExcludePairContainer)CriticalPairAnalysisSeparated.this.dependPC, CriticalPairAnalysisSeparated.this.cpaGraph, false);
                    if (CriticalPairAnalysisSeparated.this.excludePC != null) {
                        CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getConflictPairPanel().addParserGUIListener(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                    }
                    if (CriticalPairAnalysisSeparated.this.dependPC != null) {
                        CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getDependPairPanel().addParserGUIListener(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                    }
                    CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().addActionListenerToCPAGraphMenu(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                    CriticalPairAnalysisSeparated.this.conflictDependGraph.setGraphDesktop(CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop());
                    CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().removeCPAGraphFrame();
                    if (CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getInternalLayoutGraph(CriticalPairAnalysisSeparated.this.cpaGraph.getBasisGraph()) == CriticalPairAnalysisSeparated.this.cpaGraph) {
                        try {
                            CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().addGraph(CriticalPairAnalysisSeparated.this.cpaGraph, 400, 300).setIcon(false);
                        }
                        catch (PropertyVetoException pve) {}
                    }
                } else {
                    if (CriticalPairAnalysisSeparated.this.conflictDependGraph != null) {
                        if (CriticalPairAnalysisSeparated.this.excludePC != null) {
                            CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getConflictPairPanel().removeParserGUIListener(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                        }
                        if (CriticalPairAnalysisSeparated.this.dependPC != null) {
                            CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getDependPairPanel().removeParserGUIListener(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                        }
                    }
                    CriticalPairAnalysisSeparated.this.conflictDependGraph = null;
                    if (CriticalPairAnalysisSeparated.this.excludePC != null && CriticalPairAnalysisSeparated.this.dependPC != null) {
                        CriticalPairAnalysisSeparated.this.conflictDependGraph = new ConflictsDependenciesGraph((ExcludePairContainer)CriticalPairAnalysisSeparated.this.excludePC, (ExcludePairContainer)CriticalPairAnalysisSeparated.this.dependPC);
                        CriticalPairAnalysisSeparated.this.cpaGraph = CriticalPairAnalysisSeparated.this.conflictDependGraph.getConflictsDependenciesGraph();
                    } else if (CriticalPairAnalysisSeparated.this.excludePC != null && CriticalPairAnalysisSeparated.this.excludePC.getKindOfConflict() == 0) {
                        CriticalPairAnalysisSeparated.this.conflictDependGraph = new ConflictsDependenciesGraph((ExcludePairContainer)CriticalPairAnalysisSeparated.this.excludePC, null);
                        CriticalPairAnalysisSeparated.this.cpaGraph = CriticalPairAnalysisSeparated.this.conflictDependGraph.getConflictsGraph();
                    } else if (CriticalPairAnalysisSeparated.this.dependPC != null && CriticalPairAnalysisSeparated.this.dependPC.getKindOfConflict() == 1) {
                        CriticalPairAnalysisSeparated.this.conflictDependGraph = new ConflictsDependenciesGraph(null, (ExcludePairContainer)CriticalPairAnalysisSeparated.this.dependPC);
                        CriticalPairAnalysisSeparated.this.cpaGraph = CriticalPairAnalysisSeparated.this.conflictDependGraph.getDependenciesGraph();
                    }
                    if (CriticalPairAnalysisSeparated.this.cpaGraph != null) {
                        if (CriticalPairAnalysisSeparated.this.excludePC != null) {
                            CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getConflictPairPanel().addParserGUIListener(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                        }
                        if (CriticalPairAnalysisSeparated.this.dependPC != null) {
                            CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getDependPairPanel().addParserGUIListener(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                        }
                        CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().addActionListenerToCPAGraphMenu(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                        CriticalPairAnalysisSeparated.this.conflictDependGraph.setGraphDesktop(CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop());
                        CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().removeAllGraphFrames();
                        CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getDesktop().repaint();
                        try {
                            CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().addGraph(CriticalPairAnalysisSeparated.this.cpaGraph, 400, 300).setIcon(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        CriticalPairAnalysisSeparated.this.saveCP.setEnabled(true);
                        CriticalPairAnalysisSeparated.this.showCP.setEnabled(true);
                    } else {
                        JOptionPane.showMessageDialog(CriticalPairAnalysisSeparated.this.frame, "Show CPA graph failed!.", "Warning", 2);
                    }
                }
            }
        });
    }

    private boolean resetLayerFunction() {
        if (this.cpOption.layeredEnabled()) {
            this.lf = ParserFactory.createLayerFunction(this.pairsGraGra.getBasisGraGra(), this.lOption);
            LayerGUI lgui = new LayerGUI(this.parent, this.lf);
            lgui.showGUI();
            if (lgui.isCancelled()) {
                this.cpOption.enableLayered(false);
                this.cpOptionGUI.update();
                this.lf = null;
            }
            return true;
        }
        return false;
    }
}

