/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.editor.impl.EdGraGra;
import agg.gui.AGGAppl;
import agg.gui.GraGraEditor;
import agg.gui.GraGraTreeView;
import agg.gui.event.TreeViewEvent;
import agg.gui.event.TreeViewEventListener;
import agg.gui.parser.event.OptionEvent;
import agg.gui.parser.event.OptionListener;
import agg.gui.parser.event.ParserGUIEvent;
import agg.gui.parser.event.ParserGUIListener;
import agg.gui.parser.event.StatusMessageEvent;
import agg.gui.parser.event.StatusMessageListener;
import agg.parser.OptionEventListener;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import agg.plugins.dm.forms.SIRP;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class DefectManagement
implements TreeViewEventListener,
ParserEventListener,
OptionListener,
OptionEventListener,
ParserGUIListener,
ActionListener,
MenuListener,
StatusMessageListener {
    private AGGAppl parent;
    private GraGraTreeView treeView;
    private GraGraEditor editor;
    private EdGraGra selectedGraGra;
    private Vector listener;
    private Vector pmlistener;
    private Vector menus;
    private JMenuItem sirpItem = null;

    public DefectManagement(AGGAppl parent, GraGraTreeView treeView, GraGraEditor editor) {
        this.parent = parent;
        this.treeView = treeView;
        this.editor = editor;
        this.addParentListener(parent);
        this.listener = new Vector();
        this.pmlistener = new Vector();
        this.addDMListener(this);
        this.menus = new Vector(2);
        this.createDMMenu();
        this.selectedGraGra = null;
    }

    public void treeViewEventOccurred(TreeViewEvent e) {
        int msgkey = e.getMsg();
        if (msgkey == 61 && e.getData().isGraGra) {
            this.selectedGraGra = e.getData().getGraGra();
        }
        if (msgkey == 7 && e.getData().isGraGra) {
            this.selectedGraGra = null;
        }
    }

    public void parserEventOccured(ParserEvent p) {
    }

    public void optionEventOccurred(OptionEvent e) {
    }

    public void optionEventOccurred(EventObject e) {
    }

    public void occured(ParserGUIEvent pguie) {
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void menuSelected(MenuEvent e) {
        this.selectedGraGra = this.treeView.getCurrentGraGra();
        if (this.selectedGraGra != null) {
            this.sirpItem.setEnabled(true);
            this.sirpItem.setText("SIRP (on " + this.selectedGraGra.getName() + ")");
            return;
        }
        this.sirpItem.setEnabled(false);
        this.sirpItem.setText("SIRP");
    }

    public void menuDeselected(MenuEvent e) {
    }

    public void menuCanceled(MenuEvent e) {
    }

    public void newMessage(StatusMessageEvent sme) {
    }

    public void addDMListener(ParserEventListener l) {
        if (!this.listener.contains(l)) {
            this.listener.add(0, l);
        }
    }

    public void removeDMListener(ParserEventListener l) {
        if (this.listener.contains(l)) {
            this.listener.removeElement(l);
        }
    }

    public Enumeration getMenus() {
        return this.menus.elements();
    }

    private void createDMMenu() {
        JMenu dmMenu = new JMenu("Defect Management");
        this.sirpItem = new JMenuItem("SIRP");
        this.sirpItem.setEnabled(false);
        dmMenu.add(this.sirpItem);
        this.sirpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefectManagement.this.loadSirp(DefectManagement.this.selectedGraGra);
            }
        });
        dmMenu.addMenuListener(this);
        this.menus.addElement(dmMenu);
    }

    public void addStatusMessageListener(StatusMessageListener l) {
        if (!this.pmlistener.contains(l)) {
            this.pmlistener.add(0, l);
        }
    }

    private void addParentListener(AGGAppl parent) {
        WindowAdapter winListener = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (e.getSource() instanceof JFrame) {
                    // empty if block
                }
            }

            public void windowActivated(WindowEvent e) {
            }
        };
        parent.addWindowListener(winListener);
    }

    private void loadSirp(EdGraGra gragra) {
        SIRP mySIRP = new SIRP((Frame)this.parent, gragra, this.treeView, this.editor);
        mySIRP.setVisible(true);
        mySIRP.dispose();
    }
}

