/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.attribute.gui.AttrTopEditor;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.editor.impl.GraphPanel;
import agg.gui.GraGraEditor;
import agg.gui.GraphEditor;
import agg.gui.RuleEditor;
import agg.gui.TypeCardinalityGUI;
import agg.layout.Layouter;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.Node;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class EditPopupMenu
extends JPopupMenu {
    private JFrame applFrame;
    private JMenuItem mi;
    private JMenuItem miDelete;
    private JMenuItem miMap;
    private JMenuItem miUnmap;
    private JMenuItem miStraighten;
    private JMenuItem miAddIdenticToRule;
    private JMenuItem miAddIdenticToNAC;
    private JMenuItem miMultiplicity;
    private JMenuItem miSetParent;
    private JMenuItem miUnsetParent;
    private JMenu deleteMenu;
    private JMenu addIdentic;
    private JMenu layout;
    private JCheckBoxMenuItem miAbstract;
    private JCheckBoxMenuItem miFrozen;
    private boolean mapping = false;
    private GraGraEditor editor;
    private RuleEditor ruleEditor;
    private GraphEditor graphEditor;
    private GraphPanel gp;
    private EdGraphObject ego;
    private int xPos;
    private int yPos;
    private TypeCardinalityGUI multiplicity;
    private boolean useDeleteMenu = false;
    private Layouter layouter;

    public EditPopupMenu() {
        super("Operations");
        this.setLabel("Operations");
        this.setBorderPainted(true);
        this.deleteMenu = this.createDeleteMenu();
        this.useDeleteMenu = false;
        this.mi = this.add(new JMenuItem("   Operations   "));
        this.mi.setEnabled(false);
        this.addSeparator();
        this.mi = this.add(new JMenuItem("Attributes ..."));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDoIt()) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                EditPopupMenu.this.gp.getCanvas().saveScrollBarValue();
                AttrTopEditor attrEditor = EditPopupMenu.this.editor.getAttrEditor(EditPopupMenu.this.ego);
                if (EditPopupMenu.this.ruleEditor == null) {
                    attrEditor.enableContextEditor(false);
                    EditPopupMenu.this.editor.setAttrEditorOnTop(attrEditor.getComponent());
                } else {
                    attrEditor.enableContextEditor(true);
                    EditPopupMenu.this.editor.setAttrEditorOnBottom(attrEditor.getComponent());
                }
            }
        });
        this.addSeparator();
        this.mi = this.add(new JMenuItem("Copy"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDoIt()) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                EditPopupMenu.this.gp.setLastEditMode(EditPopupMenu.this.gp.getEditMode());
                EditPopupMenu.this.gp.setLastEditCursor(EditPopupMenu.this.gp.getEditCursor());
                EditPopupMenu.this.gp.getGraph().eraseSelected(EditPopupMenu.this.gp.getCanvas().getGraphics(), EditPopupMenu.this.gp.getCanvas().getScale(), true);
                EditPopupMenu.this.gp.getGraph().select(EditPopupMenu.this.xPos, EditPopupMenu.this.yPos);
                EditPopupMenu.this.gp.getGraph().drawSelected(EditPopupMenu.this.gp.getCanvas().getGraphics(), EditPopupMenu.this.gp.getCanvas().getScale());
                if (EditPopupMenu.this.ego.isNode()) {
                    EditPopupMenu.this.gp.setEditMode(15);
                    if (EditPopupMenu.this.editor != null) {
                        EditPopupMenu.this.editor.setMsg("To get a copy of a node click on the background of the same panel.");
                    }
                } else {
                    EditPopupMenu.this.gp.setEditMode(151);
                    if (EditPopupMenu.this.editor != null) {
                        EditPopupMenu.this.editor.setMsg("To get a copy of an edge click on a source node and a target node of the same panel.");
                    }
                }
                EditPopupMenu.this.applFrame.setCursor(new Cursor(1));
            }
        });
        this.mi = this.add(new JMenuItem("Select"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditPopupMenu.this.gp == null || EditPopupMenu.this.gp.getGraph() == null || EditPopupMenu.this.ego == null) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                EdGraphObject go = EditPopupMenu.this.gp.getGraph().select(EditPopupMenu.this.xPos, EditPopupMenu.this.yPos);
                if (go.isNode()) {
                    EditPopupMenu.this.gp.getGraph().drawNode(EditPopupMenu.this.gp.getCanvas().getGraphics(), EditPopupMenu.this.gp.getCanvas().getScale(), (EdNode)go);
                } else {
                    EditPopupMenu.this.gp.getGraph().drawArc(EditPopupMenu.this.gp.getCanvas().getGraphics(), EditPopupMenu.this.gp.getCanvas().getScale(), (EdArc)go);
                }
            }
        });
        this.mi = this.add(new JMenuItem("Select All"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditPopupMenu.this.gp == null || EditPopupMenu.this.gp.getGraph() == null) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                EditPopupMenu.this.gp.getGraph().selectAll();
                EditPopupMenu.this.gp.updateGraphics();
            }
        });
        this.addSeparator();
        this.miDelete = this.createDeleteItem();
        this.deleteMenu = this.createDeleteMenu();
        this.add(this.miDelete);
        if (this.useDeleteMenu) {
            this.add(this.deleteMenu);
        }
        this.addSeparator();
        this.miStraighten = this.mi = this.add(new JMenuItem("Straighten"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDoIt()) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                EditPopupMenu.this.gp.getGraph().eraseObj(EditPopupMenu.this.gp.getCanvas().getGraphics(), EditPopupMenu.this.gp.getCanvas().getScale(), EditPopupMenu.this.ego);
                EditPopupMenu.this.gp.getGraph().straightArc(EditPopupMenu.this.ego);
                EditPopupMenu.this.gp.getGraph().drawObj(EditPopupMenu.this.gp.getCanvas().getGraphics(), EditPopupMenu.this.gp.getCanvas().getScale(), EditPopupMenu.this.ego);
            }
        });
        this.layout = new JMenu("Graph Layout");
        this.add(this.layout);
        this.miFrozen = (JCheckBoxMenuItem)this.layout.add(new JCheckBoxMenuItem("Static Position"));
        this.miFrozen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDoIt()) {
                    return;
                }
                if (EditPopupMenu.this.ego instanceof EdNode) {
                    if (EditPopupMenu.this.ego.getBasisObject().getContext().isTypeGraph()) {
                        if (EditPopupMenu.this.layouter != null && EditPopupMenu.this.editor != null) {
                            EditPopupMenu.this.editor.getGraGra().createLayoutPattern("Freezing", "node", EditPopupMenu.this.ego.getBasisObject().getType(), ((JCheckBoxMenuItem)e.getSource()).isSelected());
                        }
                    } else if (((JCheckBoxMenuItem)e.getSource()).isSelected()) {
                        ((EdNode)EditPopupMenu.this.ego).getLNode().setFrozen(true);
                    } else {
                        ((EdNode)EditPopupMenu.this.ego).getLNode().setFrozen(false);
                    }
                }
            }
        });
        this.addSeparator();
        this.addIdentic = new JMenu("Add Identic To");
        this.add(this.addIdentic);
        this.miAddIdenticToRule = this.mi = this.addIdentic.add(new JMenuItem("Rule"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDoIt()) {
                    return;
                }
                if (EditPopupMenu.this.ruleEditor != null && EditPopupMenu.this.gp == EditPopupMenu.this.ruleEditor.getLeftPanel()) {
                    if (EditPopupMenu.this.ego.isNode()) {
                        EditPopupMenu.this.ruleEditor.getRule().addIdenticToRule(EditPopupMenu.this.ego);
                        EditPopupMenu.this.ruleEditor.updateGraphics();
                    } else {
                        Node src = (Node)EditPopupMenu.this.ruleEditor.getRule().getBasisRule().getImage(((Arc)EditPopupMenu.this.ego.getBasisObject()).getSource());
                        Node tar = (Node)EditPopupMenu.this.ruleEditor.getRule().getBasisRule().getImage(((Arc)EditPopupMenu.this.ego.getBasisObject()).getTarget());
                        Object[] options = new Object[]{"Yes", "No"};
                        if (src == null && tar != null) {
                            int answer = JOptionPane.showOptionDialog(null, "Cannot create an identic edge!\nThe source node is not defined.\nShould it be created now?", "Identic Edge", -1, 3, null, options, options[0]);
                            if (answer == 0) {
                                EditPopupMenu.this.ruleEditor.getRule().addIdenticToRule(((EdArc)EditPopupMenu.this.ego).getSource());
                                EditPopupMenu.this.ruleEditor.getRule().addIdenticToRule(EditPopupMenu.this.ego);
                                EditPopupMenu.this.ruleEditor.updateGraphics();
                            }
                        } else if (src != null && tar == null) {
                            int answer = JOptionPane.showOptionDialog(null, "Cannot create an identic edge!\nThe target node is not defined.\nShould it be created now?", "Identic Edge", -1, 3, null, options, options[0]);
                            if (answer == 0) {
                                EditPopupMenu.this.ruleEditor.getRule().addIdenticToRule(((EdArc)EditPopupMenu.this.ego).getTarget());
                                EditPopupMenu.this.ruleEditor.getRule().addIdenticToRule(EditPopupMenu.this.ego);
                                EditPopupMenu.this.ruleEditor.updateGraphics();
                            }
                        } else if (src == null && tar == null) {
                            int answer = JOptionPane.showOptionDialog(null, "Cannot create an identic edge!\nThe source and target nodes are not defined.\nShould they be created now?", "Identic Edge", -1, 3, null, options, options[0]);
                            if (answer == 0) {
                                EditPopupMenu.this.ruleEditor.getRule().addIdenticToRule(((EdArc)EditPopupMenu.this.ego).getSource());
                                EditPopupMenu.this.ruleEditor.getRule().addIdenticToRule(((EdArc)EditPopupMenu.this.ego).getTarget());
                                EditPopupMenu.this.ruleEditor.getRule().addIdenticToRule(EditPopupMenu.this.ego);
                                EditPopupMenu.this.ruleEditor.updateGraphics();
                            }
                        } else {
                            EditPopupMenu.this.ruleEditor.getRule().addIdenticToRule(EditPopupMenu.this.ego);
                            EditPopupMenu.this.ruleEditor.updateGraphics();
                        }
                    }
                }
            }
        });
        this.miAddIdenticToNAC = this.mi = this.addIdentic.add(new JMenuItem("NAC"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDoIt()) {
                    return;
                }
                if (EditPopupMenu.this.ruleEditor != null && EditPopupMenu.this.gp == EditPopupMenu.this.ruleEditor.getLeftPanel()) {
                    if (EditPopupMenu.this.ego.isNode()) {
                        EditPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(EditPopupMenu.this.ego, EditPopupMenu.this.ruleEditor.getNAC());
                        EditPopupMenu.this.ruleEditor.updateGraphics();
                    } else {
                        Node src = (Node)EditPopupMenu.this.ruleEditor.getNAC().getMorphism().getImage(((Arc)EditPopupMenu.this.ego.getBasisObject()).getSource());
                        Node tar = (Node)EditPopupMenu.this.ruleEditor.getNAC().getMorphism().getImage(((Arc)EditPopupMenu.this.ego.getBasisObject()).getTarget());
                        Object[] options = new Object[]{"Yes", "No"};
                        if (src == null && tar != null) {
                            int answer = JOptionPane.showOptionDialog(null, "Cannot create an identic edge!\nThe source node is not defined.\nShould it be created now?", "Identic Edge", -1, 3, null, options, options[0]);
                            if (answer == 0) {
                                EditPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(((EdArc)EditPopupMenu.this.ego).getSource(), EditPopupMenu.this.ruleEditor.getNAC());
                                EditPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(EditPopupMenu.this.ego, EditPopupMenu.this.ruleEditor.getNAC());
                                EditPopupMenu.this.ruleEditor.updateGraphics();
                            }
                        } else if (src != null && tar == null) {
                            int answer = JOptionPane.showOptionDialog(null, "Cannot create an identic edge!\nThe target node is not defined.\nShould it be created now?", "Identic Edge", -1, 3, null, options, options[0]);
                            if (answer == 0) {
                                EditPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(((EdArc)EditPopupMenu.this.ego).getTarget(), EditPopupMenu.this.ruleEditor.getNAC());
                                EditPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(EditPopupMenu.this.ego, EditPopupMenu.this.ruleEditor.getNAC());
                                EditPopupMenu.this.ruleEditor.updateGraphics();
                            }
                        } else if (src == null && tar == null) {
                            int answer = JOptionPane.showOptionDialog(null, "Cannot create an identic edge!\nThe source and target nodes are not defined.\nShould they be created now?", "Identic Edge", -1, 3, null, options, options[0]);
                            if (answer == 0) {
                                EditPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(((EdArc)EditPopupMenu.this.ego).getSource(), EditPopupMenu.this.ruleEditor.getNAC());
                                EditPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(((EdArc)EditPopupMenu.this.ego).getTarget(), EditPopupMenu.this.ruleEditor.getNAC());
                                EditPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(EditPopupMenu.this.ego, EditPopupMenu.this.ruleEditor.getNAC());
                                EditPopupMenu.this.ruleEditor.updateGraphics();
                            }
                        } else {
                            EditPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(EditPopupMenu.this.ego, EditPopupMenu.this.ruleEditor.getNAC());
                            EditPopupMenu.this.ruleEditor.updateGraphics();
                        }
                    }
                }
            }
        });
        this.miMap = this.mi = this.add(new JMenuItem("Map"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditPopupMenu.this.gp == null || EditPopupMenu.this.gp.getGraph() == null || EditPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                EditPopupMenu.this.mapping = true;
                EditPopupMenu.this.setLastEditModeBeforMapping(EditPopupMenu.this.gp);
                if (EditPopupMenu.this.editor != null) {
                    EditPopupMenu.this.editor.getGraphEditor().setEditMode(115);
                    EditPopupMenu.this.editor.getRuleEditor().setEditMode(115);
                    EditPopupMenu.this.editor.getRuleEditor().setObjMapping(true);
                    EditPopupMenu.this.editor.setMsg("Click on a target object you want to map or click on the background to break the mapping.");
                } else if (EditPopupMenu.this.ruleEditor != null) {
                    EditPopupMenu.this.ruleEditor.setEditMode(115);
                    EditPopupMenu.this.ruleEditor.setObjMapping(true);
                    EditPopupMenu.this.ruleEditor.setMsg("Click on a target object you want to map or click on the background to break the mapping");
                }
            }
        });
        this.miUnmap = this.mi = this.add(new JMenuItem("Unmap"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditPopupMenu.this.gp == null || EditPopupMenu.this.gp.getGraph() == null || EditPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                if (EditPopupMenu.this.editor != null && EditPopupMenu.this.editor.getRuleEditor().getRule() != null) {
                    if (EditPopupMenu.this.editor.getActivePanel() == EditPopupMenu.this.editor.getRuleEditor().getLeftPanel()) {
                        EditPopupMenu.this.editor.getRuleEditor().getRule().removeRuleMapping(EditPopupMenu.this.getPickedObj());
                        if (EditPopupMenu.this.editor.getRuleEditor().getNAC() != null) {
                            EditPopupMenu.this.editor.getRuleEditor().getRule().removeNACMapping(EditPopupMenu.this.getPickedObj(), EditPopupMenu.this.editor.getRuleEditor().getNAC().getMorphism());
                        }
                        EditPopupMenu.this.editor.getRuleEditor().getRule().removeMatchMapping(EditPopupMenu.this.getPickedObj());
                        EditPopupMenu.this.editor.getRuleEditor().getRule().update();
                        EditPopupMenu.this.editor.updateGraphics();
                    } else if (EditPopupMenu.this.editor.getActivePanel() == EditPopupMenu.this.editor.getRuleEditor().getRightPanel()) {
                        EditPopupMenu.this.editor.getRuleEditor().getRule().removeMapping(EditPopupMenu.this.getPickedObj(), EditPopupMenu.this.editor.getRuleEditor().getRule().getBasisRule());
                        EditPopupMenu.this.editor.getRuleEditor().updateGraphics();
                    } else if (EditPopupMenu.this.editor.getActivePanel() == EditPopupMenu.this.editor.getRuleEditor().getNACPanel()) {
                        EditPopupMenu.this.editor.getRuleEditor().getRule().removeMapping(EditPopupMenu.this.getPickedObj(), EditPopupMenu.this.editor.getRuleEditor().getNAC().getMorphism());
                        EditPopupMenu.this.editor.getRuleEditor().getLeftPanel().updateGraphics();
                        EditPopupMenu.this.editor.getRuleEditor().getNACPanel().updateGraphics();
                    } else if (EditPopupMenu.this.editor.getActivePanel() == EditPopupMenu.this.editor.getGraphEditor().getGraphPanel()) {
                        EditPopupMenu.this.editor.getRuleEditor().getRule().removeMapping(EditPopupMenu.this.getPickedObj(), EditPopupMenu.this.editor.getRuleEditor().getRule().getMatch());
                        EditPopupMenu.this.editor.getRuleEditor().getLeftPanel().updateGraphics();
                        EditPopupMenu.this.editor.getGraphEditor().getGraphPanel().updateGraphics();
                    }
                } else if (EditPopupMenu.this.ruleEditor != null && EditPopupMenu.this.ruleEditor.getRule() != null) {
                    if (EditPopupMenu.this.gp == EditPopupMenu.this.ruleEditor.getLeftPanel()) {
                        EditPopupMenu.this.ruleEditor.getRule().removeRuleMapping(EditPopupMenu.this.getPickedObj());
                        if (EditPopupMenu.this.ruleEditor.getNAC() != null) {
                            EditPopupMenu.this.ruleEditor.getRule().removeNACMapping(EditPopupMenu.this.getPickedObj(), EditPopupMenu.this.ruleEditor.getNAC().getMorphism());
                        }
                        EditPopupMenu.this.ruleEditor.getRule().removeMatchMapping(EditPopupMenu.this.getPickedObj());
                        EditPopupMenu.this.ruleEditor.getRule().update();
                        EditPopupMenu.this.ruleEditor.updateGraphics();
                        if (EditPopupMenu.this.graphEditor != null) {
                            EditPopupMenu.this.graphEditor.getGraphPanel().updateGraphics();
                        }
                    } else if (EditPopupMenu.this.gp == EditPopupMenu.this.ruleEditor.getRightPanel()) {
                        EditPopupMenu.this.ruleEditor.getRule().removeMapping(EditPopupMenu.this.getPickedObj(), EditPopupMenu.this.ruleEditor.getRule().getBasisRule());
                        EditPopupMenu.this.ruleEditor.updateGraphics();
                    } else if (EditPopupMenu.this.gp == EditPopupMenu.this.ruleEditor.getNACPanel()) {
                        EditPopupMenu.this.ruleEditor.getRule().removeMapping(EditPopupMenu.this.getPickedObj(), EditPopupMenu.this.ruleEditor.getNAC().getMorphism());
                        EditPopupMenu.this.ruleEditor.getLeftPanel().updateGraphics();
                        EditPopupMenu.this.ruleEditor.getNACPanel().updateGraphics();
                    }
                } else if (EditPopupMenu.this.graphEditor != null && EditPopupMenu.this.gp == EditPopupMenu.this.graphEditor.getGraphPanel()) {
                    if (EditPopupMenu.this.ruleEditor != null) {
                        EditPopupMenu.this.ruleEditor.getRule().removeMapping(EditPopupMenu.this.getPickedObj(), EditPopupMenu.this.ruleEditor.getRule().getMatch());
                        EditPopupMenu.this.ruleEditor.getLeftPanel().updateGraphics();
                    }
                    EditPopupMenu.this.graphEditor.getGraphPanel().updateGraphics();
                }
            }
        });
        this.addSeparator();
        this.miMultiplicity = this.mi = this.add(new JMenuItem("Multiplicity"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditPopupMenu.this.setCardinalityOfType();
                if (EditPopupMenu.this.graphEditor != null) {
                    EditPopupMenu.this.graphEditor.getGraph().update();
                    EditPopupMenu.this.graphEditor.getGraphPanel().updateGraphics();
                }
            }
        });
        this.miSetParent = this.mi = this.add(new JMenuItem("Set Parent"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Node bNode;
                Graph bGraph;
                if (EditPopupMenu.this.gp == null || EditPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                if (EditPopupMenu.this.ego instanceof EdNode && (bGraph = (bNode = EditPopupMenu.this.ego.getNode().getBasisNode()).getContext()).isTypeGraph()) {
                    EditPopupMenu.this.mapping = true;
                    EditPopupMenu.this.setLastEditModeBeforMapping(EditPopupMenu.this.gp);
                    if (EditPopupMenu.this.editor != null) {
                        EditPopupMenu.this.editor.getGraphEditor().setEditMode(1201);
                        EditPopupMenu.this.editor.setMsg("Click on a node to add a parent.");
                    }
                }
            }
        });
        this.miUnsetParent = this.mi = this.add(new JMenuItem("Unset Parent"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Node bNode;
                Graph bGraph;
                if (EditPopupMenu.this.gp == null || EditPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                if (EditPopupMenu.this.ego instanceof EdNode && (bGraph = (bNode = EditPopupMenu.this.ego.getNode().getBasisNode()).getContext()).isTypeGraph()) {
                    EditPopupMenu.this.mapping = true;
                    EditPopupMenu.this.setLastEditModeBeforMapping(EditPopupMenu.this.gp);
                    if (EditPopupMenu.this.editor != null) {
                        if (bNode.getType().getParents().size() == 1) {
                            bGraph.getTypeSet().removeAllInheritanceRelations(bNode.getType());
                            EditPopupMenu.this.graphEditor.getGraph().updateGraph();
                            EditPopupMenu.this.graphEditor.getGraphPanel().updateGraphics();
                        } else {
                            EditPopupMenu.this.editor.getGraphEditor().setEditMode(1202);
                            EditPopupMenu.this.editor.setMsg("Click on a parent node to remove this parent relation.");
                        }
                    }
                }
            }
        });
        this.miAbstract = (JCheckBoxMenuItem)this.add(new JCheckBoxMenuItem("Abstract"));
        this.miAbstract.setSelected(false);
        this.miAbstract.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditPopupMenu.this.gp == null || EditPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                if (EditPopupMenu.this.ego instanceof EdNode) {
                    if (((JCheckBoxMenuItem)e.getSource()).isSelected()) {
                        EditPopupMenu.this.ego.getBasisObject().getType().setAbstract(true);
                    } else {
                        EditPopupMenu.this.ego.getBasisObject().getType().setAbstract(false);
                    }
                    EditPopupMenu.this.gp.updateGraphics();
                }
            }
        });
        this.pack();
        this.setBorderPainted(true);
        EditPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    public void showMe(Component comp, int x, int y) {
        if (this.editor != null && this.editor.getRuleEditor().getRule() == null) {
            this.setUnmapEnabled(false);
        } else if (this.gp.getGraph() != null && this.gp.getGraph().isTypeGraph()) {
            this.setUnmapEnabled(false);
        }
        if (this.useDeleteMenu) {
            int indx = this.getComponentIndex(this.deleteMenu);
            if (indx == -1 && (indx = this.getComponentIndex(this.miDelete)) != -1) {
                this.add((Component)this.deleteMenu, indx + 1);
            }
        } else {
            int indx = this.getComponentIndex(this.deleteMenu);
            if (indx != -1) {
                this.remove(indx);
            }
        }
        this.show(comp, x, y);
    }

    private boolean canDoIt() {
        return this.gp != null && this.gp.getEditMode() != 9 && this.gp.getGraph() != null && this.ego != null;
    }

    private void doAfterDelete() {
        if (this.gp.wasMappedObjDeleted()) {
            this.gp.setMappedObjDeleted(false);
            if (this.editor != null) {
                this.editor.getRuleEditor().getRule().update();
                this.editor.getRuleEditor().getLeftPanel().updateGraphics();
                this.editor.getRuleEditor().getRightPanel().updateGraphics();
                this.editor.getRuleEditor().getNACPanel().updateGraphics();
                this.editor.getGraphEditor().getGraph().update();
                this.editor.getGraphEditor().getGraphPanel().updateGraphics();
            } else if (this.ruleEditor != null) {
                this.ruleEditor.getRule().update();
                this.ruleEditor.getLeftPanel().updateGraphics();
                this.ruleEditor.getRightPanel().updateGraphics();
                this.ruleEditor.getNACPanel().updateGraphics();
                if (this.graphEditor != null) {
                    this.graphEditor.getGraph().update();
                    this.graphEditor.getGraphPanel().updateGraphics();
                }
            } else if (this.graphEditor != null) {
                this.graphEditor.getGraph().update();
                this.graphEditor.getGraphPanel().updateGraphics();
            }
        } else {
            this.gp.getGraph().update();
            this.gp.updateGraphicsAfterDelete();
        }
    }

    private void showMessageDialog(Vector failed) {
        String str = "Cannot delete objects of this type from :\n";
        for (int i = 0; i < failed.size(); ++i) {
            String s = "\t" + (String)failed.get(i) + "\n";
            str = str + s;
        }
        if (!failed.isEmpty()) {
            JOptionPane.showMessageDialog(null, str);
        }
    }

    private JMenuItem createDeleteItem() {
        JMenuItem m = this.add(new JMenuItem("Delete"));
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDoIt()) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                if (!EditPopupMenu.this.ego.getMorphismMark().equals("")) {
                    EditPopupMenu.this.gp.setMappedObjDeleted(true);
                }
                EditPopupMenu.this.gp.deleteObj(EditPopupMenu.this.ego);
                EditPopupMenu.this.doAfterDelete();
            }
        });
        return m;
    }

    private JMenu createDeleteMenu() {
        JMenu m = new JMenu("Delete Objects of Type");
        JMenuItem jmi = m.add(new JMenuItem("Delete All Objects"));
        jmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDoIt()) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                Vector failed = EditPopupMenu.this.gp.getGraph().getGraGra().getBasisGraGra().destroyGraphObjectsOfType(EditPopupMenu.this.ego.getType().getBasisType(), false);
                EditPopupMenu.this.showMessageDialog(failed);
                EditPopupMenu.this.doAfterDelete();
                EditPopupMenu.this.gp.getGraph().getGraGra().update();
                if (EditPopupMenu.this.editor != null) {
                    EditPopupMenu.this.editor.getRuleEditor().updateGraphics();
                }
            }
        });
        jmi = m.add(new JMenuItem("Delete Objects of Host Graph"));
        jmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDoIt()) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                if (!EditPopupMenu.this.gp.getGraph().getGraGra().getBasisGraGra().destroyGraphObjectsOfTypeFromHostGraph(EditPopupMenu.this.ego.getType().getBasisType())) {
                    JOptionPane.showMessageDialog(null, "Cannot delete objects of this type from host graph.");
                }
                EditPopupMenu.this.doAfterDelete();
                EditPopupMenu.this.gp.getGraph().getGraGra().getGraph().update();
            }
        });
        return m;
    }

    public void setEditor(GraGraEditor ed) {
        this.editor = ed;
        this.ruleEditor = this.editor.getRuleEditor();
        this.graphEditor = this.editor.getGraphEditor();
    }

    public void setEditor(RuleEditor re) {
        this.ruleEditor = re;
        this.graphEditor = null;
    }

    public void setEditor(GraphEditor ge) {
        this.graphEditor = ge;
        this.ruleEditor = null;
    }

    public void setGraphLayouter(Layouter l) {
        this.layouter = l;
    }

    public EdGraphObject getPickedObj() {
        return this.ego;
    }

    public boolean isMapping() {
        return this.mapping;
    }

    public void setParentFrame(JFrame pf) {
        this.applFrame = pf;
    }

    public void setMapEnabled(boolean b) {
        this.miMap.setEnabled(b);
    }

    public void setUnmapEnabled(boolean b) {
        this.miUnmap.setEnabled(b);
    }

    public boolean invoked(GraphPanel p, int x, int y) {
        this.gp = p;
        if (this.gp.getGraph() != null) {
            Arc bArc;
            this.ego = this.gp.getGraph().getPicked(x, y);
            if (this.ego == null) {
                this.ego = this.gp.getGraph().getPickedTextOfArc(x, y, this.gp.getCanvas().getGraphics().getFontMetrics());
            }
            if (this.ego.isArc() && (bArc = this.ego.getArc().getBasisArc()).isInheritance()) {
                return false;
            }
            if (this.ego != null) {
                this.layout.setEnabled(false);
                if (this.ego.isNode()) {
                    this.miStraighten.setEnabled(false);
                    if (this.ego.isElementOfTypeGraph()) {
                        this.useDeleteMenu = true;
                        this.addIdentic.setEnabled(false);
                        this.miUnmap.setEnabled(false);
                        this.miMultiplicity.setEnabled(true);
                        this.miAbstract.setEnabled(true);
                        if (this.ego.getBasisObject().getType().isAbstract()) {
                            this.miAbstract.setSelected(true);
                        } else {
                            this.miAbstract.setSelected(false);
                        }
                        this.miSetParent.setEnabled(true);
                        if (!this.ego.getNode().getBasisNode().getType().getParents().isEmpty()) {
                            this.miUnsetParent.setEnabled(true);
                        } else {
                            this.miUnsetParent.setEnabled(false);
                        }
                        this.layout.setEnabled(true);
                        if (this.layouter != null) {
                            if (this.layouter.getLayoutPatternForType(this.ego.getBasisObject().getType(), "Freezing") != null) {
                                this.miFrozen.setSelected(true);
                            } else {
                                this.miFrozen.setSelected(false);
                            }
                        }
                    } else {
                        if (this.graphEditor != null && this.graphEditor.getGraphPanel() == this.gp) {
                            this.layout.setEnabled(true);
                        }
                        this.miFrozen.setSelected(((EdNode)this.ego).getLNode().isFrozen());
                        this.useDeleteMenu = false;
                        this.addIdentic.setEnabled(false);
                        this.miMultiplicity.setEnabled(false);
                        this.miAbstract.setEnabled(false);
                        this.miAbstract.setSelected(false);
                        this.miSetParent.setEnabled(false);
                        this.miUnsetParent.setEnabled(false);
                    }
                    if (this.ruleEditor != null && this.gp == this.ruleEditor.getLeftPanel()) {
                        this.addIdentic.setEnabled(true);
                    }
                } else {
                    this.miStraighten.setEnabled(true);
                    this.miSetParent.setEnabled(false);
                    this.miUnsetParent.setEnabled(false);
                    this.miAbstract.setEnabled(false);
                    this.miAbstract.setSelected(false);
                    if (this.ego.isElementOfTypeGraph()) {
                        this.useDeleteMenu = true;
                        this.addIdentic.setEnabled(false);
                        this.miUnmap.setEnabled(false);
                        this.miMultiplicity.setEnabled(true);
                    } else {
                        this.useDeleteMenu = false;
                        this.addIdentic.setEnabled(false);
                        this.miMultiplicity.setEnabled(false);
                    }
                    if (this.ruleEditor != null && this.gp == this.ruleEditor.getLeftPanel()) {
                        this.addIdentic.setEnabled(true);
                    }
                }
                if (!this.ego.isSelected()) {
                    this.xPos = x;
                    this.yPos = y;
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private void setLastEditModeBeforMapping(GraphPanel gp) {
        if (gp.getEditMode() == 11 || gp.getEditMode() == 113 || gp.getEditMode() == 12 || gp.getEditMode() == 13 || gp.getEditMode() == 114 || gp.getEditMode() == 31 || gp.getEditMode() == 81 || gp.getEditMode() == 42 || gp.getEditMode() == 115 || gp.getEditMode() == 116 || gp.getEditMode() == 1201 || gp.getEditMode() == 1202) {
            gp.setLastEditMode(gp.getEditMode());
            gp.setLastEditCursor(gp.getEditCursor());
        }
    }

    private void drawGraphic(EdGraphObject go, GraphPanel p) {
        if (go.isNode()) {
            p.getGraph().drawNode(p.getCanvas().getGraphics(), p.getCanvas().getScale(), (EdNode)go);
        } else {
            p.getGraph().drawArc(p.getCanvas().getGraphics(), p.getCanvas().getScale(), (EdArc)go);
        }
    }

    private void setCardinalityOfType() {
        if (this.ego != null) {
            this.multiplicity = !this.ego.isNode() ? new TypeCardinalityGUI(null, this.ego.getType().getBasisType(), ((EdArc)this.ego).getSource().getType().getBasisType(), ((EdArc)this.ego).getTarget().getType().getBasisType()) : new TypeCardinalityGUI(null, this.ego.getType().getBasisType());
            this.multiplicity.showGUI();
        }
    }
}

