/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.attribute.gui.AttrTopEditor;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.editor.impl.GraphPanel;
import agg.gui.GraGraEditor;
import agg.gui.GraphEditor;
import agg.gui.RuleEditor;
import agg.xt_basis.Graph;
import agg.xt_basis.Node;
import agg.xt_basis.Type;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class EditSelPopupMenu
extends JPopupMenu {
    private JFrame applFrame;
    private JMenuItem mi;
    private JMenuItem miDelete;
    private JMenuItem miMap;
    private JMenuItem miUnmap;
    private JMenuItem miStraighten;
    private JMenuItem miAddIdenticToRule;
    private JMenuItem miAddIdenticToNAC;
    private JMenuItem miSetParent;
    private JMenuItem miUnsetParent;
    private JMenu deleteMenu;
    private JMenu addIdentic;
    private boolean mapping = false;
    private GraGraEditor editor;
    private RuleEditor ruleEditor;
    private GraphEditor graphEditor;
    private GraphPanel gp;
    private EdGraphObject ego;
    private boolean useDeleteMenu = false;
    private Vector selectedTypes;

    public EditSelPopupMenu() {
        super("Operations");
        this.setLabel("Operations");
        this.setBorderPainted(true);
        this.deleteMenu = this.createDeleteMenu();
        this.useDeleteMenu = false;
        this.mi = this.add(new JMenuItem("   Operations   "));
        this.mi.setEnabled(false);
        this.addSeparator();
        this.mi = this.add(new JMenuItem("Attributes ..."));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9 || EditSelPopupMenu.this.gp.getGraph() == null || EditSelPopupMenu.this.ego == null) {
                    return;
                }
                EditSelPopupMenu.this.mapping = false;
                EditSelPopupMenu.this.gp.getCanvas().saveScrollBarValue();
                AttrTopEditor attrEditor = EditSelPopupMenu.this.editor.getAttrEditor(EditSelPopupMenu.this.ego);
                if (EditSelPopupMenu.this.ruleEditor == null) {
                    attrEditor.enableContextEditor(false);
                    EditSelPopupMenu.this.editor.setAttrEditorOnTop(attrEditor.getComponent());
                } else {
                    attrEditor.enableContextEditor(true);
                    EditSelPopupMenu.this.editor.setAttrEditorOnBottom(attrEditor.getComponent());
                }
                EditSelPopupMenu.this.gp.updateGraphics();
            }
        });
        this.addSeparator();
        this.mi = this.add(new JMenuItem("Copy Selected"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9 || EditSelPopupMenu.this.gp.getGraph() == null) {
                    return;
                }
                EditSelPopupMenu.this.mapping = false;
                if (EditSelPopupMenu.this.gp.getGraph().hasSelection()) {
                    EditSelPopupMenu.this.gp.setLastEditMode(EditSelPopupMenu.this.gp.getEditMode());
                    EditSelPopupMenu.this.gp.setLastEditCursor(EditSelPopupMenu.this.gp.getEditCursor());
                    EditSelPopupMenu.this.gp.setEditMode(15);
                    EditSelPopupMenu.this.applFrame.setCursor(new Cursor(1));
                    if (EditSelPopupMenu.this.editor != null) {
                        EditSelPopupMenu.this.editor.setMsg("To get a copy click on the background of the same panel.");
                    }
                }
            }
        });
        this.mi = this.add(new JMenuItem("Deselect"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditSelPopupMenu.this.mapping = false;
                if (EditSelPopupMenu.this.gp != null && EditSelPopupMenu.this.gp.getGraph() != null && EditSelPopupMenu.this.ego != null) {
                    EditSelPopupMenu.this.gp.getGraph().deselect(EditSelPopupMenu.this.ego);
                    EditSelPopupMenu.this.gp.updateGraphics();
                }
            }
        });
        this.mi = this.add(new JMenuItem("Deselect All"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditSelPopupMenu.this.mapping = false;
                if (EditSelPopupMenu.this.gp != null && EditSelPopupMenu.this.gp.getGraph() != null) {
                    EditSelPopupMenu.this.gp.getGraph().deselectAll();
                    EditSelPopupMenu.this.gp.updateGraphics();
                }
            }
        });
        this.addSeparator();
        this.miDelete = this.createDeleteItem();
        this.deleteMenu = this.createDeleteMenu();
        this.add(this.miDelete);
        if (this.useDeleteMenu) {
            this.add(this.deleteMenu);
        }
        this.addSeparator();
        this.miStraighten = this.mi = this.add(new JMenuItem("Straighten Selected"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9 || EditSelPopupMenu.this.gp.getGraph() == null) {
                    return;
                }
                EditSelPopupMenu.this.mapping = false;
                EditSelPopupMenu.this.gp.getGraph().straightSelectedArcs();
                EditSelPopupMenu.this.gp.updateGraphics();
            }
        });
        this.addSeparator();
        this.addIdentic = new JMenu("Add Identic To");
        this.add(this.addIdentic);
        this.miAddIdenticToRule = this.mi = this.addIdentic.add(new JMenuItem("Rule"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                if (EditSelPopupMenu.this.ruleEditor != null && EditSelPopupMenu.this.gp == EditSelPopupMenu.this.ruleEditor.getLeftPanel()) {
                    EditSelPopupMenu.this.ruleEditor.getRule().addIdenticToRule(EditSelPopupMenu.this.ruleEditor.getRule().getLeft().getSelectedObjs());
                    EditSelPopupMenu.this.ruleEditor.updateGraphics();
                }
            }
        });
        this.miAddIdenticToNAC = this.mi = this.addIdentic.add(new JMenuItem("NAC"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                if (EditSelPopupMenu.this.ruleEditor != null && EditSelPopupMenu.this.gp == EditSelPopupMenu.this.ruleEditor.getLeftPanel()) {
                    EditSelPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(EditSelPopupMenu.this.ruleEditor.getRule().getLeft().getSelectedObjs(), EditSelPopupMenu.this.ruleEditor.getNAC());
                    EditSelPopupMenu.this.ruleEditor.updateGraphics();
                }
            }
        });
        this.miMap = this.mi = this.add(new JMenuItem("Map Selected"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                EditSelPopupMenu.this.mapping = true;
                EditSelPopupMenu.this.setLastEditModeBeforMapping(EditSelPopupMenu.this.gp);
                if (EditSelPopupMenu.this.editor != null) {
                    EditSelPopupMenu.this.editor.getGraphEditor().setEditMode(117);
                    EditSelPopupMenu.this.editor.getRuleEditor().setEditMode(117);
                    EditSelPopupMenu.this.editor.getRuleEditor().setObjMapping(true);
                    EditSelPopupMenu.this.editor.setMsg("Click on a target object you want to map or click on the background you want to break the mapping.");
                } else if (EditSelPopupMenu.this.ruleEditor != null) {
                    EditSelPopupMenu.this.ruleEditor.setEditMode(117);
                    EditSelPopupMenu.this.ruleEditor.setObjMapping(true);
                    EditSelPopupMenu.this.ruleEditor.setMsg("Click on on a target object you want to map or click on the background you want to break the mapping.");
                }
            }
        });
        this.miUnmap = this.mi = this.add(new JMenuItem("Unmap Selected"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                EditSelPopupMenu.this.mapping = false;
                if (EditSelPopupMenu.this.editor != null && EditSelPopupMenu.this.editor.getRuleEditor().getRule() != null) {
                    if (EditSelPopupMenu.this.editor.getActivePanel() == EditSelPopupMenu.this.editor.getRuleEditor().getLeftPanel()) {
                        for (int i = 0; i < EditSelPopupMenu.this.editor.getRuleEditor().getRule().getLeft().getSelectedObjs().size(); ++i) {
                            EdGraphObject originalObj = (EdGraphObject)EditSelPopupMenu.this.editor.getRuleEditor().getRule().getLeft().getSelectedObjs().elementAt(i);
                            EditSelPopupMenu.this.editor.getRuleEditor().getRule().removeRuleMapping(originalObj);
                            if (EditSelPopupMenu.this.editor.getRuleEditor().getNAC() != null) {
                                EditSelPopupMenu.this.editor.getRuleEditor().getRule().removeNACMapping(originalObj, EditSelPopupMenu.this.editor.getRuleEditor().getNAC().getMorphism());
                            }
                            EditSelPopupMenu.this.editor.getRuleEditor().getRule().removeMatchMapping(originalObj);
                        }
                        EditSelPopupMenu.this.editor.getRuleEditor().getRule().update();
                        EditSelPopupMenu.this.editor.updateGraphics();
                    } else if (EditSelPopupMenu.this.editor.getActivePanel() == EditSelPopupMenu.this.editor.getRuleEditor().getRightPanel()) {
                        for (int i = 0; i < EditSelPopupMenu.this.editor.getRuleEditor().getRule().getRight().getSelectedObjs().size(); ++i) {
                            EdGraphObject imageObj = (EdGraphObject)EditSelPopupMenu.this.editor.getRuleEditor().getRule().getRight().getSelectedObjs().elementAt(i);
                            EditSelPopupMenu.this.editor.getRuleEditor().getRule().removeMapping(imageObj, EditSelPopupMenu.this.editor.getRuleEditor().getRule().getBasisRule());
                        }
                        EditSelPopupMenu.this.editor.getRuleEditor().updateGraphics();
                    } else if (EditSelPopupMenu.this.editor.getActivePanel() == EditSelPopupMenu.this.editor.getRuleEditor().getNACPanel()) {
                        for (int i = 0; i < EditSelPopupMenu.this.editor.getRuleEditor().getNAC().getSelectedObjs().size(); ++i) {
                            EdGraphObject imageObj = (EdGraphObject)EditSelPopupMenu.this.editor.getRuleEditor().getNAC().getSelectedObjs().elementAt(i);
                            EditSelPopupMenu.this.editor.getRuleEditor().getRule().removeMapping(imageObj, EditSelPopupMenu.this.editor.getRuleEditor().getNAC().getMorphism());
                        }
                        EditSelPopupMenu.this.editor.getRuleEditor().getLeftPanel().updateGraphics();
                        EditSelPopupMenu.this.editor.getRuleEditor().getNACPanel().updateGraphics();
                    } else if (EditSelPopupMenu.this.editor.getActivePanel() == EditSelPopupMenu.this.editor.getGraphEditor().getGraphPanel()) {
                        for (int i = 0; i < EditSelPopupMenu.this.editor.getGraphEditor().getGraph().getSelectedObjs().size(); ++i) {
                            EdGraphObject imageObj = (EdGraphObject)EditSelPopupMenu.this.editor.getGraphEditor().getGraph().getSelectedObjs().elementAt(i);
                            EditSelPopupMenu.this.editor.getRuleEditor().getRule().removeMapping(imageObj, EditSelPopupMenu.this.editor.getRuleEditor().getRule().getMatch());
                        }
                        EditSelPopupMenu.this.editor.getRuleEditor().getLeftPanel().updateGraphics();
                        EditSelPopupMenu.this.editor.getGraphEditor().getGraphPanel().updateGraphics();
                    }
                } else if (EditSelPopupMenu.this.ruleEditor != null && EditSelPopupMenu.this.ruleEditor.getRule() != null) {
                    if (EditSelPopupMenu.this.gp == EditSelPopupMenu.this.ruleEditor.getLeftPanel()) {
                        for (int i = 0; i < EditSelPopupMenu.this.ruleEditor.getRule().getLeft().getSelectedObjs().size(); ++i) {
                            EdGraphObject originalObj = (EdGraphObject)EditSelPopupMenu.this.ruleEditor.getRule().getLeft().getSelectedObjs().elementAt(i);
                            EditSelPopupMenu.this.ruleEditor.getRule().removeRuleMapping(originalObj);
                            if (EditSelPopupMenu.this.ruleEditor.getNAC() != null) {
                                EditSelPopupMenu.this.ruleEditor.getRule().removeNACMapping(originalObj, EditSelPopupMenu.this.ruleEditor.getNAC().getMorphism());
                            }
                            EditSelPopupMenu.this.ruleEditor.getRule().removeMatchMapping(originalObj);
                        }
                        EditSelPopupMenu.this.ruleEditor.getRule().update();
                        EditSelPopupMenu.this.ruleEditor.updateGraphics();
                        if (EditSelPopupMenu.this.graphEditor != null) {
                            EditSelPopupMenu.this.graphEditor.getGraphPanel().updateGraphics();
                        }
                    } else if (EditSelPopupMenu.this.gp == EditSelPopupMenu.this.ruleEditor.getRightPanel()) {
                        for (int i = 0; i < EditSelPopupMenu.this.ruleEditor.getRule().getRight().getSelectedObjs().size(); ++i) {
                            EdGraphObject imageObj = (EdGraphObject)EditSelPopupMenu.this.ruleEditor.getRule().getRight().getSelectedObjs().elementAt(i);
                            EditSelPopupMenu.this.ruleEditor.getRule().removeMapping(imageObj, EditSelPopupMenu.this.ruleEditor.getRule().getBasisRule());
                        }
                        EditSelPopupMenu.this.ruleEditor.updateGraphics();
                    } else if (EditSelPopupMenu.this.gp == EditSelPopupMenu.this.ruleEditor.getNACPanel()) {
                        for (int i = 0; i < EditSelPopupMenu.this.ruleEditor.getNAC().getSelectedObjs().size(); ++i) {
                            EdGraphObject imageObj = (EdGraphObject)EditSelPopupMenu.this.ruleEditor.getNAC().getSelectedObjs().elementAt(i);
                            EditSelPopupMenu.this.ruleEditor.getRule().removeMapping(imageObj, EditSelPopupMenu.this.ruleEditor.getNAC().getMorphism());
                        }
                        EditSelPopupMenu.this.ruleEditor.getLeftPanel().updateGraphics();
                        EditSelPopupMenu.this.ruleEditor.getNACPanel().updateGraphics();
                    }
                } else if (EditSelPopupMenu.this.graphEditor != null && EditSelPopupMenu.this.gp == EditSelPopupMenu.this.graphEditor.getGraphPanel()) {
                    for (int i = 0; i < EditSelPopupMenu.this.graphEditor.getGraph().getSelectedObjs().size(); ++i) {
                        EdGraphObject imageObj = (EdGraphObject)EditSelPopupMenu.this.graphEditor.getGraph().getSelectedObjs().elementAt(i);
                        if (EditSelPopupMenu.this.ruleEditor == null) continue;
                        EditSelPopupMenu.this.ruleEditor.getRule().removeMapping(imageObj, EditSelPopupMenu.this.ruleEditor.getRule().getMatch());
                    }
                    if (EditSelPopupMenu.this.ruleEditor != null) {
                        EditSelPopupMenu.this.ruleEditor.getLeftPanel().updateGraphics();
                    }
                    EditSelPopupMenu.this.graphEditor.getGraphPanel().updateGraphics();
                }
            }
        });
        this.addSeparator();
        this.miSetParent = this.mi = this.add(new JMenuItem("Set Parent"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                if (EditSelPopupMenu.this.ego instanceof EdNode) {
                    Node node = EditSelPopupMenu.this.ego.getNode().getBasisNode();
                }
                EditSelPopupMenu.this.mapping = true;
                EditSelPopupMenu.this.setLastEditModeBeforMapping(EditSelPopupMenu.this.gp);
                if (EditSelPopupMenu.this.editor != null) {
                    EditSelPopupMenu.this.editor.getGraphEditor().setEditMode(1201);
                }
            }
        });
        this.miUnsetParent = this.mi = this.add(new JMenuItem("Unset Parent"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Node bNode;
                Graph bGraph;
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                if (EditSelPopupMenu.this.ego instanceof EdNode && (bGraph = (bNode = EditSelPopupMenu.this.ego.getNode().getBasisNode()).getContext()).isTypeGraph()) {
                    bGraph.getTypeSet().addInheritanceRelation(bNode.getType(), null);
                    if (EditSelPopupMenu.this.graphEditor != null) {
                        EditSelPopupMenu.this.graphEditor.getGraph().updateGraph();
                        EditSelPopupMenu.this.graphEditor.getGraphPanel().updateGraphics();
                        EditSelPopupMenu.this.editor.getGraphEditor().getGraphPanel().updateGraphics();
                    }
                }
                EditSelPopupMenu.this.setLastEditModeBeforMapping(EditSelPopupMenu.this.gp);
            }
        });
        this.pack();
        this.setBorderPainted(true);
    }

    public void showMe(Component comp, int x, int y) {
        if (this.editor != null) {
            if (this.editor.getRuleEditor().getRule() == null) {
                this.setUnmapEnabled(false);
            }
            if (this.gp.getGraph() != null && this.gp.getGraph().isTypeGraph()) {
                this.setUnmapEnabled(false);
            }
        }
        if (this.useDeleteMenu) {
            int indx = this.getComponentIndex(this.deleteMenu);
            if (indx == -1 && (indx = this.getComponentIndex(this.miDelete)) != -1) {
                this.add((Component)this.deleteMenu, indx + 1);
            }
        } else {
            int indx = this.getComponentIndex(this.deleteMenu);
            if (indx != -1) {
                this.remove(indx);
            }
        }
        this.show(comp, x, y);
    }

    private boolean canDo() {
        return this.gp != null && this.gp.getEditMode() != 9 && this.gp.getGraph() != null;
    }

    private void doAfterDelete() {
        if (this.gp.wasMappedObjDeleted()) {
            this.gp.setMappedObjDeleted(false);
            if (this.editor != null) {
                this.editor.getRuleEditor().getRule().update();
                this.editor.getRuleEditor().getLeftPanel().updateGraphics();
                this.editor.getRuleEditor().getRightPanel().updateGraphics();
                this.editor.getRuleEditor().getNACPanel().updateGraphics();
                this.editor.getGraphEditor().getGraph().update();
                this.editor.getGraphEditor().getGraphPanel().updateGraphics();
            } else if (this.ruleEditor != null) {
                this.ruleEditor.getRule().update();
                this.ruleEditor.getLeftPanel().updateGraphics();
                this.ruleEditor.getRightPanel().updateGraphics();
                this.ruleEditor.getNACPanel().updateGraphics();
                if (this.graphEditor != null) {
                    this.graphEditor.getGraph().update();
                    this.graphEditor.getGraphPanel().updateGraphics();
                }
            } else if (this.graphEditor != null) {
                this.graphEditor.getGraph().update();
                this.graphEditor.getGraphPanel().updateGraphics();
            }
        } else {
            this.gp.getGraph().update();
            this.gp.updateGraphicsAfterDelete();
        }
    }

    private void showMessageDialog(Vector failed) {
        String str = "Cannot delete objects of this type from :\n";
        for (int i = 0; i < failed.size(); ++i) {
            String s = "\t" + (String)failed.get(i) + "\n";
            str = str + s;
        }
        if (!failed.isEmpty()) {
            JOptionPane.showMessageDialog(null, str);
        }
    }

    private JMenuItem createDeleteItem() {
        JMenuItem m = this.add(new JMenuItem("Delete Selected"));
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int answer;
                if (!EditSelPopupMenu.this.canDo()) {
                    return;
                }
                if (EditSelPopupMenu.this.gp.getGraph().hasSelection() && (answer = EditSelPopupMenu.this.removeWarning()) == 0) {
                    for (int i = 0; i < EditSelPopupMenu.this.gp.getGraph().getSelectedObjs().size(); ++i) {
                        EdGraphObject go = (EdGraphObject)EditSelPopupMenu.this.gp.getGraph().getSelectedObjs().elementAt(i);
                        if (go.getMorphismMark().equals("")) continue;
                        EditSelPopupMenu.this.gp.setMappedObjDeleted(true);
                    }
                    EditSelPopupMenu.this.gp.deleteSelected();
                    EditSelPopupMenu.this.doAfterDelete();
                }
            }
        });
        return m;
    }

    private Vector getSelectedTypes(Vector selectedGraphObjects) {
        Vector<Type> v = new Vector<Type>(5);
        for (int i = 0; i < selectedGraphObjects.size(); ++i) {
            EdGraphObject go = (EdGraphObject)selectedGraphObjects.get(i);
            Type t = go.getBasisObject().getType();
            if (v.contains(t)) continue;
            v.add(t);
        }
        return v;
    }

    private JMenu createDeleteMenu() {
        JMenu m = new JMenu("Delete Objects of Selected Types");
        JMenuItem jmi = m.add(new JMenuItem("Delete All Objects"));
        jmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!EditSelPopupMenu.this.canDo()) {
                    return;
                }
                EditSelPopupMenu.this.mapping = false;
                if (EditSelPopupMenu.this.gp.getGraph().hasSelection()) {
                    Vector selectedTypes = EditSelPopupMenu.this.getSelectedTypes(EditSelPopupMenu.this.gp.getGraph().getSelectedObjs());
                    Vector failed = EditSelPopupMenu.this.gp.getGraph().getGraGra().getBasisGraGra().destroyGraphObjectsOfTypes(selectedTypes, false);
                    EditSelPopupMenu.this.showMessageDialog(failed);
                }
                EditSelPopupMenu.this.doAfterDelete();
                EditSelPopupMenu.this.gp.getGraph().getGraGra().update();
                if (EditSelPopupMenu.this.editor != null) {
                    EditSelPopupMenu.this.editor.getRuleEditor().updateGraphics();
                }
            }
        });
        jmi = m.add(new JMenuItem("Delete Objects of Host Graph"));
        jmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!EditSelPopupMenu.this.canDo()) {
                    return;
                }
                EditSelPopupMenu.this.mapping = false;
                if (EditSelPopupMenu.this.gp.getGraph().hasSelection()) {
                    Vector selectedTypes = EditSelPopupMenu.this.getSelectedTypes(EditSelPopupMenu.this.gp.getGraph().getSelectedObjs());
                    Vector failed = EditSelPopupMenu.this.gp.getGraph().getGraGra().getBasisGraGra().destroyGraphObjectsOfTypesFromHostGraph(selectedTypes);
                    EditSelPopupMenu.this.showMessageDialog(failed);
                }
                EditSelPopupMenu.this.doAfterDelete();
                EditSelPopupMenu.this.gp.getGraph().getGraGra().getGraph().update();
            }
        });
        return m;
    }

    public void setEditor(GraGraEditor ed) {
        this.editor = ed;
        this.ruleEditor = this.editor.getRuleEditor();
        this.graphEditor = this.editor.getGraphEditor();
    }

    public void setEditor(RuleEditor re) {
        this.ruleEditor = re;
        this.graphEditor = null;
    }

    public void setEditor(GraphEditor ge) {
        this.graphEditor = ge;
        this.ruleEditor = null;
    }

    public EdGraphObject getPickedObj() {
        return this.ego;
    }

    public boolean isMapping() {
        return this.mapping;
    }

    public void setParentFrame(JFrame pf) {
        this.applFrame = pf;
    }

    public void setMapEnabled(boolean b) {
        this.miMap.setEnabled(b);
    }

    public void setUnmapEnabled(boolean b) {
        this.miUnmap.setEnabled(b);
    }

    public boolean invoked(GraphPanel p, int x, int y) {
        this.gp = p;
        if (this.gp.getGraph() != null) {
            this.ego = this.gp.getGraph().getPicked(x, y);
            if (this.ego == null) {
                this.ego = this.gp.getGraph().getPickedTextOfArc(x, y, this.gp.getCanvas().getGraphics().getFontMetrics());
            }
            if (this.ego != null && this.ego.isSelected()) {
                if (this.ego.isNode()) {
                    this.miStraighten.setEnabled(false);
                    if (this.ego.isElementOfTypeGraph()) {
                        this.useDeleteMenu = true;
                        this.addIdentic.setEnabled(false);
                        this.miSetParent.setEnabled(true);
                        if (!this.ego.getNode().getBasisNode().getType().getParents().isEmpty()) {
                            this.miUnsetParent.setEnabled(true);
                        } else {
                            this.miUnsetParent.setEnabled(false);
                        }
                    } else {
                        this.useDeleteMenu = false;
                        this.addIdentic.setEnabled(false);
                        this.miSetParent.setEnabled(false);
                        this.miUnsetParent.setEnabled(false);
                    }
                    if (this.ruleEditor != null && this.gp == this.ruleEditor.getLeftPanel()) {
                        this.addIdentic.setEnabled(true);
                    }
                } else {
                    this.miStraighten.setEnabled(true);
                    this.miSetParent.setEnabled(false);
                    this.miUnsetParent.setEnabled(false);
                    if (this.ego.isElementOfTypeGraph()) {
                        this.useDeleteMenu = true;
                        this.addIdentic.setEnabled(false);
                    } else {
                        this.useDeleteMenu = false;
                        this.addIdentic.setEnabled(false);
                    }
                    if (this.ruleEditor != null && this.gp == this.ruleEditor.getLeftPanel()) {
                        this.addIdentic.setEnabled(true);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void setLastEditModeBeforMapping(GraphPanel gp) {
        if (gp.getEditMode() == 11 || gp.getEditMode() == 113 || gp.getEditMode() == 12 || gp.getEditMode() == 13 || gp.getEditMode() == 114 || gp.getEditMode() == 31 || gp.getEditMode() == 81 || gp.getEditMode() == 42 || gp.getEditMode() == 115 || gp.getEditMode() == 116) {
            gp.setLastEditMode(gp.getEditMode());
            gp.setLastEditCursor(gp.getEditCursor());
        }
    }

    private int removeWarning() {
        String msgStr = "Do you really want to delete all \nselected objects of this graph?";
        Object[] options = new Object[]{"YES", "NO"};
        int answer = JOptionPane.showOptionDialog(null, msgStr, "Warning", -1, 2, null, options, options[1]);
        return answer;
    }
}

