/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.cons.Formula;
import agg.editor.impl.EdGraGra;
import agg.gui.HtmlBrowser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class GraGraConstraintLayerGUI
extends JDialog
implements ActionListener {
    private JPanel contentPane;
    private JPanel constraintPanel;
    private JPanel buttonPanel;
    private JScrollPane scrollPane;
    private JTable constraintTable;
    private JButton closeButton;
    private JButton cancelButton;
    private JButton helpButton;
    private boolean isCancelled;
    private Vector constraints;
    private Vector layers;
    private EdGraGra gragra;
    private HtmlBrowser helpBrowser;

    public GraGraConstraintLayerGUI(JFrame parent, Vector constraints, Vector layersAsString) {
        super((Frame)parent, true);
        this.setTitle("Select Layer");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GraGraConstraintLayerGUI.this.exitForm(evt);
            }
        });
        this.constraints = constraints;
        this.layers = new Vector(layersAsString.size());
        for (int i = layersAsString.size() - 1; i >= 0; --i) {
            this.layers.add((String)layersAsString.get(i));
        }
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        } else {
            this.setLocation(300, 100);
        }
        this.initComponents();
    }

    private void initComponents() {
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setBackground(Color.lightGray);
        this.constraintPanel = new JPanel(new BorderLayout());
        this.constraintPanel.setBackground(Color.orange);
        this.constraintPanel.setBorder(new TitledBorder("Set Layer for Graph Constraint"));
        this.constraintTable = new JTable(new HashTableModel(this.constraints, this.layers));
        this.constraintTable.setRowSelectionAllowed(true);
        this.constraintTable.setColumnSelectionAllowed(true);
        Color selColor = this.constraintTable.getSelectionBackground();
        this.constraintTable.setSelectionBackground(Color.WHITE);
        for (int i = 1; i < this.constraintTable.getColumnCount(); ++i) {
            TableColumn column = this.constraintTable.getColumn(this.constraintTable.getColumnName(i));
            column.setMaxWidth(30);
            LayerCellRenderer lcr = new LayerCellRenderer(i, this.constraintTable.getRowCount(), this.constraintTable, selColor);
            column.setCellRenderer(lcr);
        }
        this.constraintTable.getSelectionModel().setSelectionMode(2);
        int hght = this.getHeight(this.constraintTable.getRowCount(), this.constraintTable.getRowHeight()) + 10;
        this.constraintTable.doLayout();
        this.scrollPane = new JScrollPane(this.constraintTable);
        this.scrollPane.setPreferredSize(new Dimension(300, hght));
        this.constraintPanel.add(this.scrollPane);
        this.buttonPanel = new JPanel(new GridLayout(0, 3, 5, 5));
        this.closeButton = new JButton();
        this.closeButton.setActionCommand("close");
        this.closeButton.setText("Close");
        this.closeButton.setToolTipText("Accept entries and close dialog.");
        this.closeButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.isCancelled = false;
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setText("Cancel");
        this.closeButton.setToolTipText("Reject entries and close dialog.");
        this.cancelButton.addActionListener(this);
        this.helpButton = new JButton();
        this.helpButton.setActionCommand("help");
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(this.helpButton);
        this.contentPane.add((Component)this.constraintPanel, "Center");
        this.contentPane.add((Component)this.buttonPanel, "South");
        this.contentPane.revalidate();
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(0);
        this.validate();
        this.pack();
    }

    private void exitForm(WindowEvent evt) {
        if (this.helpBrowser != null) {
            this.helpBrowser.setVisible(false);
            this.helpBrowser.dispose();
        }
        this.setVisible(false);
        this.dispose();
    }

    public void showGUI() {
        this.setVisible(true);
    }

    private void acceptValues() {
        Hashtable table = ((HashTableModel)this.constraintTable.getModel()).getTable();
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Vector l = (Vector)table.get(key);
            Vector<Integer> v = new Vector<Integer>(l.size());
            for (int i = 0; i < l.size(); ++i) {
                String s = (String)l.get(i);
                if (s.equals("")) continue;
                v.add(new Integer(s));
            }
            ((Formula)key).setLayer(v);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeButton) {
            this.acceptValues();
            this.setVisible(false);
            if (this.helpBrowser != null) {
                this.helpBrowser.setVisible(false);
                this.helpBrowser.dispose();
            }
            this.dispose();
        } else if (source == this.cancelButton) {
            this.isCancelled = true;
            this.setVisible(false);
            if (this.helpBrowser != null) {
                this.helpBrowser.setVisible(false);
                this.helpBrowser.dispose();
            }
            this.dispose();
        } else if (source == this.helpButton) {
            if (this.helpBrowser != null) {
                this.helpBrowser.dispose();
                this.helpBrowser = null;
            }
            if (this.helpBrowser == null) {
                this.helpBrowser = new HtmlBrowser("ConstraintForLayerHelp.html");
                this.helpBrowser.setSize(500, 300);
                this.helpBrowser.setLocation(50, 50);
            }
        }
    }

    public void setGraGra(EdGraGra gra) {
        this.gragra = gra;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    private int getHeight(int rowCount, int rowHeight) {
        int h = (rowCount + 1) * rowHeight;
        if (rowCount > 10) {
            h = 12 * rowHeight;
        }
        return h;
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    public class LayerCellRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer,
    MouseListener {
        Vector checks;
        int column;
        Color selColor = Color.WHITE;
        public final JTable jtable;

        public LayerCellRenderer(int indx, int size, JTable table, Color selColor) {
            this.addMouseListener(this);
            this.jtable = table;
            this.jtable.addMouseListener(this);
            this.checks = new Vector(size);
            this.column = indx;
            this.initLayers(indx, size);
        }

        private void initLayers(int indx, int size) {
            for (int i = 0; i < size; ++i) {
                JCheckBox cb = new JCheckBox("", false);
                cb.setBackground(Color.WHITE);
                this.checks.addElement(cb);
                Object value = ((DefaultTableModel)this.jtable.getModel()).getValueAt(i, indx);
                if (((String)value).equals("")) continue;
                cb.setSelected(true);
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JCheckBox jcb = (JCheckBox)this.checks.get(row);
            return jcb;
        }

        public void mouseClicked(MouseEvent e) {
            for (int i = 0; i < this.checks.size(); ++i) {
                JCheckBox cb = (JCheckBox)this.checks.get(i);
                if (!this.jtable.isCellSelected(i, this.column)) continue;
                cb.setSelected(!cb.isSelected());
                if (cb.isSelected()) {
                    cb.setBackground(this.selColor);
                    ((DefaultTableModel)this.jtable.getModel()).setValueAt(this.jtable.getColumnName(this.column), i, this.column);
                } else {
                    cb.setBackground(Color.WHITE);
                    ((DefaultTableModel)this.jtable.getModel()).setValueAt("", i, this.column);
                }
                Object newValue = ((DefaultTableModel)this.jtable.getModel()).getValueAt(i, this.column);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public Vector getChecks() {
            return this.checks;
        }
    }

    public class HashTableModel
    extends DefaultTableModel {
        Hashtable table;

        public HashTableModel(Vector constraints, Vector layers) {
            int i;
            layers.add(0, "Constraint / Layer");
            for (i = 0; i < layers.size(); ++i) {
                this.addColumn((String)layers.get(i));
            }
            this.table = new Hashtable(constraints.size());
            for (i = 0; i < constraints.size(); ++i) {
                Formula f = (Formula)constraints.get(i);
                Vector value = f.getLayer();
                Vector<Object> tmpVector = new Vector<Object>();
                for (int k = 1; k < layers.size(); ++k) {
                    String l = (String)layers.get(k);
                    boolean found = false;
                    for (int j = 0; j < value.size(); ++j) {
                        Integer v = (Integer)value.get(j);
                        if (v.intValue() != new Integer(l).intValue()) continue;
                        tmpVector.addElement(l);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    tmpVector.addElement("");
                }
                this.table.put(f, (Vector)tmpVector.clone());
                tmpVector.add(0, f);
                this.addRow(tmpVector);
            }
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Object getValueAt(int row, int column) {
            Object result = super.getValueAt(row, column);
            if (result instanceof Formula) {
                result = ((Formula)result).getName();
            } else {
                Object key = super.getValueAt(row, 0);
                if (key instanceof Formula) {
                    Vector v = (Vector)this.table.get(key);
                    result = column - 1 < v.size() ? (String)v.get(column - 1) : "";
                }
            }
            return result;
        }

        public void setValueAt(Object aValue, int row, int column) {
            Object key = super.getValueAt(row, 0);
            try {
                super.setValueAt((String)aValue, row, column);
                Vector v = (Vector)this.table.get(key);
                v.remove(column - 1);
                v.add(column - 1, (String)aValue);
                this.table.put(key, v);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }

        public Hashtable getTable() {
            return this.table;
        }

        public Formula getConstraint(String name) {
            Enumeration e = this.table.keys();
            while (e.hasMoreElements()) {
                Formula key = (Formula)e.nextElement();
                if (!key.getName().equals(name)) continue;
                return key;
            }
            return null;
        }

        public int getRow(Formula constraint) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                String rname = (String)this.getValueAt(i, 0);
                Formula f = this.getConstraint(rname);
                if (f == null || !f.equals(constraint)) continue;
                return i;
            }
            return -1;
        }
    }
}

