/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.attribute.AttrContext;
import agg.attribute.AttrVariableTuple;
import agg.attribute.facade.EditorFacade;
import agg.attribute.facade.impl.DefaultEditorFacade;
import agg.attribute.gui.AttrTopEditor;
import agg.attribute.gui.AttrTupleEditor;
import agg.attribute.gui.impl.BasicTupleEditor;
import agg.attribute.gui.impl.TopEditor;
import agg.attribute.gui.impl.TupleTableModel;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.view.impl.MaskedViewSetting;
import agg.attribute.view.impl.OpenViewSetting;
import agg.cons.AtomApplCond;
import agg.cons.AtomConstraint;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdAtomApplCond;
import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdType;
import agg.editor.impl.GraphPanel;
import agg.gui.AGGAppl;
import agg.gui.AGGToolBar;
import agg.gui.EditPopupMenu;
import agg.gui.EditSelPopupMenu;
import agg.gui.GraGraPrint;
import agg.gui.GraGraTransform;
import agg.gui.GraGraTreeNodeData;
import agg.gui.GraTraOptionGUI;
import agg.gui.GraphEditor;
import agg.gui.GraphLayouterOptionGUI;
import agg.gui.GraphicsExportJPEG;
import agg.gui.ModePopupMenu;
import agg.gui.RuleEditor;
import agg.gui.TransformInterpret;
import agg.gui.TransformLayered;
import agg.gui.TypeEditor;
import agg.gui.cons.TwoMorphs;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import agg.gui.event.TransformEvent;
import agg.gui.event.TransformEventListener;
import agg.gui.event.TreeViewEvent;
import agg.gui.event.TreeViewEventListener;
import agg.gui.event.TypeEvent;
import agg.gui.event.TypeEventListener;
import agg.gui.icons.CompletionIcon;
import agg.gui.icons.DeselectAllIcon;
import agg.gui.icons.MatchIcon;
import agg.gui.icons.SelectAllIcon;
import agg.gui.icons.SelectArcTypeIcon;
import agg.gui.icons.SelectNodeTypeIcon;
import agg.gui.icons.StartIcon;
import agg.gui.icons.StepIcon;
import agg.gui.icons.StopIcon;
import agg.gui.icons.TextIcon;
import agg.layout.LayoutMetrics;
import agg.layout.Layouter;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Rule;
import com.objectspace.jgl.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraGraEditor
extends JPanel
implements ActionListener,
TreeModelListener,
TableModelListener,
TreeViewEventListener,
TransformEventListener,
TypeEventListener {
    public static final int[] fontSizeArray = new int[]{12, 10, 8, 0};
    public static final double[] scaleArray = new double[]{1.5, 1.0, 0.7, 0.5};
    private JFrame applFrame;
    private AGGToolBar toolBar;
    private KeyAdapter keyAdapter;
    private String typedKey;
    private JSplitPane splitPane0;
    private JSplitPane splitPane;
    private JSplitPane splitPane1;
    private Vector mainMenus;
    private JMenu edit;
    private JMenu mode;
    private JMenu transform;
    private ModePopupMenu modePopupMenu;
    private EditPopupMenu editPopupMenu;
    private EditSelPopupMenu editSelPopupMenu;
    private int editmode;
    private int lasteditmode = 11;
    private TypeEditor typeEditor;
    private RuleEditor ruleEditor;
    private GraphEditor graphEditor;
    private AttrTopEditor attrEditor;
    private boolean attrTypeChanged;
    private AttrTupleEditor inputParameterEditor;
    private int dividerLocation;
    private Hashtable dividerLocationSet;
    private int dividerLocation1;
    private TwoMorphs pacMorphs;
    private GraphPanel activePanel;
    private boolean isAtomApplCond = false;
    private Vector editEventListeners;
    private boolean iconable;
    private Cursor lastCursor;
    private GraGraTreeNodeData treeNodeData;
    private EdGraGra gragra;
    private EdGraph graphToCopy;
    private Hashtable undoGraphs;
    private GraGraTransform gragraTransform;
    private TransformInterpret interpreter;
    private boolean interpreting = false;
    private String cancelled = "";
    private TransformLayered layeredTransform;
    private boolean layering = false;
    private String transformMsg = "";
    private boolean errMsg = false;
    private Thread tmpTransformThread;
    private boolean sleep;
    private JButton buttonMatch;
    private JButton buttonCompletion;
    private JButton buttonStep;
    private JButton buttonStart;
    private JButton buttonStop;
    private JButton buttonUndo;
    private JButton buttonLT;
    private Toolkit tk;
    private PrintJob printJob;
    private Graphics printGraphics;
    private Vector editModeButtons;
    private Vector transformButtons;
    private GraphicsExportJPEG exportJPEG;
    private String jpgPath = null;
    private Layouter layouter = new Layouter(100, null);
    private JFileChooser folderchoose;
    private Vector<String> metricvalues = null;
    private GraphLayouterOptionGUI graphLayouterOptionGUI = new GraphLayouterOptionGUI(this.layouter);

    public GraGraEditor() {
        super(new BorderLayout());
        this.undoGraphs = new Hashtable(2);
        this.setToolkit();
        this.createMainMenus();
        this.createToolBar();
        this.typeEditor = new TypeEditor();
        this.typeEditor.addTypeEventListener(this);
        this.graphEditor = new GraphEditor(this);
        this.ruleEditor = new RuleEditor(this);
        this.pacMorphs = new TwoMorphs();
        this.dividerLocationSet = new Hashtable(0);
        this.splitPane = new JSplitPane(0, this.ruleEditor, this.graphEditor);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane0 = new JSplitPane(0, this.typeEditor, this.splitPane);
        this.splitPane0.setContinuousLayout(true);
        this.splitPane0.setOneTouchExpandable(true);
        this.splitPane1 = new JSplitPane(1, this.splitPane0, null);
        this.splitPane1.setContinuousLayout(true);
        this.splitPane1.setOneTouchExpandable(true);
        this.add((Component)this.splitPane1, "Center");
        this.editmode = -1;
        this.lastCursor = new Cursor(0);
        this.ruleEditor.setEditCursor(new Cursor(0));
        this.graphEditor.setEditCursor(new Cursor(0));
        this.modePopupMenu = new ModePopupMenu();
        this.modePopupMenu.setLabel("Edit Mode");
        this.modePopupMenu.setEditor(this);
        this.modePopupMenu.setMainModeMenu(this.mode);
        this.editPopupMenu = new EditPopupMenu();
        this.editPopupMenu.setLabel("Edit");
        this.editPopupMenu.setEditor(this);
        this.editPopupMenu.setParentFrame(this.applFrame);
        this.editPopupMenu.setGraphLayouter(this.layouter);
        this.editSelPopupMenu = new EditSelPopupMenu();
        this.editSelPopupMenu.setLabel("Edit");
        this.editSelPopupMenu.setEditor(this);
        this.editSelPopupMenu.setParentFrame(this.applFrame);
        this.ruleEditor.setModePopupMenu(this.modePopupMenu);
        this.ruleEditor.setEditPopupMenu(this.editPopupMenu);
        this.ruleEditor.setEditSelPopupMenu(this.editSelPopupMenu);
        this.graphEditor.setModePopupMenu(this.modePopupMenu);
        this.graphEditor.setEditPopupMenu(this.editPopupMenu);
        this.graphEditor.setEditSelPopupMenu(this.editSelPopupMenu);
        EditorFacade editorFacade = DefaultEditorFacade.self();
        this.attrEditor = editorFacade.getTopEditor();
        ((TopEditor)this.attrEditor).getAttrInstanceEditor().getTableModel().addTableModelListener(this);
        this.graphEditor.setAttrEditor(this.attrEditor);
        this.ruleEditor.setAttrEditor(this.attrEditor);
        ((TopEditor)this.attrEditor).getContextEditor().getConditionEditor().getTableModel().addTableModelListener(this);
        this.inputParameterEditor = editorFacade.getInputParameterEditor();
        ((BasicTupleEditor)this.inputParameterEditor).getTableModel().addTableModelListener(this);
        this.gragraTransform = new GraGraTransform(this);
        this.gragraTransform.addTransformEventListener(this);
        this.gragraTransform.getOptionGUI().addOptionListener("layered", this);
        this.gragra = null;
        this.resetEnabledOfMenus(null, false);
        this.resetEnabledOfToolBarItems(null, false);
        this.keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (!GraGraEditor.this.performShortKeyEvent(e)) {
                    GraGraEditor.this.transferShortKeyToTreeView(e);
                }
            }
        };
        this.addKeyListener(this.keyAdapter);
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Object source = e.getSource();
                GraphPanel p = GraGraEditor.this.activePanel;
                if (source == GraGraEditor.this.ruleEditor.getLeftPanel().getCanvas()) {
                    GraGraEditor.this.activePanel = GraGraEditor.this.ruleEditor.getLeftPanel();
                } else if (source == GraGraEditor.this.ruleEditor.getRightPanel().getCanvas()) {
                    GraGraEditor.this.activePanel = GraGraEditor.this.ruleEditor.getRightPanel();
                } else if (source == GraGraEditor.this.ruleEditor.getNACPanel().getCanvas()) {
                    GraGraEditor.this.activePanel = GraGraEditor.this.ruleEditor.getNACPanel();
                } else if (source == GraGraEditor.this.graphEditor.getGraphPanel().getCanvas()) {
                    GraGraEditor.this.activePanel = GraGraEditor.this.graphEditor.getGraphPanel();
                } else {
                    GraGraEditor.this.activePanel = null;
                }
                if (p != null && GraGraEditor.this.activePanel != null && p != GraGraEditor.this.activePanel && (p.getEditMode() == 113 || p.getEditMode() == 151)) {
                    p.setEditMode(11);
                }
            }

            public void mouseEntered(MouseEvent e) {
                GraGraEditor.this.requestFocusInWindow();
                Object source = e.getSource();
                if (source == GraGraEditor.this.typeEditor.getTypePalette().getSplitComponent()) {
                    if (!GraGraEditor.this.typeEditor.getTypePalette().isEmpty()) {
                        GraGraEditor.this.splitPane1.setDividerLocation(GraGraEditor.this.splitPane1.getWidth() - 100);
                    } else {
                        GraGraEditor.this.splitPane1.setDividerLocation(GraGraEditor.this.splitPane1.getWidth());
                    }
                }
            }

            public void mouseExited(MouseEvent e) {
            }
        };
        this.addMouseListener(ml);
        this.ruleEditor.getLeftPanel().getCanvas().addMouseListener(ml);
        this.ruleEditor.getRightPanel().getCanvas().addMouseListener(ml);
        this.ruleEditor.getNACPanel().getCanvas().addMouseListener(ml);
        this.graphEditor.getGraphPanel().getCanvas().addMouseListener(ml);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean performShortKeyEvent(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (this.interpreting || this.layering) {
            if (e.isShiftDown() && e.isControlDown()) {
                this.typedKey = KeyEvent.getKeyText(keyCode);
                if (!this.typedKey.equals("Q")) return true;
                this.buttonStop.doClick();
                return true;
            } else {
                this.sleep = false;
            }
            return true;
        }
        if (e.isControlDown() && e.isAltDown()) {
            this.typedKey = KeyEvent.getKeyText(keyCode);
            if (this.typedKey.equals("N")) {
                this.selectNodeTypeProc();
                return true;
            } else if (this.typedKey.equals("E")) {
                this.selectArcTypeProc();
                return true;
            } else if (this.typedKey.equals("S")) {
                this.selectAllProc();
                return true;
            } else {
                if (!this.typedKey.equals("U")) return false;
                this.deselectAllProc();
            }
            return true;
        } else if (e.isControlDown() && e.isShiftDown()) {
            this.typedKey = KeyEvent.getKeyText(keyCode);
            if (this.typedKey.equals("M")) {
                this.buttonMatch.doClick();
                return true;
            } else if (this.typedKey.equals("C")) {
                this.buttonCompletion.doClick();
                return true;
            } else if (this.typedKey.equals("S")) {
                this.buttonStep.doClick();
                return true;
            } else if (this.typedKey.equals("T")) {
                this.buttonStart.doClick();
                return true;
            } else if (this.typedKey.equals("U")) {
                this.buttonUndo.doClick();
                return true;
            } else if (this.typedKey.equals("R")) {
                this.doIdenticRuleProc();
                return true;
            } else {
                if (!this.typedKey.equals("N")) return false;
                this.doIdenticNacProc();
            }
            return true;
        } else {
            if (e.isShiftDown() && e.isAltDown()) {
                this.typedKey = KeyEvent.getKeyText(keyCode);
                if (!this.typedKey.equals("P")) return false;
                this.fireEditEvent(new EditEvent((Object)this, -10, "Parser Open"));
                return false;
            }
            if (e.isShiftDown()) {
                this.typedKey = KeyEvent.getKeyText(keyCode);
                if (this.typedKey.equals("D")) {
                    this.forwardModeCommand("Draw");
                    this.setEditMode(11);
                    return true;
                } else if (this.typedKey.equals("S")) {
                    this.forwardModeCommand("Select");
                    this.setEditMode(12);
                    return true;
                } else if (this.typedKey.equals("M")) {
                    this.forwardModeCommand("Move");
                    this.setEditMode(13);
                    return true;
                } else {
                    if (!this.typedKey.equals("A")) return false;
                    this.forwardModeCommand("Attributes");
                    this.setEditMode(114);
                }
                return true;
            } else if (e.isControlDown()) {
                this.typedKey = KeyEvent.getKeyText(keyCode);
                if (this.typedKey.equals("A")) {
                    this.attrsProc();
                    return true;
                } else if (this.typedKey.equals("D")) {
                    this.deleteProc();
                    return true;
                } else if (this.typedKey.equals("C")) {
                    this.copyProc();
                    return true;
                } else if (this.typedKey.equals("P")) {
                    this.pasteProc();
                    return true;
                } else if (this.typedKey.equals("E")) {
                    this.straightenArcsProc();
                    return true;
                } else if (this.typedKey.equals("M")) {
                    this.forwardModeCommand("Map");
                    this.setEditMode(115);
                    return true;
                } else {
                    if (!this.typedKey.equals("U")) return false;
                    this.forwardModeCommand("Unmap");
                    this.setEditMode(116);
                }
                return true;
            } else {
                if (e.isAltDown()) {
                    this.typedKey = KeyEvent.getKeyText(keyCode);
                    return false;
                }
                this.typedKey = String.valueOf(e.getKeyChar()).toUpperCase();
                if (this.typedKey.equals("F")) {
                    this.fireEditEvent(new EditEvent((Object)this, -10, "File"));
                    return true;
                } else if (this.typedKey.equals("E")) {
                    this.edit.doClick();
                    return true;
                } else if (this.typedKey.equals("M")) {
                    this.mode.doClick();
                    return true;
                } else if (this.typedKey.equals("T")) {
                    this.transform.doClick();
                    return true;
                } else if (this.typedKey.equals("R")) {
                    this.fireEditEvent(new EditEvent((Object)this, -10, "Parser"));
                    return true;
                } else if (this.typedKey.equals("A")) {
                    this.fireEditEvent(new EditEvent((Object)this, -10, "Analyzer"));
                    return true;
                } else if (this.typedKey.equals("P")) {
                    this.fireEditEvent(new EditEvent((Object)this, -10, "Preferences"));
                    return true;
                } else if (this.typedKey.equals("H")) {
                    this.fireEditEvent(new EditEvent((Object)this, -10, "Help"));
                    return true;
                } else {
                    if (!KeyEvent.getKeyText(keyCode).equals("Delete") && !KeyEvent.getKeyText(keyCode).equals("Entf")) return false;
                    if (this.deleteProc()) return true;
                    this.fireEditEvent(new EditEvent((Object)this, -10, "Delete"));
                }
            }
        }
        return true;
    }

    private void transferShortKeyToTreeView(KeyEvent e) {
        this.fireEditEvent(new EditEvent((Object)this, -11, e));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            if (!((JButton)e.getSource()).isEnabled()) {
                return;
            }
            JButton b = (JButton)e.getSource();
            if (b.equals(this.buttonLT)) {
                this.gragraTransform.getOptionGUI().doClick("layered");
            }
        } else if (e.getSource() instanceof JMenuItem) {
            if (!((JMenuItem)e.getSource()).isEnabled()) {
                return;
            }
        } else if (e.getSource() instanceof JCheckBox) {
            if (((JCheckBox)e.getSource()).getText().equals("layered")) {
                this.resetLayeredTransformIcon(this.gragraTransform.layeredEnabled());
            }
            if (((JCheckBox)e.getSource()).getText().equals("waitAfterStep")) {
                this.sleep = this.gragraTransform.waitAfterStepEnabled();
            }
            return;
        }
        String command = e.getActionCommand();
        if (command.equals("attributes")) {
            this.attrsProc();
        } else if (command.equals("delete")) {
            this.deleteProc();
        } else if (command.equals("copy")) {
            this.copyProc();
        } else if (command.equals("paste")) {
            this.pasteProc();
        } else if (command.equals("selectAll")) {
            this.selectAllProc();
        } else if (command.equals("selectNodeType")) {
            this.selectNodeTypeProc();
        } else if (command.equals("selectArcType")) {
            this.selectArcTypeProc();
        } else if (command.equals("deselectAll")) {
            this.deselectAllProc();
        } else if (command.equals("straighten")) {
            this.straightenArcsProc();
        } else if (command.equals("identicRule")) {
            this.doIdenticRuleProc();
        } else if (command.equals("identicNAC")) {
            this.doIdenticNacProc();
        } else if (command.equals("bold") || command.equals("italic") || command.equals("plain") || command.equals("LARGE") || command.equals("large") || command.equals("small") || command.equals("tiny") || command.equals("0.5") || command.equals("0.7") || command.equals("1.0") || command.equals("1.5") || command.equals("2.0")) {
            this.doPreferencesProc(command);
        } else if (command.equals("drawMode")) {
            if (e.getSource() instanceof JButton) {
                this.forwardModeCommand("Draw");
            } else if (e.getSource() instanceof JCheckBoxMenuItem) {
                this.forwardModeCommand((JCheckBoxMenuItem)e.getSource());
            }
            this.setEditMode(11);
        } else if (command.equals("selectMode")) {
            if (e.getSource() instanceof JButton) {
                this.forwardModeCommand("Select");
            } else if (e.getSource() instanceof JCheckBoxMenuItem) {
                this.forwardModeCommand((JCheckBoxMenuItem)e.getSource());
            }
            this.setEditMode(12);
        } else if (command.equals("moveMode")) {
            if (e.getSource() instanceof JButton) {
                this.forwardModeCommand("Move");
            } else if (e.getSource() instanceof JCheckBoxMenuItem) {
                this.forwardModeCommand((JCheckBoxMenuItem)e.getSource());
            }
            this.setEditMode(13);
        } else if (command.equals("attributesMode")) {
            if (e.getSource() instanceof JButton) {
                this.forwardModeCommand("Attributes");
            } else if (e.getSource() instanceof JCheckBoxMenuItem) {
                this.forwardModeCommand((JCheckBoxMenuItem)e.getSource());
            }
            this.setEditMode(114);
        } else if (command.equals("mapMode")) {
            if (e.getSource() instanceof JButton) {
                this.forwardModeCommand("Map");
            } else if (e.getSource() instanceof JCheckBoxMenuItem) {
                this.forwardModeCommand((JCheckBoxMenuItem)e.getSource());
            }
            this.setEditMode(115);
        } else if (command.equals("unmapMode")) {
            if (e.getSource() instanceof JButton) {
                this.forwardModeCommand("Unmap");
            } else if (e.getSource() instanceof JCheckBoxMenuItem) {
                this.forwardModeCommand((JCheckBoxMenuItem)e.getSource());
            }
            this.setEditMode(116);
        } else if (command.equals("imageMode")) {
            if (e.getSource() instanceof JButton) {
                this.forwardModeCommand("Image_view");
            } else if (e.getSource() instanceof JCheckBoxMenuItem) {
                this.forwardModeCommand((JCheckBoxMenuItem)e.getSource());
                this.setNodeIconable(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        } else if (command.equals("start")) {
            this.requestFocusInWindow();
            if (this.getGraGra() != null) {
                if (!this.isEditable()) {
                    return;
                }
                if (!this.isGraGraReadyToTransform(this.gragra)) {
                    return;
                }
                this.selectToolBarTransformItem("start");
                if (e.getSource() instanceof JButton) {
                    this.resetTransformMenu("Start");
                } else if (e.getSource() instanceof JMenuItem) {
                    this.resetTransformMenu((JMenuItem)e.getSource());
                }
                this.resetEditModeAfterMapping(this.lasteditmode);
                ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
                this.cancelled = "";
                if (this.layouter.isEnabled()) {
                    this.doPrepareLayouterProc();
                }
                if (this.gragraTransform.layeredEnabled()) {
                    if (!this.layering) {
                        this.doPrepareTransformationProc();
                        this.startLayeredTransform();
                    } else if (!this.sleep) {
                        this.fireEditEvent(new EditEvent((Object)this, -1, " Please wait. Transformation is running ... "));
                    }
                } else if (!this.interpreting) {
                    this.doPrepareTransformationProc();
                    this.startTransformInterpreter();
                } else if (!this.sleep) {
                    this.fireEditEvent(new EditEvent((Object)this, -1, " Please wait. Transformation is running ... "));
                }
            }
        } else if (command.equals("stop")) {
            this.requestFocusInWindow();
            if (this.getGraGra() != null) {
                if (!this.getGraGra().getGraph().isEditable()) {
                    return;
                }
                if (this.layering) {
                    this.selectToolBarTransformItem("stop");
                    if (!this.gragraTransform.stopLayerEnabled()) {
                        if (e.getSource() instanceof JButton) {
                            this.resetTransformMenu("Stop");
                        } else if (e.getSource() instanceof JMenuItem) {
                            this.resetTransformMenu((JMenuItem)e.getSource());
                        }
                        this.sleep = false;
                        this.requestFocusInWindow();
                        this.gragraTransform.stopTransformLayered();
                        this.resetIconsIfTransformInterpret(true);
                        this.setEditMode(this.lasteditmode);
                    } else {
                        this.sleep = false;
                        this.requestFocusInWindow();
                        this.gragraTransform.stopTransformLayered();
                    }
                } else if (this.interpreting) {
                    if (e.getSource() instanceof JButton) {
                        this.resetTransformMenu("Stop");
                    } else if (e.getSource() instanceof JMenuItem) {
                        this.resetTransformMenu((JMenuItem)e.getSource());
                    }
                    this.requestFocusInWindow();
                    this.doStopTransformInterpreterProc();
                }
            }
        } else if (command.equals("match")) {
            this.doPrepareInteractiveMatchProc();
        } else if (command.equals("completion")) {
            this.requestFocusInWindow();
            this.doPrepareCompletionMatchProc();
        } else if (command.equals("step")) {
            this.requestFocusInWindow();
            if (this.getGraGra() != null && this.ruleEditor.getRule() != null) {
                if (!this.isEditable()) {
                    return;
                }
                if (this.layouter.isEnabled() && this.getGraph().getGraphGen() == 0) {
                    this.getGraph().incGraphGen();
                }
                this.doExecuteStepProc();
            }
        } else if (command.equals("undo")) {
            this.requestFocusInWindow();
            if (this.getGraGra() != null && this.ruleEditor.getRule() != null) {
                if (!this.getGraGra().getGraph().isEditable()) {
                    return;
                }
                if (!this.interpreting && !this.layering) {
                    this.selectToolBarTransformItem("undo");
                    this.doUnduGraphTransformationProc();
                    this.selectToolBarTransformItem("");
                }
            }
        } else if (command.equals("layout")) {
            this.doDefaultELayoutProc();
            this.updateGraphics();
        } else if (command.equals("arclayout")) {
            this.doByArcLengthELayoutProc();
            this.updateGraphics();
        } else if (command.equals("combinedlayout1")) {
            this.doCombinedELayoutProc();
            this.updateGraphics();
        } else if (command.equals("combinedlayout2")) {
            this.doStandardELayoutProc();
            this.updateGraphics();
        } else if (command.equals("lmetric")) {
            this.doDisplayELayoutMetricsProc();
        }
    }

    public synchronized void addEditEventListener(EditEventListener l) {
        Vector v;
        Vector vector = v = this.editEventListeners == null ? new Vector(2) : (Vector)this.editEventListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.editEventListeners = v;
        }
    }

    public synchronized void removeEditEventListener(EditEventListener l) {
        if (this.editEventListeners != null && this.editEventListeners.contains(l)) {
            this.editEventListeners.removeElement(l);
        }
    }

    private synchronized void fireEditEvent(EditEvent e) {
        if (this.editEventListeners != null) {
            for (int i = 0; i < this.editEventListeners.size(); ++i) {
                ((EditEventListener)this.editEventListeners.elementAt(i)).editEventOccurred(e);
            }
        }
    }

    @Override
    public void treeViewEventOccurred(TreeViewEvent e) {
        if (e.getMsg() == 24) {
            if (e.getObject() instanceof KeyEvent) {
                this.requestFocusInWindow();
                this.performShortKeyEvent((KeyEvent)e.getObject());
            }
        } else if (e.getMsg() == 19) {
            this.graphEditor.updateGraphics();
        } else if (e.getMsg() == 6) {
            if (this.editmode == 42) {
                this.resetEditModeAfterMapping(this.lasteditmode);
            }
        } else if (e.getMsg() == 61) {
            this.treeNodeData = e.getData();
            if (this.treeNodeData.isGraGra && this.getGraGra() != null) {
                this.getGraGra().getBasisGraGra().storeUsedClassPackages();
            }
            this.loadDataInEditor(this.treeNodeData);
            if (this.getGraGra() != null) {
                if (this.treeNodeData.isGraGra) {
                    this.getGraGra().getBasisGraGra().setUsedClassPackages();
                } else if (this.treeNodeData.isRule && this.treeNodeData.getRule().getMatch() != null) {
                    this.treeNodeData.getRule().update();
                    this.graphEditor.getGraph().update();
                    this.updateGraphics();
                }
            }
        } else if (e.getMsg() == 7) {
            this.treeNodeData = e.getData();
            if (this.treeNodeData != null) {
                this.deleteDataOfEditor(this.treeNodeData);
                if (this.gragra == null) {
                    this.splitPane1.setRightComponent(null);
                    this.resetEnabledOfToolBarItems(null, false);
                }
                this.resetEnabledOfMenus(null, false);
                if (this.hasAttrEditorOnTop()) {
                    this.resetRuleEditor();
                } else if (this.hasAttrEditorOnBottom()) {
                    this.resetGraphEditor();
                }
                this.treeNodeData = null;
            }
        } else if (e.getMsg() == 2) {
            this.resetEditModeAfterMapping(this.lasteditmode);
        } else if (e.getMsg() == 4) {
            if (this.layouter.isEnabled() && this.getGraGra().getGraph().hasDefaultLayout()) {
                this.getGraGra().getGraph().doDefaultEvolutionaryGraphLayout(this.layouter, 20);
            }
            this.setEditMode(13);
            this.selectToolBarModeItem("Move");
            this.lasteditmode = 13;
            this.forwardModeCommand("Move");
        } else if (e.getMsg() == 1) {
            if (this.ruleEditor.isObjMapping()) {
                this.ruleEditor.resetEditModeAfterMapping();
            }
            this.updateGraphics();
            if (this.gragra != null) {
                this.gragra.getBasisGraGra().setGraTraOptions(this.gragraTransform.getGraTraOptionsList());
            }
        } else if (e.getMsg() == 21) {
            this.updateGraphics();
        } else if (e.getMsg() == 16) {
            this.gragraTransform.destroyMatch();
            this.graphEditor.updateGraphics();
            this.fireEditEvent(new EditEvent((Object)this, -1, "        "));
        } else if (e.getMsg() == 160) {
            this.treeNodeData = e.getData();
            if (this.treeNodeData.isGraGra && this.treeNodeData.getGraGra() == this.gragra) {
                this.graphEditor.setGraph(this.gragra.getGraph());
                this.graphEditor.updateGraphics();
                if (this.gragraTransform.checkRuleApplicabilityEnabled()) {
                    this.gragraTransform.getApplicableRules(this.gragra);
                }
            }
        } else if (e.getMsg() == 170) {
            this.typeEditor.refreshTypes();
            if (this.graphEditor.getGraph().isTypeGraph()) {
                this.graphEditor.setGraph(this.gragra.getTypeGraph());
                this.graphEditor.updateGraphics();
            }
            if (!this.getGraGra().getTypeSet().getTypeGraph().getSelectedObjs().isEmpty()) {
                this.forwardModeCommand("Move");
                this.setEditMode(13);
            }
        } else if (e.getMsg() == 17) {
            this.gragraTransform.destroyMatch();
            this.graphEditor.updateGraphics();
            this.fireEditEvent(new EditEvent((Object)this, -1, "        "));
        } else if (e.getMsg() == 171) {
            this.typeEditor.refreshTypes();
            if (!this.graphEditor.getGraph().isTypeGraph()) {
                this.graphEditor.setGraph(this.gragra.getGraph());
                this.graphEditor.updateGraphics();
            }
            if (this.gragraTransform.checkRuleApplicabilityEnabled()) {
                this.gragraTransform.getApplicableRules(this.gragra);
            }
        } else if (e.getMsg() == 172) {
            this.typeEditor.refreshTypes();
        } else if (e.getMsg() == 18) {
            this.gragraTransform.getApplicableRules(this.getGraGra());
        } else if (e.getMsg() == 22) {
            this.typeEditor.refreshTypes();
        } else if (e.getMsg() == 23) {
            this.saveGraphJPEG();
        } else if (e.getMsg() == 10 && e.getObject() instanceof GraGraPrint) {
            this.printGraGra(this.applFrame, (GraGraPrint)e.getObject(), this.gragra);
        }
        this.requestFocusInWindow();
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        TreePath path = e.getTreePath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)node.getUserObject();
        String name = data.string();
        if (this.treeNodeData != null) {
            data = this.treeNodeData;
            name = data.string();
            if (data.isGraGra && data.getGraGra().equals(this.getGraGra())) {
                if (this.ruleEditor.getAtomic() != null) {
                    this.ruleEditor.setAtomicTitle(this.ruleEditor.getAtomic().getBasisAtomic().getName(), this.ruleEditor.getAtomic().getBasisAtomic().getAtomicName());
                } else if (this.ruleEditor.getRule() != null) {
                    this.ruleEditor.setRuleTitle(this.ruleEditor.getRule().getBasisRule().getName(), name);
                } else {
                    this.ruleEditor.setRuleTitle("", name);
                }
                this.graphEditor.setTitle(data.getGraGra().getGraph().getBasisGraph().getName(), name);
            } else if (data.isTypeGraph && data.getGraph().equals(this.graphEditor.getGraph())) {
                this.graphEditor.setTitle(data.getGraph().getBasisGraph().getName(), this.getGraGra().getName());
            } else if (data.isGraph && data.getGraph().equals(this.graphEditor.getGraph())) {
                this.graphEditor.setTitle(data.getGraph().getBasisGraph().getName(), this.getGraGra().getName());
            } else if (data.isRule && data.getRule().equals(this.ruleEditor.getRule())) {
                this.ruleEditor.setRuleTitle(name, this.getGraGra().getName());
            } else if (data.isNAC && data.getNAC().equals(this.ruleEditor.getNAC())) {
                this.ruleEditor.setNACTitle(name);
            } else if (data.isAtomic && data.getAtomic().equals(this.ruleEditor.getAtomic())) {
                if (this.ruleEditor.getAtomic() != null) {
                    if (this.ruleEditor.getAtomic().getParent() == this.ruleEditor.getAtomic() && this.ruleEditor.getAtomic().getConclusions().isEmpty()) {
                        this.ruleEditor.setAtomicTitle("", name);
                    } else {
                        this.ruleEditor.setAtomicTitle(this.ruleEditor.getAtomic().getMorph().getName(), name);
                    }
                } else {
                    this.ruleEditor.setAtomicTitle("", name);
                }
            } else if (data.isConclusion && data.getConclusion().equals(this.ruleEditor.getAtomic())) {
                this.ruleEditor.setAtomicTitle(name, data.getConclusion().getBasisAtomic().getAtomicName());
            }
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }

    @Override
    public void transformEventOccurred(TransformEvent e) {
        if (e.getMsg() == 21) {
            this.requestFocusInWindow();
            JOptionPane.showMessageDialog(null, "Sorry.\nConsistency check will be ignored, because it isn`t yet\nimplemented for grammars with node type inheritance.", "Warning", 2);
        } else if (e.getMsg() == 9) {
            this.transformMsg = "Transformation of  <" + this.getGraGra().getName() + ">  ...";
            this.fireEditEvent(new EditEvent((Object)this, -1, this.transformMsg));
        } else if (e.getMsg() == 16) {
            if (this.interpreting || this.layering) {
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... " + e.getMessage()));
            }
        } else if (e.getMsg() == 17) {
            if (this.layouter.isEnabled()) {
                this.layouter.setOldEdGraph(this.getGraph().copy());
                this.getGraph().incGraphGen();
            }
            if (this.interpreting || this.layering) {
                if (this.gragraTransform.waitAfterStepEnabled()) {
                    this.sleep = true;
                    this.requestFocusInWindow();
                    this.updateGraphics();
                    this.fireEditEvent(new EditEvent((Object)this, -1, e.getMessage() + "     <<<   PRESS ANY KEY TO CONTINUE   >>>"));
                    try {
                        while (this.sleep) {
                            if (!this.interpreting && !this.layering) continue;
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException ex1) {}
                } else {
                    this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... " + e.getMessage()));
                }
            }
        } else if (e.getMsg() == 22) {
            if (this.layering && this.gragraTransform.stopLayerEnabled()) {
                this.sleep = true;
                this.requestFocusInWindow();
                this.updateGraphics();
                this.fireEditEvent(new EditEvent((Object)this, -1, e.getMessage() + "     <<<   PRESS ANY KEY TO CONTINUE   >>>"));
                try {
                    while (this.sleep) {
                        if (!this.layering) continue;
                        Thread.sleep(100L);
                    }
                    this.layeredTransform.nextLayer();
                }
                catch (InterruptedException ex1) {}
            }
        } else if (e.getMsg() == 10) {
            this.requestFocusInWindow();
            if (this.layouter.isEnabled()) {
                this.getGraGra().getGraph().resolveArcOverlappings(20);
                this.graphEditor.updateGraphics();
            }
            if (this.layering || this.interpreting) {
                this.sleep = false;
                this.disableStop();
                this.resetIconsIfTransformInterpret(true);
                String str = e.getMessage();
                if (!this.cancelled.equals("")) {
                    str = str + " ( " + this.cancelled + " )";
                }
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transformation of  <" + this.getGraGra().getName() + "> ...  Please wait."));
                if (this.layering) {
                    this.removeEditEventListener(this.layeredTransform);
                    this.layering = false;
                } else if (this.interpreting) {
                    this.removeEditEventListener(this.interpreter);
                    this.interpreting = false;
                }
                this.addEditEventListener(this.gragraTransform.getTransformDebugger());
                if (this.gragraTransform.checkRuleApplicabilityEnabled()) {
                    this.gragraTransform.getApplicableRules(this.getGraGra());
                }
                this.setEditMode(this.lasteditmode);
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transformation of  <" + this.getGraGra().getName() + ">  " + str));
            }
            this.selectToolBarTransformItem("");
            if (this.layouter.getWriteMetricValues() && this.jpgPath != null && !this.jpgPath.equals("")) {
                this.writeMetricValues(this.jpgPath + File.separator + this.getGraGra().getFileName() + "_metrics.log");
            }
        } else if (e.getMsg() == 11) {
            this.requestFocusInWindow();
            if (this.ruleEditor.isObjMapping()) {
                this.ruleEditor.resetEditModeAfterMapping();
            }
            this.setEditMode(42);
        } else if (e.getMsg() == 12) {
            this.requestFocusInWindow();
            this.updateGraphics();
            this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ...  Next Completion ... Please wait. "));
        } else if (e.getMsg() == 15) {
            this.requestFocusInWindow();
            if (!this.interpreting && !this.layering) {
                this.updateGraphics();
                this.setEditMode(this.lasteditmode);
                JOptionPane.showMessageDialog(null, "Cannot match\n" + e.getMessage(), "Cannot match", 0);
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ...  Match failed. "));
            }
        } else if (e.getMsg() == 13) {
            if (this.layouter.isEnabled()) {
                this.layouter.setOldEdGraph(this.getGraph().copy());
                this.getGraph().incGraphGen();
            }
            this.requestFocusInWindow();
            this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ...  Step ... Please wait. "));
        } else if (e.getMsg() == 1) {
            AttrContext ac = e.getMatch().getAttrContext();
            AttrVariableTuple avt = ac.getVariables();
            this.inputParameterEditor.setTuple(avt);
            ((OpenViewSetting)((MaskedViewSetting)this.inputParameterEditor.getViewSetting()).getOpenView()).removeFormat(avt.getType());
            this.setInputParameterEditorOnTop(this.inputParameterEditor.getComponent());
            this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... Please set value of the input parameter(s)."));
        } else if (e.getMsg() == 18) {
            this.requestFocusInWindow();
            this.updateGraphics();
            JOptionPane.showMessageDialog(null, "Not ready to transform!\n" + e.getMessage(), "Cannot transform", 0);
            this.setEditMode(this.lasteditmode);
            this.selectToolBarTransformItem("");
            this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ...  Not ready to transform. "));
            this.getGraGra().setUndoGraph(null);
            this.undoGraphs.remove(this.getGraGra().getGraph());
        } else if (e.getMsg() == 4) {
            if (!this.interpreting && !this.layering) {
                this.requestFocusInWindow();
                this.updateGraphics();
                JOptionPane.showMessageDialog(null, "Cannot transform\n" + e.getMessage(), "Cannot transform", 0);
                this.getGraGra().setUndoGraph(null);
                this.undoGraphs.remove(this.getGraGra().getGraph());
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ...  failed. "));
            } else {
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... " + e.getMessage()));
            }
            this.setEditMode(this.lasteditmode);
            this.selectToolBarTransformItem("");
        } else if (e.getMsg() == 5) {
            this.requestFocusInWindow();
            this.updateGraphics();
            this.fireEditEvent(new EditEvent((Object)this, -1, "Please define a new match."));
        } else if (e.getMsg() == 6) {
            this.requestFocusInWindow();
            this.fireEditEvent(new EditEvent((Object)this, -1, "Your last match completion "));
        } else if (e.getMsg() == 7) {
            this.requestFocusInWindow();
            this.updateGraphics();
            this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... Match is complete."));
            this.selectToolBarTransformItem("");
        } else if (e.getMsg() == 2) {
            if (this.layouter.isEnabled()) {
                this.doStepELayoutProc();
            }
            if (!this.interpreting && !this.layering) {
                this.updateGraphics();
                if (e.getMatch() == null) {
                    this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... Step is completed."));
                    if (this.gragraTransform.checkRuleApplicabilityEnabled()) {
                        this.fireEditEvent(new EditEvent((Object)this, -1, " Checking applicability of rules ... Please wait. "));
                        Vector applicableRules = this.gragraTransform.getApplicableRules(this.getGraGra());
                        this.fireEditEvent(new EditEvent((Object)this, -1, " Step is done.     Checking applicability of rules is done."));
                    } else {
                        this.fireEditEvent(new EditEvent((Object)this, -1, " Step is complete."));
                        this.gragraTransform.getApplicableRules(this.getGraGra(), true);
                        this.fireEditEvent(new EditEvent((Object)this, -1, " Step is done. "));
                    }
                } else {
                    this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... Step is completed. Last match to destroy failed."));
                }
                this.selectToolBarTransformItem("");
            } else {
                if (this.gragraTransform.showGraphAfterStepEnabled()) {
                    this.updateGraphics();
                }
                if (this.gragraTransform.waitAfterStepEnabled()) {
                    this.sleep = true;
                    if (this.gragraTransform.checkRuleApplicabilityEnabled()) {
                        this.gragraTransform.getApplicableRules(this.gragra);
                    }
                    this.fireEditEvent(new EditEvent((Object)this, -1, e.getMessage() + "     <<<   PRESS ANY KEY TO CONTINUE   ( Maybe click on AGG to activate it. ) >>>"));
                    this.requestFocusInWindow();
                    try {
                        while (this.sleep) {
                            if (this.interpreting) {
                                Thread.sleep(100L);
                                continue;
                            }
                            if (!this.layering) continue;
                            Thread.sleep(100L);
                        }
                        if (this.gragraTransform.checkRuleApplicabilityEnabled()) {
                            this.gragraTransform.getApplicableRules(this.gragra, true);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.fireEditEvent(new EditEvent((Object)this, -1, this.transformMsg + e.getMessage()));
                    this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... " + e.getMessage()));
                }
            }
        } else if (e.getMsg() == 3) {
            if (!this.interpreting && !this.layering) {
                this.requestFocusInWindow();
                this.updateGraphics();
                JOptionPane.showMessageDialog(null, "No completion is found.\n" + e.getMessage(), "No completion", 0);
                this.selectToolBarTransformItem("");
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... No match completion found."));
            }
        } else if (e.getMsg() == 14) {
            if (!this.interpreting && !this.layering) {
                this.requestFocusInWindow();
                this.updateGraphics();
                JOptionPane.showMessageDialog(null, "Match is not valid.", "Not valid", 0);
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... Match was not valid."));
            }
        } else if (e.getMsg() == 8) {
            this.requestFocusInWindow();
            if (this.interpreting || this.layering) {
                this.cancelled = e.getMessage();
                this.updateGraphics();
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ...  was cancelled. "));
            } else {
                this.updateGraphics();
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... Last action was cancelled. "));
            }
            this.setEditMode(this.lasteditmode);
            this.selectToolBarTransformItem("");
        } else if (e.getMsg() == 19) {
            this.requestFocusInWindow();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Graph inconsistency", 0);
            this.setEditMode(this.lasteditmode);
            this.selectToolBarTransformItem("");
            this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ...  Graph inconsistency "));
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        AttrVariableTuple avt = (AttrVariableTuple)((BasicTupleEditor)this.inputParameterEditor).getTuple();
        if (e.getColumn() == -1 && avt != null && avt.areInputParametersSet()) {
            this.resetTypeEditor();
            this.inputParameterEditor.setTuple(null);
            this.fireEditEvent(new EditEvent(this, -3));
            return;
        }
        if (!this.hasAttrEditorOnTop() && !this.hasAttrEditorOnBottom()) {
            return;
        }
        if (((TupleTableModel)e.getSource()).getColumnName(((TupleTableModel)e.getSource()).getChangedColumn()).equals("Shown")) {
            if (((TupleTableModel)e.getSource()).isColumnValueChanged()) {
                this.gragra.setChanged(true);
            }
        } else if (((TupleTableModel)e.getSource()).getColumnName(((TupleTableModel)e.getSource()).getChangedColumn()).equals("Expression")) {
            if (((TopEditor)this.attrEditor).getTitleOfSelectedEditor().equals("Attribute Context")) {
                if (this.ruleEditor.getAtomic() instanceof EdAtomic) {
                    this.fireEditEvent(new EditEvent(this, -8, this.ruleEditor.getAtomic(), ""));
                    if (((TupleTableModel)e.getSource()).isColumnValueChanged()) {
                        // empty if block
                    }
                } else if (this.ruleEditor.getRule() instanceof EdRule) {
                    this.fireEditEvent(new EditEvent(this, -8, this.ruleEditor.getRule(), ""));
                    if (((TupleTableModel)e.getSource()).isColumnValueChanged()) {
                        // empty if block
                    }
                }
            }
        } else if (((TupleTableModel)e.getSource()).getColumnName(((TupleTableModel)e.getSource()).getChangedColumn()).equals("Type") && ((TupleTableModel)e.getSource()).isTypeColumnValueChanged()) {
            this.attrTypeChanged = true;
        }
    }

    private void attrTypeChangedWarning() {
        if (this.attrTypeChanged) {
            JOptionPane.showMessageDialog(null, "You have changed the type of an attribute member.\nAlready set values of this attribute member are no more valid.\nPlease check these values.", "Attribute Type changed", 2);
            this.attrTypeChanged = false;
        }
    }

    @Override
    public void typeEventOccurred(TypeEvent e) {
        if (e.getMsg() == 3) {
            this.gragra.update();
            this.updateGraphics();
        } else if (e.getMsg() == 12) {
            this.graphLayouterOptionGUI.updateEdgeTypeComboBox((EdType)e.getUsedObject(), e.getIndexOfObject(), e.getMsg());
        } else if (e.getMsg() == 13) {
            this.graphLayouterOptionGUI.updateEdgeTypeComboBox((EdType)e.getUsedObject(), e.getIndexOfObject(), e.getMsg());
        } else if (e.getMsg() != 0) {
            if (e.getMsg() == 6) {
                this.gragra.update();
                this.updateGraphics();
            } else if (e.getMsg() == 14) {
                this.graphLayouterOptionGUI.updateEdgeTypeComboBox((EdType)e.getUsedObject(), e.getIndexOfObject(), e.getMsg());
            } else if (e.getMsg() == 9) {
                this.updateGraphics();
            } else if (e.getMsg() == 10) {
                this.updateGraphics();
            } else if (e.getMsg() == 11) {
                this.typeEditor.refreshTypes();
            }
        }
    }

    public void setFrame(JFrame f) {
        this.applFrame = f;
        this.typeEditor.setFrame(this.applFrame);
        this.ruleEditor.setFrame(this.applFrame);
        this.graphEditor.setFrame(this.applFrame);
        this.editPopupMenu.setParentFrame(this.applFrame);
        this.editSelPopupMenu.setParentFrame(this.applFrame);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, 550);
    }

    public Enumeration getMenus() {
        return this.mainMenus.elements();
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public GraphLayouterOptionGUI getGraphLayouterOptionGUI() {
        return this.graphLayouterOptionGUI;
    }

    public void setInputParameterEditorOnTop(Component paramEditor) {
        if (this.splitPane0.getTopComponent() instanceof TypeEditor) {
            this.ruleEditor.saveScrollBarValue();
            this.graphEditor.saveScrollBarValue();
            int location = this.splitPane0.getDividerLocation();
            JPanel p = new JPanel(new BorderLayout());
            p.setBorder(new TitledBorder("   Please  set  Value  of  Input  Parameter   "));
            p.setBackground(Color.ORANGE);
            p.add(paramEditor, "Center");
            p.add((Component)new JLabel("   "), "South");
            int h = paramEditor.getHeight() + 50;
            p.setPreferredSize(new Dimension(500, h));
            this.splitPane0.setTopComponent(p);
        }
    }

    public void setInputParameterEditorOnBottom(Component paramEditor) {
        if (!(this.splitPane0.getBottomComponent() instanceof AttrTupleEditor) && !(this.splitPane.getBottomComponent() instanceof GraphEditor)) {
            this.ruleEditor.saveScrollBarValue();
            this.graphEditor.saveScrollBarValue();
            int location = this.splitPane0.getDividerLocation();
            this.splitPane0.setBottomComponent(paramEditor);
        }
    }

    public void resetTypeEditor() {
        if (!(this.splitPane0.getTopComponent() instanceof TypeEditor)) {
            this.ruleEditor.saveScrollBarValue();
            this.graphEditor.saveScrollBarValue();
            this.splitPane0.setTopComponent(this.typeEditor);
        }
    }

    public void setAttrEditorOnTop(Component attrEditorComponent) {
        if (!(this.splitPane.getTopComponent() instanceof AttrTupleEditor)) {
            ((TopEditor)this.attrEditor).selectAttributeEditor(true);
            this.ruleEditor.saveScrollBarValue();
            this.dividerLocation = this.splitPane.getDividerLocation();
            this.splitPane.setTopComponent(attrEditorComponent);
            this.splitPane.setDividerLocation(this.dividerLocation);
        }
    }

    public void setAttrEditorOnBottom(Component attrEditorComponent) {
        if (!(this.splitPane.getBottomComponent() instanceof AttrTupleEditor)) {
            ((TopEditor)this.attrEditor).selectAttributeEditor(true);
            this.graphEditor.saveScrollBarValue();
            this.dividerLocation = this.splitPane.getDividerLocation();
            this.splitPane.setBottomComponent(attrEditorComponent);
            this.splitPane.setDividerLocation(this.dividerLocation);
            this.ruleEditor.getLeftPanel().setAttrEditorActivated(true);
            this.ruleEditor.getRightPanel().setAttrEditorActivated(true);
            if (this.ruleEditor.getNACPanel() != null) {
                this.ruleEditor.getNACPanel().setAttrEditorActivated(true);
            }
        }
    }

    public boolean hasAttrEditorOnTop() {
        if (this.splitPane.getTopComponent() instanceof RuleEditor && this.splitPane.getBottomComponent() instanceof GraphEditor) {
            return false;
        }
        return this.splitPane.getBottomComponent() instanceof GraphEditor;
    }

    public boolean hasAttrEditorOnBottom() {
        if (this.splitPane.getTopComponent() instanceof RuleEditor && this.splitPane.getBottomComponent() instanceof GraphEditor) {
            return false;
        }
        return this.splitPane.getTopComponent() instanceof RuleEditor;
    }

    public void resetRuleEditor() {
        int location = this.splitPane.getDividerLocation();
        this.dividerLocation = this.splitPane.getDividerLocation();
        if (!(this.splitPane.getTopComponent() instanceof RuleEditor)) {
            this.graphEditor.saveScrollBarValue();
        }
        if (this.isAtomApplCond) {
            this.splitPane.setTopComponent(this.pacMorphs);
            this.splitPane.setDividerLocation(this.dividerLocation);
        } else {
            this.splitPane.setTopComponent(this.ruleEditor);
            this.splitPane.setDividerLocation(this.dividerLocation);
        }
    }

    public void resetGraphEditor() {
        if (!(this.splitPane.getBottomComponent() instanceof GraphEditor)) {
            this.ruleEditor.saveScrollBarValue();
            this.splitPane.setBottomComponent(this.graphEditor);
            this.splitPane.setDividerLocation(this.dividerLocation);
            this.ruleEditor.getLeftPanel().setAttrEditorActivated(false);
            this.ruleEditor.getRightPanel().setAttrEditorActivated(false);
            if (this.ruleEditor.getNACPanel() != null) {
                this.ruleEditor.getNACPanel().setAttrEditorActivated(false);
            }
        }
    }

    public void resetEditor() {
        if (this.hasAttrEditorOnTop()) {
            this.resetRuleEditor();
        } else if (this.hasAttrEditorOnBottom()) {
            this.resetGraphEditor();
        }
    }

    public final TypeEditor getTypeEditor() {
        return this.typeEditor;
    }

    public final RuleEditor getRuleEditor() {
        return this.ruleEditor;
    }

    public final GraphEditor getGraphEditor() {
        return this.graphEditor;
    }

    public final AttrTopEditor getAttrEditor() {
        return this.attrEditor;
    }

    public final AttrTupleEditor getInputParameterEditor() {
        return this.inputParameterEditor;
    }

    public int getTypePanelDividerLocation() {
        return this.splitPane1.getDividerLocation();
    }

    public int getTypePanelLastDividerLocation() {
        return this.splitPane1.getLastDividerLocation();
    }

    public void setTypePanelDividerLocation(int l) {
        this.splitPane1.setDividerLocation(l);
    }

    public GraTraOptionGUI getTransformOptionGUI() {
        return this.gragraTransform.getOptionGUI();
    }

    public GraphPanel getActivePanel() {
        return this.activePanel;
    }

    public GraphPanel getPanelOfGraph(EdGraph g) {
        if (g == null) {
            return null;
        }
        if (g.equals(this.ruleEditor.getLeftPanel().getGraph())) {
            return this.ruleEditor.getLeftPanel();
        }
        if (g.equals(this.ruleEditor.getRightPanel().getGraph())) {
            return this.ruleEditor.getRightPanel();
        }
        if (g.equals(this.ruleEditor.getNACPanel().getGraph())) {
            return this.ruleEditor.getNACPanel();
        }
        if (g.equals(this.graphEditor.getGraphPanel().getGraph())) {
            return this.graphEditor.getGraphPanel();
        }
        return null;
    }

    public final EdGraGra getGraGra() {
        return this.gragra;
    }

    public final EdRule getRule() {
        return this.ruleEditor.getRule();
    }

    public final EdGraph getGraph() {
        return this.graphEditor.getGraph();
    }

    public final EdNAC getNAC() {
        return this.ruleEditor.getNAC();
    }

    public void setGraGra(EdGraGra gra) {
        if (this.gragra != null) {
            this.gragra.getTypeSet().removeTypeEventListener(this);
        }
        this.gragra = gra;
        if (this.gragra == null) {
            this.graphLayouterOptionGUI.setGraGra(null);
            return;
        }
        this.gragra.getTypeSet().setNodeIconable(this.iconable);
        if (this.gragra.getBasisGraGra().getGraTraOptions().isEmpty()) {
            Vector<String> defaultOpts = new Vector<String>();
            defaultOpts.addElement("CSP");
            defaultOpts.addElement("injective");
            defaultOpts.addElement("dangling");
            defaultOpts.addElement("NACs");
            this.gragraTransform.updateGraTraOptionGUI(defaultOpts);
            this.gragra.getBasisGraGra().setGraTraOptions(this.gragraTransform.getStrategy());
        } else {
            this.gragraTransform.updateGraTraOptionGUI(this.gragra.getBasisGraGra().getGraTraOptions());
            this.gragra.getBasisGraGra().setGraTraOptions(this.gragraTransform.getStrategy());
        }
        this.resetLayeredTransformIcon(this.gragraTransform.layeredEnabled());
        this.gragra.getTypeSet().addTypeEventListener(this);
        this.graphLayouterOptionGUI.setGraGra(this.gragra);
    }

    public void setRule(EdRule r) {
        if (this.gragra == r.getGraGra()) {
            this.ruleEditor.setRule(r);
        }
    }

    public void setGraph(EdGraph g) {
        if (this.gragra == g.getGraGra()) {
            this.graphEditor.setGraph(g);
        }
    }

    public void setNAC(EdNAC nac) {
        if (this.ruleEditor.getRule() == nac.getRule()) {
            this.ruleEditor.setNAC(nac);
        }
    }

    public void setAtomic(EdAtomic a) {
        if (this.gragra == a.getGraGra()) {
            this.ruleEditor.setAtomic(a);
            this.ruleEditor.updateGraphics();
        }
    }

    public void setAtomApplCond(AtomApplCond c) {
        if (this.gragra == this.pacMorphs.getGraGra()) {
            this.pacMorphs.setAtomApplCond(c);
        }
    }

    public final int getEditMode() {
        return this.editmode;
    }

    public void setEditMode(int mode) {
        this.editmode = mode;
        switch (this.editmode) {
            case 11: {
                this.drawModeProc();
                break;
            }
            case 12: {
                this.selectModeProc();
                break;
            }
            case 13: {
                this.moveModeProc();
                break;
            }
            case 114: {
                this.attributesModeProc();
                break;
            }
            case 31: {
                this.ruleDefModeProc();
                break;
            }
            case 81: {
                this.nacDefModeProc();
                break;
            }
            case 42: {
                this.matchDefModeProc();
                break;
            }
            case 115: {
                this.mapModeProc();
                break;
            }
            case 116: {
                this.unmapModeProc();
                break;
            }
            case 117: {
                this.mapselModeProc();
                break;
            }
            case 118: {
                this.unmapselModeProc();
                break;
            }
            case 9: {
                this.viewModeProc();
                break;
            }
            default: {
                this.drawModeProc();
            }
        }
        this.fireEditEvent(new EditEvent(this, mode));
    }

    private void drawModeProc() {
        this.ruleEditor.setEditMode(11);
        this.graphEditor.setEditMode(11);
        this.lasteditmode = 11;
    }

    private void selectModeProc() {
        this.ruleEditor.setEditMode(12);
        this.graphEditor.setEditMode(12);
        this.lasteditmode = 12;
    }

    private void moveModeProc() {
        this.ruleEditor.setEditMode(13);
        this.graphEditor.setEditMode(13);
        this.lasteditmode = 13;
    }

    private void attributesModeProc() {
        this.ruleEditor.setEditMode(114);
        this.graphEditor.setEditMode(114);
        this.lasteditmode = 114;
    }

    private void ruleDefModeProc() {
        this.ruleEditor.setEditMode(31);
        this.graphEditor.setEditMode(31);
    }

    private void nacDefModeProc() {
        this.ruleEditor.setEditMode(81);
        this.graphEditor.setEditMode(81);
    }

    private void matchDefModeProc() {
        this.ruleEditor.setEditMode(42);
    }

    private void mapModeProc() {
        this.ruleEditor.setEditMode(115);
        this.graphEditor.setEditMode(115);
        this.lasteditmode = 115;
    }

    private void unmapModeProc() {
        this.ruleEditor.setEditMode(116);
        this.graphEditor.setEditMode(116);
        this.lasteditmode = 116;
    }

    private void mapselModeProc() {
        this.ruleEditor.setEditMode(117);
        this.graphEditor.setEditMode(117);
    }

    private void unmapselModeProc() {
        this.ruleEditor.setEditMode(118);
        this.graphEditor.setEditMode(118);
    }

    private void viewModeProc() {
        this.ruleEditor.setEditMode(9);
        this.graphEditor.setEditMode(9);
    }

    public void attrsProc() {
        if (this.editmode == 9) {
            return;
        }
        if (this.ruleEditor.getRule() == null && this.graphEditor.getGraph() == null) {
            return;
        }
        if (!this.getGraGra().getGraph().isEditable()) {
            return;
        }
        if (!this.graphEditor.hasSelection() && !this.ruleEditor.hasSelection()) {
            JOptionPane.showMessageDialog(null, "No object is selected.");
            this.errMsg = true;
            return;
        }
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        if (this.ruleEditor.hasOneSelection() && !this.graphEditor.hasSelection()) {
            EdGraphObject ego = null;
            if (this.ruleEditor.getRule().getLeft().hasOneSelection()) {
                ego = (EdGraphObject)this.ruleEditor.getRule().getLeft().getSelectedObjs().firstElement();
            } else if (this.ruleEditor.getRule().getRight().hasOneSelection()) {
                ego = (EdGraphObject)this.ruleEditor.getRule().getRight().getSelectedObjs().firstElement();
            } else if (this.ruleEditor.getNAC().hasOneSelection()) {
                ego = (EdGraphObject)this.ruleEditor.getNAC().getSelectedObjs().firstElement();
            }
            if (ego != null) {
                this.getAttrEditor(ego);
                this.getAttrEditor().enableContextEditor(true);
                this.setAttrEditorOnBottom(this.getAttrEditor().getComponent());
                this.fireEditEvent(new EditEvent((Object)this, -1, "To get the graph editor again click on the graph in the tree view."));
            } else {
                JOptionPane.showMessageDialog(null, "No object is selected.");
                this.errMsg = true;
            }
        } else if (this.graphEditor.hasOneSelection() && !this.ruleEditor.hasSelection()) {
            this.getAttrEditor((EdGraphObject)this.graphEditor.getGraph().getSelectedObjs().firstElement());
            this.getAttrEditor().enableContextEditor(false);
            this.setAttrEditorOnTop(this.getAttrEditor().getComponent());
            this.fireEditEvent(new EditEvent((Object)this, -1, "To get the rule editor again click on the rule in the tree view."));
        } else {
            JOptionPane.showMessageDialog(null, "Too many selections.\nPlease select only one object.");
            this.errMsg = true;
        }
    }

    public boolean deleteProc() {
        if (this.editmode == 9) {
            return false;
        }
        if (this.ruleEditor.getRule() == null && this.graphEditor.getGraph() == null) {
            return false;
        }
        if (!this.getGraGra().getGraph().isEditable()) {
            return false;
        }
        if (!this.graphEditor.hasSelection() && !this.ruleEditor.hasSelection()) {
            return false;
        }
        this.errMsg = false;
        int answer = this.removeWarning("Do you want realy to delete \nall selected objects ?");
        if (answer == 0) {
            this.ruleEditor.deleteProc();
            if (this.graphEditor.deleteProc()) {
                this.ruleEditor.getRule().update();
            }
        }
        return true;
    }

    public void copyProc() {
        if (this.editmode == 9) {
            return;
        }
        if (this.ruleEditor.getRule() == null && this.graphEditor.getGraph() == null) {
            return;
        }
        if (!this.getGraGra().getGraph().isEditable()) {
            return;
        }
        this.errMsg = false;
        if (this.splitPane.getTopComponent() instanceof RuleEditor && this.splitPane.getBottomComponent() instanceof GraphEditor) {
            if (!this.graphEditor.hasSelection() && !this.ruleEditor.hasSelection()) {
                JOptionPane.showMessageDialog(null, "Cannot make a copy. \nNo object is selected.");
                this.errMsg = true;
                return;
            }
            if (this.ruleEditor.hasSelection() && !this.ruleEditor.hasOneSelection()) {
                JOptionPane.showMessageDialog(null, "Too many selections. \nPlease select only objects within the same graph panel.");
                this.errMsg = true;
                return;
            }
            if (this.ruleEditor.hasSelection() && this.graphEditor.hasSelection()) {
                JOptionPane.showMessageDialog(null, "Too many selections. \nPlease select only objects within the same graph panel.");
                this.errMsg = true;
                return;
            }
            EdGraph gCopy = this.ruleEditor.getSelectedAsGraphCopy();
            if (gCopy != null) {
                this.ruleEditor.setGraphToCopy(gCopy);
                this.graphEditor.setGraphToCopy(gCopy);
                this.graphEditor.setSourceOfCopy(this.ruleEditor.getSourceOfCopy());
            } else {
                gCopy = this.graphEditor.getSelectedAsGraphCopy();
                if (gCopy != null) {
                    this.ruleEditor.setGraphToCopy(gCopy);
                    this.ruleEditor.setSourceOfCopy(this.graphEditor.getGraph());
                    this.graphEditor.setGraphToCopy(gCopy);
                }
            }
            if (gCopy != null) {
                this.graphToCopy = gCopy;
                this.fireEditEvent(new EditEvent((Object)this, -1, "To get a copy click on the background of a panel."));
                this.ruleEditor.setEditMode(15);
                this.graphEditor.setEditMode(15);
            } else {
                JOptionPane.showMessageDialog(null, "Bad selection. \nPlease check selected edges.\nSource and target nodes should be selected, too.");
                this.errMsg = true;
            }
        }
    }

    public void pasteProc() {
        if (this.editmode == 9) {
            return;
        }
        if (this.ruleEditor.getRule() == null && this.graphEditor.getGraph() == null) {
            return;
        }
        if (!this.getGraGra().getGraph().isEditable()) {
            return;
        }
        this.errMsg = false;
        if (this.splitPane.getTopComponent() instanceof RuleEditor && this.splitPane.getBottomComponent() instanceof GraphEditor) {
            if (this.graphToCopy != null) {
                this.ruleEditor.setGraphToCopy(this.graphToCopy);
                this.ruleEditor.setSourceOfCopy(null);
                this.graphEditor.setGraphToCopy(this.graphToCopy);
                this.graphEditor.setSourceOfCopy(null);
                this.fireEditEvent(new EditEvent((Object)this, -1, "To paste a copy click on the background of the panel."));
                this.ruleEditor.setEditMode(15);
                this.graphEditor.setEditMode(15);
            } else {
                JOptionPane.showMessageDialog(null, "No graph objects are copied.\nTo paste the graph objects into another (rule or host) graph:\n - select the objects and click the \"Copy\" icon \n - choose the favoured graph \n - click the \"Paste\" icon and finally \n - click on the background of the graph panel to place the copy.");
            }
        }
    }

    public void resetAfterCopy() {
        this.ruleEditor.setGraphToCopy(null);
        this.graphEditor.setGraphToCopy(null);
    }

    public void selectAllProc() {
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        if (this.splitPane.getTopComponent() instanceof RuleEditor) {
            this.ruleEditor.selectAllProc();
        }
        if (this.splitPane.getBottomComponent() instanceof GraphEditor) {
            this.graphEditor.selectAllProc();
        }
        this.fireEditEvent(new EditEvent((Object)this, -1, ""));
    }

    public void selectNodeTypeProc() {
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        if (this.splitPane.getTopComponent() instanceof RuleEditor) {
            this.ruleEditor.selectNodeTypeProc();
        }
        if (this.splitPane.getBottomComponent() instanceof GraphEditor) {
            this.graphEditor.selectNodeTypeProc();
        }
        this.fireEditEvent(new EditEvent((Object)this, -1, ""));
    }

    public void selectArcTypeProc() {
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        if (this.splitPane.getTopComponent() instanceof RuleEditor) {
            this.ruleEditor.selectArcTypeProc();
        }
        if (this.splitPane.getBottomComponent() instanceof GraphEditor) {
            this.graphEditor.selectArcTypeProc();
        }
        this.fireEditEvent(new EditEvent((Object)this, -1, ""));
    }

    public void deselectAllProc() {
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        if (this.splitPane.getTopComponent() instanceof RuleEditor) {
            this.ruleEditor.deselectAllProc();
        }
        if (this.splitPane.getBottomComponent() instanceof GraphEditor) {
            this.graphEditor.deselectAllProc();
        }
        this.fireEditEvent(new EditEvent((Object)this, -1, ""));
    }

    public void straightenArcsProc() {
        if (this.editmode == 9) {
            return;
        }
        if (this.ruleEditor.getRule() == null && this.graphEditor.getGraph() == null) {
            return;
        }
        if (!this.getGraGra().getGraph().isEditable()) {
            return;
        }
        if (!this.graphEditor.hasSelection() && !this.ruleEditor.hasSelection()) {
            JOptionPane.showMessageDialog(null, "No object is selected.");
            this.errMsg = true;
            return;
        }
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        if (this.splitPane.getTopComponent() instanceof RuleEditor) {
            this.ruleEditor.straigthenArcsProc();
        }
        if (this.splitPane.getBottomComponent() instanceof GraphEditor) {
            this.graphEditor.straigthenArcsProc();
        }
    }

    public void doIdenticRuleProc() {
        if (this.editmode == 9) {
            return;
        }
        if (this.ruleEditor.getRule() == null) {
            return;
        }
        if (!this.getGraGra().getGraph().isEditable()) {
            return;
        }
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        this.ruleEditor.doIdenticRule();
        if (!this.ruleEditor.getMsg().equals("")) {
            this.fireEditEvent(new EditEvent((Object)this, -1, this.ruleEditor.getMsg()));
        }
    }

    public void doIdenticNacProc() {
        if (this.editmode == 9) {
            return;
        }
        if (this.ruleEditor.getRule() == null) {
            return;
        }
        if (!this.getGraGra().getGraph().isEditable()) {
            return;
        }
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        this.ruleEditor.doIdenticNAC();
        if (!this.ruleEditor.getMsg().equals("")) {
            this.fireEditEvent(new EditEvent((Object)this, -1, this.ruleEditor.getMsg()));
        }
    }

    public void setInterpreting(boolean enable) {
        this.interpreting = enable;
    }

    public void setLayering(boolean enable) {
        this.layering = enable;
    }

    public void doView(String command) {
        this.setEditMode(9);
        this.resetModeMenu(null);
        this.modePopupMenu.deselectAll();
        this.fireEditEvent(new EditEvent(this, 9));
    }

    public void doPreferencesProc(String command) {
        if (command.equals("bold")) {
            this.setFontStyle(1);
        } else if (command.equals("italic")) {
            this.setFontStyle(2);
        } else if (command.equals("plain")) {
            this.setFontStyle(0);
        } else if (command.equals("tiny")) {
            this.setFontSize(0);
        } else if (command.equals("small")) {
            this.setFontSize(8);
        } else if (command.equals("large")) {
            this.setFontSize(10);
        } else if (command.equals("LARGE")) {
            this.setFontSize(12);
        } else if (command.equals("0.5")) {
            this.setScale(0.5);
        } else if (command.equals("0.7")) {
            this.setScale(0.7);
        } else if (command.equals("1.0")) {
            this.setScale(1.0);
        } else if (command.equals("1.5")) {
            this.setScale(1.5);
        } else if (command.equals("2.0")) {
            this.setScale(2.0);
        }
    }

    private void setFontStyle(int fstyle) {
        this.ruleEditor.getLeftPanel().getCanvas().setFontStyle(fstyle);
        this.ruleEditor.getRightPanel().getCanvas().setFontStyle(fstyle);
        this.ruleEditor.getNACPanel().getCanvas().setFontStyle(fstyle);
        this.graphEditor.getGraphPanel().getCanvas().setFontStyle(fstyle);
        this.updateGraphics();
        this.fireEditEvent(new EditEvent((Object)this, -4, fstyle));
    }

    private void setFontSize(int fsize) {
        this.ruleEditor.getLeftPanel().getCanvas().setFontSize(fsize);
        this.ruleEditor.getRightPanel().getCanvas().setFontSize(fsize);
        this.ruleEditor.getNACPanel().getCanvas().setFontSize(fsize);
        this.graphEditor.getGraphPanel().getCanvas().setFontSize(fsize);
        this.updateGraphics();
        this.fireEditEvent(new EditEvent((Object)this, -5, fsize));
    }

    private void setScale(double scale) {
        this.ruleEditor.getLeftPanel().getCanvas().setScale(scale);
        this.ruleEditor.getRightPanel().getCanvas().setScale(scale);
        this.ruleEditor.getNACPanel().getCanvas().setScale(scale);
        this.graphEditor.getGraphPanel().getCanvas().setScale(scale);
        this.updateGraphics();
        this.fireEditEvent(new EditEvent((Object)this, -6, scale));
    }

    public final AttrTopEditor getAttrEditor(EdGraphObject ego) {
        EdArc ea;
        if (ego.isNode()) {
            EdNode en = (EdNode)ego;
            if (en.getBasisNode() != null) {
                this.attrEditor.setTuple(en.getBasisNode().getAttribute());
                en.setAttrViewSetting(this.attrEditor.getViewSetting());
                if (!en.isAttrObserver()) {
                    this.attrEditor.getViewSetting().addObserver(en, en.getBasisNode().getAttribute());
                    en.setAttrObserver(true);
                }
                en.setGraphPanel(this.getActivePanel());
            }
        } else if (ego.isArc() && (ea = (EdArc)ego).getBasisArc() != null) {
            this.attrEditor.setTuple(ea.getBasisArc().getAttribute());
            ea.setAttrViewSetting(this.attrEditor.getViewSetting());
            if (!ea.isAttrObserver()) {
                this.attrEditor.getViewSetting().addObserver(ea, ea.getBasisArc().getAttribute());
                ea.setAttrObserver(true);
            }
            ea.setGraphPanel(this.getActivePanel());
        }
        return this.attrEditor;
    }

    public GraGraTransform getGraGraTransform() {
        return this.gragraTransform;
    }

    public void updateGraphics() {
        this.ruleEditor.getLeftPanel().updateGraphics();
        this.ruleEditor.getRightPanel().updateGraphics();
        this.ruleEditor.getNACPanel().updateGraphics();
        this.graphEditor.getGraphPanel().updateGraphics();
        if (this.graphEditor.getGraph() != null) {
            this.graphEditor.getGraphPanel().getCanvas().setSize(this.graphEditor.getGraph().getGraphDimension());
        }
    }

    public void clear() {
        this.typeEditor.removeAll();
        this.setGraGra(null);
        this.graphEditor.setGraph(null);
        this.ruleEditor.setNAC(null);
        this.ruleEditor.setRule(null);
        this.pacMorphs.setGraGra(null);
        this.pacMorphs.setAtomApplCond(null);
        this.updateGraphics();
        this.fireEditEvent(new EditEvent((Object)this, -7, ""));
    }

    public void setNodeIconable(boolean iconable) {
        this.iconable = iconable;
        if (this.gragra != null) {
            this.gragra.getTypeSet().setNodeIconable(iconable);
            this.updateGraphics();
        }
    }

    public void resetEnabled(boolean enable) {
        this.setEnabled(enable);
        this.edit.setEnabled(enable);
        this.mode.setEnabled(enable);
        this.transform.setEnabled(enable);
    }

    public void setMsg(String s) {
        this.fireEditEvent(new EditEvent((Object)this, -1, s));
    }

    public void setExportJPEG(GraphicsExportJPEG jpg) {
        this.exportJPEG = jpg;
        this.modePopupMenu.setGraphExportJPEG(jpg);
        this.ruleEditor.setExportJPEG(jpg);
        this.graphEditor.setExportJPEG(jpg);
        ((TopEditor)this.attrEditor).setExportJPEG(jpg);
    }

    public MorphCompletionStrategy getMorphCompletionStrategy() {
        return this.gragraTransform.getStrategy();
    }

    public void startLayeredTransform() {
        this.layeredTransform = this.gragraTransform.createTransformLayered();
        this.layering = true;
        this.gragraTransform.startTransformLayered(this.getGraGra());
    }

    public void startTransformInterpreter() {
        this.interpreter = this.gragraTransform.createTransformInterpreter();
        this.interpreting = true;
        this.gragraTransform.startTransformInterpreter(this.getGraGra());
    }

    private boolean isEditable() {
        if (!this.getGraGra().getGraph().isEditable()) {
            this.updateGraphics();
            JOptionPane.showMessageDialog(null, "Grammar is locked by critical pair analysis \nor transformation is already running.", "Cannot transform", 2);
            return false;
        }
        return true;
    }

    private boolean isGraGraReadyToTransform(EdGraGra gra) {
        String msgstr = "";
        if (!gra.getBasisGraGra().isGraphReadyForTransform()) {
            msgstr = "The host graph of this grammar is not fine.\nPlease check attribute settings of the objects.";
        } else {
            Pair obj = gra.getBasisGraGra().isReadyToTransform();
            if (obj != null) {
                if (obj instanceof Rule) {
                    msgstr = "The rule  <" + ((Rule)((Object)obj)).getName() + ">  of this grammar is not fine.\n" + "Please check attribute settings of the objects.";
                } else if (obj instanceof AtomConstraint) {
                    msgstr = "The graph constraint  <" + ((AtomConstraint)((Object)obj)).getName() + ">  of this grammar is not fine.\n" + "Please check attribute settings of the objects.";
                }
            }
        }
        if (!msgstr.equals("")) {
            this.updateGraphics();
            JOptionPane.showMessageDialog(null, "Not ready to transform!\n" + msgstr, "Cannot transform", 0);
            this.selectToolBarTransformItem("");
            this.setEditMode(this.lasteditmode);
            return false;
        }
        return true;
    }

    private void doPrepareTransformationProc() {
        this.createUndoGraph();
        this.resetIconsIfTransformInterpret(false);
        this.lasteditmode = this.getEditMode();
        this.setEditMode(9);
        this.gragraTransform.getApplicableRules(this.getGraGra(), true);
    }

    private void doStopTransformInterpreterProc() {
        this.selectToolBarTransformItem("stop");
        this.selectToolBarTransformItem("stop");
        this.requestFocusInWindow();
        this.sleep = false;
        this.gragraTransform.stopTransformInterpreter();
        this.resetIconsIfTransformInterpret(true);
        this.setEditMode(this.lasteditmode);
    }

    private void doPrepareInteractiveMatchProc() {
        this.lasteditmode = this.getEditMode();
        if (this.getGraGra() != null && this.ruleEditor.getRule() != null) {
            if (!this.getGraGra().getGraph().isEditable()) {
                JOptionPane.showMessageDialog(null, "Grammar is locked by critical pair analysis \nor transformation is already running.", "Cannot transform", 2);
                return;
            }
            ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
            if (!this.interpreting && !this.layering) {
                Vector applicableRules;
                this.selectToolBarTransformItem("match");
                if (this.gragraTransform.checkRuleApplicabilityEnabled() && !(applicableRules = this.gragraTransform.getApplicableRules(this.getGraGra())).contains(this.ruleEditor.getRule().getBasisRule())) {
                    JOptionPane.showMessageDialog(null, "Current rule isn't applicable. \nPlease select an applicable rule.", "Cannot match", 2);
                    this.selectToolBarTransformItem("");
                    return;
                }
                this.gragraTransform.matchDef(this.ruleEditor.getRule());
            }
        }
    }

    private void doPrepareCompletionMatchProc() {
        if (this.getGraGra() != null && this.ruleEditor.getRule() != null) {
            if (!this.getGraGra().getGraph().isEditable()) {
                JOptionPane.showMessageDialog(null, "Grammar is locked by critical pair analysis \nor transformation is already running.", "Cannot transform", 2);
                return;
            }
            ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
            if (!this.interpreting && !this.layering) {
                if (this.tmpTransformThread == null || !this.tmpTransformThread.isAlive()) {
                    this.selectToolBarTransformItem("completion");
                    if (this.ruleEditor.isObjMapping()) {
                        this.ruleEditor.resetEditModeAfterMapping();
                    }
                    if (this.getEditMode() == 42) {
                        this.setEditMode(this.lasteditmode);
                    }
                    this.tmpTransformThread = new Thread(){

                        public void run() {
                            GraGraEditor.this.gragraTransform.nextCompletion(GraGraEditor.this.ruleEditor.getRule());
                        }
                    };
                    this.tmpTransformThread.start();
                } else {
                    this.fireEditEvent(new EditEvent((Object)this, -1, " next completion ... Please wait. "));
                }
            }
        }
    }

    private void doExecuteStepProc() {
        ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
        if (!this.interpreting && !this.layering) {
            this.createUndoGraph();
            if (this.tmpTransformThread == null || !this.tmpTransformThread.isAlive()) {
                this.selectToolBarTransformItem("step");
                if (this.getEditMode() == 42) {
                    this.setEditMode(this.lasteditmode);
                }
                this.tmpTransformThread = new Thread(){

                    public void run() {
                        GraGraEditor.this.gragraTransform.step(GraGraEditor.this.ruleEditor.getRule());
                    }
                };
                this.tmpTransformThread.start();
            } else {
                this.fireEditEvent(new EditEvent((Object)this, -1, " transformation step ... Please wait. "));
            }
        }
    }

    private void doUnduGraphTransformationProc() {
        if (this.getGraGra().getUndoGraph() != null) {
            EdGraph undoGraph = (EdGraph)this.undoGraphs.get(this.getGraGra().getGraph());
            EdGraph ug = null;
            if (undoGraph != null) {
                ug = undoGraph.copy();
            }
            if (ug != null) {
                ug.setGraGra(this.getGraGra());
            }
            if (ug != null && this.getGraGra().resetGraph(ug)) {
                this.getGraGra().setUndoGraph(null);
                this.undoGraphs.remove(this.getGraGra().getGraph());
                if (this.treeNodeData != null) {
                    if (!this.treeNodeData.isTypeGraph) {
                        if (this.treeNodeData.isGraph) {
                            this.treeNodeData.setData(this.getGraGra().getGraph());
                        }
                        this.graphEditor.setGraph(this.getGraGra().getGraph());
                        this.graphEditor.updateGraphics();
                    } else if (this.treeNodeData.isTypeGraph || !this.treeNodeData.isGraph) {
                        DefaultMutableTreeNode treeNode = this.treeNodeData.getTreeNode();
                        GraGraTreeNodeData data = (GraGraTreeNodeData)treeNode.getUserObject();
                        if (data.isGraGra) {
                            if (data.getGraGra().getBasisGraGra().getTypeGraph() != null) {
                                DefaultMutableTreeNode gNode = (DefaultMutableTreeNode)treeNode.getChildAt(1);
                                ((GraGraTreeNodeData)gNode.getUserObject()).setData(data.getGraGra().getGraph());
                            } else {
                                DefaultMutableTreeNode gNode = (DefaultMutableTreeNode)treeNode.getChildAt(0);
                                ((GraGraTreeNodeData)gNode.getUserObject()).setData(data.getGraGra().getGraph());
                            }
                        } else {
                            DefaultMutableTreeNode pNode = (DefaultMutableTreeNode)treeNode.getParent();
                            if (pNode != null) {
                                GraGraTreeNodeData pData = (GraGraTreeNodeData)pNode.getUserObject();
                                while (!pData.isGraGra) {
                                    pNode = (DefaultMutableTreeNode)pNode.getParent();
                                    pData = (GraGraTreeNodeData)pNode.getUserObject();
                                }
                                if (pData.getGraGra().getBasisGraGra().getTypeGraph() != null) {
                                    DefaultMutableTreeNode pComp = (DefaultMutableTreeNode)pNode.getChildAt(1);
                                    ((GraGraTreeNodeData)pComp.getUserObject()).setData(pData.getGraGra().getGraph());
                                } else {
                                    DefaultMutableTreeNode pComp = (DefaultMutableTreeNode)pNode.getChildAt(0);
                                    ((GraGraTreeNodeData)pComp.getUserObject()).setData(pData.getGraGra().getGraph());
                                }
                            }
                        }
                    }
                }
                if (this.gragraTransform.checkRuleApplicabilityEnabled()) {
                    this.gragraTransform.getApplicableRules(this.getGraGra());
                }
                this.fireEditEvent(new EditEvent((Object)this, -1, "Undo graph after transformation is done."));
            } else {
                JOptionPane.showMessageDialog(null, "Undo graph after transformation is failed.");
            }
        } else {
            if (!this.gragraTransform.checkRuleApplicabilityEnabled()) {
                this.gragraTransform.getApplicableRules(this.getGraGra(), true);
            }
            this.fireEditEvent(new EditEvent((Object)this, -1, "Any rule has been applied or undo is not possible because of type mismatch."));
        }
    }

    private void loadDataInEditor(GraGraTreeNodeData data) {
        EdGraGra gra = null;
        EdGraph graph = null;
        EdRule rule = null;
        EdNAC nac = null;
        EdAtomic atom = null;
        EdAtomApplCond applcond = null;
        boolean resetGraGra = false;
        boolean oldAtomApplCond = this.isAtomApplCond;
        this.isAtomApplCond = false;
        if (data.isGraGra && data.getGraGra() != null && data.getGraGra().getBasisGraGra() != null) {
            gra = data.getGraGra();
            if (gra != this.gragra) {
                resetGraGra = true;
                this.dividerLocation = this.splitPane.getDividerLocation();
                this.dividerLocation1 = this.typeEditor.getTypePalette().getDividerLocation();
                graph = gra.getGraph();
                if (!gra.getRules().isEmpty()) {
                    rule = (EdRule)gra.getRules().firstElement();
                    if (rule.getMatch() != null) {
                        rule.update();
                        graph.update();
                    }
                    if (rule != null && !rule.getNACs().isEmpty()) {
                        nac = (EdNAC)rule.getNACs().firstElement();
                    }
                } else {
                    this.dividerLocation = 0;
                }
            }
        } else if (data.isGraph && data.getGraph() != null && data.getGraph().getBasisGraph() != null) {
            graph = data.getGraph();
            if (graph != this.graphEditor.getGraph() || this.graphEditor.isEmpty()) {
                if (this.gragra == null || graph.getGraGra() != this.gragra) {
                    resetGraGra = true;
                    gra = graph.getGraGra();
                    if (!graph.isTypeGraph()) {
                        gra.resetGraph(graph);
                    }
                    if (!gra.getRules().isEmpty()) {
                        rule = (EdRule)gra.getRules().firstElement();
                    }
                    if (rule != null && !rule.getNACs().isEmpty()) {
                        nac = (EdNAC)rule.getNACs().firstElement();
                    }
                } else if (!graph.isTypeGraph()) {
                    if (this.gragra.getGraph() != graph) {
                        this.gragra.resetGraph(graph);
                    }
                    graph = this.gragra.getGraph();
                    data.setData(graph);
                    this.graphEditor.setGraph(graph);
                    this.graphEditor.updateGraphics();
                } else {
                    this.graphEditor.setGraph(graph);
                    this.graphEditor.updateGraphics();
                }
            }
        } else if (data.isAtomic && data.getAtomic() != null && data.getAtomic().getBasisAtomic() != null) {
            atom = data.getAtomic();
            if (atom != this.ruleEditor.getAtomic()) {
                this.dividerLocation = this.splitPane.getDividerLocation();
                if (this.ruleEditor.getAtomic() != null) {
                    this.dividerLocationSet.put(this.ruleEditor.getAtomic(), new Integer(this.splitPane.getDividerLocation()));
                }
                if (this.gragra == null || atom.getGraGra() != this.gragra) {
                    resetGraGra = true;
                    gra = atom.getGraGra();
                    graph = gra.getGraph();
                } else if (this.ruleEditor.getAtomic() == null || this.ruleEditor.getAtomic().getParent() != atom) {
                    atom.update();
                    this.ruleEditor.setAtomic(atom);
                    if (this.dividerLocationSet.get(atom) != null) {
                        this.splitPane.setDividerLocation((Integer)this.dividerLocationSet.get(atom));
                    }
                    this.ruleEditor.updateGraphics();
                }
            }
            this.resetEnabledOfMenus(data, false);
            this.resetEnabledOfToolBarItems(data, false);
        } else if (data.isConclusion && data.getAtomic() != null && data.getAtomic().getBasisAtomic() != null) {
            atom = data.getAtomic();
            if (atom != this.ruleEditor.getAtomic()) {
                if (this.gragra == null || atom.getGraGra() != this.gragra) {
                    resetGraGra = true;
                    gra = atom.getGraGra();
                    graph = gra.getGraph();
                } else {
                    atom.update();
                    this.ruleEditor.setAtomic(atom);
                    this.ruleEditor.updateGraphics();
                    if (this.ruleEditor.isObjMapping()) {
                        this.ruleEditor.resetEditModeAfterMapping();
                    }
                }
            }
            this.resetEnabledOfMenus(data, false);
            this.resetEnabledOfToolBarItems(data, false);
        } else if (data.isRule && data.getRule() != null && data.getRule().getBasisRule() != null) {
            rule = data.getRule();
            if (rule != this.ruleEditor.getRule()) {
                this.dividerLocation = this.splitPane.getDividerLocation();
                if (this.ruleEditor.getRule() != null) {
                    this.dividerLocationSet.put(this.ruleEditor.getRule(), new Integer(this.splitPane.getDividerLocation()));
                }
                if (this.gragra == null || rule.getGraGra() != this.gragra) {
                    resetGraGra = true;
                    gra = rule.getGraGra();
                    graph = gra.getGraph();
                }
                if (!rule.getNACs().isEmpty()) {
                    nac = (EdNAC)rule.getNACs().firstElement();
                }
                if (!resetGraGra) {
                    this.ruleEditor.setRule(rule);
                    this.ruleEditor.setNAC(nac);
                    if (rule != null && this.dividerLocationSet.get(rule) != null) {
                        this.splitPane.setDividerLocation((Integer)this.dividerLocationSet.get(rule));
                    } else {
                        this.splitPane.setDividerLocation(this.dividerLocation);
                    }
                    this.ruleEditor.updateGraphics();
                    if (this.ruleEditor.isObjMapping()) {
                        this.ruleEditor.resetEditModeAfterMapping();
                    }
                }
            }
            this.resetEnabledOfMenus(data, false);
            this.resetEnabledOfToolBarItems(data, false);
        } else if (data.isConstraint) {
            gra = data.getConstraint().getGraGra();
            if (gra != null && gra != this.gragra) {
                resetGraGra = true;
                this.dividerLocation = this.splitPane.getDividerLocation();
                graph = gra.getGraph();
                if (!gra.getRules().isEmpty() && (rule = (EdRule)gra.getRules().firstElement()).getMatch() != null) {
                    rule.update();
                    graph.update();
                }
                if (rule != null && !rule.getNACs().isEmpty()) {
                    nac = (EdNAC)rule.getNACs().firstElement();
                }
            }
        } else if (data.isRuleConstraint) {
            DefaultMutableTreeNode n;
            if (data.getTreeNode() != null && (n = data.getTreeNode()).getChildCount() != 0) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)n.getChildAt(0);
                GraGraTreeNodeData c = (GraGraTreeNodeData)child.getUserObject();
                applcond = c.getAtomApplCond();
                if (this.gragra != null) {
                    gra = ((GraGraTreeNodeData)((DefaultMutableTreeNode)n.getParent().getParent()).getUserObject()).getGraGra();
                    rule = ((GraGraTreeNodeData)((DefaultMutableTreeNode)n.getParent()).getUserObject()).getRule();
                    if (gra != this.gragra) {
                        resetGraGra = true;
                        graph = gra.getGraph();
                    }
                    this.pacMorphs.setGraGra(gra);
                    this.pacMorphs.setRule(rule);
                    this.pacMorphs.setAtomApplCond(applcond.getAtomApplCond());
                    this.resetEnabledOfMenus(c, false);
                    this.resetEnabledOfToolBarItems(c, false);
                    this.isAtomApplCond = true;
                }
            }
        } else if (data.isAtomApplCond && data.getAtomApplCond() != null) {
            if (data.getTreeNode() != null) {
                DefaultMutableTreeNode n = data.getTreeNode();
                applcond = data.getAtomApplCond();
                if (this.gragra != null) {
                    gra = ((GraGraTreeNodeData)((DefaultMutableTreeNode)n.getParent().getParent().getParent()).getUserObject()).getGraGra();
                    rule = ((GraGraTreeNodeData)((DefaultMutableTreeNode)n.getParent().getParent()).getUserObject()).getRule();
                    if (gra != this.gragra) {
                        resetGraGra = true;
                        graph = gra.getGraph();
                    }
                    this.pacMorphs.setGraGra(this.gragra);
                    this.pacMorphs.setRule(rule);
                    this.pacMorphs.setAtomApplCond(applcond.getAtomApplCond());
                    this.resetEnabledOfMenus(data, false);
                    this.resetEnabledOfToolBarItems(data, false);
                    this.isAtomApplCond = true;
                }
            }
        } else if (data.isNAC && data.getNAC() != null && data.getNAC().getBasisGraph() != null) {
            nac = data.getNAC();
            if (this.gragra == null || nac.getRule().getGraGra() != this.gragra) {
                resetGraGra = true;
                rule = nac.getRule();
                gra = rule.getGraGra();
                graph = gra.getGraph();
            } else if (nac.getRule() != this.ruleEditor.getRule()) {
                rule = nac.getRule();
                this.ruleEditor.setRule(rule);
                this.ruleEditor.setNAC(nac);
                if (this.dividerLocationSet.get(rule) != null) {
                    int divloc = (Integer)this.dividerLocationSet.get(rule);
                    if (nac != null && this.dividerLocationSet.get(nac) != null) {
                        int divloc1 = (Integer)this.dividerLocationSet.get(nac);
                        if (divloc >= divloc1) {
                            this.splitPane.setDividerLocation(divloc);
                        } else {
                            this.splitPane.setDividerLocation(divloc1);
                        }
                    } else {
                        this.splitPane.setDividerLocation((Integer)this.dividerLocationSet.get(rule));
                    }
                } else {
                    this.splitPane.setDividerLocation(this.dividerLocation);
                }
                this.ruleEditor.updateGraphics();
                if (this.ruleEditor.isObjMapping()) {
                    this.ruleEditor.resetEditModeAfterMapping();
                }
                this.ruleEditor.showNAC();
            } else if (nac != this.ruleEditor.getNAC()) {
                this.dividerLocation = this.splitPane.getDividerLocation();
                if (this.ruleEditor.getNAC() != null) {
                    this.dividerLocationSet.put(this.ruleEditor.getNAC(), new Integer(this.splitPane.getDividerLocation()));
                }
                this.ruleEditor.saveRuleScrollBarValue();
                this.ruleEditor.setNAC(nac);
                if (this.dividerLocationSet.get(nac) != null) {
                    this.splitPane.setDividerLocation((Integer)this.dividerLocationSet.get(nac));
                }
                if (this.ruleEditor.isObjMapping()) {
                    this.ruleEditor.resetEditModeAfterMapping();
                }
            }
            this.resetEnabledOfMenus(data, false);
            this.resetEnabledOfToolBarItems(data, false);
        } else if (data.isAttrCondition) {
            EdAtomic conclusion;
            if (this.ruleEditor.getAtomic() != null) {
                Pair attrCond = data.getAttrCondition();
                if (attrCond.second instanceof EdAtomic) {
                    conclusion = (EdAtomic)attrCond.second;
                    if (conclusion.getParent().getGraGra() != this.gragra) {
                        resetGraGra = true;
                        gra = conclusion.getParent().getGraGra();
                        graph = gra.getGraph();
                    } else if (conclusion != this.ruleEditor.getAtomic()) {
                        this.ruleEditor.setAtomic(conclusion);
                    }
                    AttrContext attrContext = conclusion.getMorph().getAttrContext();
                    this.attrEditor.setContext(attrContext);
                    this.setAttrEditorOnBottom(this.attrEditor.getComponent());
                    ((TopEditor)this.attrEditor).selectContextEditor(true);
                    ((TopEditor)this.attrEditor).setTuple(null);
                }
            } else if (this.ruleEditor.getRule() != null) {
                Pair attrCond = data.getAttrCondition();
                if (attrCond.second instanceof EdAtomic) {
                    conclusion = (EdAtomic)attrCond.second;
                    if (conclusion.getParent().getGraGra() != this.gragra) {
                        resetGraGra = true;
                        gra = conclusion.getParent().getGraGra();
                        graph = gra.getGraph();
                    } else if (conclusion != this.ruleEditor.getAtomic()) {
                        this.ruleEditor.setAtomic(conclusion);
                    }
                    AttrContext attrContext = conclusion.getMorph().getAttrContext();
                    this.attrEditor.setContext(attrContext);
                    this.setAttrEditorOnBottom(this.attrEditor.getComponent());
                    ((TopEditor)this.attrEditor).selectContextEditor(true);
                    ((TopEditor)this.attrEditor).setTuple(null);
                } else {
                    rule = (EdRule)attrCond.second;
                    AttrContext attrContext = rule.getBasisRule().getAttrContext();
                    this.attrEditor.setContext(attrContext);
                    if (rule.getGraGra() != this.gragra) {
                        resetGraGra = true;
                        gra = rule.getGraGra();
                        graph = gra.getGraph();
                    } else if (rule != this.ruleEditor.getRule()) {
                        this.ruleEditor.setRule(rule);
                        ((TopEditor)this.attrEditor).setTuple(null);
                    }
                    if (this.hasAttrEditorOnTop()) {
                        this.resetRuleEditor();
                    }
                    this.setAttrEditorOnBottom(this.attrEditor.getComponent());
                    ((TopEditor)this.attrEditor).selectContextEditor(true);
                }
            }
        }
        if (this.hasAttrEditorOnTop()) {
            this.attrTypeChangedWarning();
            if (rule != null) {
                this.ruleEditor.setRule(rule);
            }
            this.resetRuleEditor();
        } else if (this.hasAttrEditorOnBottom() && !data.isAttrCondition) {
            this.attrTypeChangedWarning();
            this.resetGraphEditor();
        }
        if (oldAtomApplCond != this.isAtomApplCond) {
            this.resetRuleEditor();
        }
        if (resetGraGra) {
            this.setGraGra(gra);
            this.typeEditor.setGraGra(gra);
            if (this.dividerLocation1 == 0) {
                this.typeEditor.getTypePalette().setDividerLocation(this.splitPane0.getDividerLocation() + this.splitPane.getDividerLocation() + 10);
            } else {
                this.typeEditor.getTypePalette().setDividerLocation(this.dividerLocation1);
            }
            this.splitPane1.setRightComponent(this.typeEditor.getTypePalette().getSplitComponent());
            this.splitPane1.setDividerLocation(this.getWidth() - 100);
            this.graphEditor.setGraph(graph);
            this.resetEnabledOfMenus(data, true);
            this.resetEnabledOfToolBarItems(data, true);
            if (atom != null) {
                this.ruleEditor.setAtomic(atom);
                if (this.dividerLocationSet.get(atom) != null) {
                    this.splitPane.setDividerLocation((Integer)this.dividerLocationSet.get(atom));
                } else {
                    this.splitPane.setDividerLocation(this.dividerLocation);
                }
            } else {
                this.ruleEditor.setRule(rule);
                this.ruleEditor.setNAC(nac);
                if (rule != null && this.dividerLocationSet.get(rule) != null) {
                    int divloc = (Integer)this.dividerLocationSet.get(rule);
                    if (nac != null && this.dividerLocationSet.get(nac) != null) {
                        int divloc1 = (Integer)this.dividerLocationSet.get(nac);
                        if (divloc >= divloc1) {
                            this.splitPane.setDividerLocation(divloc);
                        } else {
                            this.splitPane.setDividerLocation(divloc1);
                        }
                    } else {
                        this.splitPane.setDividerLocation((Integer)this.dividerLocationSet.get(rule));
                    }
                } else {
                    this.splitPane.setDividerLocation(this.dividerLocation);
                }
                if (nac == null) {
                    this.ruleEditor.hideNAC();
                }
            }
            this.updateGraphics();
            if (this.getEditMode() == -1) {
                this.setEditMode(11);
                this.selectToolBarModeItem("Draw");
            } else if (this.getGraGra().getTypeSet().isEmpty()) {
                this.setEditMode(11);
                this.selectToolBarModeItem("Draw");
            } else {
                if (this.ruleEditor.isObjMapping()) {
                    this.ruleEditor.resetEditModeAfterMapping();
                }
                this.setEditMode(this.lasteditmode);
                this.selectToolBarModeItem(this.lasteditmode);
            }
            if (this.gragraTransform.checkRuleApplicabilityEnabled()) {
                this.gragraTransform.getApplicableRules(this.getGraGra());
            }
        }
        this.fireEditEvent(new EditEvent((Object)this, -9, ""));
    }

    private void deleteDataOfEditor(GraGraTreeNodeData data) {
        if (data.isGraGra) {
            for (int i = 0; i < data.getGraGra().getRules().size(); ++i) {
                this.removeRuleContextFromAttrEditor((EdRule)data.getGraGra().getRules().elementAt(i));
            }
            if (data.getGraGra().equals(this.gragra)) {
                this.clear();
            }
        } else if (data.isTypeGraph) {
            if (data.getGraph().equals(this.graphEditor.getGraph())) {
                this.graphEditor.clear();
            }
        } else if (data.isGraph && !data.isTypeGraph) {
            if (data.getGraph().equals(this.graphEditor.getGraph())) {
                this.graphEditor.clear();
            }
        } else if (data.isRule) {
            this.removeRuleContextFromAttrEditor(data.getRule());
            if (data.getRule().equals(this.ruleEditor.getRule())) {
                this.ruleEditor.clear();
            }
        } else if (data.isNAC) {
            if (data.getNAC().equals(this.ruleEditor.getNAC())) {
                this.ruleEditor.clearNAC();
            }
        } else if (data.isAtomic) {
            if (data.getAtomic().equals(this.ruleEditor.getAtomic())) {
                this.ruleEditor.clear();
            }
        } else if (data.isConclusion) {
            if (data.getConclusion().equals(this.ruleEditor.getAtomic())) {
                this.ruleEditor.clear();
            }
        } else if (data.isAtomApplCond) {
            this.pacMorphs.setAtomApplCond(null);
        }
    }

    private void removeRuleContextFromAttrEditor(EdRule r) {
        ((OpenViewSetting)this.getAttrEditor().getViewSetting().getOpenView()).removeFormat(r.getBasisRule().getAttrContext().getVariables().getType());
        ((OpenViewSetting)this.getAttrEditor().getViewSetting().getOpenView()).removeFormat(r.getBasisRule().getAttrContext().getConditions().getType());
    }

    private EdGraph createUndoGraph() {
        EdGraph g = this.getGraGra().getGraph().copy();
        g.setGraGra(this.getGraGra());
        this.getGraGra().setUndoGraph(g);
        this.undoGraphs.put(this.getGraGra().getGraph(), g);
        return g;
    }

    private void createMainMenus() {
        this.mainMenus = new Vector();
        String[] editLabels = new String[]{"Attributes                                    Ctrl+A", "Delete                                          Ctrl+D", "Copy                                            Ctrl+C", "Paste                                            Ctrl+P", "Select Nodes of Type            Ctrl+Alt+N", "Select Edges of Type             Ctrl+Alt+E", "Select All                               Ctrl+Alt+S", "Deselect All                          Ctrl+Alt+U", "Straighten Edges                         Ctrl+E", "Identic Rule                           Ctrl+Shift+R", "Identic NAC                           Ctrl+Shift+N"};
        String[] editCommands = new String[]{"attributes", "delete", "copy", "paste", "selectNodeType", "selectArcType", "selectAll", "deselectAll", "straighten", "identicRule", "identicNAC"};
        this.edit = new JMenu("Edit", true);
        this.edit.setMnemonic('E');
        for (int i = 0; i < editLabels.length; ++i) {
            JMenuItem mi = new JMenuItem(editLabels[i]);
            mi.setEnabled(true);
            mi.setActionCommand(editCommands[i]);
            mi.addActionListener(this);
            this.edit.add(mi);
            if (!editCommands[i].equals("attributes") && !editCommands[i].equals("paste") && !editCommands[i].equals("deselectAll") && !editCommands[i].equals("straighten")) continue;
            this.edit.addSeparator();
        }
        this.mainMenus.addElement(this.edit);
        String[] modeLabels = new String[]{"Draw              Shift+D", "Select              Shift+S", "Move              Shift+M", "Attributes       Shift+A", "Map                 Ctrl+M", "Unmap             Ctrl+U", "Image_view"};
        String[] modeCommands = new String[]{"drawMode", "selectMode", "moveMode", "attributesMode", "mapMode", "unmapMode", "imageMode"};
        this.mode = new JMenu("Mode", true);
        this.mode.setMnemonic('M');
        for (int i = 0; i < modeLabels.length; ++i) {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(modeLabels[i]);
            mi.setEnabled(true);
            mi.setActionCommand(modeCommands[i]);
            mi.addActionListener(this);
            this.mode.add(mi);
            if (!modeCommands[i].equals("unmapMode")) continue;
            this.mode.addSeparator();
        }
        this.mode.getItem(0).setSelected(true);
        this.mainMenus.addElement(this.mode);
        String[] transLabels = new String[]{"Start                         Shift+Ctrl+T", "Stop                         Shift+Ctrl+Q", "Match                       Shift+Ctrl+M", "Next Completion      Shift+Ctrl+C", "Step                          Shift+Ctrl+S", "Undo                        Shift+Ctrl+U"};
        String[] transCommands = new String[]{"start", "stop", "match", "completion", "step", "undo"};
        this.transform = new JMenu("Transform", true);
        this.transform.setMnemonic('T');
        for (int i = 0; i < transLabels.length; ++i) {
            JMenuItem mi = new JMenuItem(transLabels[i]);
            mi.setEnabled(true);
            mi.setActionCommand(transCommands[i]);
            mi.addActionListener(this);
            if (mi.getText().equals("Stop")) {
                mi.setEnabled(false);
            }
            this.transform.add(mi);
            if (!transCommands[i].equals("stop") && !transCommands[i].equals("step")) continue;
            this.transform.addSeparator();
        }
        this.mainMenus.addElement(this.transform);
    }

    private void resetEnabledOfMenus(GraGraTreeNodeData selNode, boolean gragraIsChanged) {
        if (this.gragra != null) {
            if (gragraIsChanged) {
                if (selNode != null) {
                    if (selNode.isAtomic || selNode.isConclusion) {
                        this.edit.setEnabled(true);
                        this.mode.setEnabled(true);
                        this.transform.setEnabled(false);
                        this.setEditMode(this.lasteditmode);
                    } else if (selNode.isRuleConstraint || selNode.isConstraint || selNode.isAtomApplCond) {
                        if (this.editmode != 9) {
                            this.lasteditmode = this.editmode;
                        }
                        this.setEditMode(9);
                        this.edit.setEnabled(false);
                        this.mode.setEnabled(false);
                        this.transform.setEnabled(false);
                    } else {
                        this.edit.setEnabled(true);
                        this.mode.setEnabled(true);
                        this.transform.setEnabled(true);
                        this.setEditMode(this.lasteditmode);
                    }
                }
            } else if (selNode != null) {
                if (selNode.isAtomic || selNode.isConclusion) {
                    this.edit.setEnabled(true);
                    this.mode.setEnabled(true);
                    this.transform.setEnabled(false);
                    this.setEditMode(this.lasteditmode);
                } else if (selNode.isRuleConstraint || selNode.isConstraint || selNode.isAtomApplCond) {
                    if (this.editmode != 9) {
                        this.lasteditmode = this.editmode;
                    }
                    this.setEditMode(9);
                    this.edit.setEnabled(false);
                    this.mode.setEnabled(false);
                    this.transform.setEnabled(false);
                } else {
                    this.edit.setEnabled(true);
                    this.mode.setEnabled(true);
                    this.transform.setEnabled(true);
                    this.setEditMode(this.lasteditmode);
                }
            }
        } else {
            this.edit.setEnabled(false);
            this.mode.setEnabled(false);
            this.transform.setEnabled(false);
        }
    }

    private void resetModeMenu(JCheckBoxMenuItem selItem) {
        for (int i = 0; i < this.mode.getItemCount(); ++i) {
            if (!(this.mode.getMenuComponent(i) instanceof JMenuItem)) continue;
            JMenuItem mi = this.mode.getItem(i);
            if (selItem == null) {
                mi.setSelected(false);
                continue;
            }
            if (selItem.getText().equals("Image_view") || mi.getText().equals("Image_view") || !selItem.getState() || mi.equals(selItem)) continue;
            mi.setSelected(!selItem.getState());
        }
    }

    private JCheckBoxMenuItem getModeMenuItem(String itemname) {
        String name = itemname.replaceAll(" ", "");
        for (int i = 0; i < this.mode.getItemCount(); ++i) {
            JMenuItem mi;
            String miname;
            if (!(this.mode.getMenuComponent(i) instanceof JMenuItem) || (miname = (mi = this.mode.getItem(i)).getText().replaceAll(" ", "")).indexOf(name) == -1) continue;
            return (JCheckBoxMenuItem)mi;
        }
        return null;
    }

    private void forwardModeCommand(JCheckBoxMenuItem selItem) {
        if (!selItem.getText().equals("Image_view")) {
            selItem.setSelected(true);
        }
        this.resetModeMenu(selItem);
        this.modePopupMenu.selectEditModeMenuItem(selItem.getText());
        this.selectToolBarModeItem(selItem.getText());
    }

    private void forwardModeCommand(String selName) {
        JCheckBoxMenuItem selItem = this.getModeMenuItem(selName);
        if (selItem != null) {
            this.forwardModeCommand(selItem);
        } else {
            this.modePopupMenu.selectEditModeMenuItem(selName);
            this.selectToolBarModeItem(selName);
        }
    }

    private void resetTransformMenu(String selName) {
        if (selName.equals("Start")) {
            JMenuItem selItem = this.transform.getItem(0);
            this.resetTransformMenu(selItem);
        } else if (selName.equals("Stop")) {
            JMenuItem selItem = this.transform.getItem(1);
            this.resetTransformMenu(selItem);
        }
    }

    private void resetTransformMenu(JMenuItem selItem) {
        block5: {
            block4: {
                if (!selItem.getText().equals("Start")) break block4;
                for (int i = 0; i < this.transform.getItemCount(); ++i) {
                    if (!(this.transform.getMenuComponent(i) instanceof JMenuItem)) continue;
                    JMenuItem mi = this.transform.getItem(i);
                    if (mi.getText().equals("Stop") || mi.getText().equals("Transform")) {
                        mi.setEnabled(true);
                        continue;
                    }
                    mi.setEnabled(false);
                }
                break block5;
            }
            if (!selItem.getText().equals("Stop")) break block5;
            for (int i = 0; i < this.transform.getItemCount(); ++i) {
                if (!(this.transform.getMenuComponent(i) instanceof JMenuItem)) continue;
                JMenuItem mi = this.transform.getItem(i);
                if (mi.getText().equals("Stop")) {
                    mi.setEnabled(false);
                    continue;
                }
                mi.setEnabled(true);
            }
        }
    }

    private void disableStop() {
        for (int i = 0; i < this.transform.getItemCount(); ++i) {
            if (!(this.transform.getItem(i) instanceof JMenuItem)) continue;
            if (this.transform.getItem(i).getText().equals("Stop")) {
                this.transform.getItem(i).setEnabled(false);
                continue;
            }
            this.transform.getItem(i).setEnabled(true);
        }
    }

    private void createToolBar() {
        Dimension freeSpace = new Dimension(20, 20);
        this.toolBar = new AGGToolBar(0);
        this.toolBar.addTool("imageable", "attributes", "Attributes of a selected object", "attributes", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("imageable", "delete", "Delete selected object(s)", "delete", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("imageable", "copy", "Copy selected object(s)", "copy", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("imageable", "paste", "Paste", "paste", this, false);
        this.toolBar.addSeparator();
        this.toolBar.addTool("iconable", "SelectNodeTypeIcon", "Select nodes of current type", "selectNodeType", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("iconable", "SelectArcTypeIcon", "Select arcs of current type", "selectArcType", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("iconable", "SelectAllIcon", "Select all objects", "selectAll", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("iconable", "DeselectAllIcon", "Deselect all objects / Redraw", "deselectAll", this, false);
        this.toolBar.addSeparator(freeSpace);
        this.toolBar.addTool("textable", "IR", "Identic Rule", "identicRule", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("textable", "IN", "Identic NAC", "identicNAC", this, false);
        this.toolBar.addSeparator(freeSpace);
        this.editModeButtons = new Vector(6);
        this.editModeButtons.add(this.toolBar.addTool("imageable", "draw_mode", "Draw mode", "drawMode", this, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.editModeButtons.add(this.toolBar.addTool("imageable", "select_mode", "Select mode", "selectMode", this, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.editModeButtons.add(this.toolBar.addTool("imageable", "move_mode", "Move mode", "moveMode", this, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.editModeButtons.add(this.toolBar.addTool("imageable", "attributes_mode", "Attributes mode", "attributesMode", this, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.editModeButtons.add(this.toolBar.addTool("imageable", "map_mode", "Map mode", "mapMode", this, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.editModeButtons.add(this.toolBar.addTool("imageable", "unmap_mode", "Unmap mode", "unmapMode", this, false));
        this.toolBar.addSeparator(freeSpace);
        this.transformButtons = new Vector(6);
        this.buttonMatch = this.toolBar.addTool("iconable", "MatchIcon", "Interactive match mode", "match", this, false);
        this.transformButtons.add(this.buttonMatch);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.buttonCompletion = this.toolBar.addTool("iconable", "CompletionIcon", "Next Completion", "completion", this, false);
        this.transformButtons.add(this.buttonCompletion);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.buttonStep = this.toolBar.addTool("iconable", "StepIcon", "Transformation Step", "step", this, false);
        this.transformButtons.add(this.buttonStep);
        this.toolBar.addSeparator();
        this.buttonStart = this.toolBar.addTool("iconable", "StartIcon", "Start Transformation", "start", this, false);
        this.transformButtons.add(this.buttonStart);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.buttonStop = this.toolBar.addTool("iconable", "StopIcon", "Stop Transformation", "stop", this, false);
        this.transformButtons.add(this.buttonStop);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.buttonUndo = this.toolBar.addTool("imageable", "undo", "Undo Transformation", "undo", this, false);
        this.transformButtons.add(this.buttonUndo);
        this.toolBar.addSeparator();
        this.buttonLT = this.toolBar.addTool("textable", " ", "", "", this, false);
        this.buttonLT.setForeground(Color.red);
        ((TextIcon)this.buttonLT.getIcon()).setColor(Color.red);
        this.toolBar.addSeparator(new Dimension(20, 10));
        this.toolBar.addTool("imageable", "layout", "repeatedly graph layout", "combinedlayout2", this, true);
    }

    private void selectToolBarModeItem(int mode) {
        if (mode == 11) {
            this.selectToolBarModeItem("Draw");
        } else if (mode == 12) {
            this.selectToolBarModeItem("Select");
        } else if (mode == 13) {
            this.selectToolBarModeItem("Move");
        } else if (mode == 114) {
            this.selectToolBarModeItem("Attributes");
        } else if (mode == 115) {
            this.selectToolBarModeItem("Map");
        } else if (mode == 116) {
            this.selectToolBarModeItem("Unmap");
        } else {
            this.selectToolBarModeItem("Draw");
        }
    }

    public void selectToolBarModeItem(String editmode) {
        String actionComand = "drawMode";
        String mode = editmode.replaceAll(" ", "");
        if (mode.indexOf("Select") != -1) {
            actionComand = "selectMode";
        } else if (mode.indexOf("Move") != -1) {
            actionComand = "moveMode";
        } else if (mode.indexOf("Attributes") != -1) {
            actionComand = "attributesMode";
        } else if (mode.indexOf("Map") != -1) {
            actionComand = "mapMode";
        } else if (mode.indexOf("Unmap") != -1) {
            actionComand = "unmapMode";
        }
        Color bgc = new Color(238, 238, 238);
        for (int i = 0; i < this.editModeButtons.size(); ++i) {
            JButton b = (JButton)this.editModeButtons.get(i);
            if (b.getActionCommand().equals(actionComand)) {
                if (b.isSelected()) continue;
                b.setBackground(new Color(153, 153, 255));
                b.setSelected(true);
                if (this.ruleEditor.isObjMapping()) {
                    this.ruleEditor.resetEditModeAfterMapping();
                }
                if (this.getEditMode() == 42) {
                    this.setEditMode(this.lasteditmode);
                }
                this.selectToolBarTransformItem("");
                continue;
            }
            b.setBackground(bgc);
            b.setSelected(false);
        }
    }

    public void selectToolBarTransformItem(String actionComand) {
        Color bgc = new Color(238, 238, 238);
        for (int i = 0; i < this.transformButtons.size(); ++i) {
            JButton b = (JButton)this.transformButtons.get(i);
            if (b.getActionCommand().equals(actionComand)) {
                if (b.isSelected()) continue;
                b.setBackground(Color.yellow);
                b.setSelected(true);
                continue;
            }
            b.setBackground(bgc);
            b.setSelected(false);
        }
    }

    private void resetEnabledOfToolBarItems(GraGraTreeNodeData extraNode, boolean gragraIsChanged) {
        if (this.gragra != null) {
            if (extraNode != null) {
                if (gragraIsChanged) {
                    if (extraNode.isAtomic || extraNode.isConclusion) {
                        for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
                            if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton)) continue;
                            JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                            b.setEnabled(true);
                            if (!(b.getIcon() instanceof TextIcon)) continue;
                            if (((TextIcon)b.getIcon()).getText().equals("IR")) {
                                b.setIcon(new TextIcon("IA", true));
                                b.setToolTipText("Identic Atomic");
                            }
                            if (((TextIcon)b.getIcon()).getText().equals("IN")) {
                                ((TextIcon)b.getIcon()).setEnabled(false);
                                b.setEnabled(false);
                                continue;
                            }
                            ((TextIcon)b.getIcon()).setEnabled(true);
                        }
                        this.resetSelectIcons(true);
                        this.resetTransformIcons(false);
                    } else if (extraNode.isRuleConstraint || extraNode.isConstraint || extraNode.isAtomApplCond) {
                        for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
                            if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton)) continue;
                            JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                            b.setEnabled(false);
                            if (!(b.getIcon() instanceof TextIcon)) continue;
                            ((TextIcon)b.getIcon()).setEnabled(false);
                        }
                        this.resetSelectIcons(false);
                        this.resetTransformIcons(false);
                    } else if (extraNode.isGraGra || extraNode.isGraph) {
                        for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
                            if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton)) continue;
                            JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                            b.setEnabled(true);
                            if (!(b.getIcon() instanceof TextIcon)) continue;
                            ((TextIcon)b.getIcon()).setEnabled(true);
                        }
                        this.resetSelectIcons(true);
                        this.resetTransformIcons(true);
                    } else if (extraNode.isRule || extraNode.isNAC) {
                        for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
                            if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton)) continue;
                            JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                            b.setEnabled(true);
                            if (!(b.getIcon() instanceof TextIcon)) continue;
                            if (((TextIcon)b.getIcon()).getText().equals("IA")) {
                                b.setIcon(new TextIcon("IR", true));
                                b.setToolTipText("Identic Rule");
                            }
                            ((TextIcon)b.getIcon()).setEnabled(true);
                        }
                        this.resetSelectIcons(true);
                        this.resetTransformIcons(true);
                    }
                } else if (extraNode.isAtomic || extraNode.isConclusion) {
                    for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
                        if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton)) continue;
                        JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                        b.setEnabled(true);
                        if (!(b.getIcon() instanceof TextIcon)) continue;
                        if (((TextIcon)b.getIcon()).getText().equals("IR")) {
                            b.setIcon(new TextIcon("IA", true));
                            b.setToolTipText("Identic Atomic");
                        }
                        if (((TextIcon)b.getIcon()).getText().equals("IN")) {
                            ((TextIcon)b.getIcon()).setEnabled(false);
                            b.setEnabled(false);
                            continue;
                        }
                        ((TextIcon)b.getIcon()).setEnabled(true);
                    }
                    this.resetSelectIcons(true);
                    this.resetTransformIcons(false);
                } else if (extraNode.isRuleConstraint || extraNode.isConstraint || extraNode.isAtomApplCond) {
                    for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
                        if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton)) continue;
                        JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                        b.setEnabled(false);
                        if (!(b.getIcon() instanceof TextIcon)) continue;
                        ((TextIcon)b.getIcon()).setEnabled(false);
                    }
                    this.resetSelectIcons(false);
                    this.resetTransformIcons(false);
                } else if (extraNode.isGraGra || extraNode.isGraph) {
                    for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
                        if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton)) continue;
                        JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                        b.setEnabled(true);
                        if (!(b.getIcon() instanceof TextIcon)) continue;
                        ((TextIcon)b.getIcon()).setEnabled(true);
                    }
                    this.resetSelectIcons(true);
                    this.resetTransformIcons(true);
                } else if (extraNode.isRule || extraNode.isNAC) {
                    for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
                        if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton)) continue;
                        JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                        b.setEnabled(true);
                        if (!(b.getIcon() instanceof TextIcon)) continue;
                        if (((TextIcon)b.getIcon()).getText().equals("IA")) {
                            b.setIcon(new TextIcon("IR", true));
                            b.setToolTipText("Identic Rule");
                        }
                        ((TextIcon)b.getIcon()).setEnabled(true);
                    }
                    this.resetSelectIcons(true);
                    this.resetTransformIcons(true);
                }
            } else {
                for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
                    if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton)) continue;
                    JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                    b.setEnabled(true);
                    if (!(b.getIcon() instanceof TextIcon)) continue;
                    ((TextIcon)b.getIcon()).setEnabled(true);
                }
                this.resetSelectIcons(true);
                this.resetTransformIcons(true);
            }
        } else {
            for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
                if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton)) continue;
                JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                b.setEnabled(false);
                if (!(b.getIcon() instanceof TextIcon)) continue;
                ((TextIcon)b.getIcon()).setEnabled(false);
            }
            this.resetSelectIcons(false);
            this.resetTransformIcons(false);
        }
        this.toolBar.revalidate();
    }

    private void resetSelectIcons(boolean enable) {
        for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
            if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton)) continue;
            JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
            if (b.getIcon() instanceof DeselectAllIcon) {
                ((DeselectAllIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof SelectAllIcon) {
                ((SelectAllIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof SelectNodeTypeIcon) {
                ((SelectNodeTypeIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (!(b.getIcon() instanceof SelectArcTypeIcon)) continue;
            ((SelectArcTypeIcon)b.getIcon()).setEnabled(enable);
            b.setEnabled(enable);
        }
    }

    private void resetEditIcons(boolean enable) {
        for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
            if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton)) continue;
            JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
            if (b.getActionCommand().equals("attributes") || b.getActionCommand().equals("delete") || b.getActionCommand().equals("copy") || b.getActionCommand().equals("paste")) {
                b.setEnabled(enable);
            }
            if (b.getIcon() instanceof TextIcon) {
                if (!((TextIcon)b.getIcon()).getText().equals("IR") && !((TextIcon)b.getIcon()).getText().equals("IN") && !((TextIcon)b.getIcon()).getText().equals("IA")) continue;
                ((TextIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof SelectNodeTypeIcon) {
                ((SelectNodeTypeIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof SelectArcTypeIcon) {
                ((SelectArcTypeIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof SelectAllIcon) {
                ((SelectAllIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (!(b.getIcon() instanceof DeselectAllIcon)) continue;
            ((DeselectAllIcon)b.getIcon()).setEnabled(enable);
            b.setEnabled(enable);
        }
    }

    private void resetEditModeIcons(boolean enable) {
        for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
            JButton b;
            if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton) || !(b = (JButton)this.toolBar.getComponentAtIndex(i)).getActionCommand().equals("drawMode") && !b.getActionCommand().equals("selectMode") && !b.getActionCommand().equals("attributesMode") && !b.getActionCommand().equals("mapMode") && !b.getActionCommand().equals("unmapMode")) continue;
            b.setEnabled(enable);
        }
    }

    private void resetEditModeAfterMapping(int mode) {
        if (this.editmode == 42 || this.editmode == 115 || this.editmode == 116) {
            if (this.editmode == 42) {
                this.selectToolBarTransformItem("");
            }
            this.ruleEditor.resetEditModeAfterMapping();
            this.setEditMode(mode);
            this.lasteditmode = mode;
        }
    }

    private void resetTransformIcons(boolean enable) {
        for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
            if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton)) continue;
            JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
            if (b.getIcon() instanceof MatchIcon) {
                ((MatchIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof CompletionIcon) {
                ((CompletionIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof StepIcon) {
                ((StepIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getActionCommand().equals("undo")) {
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof StartIcon) {
                ((StartIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (!(b.getIcon() instanceof StopIcon)) continue;
            ((StopIcon)b.getIcon()).setEnabled(enable);
            b.setEnabled(enable);
        }
    }

    private void resetLayeredTransformIcon(boolean enable) {
        for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
            JButton b;
            if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton) || !(b = (JButton)this.toolBar.getComponentAtIndex(i)).equals(this.buttonLT)) continue;
            if (enable) {
                ((TextIcon)b.getIcon()).setText("LT");
                b.setToolTipText("Layered Transformation Option");
                ((TextIcon)b.getIcon()).setEnabled(true);
                b.setEnabled(true);
            } else {
                ((TextIcon)b.getIcon()).setText(" ");
                b.setToolTipText("");
            }
            if (b.getGraphics() == null) continue;
            b.update(b.getGraphics());
        }
    }

    private void resetTransformDebugIcons(boolean enable) {
        for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
            if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton)) continue;
            JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
            if (b.getIcon() instanceof MatchIcon) {
                ((MatchIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof CompletionIcon) {
                ((CompletionIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (!(b.getIcon() instanceof StepIcon)) continue;
            ((StepIcon)b.getIcon()).setEnabled(enable);
            b.setEnabled(enable);
        }
    }

    private void resetIconsIfTransformInterpret(boolean enable) {
        ((AGGAppl)this.applFrame).getGraGraTreeView().resetFileIcons(enable);
        this.resetEditIcons(enable);
        this.resetEditModeIcons(enable);
        this.resetTransformDebugIcons(enable);
        this.toolBar.revalidate();
    }

    private void printGraGra(JFrame f, EdGraGra gra) {
        if (this.gragra == null) {
            return;
        }
        GraGraPrint print = new GraGraPrint(f, this.gragra);
        print.showDialog();
    }

    private void printGraGra(JFrame f, GraGraPrint print, EdGraGra gra) {
        if (this.gragra == null) {
            return;
        }
        print.setGraGra(this.gragra);
        this.addEditEventListener(print);
        print.showDialog();
    }

    private int removeWarning(String msgStr) {
        Object[] options = new Object[]{"YES", "NO"};
        int answer = JOptionPane.showOptionDialog(null, msgStr, "Warning", -1, 2, null, options, options[1]);
        return answer;
    }

    private void setToolkit() {
        Frame f = new Frame("");
        f.pack();
        this.tk = f.getToolkit();
    }

    private void doPrepareLayouterProc() {
        if (this.layouter.getJpgOutput()) {
            this.jpgPath = this.exportJPEG.getDirectoryForJPEGs(this);
            if (this.jpgPath != null && !this.jpgPath.equals("")) {
                String filename = this.getGraGra().getFileName() + "_0.jpg";
                this.exportJPEG.save(this.graphEditor.getGraphPanel().getCanvas(), this.jpgPath + File.separator + filename);
            }
        }
        if (this.layouter.getWriteMetricValues() && this.metricvalues == null) {
            this.metricvalues = this.createMetricValues();
        }
    }

    private void saveGraphJPEG() {
        if (this.gragra == null) {
            return;
        }
        this.exportJPEG.setDirectory(this.gragra.getDirName());
        this.exportJPEG.save(this.graphEditor.getGraphPanel().getCanvas());
    }

    private void saveApplJPEG() {
        this.exportJPEG.setDirectory(this.gragra.getDirName());
        this.exportJPEG.save(this.graphEditor.getGraphPanel().getCanvas());
    }

    private void setNodeIds() {
        Vector nodes = this.getGraph().getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            EdNode node = (EdNode)nodes.get(i);
            if (node.getNodeID() != -1) continue;
            this.getGraph().incLastNodeID();
            node.setNodeID(this.getGraph().getLastNodeID());
        }
    }

    private Vector<String> createMetricValues() {
        int i;
        Vector<String> metricValues = new Vector<String>();
        String s = new String("A  \tB \tC \tD   \tE    \tF     \tG    \tH    \tI          J          K       ");
        metricValues.add(s);
        String s1 = "";
        for (i = 0; i < 94; ++i) {
            s1 = s1.concat("-");
        }
        metricValues.add(s1);
        s = new String("age\t#n\t#e\tn_ov\tn_eov\te_xing\te_dif\tn_mov\td_single   d_mental   d_layout");
        metricValues.add(s);
        s1 = "";
        for (i = 0; i < 94; ++i) {
            s1 = s1.concat("-");
        }
        metricValues.add(s1);
        LayoutMetrics lmetric = this.layouter.getLayoutMetrics();
        int age = 0;
        s = new String(age + "\t");
        int nodes = this.getGraph().getNodes().size();
        s = s + nodes + "\t";
        int arcs = this.getGraph().getArcs().size();
        s = s + arcs + "\t";
        int nodeOverlapping = lmetric.getNodeIntersect(this.getGraph(), false);
        s = s + nodeOverlapping + "\t";
        int arcNodeOverlapping = lmetric.getArcNodeIntersect(this.getGraph());
        s = s + arcNodeOverlapping + "\t";
        int arcArcOverlapping = lmetric.getArcArcIntersect(this.getGraph());
        s = s + arcArcOverlapping + "\t";
        s = s + lmetric.getAverageArcLengthDeviation(this.getGraph()) + "\t";
        s = s + "N/A\t";
        float singleDistance = lmetric.getSingleDistance(nodes, arcs, nodeOverlapping, arcNodeOverlapping, arcArcOverlapping);
        String str_singleDistance = String.valueOf(singleDistance);
        s = s + str_singleDistance.substring(0, str_singleDistance.indexOf(46) + 2) + "\t   ";
        s = s + "N/A\t      ";
        s = s + "N/A";
        metricValues.add(s);
        return metricValues;
    }

    private void writeMetricValues(String filename) {
        try {
            BufferedWriter buf = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename)));
            for (int i = 0; i < this.metricvalues.size(); ++i) {
                buf.write(this.metricvalues.get(i) + "\n");
            }
            buf.flush();
            buf.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doDefaultELayoutProc() {
        this.getGraph().updateNodePosEtoL();
        Dimension neededpanel = this.layouter.getNeededPanelSize(this.getGraph());
        int panelx = this.getPanelOfGraph(this.getGraph()).getWidth();
        int panely = this.getPanelOfGraph(this.getGraph()).getHeight();
        neededpanel.setSize(Math.max(neededpanel.width, panelx), Math.max(neededpanel.height, panely));
        this.layouter.setPanelSize(neededpanel);
        this.getPanelOfGraph(this.getGraph()).getCanvas().setSize(neededpanel);
        this.layouter.layout(this.getGraph());
    }

    private void doByArcLengthELayoutProc() {
        this.getGraph().updateNodePosEtoL();
        Dimension neededpanel = this.layouter.getNeededPanelSize(this.getGraph());
        int panelx = this.getPanelOfGraph(this.getGraph()).getWidth();
        int panely = this.getPanelOfGraph(this.getGraph()).getHeight();
        neededpanel.setSize(Math.max(neededpanel.width, panelx), Math.max(neededpanel.height, panely));
        this.layouter.setPanelSize(neededpanel);
        this.getPanelOfGraph(this.getGraph()).getCanvas().setSize(neededpanel);
        this.layouter.layoutByArcLength(this.getGraph());
    }

    private void doCombinedELayoutProc() {
        this.getGraph().updateNodePosEtoL();
        Dimension neededpanel = this.layouter.getNeededPanelSize(this.getGraph());
        int panelx = this.getPanelOfGraph(this.getGraph()).getWidth();
        int panely = this.getPanelOfGraph(this.getGraph()).getHeight();
        neededpanel.setSize(Math.max(neededpanel.width, panelx), Math.max(neededpanel.height, panely));
        this.layouter.setPanelSize(neededpanel);
        this.getPanelOfGraph(this.getGraph()).getCanvas().setSize(neededpanel);
        this.layouter.combinedLayout(this.getGraph(), this.layouter.getIterationCount(), 10, 50);
    }

    private void doStandardELayoutProc() {
        this.getGraph().updateNodePosEtoL();
        this.getGraph().updateLengthOfLayoutEdge(this.layouter.getGeneralEdgeLength());
        this.setNodeIds();
        LayoutMetrics lmetrics = this.layouter.getLayoutMetrics();
        for (int i = 0; i < this.getGraph().getNodes().size(); ++i) {
            ((EdNode)this.getGraph().getNodes().get(i)).calculateCluster(lmetrics.getEpsilon(), this.getGraph().getNodes());
        }
        Dimension neededpanel = this.layouter.getNeededPanelSize(this.getGraph());
        int panelx = this.getPanelOfGraph(this.getGraph()).getWidth();
        int panely = this.getPanelOfGraph(this.getGraph()).getHeight();
        neededpanel.setSize(Math.max(neededpanel.width, panelx), Math.max(neededpanel.height, panely));
        this.layouter.setPanelSize(neededpanel);
        this.getPanelOfGraph(this.getGraph()).getCanvas().setSize(neededpanel);
        this.layouter.layoutGraph(this.getGraph());
    }

    private void doStepELayoutProc() {
        this.getGraph().updateNodePosEtoL();
        this.getGraph().updateLengthOfLayoutEdge(this.layouter.getGeneralEdgeLength());
        this.setNodeIds();
        LayoutMetrics lmetrics = this.layouter.getLayoutMetrics();
        for (int i = 0; i < this.getGraph().getNodes().size(); ++i) {
            ((EdNode)this.getGraph().getNodes().get(i)).calculateCluster(lmetrics.getEpsilon(), this.getGraph().getNodes());
        }
        this.layouter.shockAging(this.getGraph());
        Dimension neededpanel = this.layouter.getNeededPanelSize(this.getGraph());
        int panelx = this.getPanelOfGraph(this.getGraph()).getWidth();
        int panely = this.getPanelOfGraph(this.getGraph()).getHeight();
        neededpanel.setSize(Math.max(neededpanel.width, panelx), Math.max(neededpanel.height, panely));
        this.layouter.setPanelSize(neededpanel);
        this.layouter.newNodesRandomLayout(this.getGraph());
        this.getPanelOfGraph(this.getGraph()).getCanvas().setSize(neededpanel);
        this.layouter.layoutGraph(this.getGraph());
        if (this.layouter.doCenter()) {
            this.layouter.centerLayout(this.getGraph());
        }
        if (this.layouter.getJpgOutput()) {
            if (this.jpgPath == null && !this.exportJPEG.isCancelled()) {
                this.jpgPath = this.exportJPEG.getDirectoryForJPEGs(this);
            }
            if (this.jpgPath != null && !this.jpgPath.equals("")) {
                String filename = this.getGraGra().getFileName() + "_" + this.getGraph().getGraphGen() + ".jpg";
                this.exportJPEG.save(this.graphEditor.getGraphPanel().getCanvas(), this.jpgPath + File.separator + filename);
            }
        }
        if (this.layouter.getWriteMetricValues()) {
            if (this.metricvalues == null) {
                this.metricvalues = this.createMetricValues();
            }
            String metrics = this.getMetricValuesString(this.getGraph(), this.layouter.getOldEdGraph(), lmetrics);
            this.metricvalues.addElement(metrics);
        }
    }

    private String getMetricValuesString(EdGraph g, EdGraph oldg, LayoutMetrics lmetrics) {
        String str;
        int age = g.getGraphGen();
        String metrics = new String(age + "\t");
        int nodes = g.getNodes().size();
        metrics = metrics + nodes + "\t";
        int arcs = g.getArcs().size();
        metrics = metrics + arcs + "\t";
        int nodeOverlapping = lmetrics.getNodeIntersect(g, false);
        metrics = metrics + nodeOverlapping + "\t";
        int arcNodeOverlapping = lmetrics.getArcNodeIntersect(g);
        metrics = metrics + arcNodeOverlapping + "\t";
        int arcArcOverlapping = lmetrics.getArcArcIntersect(g);
        metrics = metrics + arcArcOverlapping + "\t";
        int movementsOfArcs = lmetrics.getAverageArcLengthDeviation(g);
        metrics = metrics + movementsOfArcs + "\t";
        int movementsOfNodes = lmetrics.getAverageNodeMove(oldg, g);
        metrics = metrics + movementsOfNodes + "\t";
        float singleDist = lmetrics.getSingleDistance(nodes, arcs, nodeOverlapping, arcNodeOverlapping, arcArcOverlapping);
        String singleDistance = str = String.valueOf(singleDist);
        if (str.length() > str.indexOf(46) + 2) {
            singleDistance = str.substring(0, str.indexOf(46) + 2);
        }
        metrics = metrics + singleDistance + "\t   ";
        float mentalDist = lmetrics.getMentalDistance(nodes, arcs, movementsOfNodes, movementsOfArcs);
        String mentalDistance = str = String.valueOf(mentalDist);
        if (str.length() > str.indexOf(46) + 2) {
            mentalDistance = str.substring(0, str.indexOf(46) + 2);
        }
        metrics = metrics + mentalDistance + "\t      ";
        float layoutQual = lmetrics.getLayoutQuality(singleDist, mentalDist);
        String layoutQuality = str = String.valueOf(layoutQual);
        if (str.length() > str.indexOf(46) + 2) {
            layoutQuality = str.substring(0, str.indexOf(46) + 2);
        }
        metrics = metrics + layoutQuality;
        return metrics;
    }

    private void doDisplayELayoutMetricsProc() {
        this.getGraph().updateNodePosEtoL();
        LayoutMetrics lm = new LayoutMetrics();
        int aaintersect = lm.getArcArcIntersect(this.getGraph());
        int anintersect = lm.getArcNodeIntersect(this.getGraph());
        int nnintersect = lm.getNodeIntersect(this.getGraph(), false);
        int ogintersect = lm.getOverallIntersect(this.getGraph());
        String erg = "Layout metrics:\n( the smaller the value the better )\nweighted overall-result: " + ogintersect + "\nedge-edge overlappings: " + aaintersect + "\nedge-node overlappings: " + anintersect + "\nnode-node overlappings: " + nnintersect;
        JOptionPane.showMessageDialog(this, erg);
    }

    private void makePartialMatch() {
        System.out.println("GraGraEditor.makePartialMatch...");
        Vector sel = this.getGraGra().getGraph().getSelectedObjs();
        Vector<GraphObject> set = new Vector<GraphObject>();
        for (int i = 0; i < sel.size(); ++i) {
            set.add(((EdGraphObject)sel.get(i)).getBasisObject());
        }
        Graph lhs = this.ruleEditor.getRule().getBasisRule().getLeft();
        Vector<Hashtable> maps = lhs.getPartialMorphismIntoSet(set);
        if (maps != null && !maps.isEmpty()) {
            if (this.ruleEditor.getRule().getBasisRule().getMatch() == null) {
                this.getGraGra().getBasisGraGra().createMatch(this.ruleEditor.getRule().getBasisRule());
            }
            this.ruleEditor.getRule().setMatch(this.ruleEditor.getRule().getBasisRule().getMatch());
            Hashtable table = maps.get(0);
            Enumeration en = table.keys();
            while (en.hasMoreElements()) {
                GraphObject obj = (GraphObject)en.nextElement();
                GraphObject img = (GraphObject)table.get(obj);
                this.ruleEditor.getRule().getBasisRule().getMatch().addMapping(obj, img);
                if (this.ruleEditor.getRule().getBasisRule().getMatch().getImage(obj) != null) {
                    System.out.println("add mapping to match - done");
                    continue;
                }
                System.out.println("add mapping to match - failed");
            }
        }
    }
}

