/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.cons.AtomConstraint;
import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdConstraint;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdRule;
import agg.gui.GraGraTreeView;
import agg.gui.IconResource;
import agg.gui.icons.NewConclusionIcon;
import agg.xt_basis.Rule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GraGraElementsStore
implements MouseListener {
    private Hashtable storeGraGra;
    private Hashtable storeRule;
    private Hashtable storeAtomConstraint;
    private JPanel palette;
    private JScrollPane scrollPane;
    private Vector paletteElems;
    private Hashtable obj2panel;
    private Hashtable buttons;
    private Object current;
    private boolean currentValid = false;
    private JDialog d;
    protected static final Color SelectedBackgroundColor = new Color(153, 153, 255);
    private String dot = " . ";
    private int x = -1;
    private int y = -1;
    private int lWeidth;
    private JButton trash;
    GraGraTreeView treeView;

    public GraGraElementsStore(GraGraTreeView tree) {
        this.treeView = tree;
        this.storeGraGra = new Hashtable(5);
        this.storeRule = new Hashtable(5);
        this.storeAtomConstraint = new Hashtable(5);
        this.paletteElems = new Vector(5);
        this.buttons = new Hashtable(5);
        this.obj2panel = new Hashtable(5);
    }

    public void setTrash(JButton aTrash) {
        this.trash = aTrash;
    }

    public boolean isEmpty() {
        return this.paletteElems.isEmpty();
    }

    public void storeGraph(EdGraGra parent, EdGraph g) {
        Vector<EdGraph> v;
        Hashtable<String, Vector<EdGraph>> ht = (Hashtable<String, Vector<EdGraph>>)this.storeGraGra.get(parent);
        if (ht == null) {
            ht = new Hashtable<String, Vector<EdGraph>>(5);
        }
        if ((v = (Vector<EdGraph>)ht.get("GRAPH")) == null) {
            v = new Vector<EdGraph>(1);
        }
        v.add(g);
        ht.put("GRAPH", v);
        this.storeGraGra.put(parent, ht);
        String name = this.makeName(g.getBasisGraph().getName(), g.getGraGra().getName(), "");
        int w = this.getNameLength(name);
        JLabel b = this.createButton(name, IconResource.getIconFromURL(IconResource.getURLGraph()));
        this.buttons.put(b, g);
        this.obj2panel.put(g, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public void storeTypeGraph(EdGraGra parent, EdGraph g) {
        Vector<EdGraph> v;
        Hashtable<String, Vector<EdGraph>> ht = (Hashtable<String, Vector<EdGraph>>)this.storeGraGra.get(parent);
        if (ht == null) {
            ht = new Hashtable<String, Vector<EdGraph>>(5);
        }
        if ((v = (Vector<EdGraph>)ht.get("TG")) == null) {
            v = new Vector<EdGraph>(1);
        }
        v.add(g);
        ht.put("TG", v);
        this.storeGraGra.put(parent, ht);
        String name = this.makeName(g.getBasisGraph().getName(), g.getGraGra().getName(), "");
        int w = this.getNameLength(name);
        JLabel b = this.createButton(name, IconResource.getIconFromURL(IconResource.getURLTypeGraph()));
        this.buttons.put(b, g);
        this.obj2panel.put(g, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public void storeRule(EdGraGra parent, EdRule r) {
        Vector<EdRule> v;
        Hashtable<String, Vector<EdRule>> ht = (Hashtable<String, Vector<EdRule>>)this.storeGraGra.get(parent);
        if (ht == null) {
            ht = new Hashtable<String, Vector<EdRule>>(5);
        }
        if ((v = (Vector<EdRule>)ht.get("RULE")) == null) {
            v = new Vector<EdRule>(1);
        }
        v.add(r);
        ht.put("RULE", v);
        this.storeGraGra.put(parent, ht);
        String name = this.makeName(r.getBasisRule().getName(), r.getGraGra().getName(), "");
        int w = this.getNameLength(name);
        JLabel b = this.createButton(name, IconResource.getIconFromURL(IconResource.getURLRule()));
        this.buttons.put(b, r);
        this.obj2panel.put(r, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public void storeAtomConstraint(EdGraGra parent, EdAtomic c) {
        Vector<EdAtomic> v;
        Hashtable<String, Vector<EdAtomic>> ht = (Hashtable<String, Vector<EdAtomic>>)this.storeGraGra.get(parent);
        if (ht == null) {
            ht = new Hashtable<String, Vector<EdAtomic>>(5);
        }
        if ((v = (Vector<EdAtomic>)ht.get("ATOMIC")) == null) {
            v = new Vector<EdAtomic>(1);
        }
        v.add(c);
        ht.put("ATOMIC", v);
        this.storeGraGra.put(parent, ht);
        String name = this.makeName(c.getBasisAtomic().getAtomicName(), c.getGraGra().getName(), "");
        int w = this.getNameLength(name);
        JLabel b = this.createButton(name, IconResource.getIconFromURL(IconResource.getURLAtomic()));
        this.buttons.put(b, c);
        this.obj2panel.put(c, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public void storeConstraint(EdGraGra parent, EdConstraint c) {
        Vector<EdConstraint> v;
        Hashtable<String, Vector<EdConstraint>> ht = (Hashtable<String, Vector<EdConstraint>>)this.storeGraGra.get(parent);
        if (ht == null) {
            ht = new Hashtable<String, Vector<EdConstraint>>(5);
        }
        if ((v = (Vector<EdConstraint>)ht.get("FORMULA")) == null) {
            v = new Vector<EdConstraint>(1);
        }
        v.add(c);
        ht.put("FORMULA", v);
        this.storeGraGra.put(parent, ht);
        String name = this.makeName(c.getBasisConstraint().getName(), c.getGraGra().getName(), "");
        int w = this.getNameLength(name);
        JLabel b = this.createButton(name, IconResource.getIconFromURL(IconResource.getURLConstraint()));
        this.buttons.put(b, c);
        this.obj2panel.put(c, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public void storeNAC(EdRule parent, EdNAC nac) {
        Vector<EdNAC> v = (Vector<EdNAC>)this.storeRule.get(parent);
        if (v == null) {
            v = new Vector<EdNAC>(5);
        }
        v.add(nac);
        this.storeRule.put(parent, v);
        String name = this.makeName(nac.getName(), nac.getRule().getBasisRule().getName(), nac.getRule().getGraGra().getName());
        int w = this.getNameLength(name);
        JLabel b = this.createButton(name, IconResource.getIconFromURL(IconResource.getURLNAC()));
        this.buttons.put(b, nac);
        this.obj2panel.put(nac, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public void storeAtomConclusion(EdAtomic parent, EdAtomic c) {
        Vector<EdAtomic> v = (Vector<EdAtomic>)this.storeAtomConstraint.get(parent);
        if (v == null) {
            v = new Vector<EdAtomic>(5);
        }
        v.add(c);
        this.storeAtomConstraint.put(parent, v);
        String name = this.makeName(c.getBasisAtomic().getName(), c.getBasisAtomic().getAtomicName(), c.getGraGra().getName());
        int w = this.getNameLength(name);
        NewConclusionIcon icon = new NewConclusionIcon(Color.blue);
        icon.setEnabled(true);
        JLabel b = this.createButton(name, icon);
        this.buttons.put(b, c);
        this.obj2panel.put(c, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public EdGraph getTypeGraph(EdGraGra parent) {
        EdGraph g = null;
        Hashtable ht = (Hashtable)this.storeGraGra.get(parent);
        if (ht != null) {
            Vector v = (Vector)ht.get("TG");
            if (v != null && !v.isEmpty()) {
                g = (EdGraph)v.lastElement();
                v.remove(g);
                if (v.isEmpty()) {
                    ht.remove("TG");
                }
            }
            if (ht.isEmpty()) {
                this.storeGraGra.remove(parent);
            }
            this.updateTrash();
        }
        return g;
    }

    public EdGraph getGraph(EdGraGra parent) {
        EdGraph g = null;
        Hashtable ht = (Hashtable)this.storeGraGra.get(parent);
        if (ht != null) {
            Vector v = (Vector)ht.get("GRAPH");
            if (v != null && !v.isEmpty()) {
                g = (EdGraph)v.lastElement();
                v.remove(g);
                if (v.isEmpty()) {
                    ht.remove("GRAPH");
                }
            }
            if (ht.isEmpty()) {
                this.storeGraGra.remove(parent);
            }
            this.updateTrash();
        }
        return g;
    }

    public EdRule getRule(EdGraGra parent) {
        EdRule r = null;
        Hashtable ht = (Hashtable)this.storeGraGra.get(parent);
        if (ht != null) {
            Vector v = (Vector)ht.get("RULE");
            if (v != null && !v.isEmpty()) {
                r = (EdRule)v.lastElement();
                v.remove(r);
                if (v.isEmpty()) {
                    ht.remove("RULE");
                }
            }
            if (ht.isEmpty()) {
                this.storeGraGra.remove(parent);
            }
            this.updateTrash();
        }
        return r;
    }

    public EdNAC getNAC(EdRule parent) {
        EdNAC n = null;
        Vector v = (Vector)this.storeRule.get(parent);
        if (v != null && !v.isEmpty()) {
            n = (EdNAC)v.lastElement();
            v.remove(n);
            if (v.isEmpty()) {
                this.storeRule.remove(parent);
            }
            this.updateTrash();
        }
        return n;
    }

    public EdAtomic getAtomConstraint(EdGraGra parent) {
        EdAtomic a = null;
        Hashtable ht = (Hashtable)this.storeGraGra.get(parent);
        if (ht != null) {
            Vector v = (Vector)ht.get("ATOMIC");
            if (v != null && !v.isEmpty()) {
                a = (EdAtomic)v.lastElement();
                v.remove(a);
                if (v.isEmpty()) {
                    ht.remove("ATOMIC");
                }
            }
            if (ht.isEmpty()) {
                this.storeGraGra.remove(parent);
            }
            this.updateTrash();
        }
        return a;
    }

    public EdAtomic getAtomConclusion(EdAtomic parent) {
        EdAtomic a = null;
        Vector v = (Vector)this.storeAtomConstraint.get(parent);
        if (v != null && !v.isEmpty()) {
            a = (EdAtomic)v.lastElement();
            v.remove(a);
            if (v.isEmpty()) {
                this.storeAtomConstraint.remove(parent);
            }
            this.updateTrash();
        }
        return a;
    }

    public EdConstraint getConstraint(EdGraGra parent) {
        EdConstraint c = null;
        Hashtable ht = (Hashtable)this.storeGraGra.get(parent);
        if (ht != null) {
            Vector v = (Vector)ht.get("FORMULA");
            if (v != null && !v.isEmpty()) {
                c = (EdConstraint)v.lastElement();
                v.remove(c);
                if (v.isEmpty()) {
                    ht.remove("FORMULA");
                }
            }
            if (ht.isEmpty()) {
                this.storeGraGra.remove(parent);
            }
            this.updateTrash();
        }
        return c;
    }

    public void removeGraGra(EdGraGra gra) {
        EdAtomic a;
        Vector v;
        Enumeration e = this.storeRule.keys();
        while (e.hasMoreElements()) {
            EdRule r = (EdRule)e.nextElement();
            if (r.getGraGra() != gra) continue;
            v = (Vector)this.storeRule.get(r);
            for (int i = 0; i < v.size(); ++i) {
                EdNAC nac = (EdNAC)v.get(i);
                this.removeFromTrashPalette(nac);
                nac.dispose();
            }
            v.clear();
            this.storeRule.remove(r);
            Rule br = r.getBasisRule();
            r.dispose();
            br.dispose();
            e = this.storeRule.keys();
        }
        e = this.storeAtomConstraint.keys();
        while (e.hasMoreElements()) {
            EdAtomic c = (EdAtomic)e.nextElement();
            if (c.getGraGra() != gra) continue;
            v = (Vector)this.storeAtomConstraint.get(c);
            for (int i = 0; i < v.size(); ++i) {
                a = (EdAtomic)v.get(i);
                this.removeFromTrashPalette(a);
                a.dispose();
            }
            v.clear();
            this.storeAtomConstraint.remove(c);
            AtomConstraint bc = c.getBasisAtomic();
            c.dispose();
            bc.dispose();
            e = this.storeAtomConstraint.keys();
        }
        Hashtable ht = (Hashtable)this.storeGraGra.get(gra);
        if (ht != null) {
            EdGraph g;
            v = (Vector)ht.get("TG");
            if (v != null) {
                for (int i = 0; i < v.size(); ++i) {
                    g = (EdGraph)v.get(i);
                    this.removeFromTrashPalette(g);
                    g.dispose();
                }
                v.clear();
            }
            if ((v = (Vector)ht.get("GRAPH")) != null) {
                for (int i = 0; i < v.size(); ++i) {
                    g = (EdGraph)v.get(i);
                    this.removeFromTrashPalette(g);
                    g.dispose();
                }
                v.clear();
            }
            if ((v = (Vector)ht.get("RULE")) != null) {
                for (int i = 0; i < v.size(); ++i) {
                    EdRule r = (EdRule)v.get(i);
                    this.removeFromTrashPalette(r);
                    r.dispose();
                }
                v.clear();
            }
            if ((v = (Vector)ht.get("ATOMIC")) != null) {
                for (int i = 0; i < v.size(); ++i) {
                    a = (EdAtomic)v.get(i);
                    this.removeFromTrashPalette(a);
                    a.dispose();
                }
                v.clear();
            }
            if ((v = (Vector)ht.get("FORMULA")) != null) {
                for (int i = 0; i < v.size(); ++i) {
                    EdConstraint c = (EdConstraint)v.get(i);
                    this.removeFromTrashPalette(c);
                }
                v.clear();
            }
            ht.clear();
        }
        this.storeGraGra.remove(gra);
        this.current = null;
        this.currentValid = false;
        this.updateTrash();
    }

    private void updateTrash() {
        if (this.paletteElems.isEmpty()) {
            this.trash.setEnabled(false);
        } else {
            this.trash.setEnabled(true);
        }
    }

    private String makeName(String elem, String parent1, String parent2) {
        String res = "";
        if (elem.length() > 0) {
            if (parent1.length() > 0) {
                res = elem + " [" + parent1 + "]" + "  ";
            }
            if (parent2.length() > 0) {
                res = elem + " [" + parent1 + "]" + " [" + parent2 + "]" + "  ";
            }
        }
        return res;
    }

    private int getNameLength(String name) {
        if (name.length() < 40) {
            return name.length() * 8 + 20;
        }
        return name.length() * 8;
    }

    private void propagateSelection(Object obj) {
        if (obj instanceof EdNAC) {
            this.getNAC(((EdNAC)obj).getRule());
        } else if (obj instanceof EdGraph) {
            if (((EdGraph)obj).isTypeGraph()) {
                this.getTypeGraph(((EdGraph)obj).getGraGra());
            } else {
                this.getGraph(((EdGraph)obj).getGraGra());
            }
        } else if (obj instanceof EdAtomic) {
            if (((EdAtomic)obj).getParent() == (EdAtomic)obj) {
                this.getAtomConstraint(((EdAtomic)obj).getGraGra());
            } else {
                this.getAtomConclusion(((EdAtomic)obj).getParent());
            }
        } else if (obj instanceof EdRule) {
            this.getRule(((EdRule)obj).getGraGra());
        } else if (obj instanceof EdConstraint) {
            this.getConstraint(((EdConstraint)obj).getGraGra());
        }
    }

    private JLabel createButton(String name, Icon icon) {
        JLabel l = new JLabel(name);
        l.setIcon(icon);
        JPanel p = new JPanel(new GridLayout(1, 0));
        p.addMouseListener(this);
        p.add(l);
        p.setToolTipText("Double click to add this element to its parent.");
        this.paletteElems.add(p);
        return l;
    }

    public void setLocation(int X, int Y) {
        if (this.x <= 0) {
            this.x = X;
        }
        if (this.y <= 0) {
            this.y = Y;
        }
    }

    public void showStorePalette() {
        if (this.paletteElems.isEmpty()) {
            this.current = null;
            this.currentValid = false;
            return;
        }
        if (this.d == null || !this.d.isVisible()) {
            int size = this.paletteElems.size();
            if (size == 0) {
                return;
            }
            this.palette = new JPanel(new GridLayout(size, 0));
            for (int i = 0; i < this.paletteElems.size(); ++i) {
                this.palette.add((JPanel)this.paletteElems.get(i));
            }
            this.scrollPane = new JScrollPane(this.palette);
            int wdth = this.lWeidth;
            int hght = (this.paletteElems.size() + 1) * 30;
            if (hght > 300) {
                hght = 300;
            }
            this.scrollPane.setPreferredSize(new Dimension(wdth, hght));
            JPanel p = new JPanel(new BorderLayout());
            JButton empty = new JButton("Empty");
            empty.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    GraGraElementsStore.this.palette.removeAll();
                    GraGraElementsStore.this.storeGraGra.clear();
                    GraGraElementsStore.this.storeRule.clear();
                    GraGraElementsStore.this.storeAtomConstraint.clear();
                    GraGraElementsStore.this.paletteElems.clear();
                    GraGraElementsStore.this.lWeidth = 0;
                    GraGraElementsStore.this.updateTrash();
                    GraGraElementsStore.this.x = GraGraElementsStore.this.d.getX();
                    GraGraElementsStore.this.y = GraGraElementsStore.this.d.getY();
                    GraGraElementsStore.this.exitForm();
                }
            });
            p.add((Component)this.scrollPane, "Center");
            p.add((Component)empty, "South");
            this.d = new JDialog();
            this.d.setModal(false);
            this.d.setTitle("Trash");
            this.d.getContentPane().add(p);
            this.d.setSize(wdth, hght + 25);
            this.d.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    GraGraElementsStore.this.x = GraGraElementsStore.this.d.getX();
                    GraGraElementsStore.this.y = GraGraElementsStore.this.d.getY();
                    GraGraElementsStore.this.exitForm();
                }
            });
            this.d.setLocation(this.x, this.y);
            this.d.setVisible(true);
        }
    }

    private void refreshStorePalette() {
        if (this.d != null && this.d.isVisible()) {
            ((GridLayout)this.palette.getLayout()).setRows(this.paletteElems.size());
            this.palette.add((JPanel)this.paletteElems.get(this.paletteElems.size() - 1));
            int wdth = this.lWeidth;
            int hght = (this.paletteElems.size() + 1) * 30;
            if (hght > 300) {
                hght = 300;
            }
            this.scrollPane.setPreferredSize(new Dimension(wdth, hght));
            this.scrollPane.setSize(new Dimension(wdth, hght));
            this.scrollPane.validate();
            this.d.setSize(wdth, hght + 25);
            this.d.validate();
        }
    }

    private void exitForm() {
        this.d.setVisible(false);
        this.d.dispose();
    }

    public void mouseClicked(MouseEvent e) {
        Object source = e.getSource();
        if (e.getClickCount() == 1) {
            JPanel p;
            JLabel l;
            Color col;
            if (source instanceof JPanel && !(col = (l = (JLabel)(p = (JPanel)source).getComponent(0)).getForeground()).equals(SelectedBackgroundColor)) {
                for (int i = 0; i < this.palette.getComponentCount(); ++i) {
                    JPanel pi = (JPanel)this.palette.getComponent(i);
                    JLabel li = (JLabel)pi.getComponent(0);
                    li.setForeground(col);
                }
                l.setForeground(SelectedBackgroundColor);
            }
        } else if (e.getClickCount() == 2 && source instanceof JPanel) {
            JPanel p = (JPanel)source;
            JLabel l = (JLabel)p.getComponent(0);
            this.current = this.buttons.get(l);
            this.currentValid = true;
            this.paletteElems.remove(p);
            this.buttons.remove(l);
            this.propagateSelection(this.current);
            if (this.treeView != null && this.current != null) {
                this.treeView.undoDelete(this.current);
            }
            this.x = this.d.getX();
            this.y = this.d.getY();
            this.exitForm();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private void removeFromTrashPalette(Object obj) {
        JPanel p = (JPanel)this.obj2panel.get(obj);
        this.paletteElems.remove(p);
        this.obj2panel.remove(obj);
    }

    public Object getSelection() {
        if (this.currentValid) {
            this.currentValid = false;
            return this.current;
        }
        return null;
    }
}

