/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.editor.impl.EdGraGra;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleLayer;
import com.objectspace.jgl.HashSet;
import com.objectspace.jgl.OrderedSet;
import com.objectspace.jgl.OrderedSetIterator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class GraGraLayerGUI
extends JDialog
implements ActionListener {
    private JPanel contentPane;
    private JPanel rulePanel;
    private JPanel buttonPanel;
    private JScrollPane ruleScrollPane;
    private JTable ruleTable;
    private JButton closeButton;
    private JButton cancelButton;
    private boolean isCancelled;
    private RuleLayer layer;
    private EdGraGra gragra;
    boolean changed = false;

    public GraGraLayerGUI(JFrame parent, RuleLayer layer) {
        super((Frame)parent, true);
        this.setTitle("Set Layer");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GraGraLayerGUI.this.exitForm(evt);
            }
        });
        this.layer = layer;
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        } else {
            this.setLocation(300, 100);
        }
        this.initComponents();
    }

    private void initComponents() {
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setBackground(Color.lightGray);
        this.rulePanel = new JPanel(new BorderLayout());
        this.rulePanel.setBackground(Color.orange);
        this.rulePanel.setBorder(new TitledBorder("Set Rule Layer"));
        this.ruleTable = new JTable(new HashTableModel(this.layer, new String[]{"Rule", "Layer"}));
        TableColumn layerColumn = this.ruleTable.getColumn("Layer");
        layerColumn.setMaxWidth(50);
        int hght = this.getHeight(this.ruleTable.getRowCount(), this.ruleTable.getRowHeight()) + 10;
        this.ruleTable.doLayout();
        this.ruleScrollPane = new JScrollPane(this.ruleTable);
        this.ruleScrollPane.setPreferredSize(new Dimension(200, hght));
        this.rulePanel.add(this.ruleScrollPane);
        this.buttonPanel = new JPanel(new GridBagLayout());
        this.closeButton = new JButton();
        this.closeButton.setActionCommand("close");
        this.closeButton.setText("Close");
        this.closeButton.setToolTipText("Accept entries and close dialog.");
        this.closeButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.isCancelled = false;
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Reject entries and close dialog.");
        this.cancelButton.addActionListener(this);
        this.constrainBuild(this.buttonPanel, this.closeButton, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 10, 10, 5);
        this.constrainBuild(this.buttonPanel, this.cancelButton, 1, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 10);
        this.contentPane.add((Component)this.rulePanel, "Center");
        this.contentPane.add((Component)this.buttonPanel, "South");
        this.contentPane.revalidate();
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(0);
        this.validate();
        this.pack();
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void showGUI() {
        this.setVisible(true);
    }

    public boolean hasChanged() {
        return this.changed;
    }

    private void acceptValues() {
        Hashtable table = ((HashTableModel)this.ruleTable.getModel()).getTable();
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Integer l = (Integer)table.get(key);
            if (l.intValue() == ((Rule)key).getLayer()) continue;
            ((Rule)key).setLayer(l);
            this.changed = true;
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeButton) {
            this.acceptValues();
            this.setVisible(false);
            this.dispose();
        } else if (source == this.cancelButton) {
            this.isCancelled = true;
            this.setVisible(false);
            this.dispose();
        }
    }

    public void setGraGra(EdGraGra gra) {
        this.gragra = gra;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    private int getHeight(int rowCount, int rowHeight) {
        int h = (rowCount + 1) * rowHeight;
        if (rowCount > 10) {
            h = 12 * rowHeight;
        }
        return h;
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    public class HashTableModel
    extends DefaultTableModel {
        Hashtable table;
        RuleLayer ruleLayer;

        public HashTableModel(Hashtable table, String[] columnNames) {
            for (int i = 0; i < columnNames.length; ++i) {
                this.addColumn(columnNames[i]);
            }
            this.table = table;
            Enumeration keys = this.table.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = this.table.get(key);
                Vector<Object> tmpVector = new Vector<Object>();
                tmpVector.addElement(key);
                tmpVector.addElement(value);
                this.addRow(tmpVector);
            }
        }

        public HashTableModel(RuleLayer layer, String[] columnNames) {
            for (int i = 0; i < columnNames.length; ++i) {
                this.addColumn(columnNames[i]);
            }
            this.table = layer.getRuleLayer();
            this.ruleLayer = layer;
            Integer startLayer = layer.getStartLayer();
            Hashtable invertedRuleLayer = layer.invertLayer();
            OrderedSet ruleLayerSet = new OrderedSet();
            Enumeration en = invertedRuleLayer.keys();
            while (en.hasMoreElements()) {
                ruleLayerSet.add(en.nextElement());
            }
            Integer currentLayer = startLayer;
            boolean nextLayerExists = true;
            while (nextLayerExists && currentLayer != null) {
                HashSet rulesForLayer = (HashSet)invertedRuleLayer.get(currentLayer);
                Enumeration en2 = rulesForLayer.elements();
                while (en2.hasMoreElements()) {
                    Rule rule = (Rule)en2.nextElement();
                    Vector<Object> tmpVector = new Vector<Object>();
                    tmpVector.addElement(rule);
                    tmpVector.addElement(new Integer(rule.getLayer()));
                    this.addRow(tmpVector);
                }
                OrderedSetIterator osi = ruleLayerSet.find(currentLayer);
                if (osi == null || osi.atEnd()) {
                    nextLayerExists = false;
                    continue;
                }
                osi.advance();
                currentLayer = (Integer)osi.get();
            }
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Object getValueAt(int row, int column) {
            Object result = super.getValueAt(row, column);
            if (result instanceof Rule) {
                result = ((Rule)result).getName();
            }
            return result;
        }

        public void setValueAt(Object aValue, int row, int column) {
            Object key = super.getValueAt(row, 0);
            try {
                Integer i = new Integer((String)aValue);
                super.setValueAt(i, row, column);
                this.table.put(key, i);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }

        public Hashtable getTable() {
            return this.table;
        }
    }
}

