/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.editor.impl.EdGraGra;
import agg.gui.AGGFileFilter;
import agg.gui.ExtensionFileFilter;
import agg.gui.LoadSaveStatus;
import agg.gui.ProgressBar;
import agg.gui.event.LoadEvent;
import agg.gui.event.LoadEventListener;
import agg.util.XMLHelper;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class GraGraLoad {
    private ProgressBar bar;
    private Vector loadListeners;
    private JFrame applFrame;
    private JFileChooser chooser;
    private ExtensionFileFilter filterXML;
    private ExtensionFileFilter filterAGG;
    private ExtensionFileFilter filterGRA;
    private String addMsg;
    private EdGraGra gra;
    private GraGra basis;
    private String dirName = "";
    private String fileName = "";

    public GraGraLoad(JFrame fr) {
        this(fr, "", "");
    }

    public GraGraLoad(JFrame fr, String dname, String fname) {
        this.applFrame = fr;
        this.dirName = dname;
        this.fileName = fname;
        this.chooser = !this.dirName.equals("") ? new JFileChooser(this.dirName) : new JFileChooser(System.getProperty("user.dir"));
        this.filterXML = new AGGFileFilter("ggx", "AGG Files XML (.ggx)");
        this.chooser.addChoosableFileFilter(this.filterXML);
        this.chooser.setFileFilter(this.filterXML);
        this.bar = this.createProgressBar();
    }

    public FileFilter getFileFilter() {
        return this.chooser.getFileFilter();
    }

    public void setFileFilter(FileFilter filter) {
        this.chooser.setFileFilter(filter);
    }

    public void setExtensionFileFilter(ExtensionFileFilter filter) {
        this.chooser.setFileFilter(filter);
    }

    public void load() {
        this.fireLoad(new LoadEvent(this, 0, ""));
        this.gra = null;
        this.basis = null;
        int returnVal = this.chooser.showOpenDialog(this.applFrame);
        this.dirName = this.chooser.getCurrentDirectory().toString();
        if (returnVal == 0) {
            if (this.chooser.getSelectedFile() != null && !this.chooser.getSelectedFile().getName().equals("")) {
                this.fileName = this.chooser.getSelectedFile().getName();
                if (!this.dirName.endsWith(File.separator)) {
                    this.dirName = this.dirName + File.separator;
                }
                this.reload();
            } else {
                this.fireLoad(new LoadEvent(this, 10, ""));
            }
        } else {
            this.fireLoad(new LoadEvent(this, 10, ""));
        }
    }

    public void reload(String dirName, String fileName) {
        this.dirName = dirName;
        this.fileName = fileName;
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        if (!this.fileName.endsWith(".ggx")) {
            this.fileName = this.fileName + ".ggx";
        }
        if (this.fileName.endsWith(".ggx")) {
            File f = new File(this.dirName + this.fileName);
            if (f.exists()) {
                XMLHelper h = null;
                h = new XMLHelper();
                if (this.dirName.equals("")) {
                    h.read_from_xml(this.fileName);
                } else {
                    h.read_from_xml(this.dirName + this.fileName);
                }
                GraGra bgra = BaseFactory.theFactory().createGraGra();
                h.getTopObject(bgra);
                this.gra = new EdGraGra(bgra);
                this.gra.setDirName(this.dirName);
                this.gra.setFileName(this.fileName);
                this.gra.getTypeSet().setResourcesPath(this.dirName);
                if (!this.gra.getTypeSet().basisTypeReprComplete()) {
                    this.gra.getTypeSet().setAdditionalReprOfBasisType();
                }
                boolean attrsVisible = true;
                this.gra.update(attrsVisible);
                h.enrichObject(this.gra);
                this.fireLoad(new LoadEvent(this, 12, this.dirName + this.fileName));
            } else {
                JOptionPane.showMessageDialog(null, "File  \"" + this.dirName + this.fileName + "\"  does not exist!", "Cannot load file", 2);
                System.out.println("agg.gui.GraGraLoad:  File  \"" + this.dirName + this.fileName + "\"  does not exist!");
            }
        } else if (!this.dirName.equals("") && !this.fileName.equals("")) {
            this.fireLoad(new LoadEvent(this, 1, this.bar.getContentPanel(), ""));
            this.bar.start();
            int key = -1;
            this.addMsg = "";
            try {
                File f = new File(this.dirName + this.fileName);
                long datei = f.length();
                double multi = ((double)datei + (double)datei * 0.04) / 16000.0;
                LoadSaveStatus.setMaximum((int)(100.0 * multi));
                FileInputStream fis = new FileInputStream(f);
                ObjectInputStream ois = new ObjectInputStream(fis);
                this.gra = (EdGraGra)ois.readObject();
                this.gra.setDirName(this.dirName);
                this.gra.setFileName(this.fileName);
                this.gra.getTypeSet().setResourcesPath(this.dirName);
                if (!this.gra.getTypeSet().basisTypeReprComplete()) {
                    this.gra.getTypeSet().setAdditionalReprOfBasisType();
                }
                this.gra.update();
                fis.close();
                key = 12;
            }
            catch (FileNotFoundException fnfx) {
                this.gra = null;
                key = 5;
                this.addMsg = "";
            }
            catch (SecurityException sx) {
                this.gra = null;
                key = 3;
                this.addMsg = sx.getMessage() == null ? "" : sx.getLocalizedMessage();
            }
            catch (StreamCorruptedException scx) {
                this.gra = null;
                key = 4;
            }
            catch (ClassNotFoundException cnfx) {
                this.gra = null;
                key = 5;
                this.addMsg = cnfx.getLocalizedMessage();
            }
            catch (InvalidClassException icx) {
                this.gra = null;
                key = 6;
                this.addMsg = icx.getLocalizedMessage();
            }
            catch (OptionalDataException odx) {
                this.gra = null;
                key = 7;
                this.addMsg = odx.getLocalizedMessage();
            }
            catch (IOException iox) {
                this.gra = null;
                key = 8;
                this.addMsg = iox.getLocalizedMessage() == null ? "" : iox.getLocalizedMessage();
            }
            catch (StackOverflowError sox) {
                this.gra = null;
                key = 11;
                this.addMsg = sox.getLocalizedMessage() == null ? "" : sox.getLocalizedMessage();
            }
            finally {
                this.fireLoad(new LoadEvent(this, 2, this.bar.getContentPanel(), ""));
                this.fireLoad(new LoadEvent(this, key, this.dirName + this.fileName, this.addMsg));
                this.bar.finish();
                this.bar.quit();
            }
        }
    }

    public void loadBase() {
        this.fireLoad(new LoadEvent(this, 0, ""));
        int returnVal = this.chooser.showOpenDialog(this.applFrame);
        this.dirName = this.chooser.getCurrentDirectory().toString();
        if (returnVal == 0) {
            if (this.chooser.getSelectedFile() != null && !this.chooser.getSelectedFile().getName().equals("")) {
                this.fileName = this.chooser.getSelectedFile().getName();
                if (!this.dirName.endsWith(File.separator)) {
                    this.dirName = this.dirName + File.separator;
                }
                this.reloadBase();
            } else {
                this.fireLoad(new LoadEvent(this, 10, ""));
            }
        } else {
            this.fireLoad(new LoadEvent(this, 10, ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadBase() {
        if (this.fileName.endsWith(".ggx")) {
            XMLHelper h = new XMLHelper();
            if (this.dirName.equals("")) {
                h.read_from_xml(this.fileName);
            } else {
                h.read_from_xml(this.dirName + this.fileName);
            }
            this.basis = BaseFactory.theFactory().createGraGra();
            h.getTopObject(this.basis);
            this.fireLoad(new LoadEvent(this, 12, this.dirName + this.fileName));
        } else if (!this.dirName.equals("") && !this.fileName.equals("")) {
            this.fireLoad(new LoadEvent(this, 1, this.bar.getContentPanel(), ""));
            this.bar.start();
            int key = -1;
            this.addMsg = "";
            try {
                File f = new File(this.dirName + this.fileName);
                long datei = f.length();
                double multi = ((double)datei + (double)datei * 0.04) / 16000.0;
                LoadSaveStatus.setMaximum((int)(100.0 * multi));
                FileInputStream fis = new FileInputStream(f);
                ObjectInputStream ois = new ObjectInputStream(fis);
                this.basis = (GraGra)ois.readObject();
                fis.close();
                key = 12;
            }
            catch (FileNotFoundException fnfx) {
                key = 5;
                this.addMsg = "";
            }
            catch (SecurityException sx) {
                key = 3;
                this.addMsg = sx.getMessage() == null ? "" : sx.getLocalizedMessage();
            }
            catch (StreamCorruptedException scx) {
                key = 4;
            }
            catch (ClassNotFoundException cnfx) {
                key = 5;
                this.addMsg = cnfx.getLocalizedMessage();
            }
            catch (InvalidClassException icx) {
                key = 6;
                this.addMsg = icx.getLocalizedMessage();
            }
            catch (OptionalDataException odx) {
                key = 7;
                this.addMsg = odx.getLocalizedMessage();
            }
            catch (IOException iox) {
                key = 8;
                this.addMsg = iox.getMessage() == null ? "" : iox.getLocalizedMessage();
            }
            catch (StackOverflowError sox) {
                key = 11;
                this.addMsg = sox.getMessage() == null ? "" : sox.getLocalizedMessage();
            }
            finally {
                this.fireLoad(new LoadEvent(this, 2, this.bar.getContentPanel(), ""));
                this.fireLoad(new LoadEvent(this, key, this.dirName + this.fileName, this.addMsg));
                this.bar.finish();
                this.bar.quit();
            }
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setDirName(String directory) {
        if (!directory.equals("")) {
            this.dirName = directory;
            this.chooser = new JFileChooser(this.dirName);
            this.filterXML = new AGGFileFilter("ggx", "AGG Files XML (.ggx)");
            this.chooser.addChoosableFileFilter(this.filterXML);
            this.chooser.setFileFilter(this.filterXML);
        }
    }

    public EdGraGra getGraGra() {
        return this.gra;
    }

    public GraGra getBaseGraGra() {
        return this.basis;
    }

    public void setGraGra(EdGraGra gragra, String dirname, String filename) {
        this.gra = gragra;
        if (dirname != null && !dirname.equals("")) {
            this.dirName = dirname;
        }
        this.fileName = filename;
    }

    public void setBaseGraGra(GraGra gragra) {
        this.basis = gragra;
    }

    public void setBaseGraGra(GraGra gragra, String dirname, String filename) {
        this.basis = gragra;
        if (dirname != null && !dirname.equals("")) {
            this.dirName = dirname;
        }
        this.fileName = filename;
    }

    public void setFrame(JFrame f) {
        this.applFrame = f;
        if (this.bar != null) {
            this.bar.setFrame(f);
        }
    }

    public synchronized void addLoadEventListener(LoadEventListener l) {
        Vector v;
        Vector vector = v = this.loadListeners == null ? new Vector(2) : (Vector)this.loadListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.loadListeners = v;
        }
    }

    public synchronized void removeLoadEventListener(LoadEventListener l) {
        if (this.loadListeners != null && this.loadListeners.contains(l)) {
            Vector v = (Vector)this.loadListeners.clone();
            v.removeElement(l);
            this.loadListeners = v;
        }
    }

    private void fireLoad(LoadEvent e) {
        if (this.loadListeners != null) {
            Vector listeners = this.loadListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LoadEventListener)listeners.elementAt(i)).loadEventOccurred(e);
            }
        }
    }

    private ProgressBar createProgressBar() {
        ProgressBar bar = new ProgressBar("Save");
        bar.setLabel("Saving Files ...");
        bar.setFinishText("Saving Files done");
        bar.setToolTipText("Save Status");
        bar.setFinishAppend(false);
        return bar;
    }
}

