/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.editor.impl.Arrow;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdRule;
import agg.editor.impl.GraphCanvas;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class GraGraPrint
extends JPanel
implements ActionListener,
EditEventListener {
    private EdGraGra gragra;
    private JPanel gragraPanel;
    private JFrame applFrame;
    private JDialog dialog;
    private JButton preview;
    private JButton print;
    private JFrame previewFrame;
    private JButton previewPrint;
    private JButton previewCancel;
    private JCheckBox all;
    private JCheckBox g;
    private Vector gragraRuleChecks;
    private Vector gragraRuleInfos;
    private Vector gragraOptionalChecks;
    private Vector optionalChecks;
    private JDialog ruleCheck;
    private Vector optional;
    private boolean cancelled = false;
    private int W = 468;
    private int H = 648;
    private static final int offset = 10;
    private Dimension pageable = new Dimension(612, 792);
    private Dimension imageable = new Dimension(468, 648);
    private double scale = 1.0;
    private PageFormat pageFormat;
    private Font font = new Font("Dialog", 0, 12);
    private String fontName = "Dialog";
    private int fontStyle = 0;
    private int fontSize = 12;

    public GraGraPrint(JFrame applFrame) {
        this(applFrame, null);
    }

    public GraGraPrint(JFrame applFrame, EdGraGra gra) {
        super(new BorderLayout(), true);
        this.setBackground(Color.white);
        this.applFrame = applFrame;
        this.gragra = gra;
        this.initialize(this.gragra);
    }

    private void initialize(EdGraGra gra) {
        this.gragraRuleChecks = new Vector();
        this.gragraRuleInfos = new Vector();
        this.gragraOptionalChecks = new Vector();
        this.optionalChecks = new Vector();
        this.previewFrame = new JFrame("Preview");
        this.setSize(150, 150);
        this.setPreferredSize(new Dimension(150, 150));
        JScrollPane jsp = new JScrollPane(22, 32);
        jsp.setViewportView(this);
        this.previewFrame.getContentPane().add("Center", jsp);
        JPanel buttonPanel = new JPanel();
        this.previewPrint = new JButton("Print");
        this.previewCancel = new JButton("Cancel");
        buttonPanel.add(this.previewPrint);
        buttonPanel.add(this.previewCancel);
        this.previewPrint.addActionListener(this);
        this.previewCancel.addActionListener(this);
        this.previewFrame.getContentPane().add("South", buttonPanel);
        this.previewFrame.setSize(150, 150);
        this.previewFrame.setLocation(10, 10);
        this.previewFrame.pack();
        this.dialog = new JDialog(new JFrame(), "Print", true);
        JPanel mainPanel = new JPanel(new GridBagLayout(), true);
        mainPanel.setPreferredSize(new Dimension(300, 300));
        this.dialog.getContentPane().add(mainPanel);
        this.gragraPanel = new JPanel(new BorderLayout());
        this.gragraPanel.add((Component)this.createGraGraCheckBox(gra), "Center");
        JPanel scalePanel = new JPanel(new BorderLayout());
        scalePanel.add((Component)this.createScaleBox(), "Center");
        JPanel confirmPanel = new JPanel(new BorderLayout());
        confirmPanel.add((Component)this.createConfirmButtons(), "Center");
        this.print.addActionListener(this);
        this.constrainBuild(mainPanel, this.gragraPanel, 0, 0, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(mainPanel, confirmPanel, 0, 2, 2, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        this.dialog.pack();
        this.dialog.setLocation(50, 50);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton && (e.getSource() == this.previewPrint || e.getSource() == this.print)) {
            if (this.isEmpty()) {
                return;
            }
            PrinterJob printJob = PrinterJob.getPrinterJob();
            if (printJob != null) {
                printJob.setJobName("GraGra");
                this.pageFormat = printJob.defaultPage();
                this.pageFormat.setOrientation(1);
                Book book = new Book();
                printJob.setPageable(book);
                if (printJob.printDialog()) {
                    this.pageable = new Dimension((int)this.pageFormat.getWidth(), (int)this.pageFormat.getHeight());
                    this.imageable = new Dimension(this.pageable.width - 2 * (int)this.pageFormat.getImageableX(), this.pageable.height - 2 * (int)this.pageFormat.getImageableY());
                    this.W = this.imageable.width;
                    this.H = this.imageable.height;
                    Vector pages = this.getPagesToPrint(this.pageFormat);
                    if (pages != null) {
                        for (int i = 0; i < pages.size(); ++i) {
                            PaintContent paintContent = new PaintContent();
                            paintContent.setPageImages((Vector)pages.elementAt(i));
                            book.append(paintContent, this.pageFormat);
                        }
                    }
                    try {
                        printJob.print();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        this.previewFrame.dispose();
    }

    public void editEventOccurred(EditEvent e) {
        int msgkey = e.getMsg();
        if (msgkey == -4) {
            this.fontStyle = e.getIntValue();
        } else if (msgkey == -5) {
            this.fontSize = e.getIntValue();
        } else if (msgkey == -6) {
            this.scale = e.getDoubleValue();
        }
    }

    public void showDialog() {
        this.dialog.setVisible(true);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2D.setPaint(Color.white);
        g2D.drawRect(0, 0, this.getWidth(), this.getHeight());
        this.printImages(g2D);
    }

    public void setGraGra(EdGraGra gra) {
        this.gragra = gra;
        this.gragraRuleChecks = new Vector();
        this.gragraRuleInfos = new Vector();
        this.gragraOptionalChecks = new Vector();
        this.optionalChecks = new Vector();
        this.gragraPanel.removeAll();
        this.gragraPanel.add((Component)this.createGraGraCheckBox(this.gragra), "Center");
        this.preview.setEnabled(false);
        this.print.setEnabled(false);
    }

    public void setFrame(JFrame f) {
        this.applFrame = f;
        if (this.dialog != null && this.applFrame != null) {
            this.dialog.setLocation(this.applFrame.getLocation().x + this.applFrame.getWidth() / 4, this.applFrame.getLocation().y + this.applFrame.getHeight() / 4);
        }
    }

    public boolean isEmpty() {
        if (this.cancelled) {
            return true;
        }
        if (this.all.isSelected()) {
            return false;
        }
        if (this.g.isSelected()) {
            return false;
        }
        for (int i = 0; i < this.gragraRuleChecks.size(); ++i) {
            JCheckBox cb = (JCheckBox)this.gragraRuleChecks.elementAt(i);
            if (!cb.isSelected()) continue;
            return false;
        }
        return true;
    }

    private Vector getAllImages() {
        Vector<Image> images = new Vector<Image>();
        for (int i = 0; i < this.gragraRuleChecks.size(); ++i) {
            Vector imgs;
            JCheckBox cb = (JCheckBox)this.gragraRuleChecks.elementAt(i);
            EdRule r = (EdRule)this.gragra.getRules().elementAt(i);
            if (!this.all.isSelected() && !cb.isSelected() || (imgs = this.getImage(i, r)) == null) continue;
            for (int j = 0; j < imgs.size(); ++j) {
                Image image = (Image)imgs.elementAt(j);
                if (image == null) continue;
                images.addElement(image);
            }
        }
        if (this.all.isSelected() || this.g.isSelected()) {
            Image image = null;
            image = this.gragra.getGraph().getGraphDimension((double)this.scale).width == 0 ? this.getImage(this.gragra.getGraph(), new Dimension(100, 50)) : this.getImage(this.gragra.getGraph(), null);
            if (image != null) {
                images.addElement(image);
            }
        }
        return images;
    }

    private void paintImages(Graphics2D grs) {
        Vector images = this.getAllImages();
        if (images.isEmpty()) {
            return;
        }
        int x = 72;
        int y = 72;
        for (int i = 0; i < images.size(); ++i) {
            Image image = (Image)images.elementAt(i);
            grs.drawImage(image, x, y, null);
            y = y + image.getHeight(null) + 10;
        }
        int sizeX = this.W + 72;
        int sizeY = y + 10;
        this.setSize(sizeX, sizeY);
        for (int i = this.H + 72; i < sizeY; i += this.H + 72) {
            grs.setPaint(Color.black);
            grs.drawLine(0, i - 2, sizeX - 1, i - 2);
        }
        grs.setPaint(Color.white);
    }

    private void printImages(Graphics2D grs) {
        Vector pages;
        if (this.pageFormat == null) {
            this.pageFormat = new PageFormat();
        }
        if ((pages = this.getPagesToPrint(this.pageFormat)).isEmpty()) {
            return;
        }
        int x = 0;
        int y = 0;
        for (int j = 0; j < pages.size(); ++j) {
            Vector pageImages = (Vector)pages.elementAt(j);
            if (pageImages == null) continue;
            x = (int)this.pageFormat.getImageableX();
            y += (int)this.pageFormat.getImageableY();
            for (int i = 0; i < pageImages.size(); ++i) {
                Image image = (Image)pageImages.elementAt(i);
                grs.drawImage(image, x, y, null);
                y += image.getHeight(null);
            }
            grs.setPaint(Color.black);
            grs.drawLine(0, y += (int)this.pageFormat.getImageableY(), this.W, y);
            grs.setPaint(Color.white);
        }
        this.setSize(this.W + (int)this.pageFormat.getImageableX() + 10, y + 10);
    }

    private Vector getPagesToPrint(PageFormat pf) {
        Vector pgs = new Vector();
        Vector images = this.getAllImages();
        if (images.isEmpty()) {
            return pgs;
        }
        boolean sizeX = false;
        boolean sizeY = false;
        int x = (int)pf.getImageableX();
        int y = (int)pf.getImageableY();
        Vector<Image> page = new Vector<Image>();
        for (int i = 0; i < images.size(); ++i) {
            Image image = (Image)images.elementAt(i);
            if (image == null) continue;
            if (y + image.getHeight(null) <= this.imageable.height) {
                page.addElement(image);
                if ((y += image.getHeight(null)) + 10 > this.imageable.height) continue;
                y = y + image.getHeight(null) + 10;
                continue;
            }
            if (!page.isEmpty()) {
                pgs.addElement(page);
            }
            y = (int)this.pageFormat.getImageableY();
            page = new Vector();
            page.addElement(image);
            if ((y += image.getHeight(null)) + 10 > this.imageable.height) continue;
            y = y + image.getHeight(null) + 10;
        }
        if (page != null && !page.isEmpty()) {
            pgs.addElement(page);
        }
        return pgs;
    }

    private JPanel createGraGraCheckBox(EdGraGra gra) {
        JPanel p = new JPanel(new GridBagLayout());
        JLabel info = new JLabel("GraGra: EMPTY");
        if (gra == null) {
            return p;
        }
        info = new JLabel("GraGra:  " + gra.getName());
        int y = 0;
        this.constrainBuild(p, info, 0, y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        this.all = new JCheckBox("All");
        this.all.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JCheckBox && e.getSource() == GraGraPrint.this.all) {
                    if (GraGraPrint.this.all.isSelected()) {
                        GraGraPrint.this.deselectRules();
                        GraGraPrint.this.g.setSelected(false);
                        GraGraPrint.this.preview.setEnabled(true);
                        GraGraPrint.this.print.setEnabled(true);
                    } else if (GraGraPrint.this.isEmpty()) {
                        GraGraPrint.this.preview.setEnabled(false);
                        GraGraPrint.this.print.setEnabled(false);
                    }
                }
            }
        });
        this.constrainBuild(p, this.all, 0, ++y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        JLabel optional = new JLabel("optional");
        this.constrainBuild(p, optional, 1, y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        for (int i = 0; i < gra.getRules().size(); ++i) {
            final EdRule r = (EdRule)gra.getRules().elementAt(i);
            final int indx = i;
            if (r == null) continue;
            JCheckBox cb = new JCheckBox(r.getBasisRule().getName());
            cb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JCheckBox item = (JCheckBox)e.getSource();
                    if (item.isSelected()) {
                        GraGraPrint.this.all.setSelected(false);
                        ((JCheckBox)GraGraPrint.this.gragraOptionalChecks.elementAt(indx)).setEnabled(true);
                        GraGraPrint.this.preview.setEnabled(true);
                        GraGraPrint.this.print.setEnabled(true);
                    } else {
                        ((JCheckBox)GraGraPrint.this.gragraOptionalChecks.elementAt(indx)).setEnabled(false);
                        if (GraGraPrint.this.isEmpty()) {
                            GraGraPrint.this.preview.setEnabled(false);
                            GraGraPrint.this.print.setEnabled(false);
                        }
                    }
                }
            });
            this.gragraRuleChecks.add(cb);
            this.constrainBuild(p, cb, 0, ++y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
            cb = new JCheckBox();
            cb.setEnabled(false);
            this.gragraOptionalChecks.addElement(cb);
            final Vector checks = new Vector();
            this.optionalChecks.add(checks);
            cb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JCheckBox item = (JCheckBox)e.getSource();
                    if (item.isSelected()) {
                        GraGraPrint.this.ruleCheck = GraGraPrint.this.getRuleCheckBox(r, indx, checks);
                    }
                }
            });
            this.constrainBuild(p, cb, 1, y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
            info = new JLabel("");
            this.gragraRuleInfos.addElement(info);
            this.constrainBuild(p, info, 0, ++y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        }
        this.g = new JCheckBox(this.gragra.getGraph().getBasisGraph().getName());
        this.g.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JCheckBox && e.getSource() == GraGraPrint.this.g) {
                    if (GraGraPrint.this.g.isSelected()) {
                        GraGraPrint.this.all.setSelected(false);
                        GraGraPrint.this.preview.setEnabled(true);
                        GraGraPrint.this.print.setEnabled(true);
                    } else if (GraGraPrint.this.isEmpty()) {
                        GraGraPrint.this.preview.setEnabled(false);
                        GraGraPrint.this.print.setEnabled(false);
                    }
                }
            }
        });
        this.constrainBuild(p, this.g, 0, ++y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        return p;
    }

    private JDialog getRuleCheckBox(EdRule r, int n, Vector v) {
        final JDialog dial = new JDialog(new JFrame(), "optional", true);
        JPanel p = new JPanel(new GridBagLayout());
        dial.getContentPane().add(p);
        int y = 0;
        JCheckBox cb = new JCheckBox("LHS");
        this.constrainBuild(p, cb, 0, y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        v.addElement(cb);
        cb = new JCheckBox("RHS");
        this.constrainBuild(p, cb, 0, ++y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        v.addElement(cb);
        if (r.getNACs().size() != 0) {
            JLabel l = new JLabel("NAC:");
            this.constrainBuild(p, l, 0, ++y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
            for (int i = 0; i < r.getNACs().size(); ++i) {
                EdNAC nac = (EdNAC)r.getNACs().elementAt(i);
                cb = new JCheckBox(nac.getName());
                v.addElement(cb);
                this.constrainBuild(p, cb, 0, ++y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
            }
        }
        ++y;
        JButton ok = new JButton("OK");
        ok.setBorderPainted(true);
        final Vector checks = v;
        final int indx = n;
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean check = false;
                for (int i = 0; i < checks.size(); ++i) {
                    JCheckBox c = (JCheckBox)checks.elementAt(i);
                    if (!c.isSelected()) continue;
                    check = true;
                }
                if (!check) {
                    GraGraPrint.this.deselectRuleOptional(indx);
                }
                dial.setVisible(false);
            }
        });
        this.constrainBuild(p, ok, 0, y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        dial.pack();
        dial.setLocation(this.dialog.getX() + 100, this.dialog.getY() + 50);
        dial.setVisible(true);
        return dial;
    }

    private JPanel createScaleBox() {
        JPanel p = new JPanel();
        JLabel l = new JLabel("Scale:  ");
        p.add(l);
        final JTextField s = new JTextField("1.0", 3);
        p.add(s);
        this.scale = 1.0;
        s.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JTextField) {
                    try {
                        Double d = new Double(((JTextField)e.getSource()).getText().trim());
                        GraGraPrint.this.scale = d;
                    }
                    catch (NumberFormatException ex) {
                        s.setText("1.0");
                    }
                }
            }
        });
        return p;
    }

    private JPanel createConfirmButtons() {
        JPanel p = new JPanel(new GridBagLayout());
        this.preview = new JButton("Preview");
        this.preview.setEnabled(false);
        this.preview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraGraPrint.this.dialog.setVisible(false);
                GraGraPrint.this.previewFrame.setVisible(true);
            }
        });
        this.constrainBuild(p, this.preview, 0, 0, 1, 1, 1, 10, 0.0, 0.0, 5, 10, 5, 5);
        this.print = new JButton("Print");
        this.print.setEnabled(false);
        this.print.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraGraPrint.this.dialog.setVisible(false);
            }
        });
        this.constrainBuild(p, this.print, 1, 0, 1, 1, 1, 10, 0.0, 0.0, 5, 10, 5, 5);
        JButton b = new JButton("Cancel");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraGraPrint.this.cancelled = true;
                GraGraPrint.this.dialog.setVisible(false);
            }
        });
        this.constrainBuild(p, b, 2, 0, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 10);
        return p;
    }

    private void deselectRules() {
        for (int i = 0; i < this.gragraRuleChecks.size(); ++i) {
            ((JCheckBox)this.gragraRuleChecks.elementAt(i)).setSelected(false);
            ((JCheckBox)this.gragraOptionalChecks.elementAt(i)).setEnabled(false);
        }
    }

    private void deselectRuleOptional(int n) {
        JCheckBox cb = (JCheckBox)this.gragraOptionalChecks.elementAt(n);
        cb.setSelected(false);
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    private Image getImage(EdGraph g, Dimension imageDim) {
        int h;
        int w;
        Image image;
        if (g == null) {
            return null;
        }
        Dimension graphDim = g.getGraphDimension(this.scale);
        if (graphDim == null) {
            return null;
        }
        graphDim.width = graphDim.width;
        graphDim.height = graphDim.height;
        Dimension d = new Dimension(graphDim.width, 20 + graphDim.height);
        if (imageDim != null) {
            if (imageDim.width > d.width) {
                d.width = imageDim.width;
            }
            if (imageDim.height > d.height) {
                d.height = imageDim.height;
            }
        }
        if ((image = this.createImage(w = d.width, h = d.height)) == null) {
            return null;
        }
        Graphics2D grs = (Graphics2D)image.getGraphics();
        grs.setPaint(Color.white);
        grs.fill(new Rectangle(0, 0, w, h));
        GraphCanvas canvas = new GraphCanvas();
        canvas.setSize(d);
        canvas.setGraph(g);
        Image im = this.createImage(graphDim.width, graphDim.height);
        canvas.setScale(this.scale);
        canvas.setFontStyle(this.fontStyle);
        canvas.setFontSize(this.fontSize);
        canvas.paint(im.getGraphics());
        grs.setPaint(Color.black);
        grs.drawString(g.getBasisGraph().getName(), 10, 15);
        grs.drawImage(im, 1, 20, null);
        grs.drawRect(1, 20, w - 2, h - 20 - 2);
        return image;
    }

    private Image getImage(Vector graphs) {
        if (graphs == null || graphs.isEmpty()) {
            return null;
        }
        int iw = 0;
        int ih = 0;
        Vector<EdGraph> imageGraphs = new Vector<EdGraph>();
        for (int i = 0; i < graphs.size(); ++i) {
            EdGraph g = (EdGraph)graphs.elementAt(i);
            if (this.optional == null || !this.optional.isEmpty() && !((Boolean)this.optional.elementAt(i + 2)).booleanValue()) continue;
            Dimension graphDim = g.getGraphDimension(this.scale);
            if (graphDim.width > iw) {
                iw = graphDim.width;
            }
            if (graphDim.height > ih) {
                ih = graphDim.height;
            }
            if (iw <= 0 || ih <= 0) continue;
            imageGraphs.addElement(g);
        }
        iw += 10;
        ih = 20 + ih + 10;
        Vector<Image> images = new Vector<Image>();
        for (int i = 0; i < imageGraphs.size(); ++i) {
            EdGraph g = (EdGraph)imageGraphs.elementAt(i);
            Image image = this.getImage(g, new Dimension(iw, ih));
            images.addElement(image);
        }
        Dimension space = new Dimension(10, ih);
        int w = 0;
        int h = 0;
        int n = 0;
        for (int i = 0; i < images.size(); ++i) {
            Image image = (Image)images.elementAt(i);
            if (i == 0) {
                w = iw;
                n = 1;
                continue;
            }
            if (w + space.width > this.W) {
                n = i;
                i = images.size();
                continue;
            }
            if (w + space.width + iw > this.W) {
                w += space.width;
                n = i;
                i = images.size();
                continue;
            }
            ++n;
            w = w + space.width + iw;
        }
        int nn = Math.round((float)images.size() / (float)n);
        if (nn > 0) {
            h = nn * ih + 20;
            while (h > this.H) {
                h = --nn * ih + 20;
            }
            Image bigImage = this.createImage(w, h);
            Graphics2D grs = (Graphics2D)bigImage.getGraphics();
            grs.setPaint(Color.white);
            grs.fill(new Rectangle(0, 0, w, h));
            int x = 0;
            int y = 0;
            for (int i = 0; i < images.size(); ++i) {
                Image image = (Image)images.elementAt(i);
                if (x + space.width > this.W || x + space.width + iw > this.W) {
                    x = 0;
                    y += ih;
                }
                grs.drawImage(image, x, y, null);
                x = x + iw + space.width;
            }
            return bigImage;
        }
        return null;
    }

    private Image getRuleArrow(Dimension d, boolean horizontal) {
        if (d == null) {
            return null;
        }
        Image image = this.createImage(d.width, d.height);
        Graphics2D grs = (Graphics2D)image.getGraphics();
        grs.setPaint(Color.white);
        grs.fill(new Rectangle(0, 0, d.width, d.height));
        grs.setPaint(Color.black);
        Arrow arrow = null;
        if (horizontal) {
            grs.drawLine(0, d.height / 2, d.width, d.height / 2);
            arrow = new Arrow(1.0, 0, d.height / 2, d.width, d.height / 2);
        } else {
            grs.drawLine(d.width / 2, 0, d.width / 2, d.height);
            arrow = new Arrow(1.0, d.width / 2, 0, d.width / 2, d.height);
        }
        arrow.draw(grs);
        return image;
    }

    private Vector getImage(int ruleIndx, EdRule r) {
        int i;
        if (r == null) {
            return null;
        }
        this.optional = new Vector();
        if (((JCheckBox)this.gragraOptionalChecks.elementAt(ruleIndx)).isSelected()) {
            Vector v = (Vector)this.optionalChecks.elementAt(ruleIndx);
            for (i = 0; i < v.size(); ++i) {
                Boolean b;
                JCheckBox cb = (JCheckBox)v.elementAt(i);
                if (cb.isSelected()) {
                    b = new Boolean(true);
                    this.optional.addElement(b);
                    continue;
                }
                b = new Boolean(false);
                this.optional.addElement(b);
            }
        } else {
            Boolean b = new Boolean(true);
            this.optional.addElement(b);
            b = new Boolean(true);
            this.optional.addElement(b);
            for (i = 0; i < r.getNACs().size(); ++i) {
                b = new Boolean(true);
                this.optional.addElement(b);
            }
        }
        int w = 0;
        int h = 0;
        Dimension leftDim = r.getLeft().getGraphDimension(this.scale);
        Dimension rightDim = r.getRight().getGraphDimension(this.scale);
        w = leftDim.width > rightDim.width ? leftDim.width : rightDim.width;
        h = leftDim.height > rightDim.height ? leftDim.height : rightDim.height;
        h = 20 + h + 10;
        int lw = 0;
        int lh = 0;
        Image leftImage = null;
        if (((Boolean)this.optional.elementAt(0)).booleanValue() && (leftImage = this.getImage(r.getLeft(), new Dimension(w += 10, h))) != null) {
            lw = w;
            lh = h;
        }
        int rw = 0;
        int rh = 0;
        Image rightImage = null;
        if (((Boolean)this.optional.elementAt(1)).booleanValue() && (rightImage = this.getImage(r.getRight(), new Dimension(w, h))) != null) {
            rw = w;
            rh = h;
        }
        Image ruleArrow = null;
        boolean horizontal = true;
        Dimension arrowDim = new Dimension(0, 0);
        if (leftImage != null && rightImage != null) {
            if (lw + 30 >= this.W || lw + 30 + rw >= this.W) {
                arrowDim = new Dimension(lw, 30);
                horizontal = false;
                ruleArrow = this.getRuleArrow(arrowDim, horizontal);
            } else {
                arrowDim = new Dimension(30, h + 20);
                horizontal = true;
                ruleArrow = this.getRuleArrow(arrowDim, horizontal);
            }
        }
        int ruleW = 0;
        int ruleH = 0;
        Image ruleImage = null;
        Graphics2D grs = null;
        int x = 0;
        int y = 0;
        if (leftImage != null && rightImage != null && horizontal) {
            ruleW = lw + arrowDim.width + rw;
            ruleH = lh;
            ruleImage = this.createImage(ruleW, ruleH);
            grs = (Graphics2D)ruleImage.getGraphics();
            grs.setColor(Color.white);
            grs.fillRect(0, 0, ruleW, ruleH);
            grs.drawImage(leftImage, x, y, null);
            grs.drawImage(ruleArrow, x += lw, y, null);
            grs.drawImage(rightImage, x += ruleArrow.getWidth(null), y, null);
        } else if (leftImage != null && rightImage != null && !horizontal) {
            ruleW = lw;
            ruleH = lh + ruleArrow.getHeight(null) + lh;
            ruleImage = this.createImage(ruleW, ruleH);
            grs = (Graphics2D)ruleImage.getGraphics();
            grs.setColor(Color.white);
            grs.fillRect(0, 0, ruleW, ruleH);
            grs.drawImage(leftImage, x, y, null);
            grs.drawImage(ruleArrow, x, y += lh, null);
            grs.drawImage(rightImage, x, y += ruleArrow.getHeight(null), null);
        } else if (leftImage != null) {
            ruleW = lw;
            ruleH = lh;
            ruleImage = this.createImage(ruleW, ruleH);
            grs = (Graphics2D)ruleImage.getGraphics();
            grs.setColor(Color.white);
            grs.fillRect(0, 0, ruleW, ruleH);
            grs.drawImage(leftImage, x, y, null);
        } else if (rightImage != null) {
            ruleW = rw;
            ruleH = rh;
            ruleImage = this.createImage(ruleW, ruleH);
            grs = (Graphics2D)ruleImage.getGraphics();
            grs.setColor(Color.white);
            grs.fillRect(0, 0, ruleW, ruleH);
            grs.drawImage(rightImage, x, y, null);
        }
        Vector<Image> images = new Vector<Image>();
        int bigImageW = 0;
        int bigImageH = 0;
        if (ruleImage != null) {
            bigImageW = ruleW;
            bigImageH = ruleH;
        }
        Image bigImage = null;
        Image nacImage = null;
        Vector nacs = r.getNACs();
        nacImage = this.getImage(nacs);
        if (nacImage != null) {
            if (ruleImage != null) {
                if (ruleH + nacImage.getHeight(null) > this.H) {
                    bigImageW = this.W;
                    bigImageH = this.H;
                    bigImage = this.createImage(bigImageW, bigImageH);
                    grs = (Graphics2D)bigImage.getGraphics();
                    grs.setPaint(Color.white);
                    grs.fillRect(0, 0, bigImageW, bigImageH);
                    grs.setColor(Color.black);
                    grs.drawString("Rule: " + r.getBasisRule().getName(), 10, 15);
                    x = 5;
                    y = 20;
                    grs.drawImage(ruleImage, x, y, null);
                    grs.drawRect(1, 20, ruleW + 10 - 2, ruleH + 5);
                    images.addElement(bigImage);
                } else {
                    bigImageH += nacImage.getHeight(null);
                }
            } else {
                bigImageH = nacImage.getHeight(null);
            }
            bigImageW = nacImage.getWidth(null) > bigImageW ? nacImage.getWidth(null) : ruleW;
        }
        if (images.isEmpty()) {
            bigImageH = 20 + bigImageH + 5;
            bigImage = this.createImage(bigImageW += 10, bigImageH);
            grs = (Graphics2D)bigImage.getGraphics();
            grs.setPaint(Color.white);
            grs.fillRect(0, 0, bigImageW, bigImageH);
            grs.setColor(Color.black);
            grs.drawString("Rule: " + r.getBasisRule().getName(), 10, 15);
            x = 5;
            y = 20;
            grs.drawImage(ruleImage, x, y, null);
            if (nacImage != null) {
                grs.drawImage(nacImage, x, y += ruleImage.getHeight(null), null);
            }
            grs.drawRect(1, 20, bigImageW - 2, bigImageH - 20 - 1);
            images.addElement(bigImage);
        } else if (nacImage != null) {
            bigImageW = this.W;
            bigImageH = this.H;
            bigImage = this.createImage(bigImageW, bigImageH);
            grs = (Graphics2D)bigImage.getGraphics();
            grs.setPaint(Color.white);
            grs.fillRect(0, 0, bigImageW, bigImageH);
            grs.setColor(Color.black);
            grs.drawString("NAC(s) of Rule: " + r.getBasisRule().getName(), 10, 15);
            x = 5;
            y = 20;
            grs.drawImage(nacImage, x, y, null);
            grs.drawRect(1, 20, nacImage.getWidth(null) + 10 - 2, nacImage.getHeight(null) - 1);
            images.addElement(bigImage);
        }
        return images;
    }

    private PrintJob getPrintJob() {
        if (this.applFrame == null) {
            return null;
        }
        Frame f = new Frame("");
        f.pack();
        Toolkit tk = f.getToolkit();
        PrintJob pj = tk.getPrintJob(this.applFrame, "Print Job", new Properties());
        return pj;
    }

    class PaintContent
    implements Printable {
        private Vector myPageImages;

        PaintContent() {
        }

        public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
            if (this.myPageImages != null) {
                Graphics2D g2D = (Graphics2D)g;
                g2D.setFont(GraGraPrint.this.font);
                int x = (int)pf.getImageableX();
                int y = (int)pf.getImageableY();
                for (int i = 0; i < this.myPageImages.size(); ++i) {
                    Image image = (Image)this.myPageImages.elementAt(i);
                    g2D.drawImage(image, x, y, null);
                    y += image.getHeight(null);
                }
                return 0;
            }
            return 1;
        }

        public void setPageImages(Vector imgs) {
            this.myPageImages = imgs;
        }
    }

    class PaintCover
    implements Printable {
        PaintCover() {
        }

        public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
            Font fnt = new Font("Helvetica-Bold", 1, 48);
            g.setFont(GraGraPrint.this.font);
            g.setColor(Color.black);
            g.drawString("Graph Grammar", 100, 200);
            return 0;
        }
    }
}

