/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.editor.impl.EdGraGra;
import agg.gui.AGGFileFilter;
import agg.gui.ExtensionFileFilter;
import agg.gui.LoadSaveStatus;
import agg.gui.ProgressBar;
import agg.gui.event.SaveEvent;
import agg.gui.event.SaveEventListener;
import agg.util.XMLHelper;
import agg.xt_basis.GraGra;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public class GraGraSave {
    private ProgressBar bar;
    private Vector saveListeners;
    private JFrame applFrame;
    private JFileChooser chooser;
    private ExtensionFileFilter filterXML;
    private ExtensionFileFilter filterAGG;
    private String addMsg;
    private EdGraGra gra;
    private GraGra basis;
    private String dirName = "";
    private String fileName = "";

    public GraGraSave(JFrame fr) {
        this(fr, "", "");
    }

    public GraGraSave(JFrame fr, String dname, String fname) {
        this.applFrame = fr;
        this.dirName = dname;
        this.fileName = fname;
        this.chooser = !this.dirName.equals("") ? new JFileChooser(this.dirName) : new JFileChooser(System.getProperty("user.dir"));
        this.filterXML = new AGGFileFilter("ggx", "AGG Files XML (.ggx)");
        this.chooser.addChoosableFileFilter(this.filterXML);
        this.chooser.setFileFilter(this.filterXML);
        this.bar = this.createProgressBar();
    }

    public FileFilter getFileFilter() {
        return this.chooser.getFileFilter();
    }

    public void setFileFilter(FileFilter filter) {
        this.chooser.setFileFilter(filter);
    }

    public void setExtensionFileFilter(ExtensionFileFilter filter) {
        this.chooser.setFileFilter(filter);
    }

    public void saveAs() {
        this.fireSave(new SaveEvent(this, 0, ""));
        int returnVal = this.chooser.showSaveDialog(this.applFrame);
        this.dirName = this.chooser.getCurrentDirectory().toString();
        if (returnVal == 0) {
            if (this.chooser.getSelectedFile() != null && !this.chooser.getSelectedFile().getName().equals("")) {
                this.fileName = this.chooser.getSelectedFile().getName();
                this.save();
            } else {
                this.fireSave(new SaveEvent(this, 3, ""));
            }
        } else {
            this.fireSave(new SaveEvent(this, 3, ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void save() {
        block21: {
            if (this.gra == null) {
                this.fireSave(new SaveEvent(this, -1, "GraGra object is null"));
                return;
            }
            this.fireSave(new SaveEvent(this, 0, ""));
            if (this.dirName.equals("")) {
                this.dirName = System.getProperty("user.dir");
            }
            if (!this.dirName.endsWith(File.separator)) {
                this.dirName = this.dirName + File.separator;
            }
            if (this.fileName.equals("")) {
                this.saveAs();
            } else {
                int key;
                FileOutputStream fos;
                block20: {
                    if (this.chooser.getFileFilter() == this.filterXML) {
                        if (!this.fileName.endsWith(".ggx")) {
                            this.fileName = this.fileName.concat(".ggx");
                        }
                        if (this.fileName.endsWith(".ggx")) {
                            XMLHelper xmlh = new XMLHelper();
                            xmlh.addTopObject(this.gra);
                            xmlh.save_to_xml(this.dirName + this.fileName);
                            this.gra.setDirName(this.dirName);
                            this.gra.setFileName(this.fileName);
                            this.gra.getTypeSet().setResourcesPath(this.dirName);
                            this.gra.setChanged(false);
                            this.fireSave(new SaveEvent(this, 6, this.dirName + this.fileName));
                            return;
                        }
                    } else if (this.chooser.getFileFilter() == this.filterAGG && !this.fileName.endsWith(".agg")) {
                        this.fileName = this.fileName.concat(".agg");
                    }
                    this.fireSave(new SaveEvent(this, 1, this.bar.getContentPanel(), ""));
                    this.bar.start();
                    File f = new File(this.dirName + this.fileName);
                    fos = null;
                    ObjectOutputStream oos = null;
                    key = -1;
                    fos = new FileOutputStream(f);
                    oos = new ObjectOutputStream(fos);
                    this.gra.setDirName(this.dirName);
                    this.gra.setFileName(this.fileName);
                    this.gra.getTypeSet().setResourcesPath(this.dirName);
                    oos.writeObject(this.gra);
                    oos.flush();
                    Object var7_6 = null;
                    if (fos == null) break block20;
                    this.addMsg = "";
                    try {
                        fos.close();
                        this.gra.setDirName(this.dirName);
                        this.gra.setFileName(this.fileName);
                        key = 6;
                    }
                    catch (IOException ex) {
                        this.gra.setDirName("");
                        this.gra.setFileName("");
                        key = 5;
                    }
                }
                this.fireSave(new SaveEvent(this, 2, this.bar.getContentPanel(), ""));
                this.fireSave(new SaveEvent(this, key, this.dirName + this.fileName, this.addMsg));
                this.bar.finish();
                this.bar.quit();
                {
                    break block21;
                    catch (IOException iox) {
                        this.gra.setDirName("");
                        this.gra.setFileName("");
                        key = 4;
                        this.addMsg = iox.getMessage() == null ? "" : iox.getLocalizedMessage();
                        Object var7_7 = null;
                        if (fos != null) {
                            this.addMsg = "";
                            try {
                                fos.close();
                                this.gra.setDirName(this.dirName);
                                this.gra.setFileName(this.fileName);
                                key = 6;
                            }
                            catch (IOException ex) {
                                this.gra.setDirName("");
                                this.gra.setFileName("");
                                key = 5;
                            }
                        }
                        this.fireSave(new SaveEvent(this, 2, this.bar.getContentPanel(), ""));
                        this.fireSave(new SaveEvent(this, key, this.dirName + this.fileName, this.addMsg));
                        this.bar.finish();
                        this.bar.quit();
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (fos != null) {
                        this.addMsg = "";
                        try {
                            fos.close();
                            this.gra.setDirName(this.dirName);
                            this.gra.setFileName(this.fileName);
                            key = 6;
                        }
                        catch (IOException ex) {
                            this.gra.setDirName("");
                            this.gra.setFileName("");
                            key = 5;
                        }
                    }
                    this.fireSave(new SaveEvent(this, 2, this.bar.getContentPanel(), ""));
                    this.fireSave(new SaveEvent(this, key, this.dirName + this.fileName, this.addMsg));
                    this.bar.finish();
                    this.bar.quit();
                    throw throwable;
                }
            }
        }
    }

    public void saveAsBase() {
        this.fireSave(new SaveEvent(this, 0, ""));
        int returnVal = this.chooser.showSaveDialog(this.applFrame);
        this.dirName = this.chooser.getCurrentDirectory().toString();
        if (returnVal == 0) {
            if (this.chooser.getSelectedFile() != null && !this.chooser.getSelectedFile().getName().equals("")) {
                this.fileName = this.chooser.getSelectedFile().getName();
                this.saveBase();
            } else {
                this.fireSave(new SaveEvent(this, 3, ""));
            }
        } else {
            this.fireSave(new SaveEvent(this, 3, ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void saveBase() {
        block21: {
            if (this.basis == null) {
                return;
            }
            if (this.dirName.equals("")) {
                this.dirName = System.getProperty("user.dir");
            }
            if (!this.dirName.endsWith(File.separator)) {
                this.dirName = this.dirName + File.separator;
            }
            if (this.fileName.equals("")) {
                this.saveAsBase();
            } else {
                int key;
                FileOutputStream fos;
                block20: {
                    if (this.chooser.getFileFilter() == this.filterXML) {
                        if (!this.fileName.endsWith(".ggx")) {
                            this.fileName = this.fileName.concat(".ggx");
                        }
                        if (this.fileName.endsWith(".ggx")) {
                            XMLHelper xmlh = new XMLHelper();
                            xmlh.addTopObject(this.basis);
                            xmlh.save_to_xml(this.dirName + this.fileName);
                            this.fireSave(new SaveEvent(this, 6, this.dirName + this.fileName));
                            return;
                        }
                    } else if (this.chooser.getFileFilter() == this.filterAGG && !this.fileName.endsWith(".agg")) {
                        this.fileName = this.fileName.concat(".agg");
                    }
                    this.fireSave(new SaveEvent(this, 1, this.bar.getContentPanel(), ""));
                    this.bar.start();
                    File f = new File(this.dirName + this.fileName);
                    fos = null;
                    ObjectOutputStream oos = null;
                    key = -1;
                    fos = new FileOutputStream(f);
                    oos = new ObjectOutputStream(fos);
                    oos.writeObject(this.basis);
                    oos.flush();
                    Object var7_6 = null;
                    if (fos == null) break block20;
                    this.addMsg = "";
                    try {
                        fos.close();
                        key = 6;
                    }
                    catch (IOException ex) {
                        key = 5;
                    }
                }
                this.fireSave(new SaveEvent(this, 2, this.bar.getContentPanel(), ""));
                this.fireSave(new SaveEvent(this, key, this.dirName + this.fileName, this.addMsg));
                this.bar.finish();
                this.bar.quit();
                {
                    break block21;
                    catch (IOException iox) {
                        key = 4;
                        this.addMsg = iox.getMessage() == null ? "" : iox.getLocalizedMessage();
                        Object var7_7 = null;
                        if (fos != null) {
                            this.addMsg = "";
                            try {
                                fos.close();
                                key = 6;
                            }
                            catch (IOException ex) {
                                key = 5;
                            }
                        }
                        this.fireSave(new SaveEvent(this, 2, this.bar.getContentPanel(), ""));
                        this.fireSave(new SaveEvent(this, key, this.dirName + this.fileName, this.addMsg));
                        this.bar.finish();
                        this.bar.quit();
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (fos != null) {
                        this.addMsg = "";
                        try {
                            fos.close();
                            key = 6;
                        }
                        catch (IOException ex) {
                            key = 5;
                        }
                    }
                    this.fireSave(new SaveEvent(this, 2, this.bar.getContentPanel(), ""));
                    this.fireSave(new SaveEvent(this, key, this.dirName + this.fileName, this.addMsg));
                    this.bar.finish();
                    this.bar.quit();
                    throw throwable;
                }
            }
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setDirName(String directory) {
        if (!directory.equals("")) {
            this.dirName = directory;
            this.chooser = new JFileChooser(this.dirName);
            this.filterXML = new AGGFileFilter("ggx", "AGG Files XML (.ggx)");
            this.chooser.addChoosableFileFilter(this.filterXML);
            this.chooser.setFileFilter(this.filterXML);
        }
    }

    public void setGraGra(EdGraGra gragra) {
        this.gra = gragra;
    }

    public void setGraGra(EdGraGra gragra, String dirname, String filename) {
        this.gra = gragra;
        if (dirname != null && !dirname.equals("")) {
            this.dirName = dirname;
        }
        this.fileName = filename;
    }

    public void setBaseGraGra(GraGra gragra) {
        this.basis = gragra;
    }

    public void setBaseGraGra(GraGra gragra, String dirname, String filename) {
        this.basis = gragra;
        if (dirname != null && !dirname.equals("")) {
            this.dirName = dirname;
        }
        this.dirName = dirname;
        this.fileName = filename;
    }

    public EdGraGra getGraGra() {
        return this.gra;
    }

    public GraGra getBaseGraGra() {
        return this.basis;
    }

    public void setFrame(JFrame f) {
        this.applFrame = f;
        if (this.bar != null) {
            this.bar.setFrame(f);
        }
    }

    public synchronized void addSaveEventListener(SaveEventListener l) {
        Vector v;
        Vector vector = v = this.saveListeners == null ? new Vector(2) : (Vector)this.saveListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.saveListeners = v;
        }
    }

    public synchronized void removeSaveEventListener(SaveEventListener l) {
        if (this.saveListeners != null && this.saveListeners.contains(l)) {
            Vector v = (Vector)this.saveListeners.clone();
            v.removeElement(l);
            this.saveListeners = v;
        }
    }

    private void fireSave(SaveEvent e) {
        if (this.saveListeners != null) {
            Vector listeners = this.saveListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((SaveEventListener)listeners.elementAt(i)).saveEventOccurred(e);
            }
        }
    }

    private ProgressBar createProgressBar() {
        ProgressBar bar = new ProgressBar("Save");
        bar.setFrame(this.applFrame);
        bar.setLabel("Saving File ...");
        bar.setFinishText("Saving  done");
        bar.setToolTipText("Save Status");
        bar.setFinishAppend(false);
        LoadSaveStatus.setMaximum(1000);
        return bar;
    }
}

