/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.attribute.gui.AttrTupleEditor;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdRule;
import agg.gui.GraGraEditor;
import agg.gui.GraTraOptionGUI;
import agg.gui.TransformDebug;
import agg.gui.TransformInterpret;
import agg.gui.TransformLayered;
import agg.gui.event.TransformEvent;
import agg.gui.event.TransformEventListener;
import agg.xt_basis.CompletionPropertyBits;
import agg.xt_basis.CompletionStrategySelector;
import agg.xt_basis.GraTraOptions;
import agg.xt_basis.MorphCompletionStrategy;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.JMenu;

public class GraGraTransform {
    private GraTraOptionGUI optionGUI;
    private MorphCompletionStrategy strategy;
    private TransformDebug debugger;
    private TransformInterpret interpreter;
    private GraGraEditor editor;
    private AttrTupleEditor inputParameterEditor;
    private int priority;
    private JMenu transform;
    private Vector transformListeners;
    private TransformEvent event;
    private TransformLayered layeredTransform;

    public GraGraTransform(GraGraEditor anEditor) {
        this.editor = anEditor;
        this.priority = 3;
        this.optionGUI = new GraTraOptionGUI(this);
        this.strategy = this.optionGUI.getMorphCompletioStrategy();
        this.debugger = new TransformDebug(this);
        this.debugger.setCompletionStrategy(this.strategy);
        this.editor.addEditEventListener(this.debugger);
    }

    public GraTraOptionGUI getOptionGUI() {
        return this.optionGUI;
    }

    public MorphCompletionStrategy getStrategy() {
        return this.strategy;
    }

    public boolean layeredEnabled() {
        return this.optionGUI.layeredEnabled();
    }

    public boolean consistencyEnabled() {
        return this.optionGUI.consistencyEnabled();
    }

    public boolean showLayerEnabled() {
        return this.optionGUI.showLayerEnabled();
    }

    public boolean stopLayerEnabled() {
        return this.optionGUI.stopLayerEnabled();
    }

    public boolean showGraphAfterStepEnabled() {
        return this.optionGUI.showGraphAfterStepEnabled();
    }

    public boolean waitAfterStepEnabled() {
        return this.optionGUI.waitAfterStepEnabled();
    }

    public boolean checkRuleApplicabilityEnabled() {
        return this.optionGUI.checkRuleApplicabilityEnabled();
    }

    public boolean selectNewAfterStepEnabled() {
        return this.optionGUI.selectNewAfterStepEnabled();
    }

    public boolean layeredLoopEnabled() {
        return this.optionGUI.layeredLoopEnabled();
    }

    public void setCompletionStrategy(MorphCompletionStrategy strat) {
        this.strategy = strat;
        this.debugger.setCompletionStrategy(strat);
        if (this.debugger.getMatch() != null) {
            this.debugger.getMatch().setCompletionStrategy(strat);
        }
        this.editor.getGraGra().getBasisGraGra().setGraTraOptions(strat);
    }

    public Vector getGraTraOptionsList() {
        GraTraOptions gratraOptions = new GraTraOptions();
        gratraOptions.addOption(CompletionStrategySelector.getName(this.strategy));
        BitSet activebits = this.strategy.getProperties();
        for (int i = 0; i < CompletionPropertyBits.BITNAME.length; ++i) {
            if (!activebits.get(i)) continue;
            String bitName = CompletionPropertyBits.BITNAME[i];
            gratraOptions.addOption(bitName);
        }
        if (this.optionGUI.consistencyEnabled()) {
            gratraOptions.addOption("consistency");
        }
        if (this.optionGUI.layeredEnabled()) {
            gratraOptions.addOption("layered");
        }
        if (this.optionGUI.stopLayerEnabled()) {
            gratraOptions.addOption("stopLayer");
        }
        if (this.optionGUI.layeredLoopEnabled()) {
            gratraOptions.addOption("layeredLoop");
        }
        if (this.optionGUI.checkRuleApplicabilityEnabled()) {
            gratraOptions.addOption("checkRuleApplicability");
        }
        if (this.optionGUI.showGraphAfterStepEnabled()) {
            gratraOptions.addOption("showGraphAfterStep");
        }
        return gratraOptions.getOptions();
    }

    public GraTraOptions getGraTraOptions() {
        GraTraOptions gratraOptions = new GraTraOptions();
        gratraOptions.addOption(CompletionStrategySelector.getName(this.strategy));
        BitSet activebits = this.strategy.getProperties();
        for (int i = 0; i < CompletionPropertyBits.BITNAME.length; ++i) {
            if (!activebits.get(i)) continue;
            String bitName = CompletionPropertyBits.BITNAME[i];
            gratraOptions.addOption(bitName);
        }
        if (this.optionGUI.consistencyEnabled()) {
            gratraOptions.addOption("consistency");
        }
        if (this.optionGUI.layeredEnabled()) {
            gratraOptions.addOption("layered");
        }
        if (this.optionGUI.stopLayerEnabled()) {
            gratraOptions.addOption("stopLayer");
        }
        if (this.optionGUI.layeredLoopEnabled()) {
            gratraOptions.addOption("layeredLoop");
        }
        if (this.optionGUI.checkRuleApplicabilityEnabled()) {
            gratraOptions.addOption("checkRuleApplicability");
        }
        if (this.optionGUI.showGraphAfterStepEnabled()) {
            gratraOptions.addOption("showGraphAfterStep");
        }
        return gratraOptions;
    }

    public void updateGraTraOption(String opt, boolean b) {
        if (this.editor.getGraGra() == null) {
            return;
        }
        if (b) {
            this.editor.getGraGra().getBasisGraGra().addGraTraOption(opt);
        } else {
            this.editor.getGraGra().getBasisGraGra().removeGraTraOption(opt);
        }
    }

    public void updateGraTraOptionGUI(Vector optionsList) {
        this.optionGUI.update(optionsList);
    }

    public void setPriority(int prior) {
        this.priority = prior;
    }

    public TransformDebug getTransformDebugger() {
        return this.debugger;
    }

    public TransformInterpret createTransformInterpreter() {
        this.interpreter = new TransformInterpret(this);
        return this.interpreter;
    }

    public TransformLayered createTransformLayered() {
        this.layeredTransform = new TransformLayered(this);
        return this.layeredTransform;
    }

    public void startTransformInterpreter(EdGraGra gragra) {
        this.editor.removeEditEventListener(this.debugger);
        this.editor.addEditEventListener(this.interpreter);
        this.editor.setInterpreting(true);
        this.editor.setLayering(false);
        this.interpreter.setGraGra(gragra);
        this.interpreter.setCompletionStrategy(this.strategy);
        this.interpreter.setPriority(this.priority);
        this.interpreter.setShowGraphAfterStep(this.showGraphAfterStepEnabled());
        this.interpreter.start();
    }

    public void startTransformLayered(EdGraGra gragra) {
        this.editor.removeEditEventListener(this.debugger);
        this.editor.addEditEventListener(this.layeredTransform);
        this.editor.setInterpreting(false);
        this.editor.setLayering(true);
        this.layeredTransform.setGraGra(gragra);
        this.layeredTransform.setCompletionStrategy(this.strategy);
        this.layeredTransform.setPriority(this.priority);
        this.layeredTransform.setShowGraphAfterStep(this.showGraphAfterStepEnabled());
        this.layeredTransform.start();
    }

    public void stopTransformInterpreter() {
        this.interpreter.stopping();
    }

    public void stopTransformLayered() {
        this.layeredTransform.stopping();
    }

    public void changeFromTransformLayeredToTransformInterpreter() {
        this.stopTransformLayered();
        this.editor.startTransformInterpreter();
    }

    public Vector getApplicableRules(EdGraGra gragra) {
        return this.debugger.getApplicableRules(gragra);
    }

    public Vector getApplicableRules(EdGraGra gragra, boolean applicable) {
        return this.debugger.getApplicableRules(gragra, applicable);
    }

    public void matchDef(EdRule rule) {
        this.debugger.setRule(rule);
        this.debugger.matchDef();
    }

    public void destroyMatch() {
        this.debugger.destroyMatch();
    }

    public void nextCompletion(EdRule rule) {
        this.debugger.setRule(rule);
        this.debugger.nextCompletion();
    }

    public void step(EdRule rule) {
        this.debugger.setRule(rule);
        this.debugger.step();
    }

    public synchronized void addTransformEventListener(TransformEventListener l) {
        Vector v;
        Vector vector = v = this.transformListeners == null ? new Vector(2) : (Vector)this.transformListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.transformListeners = v;
        }
    }

    public synchronized void removeTransformEventListener(TransformEventListener l) {
        if (this.transformListeners != null && this.transformListeners.contains(l)) {
            Vector v = (Vector)this.transformListeners.clone();
            v.removeElement(l);
            this.transformListeners = v;
        }
    }

    public void fireTransform(TransformEvent e) {
        this.event = e;
        if (this.transformListeners != null) {
            Vector listeners = this.transformListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((TransformEventListener)listeners.elementAt(i)).transformEventOccurred(e);
            }
        }
    }
}

