/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.gui.GraGraTreeNodeData;
import agg.gui.IconResource;
import agg.gui.icons.NewConclusionIcon;
import agg.xt_basis.Rule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class GraGraTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected boolean selected;
    protected boolean notApplicable;
    protected boolean isTrigger = false;
    protected static final Color SelectedBackgroundColor = new Color(153, 153, 255);
    protected static final Color NotApplicableBackgroundColor = Color.LIGHT_GRAY;
    protected static final Color TriggerRuleBackgroundColor = Color.RED;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        this.setText(stringValue);
        this.setIconTextGap(5);
        GraGraTreeNodeData userObject = (GraGraTreeNodeData)((DefaultMutableTreeNode)value).getUserObject();
        this.notApplicable = false;
        this.isTrigger = false;
        if (userObject.isGraGra) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLGraGra()));
            if (!userObject.getGraGra().getFileName().equals("")) {
                if (userObject.getGraGra().getDirName().indexOf(File.separator) != -1) {
                    this.setToolTipText("  " + userObject.getGraGra().getDirName() + userObject.getGraGra().getFileName() + "  ");
                } else {
                    this.setToolTipText("  " + userObject.getGraGra().getDirName() + File.separator + userObject.getGraGra().getFileName() + "  ");
                }
            } else {
                this.setToolTipText(" Graph grammar ");
            }
        } else if (userObject.isTypeGraph) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLTypeGraph()));
            this.setToolTipText(" Type graph with connections of types ");
        } else if (userObject.isGraph) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLGraph()));
            this.setToolTipText(" Host graph ");
        } else if (userObject.isRule) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLRule()));
            this.notApplicable = !userObject.getRule().isApplicable();
            Rule r = userObject.getRule().getBasisRule();
            this.isTrigger = r.isTriggerOfLayer();
            String tipStr = "";
            tipStr = this.notApplicable ? " Rule isn't applicable " : (this.isTrigger ? " Trigger rule of layer " + r.getLayer() + " " : " Rule ");
            if (tipStr != "") {
                this.setToolTipText(tipStr);
            } else {
                this.setToolTipText("");
            }
        } else if (userObject.isNAC) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLNAC()));
            this.setToolTipText(" Negative Application Condition ");
            this.notApplicable = !userObject.getNAC().getRule().isApplicable();
        } else if (userObject.isAttrCondition) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLAttrCondition()));
            this.setToolTipText(" Attribute condition ");
        } else if (userObject.isAtomic) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLAtomic()));
            this.setToolTipText(" Atomic graph constraint ");
        } else if (userObject.isConclusion) {
            NewConclusionIcon icon = new NewConclusionIcon(Color.blue);
            icon.setEnabled(true);
            this.setIcon(icon);
            this.setToolTipText(" Conclusion of atomic graph constraint ");
        } else if (userObject.isConstraint) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLConstraint()));
            this.setToolTipText(" Constraint : " + userObject.getConstraint().getAsString() + " ");
        } else if (userObject.isRuleConstraint) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLPost()));
            this.setToolTipText(" Post Application Condition ");
            this.notApplicable = !userObject.getRuleConstraint().getRule().isApplicable();
        } else if (userObject.isAtomApplCond) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLAtomConstr()));
            this.setToolTipText(" Atomic application condition ");
            this.notApplicable = !userObject.getAtomApplCond().getRule().isApplicable();
        } else {
            this.setIcon(null);
            this.setToolTipText("");
        }
        this.selected = selected;
        return this;
    }

    public void paint(Graphics g) {
        Color bColor = Color.WHITE;
        Color fColor = Color.BLACK;
        Icon currentI = this.getIcon();
        if (this.selected) {
            bColor = SelectedBackgroundColor;
        } else if (this.notApplicable) {
            fColor = NotApplicableBackgroundColor;
        } else if (this.isTrigger) {
            fColor = TriggerRuleBackgroundColor;
        } else {
            bColor = this.getParent() != null ? this.getParent().getBackground() : this.getBackground();
        }
        g.setColor(bColor);
        this.setForeground(fColor);
        if (currentI != null && this.getText() != null) {
            int offset = currentI.getIconWidth() + this.getIconTextGap();
            g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
        } else {
            g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        super.paint(g);
    }
}

