/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdConstraint;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdRule;
import agg.gui.GraGraTreeNodeData;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GraGraTreeModel
extends DefaultTreeModel {
    private JFrame applFrame;

    public GraGraTreeModel(TreeNode newRoot) {
        super(newRoot);
    }

    public GraGraTreeModel(JFrame frame, TreeNode newRoot) {
        super(newRoot);
        this.applFrame = frame;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        GraGraTreeNodeData data;
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (this.checkNewValue(aNode, data = (GraGraTreeNodeData)aNode.getUserObject(), (String)newValue)) {
            data.setString((String)newValue);
            this.nodeChanged(aNode);
        }
    }

    private boolean checkNewValue(DefaultMutableTreeNode aNode, GraGraTreeNodeData sd, String name) {
        if (sd.isGraGra) {
            if (!this.isValid(this.getGraGraNames(), name, sd.toString())) {
                this.warning(this.applFrame, name);
                return false;
            }
            return true;
        }
        if (sd.isGraph) {
            EdGraGra egra = this.getGraGra(aNode);
            if (!this.isValid(this.getGraGraChildrenNames(egra), name, sd.toString())) {
                this.warning(this.applFrame, name);
                return false;
            }
            return true;
        }
        if (sd.isRule) {
            EdGraGra egra = this.getGraGra(aNode);
            if (!this.isValid(this.getGraGraChildrenNames(egra), name, sd.toString())) {
                this.warning(this.applFrame, name);
                return false;
            }
            return true;
        }
        if (sd.isNAC) {
            EdRule erule = this.getRule(aNode);
            if (!this.isValid(this.getRuleChildrenNames(erule), name, sd.toString())) {
                this.warning(this.applFrame, name);
                return false;
            }
            return true;
        }
        return true;
    }

    public DefaultMutableTreeNode getTreeNodeOfGraGraChild(DefaultMutableTreeNode gragraNode, Object searchedObj) {
        if (!(searchedObj instanceof EdRule)) {
            return null;
        }
        for (int j = 0; j < gragraNode.getChildCount(); ++j) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)gragraNode.getChildAt(j);
            GraGraTreeNodeData sd = (GraGraTreeNodeData)node.getUserObject();
            if (sd.isTypeGraph && searchedObj instanceof EdGraph && sd.getGraph().equals((EdGraph)searchedObj)) {
                return node;
            }
            if (sd.isGraph && searchedObj instanceof EdGraph && sd.getGraph().equals((EdGraph)searchedObj)) {
                return node;
            }
            if (sd.isRule && searchedObj instanceof EdRule && sd.getRule().equals((EdRule)searchedObj)) {
                return node;
            }
            if (sd.isAtomic && searchedObj instanceof EdAtomic && sd.getAtomic().equals((EdAtomic)searchedObj)) {
                return node;
            }
            if (!sd.isConstraint || !(searchedObj instanceof EdConstraint) || !sd.getConstraint().equals((EdConstraint)searchedObj)) continue;
            return node;
        }
        return null;
    }

    public boolean isValid(Vector names, String newName, String oldName) {
        for (int i = 0; i < names.size(); ++i) {
            if (((String)names.elementAt(i)).equals(oldName) || !((String)names.elementAt(i)).equals(newName)) continue;
            return false;
        }
        return true;
    }

    public void ruleNameChanged(EdGraGra gragra, boolean layered) {
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            GraGraTreeNodeData sdGra = (GraGraTreeNodeData)node.getUserObject();
            if (!sdGra.getGraGra().equals(gragra)) continue;
            for (int j = 0; j < node.getChildCount(); ++j) {
                DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)node.getChildAt(j);
                GraGraTreeNodeData sd = (GraGraTreeNodeData)node1.getUserObject();
                if (!sd.isRule) continue;
                String tag = "";
                String tag1 = "";
                if (!sd.getRule().getBasisRule().isEnabled()) {
                    tag = "[D]";
                }
                if (layered) {
                    tag1 = "[" + sd.getRule().getBasisRule().getLayer() + "]";
                }
                sd.setString(tag, tag1, sd.getRule().getBasisRule().getName());
                this.nodeChanged(node1);
            }
            break;
        }
    }

    public void ruleNameChanged(DefaultMutableTreeNode ruleNode, boolean layered) {
        GraGraTreeNodeData sd = (GraGraTreeNodeData)ruleNode.getUserObject();
        if (sd.isRule) {
            String tag = "";
            String tag1 = "";
            if (!sd.getRule().getBasisRule().isEnabled()) {
                tag = "[D]";
            }
            if (layered) {
                tag1 = "[" + sd.getRule().getBasisRule().getLayer() + "]";
            }
            sd.setString(tag, tag1, sd.getRule().getBasisRule().getName());
            this.nodeChanged(ruleNode);
        }
    }

    public void constraintNameChanged(EdGraGra gragra, boolean layered) {
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            GraGraTreeNodeData sdGra = (GraGraTreeNodeData)node.getUserObject();
            if (!sdGra.getGraGra().equals(gragra)) continue;
            for (int j = 0; j < node.getChildCount(); ++j) {
                DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)node.getChildAt(j);
                GraGraTreeNodeData sd = (GraGraTreeNodeData)node1.getUserObject();
                if (!sd.isConstraint) continue;
                String tag = "";
                Vector layer = sd.getConstraint().getBasisConstraint().getLayer();
                if (layered && !layer.isEmpty()) {
                    tag = "[" + sd.getConstraint().getBasisConstraint().getLayerAsString() + "]";
                }
                sd.setString(tag, sd.getConstraint().getBasisConstraint().getName());
                this.nodeChanged(node1);
            }
            break;
        }
    }

    public void constraintNameChanged(DefaultMutableTreeNode node, boolean layered) {
        GraGraTreeNodeData sd = (GraGraTreeNodeData)node.getUserObject();
        if (sd.isConstraint) {
            String tag = "";
            Vector layer = sd.getConstraint().getBasisConstraint().getLayer();
            if (layered && !layer.isEmpty()) {
                tag = "[" + sd.getConstraint().getBasisConstraint().getLayerAsString() + "]";
            }
            sd.setString(tag, sd.getConstraint().getBasisConstraint().getName());
            this.nodeChanged(node);
        }
    }

    private void warning(JFrame fr, String str) {
        JOptionPane.showMessageDialog(fr, "Name  \"" + str + "\"  exists.", "Warning", 2);
    }

    public Vector getGraGraNames() {
        Vector<String> gragraNames = new Vector<String>();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            gragraNames.addElement(((DefaultMutableTreeNode)this.root.getChildAt(i)).toString());
        }
        return gragraNames;
    }

    public Vector getGraGraChildrenNames(EdGraGra eGra) {
        Vector<String> gragraChildrenNames = new Vector<String>();
        gragraChildrenNames.addElement(eGra.getGraph().getBasisGraph().getName());
        for (int i = 0; i < eGra.getRules().size(); ++i) {
            if ((EdRule)eGra.getRules().elementAt(i) == null) continue;
            EdRule er = (EdRule)eGra.getRules().elementAt(i);
            gragraChildrenNames.addElement(er.getBasisRule().getName());
            for (int j = 0; j < er.getNACs().size(); ++j) {
                EdNAC enac = (EdNAC)er.getNACs().elementAt(j);
                gragraChildrenNames.addElement(enac.getBasisGraph().getName());
            }
        }
        return gragraChildrenNames;
    }

    private Vector getRuleChildrenNames(EdRule eRule) {
        Vector<String> ruleChildrenNames = new Vector<String>();
        for (int i = 0; i < eRule.getNACs().size(); ++i) {
            ruleChildrenNames.addElement(((EdNAC)eRule.getNACs().elementAt(i)).getBasisGraph().getName());
        }
        return ruleChildrenNames;
    }

    private Vector getAllNames() {
        Vector<String> allNames = new Vector<String>();
        allNames.addElement(((DefaultMutableTreeNode)this.root).toString());
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            allNames.addElement(node.toString());
            for (int j = 0; j < node.getChildCount(); ++j) {
                DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)node.getChildAt(j);
                allNames.addElement(node1.toString());
                if (node1.isLeaf()) continue;
                int k = 0;
                while (j < node1.getChildCount()) {
                    DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)node1.getChildAt(k);
                    allNames.addElement(node2.toString());
                    ++k;
                }
            }
        }
        return allNames;
    }

    private EdGraGra getGraGra(DefaultMutableTreeNode aNode) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)aNode.getParent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)parent.getUserObject();
        if (data.isGraGra) {
            return data.getGraGra();
        }
        return null;
    }

    private EdRule getRule(DefaultMutableTreeNode aNode) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)aNode.getParent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)parent.getUserObject();
        if (data.isRule) {
            return data.getRule();
        }
        return null;
    }
}

