/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.attribute.impl.CondMember;
import agg.editor.impl.EdAtomApplCond;
import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdConstraint;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdRuleConstraint;
import com.objectspace.jgl.Pair;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class GraGraTreeNodeData {
    public boolean isGraGra = false;
    public boolean isGraph = false;
    public boolean isRule = false;
    public boolean isNAC = false;
    public boolean isAttrCondition = false;
    public boolean isStop = false;
    public boolean isAtomic = false;
    public boolean isConclusion = false;
    public boolean isConstraint = false;
    public boolean isRuleConstraint = false;
    public boolean isAtomApplCond = false;
    public boolean isTypeGraph = false;
    private String eGras = "";
    private EdGraGra eGra;
    private EdGraph eGraph;
    private EdRule eRule;
    private EdNAC eNAC;
    private Pair attrCondition;
    private EdAtomic eAtomic;
    private EdConstraint eConstraint;
    private EdRuleConstraint eRuleConstraint;
    private EdAtomApplCond eAtomApplCond;
    private String string = "";
    private DefaultMutableTreeNode treeNode;

    public GraGraTreeNodeData(String name, boolean isRoot) {
        this.string = name;
        if (isRoot) {
            this.eGras = name;
        }
    }

    public GraGraTreeNodeData(EdGraGra gra) {
        this.string = gra.getName();
        this.eGra = gra;
        this.isGraGra = true;
    }

    public GraGraTreeNodeData(EdGraph graph) {
        this.string = graph.getBasisGraph().getName();
        this.eGraph = graph;
        this.isGraph = true;
    }

    public GraGraTreeNodeData(EdGraph graph, boolean isTypeGraph) {
        this.string = graph.getBasisGraph().getName();
        this.eGraph = graph;
        this.isTypeGraph = isTypeGraph;
        this.isGraph = true;
    }

    public GraGraTreeNodeData(EdRule rule) {
        this.string = !rule.getBasisRule().isEnabled() ? "[D]" + rule.getBasisRule().getName() : rule.getBasisRule().getName();
        this.eRule = rule;
        this.isRule = true;
    }

    public GraGraTreeNodeData(EdAtomic a) {
        this.string = a.getBasisAtomic().getAtomicName();
        this.isAtomic = true;
        this.eAtomic = a;
    }

    public GraGraTreeNodeData(EdAtomic a, boolean conclusion) {
        if (conclusion) {
            this.string = a.getBasisAtomic().getName();
            this.isConclusion = true;
        } else {
            this.string = a.getBasisAtomic().getAtomicName();
            this.isAtomic = true;
        }
        this.eAtomic = a;
    }

    public GraGraTreeNodeData(EdConstraint c) {
        this.string = c.getName();
        this.eConstraint = c;
        this.isConstraint = true;
    }

    public GraGraTreeNodeData(EdNAC nac) {
        this.string = nac.getBasisGraph().getName();
        this.eNAC = nac;
        this.eNAC.setName(this.string);
        this.isNAC = true;
    }

    public GraGraTreeNodeData(CondMember attrCond, EdRule rule) {
        this.string = attrCond.getExprAsText();
        this.attrCondition = new Pair(attrCond, rule);
        this.isAttrCondition = true;
    }

    public GraGraTreeNodeData(CondMember attrCond, EdAtomic conclusion) {
        this.string = attrCond.getExprAsText();
        this.attrCondition = new Pair(attrCond, conclusion);
        this.isAttrCondition = true;
    }

    public GraGraTreeNodeData(EdRuleConstraint ruleConstr) {
        this.string = "RuleConstraint";
        this.eRuleConstraint = ruleConstr;
        this.isRuleConstraint = true;
    }

    public GraGraTreeNodeData(EdAtomApplCond cond) {
        this.string = "AtomApplCond";
        this.eAtomApplCond = cond;
        this.isAtomApplCond = true;
    }

    public GraGraTreeNodeData(String s) {
        this.string = s;
        this.eRule = null;
        this.isStop = true;
    }

    public GraGraTreeNodeData(Object obj) {
        if (obj instanceof EdGraGra) {
            new GraGraTreeNodeData((EdGraGra)obj);
        } else if (obj instanceof EdGraph) {
            new GraGraTreeNodeData((EdGraph)obj);
        } else if (obj instanceof EdRule) {
            new GraGraTreeNodeData((EdRule)obj);
        } else if (obj instanceof EdAtomic) {
            new GraGraTreeNodeData((EdAtomic)obj);
        } else if (obj instanceof EdConstraint) {
            new GraGraTreeNodeData((EdConstraint)obj);
        } else if (obj instanceof EdNAC) {
            new GraGraTreeNodeData((EdNAC)obj);
        } else if (obj instanceof Pair) {
            new GraGraTreeNodeData((Pair)obj);
        } else if (obj instanceof EdRuleConstraint) {
            new GraGraTreeNodeData((EdRuleConstraint)obj);
        } else if (obj instanceof EdAtomApplCond) {
            new GraGraTreeNodeData((EdAtomApplCond)obj);
        } else if (obj instanceof String) {
            new GraGraTreeNodeData((String)obj);
        } else {
            this.eGra = null;
            this.isGraGra = false;
            this.eGraph = null;
            this.isGraph = false;
            this.isTypeGraph = false;
            this.eRule = null;
            this.isRule = false;
            this.isStop = false;
            this.eNAC = null;
            this.isNAC = false;
            this.eAtomic = null;
            this.isAtomic = false;
            this.isConclusion = false;
            this.eConstraint = null;
            this.isConstraint = false;
            this.eRuleConstraint = null;
            this.isRuleConstraint = false;
            this.eAtomApplCond = null;
            this.isAtomApplCond = false;
            this.string = "";
        }
    }

    public void setData(Object obj) {
        if (obj instanceof EdGraGra) {
            this.eGra = (EdGraGra)obj;
        } else if (obj instanceof EdGraph) {
            this.eGraph = (EdGraph)obj;
        } else if (obj instanceof EdRule) {
            this.eRule = (EdRule)obj;
        } else if (obj instanceof EdAtomic) {
            this.eAtomic = (EdAtomic)obj;
        } else if (obj instanceof EdConstraint) {
            this.eConstraint = (EdConstraint)obj;
        } else if (obj instanceof EdNAC) {
            this.eNAC = (EdNAC)obj;
        } else if (obj instanceof Pair) {
            this.attrCondition = (Pair)obj;
        } else if (obj instanceof EdRuleConstraint) {
            this.eRuleConstraint = (EdRuleConstraint)obj;
        } else if (obj instanceof EdAtomApplCond) {
            this.eAtomApplCond = (EdAtomApplCond)obj;
        } else if (obj instanceof String) {
            this.string = (String)obj;
        } else {
            this.eGra = null;
            this.isGraGra = false;
            this.eGraph = null;
            this.isGraph = false;
            this.isTypeGraph = false;
            this.eRule = null;
            this.isRule = false;
            this.isStop = false;
            this.eNAC = null;
            this.isNAC = false;
            this.attrCondition = null;
            this.isAttrCondition = false;
            this.eAtomic = null;
            this.isAtomic = false;
            this.isConclusion = false;
            this.eConstraint = null;
            this.isConstraint = false;
            this.eRuleConstraint = null;
            this.isRuleConstraint = false;
            this.eAtomApplCond = null;
            this.isAtomApplCond = false;
            this.string = "";
        }
    }

    public void setString(String str) {
        String newString;
        if (str == null) {
            return;
        }
        String oldString = this.string;
        this.string = newString = str.replaceAll(" ", "");
        if (this.isGraGra && !this.eGra.getName().equals(newString)) {
            this.eGra.setName(newString);
            this.eGra.setChanged(true);
        } else if (this.isTypeGraph) {
            String s = newString;
            String mode = "";
            if (newString.length() >= 3 && newString.substring(0, 3).equals("[D]")) {
                s = newString.substring(newString.indexOf("]") + 1, newString.length());
            } else if (newString.length() >= 3 && newString.substring(0, 3).equals("[E]")) {
                s = newString.substring(newString.indexOf("]") + 1, newString.length());
            } else if (newString.length() >= 4 && newString.substring(0, 4).equals("[Em]")) {
                s = newString.substring(newString.indexOf("]") + 1, newString.length());
            } else if (newString.length() >= 5 && newString.substring(0, 5).equals("[Emm]")) {
                s = newString.substring(newString.indexOf("]") + 1, newString.length());
            } else {
                switch (this.eGraph.getGraGra().getBasisGraGra().getTypeSet().getLevelOfTypeGraphCheck()) {
                    case 0: {
                        mode = "[D]";
                        break;
                    }
                    case 10: {
                        mode = "[E]";
                        break;
                    }
                    case 20: {
                        mode = "[Em]";
                        break;
                    }
                    case 30: {
                        mode = "[Emm]";
                        break;
                    }
                    default: {
                        mode = "[D]";
                    }
                }
            }
            this.string = mode + newString + "    ";
            if (!this.eGraph.getBasisGraph().getName().equals(s)) {
                this.eGraph.getBasisGraph().setName(s);
                this.eGraph.getGraGra().setChanged(true);
            }
        } else if (this.isGraph && !this.eGraph.getBasisGraph().getName().equals(newString)) {
            this.eGraph.getBasisGraph().setName(newString);
            this.eGraph.getGraGra().setChanged(true);
        } else if (this.isRule) {
            String tests;
            String sL;
            String newRuleName = "";
            String sD = "";
            if (!this.eRule.getBasisRule().isEnabled()) {
                sD = "[D]";
            }
            if (oldString.indexOf(sL = "[" + this.eRule.getBasisRule().getLayer() + "]") == -1) {
                sL = "";
            }
            if (newString.indexOf("[D]") != -1) {
                newString = newString.substring(3, newString.length());
            }
            if (newString.indexOf(tests = "[" + this.eRule.getBasisRule().getLayer() + "]") != -1) {
                newString = newString.substring(tests.length(), newString.length());
            }
            newRuleName = newString;
            if (!this.eRule.getBasisRule().getName().equals(newRuleName)) {
                this.eRule.getBasisRule().setName(newRuleName);
                this.eRule.getGraGra().setChanged(true);
            }
            this.string = sD + sL + this.eRule.getBasisRule().getName();
        } else if (this.isAtomic && !this.eAtomic.getBasisAtomic().getAtomicName().equals(newString)) {
            this.eAtomic.getBasisAtomic().setAtomicName(newString);
            for (int i = 0; i < this.eAtomic.getConclusions().size(); ++i) {
                ((EdAtomic)this.eAtomic.getConclusions().elementAt(i)).getBasisAtomic().setAtomicName(newString);
            }
            this.eAtomic.getGraGra().setChanged(true);
        } else if (this.isConclusion && !this.eAtomic.getBasisAtomic().getName().equals(newString)) {
            this.eAtomic.getBasisAtomic().setName(newString);
            this.eAtomic.getGraGra().setChanged(true);
        } else if (this.isConstraint) {
            String s = newString;
            if (newString.indexOf("[") == 0 && newString.indexOf("]") != -1) {
                s = newString.substring(newString.indexOf("]") + 1, newString.length());
            }
            if (!this.eConstraint.getName().equals(s)) {
                String sL = "";
                Vector layer = this.eConstraint.getBasisConstraint().getLayer();
                if (this.eConstraint.getGraGra().getBasisGraGra().isLayered() && !layer.isEmpty()) {
                    sL = "[";
                    for (int k = 0; k < layer.size(); ++k) {
                        int l = (Integer)layer.get(k);
                        sL = sL + String.valueOf(l);
                        if (k >= layer.size() - 1) continue;
                        sL = sL + ",";
                    }
                    sL = sL + "]";
                }
                this.eConstraint.setName(s);
                this.eConstraint.getGraGra().setChanged(true);
                this.string = sL + s;
            }
        } else if (this.isNAC && !this.eNAC.getName().equals(newString)) {
            this.eNAC.setName(newString);
            this.eNAC.getBasisGraph().setName(newString);
            this.eNAC.getGraGra().setChanged(true);
        } else if (!this.isRuleConstraint && !this.isAtomApplCond) {
            if (this.isAttrCondition) {
                this.string = ((CondMember)this.attrCondition.first).getExprAsText();
            } else {
                this.eGras = newString;
            }
        }
    }

    public void setString(String tag, String newString) {
        this.string = tag + newString;
        if (this.isRule && !this.eRule.getBasisRule().getName().equals(newString)) {
            this.eRule.getBasisRule().setName(newString);
            this.eRule.getGraGra().setChanged(true);
        } else if (this.isAttrCondition) {
            this.string = ((CondMember)this.attrCondition.first).getExprAsText();
        } else if (this.isConstraint && !this.eConstraint.getBasisConstraint().getName().equals(newString)) {
            this.eConstraint.getBasisConstraint().setName(newString);
            this.eConstraint.getGraGra().setChanged(true);
        }
    }

    public void setString(String tag, String tag1, String newString) {
        if (this.isRule) {
            this.string = tag + tag1 + newString;
            if (!this.eRule.getBasisRule().getName().equals(newString)) {
                this.eRule.getGraGra().setChanged(true);
            }
            this.eRule.getBasisRule().setName(newString);
        }
    }

    public String string() {
        return this.string;
    }

    public void update() {
        if (this.isAttrCondition) {
            this.string = ((CondMember)this.attrCondition.first).getExprAsText();
        }
    }

    public String toString() {
        return this.string();
    }

    public EdGraGra getGraGra() {
        return this.eGra;
    }

    public EdGraph getGraph() {
        return this.eGraph;
    }

    public EdRule getRule() {
        return this.eRule;
    }

    public EdAtomic getAtomic() {
        return this.eAtomic;
    }

    public EdAtomic getConclusion() {
        return this.eAtomic;
    }

    public EdConstraint getConstraint() {
        return this.eConstraint;
    }

    public EdNAC getNAC() {
        return this.eNAC;
    }

    public Pair getAttrCondition() {
        return this.attrCondition;
    }

    public EdRuleConstraint getRuleConstraint() {
        return this.eRuleConstraint;
    }

    public EdAtomApplCond getAtomApplCond() {
        return this.eAtomApplCond;
    }

    public void setTreeNode(DefaultMutableTreeNode node) {
        this.treeNode = node;
    }

    public DefaultMutableTreeNode getTreeNode() {
        return this.treeNode;
    }
}

