/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.cons.AtomApplCond;
import agg.cons.AtomConstraint;
import agg.cons.ConstraintLayer;
import agg.cons.EvalSet;
import agg.cons.Formula;
import agg.convert.ConverterXML;
import agg.editor.impl.EdAtomApplCond;
import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdConstraint;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdRuleConstraint;
import agg.gui.AGGAppl;
import agg.gui.AGGFileFilter;
import agg.gui.AGGToolBar;
import agg.gui.AtomApplCondPopupMenu;
import agg.gui.AtomicPopupMenu;
import agg.gui.ConclusionPopupMenu;
import agg.gui.ConstraintPopupMenu;
import agg.gui.FilePopupMenu;
import agg.gui.FormulaDialog;
import agg.gui.GraGraConstraintLayerGUI;
import agg.gui.GraGraDisableLayerGUI;
import agg.gui.GraGraElementsStore;
import agg.gui.GraGraLayerGUI;
import agg.gui.GraGraLoad;
import agg.gui.GraGraPopupMenu;
import agg.gui.GraGraPrint;
import agg.gui.GraGraSave;
import agg.gui.GraGraTreeCellRenderer;
import agg.gui.GraGraTreeModel;
import agg.gui.GraGraTreeNodeData;
import agg.gui.GraGraTriggerRuleOfLayerGUI;
import agg.gui.GraphPopupMenu;
import agg.gui.GraphicsExportJPEG;
import agg.gui.NACPopupMenu;
import agg.gui.RuleConstraintPopupMenu;
import agg.gui.RuleConstraintsDialog;
import agg.gui.RulePopupMenu;
import agg.gui.TypeGraphPopupMenu;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import agg.gui.event.LoadEventListener;
import agg.gui.event.SaveEventListener;
import agg.gui.event.TransformEvent;
import agg.gui.event.TransformEventListener;
import agg.gui.event.TreeViewEvent;
import agg.gui.event.TreeViewEventListener;
import agg.gui.icons.DeleteAtomicIcon;
import agg.gui.icons.DeleteConclusionIcon;
import agg.gui.icons.DeleteConstraintIcon;
import agg.gui.icons.DeleteGraGraIcon;
import agg.gui.icons.DeleteGraphIcon;
import agg.gui.icons.DeleteNACIcon;
import agg.gui.icons.DeleteRuleIcon;
import agg.gui.icons.DeleteTypeGraphIcon;
import agg.gui.icons.NewAtomicIcon;
import agg.gui.icons.NewConclusionIcon;
import agg.gui.icons.NewConstraintIcon;
import agg.gui.icons.NewGraGraIcon;
import agg.gui.icons.NewGraphIcon;
import agg.gui.icons.NewNACIcon;
import agg.gui.icons.NewRuleIcon;
import agg.gui.icons.NewTypeGraphIcon;
import agg.util.XMLHelper;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.Completion_NAC;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.RuleLayer;
import agg.xt_basis.TypeError;
import com.objectspace.jgl.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.transform.stream.StreamSource;

public class GraGraTreeView
extends JPanel
implements ActionListener,
TransformEventListener,
EditEventListener {
    private static String stopMarkStr = "   ";
    private JFrame applFrame;
    private String msg;
    private KeyAdapter keyAdapter;
    private String typedKey;
    private Vector menus;
    private JMenu file;
    private AGGToolBar toolBar;
    private GraGraSave gragraSave;
    private Vector saveEventListeners;
    private GraGraLoad gragraLoad;
    private Vector loadEventListeners;
    private Vector treeEventListeners;
    private String directory = "";
    private GraGraPrint gragraPrint;
    private EdGraGra currentGraGra;
    private EdGraGra eGra;
    private EdGraph currentGraph;
    private EdRule currentRule;
    private EdRule eRule;
    private EdNAC currentNAC;
    private EdAtomic currentAtomic;
    private EdAtomic currentConclusion;
    private EdConstraint currentConstraint;
    private EdRuleConstraint currentRuleConstraint;
    private EdAtomApplCond currentAtomApplCond;
    private Pair currentRuleContext;
    private Pair currentConclusionContext;
    private boolean isGraGra = false;
    private boolean isGraph = false;
    private boolean isRule = false;
    private boolean isNAC = false;
    private boolean isAtomic = false;
    private boolean isConclusion = false;
    private boolean isConstraint = false;
    private boolean isRuleConstraint = false;
    private boolean isAtomApplCond = false;
    private boolean isAttrCondition;
    private FilePopupMenu filePopupMenu;
    private ConstraintPopupMenu constraintPopupMenu;
    private AtomicPopupMenu atomicPopupMenu;
    private ConclusionPopupMenu conclusionPopupMenu;
    private RuleConstraintPopupMenu ruleConstraintPopupMenu;
    private AtomApplCondPopupMenu atomApplCondPopupMenu;
    private GraGraPopupMenu gragraPopupMenu;
    private RulePopupMenu rulePopupMenu;
    private NACPopupMenu nacPopupMenu;
    private TypeGraphPopupMenu typeGraphPopupMenu;
    private GraphPopupMenu graphPopupMenu;
    private Point popupLocation;
    private JTree tree;
    private GraGraTreeModel treeModel;
    private DefaultMutableTreeNode top;
    private TreePath selPath;
    private TreePath editorPath;
    private Rectangle movedRect;
    private DefaultMutableTreeNode movedNode;
    private Point movedPoint = new Point(0, 0);
    private boolean newGraGraOK = true;
    private boolean newRuleOK = false;
    private boolean newNACOK = false;
    private boolean wasPressed = false;
    private boolean wasMoved = false;
    private DefaultMutableTreeNode tmpSelNode;
    private TreePath tmpSelPath;
    private boolean isSelected = false;
    private boolean layered = false;
    private boolean useImportTypeGraph = false;
    private boolean rewriteTypeGraph = false;
    private boolean useImportGraph = false;
    private Toolkit tk;
    private GraGraElementsStore storeGraGra;
    private JButton trash;
    private GraphicsExportJPEG exportJPEG;

    public GraGraTreeView() {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.setBackground(Color.lightGray);
        this.setToolkit();
        this.storeGraGra = new GraGraElementsStore(this);
        this.createMenus();
        this.createToolBar();
        this.top = new DefaultMutableTreeNode(new GraGraTreeNodeData("GraGras", true));
        this.treeModel = new GraGraTreeModel(this.top);
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(false);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setCellRenderer(new GraGraTreeCellRenderer());
        this.add((Component)new JScrollPane(this.tree), "Center");
        this.filePopupMenu = new FilePopupMenu(this);
        this.gragraPopupMenu = new GraGraPopupMenu(this);
        this.rulePopupMenu = new RulePopupMenu(this);
        this.nacPopupMenu = new NACPopupMenu(this);
        this.constraintPopupMenu = new ConstraintPopupMenu(this);
        this.atomicPopupMenu = new AtomicPopupMenu(this);
        this.ruleConstraintPopupMenu = new RuleConstraintPopupMenu(this);
        this.atomApplCondPopupMenu = new AtomApplCondPopupMenu(this);
        this.conclusionPopupMenu = new ConclusionPopupMenu(this);
        this.typeGraphPopupMenu = new TypeGraphPopupMenu(this);
        this.graphPopupMenu = new GraphPopupMenu(this);
        this.gragraSave = new GraGraSave(this.applFrame);
        this.gragraLoad = new GraGraLoad(this.applFrame);
        this.gragraPrint = new GraGraPrint(this.applFrame);
        this.keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (!GraGraTreeView.this.performShortKey(e)) {
                    GraGraTreeView.this.transferShortKeyToEditor(e);
                }
            }
        };
        this.addKeyListener(this.keyAdapter);
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getSource() == GraGraTreeView.this.tree) {
                    GraGraTreeView.this.wasPressed = true;
                    GraGraTreeView.this.tree.setEditable(false);
                    if (GraGraTreeView.this.tree.getRowForLocation(e.getX(), e.getY()) != -1 && GraGraTreeView.this.tree.getPathForLocation(e.getX(), e.getY()) != GraGraTreeView.this.selPath) {
                        GraGraTreeView.this.selPath = GraGraTreeView.this.tree.getPathForLocation(e.getX(), e.getY());
                        GraGraTreeView.this.setValueForNew(GraGraTreeView.this.selPath);
                    }
                    if (e.isPopupTrigger()) {
                        GraGraTreeView.this.popupLocation = new Point(e.getX(), e.getY());
                        if (GraGraTreeView.this.tree.getRowForLocation(e.getX(), e.getY()) == -1) {
                            GraGraTreeView.this.filePopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            GraGraTreeView.this.popupLocation = GraGraTreeView.this.filePopupMenu.getLocationOnScreen();
                        } else if (GraGraTreeView.this.gragraPopupMenu.invoked(e.getX(), e.getY())) {
                            GraGraTreeView.this.gragraPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            GraGraTreeView.this.popupLocation = GraGraTreeView.this.gragraPopupMenu.getLocationOnScreen();
                        } else if (GraGraTreeView.this.rulePopupMenu.invoked(e.getX(), e.getY())) {
                            GraGraTreeView.this.rulePopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            GraGraTreeView.this.popupLocation = GraGraTreeView.this.rulePopupMenu.getLocationOnScreen();
                        } else if (GraGraTreeView.this.nacPopupMenu.invoked(e.getX(), e.getY())) {
                            GraGraTreeView.this.nacPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            GraGraTreeView.this.popupLocation = GraGraTreeView.this.nacPopupMenu.getLocationOnScreen();
                        } else if (GraGraTreeView.this.constraintPopupMenu.invoked(e.getX(), e.getY())) {
                            GraGraTreeView.this.constraintPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            GraGraTreeView.this.popupLocation = GraGraTreeView.this.constraintPopupMenu.getLocationOnScreen();
                        } else if (GraGraTreeView.this.atomicPopupMenu.invoked(e.getX(), e.getY())) {
                            GraGraTreeView.this.atomicPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            GraGraTreeView.this.popupLocation = GraGraTreeView.this.atomicPopupMenu.getLocationOnScreen();
                        } else if (GraGraTreeView.this.conclusionPopupMenu.invoked(e.getX(), e.getY())) {
                            GraGraTreeView.this.conclusionPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            GraGraTreeView.this.popupLocation = GraGraTreeView.this.conclusionPopupMenu.getLocationOnScreen();
                        } else if (GraGraTreeView.this.typeGraphPopupMenu.invoked(e.getX(), e.getY())) {
                            GraGraTreeView.this.typeGraphPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            GraGraTreeView.this.popupLocation = GraGraTreeView.this.typeGraphPopupMenu.getLocationOnScreen();
                        } else if (GraGraTreeView.this.graphPopupMenu.invoked(e.getX(), e.getY())) {
                            GraGraTreeView.this.graphPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            GraGraTreeView.this.popupLocation = GraGraTreeView.this.graphPopupMenu.getLocationOnScreen();
                        }
                    } else if (SwingUtilities.isMiddleMouseButton(e)) {
                        if (GraGraTreeView.this.selPath != null) {
                            if (GraGraTreeView.this.selPath == GraGraTreeView.this.tree.getSelectionPath()) {
                                GraGraTreeView.this.isSelected = true;
                            } else {
                                GraGraTreeView.this.isSelected = false;
                            }
                            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)GraGraTreeView.this.selPath.getLastPathComponent();
                            GraGraTreeNodeData sd = (GraGraTreeNodeData)aNode.getUserObject();
                            if (sd != null && (sd.isRule || sd.isStop)) {
                                GraGraTreeView.this.movedNode = aNode;
                                if (GraGraTreeView.this.tree.isExpanded(GraGraTreeView.this.selPath)) {
                                    GraGraTreeView.this.tree.collapsePath(GraGraTreeView.this.selPath);
                                }
                                ((GraGraTreeView)GraGraTreeView.this).movedPoint.x = e.getX();
                                ((GraGraTreeView)GraGraTreeView.this).movedPoint.y = e.getY();
                                GraGraTreeView.this.applFrame.setCursor(new Cursor(13));
                                GraGraTreeView.this.movedRect = GraGraTreeView.this.tree.getRowBounds(GraGraTreeView.this.tree.getRowForPath(GraGraTreeView.this.selPath));
                                GraGraTreeView.this.tree.getGraphics().drawRect(((GraGraTreeView)GraGraTreeView.this).movedRect.x - 2, ((GraGraTreeView)GraGraTreeView.this).movedRect.y - 2, ((GraGraTreeView)GraGraTreeView.this).movedRect.width + 2, ((GraGraTreeView)GraGraTreeView.this).movedRect.height + 2);
                            }
                        }
                    } else if (SwingUtilities.isLeftMouseButton(e)) {
                        GraGraTreeView.this.applFrame.setCursor(new Cursor(0));
                    }
                } else if (e.getSource() == GraGraTreeView.this.trash) {
                    GraGraTreeView.this.storeGraGra.setLocation(((GraGraTreeView)GraGraTreeView.this).trash.getLocationOnScreen().x, ((GraGraTreeView)GraGraTreeView.this).trash.getLocationOnScreen().y);
                }
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getSource() == GraGraTreeView.this.tree) {
                    if (SwingUtilities.isLeftMouseButton(e) && GraGraTreeView.this.selPath != null) {
                        if (GraGraTreeView.this.wasPressed && e.getClickCount() == 2) {
                            GraGraTreeView.this.tree.setSelectionPath(GraGraTreeView.this.selPath);
                            GraGraTreeView.this.setValueForNew(GraGraTreeView.this.selPath);
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)GraGraTreeView.this.selPath.getLastPathComponent();
                            if (!((GraGraTreeNodeData)node.getUserObject()).isRuleConstraint && !((GraGraTreeNodeData)node.getUserObject()).isAtomApplCond) {
                                if (!GraGraTreeView.this.tree.isExpanded(GraGraTreeView.this.selPath)) {
                                    GraGraTreeView.this.tree.expandPath(GraGraTreeView.this.selPath);
                                }
                                if (!((GraGraTreeNodeData)node.getUserObject()).isAttrCondition) {
                                    GraGraTreeView.this.tree.setEditable(true);
                                }
                                if (GraGraTreeView.this.tree.isEditable()) {
                                    GraGraTreeView.this.tree.startEditingAtPath(GraGraTreeView.this.selPath);
                                }
                            }
                            GraGraTreeView.this.wasPressed = false;
                        } else if (GraGraTreeView.this.wasPressed) {
                            GraGraTreeView.this.tree.setEditable(false);
                            if (!GraGraTreeView.this.wasMoved && !GraGraTreeView.this.selPath.equals(GraGraTreeView.this.editorPath)) {
                                GraGraTreeView.this.fireTreeViewEvent(new TreeViewEvent((Object)this, 6, GraGraTreeView.this.selPath));
                                GraGraTreeView.this.tree.setSelectionPath(GraGraTreeView.this.selPath);
                                DefaultMutableTreeNode node = (DefaultMutableTreeNode)GraGraTreeView.this.selPath.getLastPathComponent();
                                GraGraTreeView.this.setValueForNew(GraGraTreeView.this.selPath);
                                GraGraTreeView.this.editorPath = GraGraTreeView.this.selPath;
                                if ((DefaultMutableTreeNode)GraGraTreeView.this.editorPath.getLastPathComponent() != (DefaultMutableTreeNode)GraGraTreeView.this.treeModel.getRoot()) {
                                    GraGraTreeView.this.setCurrentData(GraGraTreeView.this.editorPath);
                                    GraGraTreeView.this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, GraGraTreeView.this.editorPath));
                                    if (GraGraTreeView.this.getGraGra().getBasisGraGra().isLayered()) {
                                        GraGraTreeView.this.layered = true;
                                    } else {
                                        GraGraTreeView.this.layered = false;
                                    }
                                    GraGraTreeView.this.treeModel.ruleNameChanged(GraGraTreeView.this.getGraGra(), GraGraTreeView.this.layered);
                                    GraGraTreeView.this.treeModel.constraintNameChanged(GraGraTreeView.this.getGraGra(), GraGraTreeView.this.layered);
                                    GraGraTreeView.this.requestFocusInWindow();
                                }
                            }
                            GraGraTreeView.this.wasPressed = false;
                        }
                    }
                } else if (e.getSource() == GraGraTreeView.this.trash) {
                    GraGraTreeView.this.storeGraGra.setLocation(((GraGraTreeView)GraGraTreeView.this).trash.getLocationOnScreen().x, ((GraGraTreeView)GraGraTreeView.this).trash.getLocationOnScreen().y);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.getSource() == GraGraTreeView.this.tree) {
                    if (e.isPopupTrigger()) {
                        if (GraGraTreeView.this.tree.getRowForLocation(e.getX(), e.getY()) == -1) {
                            GraGraTreeView.this.filePopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            GraGraTreeView.this.popupLocation = GraGraTreeView.this.filePopupMenu.getLocationOnScreen();
                        } else if (GraGraTreeView.this.gragraPopupMenu.invoked(e.getX(), e.getY())) {
                            GraGraTreeView.this.gragraPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            GraGraTreeView.this.popupLocation = GraGraTreeView.this.gragraPopupMenu.getLocationOnScreen();
                        } else if (GraGraTreeView.this.rulePopupMenu.invoked(e.getX(), e.getY())) {
                            GraGraTreeView.this.rulePopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            GraGraTreeView.this.popupLocation = GraGraTreeView.this.rulePopupMenu.getLocationOnScreen();
                        } else if (GraGraTreeView.this.nacPopupMenu.invoked(e.getX(), e.getY())) {
                            GraGraTreeView.this.nacPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            GraGraTreeView.this.popupLocation = GraGraTreeView.this.nacPopupMenu.getLocationOnScreen();
                        } else if (GraGraTreeView.this.constraintPopupMenu.invoked(e.getX(), e.getY())) {
                            GraGraTreeView.this.constraintPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            GraGraTreeView.this.popupLocation = GraGraTreeView.this.constraintPopupMenu.getLocationOnScreen();
                        } else if (GraGraTreeView.this.atomicPopupMenu.invoked(e.getX(), e.getY())) {
                            GraGraTreeView.this.atomicPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            GraGraTreeView.this.popupLocation = GraGraTreeView.this.atomicPopupMenu.getLocationOnScreen();
                        } else if (GraGraTreeView.this.conclusionPopupMenu.invoked(e.getX(), e.getY())) {
                            GraGraTreeView.this.conclusionPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            GraGraTreeView.this.popupLocation = GraGraTreeView.this.conclusionPopupMenu.getLocationOnScreen();
                        } else if (GraGraTreeView.this.typeGraphPopupMenu.invoked(e.getX(), e.getY())) {
                            GraGraTreeView.this.typeGraphPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            GraGraTreeView.this.popupLocation = GraGraTreeView.this.typeGraphPopupMenu.getLocationOnScreen();
                        } else if (GraGraTreeView.this.graphPopupMenu.invoked(e.getX(), e.getY())) {
                            GraGraTreeView.this.graphPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                            GraGraTreeView.this.popupLocation = GraGraTreeView.this.graphPopupMenu.getLocationOnScreen();
                        }
                    } else if (GraGraTreeView.this.movedNode != null) {
                        GraGraTreeView.this.applFrame.setCursor(new Cursor(13));
                        if (GraGraTreeView.this.tree.getRowForLocation(e.getX(), e.getY()) != -1) {
                            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)GraGraTreeView.this.tree.getPathForLocation(e.getX(), e.getY()).getLastPathComponent();
                            GraGraTreeNodeData sd = (GraGraTreeNodeData)aNode.getUserObject();
                            if (aNode != GraGraTreeView.this.movedNode && sd.isRule && GraGraTreeView.this.movedNode.getParent() == aNode.getParent()) {
                                int oldIndx = GraGraTreeView.this.treeModel.getIndexOfChild(GraGraTreeView.this.movedNode.getParent(), GraGraTreeView.this.movedNode);
                                DefaultMutableTreeNode movedCopy = (DefaultMutableTreeNode)GraGraTreeView.this.movedNode.clone();
                                int i = 0;
                                while (i < GraGraTreeView.this.movedNode.getChildCount()) {
                                    movedCopy.add((DefaultMutableTreeNode)GraGraTreeView.this.movedNode.getChildAt(i));
                                }
                                GraGraTreeView.this.treeModel.insertNodeInto(movedCopy, (DefaultMutableTreeNode)aNode.getParent(), ((DefaultMutableTreeNode)aNode.getParent()).getIndex(aNode));
                                int newIndx = GraGraTreeView.this.treeModel.getIndexOfChild(GraGraTreeView.this.movedNode.getParent(), movedCopy);
                                if (GraGraTreeView.this.tmpSelNode != null && GraGraTreeView.this.movedNode.equals(GraGraTreeView.this.tmpSelNode)) {
                                    GraGraTreeView.this.isSelected = true;
                                }
                                GraGraTreeView.this.treeModel.removeNodeFromParent(GraGraTreeView.this.movedNode);
                                if (GraGraTreeView.this.isSelected) {
                                    if (newIndx < oldIndx) {
                                        GraGraTreeView.this.tree.setSelectionRow(GraGraTreeView.this.tree.getRowForLocation(e.getX(), e.getY()));
                                    } else {
                                        GraGraTreeView.this.tree.setSelectionRow(GraGraTreeView.this.tree.getRowForLocation(e.getX(), e.getY()) - 1);
                                    }
                                } else if (GraGraTreeView.this.tmpSelPath != null) {
                                    GraGraTreeView.this.tree.setSelectionPath(GraGraTreeView.this.tmpSelPath);
                                }
                                GraGraTreeView.this.selPath = GraGraTreeView.this.tree.getPathForLocation(e.getX(), e.getY());
                                GraGraTreeView.this.refreshGraGraRules((DefaultMutableTreeNode)movedCopy.getParent());
                            }
                        }
                        GraGraTreeView.this.movedNode = null;
                        GraGraTreeView.this.tmpSelNode = null;
                        GraGraTreeView.this.tmpSelPath = null;
                        GraGraTreeView.this.isSelected = false;
                        GraGraTreeView.this.applFrame.setCursor(new Cursor(0));
                        GraGraTreeView.this.wasMoved = false;
                    }
                } else if (e.getSource() == GraGraTreeView.this.trash) {
                    GraGraTreeView.this.storeGraGra.setLocation(((GraGraTreeView)GraGraTreeView.this).trash.getLocationOnScreen().x, ((GraGraTreeView)GraGraTreeView.this).trash.getLocationOnScreen().y);
                }
            }

            public void mouseDragged(MouseEvent e) {
                if (e.getSource() == GraGraTreeView.this.tree && GraGraTreeView.this.movedNode != null) {
                    int dx = e.getX() - ((GraGraTreeView)GraGraTreeView.this).movedPoint.x;
                    int dy = e.getY() - ((GraGraTreeView)GraGraTreeView.this).movedPoint.y;
                    ((GraGraTreeView)GraGraTreeView.this).movedPoint.x = e.getX();
                    ((GraGraTreeView)GraGraTreeView.this).movedPoint.y = e.getY();
                    ((GraGraTreeView)GraGraTreeView.this).movedRect.x += dx;
                    ((GraGraTreeView)GraGraTreeView.this).movedRect.y = ((GraGraTreeView)GraGraTreeView.this).movedRect.y = dy;
                    GraGraTreeView.this.tree.getGraphics().drawRect(((GraGraTreeView)GraGraTreeView.this).movedRect.x, ((GraGraTreeView)GraGraTreeView.this).movedRect.y, ((GraGraTreeView)GraGraTreeView.this).movedRect.width, ((GraGraTreeView)GraGraTreeView.this).movedRect.height);
                }
            }

            public void mouseEntered(MouseEvent e) {
                GraGraTreeView.this.requestFocusInWindow();
            }
        };
        this.tree.addMouseListener(ml);
        this.trash.addMouseListener(ml);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean performShortKey(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (e.isControlDown() && e.isAltDown()) {
            this.typedKey = KeyEvent.getKeyText(keyCode);
            if (this.typedKey.equals("T")) {
                this.executeCommand("newTypeGraph");
                return true;
            } else if (this.typedKey.equals("G")) {
                this.executeCommand("newGraph");
                return true;
            } else if (this.typedKey.equals("R")) {
                this.executeCommand("newRule");
                return true;
            } else if (this.typedKey.equals("A")) {
                this.executeCommand("newAtomic");
                return true;
            } else {
                if (!this.typedKey.equals("C")) return false;
                this.executeCommand("newConstraint");
            }
            return true;
        } else if (e.isControlDown() && e.isShiftDown()) {
            this.typedKey = KeyEvent.getKeyText(keyCode);
            if (!this.typedKey.equals("G")) return false;
            this.resetGraph();
            return true;
        } else if (e.isShiftDown() && e.isAltDown()) {
            this.typedKey = KeyEvent.getKeyText(keyCode);
            if (this.typedKey.equals("G")) {
                this.executeCommand("importGGX");
                return true;
            } else if (this.typedKey.equals("X")) {
                this.executeCommand("importGXL");
                return true;
            } else if (this.typedKey.equals("O")) {
                this.executeCommand("importOMONDOXMI");
                return true;
            } else if (this.typedKey.equals("N")) {
                this.executeCommand("newNAC");
                return true;
            } else if (this.typedKey.equals("L")) {
                this.setRuleLayer();
                return true;
            } else if (this.typedKey.equals("C")) {
                this.executeCommand("newConclusion");
                return true;
            } else if (this.typedKey.equals("R")) {
                this.reloadGraGra();
                return true;
            } else {
                if (!this.typedKey.equals("D")) return false;
                this.copyRule();
            }
            return true;
        } else if (e.isShiftDown()) {
            this.typedKey = KeyEvent.getKeyText(keyCode);
            if (this.typedKey.equals("J")) {
                this.executeCommand("exportGraphJPEG");
                return true;
            } else if (this.typedKey.equals("X")) {
                this.executeCommand("exportGXL");
                return true;
            } else {
                if (!this.typedKey.equals("T")) return false;
                this.executeCommand("exportGTXL");
            }
            return true;
        } else if (e.isControlDown()) {
            this.typedKey = KeyEvent.getKeyText(keyCode);
            if (this.typedKey.equals("N")) {
                this.executeCommand("newGraGra");
                return true;
            } else if (this.typedKey.equals("O")) {
                this.executeCommand("open");
                return true;
            } else if (this.typedKey.equals("W")) {
                this.executeCommand("save");
                return true;
            } else {
                if (!this.typedKey.equals("Q")) return false;
                this.executeCommand("exit");
            }
            return true;
        } else if (e.isAltDown()) {
            this.typedKey = KeyEvent.getKeyText(keyCode);
            if (!this.typedKey.equals("W")) return false;
            this.executeCommand("saveAs");
            return true;
        } else if (KeyEvent.getKeyText(keyCode).equals("Delete") || KeyEvent.getKeyText(keyCode).equals("Entf")) {
            this.delete();
            return true;
        } else {
            if (!KeyEvent.getKeyText(keyCode).equals("F")) return false;
            this.file.doClick();
        }
        return true;
    }

    private void transferShortKeyToEditor(KeyEvent e) {
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 24, e));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            if (this.currentGraGra == null) {
                return;
            }
            if (((JCheckBox)e.getSource()).getText().equals("layered")) {
                this.layered = ((JCheckBox)e.getSource()).isSelected();
                if (this.layered) {
                    this.currentGraGra.getBasisGraGra().addGraTraOption("layered");
                } else {
                    this.currentGraGra.getBasisGraGra().removeGraTraOption("layered");
                }
                this.treeModel.ruleNameChanged(this.currentGraGra, this.layered);
                this.treeModel.constraintNameChanged(this.currentGraGra, this.layered);
            }
            return;
        }
        String command = e.getActionCommand();
        if (command.equals("disableRule")) {
            if (e.getSource() instanceof JRadioButtonMenuItem) {
                if (((JMenuItem)e.getSource()).isSelected()) {
                    this.executeCommand("disableRule");
                } else {
                    this.executeCommand("enableRule");
                }
            }
        } else {
            this.executeCommand(command);
        }
    }

    private void executeCommand(String command) {
        if (command.equals("newGraGra")) {
            this.addGraGra();
            this.resetEnabledOfFileMenuItems(command);
            this.filePopupMenu.resetEnabledOfFileMenuItems(command);
            this.resetEnabledOfToolBarItems(command);
        } else if (command.equals("newTypeGraph")) {
            this.addTypeGraph();
        } else if (command.equals("newGraph")) {
            this.addGraph();
        } else if (command.equals("addGraph")) {
            this.addHostGraph();
        } else if (command.equals("newRule")) {
            this.addRule();
        } else if (command.equals("newNAC")) {
            this.addNAC();
        } else if (command.equals("newAtomic")) {
            this.addAtomic();
        } else if (command.equals("newConclusion")) {
            this.addConclusion();
        } else if (command.equals("newConstraint")) {
            this.addConstraint();
        } else if (command.equals("checkRuleApplicability")) {
            this.checkRuleApplicability();
        } else if (command.equals("checkTypeGraph.ENABLED")) {
            this.setTypeGraphLevel(10);
        } else if (command.equals("checkTypeGraph.DISABLED")) {
            this.setTypeGraphLevel(0);
        } else if (command.equals("checkTypeGraph.ENABLED_MAX")) {
            this.setTypeGraphLevel(20);
        } else if (command.equals("checkTypeGraph.ENABLED_MAX_MIN")) {
            this.setTypeGraphLevel(30);
        } else if (command.equals("newAtomic")) {
            this.addAtomic();
        } else if (command.equals("newConclusion")) {
            this.addConclusion();
        } else if (command.equals("newConstraint")) {
            this.addConstraint();
        } else if (command.equals("checkConstraints")) {
            this.doAtomics(2);
        } else if (command.equals("checkAtomics")) {
            this.doAtomics(1);
        } else if (command.equals("convertConstraints")) {
            this.doAtomics(0);
        } else if (command.equals("convertAtomicsOfRule")) {
            this.doAtomicsOfRule();
        } else if (command.equals("checkOneAtomic")) {
            this.checkOne();
        } else if (command.equals("checkOneConstraint")) {
            this.checkOne();
        } else if (command.equals("editConstraint")) {
            this.editConstraint();
        } else if (command.equals("deleteAtomic")) {
            this.delete("Atomic");
        } else if (command.equals("deleteConclusion")) {
            this.delete("Conclusion");
        } else if (command.equals("deleteConstraint")) {
            this.delete("Constraint");
        } else if (command.equals("deleteRuleConstraint")) {
            this.delete("RuleConstraint");
        } else if (command.equals("deleteAtomApplCond")) {
            this.delete("AtomApplCond");
        } else if (command.equals("deleteRuleConstraints")) {
            this.delete("RuleConstraints");
        } else if (command.equals("open")) {
            this.loadGraGra();
            this.resetEnabledOfFileMenuItems(command);
            this.filePopupMenu.resetEnabledOfFileMenuItems(command);
            this.resetEnabledOfToolBarItems(command);
        } else if (command.equals("save")) {
            this.saveGraGra();
        } else if (command.equals("saveAs")) {
            this.saveAsGraGra();
        } else if (command.equals("exportGraphJPEG")) {
            this.exportGraphJPEG();
        } else if (command.equals("exportJPEG")) {
            this.exportJPEG();
        } else if (command.equals("openBase")) {
            this.loadBaseGraGra();
        } else if (command.equals("saveAsBase")) {
            this.saveAsBaseGraGra();
        } else if (command.equals("resetGraph")) {
            this.resetGraph();
        } else if (command.equals("reload")) {
            this.reloadGraGra();
        } else if (command.equals("exportGXL")) {
            this.exportGraGra("GXL");
        } else if (command.equals("exportGTXL")) {
            this.exportGraGra("GTXL");
        } else if (command.equals("importGGX")) {
            this.importGraGra("GGX");
        } else if (command.equals("importGXL")) {
            this.importGraGra("GXL");
        } else if (command.equals("importGTXL")) {
            this.importGraGra("GTXL");
        } else if (command.equals("importOMONDOXMI")) {
            this.importGraGra("OMONDOXMI");
        } else if (command.equals("delete")) {
            this.delete("");
            this.resetEnabledOfFileMenuItems(command);
            this.filePopupMenu.resetEnabledOfFileMenuItems(command);
            this.resetEnabledOfToolBarItems(command);
            if (this.tree.getRowCount() == 1) {
                this.fireTreeViewEvent(new TreeViewEvent(this, 11));
            }
        } else if (command.equals("deleteGraGra")) {
            this.delete("GraGra");
            this.resetEnabledOfFileMenuItems(command);
            this.filePopupMenu.resetEnabledOfFileMenuItems(command);
            this.resetEnabledOfToolBarItems(command);
            if (this.tree.getRowCount() == 1) {
                this.fireTreeViewEvent(new TreeViewEvent(this, 11));
            }
        } else if (command.equals("deleteGraph")) {
            this.delete("Graph");
        } else if (command.equals("deleteTypeGraph")) {
            this.delete("TypeGraph");
        } else if (command.equals("deleteRule")) {
            this.delete("Rule");
        } else if (command.equals("deleteNAC")) {
            this.delete("NAC");
        } else if (command.equals("deleteRuleConstraint")) {
            this.delete("RuleConstraint");
        } else if (command.equals("deleteAtomApplCond")) {
            this.delete("AtomApplCond");
        } else if (command.equals("print")) {
            this.print();
        } else if (command.equals("moveRule")) {
            this.moveRule();
        } else if (command.equals("copyRule")) {
            this.copy("Rule");
        } else if (command.equals("disableRule")) {
            this.disable("Rule", true);
        } else if (command.equals("enableRule")) {
            this.disable("Rule", false);
        } else if (command.equals("setRuleLayer")) {
            this.setRuleLayer();
        } else if (command.equals("setLayerOfRules")) {
            this.setLayerOfRules();
        } else if (command.equals("setLayerOfConstraints")) {
            this.setLayerOfConstraints();
        } else if (command.equals("setTriggerRuleOfLayer")) {
            this.setTriggerRuleOfLayer();
        } else if (command.equals("sortRulesByLayer")) {
            this.sortRulesByLayer();
        } else if (command.equals("disableLayerOfRules")) {
            this.disableLayerOfRules();
        } else if (command.equals("setFormulaLayer")) {
            this.setConstraintLayer();
        } else if (command.equals("sortConstraintsByLayer")) {
            this.sortConstraintsByLayer();
        } else if (command.equals("showNAC")) {
            this.showNAC();
        } else if (command.equals("hideNAC")) {
            this.hideNAC();
        } else if (command.equals("showAttrConditions")) {
            this.showRuleAttrConditions(null);
        } else if (command.equals("undoDelete")) {
            this.undoDelete();
        } else if (command.equals("undoDeleteTypeGraph")) {
            this.undoDeleteTypeGraph();
        } else if (command.equals("undoDeleteRule")) {
            this.undoDeleteRule();
        } else if (command.equals("undoDeleteNAC")) {
            this.undoDeleteNAC();
        } else if (command.equals("undoDeleteAtomicConstraint")) {
            this.undoDeleteAtomicConstraint();
        } else if (command.equals("undoDeleteConstraint")) {
            this.undoDeleteConstraint();
        } else if (command.equals("undoDeleteAtomicConclusion")) {
            this.undoDeleteAtomicConclusion();
        } else if (command.equals("exit")) {
            System.exit(0);
        }
    }

    public synchronized void addSaveEventListener(SaveEventListener l) {
        this.gragraSave.addSaveEventListener(l);
    }

    public synchronized void removeSaveEventListener(SaveEventListener l) {
        this.gragraSave.removeSaveEventListener(l);
    }

    public synchronized void addLoadEventListener(LoadEventListener l) {
        this.gragraLoad.addLoadEventListener(l);
    }

    public synchronized void removeLoadEventListener(LoadEventListener l) {
        this.gragraLoad.removeLoadEventListener(l);
    }

    public synchronized void addTreeViewEventListener(TreeViewEventListener l) {
        Vector v;
        Vector vector = v = this.treeEventListeners == null ? new Vector(2) : (Vector)this.treeEventListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.treeEventListeners = v;
        }
    }

    public synchronized void removeTreeViewEventListener(TreeViewEventListener l) {
        if (this.treeEventListeners != null && this.treeEventListeners.contains(l)) {
            Vector v = (Vector)this.treeEventListeners.clone();
            v.removeElement(l);
            this.treeEventListeners = v;
        }
    }

    public synchronized void addTreeModelListener(TreeModelListener l) {
        this.getTree().getModel().addTreeModelListener(l);
    }

    public synchronized void removeTreeModelListener(TreeModelListener l) {
        this.getTree().getModel().removeTreeModelListener(l);
    }

    private synchronized void fireTreeViewEvent(TreeViewEvent e) {
        if (this.treeEventListeners != null) {
            Vector listeners = this.treeEventListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((TreeViewEventListener)listeners.elementAt(i)).treeViewEventOccurred(e);
            }
        }
    }

    public Enumeration getMenus() {
        return this.menus.elements();
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void setFrame(JFrame f) {
        this.applFrame = f;
        this.gragraSave.setFrame(f);
        this.gragraLoad.setFrame(f);
        this.gragraPrint.setFrame(f);
    }

    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    public JTree getTree() {
        return this.tree;
    }

    public GraGraTreeModel getTreeModel() {
        return this.treeModel;
    }

    public GraGraPrint getPrint() {
        return this.gragraPrint;
    }

    public EdGraGra getCurrentGraGra() {
        return this.currentGraGra;
    }

    public void graphDidChange() {
        this.fireTreeViewEvent(new TreeViewEvent(this, 19));
    }

    public void selectPath(int x, int y) {
        this.selPath = this.tree.getPathForLocation(x, y);
        this.tree.setSelectionPath(this.selPath);
        this.tree.treeDidChange();
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData sd = (GraGraTreeNodeData)aNode.getUserObject();
        this.setValueForNew(sd);
    }

    public boolean addGraGra(EdGraGra grammar) {
        if (grammar != null) {
            BaseFactory.theFactory().notify(grammar.getBasisGraGra());
            grammar.update();
            int indx = this.putGraGraInTree(grammar);
            this.putGraGraInEditor(indx);
            if (this.currentGraGra.getGraTraOptions().contains("layered")) {
                this.layered = true;
                this.treeModel.ruleNameChanged(this.currentGraGra, this.layered);
                this.treeModel.constraintNameChanged(this.currentGraGra, this.layered);
            }
            this.fireTreeViewEvent(new TreeViewEvent(this, 0));
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
            grammar.setChanged(false);
            return true;
        }
        return false;
    }

    public EdGraGra addGraGra() {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.treeModel.getRoot();
        int newIndex = parent.getChildCount();
        String name = "GraGra";
        if (parent.getChildCount() > 0) {
            name = "GraGra" + newIndex;
        }
        if (!((GraGraTreeModel)this.tree.getModel()).isValid(((GraGraTreeModel)this.tree.getModel()).getGraGraNames(), name, "")) {
            name = name + "_";
        }
        EdGraGra newGraGra = new EdGraGra(name);
        newGraGra.getBasisGraGra().getGraph().setName("Graph");
        GraGraTreeNodeData sdGraGra = new GraGraTreeNodeData(newGraGra);
        DefaultMutableTreeNode newGraGraNode = new DefaultMutableTreeNode(sdGraGra);
        sdGraGra.setTreeNode(newGraGraNode);
        this.treeModel.insertNodeInto(newGraGraNode, parent, newIndex);
        if (!this.tree.isExpanded(this.tree.getPathForRow(0))) {
            this.tree.expandPath(this.tree.getPathForRow(0));
        }
        int graIndex = this.tree.getRowCount() - 1;
        GraGraTreeNodeData sdGraph = new GraGraTreeNodeData(newGraGra.getGraph());
        DefaultMutableTreeNode newGraphNode = new DefaultMutableTreeNode(sdGraph);
        sdGraph.setTreeNode(newGraphNode);
        parent = newGraGraNode;
        newIndex = parent.getChildCount();
        this.treeModel.insertNodeInto(newGraphNode, parent, newIndex);
        GraGraTreeNodeData sdRule = new GraGraTreeNodeData((EdRule)newGraGra.getRules().firstElement());
        DefaultMutableTreeNode newRuleNode = new DefaultMutableTreeNode(sdRule);
        sdRule.setTreeNode(newRuleNode);
        newIndex = parent.getChildCount();
        this.treeModel.insertNodeInto(newRuleNode, parent, newIndex);
        if (!this.tree.isExpanded(this.tree.getPathForRow(graIndex))) {
            this.tree.expandPath(this.tree.getPathForRow(graIndex));
        }
        this.tree.setSelectionRow(graIndex);
        this.editorPath = this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
        this.setValueForNew(this.editorPath);
        this.fireTreeViewEvent(new TreeViewEvent(this, 0));
        this.setCurrentData(this.editorPath);
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
        this.layered = false;
        this.treeModel.ruleNameChanged(newGraGra, this.layered);
        this.treeModel.constraintNameChanged(newGraGra, this.layered);
        newGraGra.setChanged(false);
        return newGraGra;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean addHostGraph() {
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                String s = "Bad selection.\n Please select a grammar.";
                JOptionPane.showMessageDialog(null, s);
                return false;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a grammar.");
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.eGra = this.getGraGra(parent);
        if (this.eGra != this.currentGraGra) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select the appropriate grammar.");
            return false;
        }
        EdGraph g = this.eGra.cloneGraph(true);
        int indx = this.eGra.getGraphs().size() - 1;
        if (this.eGra.getTypeGraph() != null) {
            ++indx;
        }
        g.getBasisGraph().setName(this.eGra.getGraph().getBasisGraph().getName() + (this.eGra.getGraphs().size() - 1));
        GraGraTreeNodeData sdGraph = new GraGraTreeNodeData(g);
        DefaultMutableTreeNode newGraphNode = new DefaultMutableTreeNode(sdGraph);
        sdGraph.setTreeNode(newGraphNode);
        this.treeModel.insertNodeInto(newGraphNode, parent, indx);
        return true;
    }

    private boolean addGraph() {
        return this.addGraph(null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean addGraph(EdGraGra gra, EdGraph g) {
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                String s = "Bad selection.\n Please select a grammar.";
                JOptionPane.showMessageDialog(null, s);
                return false;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a grammar.");
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.eGra = this.getGraGra(parent);
        if (gra != null && gra != this.eGra) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select the appropriate grammar.");
            return false;
        }
        if (g == null) {
            g = new EdGraph(new Graph(this.eGra.getTypeSet().getBasisTypeSet(), true), this.eGra.getTypeSet());
            g.getBasisGraph().setName(g.getBasisGraph().getName() + this.eGra.getGraphs().size());
        }
        if (!this.eGra.getGraphs().contains(g)) {
            this.eGra.addGraph(g);
        }
        g.setGraGra(this.eGra);
        GraGraTreeNodeData sdGraph = new GraGraTreeNodeData(g);
        DefaultMutableTreeNode newGraphNode = new DefaultMutableTreeNode(sdGraph);
        sdGraph.setTreeNode(newGraphNode);
        int indx = this.eGra.getGraphs().size() - 1;
        if (this.eGra.getTypeGraph() != null) {
            ++indx;
        }
        this.treeModel.insertNodeInto(newGraphNode, parent, indx);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EdGraph addTypeGraph() {
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                String s = "Bad selection.\n Please select a grammar.";
                JOptionPane.showMessageDialog(null, s);
                return null;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a grammar.");
            return null;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.eGra = this.getGraGra(parent);
        if (this.eGra.getTypeSet().getTypeGraph() != null) {
            JOptionPane.showMessageDialog(null, " The type graph already exists.");
            return null;
        }
        EdGraph typeGraph = this.eGra.getTypeSet().createTypeGraph();
        typeGraph.setGraGra(this.eGra);
        GraGraTreeNodeData sdTypeGraph = new GraGraTreeNodeData(typeGraph, true);
        sdTypeGraph.setString("[D]TypeGraph");
        DefaultMutableTreeNode newTypeGraphNode = new DefaultMutableTreeNode(sdTypeGraph);
        sdTypeGraph.setTreeNode(newTypeGraphNode);
        this.treeModel.insertNodeInto(newTypeGraphNode, parent, 0);
        return typeGraph;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean addTypeGraph(EdGraGra gra, EdGraph g) {
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                String s = "Bad selection.\n Please select a grammar.";
                JOptionPane.showMessageDialog(null, s);
                return false;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a grammar.");
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.eGra = this.getGraGra(parent);
        if (this.eGra.getTypeSet().getTypeGraph() != null) {
            JOptionPane.showMessageDialog(null, " The type graph already exists.");
            return false;
        }
        if (this.eGra != gra) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select the apropriate grammar.");
            return false;
        }
        this.eGra.getTypeSet().setTypeGraph(g);
        g.setGraGra(this.eGra);
        GraGraTreeNodeData sdTypeGraph = new GraGraTreeNodeData(g, true);
        sdTypeGraph.setString("[D]TypeGraph");
        DefaultMutableTreeNode newTypeGraphNode = new DefaultMutableTreeNode(sdTypeGraph);
        sdTypeGraph.setTreeNode(newTypeGraphNode);
        this.treeModel.insertNodeInto(newTypeGraphNode, parent, 0);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EdRule addRule() {
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                String s = "Bad selection.\n Please select a grammar.";
                JOptionPane.showMessageDialog(null, s);
                return null;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a grammar.");
            return null;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.eGra = this.getGraGra(parent);
        int newIndex = this.eGra.getGraphs().size() + this.eGra.getRules().size();
        if (this.eGra.getTypeSet().getTypeGraph() != null) {
            ++newIndex;
        }
        String name = "Rule" + this.eGra.getRules().size();
        if (!((GraGraTreeModel)this.tree.getModel()).isValid(((GraGraTreeModel)this.tree.getModel()).getGraGraChildrenNames(this.eGra), name, "")) {
            name = name + "_";
        }
        EdRule newRule = this.eGra.createRule(name);
        GraGraTreeNodeData sdRule = new GraGraTreeNodeData(newRule);
        if (this.layered) {
            String tag = "[" + newRule.getBasisRule().getLayer() + "]";
            sdRule.setString(tag, name);
        }
        DefaultMutableTreeNode newRuleNode = new DefaultMutableTreeNode(sdRule);
        sdRule.setTreeNode(newRuleNode);
        this.treeModel.insertNodeInto(newRuleNode, parent, newIndex);
        return newRule;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean addRule(EdGraGra gra, EdRule newRule) {
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                String s = "Bad selection.\n Please select a grammar.";
                JOptionPane.showMessageDialog(null, s);
                return false;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a grammar.");
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.eGra = this.getGraGra(parent);
        if (this.eGra != gra) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select the appropriate grammar.");
            return false;
        }
        this.eGra.addRule(newRule);
        int newIndex = this.eGra.getGraphs().size() + this.eGra.getRules().size() - 1;
        if (this.eGra.getTypeSet().getTypeGraph() != null) {
            ++newIndex;
        }
        String name = newRule.getBasisRule().getName();
        GraGraTreeNodeData sdRule = new GraGraTreeNodeData(newRule);
        if (this.layered) {
            String tag = "[" + newRule.getBasisRule().getLayer() + "]";
            sdRule.setString(tag, name);
        }
        DefaultMutableTreeNode newRuleNode = new DefaultMutableTreeNode(sdRule);
        sdRule.setTreeNode(newRuleNode);
        this.treeModel.insertNodeInto(newRuleNode, parent, newIndex);
        int i = 0;
        while (i < newRule.getNACs().size()) {
            EdNAC nac = (EdNAC)newRule.getNACs().get(i);
            GraGraTreeNodeData sd = new GraGraTreeNodeData(nac);
            DefaultMutableTreeNode nacNode = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(nacNode);
            this.treeModel.insertNodeInto(nacNode, newRuleNode, i);
            ++i;
        }
        return true;
    }

    protected void inheritanceWarning() {
        JOptionPane.showMessageDialog(null, "Sorry!\nThis item is not available for the graph grammar \nwith node type inheritance.", "Warning", 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public EdAtomic addAtomic() {
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                String s = "Bad selection.\n Please select a grammar.";
                JOptionPane.showMessageDialog(null, s);
                return null;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a grammar.");
            return null;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.eGra = this.getGraGra(parent);
        int newIndex = this.eGra.getGraphs().size() + this.eGra.getRules().size() + this.eGra.getAtomics().size();
        if (this.eGra.getTypeSet().getTypeGraph() != null) {
            ++newIndex;
        }
        String name = "Atomic";
        if (this.eGra.getAtomics().size() > 0) {
            name = name + this.eGra.getAtomics().size();
        }
        if (!((GraGraTreeModel)this.tree.getModel()).isValid(((GraGraTreeModel)this.tree.getModel()).getGraGraChildrenNames(this.eGra), name, "")) {
            name = name + "_";
        }
        EdAtomic newAtomic = this.eGra.createAtomic(name);
        GraGraTreeNodeData sd = new GraGraTreeNodeData(newAtomic);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(newNode);
        this.treeModel.insertNodeInto(newNode, parent, newIndex);
        newIndex = newAtomic.getConclusions().size() - 1;
        EdAtomic aConclusion = newAtomic.getConclusion(0);
        name = aConclusion.getMorph().getName();
        sd = new GraGraTreeNodeData(aConclusion, true);
        DefaultMutableTreeNode aNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(aNode);
        this.treeModel.insertNodeInto(aNode, newNode, newIndex);
        return newAtomic;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean addAtomic(EdGraGra gra, EdAtomic newAtomic) {
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                String s = "Bad selection.\n Please select a grammar.";
                JOptionPane.showMessageDialog(null, s);
                return false;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a grammar.");
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.eGra = this.getGraGra(parent);
        if (this.eGra != gra) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select the appropriate grammar.");
            return false;
        }
        this.eGra.addAtomic(newAtomic);
        int newIndex = this.eGra.getGraphs().size() + this.eGra.getRules().size() + this.eGra.getAtomics().size() - 1;
        if (this.eGra.getTypeSet().getTypeGraph() != null) {
            ++newIndex;
        }
        String name = newAtomic.getBasisAtomic().getName();
        GraGraTreeNodeData sd = new GraGraTreeNodeData(newAtomic);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(newNode);
        this.treeModel.insertNodeInto(newNode, parent, newIndex);
        int i = 0;
        while (i < newAtomic.getConclusions().size()) {
            EdAtomic aConclusion = newAtomic.getConclusion(i);
            sd = new GraGraTreeNodeData(aConclusion, true);
            DefaultMutableTreeNode aNode = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(aNode);
            this.treeModel.insertNodeInto(aNode, newNode, i);
            ++i;
        }
        return true;
    }

    public EdAtomic addConclusion() {
        if (this.selPath == null) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select an atomic.");
            return null;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)parent.getUserObject();
        if (!data.isAtomic) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select an atomic.");
            return null;
        }
        EdAtomic parentAtomic = data.getAtomic();
        TreePath graPath = this.selPath.getParentPath();
        DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
        this.handleRuleConstraints(graNode, false, parentAtomic);
        int newIndex = parentAtomic.getConclusions().size();
        String name = "Conclusion" + parentAtomic.getConclusions().size();
        EdAtomic newConclusion = parentAtomic.createNextConclusion(name);
        GraGraTreeNodeData sd = new GraGraTreeNodeData(newConclusion, true);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(newNode);
        this.treeModel.insertNodeInto(newNode, parent, newIndex);
        if (!this.tree.isExpanded(this.selPath)) {
            this.tree.expandPath(this.selPath);
        }
        return newConclusion;
    }

    public boolean addConclusion(EdAtomic atomic, EdAtomic newConclusion) {
        if (this.selPath == null) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select an atomic.");
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)parent.getUserObject();
        if (!data.isAtomic) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select an atomic.");
            return false;
        }
        EdAtomic parentAtomic = data.getAtomic();
        if (parentAtomic != atomic) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select the appropriate atomic.");
            return false;
        }
        TreePath graPath = this.selPath.getParentPath();
        DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
        this.handleRuleConstraints(graNode, false, parentAtomic);
        parentAtomic.addConclusion(newConclusion);
        int newIndex = parentAtomic.getConclusions().size();
        GraGraTreeNodeData sd = new GraGraTreeNodeData(newConclusion, true);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(newNode);
        this.treeModel.insertNodeInto(newNode, parent, newIndex - 1);
        if (!this.tree.isExpanded(this.selPath)) {
            this.tree.expandPath(this.selPath);
        }
        return true;
    }

    public void setTypeGraphLevel(int level) {
        DefaultMutableTreeNode parent;
        EdGraGra gragra;
        if (this.selPath == null && this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        }
        if ((gragra = this.getGraGra(parent = (DefaultMutableTreeNode)this.selPath.getPathComponent(1))).getTypeSet().getBasisTypeSet().getTypeGraph() == null) {
            JOptionPane.showMessageDialog(null, "The current grammar has not a type graph.", "Type Graph Error", 0);
            return;
        }
        Collection errors = gragra.setLevelOfTypeGraphCheck(level);
        if (errors.size() > 0) {
            int i;
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 21, ""));
            String message = "Cannot change the type graph mode.\n Some type mismatches found.";
            Iterator iter = errors.iterator();
            for (i = 0; iter.hasNext() && i < 20; ++i) {
                message = message + "\n" + ((TypeError)iter.next()).getMessage();
            }
            if (i >= 20 && iter.hasNext()) {
                message = message + "\n ... more undisplayed mismatches";
            }
            JOptionPane.showMessageDialog(null, message, "Type Graph Error", 0);
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
            GraGraTreeNodeData data = (GraGraTreeNodeData)node.getUserObject();
            if (data.isTypeGraph) {
                String mode = "";
                switch (gragra.getBasisGraGra().getTypeSet().getLevelOfTypeGraphCheck()) {
                    case 0: {
                        mode = "[D]";
                        break;
                    }
                    case 10: {
                        mode = "[E]";
                        break;
                    }
                    case 20: {
                        mode = "[Em]";
                        break;
                    }
                    case 30: {
                        mode = "[Emm]";
                        break;
                    }
                    default: {
                        mode = "[?]";
                    }
                }
                String str = mode + gragra.getTypeGraph().getBasisGraph().getName();
                data.setString(str);
                gragra.setChanged(true);
                this.repaint();
            }
        }
    }

    public void checkRuleApplicability() {
        if (this.selPath == null) {
            String s = "Bad selection.\n Please select a gragra.";
            JOptionPane.showMessageDialog(null, s);
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        EdGraGra gra = this.getGraGra(node);
        if (gra == null) {
            String s = "Yikes.  Internal brokeness.";
            JOptionPane.showMessageDialog(null, s);
            return;
        }
        this.fireTreeViewEvent(new TreeViewEvent(this, 18));
    }

    public void tickConvert(int i, int total) {
        String m = "Converting atom " + i + " from " + total + ".";
        TreeViewEvent e = new TreeViewEvent(this, 12);
        e.setMessage(m);
        this.fireTreeViewEvent(e);
    }

    public void checkOne() {
        if (this.selPath == null) {
            String s = "Bad selection.\n Please select an atomic constraint or a constraint (formula).";
            JOptionPane.showMessageDialog(null, s);
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)node.getUserObject();
        EdGraGra gra = this.getGraGra((DefaultMutableTreeNode)node.getParent());
        if (gra == null) {
            String s = "Yikes.  Internal brokeness.";
            JOptionPane.showMessageDialog(null, s);
            return;
        }
        TreeViewEvent e = new TreeViewEvent(this, 13);
        this.fireTreeViewEvent(e);
        boolean valid = false;
        boolean good = false;
        String thing = "BAD THING";
        boolean changed = gra.isChanged();
        if (data.isAtomic) {
            thing = "atomic";
            EdAtomic eatom = data.getAtomic();
            valid = eatom.getBasisAtomic().isValid();
            if (valid) {
                eatom.getBasisAtomic().setMorphismCompletionStrategy(gra.getBasisGraGra().getMorphismCompletionStrategy());
                good = eatom.getBasisAtomic().eval((Object)gra.getBasisGraGra().getGraph());
            }
        } else if (data.isConstraint) {
            thing = "constraint (formula)";
            EdConstraint econs = data.getConstraint();
            valid = econs.getBasisConstraint().isValid();
            if (valid) {
                gra.getBasisGraGra().putMorphismCompletionStrategyToGraphConstraints();
                good = econs.getBasisConstraint().eval(gra.getBasisGraGra().getGraph());
            }
        }
        String msg = !valid ? "This " + thing + " isn't valid.  No checking done." : (!good ? "The graph doesn't fulfill this " + thing + "." : "The graph fulfills this " + thing + ".");
        e = new TreeViewEvent(this, 14);
        e.setMessage(msg);
        this.fireTreeViewEvent(e);
        if (!msg.equals("")) {
            JOptionPane.showMessageDialog(null, msg);
        }
        gra.setChanged(changed);
    }

    public void doAtomics(int what) {
        if (this.selPath == null) {
            if (this.top.getChildCount() == 1) {
                this.tree.setSelectionRow(1);
                this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                this.setValueForNew(this.selPath);
            } else {
                String s = "Bad selection.\n Please select a grammar.";
                JOptionPane.showMessageDialog(null, s);
                return;
            }
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.eGra = this.getGraGra(parent);
        if (this.eGra == null) {
            if (this.top.getChildCount() == 1) {
                this.tree.setSelectionRow(1);
                this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                this.setValueForNew(this.selPath);
                parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
                this.eGra = this.getGraGra(parent);
            } else {
                JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a grammar.");
                return;
            }
        }
        if (this.eGra == null) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a grammar.");
            return;
        }
        switch (what) {
            case 0: {
                if (this.eGra.getBasisGraGra().getTypeSet().usesInheritance()) {
                    this.inheritanceWarning();
                    return;
                }
                this.handleRuleConstraints(parent, false, null);
                if (this.eGra.getBasisGraGra().getAtomics().hasMoreElements() && this.eGra.getBasisGraGra().getConstraints().hasMoreElements()) {
                    Thread thread = new Thread(){

                        public void run() {
                            GraGraTreeView.this.msg = GraGraTreeView.this.eGra.getBasisGraGra().convertConstraints();
                            GraGraTreeView.this.eGra.setChanged(true);
                        }
                    };
                    thread.start();
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 12, "Creating post application conditions ... Please wait."));
                    JOptionPane.showMessageDialog(null, "Creating post application conditions ... ");
                    int i = 0;
                    while (thread.isAlive()) {
                        ++i;
                    }
                    if (!this.msg.equals("")) {
                        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 12, "Cannot convert to post application conditions.  " + this.msg));
                        JOptionPane.showMessageDialog(null, "Cannot convert to post application conditions.\n" + this.msg);
                        break;
                    }
                    this.handleRuleConstraints(parent, true, null);
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 12, "Creating post application conditions ... done."));
                    break;
                }
                JOptionPane.showMessageDialog(null, "Cannot convert to post application conditions.\nAtomic constraints or constraints (formulae) don't exist.");
                break;
            }
            case 1: {
                boolean changed = this.eGra.isChanged();
                boolean all_good = false;
                TreeViewEvent e = new TreeViewEvent(this, 13);
                this.fireTreeViewEvent(e);
                boolean all_valid = this.eGra.getBasisGraGra().checkAtomics(true);
                if (all_valid) {
                    all_good = this.eGra.getBasisGraGra().checkAtomics(false);
                }
                this.msg = "";
                this.msg = !all_valid ? "Not all atomic constraints are valid \n(i.e. atomic morphism : total & injective,\n attribute value, condition ...).\nPlease check :\n(" + this.eGra.getBasisGraGra().getConsistencyErrorMsg() + ")" : (!all_good ? "All atomics are valid, \nbut the graph does not fulfill all of them.\n(" + this.eGra.getBasisGraGra().getConsistencyErrorMsg() + ")" : "The graph fulfills all atomic constraints.");
                e = new TreeViewEvent(this, 14);
                e.setMessage(this.msg);
                this.fireTreeViewEvent(e);
                if (!this.msg.equals("")) {
                    JOptionPane.showMessageDialog(null, this.msg);
                }
                this.eGra.setChanged(changed);
                break;
            }
            case 2: {
                boolean changed = this.eGra.isChanged();
                boolean all_good = false;
                TreeViewEvent e = new TreeViewEvent(this, 13);
                this.fireTreeViewEvent(e);
                this.eGra.getBasisGraGra().putMorphismCompletionStrategyToGraphConstraints();
                boolean all_valid = this.eGra.getBasisGraGra().checkGraphConstraints(true);
                if (all_valid) {
                    all_good = this.eGra.getBasisGraGra().checkGraphConstraints(false);
                }
                this.msg = !all_valid ? "Not all constraints were valid.\n Please check!.\n(" + this.eGra.getBasisGraGra().getConsistencyErrorMsg() + ")" : (!all_good ? "All constraints were valid, \nbut the graph does not fulfill all of them.\n(" + this.eGra.getBasisGraGra().getConsistencyErrorMsg() + ")" : "The graph fulfills all constraints.");
                e = new TreeViewEvent(this, 14);
                e.setMessage(this.msg);
                this.fireTreeViewEvent(e);
                if (!this.msg.equals("")) {
                    JOptionPane.showMessageDialog(null, this.msg);
                }
                this.eGra.setChanged(changed);
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doAtomicsOfRule() {
        block9: {
            if (this.selPath == null) {
                if (this.top.getChildCount() == 1 && ((DefaultMutableTreeNode)this.top.getChildAt(0)).getChildCount() == 2) {
                    this.tree.setSelectionRow(3);
                    this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                    this.setValueForNew(this.selPath);
                    break block9;
                } else {
                    JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a rule.");
                    return;
                }
            }
            if (this.top.getChildCount() == 1 && ((DefaultMutableTreeNode)this.top.getChildAt(0)).getChildCount() == 2) {
                this.tree.setSelectionRow(3);
                this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                this.setValueForNew(this.selPath);
            }
        }
        if (!this.newNACOK) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a rule.");
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.eRule = this.getRule(parent);
        if (this.eRule.getGraGra().getBasisGraGra().getTypeSet().usesInheritance()) {
            this.inheritanceWarning();
            return;
        }
        RuleConstraintsDialog ruleConstraintsDialog = new RuleConstraintsDialog(this.applFrame, this.eRule);
        ruleConstraintsDialog.showGUI();
        if (ruleConstraintsDialog.isCancelled()) return;
        if (ruleConstraintsDialog.getFormulas().isEmpty()) {
            JOptionPane.showMessageDialog(this.applFrame, "Bad selection.\n Please select a rule.");
            return;
        }
        this.handleRuleConstraints(parent, false, null);
        this.eRule.getBasisRule().setUsedFormulas(ruleConstraintsDialog.getFormulas());
        Thread thread = new Thread(){

            public void run() {
                GraGraTreeView.this.msg = GraGraTreeView.this.eRule.getBasisRule().convertUsedFormulas();
                GraGraTreeView.this.eRule.getGraGra().setChanged(true);
            }
        };
        thread.start();
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 12, "Creating post application conditions ... Please wait."));
        JOptionPane.showMessageDialog(this.applFrame, "Creating post application conditions ... ");
        int i = 0;
        while (thread.isAlive()) {
            ++i;
        }
        if (!this.msg.equals("")) {
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 12, "Cannot convert to post application conditions.  " + this.msg));
            JOptionPane.showMessageDialog(this.applFrame, "Cannot convert to post application conditions.\n" + this.msg);
            return;
        }
        this.handleRuleConstraints(parent, true, null);
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 12, "Creating post application conditions ... done."));
    }

    /*
     * Enabled aggressive block sorting
     */
    public EdConstraint addConstraint() {
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                String s = "Bad selection.\n Please select a grammar.";
                JOptionPane.showMessageDialog(null, s);
                return null;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a grammar.");
            return null;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.eGra = this.getGraGra(parent);
        int newIndex = this.eGra.getGraphs().size() + this.eGra.getRules().size() + this.eGra.getAtomics().size() + this.eGra.getConstraints().size();
        if (this.eGra.getTypeSet().getTypeGraph() != null) {
            ++newIndex;
        }
        String name = "Constraint";
        if (this.eGra.getConstraints().size() > 0) {
            name = name + this.eGra.getConstraints().size();
        }
        if (!((GraGraTreeModel)this.tree.getModel()).isValid(((GraGraTreeModel)this.tree.getModel()).getGraGraChildrenNames(this.eGra), name, "")) {
            name = name + "_";
        }
        EdConstraint newConstraint = this.eGra.createConstraint(name);
        this.handleRuleConstraints(parent, false, newConstraint);
        GraGraTreeNodeData sd = new GraGraTreeNodeData(newConstraint);
        if (this.layered && !newConstraint.getBasisConstraint().getLayer().isEmpty()) {
            String tag = "[" + newConstraint.getBasisConstraint().getLayerAsString() + "]";
            sd.setString(tag, name);
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(newNode);
        this.treeModel.insertNodeInto(newNode, parent, newIndex);
        return newConstraint;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean addConstraint(EdGraGra gra, EdConstraint newConstraint) {
        if (this.selPath == null) {
            if (this.top.getChildCount() != 1) {
                String s = "Bad selection.\n Please select a grammar.";
                JOptionPane.showMessageDialog(null, s);
                return false;
            }
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        } else if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
        }
        if (!this.newRuleOK) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a grammar.");
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.eGra = this.getGraGra(parent);
        if (this.eGra != gra) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select the appropriate grammar.");
            return false;
        }
        this.handleRuleConstraints(parent, false, newConstraint);
        this.eGra.addConstraint(newConstraint);
        int newIndex = this.eGra.getGraphs().size() + this.eGra.getRules().size() + this.eGra.getAtomics().size() + this.eGra.getConstraints().size() - 1;
        if (this.eGra.getTypeSet().getTypeGraph() != null) {
            ++newIndex;
        }
        String name = newConstraint.getName();
        GraGraTreeNodeData sd = new GraGraTreeNodeData(newConstraint);
        if (this.layered && !newConstraint.getBasisConstraint().getLayer().isEmpty()) {
            String tag = "[" + newConstraint.getBasisConstraint().getLayerAsString() + "]";
            sd.setString(tag, name);
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(newNode);
        this.treeModel.insertNodeInto(newNode, parent, newIndex);
        return true;
    }

    public void editConstraint() {
        if (this.selPath == null) {
            String s = "Bad selection.\n Please select a constraint to edit.";
            JOptionPane.showMessageDialog(null, s);
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        DefaultMutableTreeNode grand = (DefaultMutableTreeNode)parent.getParent();
        this.eGra = grand != null ? this.getGraGra(grand) : null;
        EdConstraint con = this.getConstraint(parent);
        if (this.eGra == null || con == null) {
            return;
        }
        FormulaDialog d = new FormulaDialog(null, "Edit Constraint (Formula)", true);
        String f = con.getBasisConstraint().getAsString(this.eGra.getBasisGraGra().getAtomicsVec());
        d.setVars(this.eGra.getAtomics(), f);
        d.setLocation(100, 100);
        d.setVisible(true);
        if (d.isChanged()) {
            this.handleRuleConstraints(grand, false, con);
            f = d.getFormula();
            con.getBasisConstraint().setFormula(this.eGra.getBasisGraGra().getAtomicsVec(), f);
            con.setVarSet(this.eGra.getBasisGraGra().getAtomicsVec(), this.eGra.getAtomicNames());
            con.update();
            this.eGra.setChanged(true);
        }
    }

    public void setInterpretStopMark() {
        if (this.selPath == null) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a grammar.");
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.eGra = this.getGraGra(parent);
        boolean gragraHasStopMark = false;
        for (int i = 0; i < this.eGra.getRules().size(); ++i) {
            if ((EdRule)this.eGra.getRules().elementAt(i) != null) continue;
            gragraHasStopMark = true;
            i = this.eGra.getRules().size();
        }
        if (gragraHasStopMark) {
            JOptionPane.showMessageDialog(null, "Stop mark is already set.\n You can delete or move it to reset the stop mark.");
            return;
        }
        int newIndex = parent.getChildCount();
        EdRule newRule = this.eGra.createRule(null);
        GraGraTreeNodeData sd = new GraGraTreeNodeData(stopMarkStr);
        DefaultMutableTreeNode newRuleNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(newRuleNode);
        this.treeModel.insertNodeInto(newRuleNode, parent, newIndex);
    }

    /*
     * Enabled aggressive block sorting
     */
    public EdNAC addNAC() {
        block8: {
            if (this.selPath == null) {
                if (this.top.getChildCount() == 1 && ((DefaultMutableTreeNode)this.top.getChildAt(0)).getChildCount() == 2) {
                    this.tree.setSelectionRow(3);
                    this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                    this.setValueForNew(this.selPath);
                    break block8;
                } else {
                    JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a rule.");
                    return null;
                }
            }
            if (this.top.getChildCount() == 1 && ((DefaultMutableTreeNode)this.top.getChildAt(0)).getChildCount() == 2) {
                this.tree.setSelectionRow(3);
                this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                this.setValueForNew(this.selPath);
            }
        }
        if (!this.newNACOK) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a rule.");
            return null;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.eRule = this.getRule(parent);
        int newIndex = parent.getChildCount();
        String name = "Nac";
        if (this.eRule.getNACs().size() > 0) {
            name = name + this.eRule.getNACs().size();
        }
        if (!((GraGraTreeModel)this.tree.getModel()).isValid(((GraGraTreeModel)this.tree.getModel()).getGraGraChildrenNames(this.eRule.getGraGra()), name, "")) {
            name = name + "_";
        }
        EdNAC newNAC = this.eRule.createNAC(name, false);
        GraGraTreeNodeData sd = new GraGraTreeNodeData(newNAC);
        DefaultMutableTreeNode newNACNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(newNACNode);
        this.treeModel.insertNodeInto(newNACNode, parent, newIndex);
        if (!this.tree.isExpanded(this.selPath)) {
            this.tree.expandPath(this.selPath);
        }
        return newNAC;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean addNAC(EdRule r, EdNAC newNAC) {
        block7: {
            if (this.selPath == null) {
                if (this.top.getChildCount() == 1 && ((DefaultMutableTreeNode)this.top.getChildAt(0)).getChildCount() == 2) {
                    this.tree.setSelectionRow(3);
                    this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                    this.setValueForNew(this.selPath);
                    break block7;
                } else {
                    JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a rule.");
                    return false;
                }
            }
            if (this.top.getChildCount() == 1 && ((DefaultMutableTreeNode)this.top.getChildAt(0)).getChildCount() == 2) {
                this.tree.setSelectionRow(3);
                this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                this.setValueForNew(this.selPath);
            }
        }
        if (!this.newNACOK) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a rule.");
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.eRule = this.getRule(parent);
        if (this.eRule != r) {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select the appropriate rule.");
            return false;
        }
        this.eRule.addNAC(newNAC);
        int newIndex = parent.getChildCount();
        String name = newNAC.getName();
        GraGraTreeNodeData sd = new GraGraTreeNodeData(newNAC);
        DefaultMutableTreeNode newNACNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(newNACNode);
        this.treeModel.insertNodeInto(newNACNode, parent, newIndex);
        if (!this.tree.isExpanded(this.selPath)) {
            this.tree.expandPath(this.selPath);
        }
        return true;
    }

    public void print() {
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 10, this.gragraPrint));
    }

    public void resetEnabled(boolean enable) {
        this.setEnabled(enable);
        this.file.setEnabled(enable);
    }

    public void moveRule() {
        if (this.tree.isExpanded(this.selPath)) {
            this.tree.collapsePath(this.selPath);
        }
        this.movedNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        this.tmpSelPath = this.tree.getSelectionPath();
        if (this.tmpSelPath == null) {
            this.movedNode = null;
            this.wasMoved = false;
            return;
        }
        this.tmpSelNode = (DefaultMutableTreeNode)this.tmpSelPath.getLastPathComponent();
        this.wasMoved = true;
        this.applFrame.setCursor(new Cursor(13));
    }

    public void setRuleLayer() {
        DefaultMutableTreeNode ruleNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData sd = (GraGraTreeNodeData)ruleNode.getUserObject();
        if (sd.isRule) {
            EdRule r = sd.getRule();
            String initLayer = String.valueOf(r.getBasisRule().getLayer());
            String layer = new String("-1");
            Integer i = new Integer(layer);
            while (i == null || i < 0) {
                layer = JOptionPane.showInputDialog(null, "Please input an integer value\nto set a rule layer", initLayer);
                if (layer == null) {
                    i = new Integer(initLayer);
                    break;
                }
                try {
                    i = new Integer(layer);
                }
                catch (NumberFormatException ex) {
                    i = null;
                }
            }
            if (r.getBasisRule().getLayer() != i.intValue()) {
                r.getBasisRule().setLayer(i);
                r.getGraGra().setChanged(true);
                r.getGraGra().getBasisGraGra().refreshConstraintsForLayer();
                if (this.layered) {
                    this.treeModel.ruleNameChanged(ruleNode, this.layered);
                    this.treeModel.nodeChanged(ruleNode);
                    this.treeModel.constraintNameChanged(r.getGraGra(), this.layered);
                    this.tree.treeDidChange();
                }
            }
        }
    }

    public void setConstraintLayer() {
        DefaultMutableTreeNode formulaNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData sd = (GraGraTreeNodeData)formulaNode.getUserObject();
        if (sd.isConstraint) {
            EdConstraint c = sd.getConstraint();
            Vector<Formula> v = new Vector<Formula>(1);
            v.add(c.getBasisConstraint());
            GraGraConstraintLayerGUI lg = new GraGraConstraintLayerGUI(this.applFrame, v, c.getGraGra().getBasisGraGra().getLayers());
            lg.setGraGra(c.getGraGra());
            lg.showGUI();
            if (!lg.isCancelled()) {
                c.getGraGra().setChanged(true);
                if (this.layered) {
                    this.treeModel.constraintNameChanged(c.getGraGra(), this.layered);
                    this.treeModel.nodeChanged(formulaNode);
                    this.tree.treeDidChange();
                }
            }
        }
    }

    public void showRuleAttrConditions(DefaultMutableTreeNode node) {
        if (node == null) {
            node = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        }
        GraGraTreeNodeData sd = (GraGraTreeNodeData)node.getUserObject();
        if (sd.isRule) {
            EdRule r = sd.getRule();
            int i = 0;
            while (i < node.getChildCount()) {
                DefaultMutableTreeNode delNode = (DefaultMutableTreeNode)node.getChildAt(i);
                GraGraTreeNodeData delData = (GraGraTreeNodeData)delNode.getUserObject();
                if (delData.isAttrCondition) {
                    this.treeModel.removeNodeFromParent(delNode);
                    continue;
                }
                ++i;
            }
            CondTuple conds = (CondTuple)r.getBasisRule().getAttrContext().getConditions();
            for (i = 0; i < conds.getSize(); ++i) {
                CondMember cond = (CondMember)conds.getMemberAt(i);
                String condStr = cond.getExprAsText();
                if (condStr == null || condStr.equals("")) continue;
                GraGraTreeNodeData conddata = new GraGraTreeNodeData(cond, r);
                conddata.setString(condStr);
                DefaultMutableTreeNode condchild = new DefaultMutableTreeNode(conddata);
                conddata.setTreeNode(condchild);
                this.treeModel.insertNodeInto(condchild, node, node.getChildCount());
            }
            this.treeModel.nodeChanged(node);
        }
    }

    public void showAtomicAttrConditions(DefaultMutableTreeNode node) {
        if (node == null) {
            node = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        }
        GraGraTreeNodeData sd = (GraGraTreeNodeData)node.getUserObject();
        if (sd.isConclusion) {
            EdAtomic a = sd.getConclusion();
            int i = 0;
            while (i < node.getChildCount()) {
                DefaultMutableTreeNode delNode = (DefaultMutableTreeNode)node.getChildAt(i);
                GraGraTreeNodeData delData = (GraGraTreeNodeData)delNode.getUserObject();
                if (delData.isAttrCondition) {
                    this.treeModel.removeNodeFromParent(delNode);
                    continue;
                }
                ++i;
            }
            CondTuple conds = (CondTuple)a.getBasisAtomic().getAttrContext().getConditions();
            for (i = 0; i < conds.getSize(); ++i) {
                CondMember cond = (CondMember)conds.getMemberAt(i);
                String condStr = cond.getExprAsText();
                if (condStr == null || condStr.equals("")) continue;
                GraGraTreeNodeData conddata = new GraGraTreeNodeData(cond, a);
                conddata.setString(condStr);
                DefaultMutableTreeNode condchild = new DefaultMutableTreeNode(conddata);
                conddata.setTreeNode(condchild);
                this.treeModel.insertNodeInto(condchild, node, node.getChildCount());
            }
            this.treeModel.nodeChanged(node);
        }
    }

    public void setLayerOfRules() {
        DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData sd = (GraGraTreeNodeData)graNode.getUserObject();
        if (sd.isGraGra) {
            EdGraGra gra = sd.getGraGra();
            RuleLayer rl = new RuleLayer(gra.getBasisGraGra().getRulesVec());
            GraGraLayerGUI lg = new GraGraLayerGUI(this.applFrame, rl);
            lg.setGraGra(gra);
            if (this.popupLocation != null) {
                lg.setLocation(this.popupLocation);
            }
            lg.showGUI();
            if (!lg.isCancelled() && lg.hasChanged()) {
                gra.setChanged(true);
                gra.getBasisGraGra().refreshConstraintsForLayer();
                if (this.layered) {
                    this.treeModel.ruleNameChanged(gra, this.layered);
                    this.treeModel.constraintNameChanged(gra, this.layered);
                    this.tree.treeDidChange();
                }
            }
        }
    }

    public void disableLayerOfRules() {
        DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData sd = (GraGraTreeNodeData)graNode.getUserObject();
        if (sd.isGraGra) {
            EdGraGra gra = sd.getGraGra();
            RuleLayer rl = new RuleLayer(gra.getBasisGraGra().getRulesVec());
            GraGraDisableLayerGUI lg = new GraGraDisableLayerGUI(this.applFrame, gra.getBasisGraGra().getLayers());
            lg.setGraGra(gra);
            if (this.popupLocation != null) {
                lg.setLocation(this.popupLocation);
            }
            lg.showGUI();
            if (!lg.isCancelled() && lg.hasChanged()) {
                gra.setChanged(true);
                this.treeModel.ruleNameChanged(gra, this.layered);
                this.tree.treeDidChange();
            }
        }
    }

    public void setLayerOfConstraints() {
        DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData sd = (GraGraTreeNodeData)graNode.getUserObject();
        if (sd.isGraGra) {
            EdGraGra gra = sd.getGraGra();
            if (gra.getBasisGraGra().getConstraintsVec().isEmpty()) {
                JOptionPane.showMessageDialog(null, "No graph constraints are available.");
            } else {
                ConstraintLayer cl = new ConstraintLayer(gra.getBasisGraGra().getConstraintsVec());
                GraGraConstraintLayerGUI lg = new GraGraConstraintLayerGUI(this.applFrame, gra.getBasisGraGra().getConstraintsVec(), gra.getBasisGraGra().getLayers());
                lg.setGraGra(gra);
                if (this.popupLocation != null) {
                    lg.setLocation(this.popupLocation);
                }
                lg.showGUI();
                if (!lg.isCancelled()) {
                    gra.setChanged(true);
                    if (this.layered) {
                        this.treeModel.constraintNameChanged(gra, this.layered);
                        this.tree.treeDidChange();
                    }
                }
            }
        }
    }

    public void sortRulesByLayer() {
        EdRule currRule = this.currentRule;
        DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.treeModel.getRoot();
        GraGraTreeNodeData sd = (GraGraTreeNodeData)graNode.getUserObject();
        if (sd.isGraGra) {
            EdGraGra gra = sd.getGraGra();
            int row = 0;
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                TreePath path = this.tree.getPathForRow(i);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (node != graNode) continue;
                if (this.tree.isExpanded(row)) {
                    this.tree.collapseRow(i);
                }
                row = i;
                break;
            }
            int indx = this.treeModel.getIndexOfChild(parent, graNode);
            graNode.removeAllChildren();
            this.treeModel.removeNodeFromParent(graNode);
            gra.sortRulesByLayer();
            GraGraTreeNodeData sdGra = new GraGraTreeNodeData(gra);
            graNode = new DefaultMutableTreeNode(sdGra);
            sdGra.setTreeNode(graNode);
            this.treeModel.insertNodeInto(graNode, parent, indx);
            this.putGraGraData(graNode, gra);
            this.treeModel.nodeChanged(graNode);
            if (indx == 0) {
                this.tree.expandRow(indx);
            }
            this.tree.expandRow(row);
            DefaultMutableTreeNode ruleNode = this.treeModel.getTreeNodeOfGraGraChild(graNode, currRule);
            if (ruleNode != null) {
                for (int i = 0; i < this.tree.getRowCount(); ++i) {
                    TreePath path = this.tree.getPathForRow(i);
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (!node.equals(ruleNode)) continue;
                    this.tree.setSelectionPath(path);
                }
            }
            this.treeModel.ruleNameChanged(gra, this.layered);
            this.treeModel.constraintNameChanged(gra, this.layered);
            this.tree.treeDidChange();
        }
    }

    public void setTriggerRuleOfLayer() {
        DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData sd = (GraGraTreeNodeData)graNode.getUserObject();
        if (sd.isGraGra) {
            EdGraGra gra = sd.getGraGra();
            RuleLayer rl = new RuleLayer(gra.getBasisGraGra().getRulesVec());
            GraGraTriggerRuleOfLayerGUI trlGUI = new GraGraTriggerRuleOfLayerGUI(this.applFrame, rl);
            trlGUI.setGraGra(gra);
            if (this.popupLocation != null) {
                trlGUI.setLocation(this.popupLocation);
            }
            trlGUI.showGUI();
            if (!trlGUI.isCancelled()) {
                gra.setChanged(true);
                if (this.layered) {
                    this.treeModel.ruleNameChanged(gra, this.layered);
                    this.tree.treeDidChange();
                }
            }
        }
    }

    public void sortConstraintsByLayer() {
        EdConstraint currConstraint = this.currentConstraint;
        DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.treeModel.getRoot();
        GraGraTreeNodeData sd = (GraGraTreeNodeData)graNode.getUserObject();
        if (sd.isGraGra) {
            EdGraGra gra = sd.getGraGra();
            int row = 0;
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                TreePath path = this.tree.getPathForRow(i);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (node != graNode) continue;
                if (this.tree.isExpanded(row)) {
                    this.tree.collapseRow(i);
                }
                row = i;
                break;
            }
            int indx = this.treeModel.getIndexOfChild(parent, graNode);
            graNode.removeAllChildren();
            this.treeModel.removeNodeFromParent(graNode);
            gra.sortConstraintsByLayer();
            GraGraTreeNodeData sdGra = new GraGraTreeNodeData(gra);
            graNode = new DefaultMutableTreeNode(sdGra);
            sdGra.setTreeNode(graNode);
            this.treeModel.insertNodeInto(graNode, parent, indx);
            this.putGraGraData(graNode, gra);
            this.treeModel.nodeChanged(graNode);
            if (indx == 0) {
                this.tree.expandRow(indx);
            }
            this.tree.expandRow(row);
            DefaultMutableTreeNode constraintNode = this.treeModel.getTreeNodeOfGraGraChild(graNode, currConstraint);
            if (constraintNode != null) {
                for (int i = 0; i < this.tree.getRowCount(); ++i) {
                    TreePath path = this.tree.getPathForRow(i);
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (!node.equals(constraintNode)) continue;
                    this.tree.setSelectionPath(path);
                }
            }
            this.treeModel.ruleNameChanged(gra, this.layered);
            this.treeModel.constraintNameChanged(gra, this.layered);
            this.tree.treeDidChange();
        }
    }

    private void resetGraGraData(DefaultMutableTreeNode graNode, EdGraGra gragra) {
        GraGraTreeNodeData sd = null;
        DefaultMutableTreeNode node = null;
        EdGraph typeGraph = gragra.getTypeSet().getTypeGraph();
        if (typeGraph != null) {
            sd = new GraGraTreeNodeData(typeGraph, true);
            node = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(node);
            sd.setString(typeGraph.getBasisGraph().getName());
            this.treeModel.insertNodeInto(node, graNode, graNode.getChildCount());
        }
        sd = new GraGraTreeNodeData(gragra.getGraph());
        sd.setTreeNode(node);
        sd.setString(gragra.getGraph().getBasisGraph().getName());
        node = new DefaultMutableTreeNode(sd);
        this.treeModel.insertNodeInto(node, graNode, graNode.getChildCount());
    }

    public void showNAC() {
        this.editorPath = this.selPath;
        this.setCurrentData(this.editorPath);
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 8, this.editorPath));
    }

    public void hideNAC() {
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData sd = (GraGraTreeNodeData)aNode.getUserObject();
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 9, this.editorPath));
    }

    public Vector getGraGraNames() {
        return ((GraGraTreeModel)this.tree.getModel()).getGraGraNames();
    }

    public EdGraGra getGraGra(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isGraGra) {
            return data.getGraGra();
        }
        return null;
    }

    public EdGraph getGraph(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isGraph) {
            return data.getGraph();
        }
        return null;
    }

    public EdAtomic getAtomic(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isAtomic) {
            return data.getAtomic();
        }
        return null;
    }

    public EdAtomic getConclusion(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isConclusion) {
            return data.getConclusion();
        }
        return null;
    }

    public EdConstraint getConstraint(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isConstraint) {
            return data.getConstraint();
        }
        return null;
    }

    public EdRule getRule(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isRule) {
            return data.getRule();
        }
        return null;
    }

    public EdNAC getNAC(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isNAC) {
            return data.getNAC();
        }
        return null;
    }

    public Pair getRuleContext(DefaultMutableTreeNode n) {
        Pair context = null;
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isAttrCondition) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)n.getParent();
            if (parent == null) {
                return null;
            }
            GraGraTreeNodeData sd = (GraGraTreeNodeData)parent.getUserObject();
            if (sd.isRule) {
                Vector attrconds = sd.getRule().getAttrConditions();
                context = new Pair(sd.getRule(), attrconds);
            }
        }
        return context;
    }

    public Pair getConclusionContext(DefaultMutableTreeNode n) {
        Pair context = null;
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isAttrCondition) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)n.getParent();
            if (parent == null) {
                return null;
            }
            GraGraTreeNodeData sd = (GraGraTreeNodeData)parent.getUserObject();
            if (sd.isConclusion) {
                Vector attrconds = sd.getConclusion().getAttrConditions();
                context = new Pair(sd.getConclusion(), attrconds);
            }
        }
        return context;
    }

    public EdRuleConstraint getRuleConstraint(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isRuleConstraint) {
            return data.getRuleConstraint();
        }
        return null;
    }

    public EdAtomApplCond getAtomApplCond(DefaultMutableTreeNode n) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)n.getUserObject();
        if (data.isAtomApplCond) {
            return data.getAtomApplCond();
        }
        return null;
    }

    public Vector getGraGras() {
        Vector<EdGraGra> gragras = new Vector<EdGraGra>();
        for (int i = 0; i < this.top.getChildCount(); ++i) {
            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.top.getChildAt(i);
            GraGraTreeNodeData data = (GraGraTreeNodeData)aNode.getUserObject();
            if (!data.isGraGra) continue;
            gragras.addElement(data.getGraGra());
        }
        return gragras;
    }

    public void copy(String menuItemString) {
        if (this.selPath == null) {
            JOptionPane.showMessageDialog(null, "Bad selection.\nPlease select a rule.");
            return;
        }
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        if (aNode == null) {
            return;
        }
        GraGraTreeNodeData sd = (GraGraTreeNodeData)aNode.getUserObject();
        if (sd == null) {
            return;
        }
        if (!menuItemString.equals("") && menuItemString.equals("Rule")) {
            if (sd.isRule) {
                this.copyRule(aNode);
            } else {
                JOptionPane.showMessageDialog(null, "Bad selection.\nPlease select a rule.");
            }
        }
    }

    private void copyRule(DefaultMutableTreeNode node) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)node.getUserObject();
        TreePath graPath = null;
        TreePath path = null;
        if (this.selPath == null) {
            String s = "Bad selection.\n Please select a rule.";
            JOptionPane.showMessageDialog(null, s);
            return;
        }
        graPath = this.selPath.getParentPath();
        path = this.selPath;
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            EdRule ruleClone = graData.getGraGra().cloneRule(data.getRule());
            GraGraTreeNodeData sd = new GraGraTreeNodeData(ruleClone);
            DefaultMutableTreeNode ruleCloneNode = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(ruleCloneNode);
            this.treeModel.insertNodeInto(ruleCloneNode, (DefaultMutableTreeNode)node.getParent(), ((DefaultMutableTreeNode)node.getParent()).getIndex(node) + 1);
            Enumeration nacs = ruleClone.getNACs().elements();
            int indx = 0;
            while (nacs.hasMoreElements()) {
                EdNAC aNAC = (EdNAC)nacs.nextElement();
                GraGraTreeNodeData sdn = new GraGraTreeNodeData(aNAC);
                DefaultMutableTreeNode aNACNode = new DefaultMutableTreeNode(sdn);
                sdn.setTreeNode(aNACNode);
                this.treeModel.insertNodeInto(aNACNode, ruleCloneNode, indx);
                ++indx;
            }
            CondTuple conds = (CondTuple)ruleClone.getBasisRule().getAttrContext().getConditions();
            for (int c = 0; c < conds.getSize(); ++c) {
                CondMember cond = (CondMember)conds.getMemberAt(c);
                String condStr = cond.getExprAsText();
                GraGraTreeNodeData conddata = new GraGraTreeNodeData(cond, ruleClone);
                conddata.setString(condStr);
                DefaultMutableTreeNode condchild = new DefaultMutableTreeNode(conddata);
                conddata.setTreeNode(condchild);
                this.treeModel.insertNodeInto(condchild, ruleCloneNode, ruleCloneNode.getChildCount());
            }
            this.treeModel.ruleNameChanged(ruleCloneNode, this.layered);
            this.tree.treeDidChange();
        }
    }

    private void copyRule() {
        DefaultMutableTreeNode node = null;
        GraGraTreeNodeData data = null;
        TreePath graPath = null;
        TreePath path = null;
        if (this.selPath == null) {
            String s = "Bad selection.\n Please select a rule.";
            JOptionPane.showMessageDialog(null, s);
            return;
        }
        node = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        data = (GraGraTreeNodeData)node.getUserObject();
        graPath = this.selPath.getParentPath();
        path = this.selPath;
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            EdRule ruleClone = graData.getGraGra().cloneRule(data.getRule());
            GraGraTreeNodeData sd = new GraGraTreeNodeData(ruleClone);
            DefaultMutableTreeNode ruleCloneNode = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(ruleCloneNode);
            this.treeModel.insertNodeInto(ruleCloneNode, (DefaultMutableTreeNode)node.getParent(), ((DefaultMutableTreeNode)node.getParent()).getIndex(node) + 1);
            Enumeration nacs = ruleClone.getNACs().elements();
            int indx = 0;
            while (nacs.hasMoreElements()) {
                EdNAC aNAC = (EdNAC)nacs.nextElement();
                GraGraTreeNodeData sdn = new GraGraTreeNodeData(aNAC);
                DefaultMutableTreeNode aNACNode = new DefaultMutableTreeNode(sdn);
                sdn.setTreeNode(aNACNode);
                this.treeModel.insertNodeInto(aNACNode, ruleCloneNode, indx);
                ++indx;
            }
            CondTuple conds = (CondTuple)ruleClone.getBasisRule().getAttrContext().getConditions();
            for (int c = 0; c < conds.getSize(); ++c) {
                CondMember cond = (CondMember)conds.getMemberAt(c);
                String condStr = cond.getExprAsText();
                GraGraTreeNodeData conddata = new GraGraTreeNodeData(cond, ruleClone);
                conddata.setString(condStr);
                DefaultMutableTreeNode condchild = new DefaultMutableTreeNode(conddata);
                conddata.setTreeNode(condchild);
                this.treeModel.insertNodeInto(condchild, ruleCloneNode, ruleCloneNode.getChildCount());
            }
            this.treeModel.ruleNameChanged(ruleCloneNode, this.layered);
            this.tree.treeDidChange();
        }
    }

    public void disable(String menuItemString, boolean disable) {
        if (this.selPath == null) {
            JOptionPane.showMessageDialog(null, "Bad selection.\nPlease select a rule.");
            return;
        }
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        if (aNode == null) {
            return;
        }
        GraGraTreeNodeData sd = (GraGraTreeNodeData)aNode.getUserObject();
        if (sd == null) {
            return;
        }
        if (menuItemString.equals("Rule")) {
            if (sd.isRule) {
                if (disable) {
                    if (this.layered) {
                        sd.setString("[D]", "[" + sd.getRule().getBasisRule().getLayer() + "]", sd.getRule().getBasisRule().getName());
                    } else {
                        sd.setString("[D]", sd.getRule().getBasisRule().getName());
                    }
                } else if (this.layered) {
                    sd.setString("", "[" + sd.getRule().getBasisRule().getLayer() + "]", sd.getRule().getBasisRule().getName());
                } else {
                    sd.setString("", sd.getRule().getBasisRule().getName());
                }
                sd.getRule().getBasisRule().setEnabled(!disable);
                this.treeModel.nodeChanged(aNode);
                this.tree.treeDidChange();
            } else {
                JOptionPane.showMessageDialog(null, "Bad selection.\nPlease select a rule.");
            }
        }
    }

    public void deleteInterpretStopMark() {
        DefaultMutableTreeNode delNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        GraGraTreeNodeData sd = (GraGraTreeNodeData)delNode.getUserObject();
        if (sd.isStop) {
            DefaultMutableTreeNode parentGraGra = (DefaultMutableTreeNode)delNode.getParent();
            GraGraTreeNodeData sdParent = (GraGraTreeNodeData)parentGraGra.getUserObject();
            if (sdParent.isGraGra) {
                this.treeModel.removeNodeFromParent(delNode);
                sdParent.getGraGra().removeRule(sd.getRule());
                this.selPath = this.tree.getSelectionPath();
            }
        }
    }

    public void delete() {
        this.delete("");
    }

    public void delete(String menuItemString) {
        if (this.selPath == null) {
            JOptionPane.showMessageDialog(null, "Bad selection for deletion.");
            return;
        }
        if (!menuItemString.equals("GraGra") && !this.currentGraGra.getGraph().isEditable()) {
            return;
        }
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        if (aNode == null) {
            JOptionPane.showMessageDialog(null, "Cannot delete. Data is not defined.");
            return;
        }
        GraGraTreeNodeData sd = (GraGraTreeNodeData)aNode.getUserObject();
        if (sd == null) {
            JOptionPane.showMessageDialog(null, "Cannot delete. Data is not defined.");
            return;
        }
        if (!menuItemString.equals("")) {
            if (menuItemString.equals("GraGra")) {
                if (sd.isGraGra) {
                    this.deleteGraGra(aNode);
                } else {
                    JOptionPane.showMessageDialog(null, "Bad selection.\nPlease select a grammar");
                }
            } else if (menuItemString.equals("TypeGraph")) {
                if (sd.isTypeGraph) {
                    this.deleteTypeGraph(aNode);
                } else {
                    JOptionPane.showMessageDialog(null, "Bad selection.\nPlease select a type graph.");
                }
            } else if (menuItemString.equals("Graph")) {
                if (sd.isGraph && !sd.isTypeGraph) {
                    this.deleteGraph(aNode);
                } else {
                    JOptionPane.showMessageDialog(null, "Bad selection.\nPlease select a graph.");
                }
            } else if (menuItemString.equals("Rule")) {
                if (sd.isRule) {
                    this.deleteRule(aNode);
                } else {
                    JOptionPane.showMessageDialog(null, "Bad selection.\nPlease select a rule.");
                }
            } else if (menuItemString.equals("NAC")) {
                if (sd.isNAC) {
                    this.deleteNAC(aNode);
                } else {
                    JOptionPane.showMessageDialog(null, "Bad selection.\nPlease select a NAC.");
                }
            } else if (menuItemString.equals("Atomic")) {
                if (sd.isAtomic) {
                    this.deleteAtomic(aNode);
                } else {
                    JOptionPane.showMessageDialog(null, "Bad selection.\nPlase select an atomic graph constraint.");
                }
            } else if (menuItemString.equals("Conclusion")) {
                if (sd.isConclusion) {
                    this.deleteConclusion(aNode);
                } else {
                    JOptionPane.showMessageDialog(null, "Bad selection,\nPlease select a conclusion.");
                }
            } else if (menuItemString.equals("Constraint")) {
                if (sd.isConstraint) {
                    this.deleteConstraint(aNode);
                } else {
                    JOptionPane.showMessageDialog(null, "Bad selection.\nPlease select a constraint.");
                }
            } else if (menuItemString.equals("RuleConstraint")) {
                if (sd.isRuleConstraint) {
                    this.deleteRuleConstraint(aNode);
                } else {
                    JOptionPane.showMessageDialog(null, "Bad selection.\nPlease select a rule post application constraint.");
                }
            } else if (menuItemString.equals("AtomApplCond")) {
                if (sd.isAtomApplCond) {
                    this.deleteAtomApplCond(aNode);
                } else {
                    JOptionPane.showMessageDialog(null, "Bad selection.\nPlease select a rule atomic post application condition.");
                }
            } else if (menuItemString.equals("RuleConstraints")) {
                if (sd.isRule) {
                    this.deleteRuleConstraints(aNode);
                } else {
                    JOptionPane.showMessageDialog(null, "Bad selection.\nPlease select a rule.");
                }
            } else {
                JOptionPane.showMessageDialog(null, "Bad selection for deletion.");
            }
        } else if (sd.isGraGra) {
            this.deleteGraGra(aNode);
        } else if (sd.isTypeGraph) {
            this.deleteTypeGraph(aNode);
        } else if (sd.isGraph && !sd.isTypeGraph) {
            this.deleteGraph(aNode);
        } else if (sd.isRule) {
            this.deleteRule(aNode);
        } else if (sd.isNAC) {
            this.deleteNAC(aNode);
        } else if (sd.isAtomic) {
            this.deleteAtomic(aNode);
        } else if (sd.isConclusion) {
            this.deleteConclusion(aNode);
        } else if (sd.isConstraint) {
            this.deleteConstraint(aNode);
        } else if (sd.isRuleConstraint) {
            this.deleteRuleConstraint(aNode);
        } else if (sd.isAtomApplCond) {
            this.deleteAtomApplCond(aNode);
        } else {
            JOptionPane.showMessageDialog(null, "Bad selection for deletion.");
        }
    }

    private void deleteGraGra(DefaultMutableTreeNode delNode) {
        GraGraTreeNodeData sd = (GraGraTreeNodeData)delNode.getUserObject();
        if (sd.getGraGra() != this.currentGraGra) {
            if (sd.getGraGra().isChanged() && this.changedGraGraWarning("CLOSE") != 0) {
                return;
            }
            this.storeGraGra.removeGraGra(sd.getGraGra());
            this.treeModel.removeNodeFromParent(delNode);
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, this.selPath));
            sd.getGraGra().dispose();
            sd = null;
            delNode = null;
            this.selPath = null;
        } else {
            if (this.currentGraGra.isChanged() && this.changedGraGraWarning("CLOSE") != 0) {
                return;
            }
            this.storeGraGra.removeGraGra(sd.getGraGra());
            this.treeModel.removeNodeFromParent(delNode);
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, this.selPath));
            sd.getGraGra().dispose();
            sd = null;
            delNode = null;
            this.selPath = null;
            this.currentGraGra = null;
            this.currentGraph = null;
            this.currentRule = null;
            this.currentNAC = null;
            this.currentAtomic = null;
            this.currentConstraint = null;
            this.currentRuleConstraint = null;
            this.currentAtomApplCond = null;
        }
    }

    private void deleteGraph(DefaultMutableTreeNode delNode) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath graPath = null;
        TreePath delPath = null;
        if (this.selPath == null) {
            String s = "Bad selection.\n Please select a graph.";
            JOptionPane.showMessageDialog(null, s);
            return;
        }
        graPath = this.selPath.getParentPath();
        delPath = this.selPath;
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            if (graData.getGraGra().getGraphs().size() > 1) {
                if (data.getGraph() != this.currentGraph) {
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, delPath));
                    this.treeModel.removeNodeFromParent(delNode);
                    this.storeGraGra.storeGraph(graData.getGraGra(), data.getGraph());
                    graData.getGraGra().removeGraph(data.getGraph());
                    this.selPath = this.tree.getSelectionPath();
                    this.tree.setSelectionPath(this.selPath);
                } else {
                    int row = this.tree.getRowForPath(delPath);
                    int answer = this.removeWarning("Host Graph");
                    if (answer == 0) {
                        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, delPath));
                        this.treeModel.removeNodeFromParent(delNode);
                        this.storeGraGra.storeGraph(graData.getGraGra(), data.getGraph());
                        graData.getGraGra().removeGraph(data.getGraph());
                        this.setEditPath(row);
                        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                    }
                }
            } else {
                JOptionPane.showMessageDialog(null, "Cannot delete. At least one host graph should exist.");
                return;
            }
            graData.getGraGra().setChanged(true);
        }
    }

    private void setEditPath(int row) {
        if (row < 0) {
            row = 0;
        } else if (this.tree.getPathForRow(this.tree.getMinSelectionRow()) == null) {
            --row;
        }
        this.tree.setSelectionRow(row);
        this.tree.treeDidChange();
        this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
        if (this.selPath != null) {
            this.editorPath = this.selPath;
            this.setCurrentData(this.editorPath);
        }
    }

    private void deleteTypeGraph(DefaultMutableTreeNode delNode) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath graPath = null;
        TreePath delPath = null;
        if (this.selPath == null) {
            String s = "Bad selection.\n Please select a type graph.";
            JOptionPane.showMessageDialog(null, s);
            return;
        }
        graPath = this.selPath.getParentPath();
        delPath = this.selPath;
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            if (graData.getGraGra().getBasisGraGra().getLevelOfTypeGraphCheck() == 0) {
                if (data.isTypeGraph && data.getGraph() != this.currentGraph) {
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, delPath));
                    this.treeModel.removeNodeFromParent(delNode);
                    this.storeGraGra.storeTypeGraph(graData.getGraGra(), graData.getGraGra().getTypeGraph());
                    graData.getGraGra().removeTypeGraph();
                    this.selPath = this.tree.getSelectionPath();
                } else {
                    int row = this.tree.getRowForPath(delPath);
                    int answer = this.removeWarning("Type Graph");
                    if (answer == 0) {
                        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, delPath));
                        this.treeModel.removeNodeFromParent(delNode);
                        this.storeGraGra.storeTypeGraph(graData.getGraGra(), graData.getGraGra().getTypeGraph());
                        graData.getGraGra().removeTypeGraph();
                        this.currentGraph = graData.getGraGra().getGraph();
                        this.setEditPath(row);
                        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                    }
                }
                graData.getGraGra().setChanged(true);
            } else {
                JOptionPane.showMessageDialog(null, "Please disable the type graph first.");
            }
        }
    }

    private void deleteRule(DefaultMutableTreeNode delNode) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath graPath = null;
        TreePath delPath = null;
        if (this.selPath == null) {
            String s = "Bad selection.\n Please select a rule.";
            JOptionPane.showMessageDialog(null, s);
            return;
        }
        graPath = this.selPath.getParentPath();
        delPath = this.selPath;
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            if (data.getRule() != this.currentRule) {
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, delPath));
                this.treeModel.removeNodeFromParent(delNode);
                EdRule r = data.getRule();
                this.storeGraGra.storeRule(r.getGraGra(), r);
                graData.getGraGra().removeRule(r);
                this.selPath = this.tree.getSelectionPath();
            } else {
                int row = this.tree.getRowForPath(delPath);
                int answer = this.removeWarning("Rule");
                if (answer == 0) {
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, delPath));
                    this.treeModel.removeNodeFromParent(delNode);
                    EdRule r = data.getRule();
                    this.storeGraGra.storeRule(r.getGraGra(), r);
                    graData.getGraGra().removeRule(r);
                    this.setEditPath(row);
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                }
            }
        }
    }

    private void deleteAtomic(DefaultMutableTreeNode delNode) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath graPath = null;
        TreePath delPath = null;
        if (this.selPath == null) {
            if (this.tree.getSelectionPath() != null) {
                graPath = this.tree.getSelectionPath().getParentPath();
                delPath = this.tree.getSelectionPath();
            }
        } else {
            graPath = this.selPath.getParentPath();
            delPath = this.selPath;
        }
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            if (data.getAtomic() == this.currentAtomic && delPath == this.tree.getSelectionPath()) {
                int row = this.tree.getRowForPath(delPath);
                int answer = this.removeWarning("Atomic");
                if (answer == 0) {
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, delPath));
                    this.handleRuleConstraints(graNode, false, this.currentAtomic);
                    this.treeModel.removeNodeFromParent(delNode);
                    if (graData.isGraGra) {
                        this.storeGraGra.storeAtomConstraint(graData.getGraGra(), data.getAtomic());
                        graData.getGraGra().removeAtomic(data.getAtomic());
                    }
                    this.setEditPath(row);
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                }
            } else {
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, delPath));
                this.handleRuleConstraints(graNode, false, this.currentAtomic);
                this.treeModel.removeNodeFromParent(delNode);
                if (graData.isGraGra) {
                    this.storeGraGra.storeAtomConstraint(graData.getGraGra(), data.getAtomic());
                    graData.getGraGra().removeAtomic(data.getAtomic());
                }
                this.selPath = this.tree.getSelectionPath();
            }
        }
    }

    private void deleteConclusion(DefaultMutableTreeNode delNode) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath atomicPath = null;
        TreePath delPath = null;
        if (this.selPath == null) {
            String s = "Bad selection.\n Please select a conclusion.";
            JOptionPane.showMessageDialog(null, s);
            return;
        }
        atomicPath = this.selPath.getParentPath();
        delPath = this.selPath;
        if (atomicPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)atomicPath.getParentPath().getLastPathComponent();
            DefaultMutableTreeNode atomicNode = (DefaultMutableTreeNode)atomicPath.getLastPathComponent();
            GraGraTreeNodeData atomicData = (GraGraTreeNodeData)atomicNode.getUserObject();
            if (data.getConclusion().getParent().getConclusions().size() > 1) {
                if (data.getConclusion() == this.currentConclusion && delPath == this.tree.getSelectionPath()) {
                    int row = this.tree.getRowForPath(delPath);
                    int answer = this.removeWarning("Conclusion");
                    if (answer == 0) {
                        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, delPath));
                        this.handleRuleConstraints(graNode, false, atomicData.getAtomic());
                        this.treeModel.removeNodeFromParent(delNode);
                        this.storeGraGra.storeAtomConclusion(data.getAtomic().getParent(), data.getAtomic());
                        atomicData.getAtomic().removeConclusion(data.getAtomic());
                        this.setEditPath(row);
                        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                    }
                } else {
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, delPath));
                    this.handleRuleConstraints(graNode, false, atomicData.getAtomic());
                    this.treeModel.removeNodeFromParent(delNode);
                    this.storeGraGra.storeAtomConclusion(data.getAtomic().getParent(), data.getAtomic());
                    atomicData.getAtomic().removeConclusion(data.getAtomic());
                    this.selPath = this.tree.getSelectionPath();
                    this.tree.setSelectionPath(this.selPath);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Cannot delete. At least one conclusion should exist.");
                return;
            }
        }
    }

    private void deleteConstraint(DefaultMutableTreeNode delNode) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath graPath = null;
        TreePath delPath = null;
        if (this.selPath == null) {
            String s = "Bad selection.\n Please select a consistency constraint.";
            JOptionPane.showMessageDialog(null, s);
            return;
        }
        graPath = this.selPath.getParentPath();
        delPath = this.selPath;
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            if (data.getConstraint() != this.currentConstraint) {
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, delPath));
                this.handleRuleConstraints(graNode, false, data.getConstraint());
                this.treeModel.removeNodeFromParent(delNode);
                this.storeGraGra.storeConstraint(graData.getGraGra(), data.getConstraint());
                graData.getGraGra().removeConstraint(data.getConstraint());
                this.selPath = this.tree.getSelectionPath();
            } else {
                int row = this.tree.getRowForPath(delPath);
                int answer = this.removeWarning("Constraint");
                if (answer == 0) {
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, delPath));
                    this.handleRuleConstraints(graNode, false, data.getConstraint());
                    this.treeModel.removeNodeFromParent(delNode);
                    this.storeGraGra.storeConstraint(graData.getGraGra(), data.getConstraint());
                    graData.getGraGra().removeConstraint(data.getConstraint());
                    this.setEditPath(row);
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                }
            }
        }
    }

    public void deleteRuleConstraint(DefaultMutableTreeNode delNode) {
        TreePath rulePath = null;
        TreePath delPath = null;
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        if (this.selPath == null) {
            String s = "Bad selection.\n Please select a rule constraint.";
            JOptionPane.showMessageDialog(null, s);
            return;
        }
        rulePath = this.selPath.getParentPath();
        delPath = this.selPath;
        if (rulePath != null) {
            if (!data.isRuleConstraint) {
                String s = "Bad selection.\n Please select a rule constraint.";
                JOptionPane.showMessageDialog(null, s);
                return;
            }
            if (data.getRuleConstraint() != null) {
                EdRuleConstraint ruleConstr = data.getRuleConstraint();
                DefaultMutableTreeNode ruleNode = (DefaultMutableTreeNode)rulePath.getLastPathComponent();
                GraGraTreeNodeData ruleData = (GraGraTreeNodeData)ruleNode.getUserObject();
                if (ruleConstr != this.currentRuleConstraint) {
                    this.treeModel.removeNodeFromParent(delNode);
                    ruleData.getRule().getBasisRule().removeConstraint(ruleConstr.getConstraint());
                    ruleData.getRule().getGraGra().setChanged(true);
                    this.selPath = this.tree.getSelectionPath();
                    this.tree.setSelectionPath(this.selPath);
                } else {
                    int row = this.tree.getRowForPath(delPath);
                    this.treeModel.removeNodeFromParent(delNode);
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, this.selPath));
                    ruleData.getRule().getBasisRule().removeConstraint(ruleConstr.getConstraint());
                    ruleData.getRule().getGraGra().setChanged(true);
                    this.setEditPath(row);
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                }
            }
        }
    }

    public void deleteAtomApplCond(DefaultMutableTreeNode delNode) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        if (this.selPath == null) {
            String s = "Bad selection.\n Please select an atomic application condition.";
            JOptionPane.showMessageDialog(null, s);
            return;
        }
        if (!data.isAtomApplCond) {
            String s = "Bad selection.\n Please select an atomic application condition.";
            JOptionPane.showMessageDialog(null, s);
            return;
        }
        if (data.getAtomApplCond() != null) {
            EdAtomApplCond aac = data.getAtomApplCond();
            TreeNode parent = delNode.getParent();
            if (parent.getChildCount() == 1) {
                return;
            }
            TreePath rulePath = this.selPath.getParentPath().getParentPath();
            DefaultMutableTreeNode ruleNode = (DefaultMutableTreeNode)rulePath.getLastPathComponent();
            GraGraTreeNodeData ruleData = (GraGraTreeNodeData)ruleNode.getUserObject();
            if (aac != this.currentAtomApplCond) {
                this.treeModel.removeNodeFromParent(delNode);
                ruleData.getRule().getBasisRule().removeAtomApplCond(aac.getAtomApplCond());
                this.selPath = null;
            } else {
                this.treeModel.removeNodeFromParent(delNode);
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, this.selPath));
                ruleData.getRule().getBasisRule().removeAtomApplCond(aac.getAtomApplCond());
                this.selPath = null;
                this.currentAtomApplCond = null;
            }
        }
    }

    public void deleteRuleConstraints(DefaultMutableTreeNode ruleNode) {
        TreePath rulePath = null;
        TreePath delPath = null;
        if (this.selPath == null) {
            String s = "Bad selection.\n Please select a rule.";
            JOptionPane.showMessageDialog(null, s);
            return;
        }
        rulePath = this.selPath.getParentPath();
        delPath = this.selPath;
        if (rulePath != null) {
            GraGraTreeNodeData ruleData = (GraGraTreeNodeData)ruleNode.getUserObject();
            if (!ruleData.isRule) {
                String s = "Bad selection.\n Please select a rule.";
                JOptionPane.showMessageDialog(null, s);
                return;
            }
            if (ruleData.getRule().getBasisRule().getAtomApplConds().size() != 0) {
                int i = 0;
                while (i < ruleNode.getChildCount()) {
                    DefaultMutableTreeNode delNode = (DefaultMutableTreeNode)ruleNode.getChildAt(i);
                    GraGraTreeNodeData delData = (GraGraTreeNodeData)delNode.getUserObject();
                    if (delData.isRuleConstraint) {
                        this.treeModel.removeNodeFromParent(delNode);
                        continue;
                    }
                    ++i;
                }
                ruleData.getRule().getBasisRule().removeApplConditions();
                ruleData.getRule().getGraGra().setChanged(true);
                this.currentRuleConstraint = null;
                this.currentAtomApplCond = null;
            }
        }
    }

    private void deleteNAC(DefaultMutableTreeNode delNode) {
        GraGraTreeNodeData data = (GraGraTreeNodeData)delNode.getUserObject();
        TreePath rulePath = null;
        TreePath delPath = null;
        if (this.selPath == null) {
            String s = "Bad selection.\n Please select a NAC.";
            JOptionPane.showMessageDialog(null, s);
            return;
        }
        rulePath = this.selPath.getParentPath();
        delPath = this.selPath;
        if (rulePath != null) {
            DefaultMutableTreeNode ruleNode = (DefaultMutableTreeNode)rulePath.getLastPathComponent();
            GraGraTreeNodeData ruleData = (GraGraTreeNodeData)ruleNode.getUserObject();
            if (data.getNAC() != this.currentNAC) {
                this.treeModel.removeNodeFromParent(delNode);
                EdNAC nac = data.getNAC();
                this.storeGraGra.storeNAC(nac.getRule(), nac);
                ruleData.getRule().removeNAC(nac);
                this.selPath = this.tree.getSelectionPath();
                this.tree.setSelectionPath(this.selPath);
            } else {
                int row = this.tree.getRowForPath(delPath);
                int answer = this.removeWarning("NAC");
                if (answer == 0) {
                    this.treeModel.removeNodeFromParent(delNode);
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, this.selPath));
                    EdNAC nac = data.getNAC();
                    this.storeGraGra.storeNAC(nac.getRule(), nac);
                    ruleData.getRule().removeNAC(nac);
                    this.setEditPath(row);
                    this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
                }
            }
        }
    }

    private void removeRuleConstraints(DefaultMutableTreeNode rnode, Object objToCheck) {
        boolean again;
        GraGraTreeNodeData sd = (GraGraTreeNodeData)rnode.getUserObject();
        if (!sd.isRule) {
            return;
        }
        if (sd.getRule().getBasisRule().getAtomApplConds().size() == 0) {
            return;
        }
        if (objToCheck != null) {
            if (objToCheck instanceof EdAtomic) {
                EdAtomic parAtom = ((EdAtomic)objToCheck).getParent();
                if (parAtom != null) {
                    if (!sd.getRule().getBasisRule().getUsedAtomics().contains(parAtom.getBasisAtomic())) {
                        return;
                    }
                } else {
                    AtomConstraint atomic = ((EdAtomic)objToCheck).getBasisAtomic();
                    if (!sd.getRule().getBasisRule().getUsedAtomics().contains(atomic)) {
                        return;
                    }
                }
            } else if (objToCheck instanceof EdConstraint) {
                boolean used = false;
                Vector formulas = sd.getRule().getBasisRule().getUsedFormulas();
                for (int i = 0; i < formulas.size(); ++i) {
                    Formula f = (Formula)formulas.get(i);
                    if (!f.compareTo(((EdConstraint)objToCheck).getBasisConstraint())) continue;
                    used = true;
                    break;
                }
                if (!used) {
                    return;
                }
            }
        }
        TreePath path = new TreePath(rnode.getPath());
        this.tree.collapsePath(path);
        block1: do {
            Enumeration<TreeNode> en = rnode.children();
            again = false;
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)en.nextElement();
                GraGraTreeNodeData cdata = (GraGraTreeNodeData)child.getUserObject();
                if (!cdata.isRuleConstraint) continue;
                again = true;
                child.removeAllChildren();
                this.treeModel.removeNodeFromParent(child);
                continue block1;
            }
        } while (again);
        this.tree.expandPath(path);
    }

    public void addRuleConstraints(DefaultMutableTreeNode rnode, Object objToCheck) {
        GraGraTreeNodeData sd = (GraGraTreeNodeData)rnode.getUserObject();
        if (!sd.isRule) {
            return;
        }
        EdRule er = sd.getRule();
        if (er.getGraGra().getBasisGraGra().getTypeSet().usesInheritance()) {
            this.inheritanceWarning();
            return;
        }
        TreePath path = new TreePath(rnode.getPath());
        if (sd.getRule().getBasisRule().getAtomApplConds().size() == 0) {
            return;
        }
        if (objToCheck != null && objToCheck instanceof EdAtomic) {
            EdAtomic parAtom = (EdAtomic)objToCheck;
            if (!sd.getRule().getBasisRule().getUsedAtomics().contains(parAtom.getBasisAtomic())) {
                return;
            }
        }
        this.tree.collapsePath(path);
        Vector atoms = er.getBasisRule().getAtomApplConds();
        Vector names = er.getBasisRule().getNames();
        for (int i = 0; i < atoms.size(); ++i) {
            EvalSet es = (EvalSet)atoms.get(i);
            String name = "PAC_" + names.get(i);
            EdRuleConstraint rc = new EdRuleConstraint(name, er, es);
            GraGraTreeNodeData subsd = new GraGraTreeNodeData(rc);
            subsd.setString(name);
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(subsd);
            subsd.setTreeNode(child);
            this.treeModel.insertNodeInto(child, rnode, rnode.getChildCount());
            for (int j = 0; j < es.getSet().size(); ++j) {
                Vector set = ((EvalSet)es.getSet().get(j)).getSet();
                for (int k = 0; k < set.size(); ++k) {
                    AtomApplCond cond = (AtomApplCond)set.elementAt(k);
                    String condName = cond.getSourceAtomConstraint().getName();
                    String n = k + j * set.size() + 1 + "_" + condName;
                    EdAtomApplCond aac = new EdAtomApplCond(n, er, cond);
                    GraGraTreeNodeData conddata = new GraGraTreeNodeData(aac);
                    conddata.setString(n);
                    DefaultMutableTreeNode condchild = new DefaultMutableTreeNode(conddata);
                    conddata.setTreeNode(condchild);
                    this.treeModel.insertNodeInto(condchild, child, child.getChildCount());
                    for (int l = 0; l < cond.getEquivalents().size(); ++l) {
                        AtomApplCond eq = (AtomApplCond)cond.getEquivalents().elementAt(l);
                        String eqName = eq.getSourceAtomConstraint().getName();
                        String eqn = n + "_Eq" + l;
                        EdAtomApplCond aacEq = new EdAtomApplCond(eqn, er, eq);
                        GraGraTreeNodeData eqdata = new GraGraTreeNodeData(aacEq);
                        eqdata.setString(eqn);
                        DefaultMutableTreeNode eqchild = new DefaultMutableTreeNode(eqdata);
                        eqdata.setTreeNode(eqchild);
                        this.treeModel.insertNodeInto(eqchild, child, child.getChildCount());
                    }
                }
            }
        }
        this.tree.expandPath(path);
    }

    private void putRuleConstraints(DefaultMutableTreeNode rnode) {
        GraGraTreeNodeData sd = (GraGraTreeNodeData)rnode.getUserObject();
        if (!sd.isRule) {
            return;
        }
        EdRule er = sd.getRule();
        TreePath path = new TreePath(rnode.getPath());
        Vector atoms = er.getBasisRule().getAtomApplConds();
        Vector names = er.getBasisRule().getNames();
        for (int i = 0; i < atoms.size(); ++i) {
            EvalSet es = (EvalSet)atoms.get(i);
            String name = "PAC_" + names.get(i);
            EdRuleConstraint rc = new EdRuleConstraint(name, er, es);
            GraGraTreeNodeData subsd = new GraGraTreeNodeData(rc);
            subsd.setString(name);
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(subsd);
            subsd.setTreeNode(child);
            this.treeModel.insertNodeInto(child, rnode, rnode.getChildCount());
            for (int j = 0; j < es.getSet().size(); ++j) {
                Vector set = ((EvalSet)es.getSet().get(j)).getSet();
                for (int k = 0; k < set.size(); ++k) {
                    AtomApplCond cond = (AtomApplCond)set.elementAt(k);
                    String condName = cond.getSourceAtomConstraint().getName();
                    String n = k + j * set.size() + 1 + "_" + condName;
                    EdAtomApplCond aac = new EdAtomApplCond(n, er, cond);
                    GraGraTreeNodeData conddata = new GraGraTreeNodeData(aac);
                    conddata.setString(n);
                    DefaultMutableTreeNode condchild = new DefaultMutableTreeNode(conddata);
                    conddata.setTreeNode(condchild);
                    this.treeModel.insertNodeInto(condchild, child, child.getChildCount());
                    for (int l = 0; l < cond.getEquivalents().size(); ++l) {
                        AtomApplCond eq = (AtomApplCond)cond.getEquivalents().elementAt(l);
                        String eqName = eq.getSourceAtomConstraint().getName();
                        String eqn = n + "_Eq" + l;
                        EdAtomApplCond aacEq = new EdAtomApplCond(eqn, er, eq);
                        GraGraTreeNodeData eqdata = new GraGraTreeNodeData(aacEq);
                        eqdata.setString(eqn);
                        DefaultMutableTreeNode eqchild = new DefaultMutableTreeNode(eqdata);
                        eqdata.setTreeNode(eqchild);
                        this.treeModel.insertNodeInto(eqchild, child, child.getChildCount());
                    }
                }
            }
        }
    }

    public void handleRuleConstraints(DefaultMutableTreeNode node, boolean insert, Object objToCheck) {
        GraGraTreeNodeData sd = (GraGraTreeNodeData)node.getUserObject();
        if (sd.isGraGra) {
            Enumeration<TreeNode> en = node.children();
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)en.nextElement();
                GraGraTreeNodeData csd = (GraGraTreeNodeData)child.getUserObject();
                if (!csd.isRule) continue;
                if (insert) {
                    this.addRuleConstraints(child, objToCheck);
                    continue;
                }
                this.removeRuleConstraints(child, objToCheck);
            }
            if (!insert) {
                sd.getGraGra().getBasisGraGra().clearRuleConstraints();
            }
        } else if (sd.isRule) {
            if (insert) {
                this.addRuleConstraints(node, objToCheck);
            } else {
                this.removeRuleConstraints(node, objToCheck);
                sd.getRule().getBasisRule().clearConstraints();
            }
        }
    }

    public void loadGraGra() {
        this.loadGraGra(null);
    }

    public void loadGraGra(String fullFileName) {
        this.fireTreeViewEvent(new TreeViewEvent(this, 2));
        EdGraGra loadedGraGra = null;
        if (fullFileName != null) {
            File f = new File(fullFileName);
            if (f.exists()) {
                XMLHelper h = null;
                h = new XMLHelper();
                h.read_from_xml(fullFileName);
                GraGra bgra = BaseFactory.theFactory().createGraGra();
                h.getTopObject(bgra);
                loadedGraGra = new EdGraGra(bgra);
                if (f.getParent() != null) {
                    loadedGraGra.setDirName(f.getParent());
                } else {
                    loadedGraGra.setDirName("");
                }
                loadedGraGra.setFileName(f.getName());
                loadedGraGra.getTypeSet().setResourcesPath(f.getParent());
                if (!loadedGraGra.getTypeSet().basisTypeReprComplete()) {
                    loadedGraGra.getTypeSet().setAdditionalReprOfBasisType();
                }
                boolean attrsVisible = true;
                loadedGraGra.update(attrsVisible);
                h.enrichObject(loadedGraGra);
            }
        } else {
            this.gragraLoad.setDirName(this.directory);
            this.gragraLoad.load();
            if (this.gragraLoad.getGraGra() != null) {
                loadedGraGra = this.gragraLoad.getGraGra();
            }
        }
        if (loadedGraGra != null) {
            BaseFactory.theFactory().notify(loadedGraGra.getBasisGraGra());
            loadedGraGra.update();
            int graIndex = this.putGraGraInTree(loadedGraGra);
            this.putGraGraInEditor(graIndex);
            this.fireTreeViewEvent(new TreeViewEvent(this, 4));
            loadedGraGra.setChanged(false);
            if (this.currentGraGra.getGraTraOptions().contains("layered")) {
                this.layered = true;
                this.treeModel.ruleNameChanged(this.currentGraGra, this.layered);
            }
            this.directory = this.gragraLoad.getDirName();
        }
        this.applFrame.getRootPane().revalidate();
    }

    public void loadBaseGraGra() {
        this.fireTreeViewEvent(new TreeViewEvent(this, 2));
        this.gragraLoad.loadBase();
        if (this.gragraLoad.getBaseGraGra() != null) {
            GraGra loadedBasis = this.gragraLoad.getBaseGraGra();
            BaseFactory.theFactory().notify(loadedBasis);
            EdGraGra loadedGraGra = new EdGraGra(loadedBasis);
            loadedGraGra.setDirName(this.gragraLoad.getDirName());
            loadedGraGra.setFileName(this.gragraLoad.getFileName());
            loadedGraGra.update();
            int graIndex = this.putGraGraInTree(loadedGraGra);
            this.putGraGraInEditor(graIndex);
            if (this.currentGraGra.getGraTraOptions().contains("layered")) {
                this.treeModel.ruleNameChanged(this.currentGraGra, true);
            }
            this.fireTreeViewEvent(new TreeViewEvent(this, 4));
        } else {
            this.fireTreeViewEvent(new TreeViewEvent(this, -1));
        }
    }

    private int putGraGraInTree(EdGraGra gragra) {
        GraGraTreeNodeData sd = new GraGraTreeNodeData(gragra);
        DefaultMutableTreeNode graNode = new DefaultMutableTreeNode(sd);
        sd.setTreeNode(graNode);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.treeModel.getRoot();
        this.treeModel.insertNodeInto(graNode, parent, parent.getChildCount());
        if (!this.tree.isExpanded(this.tree.getPathForRow(0))) {
            this.tree.expandPath(this.tree.getPathForRow(0));
        }
        int graIndex = this.tree.getRowCount() - 1;
        this.putGraGraData(graNode, gragra);
        this.doExpand(gragra, graIndex);
        return graIndex;
    }

    private void doExpand(EdGraGra gragra, int graIndex) {
        int graChildCount;
        if (!this.tree.isExpanded(this.tree.getPathForRow(graIndex))) {
            this.tree.expandPath(this.tree.getPathForRow(graIndex));
        }
        int k = 0;
        if (gragra.getTypeGraph() != null) {
            ++k;
        }
        if ((graChildCount = k + gragra.getGraphs().size() + gragra.getRules().size() + gragra.getAtomics().size() + gragra.getConstraints().size()) > 15) {
            int count = graIndex + k + gragra.getGraphs().size();
            for (int i = 0; i < gragra.getRules().size(); ++i) {
                int row = count + (i + 1);
                this.tree.collapseRow(row);
            }
        } else {
            int count = gragra.getRules().size() + gragra.getAtomics().size() + gragra.getConstraints().size();
            for (int i = 0; i < gragra.getRules().size(); ++i) {
                int row = this.tree.getRowCount() - (count - i);
                this.tree.expandRow(row);
            }
        }
    }

    private void putGraGraInEditor(int graIndex) {
        this.tree.setSelectionRow(graIndex);
        this.tree.treeDidChange();
        this.editorPath = this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
        this.setCurrentData(this.editorPath);
        this.setValueForNew(this.editorPath);
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
    }

    private void putRuleInEditor(int ruleIndex) {
        this.tree.setSelectionRow(ruleIndex);
        this.tree.treeDidChange();
        this.editorPath = this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
        this.setCurrentData(this.editorPath);
        this.setValueForNew(this.editorPath);
        this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
    }

    public void reloadGraGra() {
        int answer;
        String currentDirName = "";
        String currentFileName = "";
        EdGraGra gra = null;
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
        if (((GraGraTreeNodeData)aNode.getUserObject()).getGraGra() == this.currentGraGra) {
            gra = this.currentGraGra;
            if (gra.getFileName().equals("")) {
                JOptionPane.showMessageDialog(null, "Please save this grammar first.");
                return;
            }
            currentDirName = gra.getDirName();
            currentFileName = gra.getFileName();
            this.fireTreeViewEvent(new TreeViewEvent(this, 2));
        } else {
            gra = ((GraGraTreeNodeData)aNode.getUserObject()).getGraGra();
            if (gra.getFileName().equals("")) {
                JOptionPane.showMessageDialog(null, "Please save this grammar first.");
            }
            currentDirName = gra.getDirName();
            currentFileName = gra.getFileName();
        }
        if (gra.isChanged() && (answer = this.changedGraGraWarning("RELOAD")) == 1) {
            return;
        }
        this.gragraLoad.setGraGra(gra, gra.getDirName(), gra.getFileName());
        this.gragraLoad.reload();
        if (this.gragraLoad.getGraGra() != null) {
            EdGraGra gragra = this.gragraLoad.getGraGra();
            gragra.update();
            if (this.tree.isExpanded(this.selPath)) {
                this.tree.collapsePath(this.selPath);
            }
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
            while (graNode.getChildCount() > 0) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)graNode.getChildAt(0);
                this.treeModel.removeNodeFromParent(child);
            }
            graNode.removeAllChildren();
            GraGraTreeNodeData graNodeData = new GraGraTreeNodeData(gragra);
            graNode.setUserObject(graNodeData);
            graNodeData.setTreeNode(graNode);
            this.treeModel.nodeChanged(graNode);
            int graIndex = this.tree.getRowForPath(this.selPath);
            this.putGraGraData(graNode, gragra);
            this.doExpand(gragra, graIndex);
            gragra.setChanged(false);
            if (gragra.getGraTraOptions().contains("layered")) {
                this.layered = true;
                this.treeModel.ruleNameChanged(gragra, this.layered);
            }
            this.fireTreeViewEvent(new TreeViewEvent(this, 4));
            this.editorPath = this.selPath;
            this.setCurrentData(this.editorPath);
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.editorPath));
        }
    }

    private void putGraGraData(DefaultMutableTreeNode graNode, EdGraGra gragra) {
        DefaultMutableTreeNode node;
        int i;
        GraGraTreeNodeData sd = null;
        DefaultMutableTreeNode typeGraphNode = null;
        EdGraph typeGraph = gragra.getTypeSet().getTypeGraph();
        if (typeGraph != null) {
            sd = new GraGraTreeNodeData(typeGraph, true);
            typeGraphNode = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(typeGraphNode);
            String mode = "";
            switch (gragra.getBasisGraGra().getTypeSet().getLevelOfTypeGraphCheck()) {
                case 0: {
                    mode = "[D]";
                    break;
                }
                case 10: {
                    mode = "[E]";
                    break;
                }
                case 20: {
                    mode = "[Em]";
                    break;
                }
                case 30: {
                    mode = "[Emm]";
                    break;
                }
                default: {
                    mode = "[?]";
                }
            }
            String name = mode + typeGraph.getBasisGraph().getName();
            sd.setString(name);
            this.treeModel.insertNodeInto(typeGraphNode, graNode, graNode.getChildCount());
        }
        for (i = 0; i < gragra.getGraphs().size(); ++i) {
            EdGraph g = (EdGraph)gragra.getGraphs().get(i);
            sd = new GraGraTreeNodeData(g);
            DefaultMutableTreeNode graphNode = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(graphNode);
            sd.setString(g.getBasisGraph().getName());
            this.treeModel.insertNodeInto(graphNode, graNode, graNode.getChildCount());
        }
        for (i = 0; i < gragra.getRules().size(); ++i) {
            EdRule r = (EdRule)gragra.getRules().elementAt(i);
            if (r == null) continue;
            sd = new GraGraTreeNodeData(r);
            DefaultMutableTreeNode ruleNode = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(ruleNode);
            this.treeModel.insertNodeInto(ruleNode, graNode, graNode.getChildCount());
            for (int j = 0; j < r.getNACs().size(); ++j) {
                EdNAC nac = (EdNAC)r.getNACs().elementAt(j);
                sd = new GraGraTreeNodeData(nac);
                DefaultMutableTreeNode nacNode = new DefaultMutableTreeNode(sd);
                sd.setTreeNode(nacNode);
                this.treeModel.insertNodeInto(nacNode, ruleNode, ruleNode.getChildCount());
            }
            CondTuple conds = (CondTuple)r.getBasisRule().getAttrContext().getConditions();
            for (int c = 0; c < conds.getSize(); ++c) {
                CondMember cond = (CondMember)conds.getMemberAt(c);
                String condStr = cond.getExprAsText();
                GraGraTreeNodeData conddata = new GraGraTreeNodeData(cond, r);
                conddata.setString(condStr);
                DefaultMutableTreeNode condchild = new DefaultMutableTreeNode(conddata);
                conddata.setTreeNode(condchild);
                this.treeModel.insertNodeInto(condchild, ruleNode, ruleNode.getChildCount());
            }
            this.putRuleConstraints(ruleNode);
        }
        for (i = 0; i < gragra.getAtomics().size(); ++i) {
            EdAtomic a = (EdAtomic)gragra.getAtomics().elementAt(i);
            if (a == null) continue;
            sd = new GraGraTreeNodeData(a);
            node = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(node);
            this.treeModel.insertNodeInto(node, graNode, graNode.getChildCount());
            for (int j = 0; j < a.getConclusions().size(); ++j) {
                EdAtomic concl = (EdAtomic)a.getConclusions().elementAt(j);
                sd = new GraGraTreeNodeData(concl, true);
                DefaultMutableTreeNode conclNode = new DefaultMutableTreeNode(sd);
                sd.setTreeNode(conclNode);
                this.treeModel.insertNodeInto(conclNode, node, node.getChildCount());
                CondTuple conds = (CondTuple)concl.getBasisAtomic().getAttrContext().getConditions();
                for (int c = 0; c < conds.getSize(); ++c) {
                    CondMember cond = (CondMember)conds.getMemberAt(c);
                    String condStr = cond.getExprAsText();
                    GraGraTreeNodeData conddata = new GraGraTreeNodeData(cond, concl);
                    conddata.setString(condStr);
                    DefaultMutableTreeNode condchild = new DefaultMutableTreeNode(conddata);
                    conddata.setTreeNode(condchild);
                    this.treeModel.insertNodeInto(condchild, conclNode, conclNode.getChildCount());
                }
            }
        }
        for (i = 0; i < gragra.getConstraints().size(); ++i) {
            EdConstraint c = (EdConstraint)gragra.getConstraints().elementAt(i);
            if (c == null) continue;
            sd = new GraGraTreeNodeData(c);
            node = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(node);
            this.treeModel.insertNodeInto(node, graNode, graNode.getChildCount());
        }
        if (gragra.getConstraints().size() != 0 && gragra.getBasisGraGra().isLayered()) {
            this.treeModel.constraintNameChanged(gragra, true);
        }
    }

    public void saveGraGra() {
        EdGraGra selGraGra = this.getGraGra();
        if (selGraGra == null) {
            return;
        }
        this.fireTreeViewEvent(new TreeViewEvent(this, 1));
        if (selGraGra.getDirName().equals("")) {
            this.gragraSave.setDirName(this.directory);
        }
        this.gragraSave.setGraGra(selGraGra, selGraGra.getDirName(), selGraGra.getFileName());
        this.gragraSave.save();
        this.fireTreeViewEvent(new TreeViewEvent(this, 3));
    }

    public void saveAsGraGra() {
        EdGraGra selGraGra = this.getGraGra();
        if (selGraGra == null) {
            return;
        }
        this.fireTreeViewEvent(new TreeViewEvent(this, 1));
        this.gragraSave.setDirName(this.directory);
        this.gragraSave.setGraGra(selGraGra, selGraGra.getDirName(), selGraGra.getFileName());
        this.gragraSave.saveAs();
        this.directory = this.gragraSave.getDirName();
        this.fireTreeViewEvent(new TreeViewEvent(this, 3));
    }

    public void saveAsBaseGraGra() {
        EdGraGra selGraGra = this.getGraGra();
        if (selGraGra == null) {
            return;
        }
        this.fireTreeViewEvent(new TreeViewEvent(this, 1));
        selGraGra.clear();
        this.gragraSave.setGraGra(selGraGra);
        this.gragraSave.setBaseGraGra(selGraGra.getBasisGraGra(), "", "");
        this.gragraSave.saveAsBase();
        this.fireTreeViewEvent(new TreeViewEvent(this, 3));
    }

    public String getFileDirectory() {
        return this.directory;
    }

    public void setFileDirectory(String dir) {
        this.directory = dir;
    }

    public synchronized void resetGraph() {
        EdGraGra selGraGra = this.getGraGra();
        if (selGraGra != null) {
            this.fireTreeViewEvent(new TreeViewEvent(this, 16));
            if (selGraGra.resetGraph()) {
                DefaultMutableTreeNode pathComp = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.selPath.getLastPathComponent()).getChildAt(0);
                if (selGraGra.getBasisGraGra().getTypeGraph() != null) {
                    pathComp = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.selPath.getLastPathComponent()).getChildAt(1);
                }
                ((GraGraTreeNodeData)pathComp.getUserObject()).setData(selGraGra.getGraph());
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 160, this.selPath));
            }
        }
    }

    public void exportGraphJPEG() {
        if (this.getGraGra() == null) {
            return;
        }
        this.fireTreeViewEvent(new TreeViewEvent(this, 23));
    }

    public void exportJPEG() {
        this.saveJPEG();
    }

    public void exportGraGra(String format) {
        EdGraGra selGraGra = this.getGraGra();
        if (selGraGra == null) {
            return;
        }
        selGraGra.clear();
        String oldDir = selGraGra.getDirName();
        String oldFile = selGraGra.getFileName();
        String tmpn = "tmp_" + selGraGra.getName() + ".ggx";
        String tmpName = tmpn.replaceAll(" ", "");
        this.gragraSave.setGraGra(selGraGra, selGraGra.getDirName(), tmpName);
        this.gragraSave.save();
        File tmpf = new File(selGraGra.getDirName() + tmpName);
        StreamSource stream = new StreamSource(tmpf);
        tmpf.deleteOnExit();
        ConverterXML converter = new ConverterXML();
        String fn = "";
        String fd = "";
        String filter = "";
        if (format.equals("GXL")) {
            filter = ".gxl";
        } else if (format.equals("GTXL")) {
            filter = ".gtxl";
        }
        if (!filter.equals("")) {
            JFileChooser chooser = null;
            chooser = this.directory.equals("") ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(this.directory);
            AGGFileFilter filterXML = new AGGFileFilter(filter, "XML Files (" + filter + ")");
            chooser.addChoosableFileFilter(filterXML);
            chooser.setFileFilter(filterXML);
            int value = chooser.showSaveDialog(this.applFrame);
            if (value == 0) {
                fd = chooser.getCurrentDirectory().toString();
                if (chooser.getSelectedFile() != null && !chooser.getSelectedFile().getName().equals("") && !(fn = chooser.getSelectedFile().getName()).endsWith(filter)) {
                    fn = fn.concat(filter);
                }
                if (!fd.endsWith(File.separator)) {
                    fd = fd + File.separator;
                }
            }
            if (!fn.equals("")) {
                File source = null;
                if (format.equals("GXL")) {
                    source = converter.copyFile(fd, "ggx2gxl.xsl");
                    if (source != null && converter.ggx2gxl(selGraGra.getDirName() + selGraGra.getFileName(), fd + fn, fd + "ggx2gxl.xsl")) {
                        this.fireTreeViewEvent(new TreeViewEvent(this, 15));
                    } else {
                        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                        JOptionPane.showMessageDialog(null, "Export has failed!");
                    }
                } else if (format.equals("GTXL")) {
                    source = converter.copyFile(fd, "gts2gtxl.xsl");
                    if (source != null) {
                        source = converter.copyFile(fd, "ggx2gxl.xsl");
                    }
                    if (source != null && converter.gts2gtxl(selGraGra.getDirName() + selGraGra.getFileName(), fd + fn, fd + "gts2gtxl.xsl")) {
                        this.fireTreeViewEvent(new TreeViewEvent(this, 15));
                    } else {
                        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                        JOptionPane.showMessageDialog(null, "Export has failed!");
                    }
                } else {
                    this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                    JOptionPane.showMessageDialog(null, "Export has failed!");
                }
            }
        }
        selGraGra.setDirName(oldDir);
        selGraGra.setFileName(oldFile);
    }

    public synchronized void importGraGra(String format) {
        ConverterXML converter = new ConverterXML();
        String fn = "";
        String fd = "";
        String filter = "";
        if (format.equals("GGX")) {
            filter = ".ggx";
        } else if (format.equals("GXL")) {
            filter = ".gxl";
        } else if (format.equals("GTXL")) {
            filter = ".gtxl";
        } else if (format.equals("OMONDOXMI")) {
            filter = ".ecore";
        }
        if (!filter.equals("")) {
            JFileChooser chooser = null;
            chooser = this.directory.equals("") ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(this.directory);
            AGGFileFilter filterXML = new AGGFileFilter(filter, "XML Files (" + filter + ")");
            chooser.addChoosableFileFilter(filterXML);
            chooser.setFileFilter(filterXML);
            int value = chooser.showOpenDialog(this.applFrame);
            if (value == 0 && chooser.getSelectedFile() != null && !chooser.getSelectedFile().getName().equals("")) {
                this.directory = chooser.getCurrentDirectory().toString();
                fn = chooser.getSelectedFile().getName();
                fd = chooser.getCurrentDirectory().toString();
                if (!fd.endsWith(File.separator)) {
                    fd = fd + File.separator;
                }
            }
            if (!fn.equals("")) {
                EdGraGra loadedGraGra;
                String fnOut = "";
                File gxldtd = null;
                File gtsdtd = null;
                File source = null;
                if (!format.equals("GGX")) {
                    if (format.equals("GXL")) {
                        fnOut = fn.substring(0, fn.length() - 4) + "_gxl.ggx";
                        source = converter.copyFile(fd, "gxl2ggx.xsl");
                        gxldtd = converter.copyFile(fd, "gxl.dtd");
                        String fd1 = System.getProperty("user.dir");
                        if (!fd1.endsWith(File.separator)) {
                            fd1 = fd1 + File.separator;
                        }
                        gtsdtd = converter.copyFile(fd, "gts.dtd");
                        gtsdtd = converter.copyFile(fd1, "gts.dtd");
                        converter.copyFile(fd, "agglayout.dtd");
                        converter.copyFile(fd1, "agglayout.dtd");
                    } else if (format.equals("GTXL")) {
                        fnOut = fn.substring(0, fn.length() - 4) + "_gtxl.ggx";
                    } else if (format.equals("OMONDOXMI")) {
                        fnOut = fn.substring(0, fn.length() - 6) + "_ecore.ggx";
                        source = converter.copyFile(fd, "gxl2ggx.xsl");
                        gxldtd = converter.copyFile(fd, "gxl.dtd");
                        gtsdtd = converter.copyFile(fd, "gts.dtd");
                        converter.copyFile(fd, "agglayout.dtd");
                        converter.copyFile(fd, "omondoxmi2gxl.xsl");
                    }
                }
                if (!(format.equals("GGX") || gxldtd != null && gtsdtd != null)) {
                    JOptionPane.showMessageDialog(null, "Import failed!\nFile gxl.dtd or gts.dtd is not found.");
                }
                if (format.equals("GGX")) {
                    this.fireTreeViewEvent(new TreeViewEvent(this, 2));
                    this.gragraLoad.reload(fd, fn);
                    if (this.gragraLoad.getGraGra() != null) {
                        this.handleLoadedImportGraGra(this.gragraLoad.getGraGra(), this.selPath);
                    } else {
                        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                        this.applFrame.getRootPane().revalidate();
                        JOptionPane.showMessageDialog(null, "Import GGX file failed!");
                    }
                } else if (format.equals("GXL") && converter.gxl2ggx(fd + fn, fd + fnOut, fd + "gxl2ggx.xsl")) {
                    this.fireTreeViewEvent(new TreeViewEvent(this, 2));
                    this.gragraLoad.reload(fd, fnOut);
                    if (this.gragraLoad.getGraGra() != null) {
                        EdGraGra test = this.gragraLoad.getGraGra();
                        this.gragraSave.setGraGra(test, test.getDirName(), test.getFileName());
                        this.gragraSave.save();
                        this.handleLoadedImportGraGra(this.gragraLoad.getGraGra(), this.selPath);
                    } else {
                        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                        this.applFrame.getRootPane().revalidate();
                        JOptionPane.showMessageDialog(null, "Import GXL file failed!");
                    }
                } else if (format.equals("GTXL") && converter.gtxl2gts(fd + fn, fd + fnOut, fd + "gtxl2gts.xsl")) {
                    this.fireTreeViewEvent(new TreeViewEvent(this, 2));
                    this.gragraLoad.reload(fd, fnOut);
                    if (this.gragraLoad.getGraGra() != null) {
                        loadedGraGra = this.gragraLoad.getGraGra();
                        this.gragraSave.setGraGra(loadedGraGra, loadedGraGra.getDirName(), loadedGraGra.getFileName());
                        this.gragraSave.save();
                        loadedGraGra.getBasisGraGra().setGraTraOptions(new Completion_NAC(new Completion_InjCSP()));
                        BaseFactory.theFactory().notify(loadedGraGra.getBasisGraGra());
                        loadedGraGra.update();
                        this.putGraGraInTree(loadedGraGra);
                        this.fireTreeViewEvent(new TreeViewEvent(this, 4));
                    } else {
                        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                        this.applFrame.getRootPane().revalidate();
                        JOptionPane.showMessageDialog(null, "Import GTXL file failed!");
                    }
                } else if (format.equals("OMONDOXMI") && converter.omondoxmi2ggx(fd + fn, fd + fnOut, fd + "omondoxmi2gxl.xsl", fd + "gxl2ggx.xsl")) {
                    this.fireTreeViewEvent(new TreeViewEvent(this, 2));
                    this.gragraLoad.reload(fd, fnOut);
                    if (this.gragraLoad.getGraGra() != null) {
                        loadedGraGra = this.gragraLoad.getGraGra();
                        this.gragraSave.setGraGra(loadedGraGra, loadedGraGra.getDirName(), loadedGraGra.getFileName());
                        this.gragraSave.save();
                        this.handleLoadedImportGraGra(loadedGraGra, this.selPath);
                    } else {
                        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                        this.applFrame.getRootPane().revalidate();
                        JOptionPane.showMessageDialog(null, "Import OMONDO XMI file failed!");
                    }
                } else {
                    this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                    JOptionPane.showMessageDialog(null, "Import has failed!");
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void old_handleLoadedImportGraGra(EdGraGra importGraGra, TreePath path) {
        if (importGraGra != null) {
            Object[] options;
            int answer;
            if (this.currentGraGra == null) {
                if (importGraGra.getBasisGraGra().getGraTraOptions().isEmpty()) {
                    importGraGra.getBasisGraGra().setGraTraOptions(new Completion_NAC(new Completion_InjCSP()));
                }
                BaseFactory.theFactory().notify(importGraGra.getBasisGraGra());
                importGraGra.update();
                this.putGraGraInTree(importGraGra);
                this.fireTreeViewEvent(new TreeViewEvent(this, 4));
                return;
            }
            boolean impAsGrammar = true;
            boolean typeGraphImported = false;
            if (!this.useImportTypeGraph) {
                if (importGraGra.getTypeSet().getTypeGraph() != null && !importGraGra.getTypeSet().getTypeGraph().getBasisGraph().isEmpty() && (answer = JOptionPane.showOptionDialog(null, "Do you want to use the type graph of the import grammar?", "Import Type Graph", -1, 3, null, options = new Object[]{"YES", "NO"}, options[0])) == 0) {
                    this.useImportTypeGraph = true;
                    typeGraphImported = this.importTypeGraph(importGraGra, path);
                    impAsGrammar = false;
                    if (typeGraphImported) {
                        this.useImportTypeGraph = false;
                    } else {
                        if (this.rewriteTypeGraph) return;
                        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                        this.applFrame.getRootPane().revalidate();
                    }
                }
            } else {
                typeGraphImported = this.importTypeGraph(importGraGra, path);
                impAsGrammar = false;
                if (!typeGraphImported) {
                    this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                    this.applFrame.getRootPane().revalidate();
                    JOptionPane.showMessageDialog(null, "Import has failed!");
                }
            }
            if (impAsGrammar || typeGraphImported && importGraGra.getGraph().getBasisGraph() != null && !importGraGra.getGraph().getBasisGraph().isEmpty()) {
                options = new Object[]{"As current graph", "Add to graphs", "As grammar", "Cancel"};
                answer = JOptionPane.showOptionDialog(null, "Do you want to use the import graph \nas the host graph of the current grammar?\n( Please note: The type graph of the \ncurrent grammar should be disabled. )", "Import Graph", -1, 3, null, options, options[0]);
                if (answer == 0) {
                    impAsGrammar = false;
                    if (!this.importGraph(importGraGra, path, true)) {
                        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                        this.applFrame.getRootPane().revalidate();
                    }
                } else if (answer == 1) {
                    impAsGrammar = false;
                    if (!this.addImportGraph(importGraGra, path, true)) {
                        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                        this.applFrame.getRootPane().revalidate();
                    }
                } else {
                    if (answer != 2) return;
                    impAsGrammar = true;
                }
            } else if (impAsGrammar || importGraGra.getGraph().getBasisGraph() != null && !importGraGra.getGraph().getBasisGraph().isEmpty()) {
                options = new Object[]{"As current graph", "Add to graphs", "As grammar", "Cancel"};
                answer = JOptionPane.showOptionDialog(null, "Do you want to use the import graph \nas the host graph of the current grammar?\n( Please note: The type graph of the \ncurrent grammar should be disabled. )", "Import Graph", -1, 3, null, options, options[0]);
                if (answer == 0) {
                    impAsGrammar = false;
                    if (!this.importGraph(importGraGra, path, false)) {
                        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                        this.applFrame.getRootPane().revalidate();
                    }
                } else if (answer == 1) {
                    impAsGrammar = false;
                    if (!this.addImportGraph(importGraGra, path, true)) {
                        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                    }
                } else {
                    if (answer != 2) return;
                    impAsGrammar = true;
                }
            }
            if (!impAsGrammar) return;
            BaseFactory.theFactory().notify(importGraGra.getBasisGraGra());
            importGraGra.update();
            this.putGraGraInTree(importGraGra);
            this.fireTreeViewEvent(new TreeViewEvent(this, 4));
            return;
        }
        this.fireTreeViewEvent(new TreeViewEvent(this, -1));
        this.applFrame.getRootPane().revalidate();
        JOptionPane.showMessageDialog(null, "Import has failed!");
    }

    private synchronized void handleLoadedImportGraGra(EdGraGra importGraGra, TreePath path) {
        if (importGraGra != null) {
            if (this.currentGraGra == null) {
                this.importAsGrammar(importGraGra);
                return;
            }
            boolean impAsTG = false;
            boolean impAsG = false;
            if (importGraGra.getTypeSet().getTypeGraph() != null && !importGraGra.getTypeSet().getTypeGraph().getBasisGraph().isEmpty()) {
                impAsTG = true;
            }
            if (importGraGra.getGraph() != null && !importGraGra.getGraph().getBasisGraph().isEmpty()) {
                impAsG = true;
            }
            if (impAsTG && impAsG) {
                Object[] options = new Object[]{"Type graph", "Host graph", "Grammar"};
                int answer = JOptionPane.showOptionDialog(null, "\nPlease select what do you want to import.", "Import", -1, 3, null, options, options[2]);
                if (answer == 0) {
                    this.importAsTypeGraph(importGraGra, path);
                } else if (answer == 1) {
                    this.importAsGraph(importGraGra, path);
                } else if (answer == 2) {
                    this.importAsGrammar(importGraGra);
                }
            } else if (impAsTG && !impAsG) {
                Object[] options = new Object[]{"Type graph", "Grammar"};
                int answer = JOptionPane.showOptionDialog(null, "\nPlease select what do you want to import.", "Import", -1, 3, null, options, options[1]);
                if (answer == 0) {
                    this.importAsTypeGraph(importGraGra, path);
                } else if (answer == 1) {
                    this.importAsGrammar(importGraGra);
                }
            } else if (!impAsTG && impAsG) {
                Object[] options = new Object[]{"Host graph", "Grammar"};
                int answer = JOptionPane.showOptionDialog(null, "\nPlease select what do you want to import.", "Import", -1, 3, null, options, options[1]);
                if (answer == 0) {
                    this.importAsGraph(importGraGra, path);
                } else if (answer == 1) {
                    this.importAsGrammar(importGraGra);
                }
            }
        }
    }

    private void importAsTypeGraph(EdGraGra imp, TreePath path) {
        boolean typeGraphImported = this.importTypeGraph(imp, path);
        if (!typeGraphImported && !this.rewriteTypeGraph) {
            this.fireTreeViewEvent(new TreeViewEvent(this, -1));
            this.applFrame.getRootPane().revalidate();
        }
    }

    private void importAsGraph(EdGraGra imp, TreePath path) {
        Object[] options = new Object[]{"Use as current graph", "Add to graphs"};
        int answer = JOptionPane.showOptionDialog(null, "Do you want to use the import graph as the current graph?\n( Please note: The type graph of the current grammar should be disabled. )", "Import Graph", -1, 3, null, options, options[0]);
        if (answer == 0) {
            if (!this.importGraph(imp, path, true)) {
                this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                this.applFrame.getRootPane().revalidate();
            }
        } else if (answer == 1 && !this.addImportGraph(imp, path, true)) {
            this.fireTreeViewEvent(new TreeViewEvent(this, -1));
            this.applFrame.getRootPane().revalidate();
        }
    }

    private void importAsGrammar(EdGraGra imp) {
        this.fireTreeViewEvent(new TreeViewEvent(this, 2));
        if (imp.getBasisGraGra().getGraTraOptions().isEmpty()) {
            imp.getBasisGraGra().setGraTraOptions(new Completion_NAC(new Completion_InjCSP()));
        }
        BaseFactory.theFactory().notify(imp.getBasisGraGra());
        imp.update();
        int graIndex = this.putGraGraInTree(imp);
        this.putGraGraInEditor(graIndex);
        this.fireTreeViewEvent(new TreeViewEvent(this, 4));
        imp.setChanged(false);
        this.resetEnabledOfFileMenuItems("open");
        this.filePopupMenu.resetEnabledOfFileMenuItems("open");
        this.resetEnabledOfToolBarItems("open");
    }

    private boolean importTypeGraph(EdGraGra importGraGra, TreePath path) {
        if (path != null) {
            GraGraTreeNodeData data = (GraGraTreeNodeData)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            while (data != null && !data.isGraGra) {
                TreePath parentPath = path.getParentPath();
                if (parentPath != null) {
                    data = (GraGraTreeNodeData)((DefaultMutableTreeNode)parentPath.getLastPathComponent()).getUserObject();
                    path = parentPath;
                    continue;
                }
                data = null;
            }
            if (data == null) {
                JOptionPane.showMessageDialog(null, "Cannot import!\nPlease select a grammar tree node first.");
                return false;
            }
            boolean imported = false;
            EdGraGra selGraGra = data.getGraGra();
            this.fireTreeViewEvent(new TreeViewEvent(this, 17));
            if (selGraGra.getBasisGraGra().getTypeSet().getLevelOfTypeGraphCheck() != 0) {
                if (!selGraGra.getTypeSet().getBasisTypeSet().compareTypes(importGraGra.getTypeSet().getBasisTypeSet())) {
                    this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                    this.applFrame.getRootPane().revalidate();
                    Object[] options = new Object[]{"OK"};
                    int answer = JOptionPane.showOptionDialog(null, "There are mismatches of types. \nDo you want to rewrite the type graph by the import type graph?\n( If yes, please disable the current type graph first and try again. )", "Import Type Graph", -1, 2, null, options, options[0]);
                    if (answer == 0) {
                        this.rewriteTypeGraph = true;
                    }
                    return false;
                }
                if (selGraGra.importTypeGraph(importGraGra.getTypeGraph(), false)) {
                    imported = true;
                }
            } else if (this.rewriteTypeGraph) {
                if (selGraGra.importTypeGraph(importGraGra.getTypeGraph(), true)) {
                    imported = true;
                }
            } else if (!selGraGra.getTypeSet().getBasisTypeSet().compareTypes(importGraGra.getTypeSet().getBasisTypeSet())) {
                Object[] options = new Object[]{"OK"};
                int answer = JOptionPane.showOptionDialog(null, "There are mismatches of types. \nDo you want to rewrite the current type graph \nby the import type graph?", "Import Type Graph", -1, 2, null, options, options[0]);
                if (answer == 0 && selGraGra.importTypeGraph(importGraGra.getTypeGraph(), true)) {
                    imported = true;
                }
            } else {
                boolean selectAll = false;
                if (selGraGra.getTypeSet().getTypeGraph() == null) {
                    this.addTypeGraph();
                    selectAll = true;
                }
                if (selGraGra.importTypeGraph(importGraGra.getTypeGraph(), true)) {
                    imported = true;
                    if (selectAll) {
                        selGraGra.getTypeSet().getTypeGraph().selectAll();
                    }
                }
            }
            if (imported) {
                this.rewriteTypeGraph = false;
                DefaultMutableTreeNode pathComp = (DefaultMutableTreeNode)((DefaultMutableTreeNode)path.getLastPathComponent()).getChildAt(0);
                if (selGraGra.getBasisGraGra().getTypeGraph() != null) {
                    pathComp = (DefaultMutableTreeNode)((DefaultMutableTreeNode)path.getLastPathComponent()).getChildAt(1);
                }
                ((GraGraTreeNodeData)pathComp.getUserObject()).setData(selGraGra.getGraph());
                if (selGraGra.getTypeSet().getBasisTypeSet().isNewTypeGraphObjectImported()) {
                    JOptionPane.showMessageDialog(null, "Import Type Graph was successful.\n( Please note: New created type graph objects are selected.\nYou can move them to the right position, if you want. )");
                } else {
                    JOptionPane.showMessageDialog(null, "Import Type Graph was successful.");
                }
                this.fireTreeViewEvent(new TreeViewEvent(this, 170));
                return true;
            }
            this.rewriteTypeGraph = false;
            this.fireTreeViewEvent(new TreeViewEvent(this, -1));
            this.applFrame.getRootPane().revalidate();
            JOptionPane.showMessageDialog(null, "Import has failed!");
            return false;
        }
        JOptionPane.showMessageDialog(null, "Cannot import!\nPlease select a grammar tree node first.");
        return false;
    }

    private void rewriteDialog(EdGraGra gra, EdGraGra impGra) {
        if (!gra.getTypeSet().getBasisTypeSet().compareTypes(impGra.getTypeSet().getBasisTypeSet())) {
            this.fireTreeViewEvent(new TreeViewEvent(this, -1));
            this.applFrame.getRootPane().revalidate();
            Object[] options = new Object[]{"Rewrite", "Inspect And Rewrite", "Cancel"};
            int answer = JOptionPane.showOptionDialog(null, "There are mismatches of types. \nDo you want to rewrite the type graph by the import type graph?\n( If yes, please disable the current type graph first and try again. )", "Import Type Graph", -1, 2, null, options, options[1]);
            if (answer == 1) {
                this.rewriteTypeGraph = true;
            } else if (answer == 0) {
                this.rewriteTypeGraph = true;
            } else if (answer == 2) {
                this.rewriteTypeGraph = false;
            }
        }
    }

    private boolean importGraph(EdGraGra importGraGra, TreePath treepath, boolean adapt) {
        TreePath path = treepath;
        if (path != null) {
            GraGraTreeNodeData data = (GraGraTreeNodeData)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            while (data != null && !data.isGraGra) {
                TreePath parentPath = path.getParentPath();
                if (parentPath != null) {
                    data = (GraGraTreeNodeData)((DefaultMutableTreeNode)parentPath.getLastPathComponent()).getUserObject();
                    path = parentPath;
                    continue;
                }
                data = null;
            }
            if (data == null) {
                JOptionPane.showMessageDialog(null, "Cannot import!\nPlease select a grammar tree node first.");
                return false;
            }
            EdGraGra selGraGra = data.getGraGra();
            Object graphPath = null;
            DefaultMutableTreeNode graphTreeNode = null;
            GraGraTreeNodeData graphData = null;
            if (this.currentGraGra == selGraGra) {
                DefaultMutableTreeNode gragraTreeNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                for (int i = 0; i < gragraTreeNode.getChildCount(); ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)gragraTreeNode.getChildAt(i);
                    GraGraTreeNodeData childData = (GraGraTreeNodeData)child.getUserObject();
                    if (!childData.isGraph || childData.getGraph() != selGraGra.getGraph()) continue;
                    graphTreeNode = child;
                    graphData = childData;
                    break;
                }
            }
            this.fireTreeViewEvent(new TreeViewEvent(this, 17));
            if (importGraGra.getTypeGraph() != null && (selGraGra.getTypeGraph() == null || selGraGra.getTypeGraph().getBasisGraph().isEmpty() && selGraGra.getLevelOfTypeGraphCheck() == 0) && this.importTypeGraph(importGraGra, path)) {
                adapt = false;
            }
            if (adapt) {
                if (selGraGra.importGraph(importGraGra.getGraph(), adapt)) {
                    graphData.setData(selGraGra.getGraph());
                    if (!this.currentGraph.isTypeGraph()) {
                        this.currentGraph = selGraGra.getGraph();
                        this.currentGraph.getBasisGraph().setName(graphData.string());
                    }
                    this.fireTreeViewEvent(new TreeViewEvent(this, 171));
                    return true;
                }
                this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                this.applFrame.getRootPane().revalidate();
                JOptionPane.showMessageDialog(null, "Import has failed!\nMaybe there are mismatches of types.");
                return false;
            }
            if (selGraGra.importGraph(importGraGra.getGraph())) {
                graphData.setData(selGraGra.getGraph());
                if (!this.currentGraph.isTypeGraph()) {
                    this.currentGraph = selGraGra.getGraph();
                    this.currentGraph.getBasisGraph().setName(graphData.string());
                }
                this.fireTreeViewEvent(new TreeViewEvent(this, 171));
                return true;
            }
            this.fireTreeViewEvent(new TreeViewEvent(this, -1));
            this.applFrame.getRootPane().revalidate();
            JOptionPane.showMessageDialog(null, "Import has failed!\nPlease check the types of the import graph.\nThe type graph of the current grammar should be disabled.");
            return false;
        }
        JOptionPane.showMessageDialog(null, "Cannot import!\nPlease select a grammar tree node first.");
        return false;
    }

    private boolean addImportGraph(EdGraGra importGraGra, TreePath treepath, boolean adapt) {
        TreePath path = treepath;
        if (path != null) {
            GraGraTreeNodeData data = (GraGraTreeNodeData)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            while (data != null && !data.isGraGra) {
                TreePath parentPath = path.getParentPath();
                if (parentPath != null) {
                    data = (GraGraTreeNodeData)((DefaultMutableTreeNode)parentPath.getLastPathComponent()).getUserObject();
                    path = parentPath;
                    continue;
                }
                data = null;
            }
            if (data == null) {
                JOptionPane.showMessageDialog(null, "Cannot import!\nPlease select a grammar tree node first.");
                return false;
            }
            EdGraGra selGraGra = data.getGraGra();
            if (adapt) {
                if (selGraGra.addImportGraph(importGraGra.getGraph(), adapt)) {
                    this.addGraph(selGraGra, selGraGra.getGraph());
                    int indx = selGraGra.getGraphs().size() - 1;
                    if (selGraGra.getBasisGraGra().getTypeGraph() != null) {
                        ++indx;
                    }
                    DefaultMutableTreeNode pathComp = (DefaultMutableTreeNode)((DefaultMutableTreeNode)path.getLastPathComponent()).getChildAt(indx);
                    ((GraGraTreeNodeData)pathComp.getUserObject()).setData(selGraGra.getGraph());
                    this.fireTreeViewEvent(new TreeViewEvent(this, 172));
                    return true;
                }
                this.fireTreeViewEvent(new TreeViewEvent(this, -1));
                this.applFrame.getRootPane().revalidate();
                JOptionPane.showMessageDialog(null, "Import has failed!\nMaybe there are mismatches of types.");
                return false;
            }
            if (selGraGra.addImportGraph(importGraGra.getGraph())) {
                this.addGraph(selGraGra, selGraGra.getGraph());
                int indx = selGraGra.getGraphs().size() - 1;
                if (selGraGra.getBasisGraGra().getTypeGraph() != null) {
                    ++indx;
                }
                DefaultMutableTreeNode pathComp = (DefaultMutableTreeNode)((DefaultMutableTreeNode)path.getLastPathComponent()).getChildAt(indx);
                ((GraGraTreeNodeData)pathComp.getUserObject()).setData(selGraGra.getGraph());
                this.fireTreeViewEvent(new TreeViewEvent(this, 172));
                return true;
            }
            this.fireTreeViewEvent(new TreeViewEvent(this, -1));
            this.applFrame.getRootPane().revalidate();
            JOptionPane.showMessageDialog(null, "Import has failed!\nPlease check the types of the import graph.\nThe type graph of the current grammar should be disabled.");
            return false;
        }
        JOptionPane.showMessageDialog(null, "Cannot import!\nPlease select a grammar tree node first.");
        return false;
    }

    public void transformEventOccurred(TransformEvent e) {
        if (e.getMsg() == 20) {
            this.tree.treeDidChange();
        }
    }

    public void editEventOccurred(EditEvent e) {
        if (e.getMsg() == -11) {
            this.requestFocusInWindow();
            this.performShortKey((KeyEvent)e.getObject());
        } else if (e.getMsg() == -10) {
            if (e.getMessage().equals("File")) {
                this.file.doClick();
            } else if (e.getMessage().equals("New GraGra")) {
                this.executeCommand("newGraGra");
            } else if (e.getMessage().equals("Open")) {
                this.executeCommand("open");
            } else if (e.getMessage().equals("Save")) {
                this.executeCommand("save");
            } else if (e.getMessage().equals("Save As")) {
                this.executeCommand("saveAs");
            } else if (e.getMessage().equals("exportGraphJPEG")) {
                this.executeCommand("exportGraphJPEG");
            } else if (e.getMessage().equals("exportGXL")) {
                this.executeCommand("exportGXL");
            } else if (e.getMessage().equals("exportGTXL")) {
                this.executeCommand("exportGTXL");
            } else if (e.getMessage().equals("importGGX")) {
                this.executeCommand("importGGX");
            } else if (e.getMessage().equals("importGXL")) {
                this.executeCommand("importGXL");
            } else if (e.getMessage().equals("importOMONDOXMI")) {
                this.executeCommand("importOMONDOXMI");
            } else if (e.getMessage().equals("Delete")) {
                this.executeCommand("delete");
            } else if (e.getMessage().equals("Type Graph")) {
                this.executeCommand("newTypeGraph");
            } else if (e.getMessage().equals("Graph")) {
                this.executeCommand("newGraph");
            } else if (e.getMessage().equals("Rule")) {
                this.executeCommand("newRule");
            } else if (e.getMessage().equals("New NAC")) {
                this.executeCommand("newNAC");
            } else if (e.getMessage().equals("Atomic Constraint")) {
                this.executeCommand("newAtomic");
            } else if (e.getMessage().equals("New Conclusion")) {
                this.executeCommand("newConclusion");
            } else if (e.getMessage().equals("Constraint")) {
                this.executeCommand("newConstraint");
            } else if (e.getMessage().equals("Set Layer")) {
                this.setRuleLayer();
            } else if (e.getMessage().equals("Reload")) {
                this.reloadGraGra();
            } else if (e.getMessage().equals("Quit")) {
                this.executeCommand("exit");
            }
        } else if (e.getMsg() == -9) {
            this.applFrame.setCursor(new Cursor(0));
        } else if (e.getMsg() == -8) {
            if (this.selPath == null) {
                return;
            }
            if (e.getObject() instanceof EdAtomic) {
                DefaultMutableTreeNode atomicNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
                GraGraTreeNodeData sd = (GraGraTreeNodeData)atomicNode.getUserObject();
                if (sd.isAtomic) {
                    DefaultMutableTreeNode conclNode = (DefaultMutableTreeNode)atomicNode.getChildAt(0);
                    int row = this.tree.getRowForPath(this.selPath) + 1;
                    this.tree.collapseRow(row);
                    this.showAtomicAttrConditions(conclNode);
                    this.tree.expandRow(row);
                } else if (sd.isConclusion && sd.getConclusion() == (EdAtomic)e.getObject()) {
                    this.tree.collapsePath(this.selPath);
                    this.showAtomicAttrConditions(atomicNode);
                    this.tree.expandPath(this.selPath);
                } else if (sd.isAttrCondition) {
                    TreePath atomicPath = this.selPath.getParentPath();
                    atomicNode = (DefaultMutableTreeNode)atomicPath.getLastPathComponent();
                    sd = (GraGraTreeNodeData)atomicNode.getUserObject();
                    this.tree.collapsePath(atomicPath);
                    this.showAtomicAttrConditions(atomicNode);
                    this.tree.expandPath(atomicPath);
                }
            } else if (e.getObject() instanceof EdRule) {
                DefaultMutableTreeNode ruleNode = (DefaultMutableTreeNode)this.selPath.getLastPathComponent();
                TreePath rulePath = this.selPath;
                GraGraTreeNodeData sd = (GraGraTreeNodeData)ruleNode.getUserObject();
                if (sd.isRule && sd.getRule() == (EdRule)e.getObject()) {
                    this.tree.collapsePath(rulePath);
                    this.showRuleAttrConditions(ruleNode);
                    this.tree.expandPath(rulePath);
                } else if (sd.isAttrCondition) {
                    rulePath = this.selPath.getParentPath();
                    ruleNode = (DefaultMutableTreeNode)rulePath.getLastPathComponent();
                    sd = (GraGraTreeNodeData)ruleNode.getUserObject();
                    this.tree.collapsePath(rulePath);
                    this.showRuleAttrConditions(ruleNode);
                    this.tree.expandPath(rulePath);
                } else if (sd.isNAC) {
                    rulePath = this.selPath.getParentPath();
                    ruleNode = (DefaultMutableTreeNode)rulePath.getLastPathComponent();
                    this.tree.collapsePath(rulePath);
                    this.showRuleAttrConditions(ruleNode);
                    this.tree.expandPath(rulePath);
                }
            }
        }
    }

    private void setValueForNew(TreePath path) {
        DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        GraGraTreeNodeData sd = (GraGraTreeNodeData)aNode.getUserObject();
        this.setValueForNew(sd);
    }

    private void setValueForNew(GraGraTreeNodeData sd) {
        this.newGraGraOK = true;
        if (sd.isGraGra) {
            this.newRuleOK = true;
            this.newNACOK = false;
        } else if (sd.isGraph) {
            this.newRuleOK = false;
            this.newNACOK = false;
        } else if (sd.isRule) {
            this.newNACOK = true;
            this.newRuleOK = false;
        } else if (sd.isNAC) {
            this.newRuleOK = false;
            this.newNACOK = false;
        } else {
            this.newRuleOK = false;
            this.newNACOK = false;
        }
    }

    private void setCurrentData(TreePath path) {
        EdGraph testGraph = null;
        EdRule testRule = null;
        EdNAC testNAC = null;
        EdAtomic testAtomic = null;
        EdAtomic testConclusion = null;
        EdConstraint testConstraint = null;
        EdRuleConstraint testRuleConstraint = null;
        this.isGraGra = false;
        this.isGraph = false;
        this.isRule = false;
        this.isNAC = false;
        this.isAtomic = false;
        this.isConclusion = false;
        this.isConstraint = false;
        this.isRuleConstraint = false;
        this.isAttrCondition = false;
        int nn = path.getPath().length;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)node.getUserObject();
        if (nn == 2) {
            this.currentGraGra = this.getGraGra(node);
            this.currentGraph = this.currentGraGra.getGraph();
            if (this.currentGraGra.getRules().size() != 0) {
                this.currentRule = (EdRule)this.currentGraGra.getRules().firstElement();
                this.currentNAC = this.currentRule.getNACs().size() != 0 ? (EdNAC)this.currentRule.getNACs().firstElement() : null;
            } else {
                this.currentRule = null;
                this.currentNAC = null;
            }
            if (this.currentGraGra.getAtomics().size() != 0) {
                this.currentAtomic = (EdAtomic)this.currentGraGra.getAtomics().firstElement();
                this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? (EdAtomic)this.currentAtomic.getConclusions().firstElement() : null;
            } else {
                this.currentAtomic = null;
                this.currentConclusion = null;
            }
            this.currentConstraint = null;
            this.currentRuleConstraint = null;
            this.currentAtomApplCond = null;
            this.isGraGra = true;
        } else if (nn == 3) {
            testGraph = this.getGraph(node);
            if (testGraph != null) {
                this.currentGraph = testGraph;
                if (this.currentGraph.getGraGra() != this.currentGraGra) {
                    this.currentGraGra = this.currentGraph.getGraGra();
                    if (this.currentGraGra.getRules().size() != 0) {
                        this.currentRule = (EdRule)this.currentGraGra.getRules().firstElement();
                        this.currentNAC = this.currentRule.getNACs().size() != 0 ? (EdNAC)this.currentRule.getNACs().firstElement() : null;
                    } else {
                        this.currentRule = null;
                        this.currentNAC = null;
                    }
                    if (this.currentGraGra.getAtomics().size() != 0) {
                        this.currentAtomic = (EdAtomic)this.currentGraGra.getAtomics().firstElement();
                        this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? (EdAtomic)this.currentAtomic.getConclusions().firstElement() : null;
                    } else {
                        this.currentAtomic = null;
                        this.currentConclusion = null;
                    }
                    this.currentConstraint = null;
                    this.currentRuleConstraint = null;
                    this.currentAtomApplCond = null;
                }
                this.isGraph = true;
                return;
            }
            testRule = this.getRule(node);
            if (testRule != null) {
                this.currentRule = testRule;
                this.currentNAC = this.currentRule.getNACs().size() != 0 ? (EdNAC)this.currentRule.getNACs().firstElement() : null;
                if (this.currentRule.getGraGra() != this.currentGraGra) {
                    this.currentGraGra = this.currentRule.getGraGra();
                    this.currentGraph = this.currentGraGra.getGraph();
                    if (this.currentGraGra.getAtomics().size() != 0) {
                        this.currentAtomic = (EdAtomic)this.currentGraGra.getAtomics().firstElement();
                        this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? (EdAtomic)this.currentAtomic.getConclusions().firstElement() : null;
                    } else {
                        this.currentAtomic = null;
                        this.currentConclusion = null;
                    }
                    this.currentConstraint = null;
                    this.currentRuleConstraint = null;
                    this.currentAtomApplCond = null;
                }
                this.isRule = true;
                return;
            }
            testAtomic = this.getAtomic(node);
            if (testAtomic != null) {
                this.currentAtomic = testAtomic;
                if (this.currentAtomic.getGraGra() != this.currentGraGra) {
                    this.currentGraGra = this.currentAtomic.getGraGra();
                    this.currentGraph = this.currentGraGra.getGraph();
                    if (this.currentGraGra.getRules().size() != 0) {
                        this.currentRule = (EdRule)this.currentGraGra.getRules().firstElement();
                        this.currentNAC = this.currentRule.getNACs().size() != 0 ? (EdNAC)this.currentRule.getNACs().firstElement() : null;
                    } else {
                        this.currentRule = null;
                        this.currentNAC = null;
                    }
                    this.currentConstraint = null;
                    this.currentRuleConstraint = null;
                    this.currentAtomApplCond = null;
                }
                this.isAtomic = true;
                return;
            }
            testConstraint = this.getConstraint(node);
            if (testConstraint != null) {
                this.currentConstraint = testConstraint;
                if (this.currentConstraint.getGraGra() != this.currentGraGra) {
                    this.currentGraGra = this.currentConstraint.getGraGra();
                    this.currentGraph = this.currentGraGra.getGraph();
                    if (this.currentGraGra.getRules().size() != 0) {
                        this.currentRule = (EdRule)this.currentGraGra.getRules().firstElement();
                        this.currentNAC = this.currentRule.getNACs().size() != 0 ? (EdNAC)this.currentRule.getNACs().firstElement() : null;
                    } else {
                        this.currentRule = null;
                        this.currentNAC = null;
                    }
                    if (this.currentGraGra.getAtomics().size() != 0) {
                        this.currentAtomic = (EdAtomic)this.currentGraGra.getAtomics().firstElement();
                        this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? (EdAtomic)this.currentAtomic.getConclusions().firstElement() : null;
                    } else {
                        this.currentAtomic = null;
                        this.currentConclusion = null;
                    }
                    this.currentRuleConstraint = null;
                    this.currentAtomApplCond = null;
                }
                this.isConstraint = true;
            }
        } else if (nn == 4) {
            testNAC = this.getNAC(node);
            if (testNAC != null) {
                this.currentNAC = testNAC;
                if (this.currentNAC.getRule() != this.currentRule) {
                    this.currentRule = this.currentNAC.getRule();
                }
                if (this.currentRule.getGraGra() != this.currentGraGra) {
                    this.currentGraGra = this.currentRule.getGraGra();
                    this.currentGraph = this.currentGraGra.getGraph();
                    if (this.currentGraGra.getAtomics().size() != 0) {
                        this.currentAtomic = (EdAtomic)this.currentGraGra.getAtomics().firstElement();
                        this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? (EdAtomic)this.currentAtomic.getConclusions().firstElement() : null;
                    } else {
                        this.currentAtomic = null;
                        this.currentConclusion = null;
                    }
                    this.currentConstraint = null;
                    this.currentRuleConstraint = null;
                    this.currentAtomApplCond = null;
                }
                this.isNAC = true;
                return;
            }
            this.currentRuleContext = this.getRuleContext(node);
            if (this.currentRuleContext != null) {
                if ((EdRule)this.currentRuleContext.first != this.currentRule) {
                    this.currentRule = (EdRule)this.currentRuleContext.first;
                    this.currentNAC = this.currentRule.getNACs().size() != 0 ? (EdNAC)this.currentRule.getNACs().firstElement() : null;
                }
                if (((EdRule)this.currentRuleContext.first).getGraGra() != this.currentGraGra) {
                    this.currentRule = (EdRule)this.currentRuleContext.first;
                    this.currentGraGra = this.currentRule.getGraGra();
                    this.currentGraph = this.currentGraGra.getGraph();
                    this.currentNAC = this.currentRule.getNACs().size() != 0 ? (EdNAC)this.currentRule.getNACs().firstElement() : null;
                    if (this.currentGraGra.getAtomics().size() != 0) {
                        this.currentAtomic = (EdAtomic)this.currentGraGra.getAtomics().firstElement();
                        this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? (EdAtomic)this.currentAtomic.getConclusions().firstElement() : null;
                    } else {
                        this.currentAtomic = null;
                        this.currentConclusion = null;
                    }
                    this.currentConstraint = null;
                    this.currentRuleConstraint = null;
                    this.currentAtomApplCond = null;
                }
                this.isAttrCondition = true;
                return;
            }
            testRuleConstraint = this.getRuleConstraint(node);
            if (testRuleConstraint != null) {
                this.currentRuleConstraint = testRuleConstraint;
                if (this.currentRuleConstraint.getRule() != this.currentRule) {
                    this.currentRule = this.currentRuleConstraint.getRule();
                    this.currentNAC = this.currentRule.getNACs().size() != 0 ? (EdNAC)this.currentRule.getNACs().firstElement() : null;
                }
                if (this.currentRule.getGraGra() != this.currentGraGra) {
                    this.currentGraGra = this.currentRule.getGraGra();
                    this.currentGraph = this.currentGraGra.getGraph();
                    if (this.currentGraGra.getAtomics().size() != 0) {
                        this.currentAtomic = (EdAtomic)this.currentGraGra.getAtomics().firstElement();
                        this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? (EdAtomic)this.currentAtomic.getConclusions().firstElement() : null;
                    } else {
                        this.currentAtomic = null;
                        this.currentConclusion = null;
                    }
                    this.currentConstraint = null;
                    this.currentAtomApplCond = null;
                }
                this.isRuleConstraint = true;
                return;
            }
            testConclusion = this.getConclusion(node);
            if (testConclusion != null) {
                this.currentConclusion = testConclusion;
                if (this.currentConclusion.getParent() != this.currentAtomic) {
                    this.currentAtomic = this.currentConclusion.getParent();
                }
                if (this.currentConclusion.getGraGra() != this.currentGraGra) {
                    this.currentGraGra = this.currentConclusion.getGraGra();
                    this.currentGraph = this.currentGraGra.getGraph();
                    if (this.currentGraGra.getRules().size() != 0) {
                        this.currentRule = (EdRule)this.currentGraGra.getRules().firstElement();
                        this.currentNAC = this.currentRule.getNACs().size() != 0 ? (EdNAC)this.currentRule.getNACs().firstElement() : null;
                    } else {
                        this.currentRule = null;
                        this.currentNAC = null;
                    }
                    this.currentConstraint = null;
                    this.currentRuleConstraint = null;
                    this.currentAtomApplCond = null;
                }
                this.isConclusion = true;
            }
        } else if (nn == 5) {
            this.currentAtomApplCond = this.getAtomApplCond(node);
            if (this.currentAtomApplCond != null) {
                if (this.currentAtomApplCond.getRule() != this.currentRule) {
                    this.currentRule = this.currentAtomApplCond.getRule();
                    this.currentNAC = this.currentRule.getNACs().size() != 0 ? (EdNAC)this.currentRule.getNACs().firstElement() : null;
                    this.currentRuleConstraint = null;
                }
                if (this.currentRule.getGraGra() != this.currentGraGra) {
                    this.currentGraGra = this.currentRule.getGraGra();
                    this.currentGraph = this.currentGraGra.getGraph();
                    if (this.currentGraGra.getAtomics().size() != 0) {
                        this.currentAtomic = (EdAtomic)this.currentGraGra.getAtomics().firstElement();
                        this.currentConclusion = this.currentAtomic.getConclusions().size() != 0 ? (EdAtomic)this.currentAtomic.getConclusions().firstElement() : null;
                    } else {
                        this.currentAtomic = null;
                        this.currentConclusion = null;
                    }
                    this.currentConstraint = null;
                }
                this.isAtomApplCond = true;
                return;
            }
            this.currentConclusionContext = this.getConclusionContext(node);
            if (this.currentConclusionContext != null) {
                if ((EdAtomic)this.currentConclusionContext.first != this.currentConclusion) {
                    this.currentConclusion = (EdAtomic)this.currentConclusionContext.first;
                }
                if (this.currentConclusion.getParent() != this.currentAtomic) {
                    this.currentConclusion = (EdAtomic)this.currentConclusionContext.first;
                    this.currentAtomic = this.currentConclusion.getParent();
                }
                if (this.currentAtomic.getGraGra() != this.currentGraGra) {
                    this.currentGraGra = this.currentAtomic.getGraGra();
                    this.currentGraph = this.currentGraGra.getGraph();
                    if (this.currentGraGra.getRules().size() != 0) {
                        this.currentRule = (EdRule)this.currentGraGra.getRules().firstElement();
                    }
                    this.currentNAC = this.currentRule.getNACs().size() != 0 ? (EdNAC)this.currentRule.getNACs().firstElement() : null;
                    this.currentConstraint = null;
                    this.currentRuleConstraint = null;
                    this.currentAtomApplCond = null;
                }
                this.isAttrCondition = true;
            }
        }
    }

    private void checkCurrentData() {
        System.out.println("GraGraTreeView: Test output ****************");
        if (this.currentAtomApplCond != null) {
            // empty if block
        }
        if (this.currentRuleConstraint != null && this.currentRule != this.currentRuleConstraint.getRule()) {
            System.out.println("- bad currentRuleConstraint or currentRule");
        }
        if (this.currentConstraint != null && this.currentGraGra != this.currentConstraint.getGraGra()) {
            System.out.println("- bad currentConstraint or currentGraGra");
        }
        if (this.currentConclusionContext != null && ((EdAtomic)this.currentConclusionContext.first).getParent().getGraGra() != this.currentGraGra) {
            System.out.println("- bad currentConclusionContext or currentGraGra");
        }
        if (this.currentConclusion != null && this.currentAtomic != this.currentConclusion.getParent()) {
            System.out.println("- bad currentConclusion or currentAtomic");
        }
        if (this.currentAtomic != null && this.currentGraGra != this.currentAtomic.getGraGra()) {
            System.out.println("- bad currentAtomic or currentGraGra");
        }
        if (this.currentNAC != null && this.currentRule != this.currentNAC.getRule()) {
            System.out.println("- bad currentNAC or currentRule");
        }
        if (this.currentRuleContext != null && ((EdRule)this.currentRuleContext.first).getGraGra() != this.currentGraGra) {
            System.out.println("- bad currentRuleContext or currentGraGra");
        }
        if (this.currentRule != null && this.currentGraGra != this.currentRule.getGraGra()) {
            System.out.println("- bad currentRule or currentGraGra");
        }
        if (this.currentGraph != null && this.currentGraGra != this.currentGraph.getGraGra()) {
            System.out.println("- bad currentGraph or currentGraGra");
        }
        System.out.println("************* END ****************");
    }

    /*
     * Enabled aggressive block sorting
     */
    private EdGraGra getGraGra() {
        if (this.currentGraGra != null) {
            return this.currentGraGra;
        }
        if (this.selPath == null) {
            if (this.top.getChildCount() == 1) {
                this.tree.setSelectionRow(1);
                this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
                this.setValueForNew(this.selPath);
                return this.getGraGra((DefaultMutableTreeNode)this.selPath.getLastPathComponent());
            }
            JOptionPane.showMessageDialog(null, "Please select a grammar.");
            return null;
        }
        if (this.top.getChildCount() == 1) {
            this.tree.setSelectionRow(1);
            this.selPath = this.tree.getPathForRow(this.tree.getMinSelectionRow());
            this.setValueForNew(this.selPath);
            return this.getGraGra((DefaultMutableTreeNode)this.selPath.getLastPathComponent());
        }
        if (this.selPath.getPath().length == 2) return this.getGraGra((DefaultMutableTreeNode)this.selPath.getLastPathComponent());
        JOptionPane.showMessageDialog(null, "Please select a grammar.");
        return null;
    }

    private void refreshGraGraRules(DefaultMutableTreeNode graNode) {
        GraGraTreeNodeData sd = (GraGraTreeNodeData)graNode.getUserObject();
        sd.getGraGra().getRules().removeAllElements();
        sd.getGraGra().getBasisGraGra().getRulesVec().removeAllElements();
        for (int i = 0; i < graNode.getChildCount(); ++i) {
            DefaultMutableTreeNode elem = (DefaultMutableTreeNode)graNode.getChildAt(i);
            GraGraTreeNodeData sdElem = (GraGraTreeNodeData)elem.getUserObject();
            if (!sdElem.isRule && !sdElem.isStop) continue;
            sd.getGraGra().getRules().addElement(sdElem.getRule());
            sd.getGraGra().getBasisGraGra().getRulesVec().addElement(sdElem.getRule().getBasisRule());
            sd.getGraGra().setChanged(true);
        }
    }

    private void undoDelete() {
        this.storeGraGra.showStorePalette();
    }

    public void undoDelete(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof EdNAC) {
            if (!this.addNAC(((EdNAC)obj).getRule(), (EdNAC)obj)) {
                this.storeGraGra.storeNAC(((EdNAC)obj).getRule(), (EdNAC)obj);
                return;
            }
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
        } else if (obj instanceof EdGraph) {
            if (((EdGraph)obj).isTypeGraph()) {
                if (!this.addTypeGraph(((EdGraph)obj).getGraGra(), (EdGraph)obj)) {
                    this.storeGraGra.storeTypeGraph(((EdGraph)obj).getGraGra(), (EdGraph)obj);
                    return;
                }
            } else if (!this.addGraph(((EdGraph)obj).getGraGra(), (EdGraph)obj)) {
                this.storeGraGra.storeGraph(((EdGraph)obj).getGraGra(), (EdGraph)obj);
                return;
            }
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
        } else if (obj instanceof EdAtomic) {
            if (((EdAtomic)obj).getParent() == (EdAtomic)obj) {
                if (!this.addAtomic(((EdAtomic)obj).getGraGra(), (EdAtomic)obj)) {
                    this.storeGraGra.storeAtomConstraint(((EdAtomic)obj).getGraGra(), (EdAtomic)obj);
                    return;
                }
            } else if (!this.addConclusion(((EdAtomic)obj).getParent(), (EdAtomic)obj)) {
                this.storeGraGra.storeAtomConclusion(((EdAtomic)obj).getParent(), (EdAtomic)obj);
                return;
            }
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
        } else if (obj instanceof EdRule) {
            if (!this.addRule(((EdRule)obj).getGraGra(), (EdRule)obj)) {
                this.storeGraGra.storeRule(((EdRule)obj).getGraGra(), (EdRule)obj);
                return;
            }
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
        } else if (obj instanceof EdConstraint) {
            if (!this.addConstraint(((EdConstraint)obj).getGraGra(), (EdConstraint)obj)) {
                this.storeGraGra.storeConstraint(((EdConstraint)obj).getGraGra(), (EdConstraint)obj);
                return;
            }
            this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
        }
        this.tree.treeDidChange();
    }

    private void undoDeleteTypeGraph() {
        if (this.currentGraGra != null) {
            EdGraph g = this.storeGraGra.getTypeGraph(this.currentGraGra);
            if (g != null) {
                this.addTypeGraph(this.currentGraGra, g);
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
            }
        } else {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a grammar.");
            return;
        }
    }

    private void undoDeleteGraph() {
        if (this.currentGraGra != null) {
            EdGraph g = this.storeGraGra.getGraph(this.currentGraGra);
            if (g != null) {
                this.addGraph(this.currentGraGra, g);
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
            }
        } else {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a grammar.");
            return;
        }
    }

    private void undoDeleteRule() {
        if (this.currentGraGra != null) {
            EdRule r = this.storeGraGra.getRule(this.currentGraGra);
            if (r != null) {
                this.addRule(this.currentGraGra, r);
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
            }
        } else {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a grammar.");
            return;
        }
    }

    private void undoDeleteAtomicConstraint() {
        if (this.currentGraGra != null) {
            EdAtomic c = this.storeGraGra.getAtomConstraint(this.currentGraGra);
            if (c != null) {
                this.addAtomic(this.currentGraGra, c);
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
            }
        } else {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a grammar.");
            return;
        }
    }

    private void undoDeleteConstraint() {
        if (this.currentGraGra != null) {
            EdConstraint c = this.storeGraGra.getConstraint(this.currentGraGra);
            if (c != null) {
                this.addConstraint(this.currentGraGra, c);
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
            }
        } else {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a grammar.");
            return;
        }
    }

    private void undoDeleteNAC() {
        if (this.currentRule != null) {
            EdNAC n = this.storeGraGra.getNAC(this.currentRule);
            if (n != null) {
                this.addNAC(this.currentRule, n);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select a rule.");
            return;
        }
    }

    private void undoDeleteAtomicConclusion() {
        if (this.currentAtomic != null) {
            EdAtomic c = this.storeGraGra.getAtomConclusion(this.currentAtomic);
            if (c != null) {
                this.addConclusion(this.currentAtomic, c);
                this.fireTreeViewEvent(new TreeViewEvent((Object)this, 22, ""));
            }
        } else {
            JOptionPane.showMessageDialog(null, "Bad selection.\n Please select an atomic constraint.");
            return;
        }
    }

    private int removeWarning(String obj) {
        String msgStr = "Do you want to delete the current " + obj + " ?";
        if (obj.equals("GraGra")) {
            msgStr = "Do you want to close the current " + obj + " ?";
        }
        Object[] options = new Object[]{"YES", "NO"};
        int answer = JOptionPane.showOptionDialog(null, msgStr, "Warning", -1, 2, null, options, options[1]);
        return answer;
    }

    private int saveWarning(String obj) {
        Object[] options = new Object[]{"SAVE", "CANCEL"};
        int answer = JOptionPane.showOptionDialog(null, "This " + obj + " has been changed. \nDo you want to save it ?", "Warning", -1, 2, null, options, options[1]);
        return answer;
    }

    private int changedGraGraWarning(String action) {
        Object[] options = new Object[]{action, "CANCEL"};
        String act = action.toLowerCase();
        if (action.equals("RELOAD")) {
            act = "rewrite";
        }
        int answer = JOptionPane.showOptionDialog(null, "This grammar has been changed.\nDo you want to " + act + " the grammar really?", "Warning", -1, 2, null, options, options[1]);
        return answer;
    }

    private void createMenus() {
        this.menus = new Vector();
        this.file = new JMenu("File", true);
        this.file.setMnemonic('F');
        JMenuItem mi = this.file.add(new JMenuItem("New GraGra            Ctrl+N"));
        mi.setEnabled(true);
        mi.setActionCommand("newGraGra");
        mi.addActionListener(this);
        this.file.addSeparator();
        mi = this.file.add(new JMenuItem("Open                      Ctrl+O"));
        mi.setEnabled(true);
        mi.setActionCommand("open");
        mi.addActionListener(this);
        mi = this.file.add(new JMenuItem("Save                       Ctrl+W"));
        mi.setEnabled(false);
        mi.setActionCommand("save");
        mi.addActionListener(this);
        mi = this.file.add(new JMenuItem("Save As                   Alt+W"));
        mi.setEnabled(false);
        mi.setActionCommand("saveAs");
        mi.addActionListener(this);
        this.file.addSeparator();
        mi = this.file.add(new JMenuItem("Open (Base)"));
        mi.setActionCommand("openBase");
        mi.addActionListener(this);
        mi = this.file.add(new JMenuItem("Save As (Base)"));
        mi.setEnabled(false);
        mi.setActionCommand("saveAsBase");
        mi.addActionListener(this);
        this.file.addSeparator();
        JMenu subm = (JMenu)this.file.add(new JMenu("Export"));
        subm.setEnabled(false);
        mi = subm.add(new JMenuItem("JPEG         Shift+J"));
        mi.setEnabled(true);
        mi.setActionCommand("exportGraphJPEG");
        mi.addActionListener(this);
        mi = subm.add(new JMenuItem("GXL          Shift+X"));
        mi.setEnabled(true);
        mi.setActionCommand("exportGXL");
        mi.addActionListener(this);
        mi = subm.add(new JMenuItem("GTXL        Shift+T"));
        mi.setEnabled(true);
        mi.setActionCommand("exportGTXL");
        mi.addActionListener(this);
        subm = (JMenu)this.file.add(new JMenu("Import"));
        subm.setEnabled(true);
        mi = subm.add(new JMenuItem("GGX                         Shift+Alt+G"));
        mi.setEnabled(true);
        mi.setActionCommand("importGGX");
        mi.addActionListener(this);
        mi = subm.add(new JMenuItem("GXL                          Shift+Alt+X"));
        mi.setEnabled(true);
        mi.setActionCommand("importGXL");
        mi.addActionListener(this);
        mi = new JMenuItem("GTXL");
        mi.setEnabled(false);
        mi.setActionCommand("importGTXL");
        mi.addActionListener(this);
        mi = subm.add(new JMenuItem("OMONDO XMI          Shift+Alt+O"));
        mi.setEnabled(true);
        mi.setActionCommand("importOMONDOXMI");
        mi.addActionListener(this);
        this.file.addSeparator();
        mi = this.file.add(new JMenuItem("Close GraGra           Delete"));
        mi.setEnabled(false);
        mi.setActionCommand("deleteGraGra");
        mi.addActionListener(this);
        this.file.addSeparator();
        mi = this.file.add(new JMenuItem("Quit                        Ctrl+Q"));
        mi.setActionCommand("exit");
        mi.addActionListener(this);
        this.menus.addElement(this.file);
    }

    private void keyPressed(String key) {
        if (key.equals("F")) {
            this.file.doClick();
        } else if (key.equals("G")) {
            this.executeCommand("newGraGra");
        } else if (key.equals("O")) {
            this.executeCommand("open");
        } else if (key.equals("S")) {
            this.executeCommand("save");
        } else if (key.equals("Z")) {
            this.executeCommand("saveAs");
        } else if (key.equals("D")) {
            this.executeCommand("deleteGraGra");
        } else if (key.equals("E")) {
            this.executeCommand("export");
        } else if (key.equals("I")) {
            this.executeCommand("import");
        } else if (key.equals("Q")) {
            this.executeCommand("exit");
        }
    }

    private void resetEnabledOfFileMenuItems(String command) {
        if (command.equals("newGraGra") || command.equals("open") || command.equals("importGXL")) {
            for (int i = 1; i < this.file.getItemCount() - 1; ++i) {
                if (!(this.file.getItem(i) instanceof JMenuItem)) continue;
                JMenuItem mi = this.file.getItem(i);
                mi.setEnabled(true);
            }
        } else if (command.equals("delete") || command.equals("deleteGraGra")) {
            if (this.tree.getRowCount() == 1) {
                for (int i = 1; i < this.file.getItemCount() - 1; ++i) {
                    if (this.file.getItem(i) instanceof JMenu) {
                        JMenu m = (JMenu)this.file.getItem(i);
                        if (m.getText().equals("Import")) {
                            m.setEnabled(true);
                            continue;
                        }
                        m.setEnabled(false);
                        continue;
                    }
                    if (!(this.file.getItem(i) instanceof JMenuItem)) continue;
                    JMenuItem mi = this.file.getItem(i);
                    if (mi.getText().equals("Open") || mi.getText().equals("Open (Base)")) {
                        mi.setEnabled(true);
                        continue;
                    }
                    mi.setEnabled(false);
                }
            }
        } else if (command.equals("print")) {
            // empty if block
        }
    }

    private void createToolBar() {
        this.toolBar = new AGGToolBar(0);
        this.toolBar.addTool("iconable", "NewGraGraIcon", "New GraGra", "newGraGra", this, true);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("imageable", "open", "Open", "open", this, true);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("imageable", "save", "Save", "save", this, false);
        this.toolBar.addSeparator();
        this.toolBar.addTool("iconable", "NewTypeGraphIcon", "New Type Graph", "newTypeGraph", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("iconable", "NewGraphIcon", "New Graph", "newGraph", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("iconable", "NewRuleIcon", "New Rule", "newRule", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("iconable", "NewNACIcon", "New NAC", "newNAC", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("iconable", "NewAtomicIcon", "New Atomic Constraint", "newAtomic", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("iconable", "NewConclusionIcon", "New Atomic Conclusion", "newConclusion", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("iconable", "NewConstraintIcon", "New Constraint", "newConstraint", this, false);
        this.toolBar.addSeparator();
        this.toolBar.addTool("iconable", "DeleteGraGraIcon", "Delete GraGra", "deleteGraGra", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("iconable", "DeleteTypeGraphIcon", "Delete Type Graph", "deleteTypeGraph", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("iconable", "DeleteGraphIcon", "Delete Graph", "deleteGraph", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("iconable", "DeleteRuleIcon", "Delete Rule", "deleteRule", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("iconable", "DeleteNACIcon", "Delete NAC", "deleteNAC", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("iconable", "DeleteAtomicIcon", "Delete Atomic Constraint", "deleteAtomic", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("iconable", "DeleteConclusionIcon", "Delete Atomic Conclusion", "deleteConclusion", this, false);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool("iconable", "DeleteConstraintIcon", "Delete Constraint", "deleteConstraint", this, false);
        this.toolBar.addSeparator();
        this.trash = this.toolBar.addTool("imageable", "trash", "Trash of grammar elements", "undoDelete", this, false);
        this.storeGraGra.setTrash(this.trash);
        this.toolBar.addSeparator();
        this.toolBar.addTool("imageable", "print", "Export JPEG", "exportJPEG", this, false);
    }

    private void resetEnabledOfToolBarItems(boolean enable) {
        for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
            if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton)) continue;
            JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
            b.setEnabled(true);
            if (b.getIcon() instanceof NewTypeGraphIcon) {
                ((NewTypeGraphIcon)b.getIcon()).setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof NewGraphIcon) {
                ((NewGraphIcon)b.getIcon()).setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof NewRuleIcon) {
                ((NewRuleIcon)b.getIcon()).setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof NewNACIcon) {
                ((NewNACIcon)b.getIcon()).setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof NewAtomicIcon) {
                ((NewAtomicIcon)b.getIcon()).setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof NewConclusionIcon) {
                ((NewConclusionIcon)b.getIcon()).setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof NewConstraintIcon) {
                ((NewConstraintIcon)b.getIcon()).setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof DeleteGraGraIcon) {
                ((DeleteGraGraIcon)b.getIcon()).setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof DeleteTypeGraphIcon) {
                ((DeleteTypeGraphIcon)b.getIcon()).setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof DeleteGraphIcon) {
                ((DeleteGraphIcon)b.getIcon()).setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof DeleteRuleIcon) {
                ((DeleteRuleIcon)b.getIcon()).setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof DeleteNACIcon) {
                ((DeleteNACIcon)b.getIcon()).setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof DeleteAtomicIcon) {
                ((DeleteAtomicIcon)b.getIcon()).setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof DeleteConclusionIcon) {
                ((DeleteConclusionIcon)b.getIcon()).setEnabled(enable);
                continue;
            }
            if (!(b.getIcon() instanceof DeleteConstraintIcon)) continue;
            ((DeleteConstraintIcon)b.getIcon()).setEnabled(enable);
        }
        if (this.storeGraGra.isEmpty()) {
            this.trash.setEnabled(false);
        } else {
            this.trash.setEnabled(true);
        }
    }

    private void resetEnabledOfToolBarItems(String command) {
        if (command.equals("newGraGra") || command.equals("open") && this.tree.getRowCount() > 1) {
            for (int i = 4; i < this.toolBar.getComponentCount(); ++i) {
                if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton)) continue;
                JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                b.setEnabled(true);
                if (b.getIcon() instanceof NewTypeGraphIcon) {
                    ((NewTypeGraphIcon)b.getIcon()).setEnabled(true);
                    continue;
                }
                if (b.getIcon() instanceof NewGraphIcon) {
                    ((NewGraphIcon)b.getIcon()).setEnabled(true);
                    continue;
                }
                if (b.getIcon() instanceof NewRuleIcon) {
                    ((NewRuleIcon)b.getIcon()).setEnabled(true);
                    continue;
                }
                if (b.getIcon() instanceof NewNACIcon) {
                    ((NewNACIcon)b.getIcon()).setEnabled(true);
                    continue;
                }
                if (b.getIcon() instanceof NewAtomicIcon) {
                    ((NewAtomicIcon)b.getIcon()).setEnabled(true);
                    continue;
                }
                if (b.getIcon() instanceof NewConclusionIcon) {
                    ((NewConclusionIcon)b.getIcon()).setEnabled(true);
                    continue;
                }
                if (b.getIcon() instanceof NewConstraintIcon) {
                    ((NewConstraintIcon)b.getIcon()).setEnabled(true);
                    continue;
                }
                if (b.getIcon() instanceof DeleteGraGraIcon) {
                    ((DeleteGraGraIcon)b.getIcon()).setEnabled(true);
                    continue;
                }
                if (b.getIcon() instanceof DeleteTypeGraphIcon) {
                    ((DeleteTypeGraphIcon)b.getIcon()).setEnabled(true);
                    continue;
                }
                if (b.getIcon() instanceof DeleteGraphIcon) {
                    ((DeleteGraphIcon)b.getIcon()).setEnabled(true);
                    continue;
                }
                if (b.getIcon() instanceof DeleteRuleIcon) {
                    ((DeleteRuleIcon)b.getIcon()).setEnabled(true);
                    continue;
                }
                if (b.getIcon() instanceof DeleteNACIcon) {
                    ((DeleteNACIcon)b.getIcon()).setEnabled(true);
                    continue;
                }
                if (b.getIcon() instanceof DeleteAtomicIcon) {
                    ((DeleteAtomicIcon)b.getIcon()).setEnabled(true);
                    continue;
                }
                if (b.getIcon() instanceof DeleteConclusionIcon) {
                    ((DeleteConclusionIcon)b.getIcon()).setEnabled(true);
                    continue;
                }
                if (!(b.getIcon() instanceof DeleteConstraintIcon)) continue;
                ((DeleteConstraintIcon)b.getIcon()).setEnabled(true);
            }
        } else if (command.equals("deleteGraGra") && this.tree.getRowCount() == 1) {
            for (int i = 4; i < this.toolBar.getComponentCount(); ++i) {
                if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton)) continue;
                JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                b.setEnabled(false);
                if (b.getIcon() instanceof NewTypeGraphIcon) {
                    ((NewTypeGraphIcon)b.getIcon()).setEnabled(false);
                    continue;
                }
                if (b.getIcon() instanceof NewGraphIcon) {
                    ((NewGraphIcon)b.getIcon()).setEnabled(false);
                    continue;
                }
                if (b.getIcon() instanceof NewRuleIcon) {
                    ((NewRuleIcon)b.getIcon()).setEnabled(false);
                    continue;
                }
                if (b.getIcon() instanceof NewNACIcon) {
                    ((NewNACIcon)b.getIcon()).setEnabled(false);
                    continue;
                }
                if (b.getIcon() instanceof NewAtomicIcon) {
                    ((NewAtomicIcon)b.getIcon()).setEnabled(false);
                    continue;
                }
                if (b.getIcon() instanceof NewConclusionIcon) {
                    ((NewConclusionIcon)b.getIcon()).setEnabled(false);
                    continue;
                }
                if (b.getIcon() instanceof NewConstraintIcon) {
                    ((NewConstraintIcon)b.getIcon()).setEnabled(false);
                    continue;
                }
                if (b.getIcon() instanceof DeleteGraGraIcon) {
                    ((DeleteGraGraIcon)b.getIcon()).setEnabled(false);
                    continue;
                }
                if (b.getIcon() instanceof DeleteTypeGraphIcon) {
                    ((DeleteTypeGraphIcon)b.getIcon()).setEnabled(false);
                    continue;
                }
                if (b.getIcon() instanceof DeleteGraphIcon) {
                    ((DeleteGraphIcon)b.getIcon()).setEnabled(false);
                    continue;
                }
                if (b.getIcon() instanceof DeleteRuleIcon) {
                    ((DeleteRuleIcon)b.getIcon()).setEnabled(false);
                    continue;
                }
                if (b.getIcon() instanceof DeleteNACIcon) {
                    ((DeleteNACIcon)b.getIcon()).setEnabled(false);
                    continue;
                }
                if (b.getIcon() instanceof DeleteAtomicIcon) {
                    ((DeleteAtomicIcon)b.getIcon()).setEnabled(false);
                    continue;
                }
                if (b.getIcon() instanceof DeleteConclusionIcon) {
                    ((DeleteConclusionIcon)b.getIcon()).setEnabled(false);
                    continue;
                }
                if (!(b.getIcon() instanceof DeleteConstraintIcon)) continue;
                ((DeleteConstraintIcon)b.getIcon()).setEnabled(false);
            }
        }
        if (this.storeGraGra.isEmpty()) {
            this.trash.setEnabled(false);
        } else {
            this.trash.setEnabled(true);
        }
    }

    public void resetFileIcons(boolean enable) {
        for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
            if (!(this.toolBar.getComponentAtIndex(i) instanceof JButton)) continue;
            JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
            if (b.getActionCommand().equals("open") || b.getActionCommand().equals("save")) {
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof NewGraGraIcon) {
                ((NewGraGraIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof NewTypeGraphIcon) {
                ((NewTypeGraphIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof NewGraphIcon) {
                ((NewGraphIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof NewRuleIcon) {
                ((NewRuleIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof NewNACIcon) {
                ((NewNACIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof NewAtomicIcon) {
                ((NewAtomicIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof NewConclusionIcon) {
                ((NewConclusionIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof NewConstraintIcon) {
                ((NewConstraintIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof DeleteGraGraIcon) {
                ((DeleteGraGraIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof DeleteTypeGraphIcon) {
                ((DeleteTypeGraphIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof DeleteGraphIcon) {
                ((DeleteGraphIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof DeleteRuleIcon) {
                ((DeleteRuleIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof DeleteNACIcon) {
                ((DeleteNACIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof DeleteAtomicIcon) {
                ((DeleteAtomicIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (b.getIcon() instanceof DeleteConclusionIcon) {
                ((DeleteConclusionIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
                continue;
            }
            if (!(b.getIcon() instanceof DeleteConstraintIcon)) continue;
            ((DeleteConstraintIcon)b.getIcon()).setEnabled(enable);
            b.setEnabled(enable);
        }
        if (this.storeGraGra.isEmpty()) {
            this.trash.setEnabled(false);
        } else {
            this.trash.setEnabled(true);
        }
    }

    public void setExportJPEG(GraphicsExportJPEG jpg) {
        this.exportJPEG = jpg;
    }

    private void saveJPEG() {
        this.exportJPEG.setDirectory(this.directory);
        ((AGGAppl)this.applFrame).exportJPEG();
    }

    private void setToolkit() {
        Frame f = new Frame("");
        f.pack();
        this.tk = f.getToolkit();
    }
}

