/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.editor.impl.EdGraGra;
import agg.gui.HtmlBrowser;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleLayer;
import com.objectspace.jgl.HashSet;
import com.objectspace.jgl.OrderedSet;
import com.objectspace.jgl.OrderedSetIterator;
import com.objectspace.jgl.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class GraGraTriggerRuleOfLayerGUI
extends JDialog
implements ActionListener {
    private JPanel contentPane;
    private JPanel rulePanel;
    private JPanel buttonPanel;
    private JScrollPane ruleScrollPane;
    private JTable ruleTable;
    private JButton closeButton;
    private JButton cancelButton;
    private JButton helpButton;
    private boolean isCancelled;
    private RuleLayer layer;
    private EdGraGra gragra;
    private HtmlBrowser helpBrowser;

    public GraGraTriggerRuleOfLayerGUI(JFrame parent, RuleLayer layer) {
        super((Frame)parent, true);
        this.setTitle("Set Trigger Rule");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GraGraTriggerRuleOfLayerGUI.this.exitForm(evt);
            }
        });
        this.layer = layer;
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        } else {
            this.setLocation(300, 100);
        }
        this.initComponents();
    }

    private void initComponents() {
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setBackground(Color.lightGray);
        this.rulePanel = new JPanel(new BorderLayout());
        this.rulePanel.setBackground(Color.orange);
        this.rulePanel.setBorder(new TitledBorder("Set Trigger Rule for Layer"));
        this.ruleTable = new JTable(new HashTableModel(this.layer, new String[]{"Rule", "Layer", "Trigger"}));
        this.ruleTable.getColumn("Layer").setMaxWidth(50);
        this.ruleTable.setRowSelectionAllowed(true);
        this.ruleTable.setColumnSelectionAllowed(false);
        this.ruleTable.setSelectionBackground(Color.WHITE);
        TableColumn triggerColumn = this.ruleTable.getColumn("Trigger");
        triggerColumn.setMaxWidth(50);
        TriggerCellRenderer tcr = new TriggerCellRenderer(this.ruleTable.getRowCount(), this.ruleTable);
        triggerColumn.setCellRenderer(tcr);
        this.ruleTable.getSelectionModel().setSelectionMode(2);
        int hght = this.getHeight(this.ruleTable.getRowCount(), this.ruleTable.getRowHeight()) + 10;
        this.ruleTable.doLayout();
        this.ruleScrollPane = new JScrollPane(this.ruleTable);
        this.ruleScrollPane.setPreferredSize(new Dimension(300, hght));
        this.rulePanel.add(this.ruleScrollPane);
        this.buttonPanel = new JPanel(new GridLayout(0, 3, 5, 5));
        this.closeButton = new JButton();
        this.closeButton.setActionCommand("close");
        this.closeButton.setText("Close");
        this.closeButton.setToolTipText("Accept entries and close dialog.");
        this.closeButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.isCancelled = false;
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setText("Cancel");
        this.closeButton.setToolTipText("Reject entries and close dialog.");
        this.cancelButton.addActionListener(this);
        this.helpButton = new JButton();
        this.helpButton.setActionCommand("help");
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(this.helpButton);
        this.contentPane.add((Component)this.rulePanel, "Center");
        this.contentPane.add((Component)this.buttonPanel, "South");
        this.contentPane.revalidate();
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(0);
        this.validate();
        this.pack();
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void showGUI() {
        this.setVisible(true);
    }

    private void acceptValues() {
        Hashtable table = ((HashTableModel)this.ruleTable.getModel()).getTable();
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Integer l = (Integer)((Pair)table.get(key)).first;
            ((Rule)key).setLayer(l);
            String trigger = (String)((Pair)table.get(key)).second;
            if (trigger.equals("")) {
                ((Rule)key).setTriggerForLayer(false);
                continue;
            }
            ((Rule)key).setTriggerForLayer(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeButton) {
            this.acceptValues();
            this.setVisible(false);
            if (this.helpBrowser != null) {
                this.helpBrowser.setVisible(false);
                this.helpBrowser.dispose();
            }
            this.dispose();
        } else if (source == this.cancelButton) {
            this.isCancelled = true;
            this.setVisible(false);
            if (this.helpBrowser != null) {
                this.helpBrowser.setVisible(false);
                this.helpBrowser.dispose();
            }
            this.dispose();
        } else if (source == this.helpButton) {
            if (this.helpBrowser != null) {
                this.helpBrowser.dispose();
                this.helpBrowser = null;
            }
            if (this.helpBrowser == null) {
                this.helpBrowser = new HtmlBrowser("TriggerRuleHelp.html");
            }
        }
    }

    public void setGraGra(EdGraGra gra) {
        this.gragra = gra;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    private int getHeight(int rowCount, int rowHeight) {
        int h = (rowCount + 1) * rowHeight;
        if (rowCount > 10) {
            h = 12 * rowHeight;
        }
        return h;
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    public class TriggerCellRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer,
    MouseListener {
        Vector checks;
        public final JTable jtable;

        public TriggerCellRenderer(int size, JTable table) {
            this.addMouseListener(this);
            this.jtable = table;
            this.jtable.addMouseListener(this);
            this.checks = new Vector(size);
            this.initTriggers(size);
        }

        private void initTriggers(int size) {
            for (int i = 0; i < size; ++i) {
                JCheckBox cb = new JCheckBox("", false);
                cb.addMouseListener(this);
                cb.setBackground(Color.WHITE);
                this.checks.addElement(cb);
                Object value = ((DefaultTableModel)this.jtable.getModel()).getValueAt(i, 2);
                if (!((String)value).equals("trigger")) continue;
                cb.setSelected(true);
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object aValue;
            JCheckBox jcb = (JCheckBox)this.checks.get(row);
            if (!isSelected && (aValue = ((DefaultTableModel)this.jtable.getModel()).getValueAt(row, 2)).equals("") && jcb.isSelected()) {
                jcb.setSelected(false);
            }
            return jcb;
        }

        public void mouseClicked(MouseEvent e) {
            for (int i = 0; i < this.checks.size(); ++i) {
                JCheckBox cb = (JCheckBox)this.checks.get(i);
                if (!this.jtable.isCellSelected(i, 2)) continue;
                cb.setSelected(!cb.isSelected());
                this.jtable.updateUI();
                if (cb.isSelected()) {
                    cb.setBackground(this.jtable.getSelectionBackground());
                    ((DefaultTableModel)this.jtable.getModel()).setValueAt("trigger", i, 2);
                } else {
                    ((DefaultTableModel)this.jtable.getModel()).setValueAt("", i, 2);
                }
                Object newValue = ((DefaultTableModel)this.jtable.getModel()).getValueAt(i, 2);
                if (!cb.isSelected()) continue;
                ((HashTableModel)this.jtable.getModel()).refreshTriggerEntries(newValue, i);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public Vector getChecks() {
            return this.checks;
        }
    }

    public class HashTableModel
    extends DefaultTableModel {
        Hashtable table;
        RuleLayer ruleLayer;
        Hashtable triggerTable;

        public HashTableModel(RuleLayer layer, String[] columnNames) {
            for (int i = 0; i < columnNames.length; ++i) {
                this.addColumn(columnNames[i]);
            }
            Hashtable layerTable = layer.getRuleLayer();
            this.table = new Hashtable(layerTable.size());
            this.triggerTable = new Hashtable(layerTable.size());
            Enumeration e = layerTable.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                String trigger = "";
                if (((Rule)key).isTriggerOfLayer()) {
                    trigger = "trigger";
                }
                Pair value = new Pair(layerTable.get(key), trigger);
                this.table.put(key, value);
            }
            this.ruleLayer = layer;
            Integer startLayer = layer.getStartLayer();
            Hashtable invertedRuleLayer = layer.invertLayer();
            OrderedSet ruleLayerSet = new OrderedSet();
            Enumeration en = invertedRuleLayer.keys();
            while (en.hasMoreElements()) {
                ruleLayerSet.add(en.nextElement());
            }
            Integer currentLayer = startLayer;
            boolean nextLayerExists = true;
            while (nextLayerExists && currentLayer != null) {
                HashSet rulesForLayer = (HashSet)invertedRuleLayer.get(currentLayer);
                Enumeration en2 = rulesForLayer.elements();
                while (en2.hasMoreElements()) {
                    Rule rule = (Rule)en2.nextElement();
                    Vector<Object> tmpVector = new Vector<Object>();
                    tmpVector.addElement(rule);
                    tmpVector.addElement(new Integer(rule.getLayer()));
                    String trigger = rule.isTriggerOfLayer() ? new String("trigger") : new String("");
                    tmpVector.addElement(trigger);
                    this.addRow(tmpVector);
                }
                OrderedSetIterator osi = ruleLayerSet.find(currentLayer);
                if (osi == null || osi.atEnd()) {
                    nextLayerExists = false;
                    continue;
                }
                osi.advance();
                currentLayer = (Integer)osi.get();
            }
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Object getValueAt(int row, int column) {
            Object result = super.getValueAt(row, column);
            if (result instanceof Rule) {
                result = ((Rule)result).getName();
            } else {
                Object key = super.getValueAt(row, 0);
                if (column == 2) {
                    String trigger = "";
                    if (key instanceof Rule) {
                        Pair p = (Pair)this.table.get(key);
                        result = (String)p.second;
                    }
                }
            }
            return result;
        }

        public void setValueAt(Object aValue, int row, int column) {
            Object key = super.getValueAt(row, 0);
            try {
                if (column == 1) {
                    Integer i = new Integer((String)aValue);
                    Pair pold = (Pair)this.table.get(key);
                    if (((Integer)pold.first).intValue() != i.intValue()) {
                        super.setValueAt(i, row, column);
                        Pair pnew = new Pair(i, new String(""));
                        this.table.put(key, pnew);
                        this.ruleLayer.getRuleLayer().put(key, i);
                    }
                } else if (column == 2) {
                    String trigger = (String)aValue;
                    if (key instanceof Rule) {
                        Pair pold = (Pair)this.table.get(key);
                        Pair pnew = new Pair(pold.first, trigger);
                        this.table.put(key, pnew);
                    }
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }

        public void refreshTriggerEntries(Object value, int row) {
            Rule rule = (Rule)super.getValueAt(row, 0);
            Enumeration e = this.table.keys();
            while (e.hasMoreElements()) {
                String triggerOfKey;
                int layerOfKey;
                Rule key = (Rule)e.nextElement();
                if (key.equals(rule)) continue;
                int rowOfKey = this.getRow(key);
                int layer = (Integer)this.getValueAt(row, 1);
                if (layer != (layerOfKey = ((Integer)this.getValueAt(rowOfKey, 1)).intValue()) || !(triggerOfKey = (String)this.getValueAt(rowOfKey, 2)).equals("trigger")) continue;
                Pair pold = (Pair)this.table.get(key);
                Pair pnew = new Pair(pold.first, "");
                this.table.put(key, pnew);
                super.setValueAt("", rowOfKey, 2);
                break;
            }
        }

        public Hashtable getTable() {
            return this.table;
        }

        public Rule getRule(String name) {
            Enumeration e = this.table.keys();
            while (e.hasMoreElements()) {
                Rule key = (Rule)e.nextElement();
                if (!key.getName().equals(name)) continue;
                return key;
            }
            return null;
        }

        public int getRow(Rule rule) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                String rname = (String)this.getValueAt(i, 0);
                Rule r = this.getRule(rname);
                if (r == null || !r.equals(rule)) continue;
                return i;
            }
            return -1;
        }
    }
}

