/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.gui.AbstractOptionGUI;
import agg.gui.GraGraTransform;
import agg.gui.icons.CompletionIcon;
import agg.gui.parser.event.OptionEvent;
import agg.xt_basis.CompletionPropertyBits;
import agg.xt_basis.CompletionStrategySelector;
import agg.xt_basis.MorphCompletionStrategy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.border.TitledBorder;

class GraTraOptionGUI
extends AbstractOptionGUI
implements ActionListener {
    private GraGraTransform transform;
    private MorphCompletionStrategy strategy;
    private JComboBox strategyComboBox;
    private JCheckBox injCB;
    private JCheckBox dangCB;
    private JCheckBox identCB;
    private JCheckBox NACsCB;
    private JCheckBox layeredCB;
    private JCheckBox showLayerCB;
    private JCheckBox layeredLoopCB;
    private JCheckBox stopLayerCB;
    private JCheckBox checkRuleApplCB;
    private JCheckBox showGraphAfterStepCB;
    private JCheckBox waitAfterStepCB;
    private JCheckBox selectNewAfterStepCB;
    private JRadioButtonMenuItem consistencyCB1;
    private JRadioButtonMenuItem consistencyCB2;
    private Vector strategyNames = new Vector(3);
    private Vector bitNames = new Vector(3);
    private String bitName = "";
    private Vector checkboxBitNames = new Vector(3);
    private BitSet supportbits;
    private BitSet activebits;
    private JButton confirmButton;
    private JPanel mainPanel;
    private boolean layered;
    private boolean layeredLoop;
    private boolean showLayer;
    private boolean stopLayer;
    private boolean consistency;
    private boolean showGraphAfterStep;
    private boolean waitAfterStep;
    private boolean selectNewAfterStep;
    private boolean checkRuleAppl;

    public GraTraOptionGUI(GraGraTransform trans) {
        this.transform = trans;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        TitledBorder border = new TitledBorder("");
        JPanel stratPanel = new JPanel();
        stratPanel.setLayout(new GridLayout(0, 1));
        JLabel stratLabel = new JLabel("Match completion strategy");
        CompletionIcon icon = new CompletionIcon(Color.black);
        icon.setEnabled(true);
        stratLabel.setIcon(icon);
        stratPanel.add(stratLabel);
        Enumeration strategies = CompletionStrategySelector.getStrategies();
        while (strategies.hasMoreElements()) {
            MorphCompletionStrategy mcs = (MorphCompletionStrategy)strategies.nextElement();
            this.strategyNames.addElement(CompletionStrategySelector.getName(mcs));
        }
        if (this.strategy == null) {
            this.strategy = CompletionStrategySelector.getDefault();
        }
        this.strategyComboBox = new JComboBox(this.strategyNames);
        this.strategyComboBox.setSelectedItem(CompletionStrategySelector.getName(this.strategy));
        this.strategyComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String stratName = (String)e.getItem();
                    Enumeration strats = CompletionStrategySelector.getStrategies();
                    while (strats.hasMoreElements()) {
                        MorphCompletionStrategy mcs = (MorphCompletionStrategy)strats.nextElement();
                        String name = CompletionStrategySelector.getName(mcs);
                        if (!stratName.equals(name)) continue;
                        GraTraOptionGUI.this.strategy = mcs;
                        GraTraOptionGUI.this.setStrategyProperties(GraTraOptionGUI.this.strategy);
                        GraTraOptionGUI.this.transform.setCompletionStrategy(GraTraOptionGUI.this.strategy);
                    }
                }
            }
        });
        stratPanel.add(this.strategyComboBox);
        JPanel matchPanel = new JPanel();
        matchPanel.setBorder(border);
        matchPanel.setLayout(new GridLayout(0, 1));
        JLabel matchLabel = new JLabel("Match conditions");
        icon = new CompletionIcon(Color.black);
        icon.setEnabled(true);
        matchLabel.setIcon(icon);
        matchPanel.add(matchLabel);
        this.supportbits = this.strategy.getSupportedProperties();
        this.activebits = this.strategy.getProperties();
        for (int i = 0; i < CompletionPropertyBits.BITNAME.length; ++i) {
            this.bitName = CompletionPropertyBits.BITNAME[i];
            this.bitNames.addElement(this.bitName);
            JCheckBox cb = new JCheckBox(this.bitName, null, true);
            if (cb.getText().equals("injective")) {
                this.injCB = cb;
            } else if (cb.getText().equals("identification")) {
                this.identCB = cb;
            }
            cb.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    for (int j = 0; j < GraTraOptionGUI.this.checkboxBitNames.size(); ++j) {
                        JCheckBox elem = (JCheckBox)GraTraOptionGUI.this.checkboxBitNames.elementAt(j);
                        if (e.getSource() == elem) {
                            if (elem.isSelected()) {
                                GraTraOptionGUI.this.activebits.set(j);
                                if (elem == GraTraOptionGUI.this.injCB) {
                                    GraTraOptionGUI.this.identCB.setEnabled(false);
                                }
                            } else {
                                GraTraOptionGUI.this.activebits.clear(j);
                                if (elem == GraTraOptionGUI.this.injCB) {
                                    GraTraOptionGUI.this.identCB.setEnabled(true);
                                }
                            }
                        }
                        GraTraOptionGUI.this.fireOptionEvent(new OptionEvent(elem));
                    }
                }
            });
            this.checkboxBitNames.addElement(cb);
            ((JCheckBox)this.checkboxBitNames.lastElement()).setEnabled(this.supportbits.get(i));
            ((JCheckBox)this.checkboxBitNames.lastElement()).setSelected(this.activebits.get(i));
            matchPanel.add((JCheckBox)this.checkboxBitNames.lastElement());
        }
        this.identCB.setEnabled(false);
        JPanel consistencyPanel = new JPanel();
        consistencyPanel.setBorder(border);
        consistencyPanel.setLayout(new GridLayout(0, 1));
        JLabel consistencyLabel = new JLabel("Consistency check during transformation");
        consistencyPanel.add(consistencyLabel);
        ButtonGroup group = new ButtonGroup();
        this.consistencyCB1 = new JRadioButtonMenuItem("consistent transformations only");
        group.add(this.consistencyCB1);
        consistencyPanel.add(this.consistencyCB1);
        this.consistencyCB1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (GraTraOptionGUI.this.consistencyCB1.isSelected()) {
                    GraTraOptionGUI.this.consistency = true;
                }
                GraTraOptionGUI.this.transform.updateGraTraOption("consistency", GraTraOptionGUI.this.consistency);
            }
        });
        this.consistencyCB2 = new JRadioButtonMenuItem("stop after inconsistent transformation");
        group.add(this.consistencyCB2);
        consistencyPanel.add(this.consistencyCB2);
        this.consistencyCB2.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (GraTraOptionGUI.this.consistencyCB2.isSelected()) {
                    GraTraOptionGUI.this.consistency = false;
                }
                GraTraOptionGUI.this.transform.updateGraTraOption("consistency", GraTraOptionGUI.this.consistency);
            }
        });
        JLabel consistencyLabel1 = new JLabel("( If a grammar does not contain any graph constraints,");
        consistencyPanel.add(consistencyLabel1);
        JLabel consistencyLabel2 = new JLabel("  ( de )selection has no effect. )");
        consistencyPanel.add(consistencyLabel2);
        JPanel layerPanel0 = new JPanel(new BorderLayout());
        layerPanel0.setBorder(border);
        JPanel layerPanel = new JPanel(new GridLayout(1, 0));
        JLabel layerLabel1 = new JLabel("Layered rule application");
        layerPanel0.add((Component)layerLabel1, "North");
        layerPanel0.add((Component)layerPanel, "Center");
        this.layeredCB = new JCheckBox("layered", null, false);
        layerPanel.add(this.layeredCB);
        this.layeredCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                GraTraOptionGUI.this.layered = GraTraOptionGUI.this.layeredCB.isSelected();
                GraTraOptionGUI.this.transform.updateGraTraOption("layered", GraTraOptionGUI.this.layered);
                GraTraOptionGUI.this.stopLayer = GraTraOptionGUI.this.layered;
                GraTraOptionGUI.this.stopLayerCB.setSelected(GraTraOptionGUI.this.stopLayer);
                GraTraOptionGUI.this.transform.updateGraTraOption("stopLayer", GraTraOptionGUI.this.stopLayer);
            }
        });
        this.showLayerCB = new JCheckBox("show layer before  transform", null, false);
        layerPanel.add(this.showLayerCB);
        this.showLayerCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (GraTraOptionGUI.this.showLayerCB.isSelected()) {
                    GraTraOptionGUI.this.showLayer = true;
                } else {
                    GraTraOptionGUI.this.showLayer = false;
                }
            }
        });
        JPanel layerPanel2 = new JPanel(new GridLayout(1, 0));
        layerPanel0.add((Component)layerPanel2, "South");
        this.layeredLoopCB = new JCheckBox("loop over layers", null, false);
        layerPanel2.add(this.layeredLoopCB);
        this.layeredLoopCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (GraTraOptionGUI.this.layeredLoopCB.isSelected()) {
                    GraTraOptionGUI.this.layeredLoop = true;
                } else {
                    GraTraOptionGUI.this.layeredLoop = false;
                }
                GraTraOptionGUI.this.transform.updateGraTraOption("layeredLoop", GraTraOptionGUI.this.layeredLoop);
            }
        });
        this.stopLayerCB = new JCheckBox("stop current layer and wait", null, false);
        layerPanel2.add(this.stopLayerCB);
        this.stopLayerCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (GraTraOptionGUI.this.stopLayerCB.isSelected()) {
                    GraTraOptionGUI.this.stopLayer = true;
                } else {
                    GraTraOptionGUI.this.stopLayer = false;
                }
                GraTraOptionGUI.this.transform.updateGraTraOption("stopLayer", GraTraOptionGUI.this.stopLayer);
            }
        });
        JPanel ruleApplPanel = new JPanel();
        ruleApplPanel.setBorder(border);
        ruleApplPanel.setLayout(new GridLayout(0, 1));
        JLabel ruleApplLabel = new JLabel("Rule applicability");
        ruleApplPanel.add(ruleApplLabel);
        this.checkRuleApplCB = new JCheckBox("check rule applicability on the host graph", null, false);
        ruleApplPanel.add(this.checkRuleApplCB);
        this.checkRuleAppl = false;
        this.checkRuleApplCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (GraTraOptionGUI.this.checkRuleApplCB.isSelected()) {
                    GraTraOptionGUI.this.checkRuleAppl = true;
                } else {
                    GraTraOptionGUI.this.checkRuleAppl = false;
                }
                GraTraOptionGUI.this.transform.updateGraTraOption("checkRuleApplicability", GraTraOptionGUI.this.checkRuleAppl);
            }
        });
        JPanel displayPanel0 = new JPanel(new BorderLayout());
        displayPanel0.setBorder(border);
        JPanel displayPanel = new JPanel(new GridLayout(1, 0));
        JLabel displayLabel = new JLabel("Graph display settings");
        displayPanel0.add((Component)displayLabel, "North");
        displayPanel0.add((Component)displayPanel, "Center");
        this.showGraphAfterStepCB = new JCheckBox("show after step", null, true);
        displayPanel.add(this.showGraphAfterStepCB);
        this.showGraphAfterStep = true;
        this.showGraphAfterStepCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (GraTraOptionGUI.this.showGraphAfterStepCB.isSelected()) {
                    GraTraOptionGUI.this.showGraphAfterStep = true;
                } else {
                    GraTraOptionGUI.this.showGraphAfterStep = false;
                }
            }
        });
        this.waitAfterStepCB = new JCheckBox("wait after step", null, false);
        displayPanel.add(this.waitAfterStepCB);
        this.waitAfterStep = false;
        this.waitAfterStepCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (GraTraOptionGUI.this.waitAfterStepCB.isSelected()) {
                    GraTraOptionGUI.this.waitAfterStep = true;
                } else {
                    GraTraOptionGUI.this.waitAfterStep = false;
                }
            }
        });
        JPanel displayPanel1 = new JPanel(new GridLayout(1, 0));
        displayPanel0.add((Component)displayPanel1, "South");
        this.selectNewAfterStepCB = new JCheckBox("select new objects after step", null, false);
        displayPanel1.add(this.selectNewAfterStepCB);
        this.selectNewAfterStep = false;
        this.selectNewAfterStepCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (GraTraOptionGUI.this.selectNewAfterStepCB.isSelected()) {
                    GraTraOptionGUI.this.selectNewAfterStep = true;
                } else {
                    GraTraOptionGUI.this.selectNewAfterStep = false;
                }
            }
        });
        this.constrainBuild(this, stratPanel, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(this, matchPanel, 0, 1, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(this, consistencyPanel, 0, 2, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(this, layerPanel0, 0, 3, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(this, ruleApplPanel, 0, 4, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(this, displayPanel0, 0, 5, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.validate();
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 640);
    }

    public String getTabTitle() {
        return "Transformation";
    }

    public String getTabTip() {
        return "Transformation Options";
    }

    public void addActionListener(ActionListener l) {
        this.layeredCB.addActionListener(l);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JCheckBox && ((JCheckBox)source).getText().equals("layered")) {
            this.layeredCB.doClick();
        }
    }

    public void update() {
        this.update(this.transform.getGraTraOptionsList());
    }

    public void update(Vector optionNames) {
        if (optionNames.contains("CSP")) {
            this.strategyComboBox.setSelectedItem("CSP");
        } else if (optionNames.contains("CSP w/o BJ")) {
            this.strategyComboBox.setSelectedItem("CSP w/o BJ");
        } else if (optionNames.contains("Simple BT")) {
            this.strategyComboBox.setSelectedItem("Simple BT");
        }
        String stratName = (String)this.strategyComboBox.getSelectedItem();
        Enumeration strats = CompletionStrategySelector.getStrategies();
        while (strats.hasMoreElements()) {
            MorphCompletionStrategy mcs = (MorphCompletionStrategy)strats.nextElement();
            String name = CompletionStrategySelector.getName(mcs);
            if (!stratName.equals(name)) continue;
            this.strategy = mcs;
        }
        this.strategy = CompletionStrategySelector.getDefault();
        this.supportbits = this.strategy.getSupportedProperties();
        this.activebits = this.strategy.getProperties();
        for (int j = 0; j < this.checkboxBitNames.size(); ++j) {
            JCheckBox elem = (JCheckBox)this.checkboxBitNames.elementAt(j);
            elem.setEnabled(this.supportbits.get(j));
            if (!elem.isEnabled()) continue;
            if (elem.getText().equals("injective")) {
                if (optionNames.contains("injective")) {
                    elem.setSelected(true);
                    this.activebits.set(j);
                } else {
                    elem.setSelected(false);
                    this.activebits.clear(j);
                }
            } else if (elem.getText().equals("dangling")) {
                if (optionNames.contains("dangling")) {
                    elem.setSelected(true);
                    this.activebits.set(j);
                } else {
                    elem.setSelected(false);
                    this.activebits.clear(j);
                }
            } else if (elem.getText().equals("identification")) {
                if (optionNames.contains("identification")) {
                    elem.setSelected(true);
                    this.activebits.set(j);
                } else {
                    elem.setSelected(false);
                    this.activebits.clear(j);
                }
            } else if (elem.getText().equals("NACs")) {
                if (optionNames.contains("NACs")) {
                    elem.setSelected(true);
                    this.activebits.set(j);
                } else {
                    elem.setSelected(false);
                    this.activebits.clear(j);
                }
            }
            this.fireOptionEvent(new OptionEvent(elem));
        }
        if (this.injCB.isSelected()) {
            this.identCB.setEnabled(false);
        } else {
            this.identCB.setEnabled(true);
        }
        if (optionNames.contains("consistency")) {
            this.consistencyCB1.setSelected(true);
            this.consistency = true;
        } else {
            this.consistencyCB2.setSelected(true);
            this.consistency = false;
        }
        if (optionNames.contains("stopLayer")) {
            this.stopLayerCB.setSelected(true);
            this.stopLayer = true;
        } else {
            this.stopLayerCB.setSelected(false);
            this.stopLayer = false;
        }
        if (optionNames.contains("layered")) {
            if (!this.layeredCB.isSelected()) {
                this.layeredCB.doClick();
            }
            this.layered = true;
            this.stopLayerCB.setSelected(true);
            this.stopLayer = true;
        } else {
            if (this.layeredCB.isSelected()) {
                this.layeredCB.doClick();
            }
            this.layered = false;
        }
        if (optionNames.contains("layeredLoop")) {
            this.layeredLoopCB.setSelected(true);
            this.layeredLoop = true;
        } else {
            this.layeredLoopCB.setSelected(false);
            this.layeredLoop = false;
        }
    }

    public void doClick(String button) {
        if (button.equals("layered")) {
            this.layeredCB.doClick();
        }
    }

    public MorphCompletionStrategy getMorphCompletioStrategy() {
        return this.strategy;
    }

    public boolean consistencyEnabled() {
        return this.consistency;
    }

    public boolean layeredEnabled() {
        return this.layered;
    }

    public boolean showLayerEnabled() {
        return this.showLayer;
    }

    public boolean showGraphAfterStepEnabled() {
        return this.showGraphAfterStep;
    }

    public boolean waitAfterStepEnabled() {
        return this.waitAfterStep;
    }

    public boolean checkRuleApplicabilityEnabled() {
        return this.checkRuleAppl;
    }

    public boolean selectNewAfterStepEnabled() {
        return this.selectNewAfterStep;
    }

    public boolean layeredLoopEnabled() {
        return this.layeredLoop;
    }

    public boolean stopLayerEnabled() {
        return this.stopLayer;
    }

    public void addOptionListener(String option, ActionListener l) {
        if (option.equals("layered")) {
            this.layeredCB.addActionListener(l);
        }
        if (option.equals("waitAfterStep")) {
            this.waitAfterStepCB.addActionListener(l);
        }
    }

    private void setStrategyProperties(MorphCompletionStrategy s) {
        this.supportbits = s.getSupportedProperties();
        this.activebits = s.getProperties();
        for (int i = 0; i < CompletionPropertyBits.BITNAME.length; ++i) {
            ((JCheckBox)this.checkboxBitNames.elementAt(i)).setSelected(this.activebits.get(i));
            ((JCheckBox)this.checkboxBitNames.elementAt(i)).setEnabled(this.supportbits.get(i));
        }
    }

    private void outStrategyProperties(MorphCompletionStrategy s) {
        for (int i = 0; i < CompletionPropertyBits.BITNAME.length; ++i) {
            if (!s.getProperties().get(i)) continue;
            System.out.println((String)this.bitNames.elementAt(i));
        }
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }
}

