/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.attribute.gui.AttrTopEditor;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.editor.impl.GraphPanel;
import agg.gui.EditPopupMenu;
import agg.gui.EditSelPopupMenu;
import agg.gui.GraGraEditor;
import agg.gui.GraphicsExportJPEG;
import agg.gui.ModePopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GraphEditor
extends JPanel
implements MouseListener {
    private Toolkit tk;
    private JFrame applFrame;
    private GraGraEditor gragraEditor;
    private AttrTopEditor attrEditor;
    private GraphPanel graphPanel = new GraphPanel();
    private JLabel title;
    private String graphName;
    private String gragraName;
    private EdGraGra eGra;
    private EdGraph eGraph;
    private EdGraph sourceOfCopy;
    private String msg = "";
    private ModePopupMenu modePopupMenu;
    private EditPopupMenu editPopupMenu;
    private EditSelPopupMenu editSelPopupMenu;
    private boolean isEditPopupMenu = false;
    private boolean isEditSelPopupMenu = false;
    private boolean isEmpty = true;
    private GraphicsExportJPEG exportJPEG;
    private JButton exportJPEGButton;
    private JPanel mainPanel = this.graphPanel.getCanvas();

    public GraphEditor() {
        this((GraGraEditor)null);
    }

    public GraphEditor(GraGraEditor anEditor) {
        super(new BorderLayout());
        this.graphPanel.getCanvas().addMouseListener(this);
        this.title = new JLabel("    ");
        this.add((Component)this.title, "North");
        this.exportJPEGButton = this.createExportJPEGButton();
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.add((Component)this.title, "West");
        titlePanel.add((Component)this.exportJPEGButton, "East");
        this.add((Component)titlePanel, "North");
        this.add((Component)this.graphPanel, "Center");
        this.gragraEditor = anEditor;
        this.setToolkit();
    }

    private JButton createExportJPEGButton() {
        ImageIcon image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/print.gif"));
        if (image != null) {
            JButton b = new JButton(image);
            b.setToolTipText("Export Graph JPEG");
            b.setMargin(new Insets(-5, 0, -5, 0));
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (GraphEditor.this.exportJPEG != null) {
                        GraphEditor.this.exportJPEG.save(GraphEditor.this.mainPanel);
                    }
                }
            });
            b.setEnabled(false);
            return b;
        }
        return null;
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 200);
    }

    public void setTitle(String str) {
        this.title.setText(str);
    }

    public void setTitle(String str1, String str2) {
        if (!str1.equals("") && !str2.equals("")) {
            this.graphName = str1;
            this.gragraName = str2;
            this.title.setText("  " + this.graphName + "  of  " + this.gragraName);
        } else if (!str1.equals("") && str2.equals("")) {
            this.graphName = str1;
            this.title.setText("  " + this.graphName + "  of  " + this.gragraName);
        } else if (str1.equals("") && !str2.equals("")) {
            this.gragraName = str2;
            this.title.setText("  " + this.graphName + "  of  " + this.gragraName);
        }
    }

    public void mouseEntered(MouseEvent e) {
        Object source = e.getSource();
        if (source == this.graphPanel.getCanvas() && this.applFrame != null) {
            this.applFrame.setCursor(this.graphPanel.getEditCursor());
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(0));
        }
    }

    public void mousePressed(MouseEvent e) {
        Object source = e.getSource();
        int x = e.getX();
        int y = e.getY();
        if (e.isPopupTrigger()) {
            if (this.eGraph != null && this.eGraph.isEditable()) {
                this.showPopupMenu(e);
            }
        } else if (SwingUtilities.isMiddleMouseButton(e)) {
            if (this.graphPanel.getCanvas().getPickedObject(e.getX(), e.getY(), this.getGraphics().getFontMetrics()) != null && this.applFrame != null) {
                this.applFrame.setCursor(new Cursor(13));
            }
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            if (this.graphPanel.getEditMode() != 13 && this.graphPanel.getEditMode() != 151 && this.applFrame != null) {
                this.applFrame.setCursor(new Cursor(0));
            }
            switch (this.graphPanel.getEditMode()) {
                case 11: {
                    break;
                }
                case 13: {
                    EdArc ea;
                    EdGraphObject ego;
                    if (source != this.graphPanel.getCanvas() || this.eGraph == null || (ego = this.eGraph.getPicked(x, y)) == null || !ego.isArc() || (ea = (EdArc)ego) == null || ea.getAnchorID() != 1) break;
                    if (this.applFrame != null) {
                        this.applFrame.setCursor(new Cursor(6));
                        break;
                    }
                    if (ea.getAnchorID() != 2) break;
                    if (this.applFrame != null) {
                        this.applFrame.setCursor(new Cursor(7));
                        break;
                    }
                    if (ea.getAnchorID() != 3) break;
                    if (this.applFrame != null) {
                        this.applFrame.setCursor(new Cursor(5));
                        break;
                    }
                    if (ea.getAnchorID() != 4) break;
                    if (this.applFrame != null) {
                        this.applFrame.setCursor(new Cursor(4));
                        break;
                    }
                    if (ea.getAnchorID() != 0 || this.applFrame == null) break;
                    this.applFrame.setCursor(new Cursor(13));
                    break;
                }
                case 1201: {
                    break;
                }
                case 1202: {
                    break;
                }
                case 114: {
                    if (source != this.graphPanel.getCanvas() || this.eGraph == null) break;
                    EdGraphObject ego = this.eGraph.getPicked(x, y);
                    if (ego != null) {
                        this.getAttrEditor(ego);
                        this.getAttrEditor().enableContextEditor(false);
                        if (this.gragraEditor == null && this.getAttrEditor() == null) break;
                        this.gragraEditor.setAttrEditorOnTop(this.getAttrEditor().getComponent());
                        break;
                    }
                    this.errSound();
                    break;
                }
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (this.eGraph != null && this.eGraph.isEditable()) {
                this.showPopupMenu(e);
            }
            this.updateGraphics();
        } else if (e.getSource() == this.graphPanel.getCanvas()) {
            switch (this.graphPanel.getEditMode()) {
                case 113: {
                    this.msg = "You have just picked the source of an edge. Click on a node to get the target.";
                    break;
                }
                case 11: {
                    this.drawModeProc();
                    if (this.applFrame != null) {
                        this.applFrame.setCursor(new Cursor(0));
                    }
                    this.gragraEditor.setMsg(this.getMsg());
                    break;
                }
                case 13: {
                    if (this.applFrame == null) break;
                    this.applFrame.setCursor(new Cursor(13));
                    break;
                }
                case 151: {
                    if (this.applFrame == null) break;
                    this.applFrame.setCursor(new Cursor(1));
                    break;
                }
                case 15: {
                    if (this.eGraph.getMsg().length() != 0) {
                        this.msg = this.eGraph.getMsg();
                    }
                    if (this.graphPanel.getLastEditMode() != 15) {
                        if (this.gragraEditor != null) {
                            this.gragraEditor.setEditMode(this.graphPanel.getLastEditMode());
                        } else {
                            this.setEditMode(this.graphPanel.getLastEditMode());
                        }
                        if (this.applFrame != null) {
                            this.applFrame.setCursor(this.graphPanel.getLastEditCursor());
                        }
                    } else {
                        if (this.gragraEditor != null) {
                            this.gragraEditor.setEditMode(this.graphPanel.getLastEditMode());
                        } else {
                            this.setEditMode(this.graphPanel.getLastEditMode());
                        }
                        if (this.applFrame != null) {
                            this.applFrame.setCursor(new Cursor(0));
                        }
                    }
                    if (this.gragraEditor != null) {
                        this.gragraEditor.resetAfterCopy();
                        if (this.sourceOfCopy != null && !this.eGraph.equals(this.sourceOfCopy)) {
                            this.sourceOfCopy.eraseSelected(this.gragraEditor.getPanelOfGraph(this.sourceOfCopy).getCanvas().getGraphics(), this.gragraEditor.getPanelOfGraph(this.sourceOfCopy).getCanvas().getScale(), true);
                            this.sourceOfCopy.deselectAll();
                        }
                        this.gragraEditor.setMsg(this.getMsg());
                    }
                    this.eGraph.setGraphToCopy(null);
                    this.sourceOfCopy = null;
                    break;
                }
                default: {
                    if (this.applFrame == null) break;
                    this.applFrame.setCursor(this.graphPanel.getEditCursor());
                }
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public GraphPanel getGraphPanel() {
        return this.graphPanel;
    }

    public EdGraph getGraph() {
        return this.eGraph;
    }

    public EdGraGra getGraGra() {
        return this.eGra;
    }

    public GraGraEditor getGraGraEditor() {
        return this.gragraEditor;
    }

    public String getMsg() {
        return this.msg;
    }

    public boolean hasGraph() {
        return this.eGraph != null;
    }

    public void setFrame(JFrame f) {
        this.applFrame = f;
    }

    public void setGraph(EdGraph eg) {
        this.eGraph = eg;
        if (this.eGraph != null) {
            this.eGra = this.eGraph.getGraGra();
            this.isEmpty = false;
        } else {
            this.isEmpty = true;
        }
        if (this.eGraph != null && this.eGra != null) {
            this.setTitle(this.eGraph.getBasisGraph().getName(), this.eGra.getName());
            this.graphPanel.setGraph(this.eGraph);
        } else if (this.eGraph != null) {
            this.setTitle(this.eGraph.getBasisGraph().getName(), "");
            this.graphPanel.setGraph(this.eGraph);
        } else {
            this.setTitle("    ");
            this.graphPanel.setGraph(null);
            this.exportJPEGButton.setEnabled(false);
        }
        if (this.eGraph != null && this.exportJPEG != null && this.exportJPEGButton != null) {
            this.exportJPEGButton.setEnabled(true);
        }
    }

    public void setExportJPEG(GraphicsExportJPEG jpg) {
        this.exportJPEG = jpg;
    }

    public void clear() {
        this.setTitle("    ");
        this.graphPanel.setGraph(null);
        this.isEmpty = true;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean hasOneSelection() {
        if (this.eGraph == null) {
            return false;
        }
        return this.graphPanel.getGraph().hasOneSelection();
    }

    public boolean hasSelection() {
        if (this.eGraph == null) {
            return false;
        }
        return this.graphPanel.getGraph().hasSelection();
    }

    public void updateGraphics() {
        this.graphPanel.updateGraphics();
    }

    public void updateGraphics(boolean graphDimensionCheck) {
        this.graphPanel.updateGraphics(graphDimensionCheck);
    }

    public void saveScrollBarValue() {
        this.graphPanel.getCanvas().saveScrollBarValue();
    }

    public void setAttrEditor(AttrTopEditor attrEditor) {
        this.attrEditor = attrEditor;
    }

    public final AttrTopEditor getAttrEditor() {
        return this.attrEditor;
    }

    public final AttrTopEditor getAttrEditor(EdGraphObject ego) {
        EdArc ea;
        if (this.attrEditor == null) {
            return null;
        }
        if (ego.isNode()) {
            EdNode en = (EdNode)ego;
            if (en.getBasisNode() != null) {
                this.attrEditor.setTuple(en.getBasisNode().getAttribute());
                en.setAttrViewSetting(this.attrEditor.getViewSetting());
                if (!en.isAttrObserver()) {
                    this.attrEditor.getViewSetting().addObserver(en, en.getBasisNode().getAttribute());
                    en.setAttrObserver(true);
                }
                en.setGraphPanel(this.graphPanel);
            }
        } else if (ego.isArc() && (ea = (EdArc)ego).getBasisArc() != null) {
            this.attrEditor.setTuple(ea.getBasisArc().getAttribute());
            ea.setAttrViewSetting(this.attrEditor.getViewSetting());
            if (!ea.isAttrObserver()) {
                this.attrEditor.getViewSetting().addObserver(ea, ea.getBasisArc().getAttribute());
                ea.setAttrObserver(true);
            }
            ea.setGraphPanel(this.graphPanel);
        }
        return this.attrEditor;
    }

    public void setModePopupMenu(ModePopupMenu pm) {
        this.modePopupMenu = pm;
    }

    public void setEditPopupMenu(EditPopupMenu pm) {
        this.editPopupMenu = pm;
    }

    public void setEditSelPopupMenu(EditSelPopupMenu pm) {
        this.editSelPopupMenu = pm;
    }

    public void setEditMode(int mode) {
        switch (mode) {
            case 11: {
                this.drawModeProc();
                break;
            }
            case 12: {
                this.selectModeProc();
                break;
            }
            case 13: {
                this.moveModeProc();
                break;
            }
            case 114: {
                this.attributesModeProc();
                break;
            }
            case 31: {
                this.ruleDefModeProc();
                break;
            }
            case 81: {
                this.nacDefModeProc();
                break;
            }
            case 42: {
                this.matchDefModeProc();
                break;
            }
            case 15: {
                this.duplicateModeProc();
                break;
            }
            case 115: {
                this.mapModeProc();
                break;
            }
            case 116: {
                this.unmapModeProc();
                break;
            }
            case 1201: {
                this.setParentModeProc();
                break;
            }
            case 1202: {
                this.unsetParentModeProc();
                break;
            }
            case 117: {
                this.mapselModeProc();
                break;
            }
            case 118: {
                this.unmapselModeProc();
                break;
            }
            case 9: {
                this.viewModeProc();
                break;
            }
        }
    }

    public int getMode() {
        return this.graphPanel.getEditMode();
    }

    public void setEditCursor(Cursor cur) {
        this.graphPanel.setEditCursor(cur);
    }

    private void drawModeProc() {
        this.graphPanel.setEditMode(11);
        this.graphPanel.setEditCursor(new Cursor(0));
        this.msg = "Click on the background to get a node / on a source node and a target node to get an edge.";
    }

    private void selectModeProc() {
        if (this.graphPanel.getEditMode() == 12) {
            return;
        }
        this.graphPanel.setEditMode(12);
        this.graphPanel.setEditCursor(new Cursor(12));
        this.msg = "Click on an object to select it.";
    }

    private void moveModeProc() {
        if (this.graphPanel.getEditMode() == 13) {
            return;
        }
        this.graphPanel.setEditMode(13);
        this.graphPanel.setEditCursor(new Cursor(13));
        this.msg = "Press and drag the button when the cursor points to an object.";
    }

    private void attributesModeProc() {
        if (this.graphPanel.getEditMode() == 114) {
            return;
        }
        this.graphPanel.setEditMode(114);
        this.graphPanel.setEditCursor(new Cursor(0));
        this.msg = "Click on an object to get the attribute editor.";
    }

    private void ruleDefModeProc() {
        if (this.graphPanel.getEditMode() == 31) {
            return;
        }
        this.graphPanel.setEditMode(31);
        this.graphPanel.setEditCursor(new Cursor(12));
    }

    private void nacDefModeProc() {
        if (this.graphPanel.getEditMode() == 81) {
            return;
        }
        this.graphPanel.setEditMode(81);
        this.graphPanel.setEditCursor(new Cursor(12));
    }

    private void matchDefModeProc() {
        if (this.graphPanel.getEditMode() == 42) {
            return;
        }
        this.graphPanel.setEditMode(42);
        this.graphPanel.setEditCursor(new Cursor(12));
    }

    private void mapModeProc() {
        this.graphPanel.setEditMode(115);
        this.graphPanel.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
    }

    private void unmapModeProc() {
        this.graphPanel.setEditMode(116);
        this.graphPanel.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
    }

    private void setParentModeProc() {
        this.graphPanel.setEditMode(1201);
        this.graphPanel.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
    }

    private void unsetParentModeProc() {
        this.graphPanel.setEditMode(1202);
        this.graphPanel.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
    }

    private void mapselModeProc() {
        if (this.graphPanel.getEditMode() == 117) {
            return;
        }
        this.graphPanel.setEditMode(117);
        this.graphPanel.setEditCursor(new Cursor(12));
    }

    private void unmapselModeProc() {
        if (this.graphPanel.getEditMode() == 118) {
            return;
        }
        this.graphPanel.setEditMode(118);
        this.graphPanel.setEditCursor(new Cursor(12));
    }

    private void duplicateModeProc() {
        if (this.eGraph == null) {
            return;
        }
        this.graphPanel.setLastEditMode(this.graphPanel.getEditMode());
        this.graphPanel.setLastEditCursor(this.graphPanel.getEditCursor());
        this.graphPanel.setEditMode(15);
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(1));
        }
        this.msg = "To get a copy click on the background of the same panel.";
    }

    private void viewModeProc() {
        this.graphPanel.setEditMode(9);
    }

    public void attrsProc() {
        if (this.graphPanel.getEditMode() == 9) {
            return;
        }
        if (this.eGraph == null) {
            return;
        }
        if (this.graphPanel.getGraph().hasOneSelection()) {
            EdGraphObject ego = (EdGraphObject)this.graphPanel.getGraph().getSelectedObjs().firstElement();
            this.getAttrEditor(ego);
            this.getAttrEditor().enableContextEditor(false);
            if (this.gragraEditor != null) {
                this.gragraEditor.setAttrEditorOnTop(this.getAttrEditor().getComponent());
            }
            this.msg = "";
        } else {
            this.msg = "No object is selected.";
        }
    }

    public boolean deleteProc() {
        if (this.graphPanel.getEditMode() == 9) {
            return false;
        }
        if (this.eGraph == null) {
            return false;
        }
        boolean result = false;
        if (this.hasSelection()) {
            this.graphPanel.deleteSelected();
            this.graphPanel.updateGraphicsAfterDelete();
            result = true;
        }
        return result;
    }

    public void copyProc() {
        if (this.graphPanel.getEditMode() == 9) {
            return;
        }
        if (!this.hasSelection()) {
            this.msg = "Copy -> No object is selected.";
            return;
        }
        this.graphPanel.setLastEditMode(this.graphPanel.getEditMode());
        this.msg = "";
        this.setEditMode(15);
    }

    public void selectAllProc() {
        if (this.eGraph == null) {
            return;
        }
        this.graphPanel.getGraph().selectAll();
        this.graphPanel.updateGraphics();
    }

    public void selectNodeTypeProc() {
        if (this.eGraph == null) {
            return;
        }
        if (!this.graphPanel.getGraph().getSelectedArcs().isEmpty() || !this.graphPanel.getGraph().getSelectedNodes().isEmpty()) {
            this.graphPanel.getGraph().eraseSelected(this.graphPanel.getCanvas().getGraphics(), this.graphPanel.getCanvas().getScale(), true);
        }
        this.graphPanel.getGraph().selectObjectsOfSelectedNodeType();
        if (!this.graphPanel.getGraph().getSelectedNodes().isEmpty()) {
            this.graphPanel.getGraph().drawSelected(this.graphPanel.getCanvas().getGraphics(), this.graphPanel.getCanvas().getScale());
        }
    }

    public void selectArcTypeProc() {
        if (this.eGraph == null) {
            return;
        }
        if (!this.graphPanel.getGraph().getSelectedNodes().isEmpty() || !this.graphPanel.getGraph().getSelectedArcs().isEmpty()) {
            this.graphPanel.getGraph().eraseSelected(this.graphPanel.getCanvas().getGraphics(), this.graphPanel.getCanvas().getScale(), true);
        }
        this.graphPanel.getGraph().selectObjectsOfSelectedArcType();
        if (!this.graphPanel.getGraph().getSelectedArcs().isEmpty()) {
            this.graphPanel.getGraph().drawSelected(this.graphPanel.getCanvas().getGraphics(), this.graphPanel.getCanvas().getScale());
        }
    }

    public void deselectAllProc() {
        if (this.eGraph == null) {
            return;
        }
        this.graphPanel.getGraph().deselectAll();
        this.graphPanel.updateGraphics();
    }

    public void straigthenArcsProc() {
        if (this.graphPanel.getEditMode() == 9) {
            return;
        }
        if (this.eGraph == null) {
            return;
        }
        if (this.graphPanel.getGraph().hasSelection()) {
            this.graphPanel.getGraph().eraseSelected(this.graphPanel.getCanvas().getGraphics(), this.graphPanel.getCanvas().getScale(), false);
            this.graphPanel.getGraph().straightSelectedArcs();
            this.graphPanel.getGraph().drawSelected(this.graphPanel.getCanvas().getGraphics(), this.graphPanel.getCanvas().getScale());
            this.msg = "";
        } else {
            this.msg = "Bad selection";
        }
    }

    public void setGraphToCopy(EdGraph g) {
        if (this.eGraph != null) {
            this.eGraph.setGraphToCopy(g);
        }
    }

    public EdGraph getSelectedAsGraphCopy() {
        if (this.eGraph == null) {
            return null;
        }
        this.sourceOfCopy = this.eGraph;
        return this.eGraph.getSelectedAsGraphCopy();
    }

    public void setSourceOfCopy(EdGraph g) {
        this.sourceOfCopy = g;
    }

    public EdGraph getSourceOfCopy() {
        return this.sourceOfCopy;
    }

    private void showPopupMenu(MouseEvent e) {
        if (e.getSource() == this.graphPanel.getCanvas()) {
            if (this.editPopupMenu != null) {
                this.editPopupMenu.setEditor(this);
                this.editPopupMenu.setParentFrame(this.applFrame);
            }
            if (this.editSelPopupMenu != null) {
                this.editSelPopupMenu.setEditor(this);
                this.editSelPopupMenu.setParentFrame(this.applFrame);
            }
        } else {
            return;
        }
        this.isEditPopupMenu = false;
        this.isEditSelPopupMenu = false;
        if (this.modePopupMenu != null && this.modePopupMenu.invoked(this, this.graphPanel, e.getX(), e.getY())) {
            this.modePopupMenu.show(e.getComponent(), e.getX(), e.getY());
        } else if (this.editPopupMenu != null && this.editPopupMenu.invoked(this.graphPanel, e.getX(), e.getY())) {
            this.isEditPopupMenu = true;
            this.editPopupMenu.setMapEnabled(false);
            this.editPopupMenu.setUnmapEnabled(true);
            this.editPopupMenu.showMe(e.getComponent(), e.getX(), e.getY());
        } else if (this.editSelPopupMenu != null && this.editSelPopupMenu.invoked(this.graphPanel, e.getX(), e.getY())) {
            this.isEditSelPopupMenu = true;
            this.editSelPopupMenu.setMapEnabled(false);
            this.editSelPopupMenu.setUnmapEnabled(true);
            this.editSelPopupMenu.showMe(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void setToolkit() {
        Frame f = new Frame("");
        f.pack();
        this.tk = f.getToolkit();
    }

    private void errSound() {
        this.tk.beep();
    }
}

