/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdType;
import agg.gui.AbstractOptionGUI;
import agg.gui.icons.CircleShapeIcon;
import agg.gui.icons.ColorDashLineIcon;
import agg.gui.icons.ColorDotLineIcon;
import agg.gui.icons.ColorSolidLineIcon;
import agg.gui.icons.OvalShapeIcon;
import agg.gui.icons.RectShapeIcon;
import agg.gui.icons.RoundRectShapeIcon;
import agg.layout.LayoutPattern;
import agg.layout.Layouter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphLayouterOptionGUI
extends AbstractOptionGUI
implements ActionListener,
ListSelectionListener {
    private Layouter layouter;
    private JCheckBox enableCB;
    private JCheckBox saveCB;
    private JCheckBox metricsCB;
    private JCheckBox centerCB;
    private JCheckBox usePatternCB;
    private JRadioButtonMenuItem x_leftCB;
    private JRadioButtonMenuItem x_rightCB;
    private JRadioButtonMenuItem x_equalCB;
    private JRadioButtonMenuItem y_aboveCB;
    private JRadioButtonMenuItem y_underCB;
    private JRadioButtonMenuItem y_equalCB;
    private Vector<JRadioButtonMenuItem> edgeXgroup;
    private Vector<JRadioButtonMenuItem> edgeYgroup;
    private JTextField iterLayoutCB;
    private JTextField iterNodeInterCB;
    private JTextField iterEdgeInterCB;
    private JTextField edgeLengthCB;
    private JTextField generalEdgeLengthCB;
    private JTextField temperatureCB;
    private int iterCount;
    private int edgeLength;
    private int generalEdgeLength;
    private int temperature;
    private JComboBox edgeTypeCB;
    private JComboBox nodeTypeCB;
    private JLabel edgeType;
    private JLabel nodeType;
    private JLabel individualEdgeLength;
    private JButton showPattern;
    private JButton displaySwitch1;
    private JButton displaySwitch2;
    private JPanel layoutOptions;
    private JPanel layoutPatternOptions;
    private JTable patternTable;
    private JDialog tableFrame;
    private Vector<EdType> edgeTypes;
    private EdGraGra gragra;

    public GraphLayouterOptionGUI(Layouter graphLayouter) {
        this.layouter = graphLayouter;
        this.layoutOptions = this.createLayoutOptionsPanel();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 18;
        c.gridwidth = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.add((Component)this.layoutOptions, c);
        this.validate();
        this.enableButtons(this.enableCB.isEnabled());
        this.updateLayouter();
    }

    private JPanel createLayoutOptionsPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        TitledBorder border = new TitledBorder(" Evolutionary Layout for Graph Sequences ");
        JPanel p = new JPanel();
        p.setLayout(gridbag);
        p.setBorder(border);
        JPanel p1 = new JPanel(new GridLayout(0, 1));
        this.enableCB = new JCheckBox(" perform during graph transformation", null, true);
        this.enableCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphLayouterOptionGUI.this.layouter.setEnabled(((JCheckBox)e.getSource()).isSelected());
                GraphLayouterOptionGUI.this.enableButtons(((JCheckBox)e.getSource()).isSelected());
            }
        });
        p1.add(this.enableCB);
        JPanel p2 = new JPanel(new GridLayout(0, 1));
        p2.setBorder(new TitledBorder(" Output "));
        JLabel l = new JLabel(" Graph sequence as JPEG ( .jpg ) images");
        p2.add(l);
        this.saveCB = new JCheckBox(" write to directory", null, false);
        this.saveCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphLayouterOptionGUI.this.layouter.setJpgOutput(((JCheckBox)e.getSource()).isSelected());
                if (((JCheckBox)e.getSource()).isSelected()) {
                    GraphLayouterOptionGUI.this.metricsCB.setSelected(true);
                    GraphLayouterOptionGUI.this.layouter.setWriteMetricValues(true);
                }
            }
        });
        p2.add(this.saveCB);
        l = new JLabel(" Quality metrics");
        p2.add(l);
        this.metricsCB = new JCheckBox(" write to ( .log ) file", null, false);
        this.metricsCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphLayouterOptionGUI.this.layouter.setWriteMetricValues(((JCheckBox)e.getSource()).isSelected());
            }
        });
        p2.add(this.metricsCB);
        this.layouter.setDoCenter(false);
        JPanel p4 = new JPanel();
        l = new JLabel("  iteration count of layout process ");
        this.iterCount = 100;
        this.layouter.setIterationCount(this.iterCount);
        this.iterLayoutCB = new JTextField(new Integer(this.iterCount).toString(), 5);
        this.iterLayoutCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!((JTextField)e.getSource()).getText().equals("")) {
                    try {
                        Integer nb = new Integer(((JTextField)e.getSource()).getText());
                        if (nb != null) {
                            GraphLayouterOptionGUI.this.layouter.setIterationCount(nb);
                        }
                    }
                    catch (NumberFormatException ex) {
                        GraphLayouterOptionGUI.this.iterLayoutCB.setText("");
                    }
                }
            }
        });
        p4.add((Component)this.iterLayoutCB, "West");
        p4.add((Component)l, "Center");
        JPanel p5 = new JPanel();
        l = new JLabel("  initial temperature of cooling ");
        this.temperature = 100;
        this.layouter.setBeginTemperature(this.temperature);
        this.temperatureCB = new JTextField(new Integer(this.temperature).toString(), 5);
        this.temperatureCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!((JTextField)e.getSource()).getText().equals("")) {
                    try {
                        Integer nb = new Integer(((JTextField)e.getSource()).getText());
                        if (nb != null) {
                            GraphLayouterOptionGUI.this.layouter.setBeginTemperature(nb);
                        }
                    }
                    catch (NumberFormatException ex) {
                        GraphLayouterOptionGUI.this.temperatureCB.setText("");
                    }
                }
            }
        });
        p5.add((Component)this.temperatureCB, "West");
        p5.add((Component)l, "Center");
        JPanel p6 = new JPanel();
        l = new JLabel("  preferred edge length  ");
        this.generalEdgeLength = 100;
        this.layouter.setGeneralEdgeLength(this.generalEdgeLength);
        this.generalEdgeLengthCB = new JTextField(new Integer(this.generalEdgeLength).toString(), 5);
        this.generalEdgeLengthCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!((JTextField)e.getSource()).getText().equals("")) {
                    try {
                        Integer nb = new Integer(((JTextField)e.getSource()).getText());
                        if (nb != null) {
                            GraphLayouterOptionGUI.this.layouter.setGeneralEdgeLength(nb);
                        }
                    }
                    catch (NumberFormatException ex) {
                        GraphLayouterOptionGUI.this.generalEdgeLengthCB.setText("200");
                    }
                }
            }
        });
        p6.add((Component)this.generalEdgeLengthCB, "West");
        p6.add((Component)l, "Center");
        JPanel p7 = new JPanel(new GridLayout(0, 1));
        this.usePatternCB = new JCheckBox(" use layout pattern", null, true);
        this.usePatternCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphLayouterOptionGUI.this.layouter.setUsePattern(((JCheckBox)e.getSource()).isSelected());
                GraphLayouterOptionGUI.this.enablePattern(GraphLayouterOptionGUI.this.usePatternCB.isEnabled() && GraphLayouterOptionGUI.this.usePatternCB.isSelected());
            }
        });
        p7.add(this.usePatternCB);
        JPanel p8 = this.createLayoutPatternOptionsPanel();
        this.constrainBuild(p, p1, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(p, p2, 0, 1, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(p, p4, 0, 3, 1, 1, 1, 17, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(p, p5, 0, 4, 1, 1, 1, 17, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(p, p6, 0, 5, 1, 1, 1, 17, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(p, p7, 0, 6, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(p, p8, 0, 7, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        p.validate();
        return p;
    }

    private JPanel createLayoutPatternOptionsPanel() {
        if (this.edgeXgroup == null) {
            this.edgeXgroup = new Vector();
        }
        if (this.edgeYgroup == null) {
            this.edgeYgroup = new Vector();
        }
        this.edgeType = new JLabel("UNDEFINED");
        this.nodeType = new JLabel("UNDEFINED");
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        TitledBorder border = new TitledBorder(" Graph Layout Pattern ");
        JPanel p = new JPanel();
        p.setLayout(gridbag);
        p.setBorder(border);
        JPanel p1 = new JPanel(new GridLayout(1, 0));
        JLabel l = new JLabel(" Selected edge type ");
        p1.add(l);
        this.edgeTypeCB = this.createEdgeTypeComboBox();
        p1.add(this.edgeTypeCB);
        JPanel p2 = new JPanel(new GridLayout(0, 1));
        p2.setBorder(new TitledBorder(" Edge Type Layout Pattern "));
        JPanel p2_1 = new JPanel(new GridLayout(1, 0));
        JPanel p2_1_1 = new JPanel(new GridLayout(0, 1));
        l = new JLabel("  X - Axis");
        p2_1_1.add(l);
        this.x_leftCB = new JRadioButtonMenuItem(" Target left of Source", null, false);
        this.x_leftCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                GraphLayouterOptionGUI.this.updateGroup(GraphLayouterOptionGUI.this.edgeXgroup, GraphLayouterOptionGUI.this.x_leftCB);
                if (!GraphLayouterOptionGUI.this.edgeType.getText().equals("")) {
                    int indx = GraphLayouterOptionGUI.this.edgeTypeCB.getSelectedIndex();
                    if (GraphLayouterOptionGUI.this.x_leftCB.isSelected()) {
                        if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.gragra.createLayoutPattern("hor_tree", "edge", ((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), 'x', -1);
                        } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.layouter.createLayoutPattern("hor_tree", "edge", ((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), 'x', -1);
                        }
                        if (GraphLayouterOptionGUI.this.patternTable != null) {
                            GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("TarLeftSrc", indx, 1);
                        }
                    } else {
                        if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.gragra.removeLayoutPattern(((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), "hor_tree");
                        } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.layouter.removeLayoutPattern(((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), "hor_tree");
                        }
                        if (GraphLayouterOptionGUI.this.patternTable != null && GraphLayouterOptionGUI.this.patternTable.getRowCount() > indx) {
                            GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("", indx, 1);
                        }
                    }
                }
            }
        });
        this.edgeXgroup.add(this.x_leftCB);
        p2_1_1.add(this.x_leftCB);
        this.x_rightCB = new JRadioButtonMenuItem(" Target right of Source", null, false);
        this.x_rightCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                GraphLayouterOptionGUI.this.updateGroup(GraphLayouterOptionGUI.this.edgeXgroup, GraphLayouterOptionGUI.this.x_rightCB);
                if (!GraphLayouterOptionGUI.this.edgeType.getText().equals("")) {
                    int indx = GraphLayouterOptionGUI.this.edgeTypeCB.getSelectedIndex();
                    if (GraphLayouterOptionGUI.this.x_rightCB.isSelected()) {
                        if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.gragra.createLayoutPattern("hor_tree", "edge", ((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), 'x', 1);
                        } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.layouter.createLayoutPattern("hor_tree", "edge", ((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), 'x', 1);
                        }
                        if (GraphLayouterOptionGUI.this.patternTable != null) {
                            GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("TarRightSrc", indx, 1);
                        }
                    } else {
                        if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.gragra.removeLayoutPattern(((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), "hor_tree");
                        } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.layouter.removeLayoutPattern(((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), "hor_tree");
                        }
                        if (GraphLayouterOptionGUI.this.patternTable != null && GraphLayouterOptionGUI.this.patternTable.getRowCount() > indx) {
                            GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("", indx, 1);
                        }
                    }
                }
            }
        });
        this.edgeXgroup.add(this.x_rightCB);
        p2_1_1.add(this.x_rightCB);
        this.x_equalCB = new JRadioButtonMenuItem(" Target equal to Source", null, false);
        this.x_equalCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                GraphLayouterOptionGUI.this.updateGroup(GraphLayouterOptionGUI.this.edgeXgroup, GraphLayouterOptionGUI.this.x_equalCB);
                if (!GraphLayouterOptionGUI.this.edgeType.getText().equals("")) {
                    int indx = GraphLayouterOptionGUI.this.edgeTypeCB.getSelectedIndex();
                    if (GraphLayouterOptionGUI.this.x_equalCB.isSelected()) {
                        if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.gragra.createLayoutPattern("hor_tree", "edge", ((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), 'x', 0);
                        } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.layouter.createLayoutPattern("hor_tree", "edge", ((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), 'x', 0);
                        }
                        if (GraphLayouterOptionGUI.this.patternTable != null) {
                            GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("TarEqualSrc", indx, 1);
                        }
                    } else {
                        if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.gragra.removeLayoutPattern(((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), "hor_tree");
                        } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.layouter.removeLayoutPattern(((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), "hor_tree");
                        }
                        if (GraphLayouterOptionGUI.this.patternTable != null && GraphLayouterOptionGUI.this.patternTable.getRowCount() > indx) {
                            GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("", indx, 1);
                        }
                    }
                }
            }
        });
        this.edgeXgroup.add(this.x_equalCB);
        p2_1_1.add(this.x_equalCB);
        JPanel p2_1_2 = new JPanel(new GridLayout(0, 1));
        l = new JLabel("  Y - Axis");
        p2_1_2.add(l);
        this.y_aboveCB = new JRadioButtonMenuItem(" Target above Source", null, false);
        this.y_aboveCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                GraphLayouterOptionGUI.this.updateGroup(GraphLayouterOptionGUI.this.edgeYgroup, GraphLayouterOptionGUI.this.y_aboveCB);
                if (!GraphLayouterOptionGUI.this.edgeType.getText().equals("")) {
                    int indx = GraphLayouterOptionGUI.this.edgeTypeCB.getSelectedIndex();
                    if (GraphLayouterOptionGUI.this.y_aboveCB.isSelected()) {
                        if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.gragra.createLayoutPattern("ver_tree", "edge", ((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), 'y', -1);
                        } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.layouter.createLayoutPattern("ver_tree", "edge", ((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), 'y', -1);
                        }
                        if (GraphLayouterOptionGUI.this.patternTable != null) {
                            GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("TarAboveSrc", indx, 2);
                        }
                    } else {
                        if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.gragra.removeLayoutPattern(((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), "ver_tree");
                        } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.layouter.removeLayoutPattern(((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), "ver_tree");
                        }
                        if (GraphLayouterOptionGUI.this.patternTable != null && GraphLayouterOptionGUI.this.patternTable.getRowCount() > indx) {
                            GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("", indx, 2);
                        }
                    }
                }
            }
        });
        this.edgeYgroup.add(this.y_aboveCB);
        p2_1_2.add(this.y_aboveCB);
        this.y_underCB = new JRadioButtonMenuItem(" Target under Source", null, false);
        this.y_underCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                GraphLayouterOptionGUI.this.updateGroup(GraphLayouterOptionGUI.this.edgeYgroup, GraphLayouterOptionGUI.this.y_underCB);
                if (!GraphLayouterOptionGUI.this.edgeType.getText().equals("")) {
                    int indx = GraphLayouterOptionGUI.this.edgeTypeCB.getSelectedIndex();
                    if (GraphLayouterOptionGUI.this.y_underCB.isSelected()) {
                        if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.gragra.createLayoutPattern("ver_tree", "edge", ((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), 'y', 1);
                        } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.layouter.createLayoutPattern("ver_tree", "edge", ((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), 'y', 1);
                        }
                        if (GraphLayouterOptionGUI.this.patternTable != null) {
                            GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("TarUnderSrc", indx, 2);
                        }
                    } else {
                        if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.gragra.removeLayoutPattern(((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), "ver_tree");
                        } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.layouter.removeLayoutPattern(((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), "ver_tree");
                        }
                        if (GraphLayouterOptionGUI.this.patternTable != null && GraphLayouterOptionGUI.this.patternTable.getRowCount() > indx) {
                            GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("", indx, 2);
                        }
                    }
                }
            }
        });
        this.edgeYgroup.add(this.y_underCB);
        p2_1_2.add(this.y_underCB);
        this.y_equalCB = new JRadioButtonMenuItem(" Target equal to Source", null, false);
        this.y_equalCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                GraphLayouterOptionGUI.this.updateGroup(GraphLayouterOptionGUI.this.edgeYgroup, GraphLayouterOptionGUI.this.y_equalCB);
                if (!GraphLayouterOptionGUI.this.edgeType.getText().equals("")) {
                    int indx = GraphLayouterOptionGUI.this.edgeTypeCB.getSelectedIndex();
                    if (GraphLayouterOptionGUI.this.y_equalCB.isSelected()) {
                        if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.gragra.createLayoutPattern("ver_tree", "edge", ((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), 'y', 0);
                        } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.layouter.createLayoutPattern("ver_tree", "edge", ((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), 'y', 0);
                        }
                        if (GraphLayouterOptionGUI.this.patternTable != null) {
                            GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("TarEqualSrc", indx, 2);
                        }
                    } else {
                        if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.gragra.removeLayoutPattern(((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), "ver_tree");
                        } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                            GraphLayouterOptionGUI.this.layouter.removeLayoutPattern(((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), "ver_tree");
                        }
                        if (GraphLayouterOptionGUI.this.patternTable != null && GraphLayouterOptionGUI.this.patternTable.getRowCount() > indx) {
                            GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("", indx, 2);
                        }
                    }
                }
            }
        });
        this.edgeYgroup.add(this.y_equalCB);
        p2_1_2.add(this.y_equalCB);
        p2_1.add(p2_1_1);
        p2_1.add(p2_1_2);
        JPanel p2_2 = new JPanel();
        l = new JLabel(" preferred length ");
        this.edgeLength = 0;
        this.edgeLengthCB = new JTextField(String.valueOf(this.edgeLength), 5);
        this.edgeLengthCB.setColumns(5);
        this.edgeLengthCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                block21: {
                    int indx = GraphLayouterOptionGUI.this.edgeTypeCB.getSelectedIndex();
                    if (!((JTextField)e.getSource()).getText().equals("")) {
                        try {
                            Integer nb = new Integer(((JTextField)e.getSource()).getText());
                            if (nb == null) break block21;
                            if (nb > 0) {
                                if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                                    GraphLayouterOptionGUI.this.gragra.createLayoutPattern("edge_length", "edge", ((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), nb);
                                } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                                    GraphLayouterOptionGUI.this.layouter.createLayoutPattern("edge_length", "edge", ((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), nb);
                                }
                                if (GraphLayouterOptionGUI.this.patternTable != null) {
                                    GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt(nb.toString(), indx, 3);
                                }
                            } else {
                                GraphLayouterOptionGUI.this.edgeLengthCB.setText("0");
                                if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                                    GraphLayouterOptionGUI.this.gragra.removeLayoutPattern(((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), "edge_length");
                                } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                                    GraphLayouterOptionGUI.this.layouter.removeLayoutPattern(((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), "edge_length");
                                }
                                if (GraphLayouterOptionGUI.this.patternTable != null && GraphLayouterOptionGUI.this.patternTable.getRowCount() > indx) {
                                    GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("0", indx, 3);
                                }
                            }
                            break block21;
                        }
                        catch (NumberFormatException ex) {
                            GraphLayouterOptionGUI.this.edgeLengthCB.setText("0");
                            if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                                GraphLayouterOptionGUI.this.gragra.removeLayoutPattern(((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), "edge_length");
                            } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                                GraphLayouterOptionGUI.this.layouter.removeLayoutPattern(((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), "edge_length");
                            }
                            if (GraphLayouterOptionGUI.this.patternTable != null && GraphLayouterOptionGUI.this.patternTable.getRowCount() > indx) {
                                GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("0", indx, 3);
                            }
                            break block21;
                        }
                    }
                    GraphLayouterOptionGUI.this.edgeLengthCB.setText("0");
                    if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.gragra.removeLayoutPattern(((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), "edge_length");
                    } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.layouter.removeLayoutPattern(((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx)).getBasisType(), "edge_length");
                    }
                    if (GraphLayouterOptionGUI.this.patternTable != null && GraphLayouterOptionGUI.this.patternTable.getRowCount() > indx) {
                        GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("0", indx, 3);
                    }
                }
            }
        });
        p2_2.add((Component)this.edgeLengthCB, "West");
        p2_2.add((Component)l, "Center");
        JPanel p2_3 = new JPanel();
        l = new JLabel(" Table of Graph Layout Patterns ");
        this.showPattern = new JButton("Show");
        this.showPattern.setEnabled(false);
        this.showPattern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GraphLayouterOptionGUI.this.tableFrame != null) {
                    if (!GraphLayouterOptionGUI.this.tableFrame.isVisible()) {
                        GraphLayouterOptionGUI.this.tableFrame.setVisible(true);
                    } else {
                        GraphLayouterOptionGUI.this.tableFrame.toFront();
                    }
                }
            }
        });
        p2_3.add((Component)l, "Center");
        p2_3.add((Component)this.showPattern, "West");
        p2_2.add((Component)p2_3, "South");
        p2.add(p2_1);
        p2.add(p2_2);
        this.constrainBuild(p, p1, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(p, p2, 0, 1, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        p.validate();
        return p;
    }

    private void updateGroup(Vector<JRadioButtonMenuItem> grp, JRadioButtonMenuItem b) {
        if (b.isSelected()) {
            for (int i = 0; i < grp.size(); ++i) {
                JRadioButtonMenuItem bi = grp.get(i);
                if (bi == b) continue;
                bi.setSelected(false);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 680);
    }

    @Override
    public String getTabTitle() {
        return "Layouter";
    }

    @Override
    public String getTabTip() {
        return "Graph Layouter Options";
    }

    public void setGraGra(EdGraGra gra) {
        this.gragra = gra;
        this.updateEdgeTypeComboBox(null);
        if (this.gragra != null) {
            this.layouter.setLayoutPatterns(this.gragra.getLayoutPatterns());
            if (this.tableFrame != null) {
                this.tableFrame.setVisible(false);
            }
            this.updateEdgeTypeComboBox(this.gragra.getTypeSet().getArcTypes());
        }
    }

    @Override
    public void update() {
        this.updateLayouter();
    }

    public void addActionListener(ActionListener l) {
    }

    public void updateLayouter() {
        this.layouter.setEnabled(this.enableCB.isSelected());
        this.layouter.setJpgOutput(this.saveCB.isSelected());
        this.layouter.setWriteMetricValues(this.metricsCB.isSelected());
        this.layouter.setIterationCount(this.iterCount);
        this.layouter.setUsePattern(this.usePatternCB.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private void enableButtons(boolean b) {
        this.saveCB.setEnabled(b);
        this.metricsCB.setEnabled(b);
        this.iterLayoutCB.setEnabled(b);
        this.temperatureCB.setEnabled(b);
        this.generalEdgeLengthCB.setEnabled(b);
        this.usePatternCB.setEnabled(b);
        this.enablePattern(this.usePatternCB.isEnabled() && this.usePatternCB.isSelected());
    }

    private void enablePattern(boolean b) {
        this.edgeTypeCB.setEnabled(b);
        this.x_leftCB.setEnabled(b);
        this.x_rightCB.setEnabled(b);
        this.x_equalCB.setEnabled(b);
        this.y_aboveCB.setEnabled(b);
        this.y_underCB.setEnabled(b);
        this.y_equalCB.setEnabled(b);
        this.edgeLengthCB.setEnabled(b);
    }

    public void updateEdgeTypeComboBox(EdType t, int index, int msg) {
        if (msg == 13) {
            JLabel mi = new JLabel(t.getName());
            mi.setIcon(this.getArcTypeIcon(t));
            Vector<String> tablerow = new Vector<String>(4);
            tablerow.add(mi.getText());
            tablerow.add("");
            tablerow.add("");
            tablerow.add("0");
            if (index >= this.edgeTypeCB.getItemCount()) {
                ((DefaultComboBoxModel)this.edgeTypeCB.getModel()).addElement(mi);
            } else {
                ((DefaultComboBoxModel)this.edgeTypeCB.getModel()).insertElementAt(mi, index);
            }
            ((DefaultTableModel)this.patternTable.getModel()).insertRow(index, tablerow);
        } else if (msg == 14) {
            ((DefaultComboBoxModel)this.edgeTypeCB.getModel()).removeElementAt(index);
            this.layouter.removeLayoutPattern(t.getBasisType());
            ((DefaultTableModel)this.patternTable.getModel()).removeRow(index);
        } else if (msg == 12) {
            JLabel l = (JLabel)this.edgeTypeCB.getSelectedItem();
            JLabel mi = (JLabel)this.edgeTypeCB.getItemAt(index);
            if (!mi.getText().equals(t)) {
                this.layouter.removeLayoutPattern(t.getBasisType());
                mi.setText(t.getName());
                if (index == this.edgeTypeCB.getSelectedIndex()) {
                    if (index < this.edgeTypeCB.getItemCount() - 1) {
                        this.edgeTypeCB.setSelectedIndex(this.edgeTypeCB.getItemCount() - 1);
                    } else {
                        this.edgeTypeCB.setSelectedIndex(0);
                    }
                }
                this.edgeTypeCB.setSelectedItem(mi);
                this.patternTable.setValueAt(mi.getText(), index, 0);
                this.patternTable.setValueAt("", index, 1);
                this.patternTable.setValueAt("", index, 2);
                this.patternTable.setValueAt("0", index, 3);
                this.updateLayoutPatternOfType(t);
            }
        }
    }

    private JComboBox createEdgeTypeComboBox() {
        if (this.edgeTypeCB == null) {
            this.edgeTypeCB = new JComboBox();
            this.edgeTypeCB.setRenderer(new MyCellRenderer());
            this.edgeTypeCB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (((JComboBox)e.getSource()).getSelectedItem() instanceof JLabel) {
                        int indx = ((JComboBox)e.getSource()).getSelectedIndex();
                        JLabel l = (JLabel)((JComboBox)e.getSource()).getSelectedItem();
                        if (l != null && l instanceof JLabel) {
                            GraphLayouterOptionGUI.this.edgeType.setText(l.getText());
                            GraphLayouterOptionGUI.this.edgeType.setIcon(l.getIcon());
                            GraphLayouterOptionGUI.this.updateLayoutPatternOfType((EdType)GraphLayouterOptionGUI.this.edgeTypes.get(indx));
                        }
                    }
                }
            });
            this.edgeTypeCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        // empty if block
                    }
                }
            });
        }
        return this.edgeTypeCB;
    }

    public JComboBox updateEdgeTypeComboBox(Vector arcTypes) {
        int i;
        this.edgeTypes = arcTypes;
        if (this.edgeTypes == null) {
            if (this.patternTable != null) {
                if (this.gragra == null) {
                    this.layouter.clearLayoutPatterns();
                }
                for (i = 0; i < this.patternTable.getRowCount(); ++i) {
                    ((DefaultTableModel)this.patternTable.getModel()).removeRow(i);
                }
                this.patternTable = null;
            }
            if (this.edgeTypeCB != null) {
                this.edgeTypeCB.removeAllItems();
            }
            if (this.x_leftCB != null) {
                this.x_leftCB.setSelected(false);
            }
            if (this.x_rightCB != null) {
                this.x_rightCB.setSelected(false);
            }
            if (this.x_equalCB != null) {
                this.x_equalCB.setSelected(false);
            }
            if (this.y_aboveCB != null) {
                this.y_aboveCB.setSelected(false);
            }
            if (this.y_underCB != null) {
                this.y_underCB.setSelected(false);
            }
            if (this.y_equalCB != null) {
                this.y_equalCB.setSelected(false);
            }
            if (this.edgeLengthCB != null) {
                this.edgeLengthCB.setText("0");
            }
        }
        if (this.edgeTypeCB != null) {
            this.edgeTypeCB.removeAllItems();
            if (this.gragra == null) {
                this.layouter.clearLayoutPatterns();
            }
        }
        if (this.edgeTypes != null) {
            for (i = 0; i < this.edgeTypes.size(); ++i) {
                EdType t = this.edgeTypes.get(i);
                JLabel mi = new JLabel(t.getName());
                mi.setIcon(this.getArcTypeIcon(t));
                this.edgeTypeCB.addItem(mi);
            }
            this.patternTable = this.createEdgePatternTable();
            this.showPattern.setEnabled(true);
            int indx = this.edgeTypeCB.getSelectedIndex();
            try {
                this.updateLayoutPatternOfType(this.edgeTypes.get(indx));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        } else {
            this.showPattern.setEnabled(false);
        }
        return this.edgeTypeCB;
    }

    private JTable createEdgePatternTable() {
        DefaultTableModel dataModel = new DefaultTableModel(new String[]{"Type", "X-Axis", "Y-Axis", "Length"}, 4){

            public int getColumnCount() {
                return 4;
            }

            public int getRowCount() {
                if (GraphLayouterOptionGUI.this.edgeTypes == null) {
                    return 0;
                }
                return GraphLayouterOptionGUI.this.edgeTypes.size();
            }

            public Object getValueAt(int row, int col) {
                if (row < super.getRowCount() && col < super.getColumnCount()) {
                    return super.getValueAt(row, col);
                }
                return null;
            }
        };
        JTable table = new JTable(dataModel);
        table.getSelectionModel().setSelectionMode(0);
        for (int r = 0; r < this.edgeTypes.size(); ++r) {
            EdType type = this.edgeTypes.get(r);
            String typename = this.edgeTypes.get(r).getName();
            table.getModel().setValueAt(typename, r, 0);
            table.getModel().setValueAt("", r, 1);
            table.getModel().setValueAt("", r, 2);
            table.getModel().setValueAt("0", r, 3);
            if (this.gragra == null) continue;
            Vector<LayoutPattern> v = this.gragra.getLayoutPatternsForType(type.getBasisType());
            for (int j = 0; j < v.size(); ++j) {
                LayoutPattern lp = v.get(j);
                if (lp.isEdgePattern() && lp.isXOffset()) {
                    if (lp.getOffset() == 1) {
                        table.getModel().setValueAt("TarRightSrc", r, 1);
                        continue;
                    }
                    if (lp.getOffset() == -1) {
                        table.getModel().setValueAt("TarLeftSrc", r, 1);
                        continue;
                    }
                    if (lp.getOffset() != 0) continue;
                    table.getModel().setValueAt("TarEqualSrc", r, 1);
                    continue;
                }
                if (lp.isEdgePattern() && lp.isYOffset()) {
                    if (lp.getOffset() == 1) {
                        table.getModel().setValueAt("TarUnderSrc", r, 2);
                        continue;
                    }
                    if (lp.getOffset() == -1) {
                        table.getModel().setValueAt("TarAboveSrc", r, 2);
                        continue;
                    }
                    if (lp.getOffset() != 0) continue;
                    table.getModel().setValueAt("TarEqualSrc", r, 2);
                    continue;
                }
                if (!lp.isEdgePattern() || !lp.isLengthPattern()) continue;
                table.getModel().setValueAt(String.valueOf(lp.getLength()), r, 3);
            }
        }
        JScrollPane scrollpane = new JScrollPane(table);
        this.tableFrame = new JDialog();
        this.tableFrame.setTitle(" Edge Type Pattern ");
        this.tableFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GraphLayouterOptionGUI.this.setVisible(false);
            }
        });
        this.tableFrame.setModal(false);
        this.tableFrame.getContentPane().add(scrollpane);
        this.tableFrame.setLocation(this.getLocation().x + 400, this.getLocation().y + 400);
        this.tableFrame.setSize(new Dimension(400, table.getCellRect((int)0, (int)0, (boolean)true).height * (table.getRowCount() + 4)));
        this.tableFrame.validate();
        return table;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int indx = e.getFirstIndex();
        if (indx < this.edgeTypeCB.getItemCount()) {
            this.edgeTypeCB.setSelectedIndex(indx);
        }
    }

    private JComboBox updateNodeTypeComboBox(Vector nodeTypes) {
        if (this.nodeTypeCB == null) {
            this.nodeTypeCB = new JComboBox();
            this.nodeTypeCB.setRenderer(new MyCellRenderer());
            this.nodeTypeCB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JLabel l;
                    if (((JComboBox)e.getSource()).getSelectedItem() instanceof JLabel && (l = (JLabel)((JComboBox)e.getSource()).getSelectedItem()) != null && l instanceof JLabel) {
                        GraphLayouterOptionGUI.this.nodeType.setText(l.getText());
                        GraphLayouterOptionGUI.this.nodeType.setIcon(l.getIcon());
                    }
                }
            });
            this.nodeTypeCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        // empty if block
                    }
                }
            });
        } else {
            this.nodeTypeCB.removeAllItems();
        }
        if (nodeTypes != null) {
            for (int i = 0; i < nodeTypes.size(); ++i) {
                EdType t = (EdType)nodeTypes.get(i);
                JLabel mi = new JLabel(t.getName());
                mi.setIcon(this.getNodeTypeIcon(t));
                this.nodeTypeCB.addItem(mi);
            }
        }
        return this.nodeTypeCB;
    }

    private Icon getArcTypeIcon(EdType et) {
        Icon icon = null;
        switch (et.shape) {
            case 61: {
                icon = new ColorSolidLineIcon(et.color);
                break;
            }
            case 62: {
                icon = new ColorDashLineIcon(et.color);
                break;
            }
            case 63: {
                icon = new ColorDotLineIcon(et.color);
                break;
            }
        }
        return icon;
    }

    public Icon getNodeTypeIcon(EdType et) {
        Icon icon = null;
        switch (et.shape) {
            case 51: {
                icon = new RectShapeIcon(et.color);
                break;
            }
            case 54: {
                icon = new RoundRectShapeIcon(et.color);
                break;
            }
            case 52: {
                icon = new CircleShapeIcon(et.color);
                break;
            }
            case 53: {
                icon = new OvalShapeIcon(et.color);
                break;
            }
        }
        return icon;
    }

    private void updateLayoutPatternOfType(EdType type) {
        int indx = this.edgeTypeCB.getSelectedIndex();
        if (this.patternTable == null || indx == -1) {
            return;
        }
        if (this.patternTable.getModel().getValueAt(indx, 1) == null) {
            return;
        }
        if (type.getTypeName().equals((String)this.patternTable.getModel().getValueAt(indx, 0))) {
            if (((String)this.patternTable.getModel().getValueAt(indx, 1)).equals("TarLeftSrc")) {
                this.x_leftCB.setSelected(true);
                this.x_rightCB.setSelected(false);
                this.x_equalCB.setSelected(false);
            } else if (((String)this.patternTable.getModel().getValueAt(indx, 1)).equals("TarRightSrc")) {
                this.x_leftCB.setSelected(false);
                this.x_rightCB.setSelected(true);
                this.x_equalCB.setSelected(false);
            } else if (((String)this.patternTable.getModel().getValueAt(indx, 1)).equals("TarEqualSrc")) {
                this.x_leftCB.setSelected(false);
                this.x_rightCB.setSelected(false);
                this.x_equalCB.setSelected(true);
            } else {
                this.x_leftCB.setSelected(false);
                this.x_rightCB.setSelected(false);
                this.x_equalCB.setSelected(false);
            }
            if (((String)this.patternTable.getModel().getValueAt(indx, 2)).equals("TarAboveSrc")) {
                this.y_aboveCB.setSelected(true);
                this.y_underCB.setSelected(false);
                this.y_equalCB.setSelected(false);
            } else if (((String)this.patternTable.getModel().getValueAt(indx, 2)).equals("TarUnderSrc")) {
                this.y_aboveCB.setSelected(false);
                this.y_underCB.setSelected(true);
                this.y_equalCB.setSelected(false);
            } else if (((String)this.patternTable.getModel().getValueAt(indx, 2)).equals("TarEqualSrc")) {
                this.y_aboveCB.setSelected(false);
                this.y_underCB.setSelected(false);
                this.y_equalCB.setSelected(true);
            } else {
                this.y_aboveCB.setSelected(false);
                this.y_underCB.setSelected(false);
                this.y_equalCB.setSelected(false);
            }
            if (!((String)this.patternTable.getModel().getValueAt(indx, 3)).equals("")) {
                this.edgeLengthCB.setText((String)this.patternTable.getModel().getValueAt(indx, 3));
            } else {
                this.edgeLengthCB.setText("0");
            }
        }
    }

    private void createLayoutPattern(EdType type) {
        if (this.x_leftCB.isSelected()) {
            this.layouter.createLayoutPattern("hor_tree", "edge", type.getBasisType(), 'x', -1);
        } else if (this.x_rightCB.isSelected()) {
            this.layouter.createLayoutPattern("hor_tree", "edge", type.getBasisType(), 'x', 1);
        } else if (this.x_equalCB.isSelected()) {
            this.layouter.createLayoutPattern("x_tree", "edge", type.getBasisType(), 'x', 0);
        }
        if (this.y_aboveCB.isSelected()) {
            this.layouter.createLayoutPattern("ver_tree", "edge", type.getBasisType(), 'y', -1);
        } else if (this.y_underCB.isSelected()) {
            this.layouter.createLayoutPattern("ver_tree", "edge", type.getBasisType(), 'y', 1);
        } else if (this.y_equalCB.isSelected()) {
            this.layouter.createLayoutPattern("y_tree", "edge", type.getBasisType(), 'y', 0);
        }
        try {
            Integer nb = new Integer(this.edgeLengthCB.getText());
            if (nb != null && nb > 0) {
                this.layouter.createLayoutPattern("edge_length", "edge", type.getBasisType(), nb);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList listbox, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof JLabel) {
                JLabel l = (JLabel)value;
                this.setForeground(Color.black);
                if (isSelected) {
                    this.setBackground(Color.lightGray);
                } else {
                    this.setBackground(Color.white);
                }
                this.setIcon(l.getIcon());
                this.setText(l.getText());
                this.setToolTipText(l.getText());
                this.setOpaque(true);
                return l;
            }
            return new JLabel("");
        }
    }
}

