/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import java.awt.Container;
import java.awt.Cursor;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class HtmlPane
extends JScrollPane
implements HyperlinkListener {
    private JEditorPane html;
    private boolean isEmpty = false;

    public HtmlPane(URL u) {
        try {
            this.html = new JEditorPane(u);
            this.html.setEditable(false);
            this.html.addHyperlinkListener(this);
            JViewport vp = this.getViewport();
            vp.add(this.html);
        }
        catch (IOException e) {
            this.isEmpty = true;
            JOptionPane.showMessageDialog(null, "IOException: \n" + e);
        }
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void setPage(String url) throws IOException {
        this.html.setPage(url);
    }

    public String toString() {
        return new Integer(this.hashCode()).toString();
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(e.getURL());
        }
    }

    protected void linkActivated(URL u) {
        Cursor c = this.html.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.html.setCursor(waitCursor);
        SwingUtilities.invokeLater(new PageLoader(u, c));
    }

    class PageLoader
    implements Runnable {
        private URL url;
        private Cursor cursor;

        PageLoader(URL u, Cursor c) {
            this.url = u;
            this.cursor = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.url == null) {
                HtmlPane.this.html.setCursor(this.cursor);
                Container parent = HtmlPane.this.html.getParent();
                parent.repaint();
            } else {
                Document doc = HtmlPane.this.html.getDocument();
                try {
                    HtmlPane.this.html.setPage(this.url);
                }
                catch (IOException ioe) {
                    HtmlPane.this.html.setDocument(doc);
                    HtmlPane.this.getToolkit().beep();
                }
                finally {
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }
}

