/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import java.util.Observer;
import java.util.Vector;

public class LoadSaveStatus {
    private static int MAXIMUM = 100;
    private static int MINIMUM;
    private static int PERCENTAGE;
    private static Vector OBSERVER;
    private static int SMALLSTEP;
    private static int BIGSTEP;
    private static int DIRECTION;

    private LoadSaveStatus() {
    }

    public static void addObserver(Observer o) {
        OBSERVER.addElement(o);
    }

    public static void deleteObserver(Observer o) {
        OBSERVER.removeElement(o);
    }

    public static void notifyObservers() {
        for (int i = 0; i < LoadSaveStatus.countObservers(); ++i) {
            Observer o = (Observer)OBSERVER.elementAt(i);
            o.update(null, null);
        }
    }

    public static void deleteObservers() {
        OBSERVER.removeAllElements();
    }

    public static int countObservers() {
        return OBSERVER.size();
    }

    public static void setMaximum(int max) {
        if (max >= LoadSaveStatus.getMinimum()) {
            MAXIMUM = max;
        }
        if (LoadSaveStatus.getValue() > LoadSaveStatus.getMaximum()) {
            LoadSaveStatus.setValue(LoadSaveStatus.getMaximum());
        }
    }

    public static int getMaximum() {
        return MAXIMUM;
    }

    public static void setMinimum(int min) {
        if (min <= LoadSaveStatus.getMaximum()) {
            MINIMUM = min;
        }
        if (LoadSaveStatus.getValue() < LoadSaveStatus.getMinimum()) {
            LoadSaveStatus.setValue(LoadSaveStatus.getMinimum());
        }
    }

    public static int getMinimum() {
        return MINIMUM;
    }

    public static void setValue(int percent) {
        if (percent <= LoadSaveStatus.getMaximum() && percent >= LoadSaveStatus.getMinimum()) {
            PERCENTAGE = percent;
            LoadSaveStatus.notifyObservers();
        }
    }

    public static int getValue() {
        return PERCENTAGE;
    }

    private static void calcValue(int stepSize) {
        switch (DIRECTION) {
            case 1: {
                if (LoadSaveStatus.getValue() + stepSize <= LoadSaveStatus.getMaximum()) break;
                DIRECTION = -1;
                break;
            }
            case -1: {
                if (LoadSaveStatus.getValue() - stepSize >= LoadSaveStatus.getMinimum()) break;
                DIRECTION = 1;
                break;
            }
        }
        LoadSaveStatus.setValue(LoadSaveStatus.getValue() + stepSize * DIRECTION);
    }

    public static void smallStep() {
        LoadSaveStatus.calcValue(LoadSaveStatus.getSmallSize());
    }

    public static void bigStep() {
        LoadSaveStatus.calcValue(LoadSaveStatus.getBigSize());
    }

    public static void setSmallSize(int small) {
        if (small > 0 && small <= LoadSaveStatus.getBigSize()) {
            SMALLSTEP = small;
        }
    }

    public static void setBigSize(int big) {
        if (big >= LoadSaveStatus.getSmallSize() && big <= LoadSaveStatus.getMaximum()) {
            BIGSTEP = big;
        }
    }

    public static int getSmallSize() {
        return SMALLSTEP;
    }

    public static int getBigSize() {
        return BIGSTEP;
    }

    public static void reset() {
        LoadSaveStatus.setValue(LoadSaveStatus.getMinimum());
    }

    static {
        PERCENTAGE = MINIMUM = 0;
        OBSERVER = new Vector();
        SMALLSTEP = 1;
        BIGSTEP = 2;
        DIRECTION = 1;
    }
}

