/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.editor.impl.GraphPanel;
import agg.gui.GraGraEditor;
import agg.gui.GraphEditor;
import agg.gui.GraphicsExportJPEG;
import agg.gui.RuleEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ModePopupMenu
extends JPopupMenu {
    private JCheckBoxMenuItem miDraw;
    private JCheckBoxMenuItem miSelect;
    private JCheckBoxMenuItem miMove;
    private JCheckBoxMenuItem miAttrs;
    private JCheckBoxMenuItem miImage;
    private JCheckBoxMenuItem miMap;
    private JCheckBoxMenuItem miUnmap;
    private JCheckBoxMenuItem miSynchronMove;
    private JMenu mainModeMenu;
    private GraGraEditor editor;
    private RuleEditor ruleEditor;
    private GraphEditor graphEditor;
    private GraphPanel gp;
    private GraphicsExportJPEG exportJPEG;

    public ModePopupMenu() {
        super("Mode");
        JMenuItem miLabel = this.add(new JMenuItem("Edit Mode"));
        miLabel.setEnabled(false);
        this.addSeparator();
        this.miDraw = (JCheckBoxMenuItem)this.add(new JCheckBoxMenuItem("Draw                                        Shift+D"));
        this.miDraw.setSelected(true);
        this.miDraw.setActionCommand("drawMode");
        this.miDraw.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JMenuItem) {
                    ((JCheckBoxMenuItem)e.getSource()).setSelected(true);
                    ModePopupMenu.this.selectEditModeMenuItem("Draw");
                    ModePopupMenu.this.selectMainEditModeMenuItem("Draw");
                    if (ModePopupMenu.this.editor != null) {
                        ModePopupMenu.this.editor.setEditMode(11);
                        ModePopupMenu.this.editor.selectToolBarModeItem("Draw");
                    } else if (ModePopupMenu.this.ruleEditor != null) {
                        ModePopupMenu.this.ruleEditor.setEditMode(11);
                    } else if (ModePopupMenu.this.graphEditor != null) {
                        ModePopupMenu.this.graphEditor.setEditMode(11);
                    }
                }
            }
        });
        this.miSelect = (JCheckBoxMenuItem)this.add(new JCheckBoxMenuItem("Select                                        Shift+S"));
        this.miSelect.setActionCommand("selectMode");
        this.miSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JMenuItem) {
                    ((JCheckBoxMenuItem)e.getSource()).setSelected(true);
                    ModePopupMenu.this.selectEditModeMenuItem("Select");
                    ModePopupMenu.this.selectMainEditModeMenuItem("Select");
                    if (ModePopupMenu.this.editor != null) {
                        ModePopupMenu.this.editor.setEditMode(12);
                        ModePopupMenu.this.editor.selectToolBarModeItem("Select");
                    } else if (ModePopupMenu.this.ruleEditor != null) {
                        ModePopupMenu.this.ruleEditor.setEditMode(12);
                    } else if (ModePopupMenu.this.graphEditor != null) {
                        ModePopupMenu.this.graphEditor.setEditMode(12);
                    }
                }
            }
        });
        this.miMove = (JCheckBoxMenuItem)this.add(new JCheckBoxMenuItem("Move                                        Shift+M"));
        this.miMove.setActionCommand("moveMode");
        this.miMove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JMenuItem) {
                    ((JCheckBoxMenuItem)e.getSource()).setSelected(true);
                    ModePopupMenu.this.selectEditModeMenuItem("Move");
                    ModePopupMenu.this.selectMainEditModeMenuItem("Move");
                    if (ModePopupMenu.this.editor != null) {
                        ModePopupMenu.this.editor.setEditMode(13);
                        ModePopupMenu.this.editor.selectToolBarModeItem("Move");
                    } else if (ModePopupMenu.this.ruleEditor != null) {
                        ModePopupMenu.this.ruleEditor.setEditMode(13);
                    } else if (ModePopupMenu.this.graphEditor != null) {
                        ModePopupMenu.this.graphEditor.setEditMode(13);
                    }
                }
            }
        });
        this.miSynchronMove = (JCheckBoxMenuItem)this.add(new JCheckBoxMenuItem("Synchron Move Mapped Objects"));
        this.miSynchronMove.setActionCommand("synchronMoveMode");
        this.miSynchronMove.setSelected(true);
        this.miSynchronMove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JMenuItem && ModePopupMenu.this.ruleEditor != null) {
                    ModePopupMenu.this.ruleEditor.setSynchronMoveOfMapObjects(((JCheckBoxMenuItem)e.getSource()).isSelected());
                }
            }
        });
        this.miAttrs = (JCheckBoxMenuItem)this.add(new JCheckBoxMenuItem("Attributes                                 Shift+A"));
        this.miAttrs.setActionCommand("atributesMode");
        this.miAttrs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JMenuItem) {
                    ((JCheckBoxMenuItem)e.getSource()).setSelected(true);
                    ModePopupMenu.this.selectEditModeMenuItem("Attributes");
                    ModePopupMenu.this.selectMainEditModeMenuItem("Attributes");
                    if (ModePopupMenu.this.editor != null) {
                        ModePopupMenu.this.editor.setEditMode(114);
                        ModePopupMenu.this.editor.selectToolBarModeItem("Attributes");
                    } else if (ModePopupMenu.this.ruleEditor != null) {
                        ModePopupMenu.this.ruleEditor.setEditMode(114);
                    } else if (ModePopupMenu.this.graphEditor != null) {
                        ModePopupMenu.this.graphEditor.setEditMode(114);
                    }
                }
            }
        });
        this.miMap = (JCheckBoxMenuItem)this.add(new JCheckBoxMenuItem("Map                                           Ctrl+M"));
        this.miMap.setActionCommand("mapMode");
        this.miMap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JMenuItem) {
                    ((JCheckBoxMenuItem)e.getSource()).setSelected(true);
                    ModePopupMenu.this.selectEditModeMenuItem("Map");
                    ModePopupMenu.this.selectMainEditModeMenuItem("Map");
                    if (ModePopupMenu.this.editor != null) {
                        ModePopupMenu.this.editor.setEditMode(115);
                        ModePopupMenu.this.editor.selectToolBarModeItem("Map");
                    } else if (ModePopupMenu.this.ruleEditor != null) {
                        ModePopupMenu.this.ruleEditor.setEditMode(115);
                    } else if (ModePopupMenu.this.graphEditor != null) {
                        ModePopupMenu.this.graphEditor.setEditMode(115);
                    }
                }
            }
        });
        this.miUnmap = (JCheckBoxMenuItem)this.add(new JCheckBoxMenuItem("Unmap                                       Ctrl+U"));
        this.miUnmap.setActionCommand("unmapMode");
        this.miUnmap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JMenuItem) {
                    ((JCheckBoxMenuItem)e.getSource()).setSelected(true);
                    ModePopupMenu.this.selectEditModeMenuItem("Unmap");
                    ModePopupMenu.this.selectMainEditModeMenuItem("Unmap");
                    if (ModePopupMenu.this.editor != null) {
                        ModePopupMenu.this.editor.setEditMode(116);
                        ModePopupMenu.this.editor.selectToolBarModeItem("Unmap");
                    } else if (ModePopupMenu.this.ruleEditor != null) {
                        ModePopupMenu.this.ruleEditor.setEditMode(116);
                    } else if (ModePopupMenu.this.graphEditor != null) {
                        ModePopupMenu.this.graphEditor.setEditMode(116);
                    }
                }
            }
        });
        this.miImage = new JCheckBoxMenuItem("Image_view");
        this.miImage.setActionCommand("imageMode");
        this.miImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JMenuItem) {
                    ((JCheckBoxMenuItem)e.getSource()).setSelected(true);
                    ModePopupMenu.this.selectEditModeMenuItem("Image_view");
                    ModePopupMenu.this.selectMainEditModeMenuItem("Image_view");
                    if (ModePopupMenu.this.editor != null) {
                        ModePopupMenu.this.editor.setNodeIconable(((JCheckBoxMenuItem)e.getSource()).isSelected());
                    }
                }
            }
        });
        this.addSeparator();
        JMenuItem miSelNodeType = this.add(new JMenuItem("Select Nodes of Type             Ctrl+Alt+N"));
        miSelNodeType.setActionCommand("selectNodeType");
        miSelNodeType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ModePopupMenu.this.gp != null && ModePopupMenu.this.gp.getGraph() != null) {
                    ModePopupMenu.this.gp.getGraph().selectObjectsOfSelectedNodeType();
                    ModePopupMenu.this.gp.updateGraphics();
                }
            }
        });
        JMenuItem miSelArcType = this.add(new JMenuItem("Select Arcs of Type                Ctrl+Alt+E"));
        miSelArcType.setActionCommand("selectArcType");
        miSelArcType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ModePopupMenu.this.gp != null && ModePopupMenu.this.gp.getGraph() != null) {
                    ModePopupMenu.this.gp.getGraph().selectObjectsOfSelectedArcType();
                    ModePopupMenu.this.gp.updateGraphics();
                }
            }
        });
        JMenuItem miSelectAll = this.add(new JMenuItem("Select All                               Ctrl+Alt+S"));
        miSelectAll.setActionCommand("selectAll");
        miSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ModePopupMenu.this.gp != null && ModePopupMenu.this.gp.getGraph() != null) {
                    ModePopupMenu.this.gp.getGraph().selectAll();
                    ModePopupMenu.this.gp.updateGraphics();
                }
            }
        });
        JMenuItem miDeselectAll = this.add(new JMenuItem("Deselect All                           Ctrl+Alt+U"));
        miDeselectAll.setActionCommand("deselectAll");
        miDeselectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ModePopupMenu.this.gp != null && ModePopupMenu.this.gp.getGraph() != null) {
                    ModePopupMenu.this.gp.getGraph().deselectAll();
                    ModePopupMenu.this.gp.updateGraphics();
                }
            }
        });
        this.addSeparator();
        JMenuItem miGraphExportJPG = this.add(new JMenuItem("Export JPEG"));
        miGraphExportJPG.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ModePopupMenu.this.gp != null && ModePopupMenu.this.gp.getGraph() != null && ModePopupMenu.this.exportJPEG != null) {
                    ModePopupMenu.this.exportJPEG.save(ModePopupMenu.this.gp.getCanvas());
                }
            }
        });
        this.pack();
        this.setBorderPainted(true);
    }

    public void setEditor(GraGraEditor ed) {
        this.editor = ed;
        this.ruleEditor = this.editor.getRuleEditor();
        this.graphEditor = this.editor.getGraphEditor();
    }

    public void setEditor(RuleEditor re) {
        this.ruleEditor = re;
    }

    public void setEditor(GraphEditor ge) {
        this.graphEditor = ge;
    }

    public void setGraphExportJPEG(GraphicsExportJPEG jpg) {
        this.exportJPEG = jpg;
    }

    public boolean invoked(JComponent parent, GraphPanel p, int x, int y) {
        this.gp = p;
        if (this.gp != null && this.gp.getGraph() != null) {
            if (this.gp.getGraph().getPicked(x, y) == null && this.gp.getGraph().getPickedTextOfArc(x, y, this.gp.getCanvas().getGraphics().getFontMetrics()) == null) {
                if (parent instanceof RuleEditor) {
                    this.miSynchronMove.setEnabled(true);
                } else {
                    this.miSynchronMove.setEnabled(false);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void setViewModel(boolean view) {
        if (view) {
            this.miDraw.setEnabled(false);
            this.miAttrs.setEnabled(false);
            this.miMap.setEnabled(false);
            this.miUnmap.setEnabled(false);
        } else {
            this.miDraw.setEnabled(true);
            this.miAttrs.setEnabled(true);
            this.miMap.setEnabled(true);
            this.miUnmap.setEnabled(true);
        }
    }

    public void deselectAll() {
        this.miDraw.setSelected(false);
        this.miMove.setSelected(false);
        this.miAttrs.setSelected(false);
        this.miMap.setSelected(false);
        this.miUnmap.setSelected(false);
    }

    public void setMainModeMenu(JMenu m) {
        this.mainModeMenu = m;
    }

    private String unspaced(String s) {
        return s.replaceAll(" ", "");
    }

    private void selectMainEditModeMenuItem(String editmode) {
        String mode = this.unspaced(editmode);
        if (this.mainModeMenu != null) {
            for (int i = 0; i < this.mainModeMenu.getItemCount(); ++i) {
                if (!(this.mainModeMenu.getMenuComponent(i) instanceof JCheckBoxMenuItem) || ((JCheckBoxMenuItem)this.mainModeMenu.getItem(i)).getText().equals("Image_view")) continue;
                String itemname = this.unspaced(((JCheckBoxMenuItem)this.mainModeMenu.getItem(i)).getText());
                if (itemname.indexOf(mode) != -1) {
                    ((JCheckBoxMenuItem)this.mainModeMenu.getItem(i)).setSelected(true);
                    continue;
                }
                ((JCheckBoxMenuItem)this.mainModeMenu.getItem(i)).setSelected(false);
            }
        }
    }

    public void selectEditModeMenuItem(String editmode) {
        String mode = this.unspaced(editmode);
        for (int i = 1; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof JCheckBoxMenuItem)) continue;
            String itemname = this.unspaced(((JCheckBoxMenuItem)this.getComponent(i)).getText());
            if (mode.equals("Image_view") || itemname.equals("SynchronMoveMappedObjects")) continue;
            if (itemname.indexOf(mode) != -1) {
                ((JCheckBoxMenuItem)((JMenuItem)this.getComponent(i))).setSelected(true);
                continue;
            }
            ((JCheckBoxMenuItem)((JMenuItem)this.getComponent(i))).setSelected(false);
        }
    }
}

