/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdType;
import agg.editor.impl.EdTypeSet;
import agg.gui.NodeTypePopupMenu;
import agg.gui.TypePalette;
import agg.gui.event.TypeEvent;
import agg.gui.event.TypeEventListener;
import agg.gui.icons.CircleShapeIcon;
import agg.gui.icons.OvalShapeIcon;
import agg.gui.icons.RectShapeIcon;
import agg.gui.icons.RoundRectShapeIcon;
import agg.xt_basis.TypeException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class NodeTypeComboBox
extends JPanel {
    private JComboBox custom;
    private CustomComboBoxModel customModel;
    private JFrame parentAppl;
    private Icon typeIcon;
    private JLabel typeIconLabel;
    private int selIndex;
    private EdGraGra eGra;
    private EdTypeSet typeSet;
    private String nodeTypeName = "";
    private int nodeTypeShape = 51;
    private Color nodeTypeColor = Color.black;
    private String nodeTypeResourcesPath = System.getProperty("user.dir");
    private String nodeTypeImageFileName = "";
    private NodeTypePopupMenu nodeTypePopupMenu;
    private boolean redefineMode = false;
    private Vector typeEventListeners;

    public NodeTypeComboBox() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(150, 20));
        this.typeIconLabel = new JLabel(" ", null, 2);
        this.typeIconLabel.setToolTipText("Color/Shape Menu");
        this.add((Component)this.typeIconLabel, "West");
        this.customModel = new CustomComboBoxModel(this);
        this.custom = new JComboBox(this.customModel);
        this.customModel.setComboBox(this.custom);
        this.custom.setEditor(new CustomEditor());
        this.custom.setEnabled(false);
        this.custom.setEditable(false);
        this.custom.setRenderer(new MyCellRenderer(this.custom));
        this.add((Component)this.custom, "Center");
        this.nodeTypePopupMenu = new NodeTypePopupMenu();
        this.nodeTypePopupMenu.setTypeIconLabel(this.typeIconLabel);
        this.nodeTypePopupMenu.setComboBox(this);
        this.typeIconLabel.setIcon(this.customModel.getNodeTypeIcon(51, Color.black));
        this.typeIconLabel.setEnabled(false);
        this.selIndex = -1;
        this.typeIconLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getSource() instanceof JLabel && NodeTypeComboBox.this.nodeTypePopupMenu.invoked(e.getX(), e.getY())) {
                    NodeTypeComboBox.this.nodeTypePopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.getSource() instanceof JLabel && NodeTypeComboBox.this.nodeTypePopupMenu.invoked(e.getX(), e.getY())) {
                    NodeTypeComboBox.this.nodeTypePopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.custom.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (NodeTypeComboBox.this.typeSet != null) {
                    String str = (String)NodeTypeComboBox.this.custom.getEditor().getItem();
                    String nameStr = str.replaceAll(" ", "");
                    NodeTypeComboBox.this.nodeTypeName = nameStr;
                    NodeTypeComboBox.this.nodeTypeShape = NodeTypeComboBox.this.nodeTypePopupMenu.getSelectedShape();
                    NodeTypeComboBox.this.nodeTypeColor = NodeTypeComboBox.this.nodeTypePopupMenu.getSelectedColor();
                    NodeTypeComboBox.this.typeIcon = NodeTypeComboBox.this.customModel.getNodeTypeIcon(NodeTypeComboBox.this.nodeTypeShape, NodeTypeComboBox.this.nodeTypeColor);
                    if (NodeTypeComboBox.this.redefineMode && NodeTypeComboBox.this.typeSet.getNodeTypes().isEmpty()) {
                        NodeTypeComboBox.this.redefineMode = false;
                        NodeTypeComboBox.this.nodeTypePopupMenu.setRedefine(false);
                    }
                    if (NodeTypeComboBox.this.redefineMode) {
                        int selIndx = NodeTypeComboBox.this.customModel.getSelectedIndex();
                        if (NodeTypeComboBox.this.redefineType(selIndx, NodeTypeComboBox.this.nodeTypeName, NodeTypeComboBox.this.nodeTypeShape, NodeTypeComboBox.this.nodeTypeColor, NodeTypeComboBox.this.nodeTypeImageFileName)) {
                            NodeTypeComboBox.this.customModel.reiconizeItemAt(selIndx, NodeTypeComboBox.this.typeIcon);
                            NodeTypeComboBox.this.customModel.renameItemAt(selIndx, NodeTypeComboBox.this.nodeTypeName);
                            NodeTypeComboBox.this.customModel.setSelectedIndex(selIndx);
                            NodeTypeComboBox.this.fireTypeEvent(new TypeEvent(this, 3));
                        }
                    } else {
                        EdType t = NodeTypeComboBox.this.typeSet.createNodeType(NodeTypeComboBox.this.nodeTypeName, NodeTypeComboBox.this.nodeTypeShape, NodeTypeComboBox.this.nodeTypeColor);
                        if (t != null) {
                            t.setImageFileName(NodeTypeComboBox.this.nodeTypeImageFileName);
                            JLabel l = new JLabel(NodeTypeComboBox.this.nodeTypeName, NodeTypeComboBox.this.typeIcon, 2);
                            NodeTypeComboBox.this.customModel.getTable().put(l, t);
                            NodeTypeComboBox.this.customModel.addItem(l);
                            NodeTypeComboBox.this.setTypeIcon(NodeTypeComboBox.this.typeIcon);
                            NodeTypeComboBox.this.customModel.setSelectedIndex(NodeTypeComboBox.this.selIndex);
                            NodeTypeComboBox.this.eGra.setChanged(true);
                        }
                    }
                }
            }
        });
    }

    public void setFrame(JFrame f) {
        this.parentAppl = f;
        this.nodeTypePopupMenu.setFrame(f);
    }

    public void setTypePalette(TypePalette palette) {
        this.customModel.setTypePalette(palette);
    }

    public synchronized void addTypeEventListener(TypeEventListener l) {
        Vector v;
        Vector vector = v = this.typeEventListeners == null ? new Vector(2) : (Vector)this.typeEventListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.typeEventListeners = v;
        }
    }

    public synchronized void removeTypeEventListener(TypeEventListener l) {
        if (this.typeEventListeners != null && this.typeEventListeners.contains(l)) {
            Vector v = (Vector)this.typeEventListeners.clone();
            v.removeElement(l);
            this.typeEventListeners = v;
        }
    }

    private void fireTypeEvent(TypeEvent e) {
        if (this.typeEventListeners != null) {
            Vector listeners = this.typeEventListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((TypeEventListener)listeners.elementAt(i)).typeEventOccurred(e);
            }
        }
    }

    public void setEnabled(boolean enable) {
        this.custom.setEnabled(enable);
        this.custom.setEditable(enable);
        this.typeIconLabel.setEnabled(enable);
    }

    public JComboBox getCustom() {
        return this.custom;
    }

    public CustomComboBoxModel getCustomModel() {
        return this.customModel;
    }

    public NodeTypePopupMenu getPopupMenu() {
        return this.nodeTypePopupMenu;
    }

    public void setTypeIcon(Icon icon) {
        this.typeIconLabel.setIcon(icon);
    }

    public void setGraGra(EdGraGra egra) {
        this.eGra = egra;
        if (this.eGra != null) {
            this.typeSet = this.eGra.getTypeSet();
            this.setEnabled(true);
            this.nodeTypePopupMenu.setRedefine(false);
        } else {
            this.typeSet = null;
            this.setEnabled(false);
        }
    }

    public void setTypeSet(EdTypeSet types) {
        this.typeSet = types;
    }

    public void setRedefineMode(boolean value) {
        this.redefineMode = value;
    }

    public void renameType(String newName) {
        int selIndx;
        if (this.typeSet != null && (selIndx = this.customModel.getSelectedIndex()) >= 0) {
            EdType et = (EdType)this.typeSet.getNodeTypes().elementAt(selIndx);
            if (!et.name.equals(newName)) {
                this.typeSet.renameType(et, newName);
                this.customModel.renameItemAt(selIndx, newName);
                this.eGra.setChanged(true);
            }
        }
    }

    public void setTypeImageFileName(String newImageFileName) {
        this.nodeTypeImageFileName = newImageFileName;
        this.eGra.setChanged(true);
    }

    public void setTypeResourcesPath(String path) {
        this.nodeTypeResourcesPath = path;
    }

    public boolean redefineType(int selIndx, String newName, int newShape, Color newColor, String newImageFileName) {
        EdType et;
        if (this.typeSet != null && selIndx >= 0 && this.typeSet.redefineType(et = (EdType)this.typeSet.getNodeTypes().elementAt(selIndx), newName, newShape, newColor, newImageFileName)) {
            this.eGra.setChanged(true);
            return true;
        }
        return false;
    }

    public void deleteType() {
        int selIndx;
        if (this.typeSet != null && (selIndx = this.customModel.getSelectedIndex()) >= 0) {
            EdType et = (EdType)this.typeSet.getNodeTypes().elementAt(selIndx);
            int answer = 1;
            if (this.typeSet.isUsed(et)) {
                if (this.typeSet.getBasisTypeSet().getLevelOfTypeGraphCheck() != 0) {
                    JOptionPane.showMessageDialog(null, "Please disable the type graph before delete a type.", "Type graph enabled", 0);
                    return;
                }
                Object[] options = new Object[]{"Delete", "Cancel"};
                answer = JOptionPane.showOptionDialog(null, "Are you sure you want to delete this type?\nThere are objects of it.", "Warning", -1, 2, null, options, options[0]);
                if (answer == 0) {
                    this.typeSet.deleteGraphObjectsOfType(et.getBasisType(), true);
                    this.fireTypeEvent(new TypeEvent(this, 6));
                }
            }
            if (!this.typeSet.isUsed(et) || answer == 0) {
                try {
                    if (this.eGra.getStartGraph() != null) {
                        this.eGra.getStartGraph().deleteObjects(et);
                    }
                    this.eGra.destroyUndoGraph();
                    int index = selIndx;
                    this.typeSet.removeNodeType(et);
                    this.eGra.setChanged(true);
                }
                catch (TypeException e) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Type Graph Error", 0);
                    return;
                }
                this.selIndex = this.customModel.removeItemAt(selIndx);
                if (this.selIndex == -1) {
                    this.nodeTypeName = "";
                    this.nodeTypePopupMenu.setSelectedShapeIndex(0);
                    this.nodeTypePopupMenu.setSelectedColorIndex(0);
                    this.nodeTypeShape = this.nodeTypePopupMenu.getSelectedShape();
                    this.nodeTypeColor = this.nodeTypePopupMenu.getSelectedColor();
                    this.typeIcon = this.customModel.getNodeTypeIcon(this.nodeTypeShape, this.nodeTypeColor);
                    this.setTypeIcon(this.typeIcon);
                } else {
                    this.nodeTypeName = ((EdType)this.typeSet.getNodeTypes().elementAt((int)this.selIndex)).name;
                    this.nodeTypeShape = ((EdType)this.typeSet.getNodeTypes().elementAt((int)this.selIndex)).shape;
                    this.nodeTypeColor = ((EdType)this.typeSet.getNodeTypes().elementAt((int)this.selIndex)).color;
                    this.nodeTypeResourcesPath = ((EdType)this.typeSet.getNodeTypes().elementAt((int)this.selIndex)).resourcesPath;
                    this.nodeTypeImageFileName = ((EdType)this.typeSet.getNodeTypes().elementAt((int)this.selIndex)).imageFileName;
                    this.typeIcon = this.customModel.getNodeTypeIcon(this.nodeTypeShape, this.nodeTypeColor);
                    this.setTypeIcon(this.typeIcon);
                    this.nodeTypePopupMenu.setSelectedShape(this.nodeTypeShape);
                    this.nodeTypePopupMenu.setSelectedColor(this.nodeTypeColor);
                }
            }
        }
    }

    public Vector getNodeTypes() {
        return this.customModel.getTypes();
    }

    class CustomEditor
    extends BasicComboBoxEditor {
        public void setItem(Object anObject) {
            if (anObject instanceof String) {
                super.setItem(anObject);
            } else if (anObject instanceof JLabel) {
                super.setItem(((JLabel)anObject).getText());
            }
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private JComboBox comboBox;

        public MyCellRenderer(JComboBox x) {
            this.comboBox = x;
        }

        public Component getListCellRendererComponent(JList listbox, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index == -1) {
                return this;
            }
            if (value == null) {
                this.setIcon(null);
                this.setText("");
                NodeTypeComboBox.this.selIndex = -1;
                return this;
            }
            Vector types = null;
            ComboBoxModel model = this.comboBox.getModel();
            if (model instanceof CustomComboBoxModel) {
                types = ((CustomComboBoxModel)model).getTypes();
            }
            if (types == null) {
                return this;
            }
            JLabel l = value instanceof JLabel ? (JLabel)value : (JLabel)types.elementAt(index);
            this.setForeground(Color.black);
            if (isSelected) {
                this.setBackground(Color.lightGray);
            } else {
                this.setBackground(Color.white);
            }
            this.setIcon(l.getIcon());
            this.setText(l.getText());
            this.setToolTipText(l.getText());
            this.setOpaque(true);
            ((CustomComboBoxModel)this.comboBox.getModel()).setCurrentValue(l);
            return this;
        }
    }

    class CustomComboBoxModel
    extends DefaultListModel
    implements ComboBoxModel {
        private NodeTypeComboBox typeBox;
        private Object currentValue;
        private Object currentObj;
        private JComboBox comboBox;
        private Vector types;
        private Hashtable table;
        private TypePalette palette;

        public CustomComboBoxModel(NodeTypeComboBox myBox) {
            this.typeBox = myBox;
            this.types = new Vector();
            this.table = new Hashtable();
        }

        public void setComboBox(JComboBox comboBox) {
            this.comboBox = comboBox;
        }

        public void setTypePalette(TypePalette palette) {
            this.palette = palette;
        }

        public void setCurrentValue(JLabel l) {
            this.currentValue = l;
        }

        public void setSelectedIndex(int index) {
            if (index != -1) {
                NodeTypeComboBox.this.selIndex = index;
                this.comboBox.setSelectedIndex(index);
            }
        }

        public void setSelectedItem(Object anObject) {
            NodeTypeComboBox.this.selIndex = this.getSelectedIndex();
            if (NodeTypeComboBox.this.typeSet != null && NodeTypeComboBox.this.typeSet.getNodeTypes().size() != 0 && NodeTypeComboBox.this.selIndex >= 0 && NodeTypeComboBox.this.selIndex < NodeTypeComboBox.this.typeSet.getNodeTypes().size()) {
                if (anObject instanceof String) {
                    this.currentObj = (String)anObject;
                }
                if (anObject instanceof JLabel) {
                    this.currentValue = (JLabel)this.types.elementAt(NodeTypeComboBox.this.selIndex);
                    this.currentObj = ((JLabel)this.currentValue).getText();
                }
                if (this.currentValue != null) {
                    NodeTypeComboBox.this.typeSet.setSelectedNodeType((EdType)this.table.get((JLabel)this.currentValue));
                } else {
                    NodeTypeComboBox.this.typeSet.setSelectedNodeType((EdType)NodeTypeComboBox.this.typeSet.getNodeTypes().elementAt(NodeTypeComboBox.this.selIndex));
                }
                EdType t = NodeTypeComboBox.this.typeSet.getSelectedNodeType();
                this.comboBox.getEditor().setItem(t.getName());
                NodeTypeComboBox.this.typeIcon = this.getNodeTypeIcon(t);
                this.typeBox.setTypeIcon(NodeTypeComboBox.this.typeIcon);
                this.typeBox.getPopupMenu().setSelectedShape(t.shape);
                this.typeBox.getPopupMenu().setSelectedColor(t.color);
                this.typeBox.getPopupMenu().setResourcesPath(t.resourcesPath);
                this.typeBox.getPopupMenu().setImageFileName(t.imageFileName);
                this.palette.setSelectedNodeTypeIndex(NodeTypeComboBox.this.selIndex);
            }
        }

        public Vector getTypes() {
            return this.types;
        }

        public Hashtable getTable() {
            return this.table;
        }

        public int getSelectedIndex() {
            int i = this.comboBox.getSelectedIndex();
            if (i != -1) {
                NodeTypeComboBox.this.selIndex = i;
            }
            return NodeTypeComboBox.this.selIndex;
        }

        public Object getSelectedItem() {
            return this.currentValue;
        }

        public Object getElementAt(int index) {
            if (index != -1 && index < this.types.size()) {
                JLabel l = (JLabel)this.types.elementAt(index);
                if (l != null) {
                    this.currentValue = l;
                    this.currentObj = l.getText();
                }
                return this.currentValue;
            }
            return new JLabel("");
        }

        public int getSize() {
            return this.types.size();
        }

        public Object addItem(JLabel l) {
            if (l != null) {
                NodeTypeComboBox.this.selIndex = this.addSorted(l);
                this.currentValue = l;
                this.currentObj = l.getText();
                if (this.palette != null) {
                    this.palette.addNodeType(l, NodeTypeComboBox.this.selIndex);
                }
                this.fireContentsChanged(this, -1, -1);
            } else {
                this.currentValue = new JLabel("undefined");
                this.currentObj = new String("undefined");
            }
            return this.currentValue;
        }

        public Object addItem(EdType t, JLabel l, boolean sorted) {
            if (l != null) {
                if (sorted) {
                    this.types.addElement(l);
                    this.table.put(l, t);
                    NodeTypeComboBox.this.selIndex = this.types.size() - 1;
                } else {
                    NodeTypeComboBox.this.selIndex = this.addSorted(l);
                    this.table.put(l, t);
                }
                this.currentValue = l;
                this.currentObj = l.getText();
                if (this.palette != null) {
                    this.palette.addNodeType(l, NodeTypeComboBox.this.selIndex);
                }
                this.fireContentsChanged(this, -1, -1);
            } else {
                this.currentValue = new JLabel("undefined");
                this.currentObj = new String("undefined");
            }
            return this.currentValue;
        }

        public Object addItem(EdType t) {
            if (t != null) {
                JLabel l = new JLabel();
                l.setIcon(this.getNodeTypeIcon(t));
                l.setText(t.name);
                this.table.put(l, t);
                JLabel ll = (JLabel)this.addItem(l);
                return ll;
            }
            return null;
        }

        private int addSorted(JLabel l) {
            int indx = -1;
            String name = l.getText();
            if (this.types.isEmpty()) {
                this.types.add(l);
            } else {
                for (int i = 0; i < this.types.size(); ++i) {
                    JLabel t = (JLabel)this.types.get(i);
                    String n = t.getText();
                    if (name.compareTo(n) < 0) {
                        this.types.add(i, l);
                        break;
                    }
                    if (name.compareTo(n) != 0) continue;
                    this.types.add(i, l);
                    break;
                }
                if (this.types.indexOf(l) == -1) {
                    this.types.add(l);
                }
            }
            indx = this.types.indexOf(l);
            return indx;
        }

        public void renameItemAt(int index, String newName) {
            if (index >= 0 && index < this.types.size()) {
                JLabel l = (JLabel)this.types.elementAt(index);
                l.setText(newName);
                this.currentValue = l;
                this.currentObj = l.getText();
                this.setSelectedItem((String)this.currentObj);
                this.palette.changeNodeType(l, index);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void reiconizeItemAt(int index, Icon newIcon) {
            if (index >= 0 && index < this.types.size()) {
                JLabel l = (JLabel)this.types.elementAt(index);
                l.setIcon(newIcon);
                this.currentValue = l;
                this.currentObj = l.getText();
                this.palette.changeNodeType(l, index);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public int removeItemAt(int index) {
            if (index >= 0 && index < this.types.size()) {
                JLabel elem = (JLabel)this.types.get(index);
                this.types.removeElementAt(index);
                if (this.palette != null) {
                    this.palette.removeNodeType(elem, index);
                }
                if (index == this.types.size()) {
                    --index;
                }
                if (index >= 0) {
                    this.setSelectedIndex(index);
                    JLabel l = (JLabel)this.types.elementAt(index);
                    this.currentValue = l;
                    this.currentObj = l.getText();
                    this.fireContentsChanged(this, -1, -1);
                    this.comboBox.getEditor().setItem((String)this.currentObj);
                } else {
                    this.comboBox.getEditor().setItem("");
                    NodeTypeComboBox.this.typeSet.setSelectedNodeType(null);
                    this.currentValue = null;
                    this.currentObj = null;
                    index = -1;
                }
            }
            return index;
        }

        public void removeAllItems() {
            for (int i = this.types.size() - 1; i >= 0; --i) {
                this.types.removeElementAt(i);
            }
            this.currentValue = null;
            this.currentObj = null;
            NodeTypeComboBox.this.selIndex = -1;
            this.comboBox.getEditor().setItem("");
        }

        public boolean hasMoreElements() {
            return this.types.size() != 0;
        }

        public Icon getNodeTypeIcon(EdType et) {
            Icon icon = null;
            switch (et.shape) {
                case 51: {
                    icon = new RectShapeIcon(et.color);
                    break;
                }
                case 54: {
                    icon = new RoundRectShapeIcon(et.color);
                    break;
                }
                case 52: {
                    icon = new CircleShapeIcon(et.color);
                    break;
                }
                case 53: {
                    icon = new OvalShapeIcon(et.color);
                    break;
                }
            }
            return icon;
        }

        public Icon getNodeTypeIcon(int shape, Color color) {
            Icon icon = null;
            switch (shape) {
                case 51: {
                    icon = new RectShapeIcon(color);
                    break;
                }
                case 54: {
                    icon = new RoundRectShapeIcon(color);
                    break;
                }
                case 52: {
                    icon = new CircleShapeIcon(color);
                    break;
                }
                case 53: {
                    icon = new OvalShapeIcon(color);
                    break;
                }
            }
            return icon;
        }
    }
}

