/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.gui.AGGFileFilter;
import agg.gui.NodeTypeComboBox;
import agg.gui.icons.CircleShapeIcon;
import agg.gui.icons.ColoredSquare;
import agg.gui.icons.OvalShapeIcon;
import agg.gui.icons.RectShapeIcon;
import agg.gui.icons.RoundRectShapeIcon;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class NodeTypePopupMenu
extends JPopupMenu {
    private JFrame parentAppl;
    private JMenuItem mi;
    private JMenu color;
    private JMenu shape;
    private JMenu image;
    private JLabel typeIconLabel;
    private Color nodeTypeColor = Color.black;
    private int nodeTypeShape = 51;
    private String resourcesPath = System.getProperty("user.dir");
    private String imageFileName = "";
    private JCheckBoxMenuItem redefinecmi;
    private NodeTypeComboBox comboBox;

    public NodeTypePopupMenu() {
        super("NodeType");
        JCheckBoxMenuItem cmi;
        this.color = (JMenu)this.add(new JMenu("Color"));
        this.color.setHorizontalTextPosition(4);
        this.color.setIcon(new ColoredSquare(Color.black));
        this.mi = this.color.add(new JMenuItem("Black"));
        this.mi.setHorizontalTextPosition(4);
        this.mi.setIcon(new ColoredSquare(Color.black));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeTypePopupMenu.this.color.setIcon(new ColoredSquare(Color.black));
                NodeTypePopupMenu.this.nodeTypeColor = NodeTypePopupMenu.getTypeColor(((JMenuItem)e.getSource()).getText());
                NodeTypePopupMenu.this.typeIconLabel.setIcon(NodeTypePopupMenu.getNodeTypeIcon(NodeTypePopupMenu.this.nodeTypeShape, NodeTypePopupMenu.this.nodeTypeColor));
            }
        });
        this.mi = this.color.add(new JMenuItem("Orange"));
        this.mi.setHorizontalTextPosition(4);
        this.mi.setIcon(new ColoredSquare(Color.orange));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeTypePopupMenu.this.color.setIcon(new ColoredSquare(Color.orange));
                NodeTypePopupMenu.this.nodeTypeColor = NodeTypePopupMenu.getTypeColor(((JMenuItem)e.getSource()).getText());
                NodeTypePopupMenu.this.typeIconLabel.setIcon(NodeTypePopupMenu.getNodeTypeIcon(NodeTypePopupMenu.this.nodeTypeShape, NodeTypePopupMenu.this.nodeTypeColor));
            }
        });
        this.mi = this.color.add(new JMenuItem("Blue"));
        this.mi.setHorizontalTextPosition(4);
        this.mi.setIcon(new ColoredSquare(Color.blue));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeTypePopupMenu.this.color.setIcon(new ColoredSquare(Color.blue));
                NodeTypePopupMenu.this.nodeTypeColor = NodeTypePopupMenu.getTypeColor(((JMenuItem)e.getSource()).getText());
                NodeTypePopupMenu.this.typeIconLabel.setIcon(NodeTypePopupMenu.getNodeTypeIcon(NodeTypePopupMenu.this.nodeTypeShape, NodeTypePopupMenu.this.nodeTypeColor));
            }
        });
        this.mi = this.color.add(new JMenuItem("Red"));
        this.mi.setHorizontalTextPosition(4);
        this.mi.setIcon(new ColoredSquare(Color.red));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeTypePopupMenu.this.color.setIcon(new ColoredSquare(Color.red));
                NodeTypePopupMenu.this.nodeTypeColor = NodeTypePopupMenu.getTypeColor(((JMenuItem)e.getSource()).getText());
                NodeTypePopupMenu.this.typeIconLabel.setIcon(NodeTypePopupMenu.getNodeTypeIcon(NodeTypePopupMenu.this.nodeTypeShape, NodeTypePopupMenu.this.nodeTypeColor));
            }
        });
        this.mi = this.color.add(new JMenuItem("Pink"));
        this.mi.setHorizontalTextPosition(4);
        this.mi.setIcon(new ColoredSquare(Color.pink));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeTypePopupMenu.this.color.setIcon(new ColoredSquare(Color.pink));
                NodeTypePopupMenu.this.nodeTypeColor = NodeTypePopupMenu.getTypeColor(((JMenuItem)e.getSource()).getText());
                NodeTypePopupMenu.this.typeIconLabel.setIcon(NodeTypePopupMenu.getNodeTypeIcon(NodeTypePopupMenu.this.nodeTypeShape, NodeTypePopupMenu.this.nodeTypeColor));
            }
        });
        this.shape = (JMenu)this.add(new JMenu("Shape"));
        this.shape.setHorizontalTextPosition(4);
        this.shape.setIcon(new RectShapeIcon(Color.black));
        this.mi = this.shape.add(new JMenuItem("Rectangle"));
        this.mi.setHorizontalTextPosition(4);
        this.mi.setIcon(new RectShapeIcon(Color.black));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeTypePopupMenu.this.shape.setIcon(new RectShapeIcon(Color.black));
                NodeTypePopupMenu.this.nodeTypeShape = NodeTypePopupMenu.getNodeTypeShape(((JMenuItem)e.getSource()).getText());
                NodeTypePopupMenu.this.typeIconLabel.setIcon(NodeTypePopupMenu.getNodeTypeIcon(NodeTypePopupMenu.this.nodeTypeShape, NodeTypePopupMenu.this.nodeTypeColor));
            }
        });
        this.mi = this.shape.add(new JMenuItem("Roundrect"));
        this.mi.setHorizontalTextPosition(4);
        this.mi.setIcon(new RoundRectShapeIcon(Color.black));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeTypePopupMenu.this.shape.setIcon(new RoundRectShapeIcon(Color.black));
                NodeTypePopupMenu.this.nodeTypeShape = NodeTypePopupMenu.getNodeTypeShape(((JMenuItem)e.getSource()).getText());
                NodeTypePopupMenu.this.typeIconLabel.setIcon(NodeTypePopupMenu.getNodeTypeIcon(NodeTypePopupMenu.this.nodeTypeShape, NodeTypePopupMenu.this.nodeTypeColor));
            }
        });
        this.mi = this.shape.add(new JMenuItem("Oval"));
        this.mi.setHorizontalTextPosition(4);
        this.mi.setIcon(new OvalShapeIcon(Color.black));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeTypePopupMenu.this.shape.setIcon(new OvalShapeIcon(Color.black));
                NodeTypePopupMenu.this.nodeTypeShape = NodeTypePopupMenu.getNodeTypeShape(((JMenuItem)e.getSource()).getText());
                NodeTypePopupMenu.this.typeIconLabel.setIcon(NodeTypePopupMenu.getNodeTypeIcon(NodeTypePopupMenu.this.nodeTypeShape, NodeTypePopupMenu.this.nodeTypeColor));
            }
        });
        this.mi = this.shape.add(new JMenuItem("Circle"));
        this.mi.setHorizontalTextPosition(4);
        this.mi.setIcon(new CircleShapeIcon(Color.black));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeTypePopupMenu.this.shape.setIcon(new CircleShapeIcon(Color.black));
                NodeTypePopupMenu.this.nodeTypeShape = NodeTypePopupMenu.getNodeTypeShape(((JMenuItem)e.getSource()).getText());
                NodeTypePopupMenu.this.typeIconLabel.setIcon(NodeTypePopupMenu.getNodeTypeIcon(NodeTypePopupMenu.this.nodeTypeShape, NodeTypePopupMenu.this.nodeTypeColor));
            }
        });
        this.mi = new JMenuItem("Image");
        this.add(this.mi);
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal;
                JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
                AGGFileFilter filter = new AGGFileFilter();
                filter.addExtension("jpg");
                filter.addExtension("gif");
                filter.setDescription("JPG & GIF Images");
                chooser.setFileFilter(filter);
                if (NodeTypePopupMenu.this.imageFileName.indexOf(".gif") != -1 || NodeTypePopupMenu.this.imageFileName.indexOf(".jpg") != -1) {
                    chooser.setSelectedFile(new File(NodeTypePopupMenu.this.resourcesPath + "/" + NodeTypePopupMenu.this.imageFileName));
                }
                if ((returnVal = chooser.showOpenDialog(NodeTypePopupMenu.this.parentAppl)) == 0) {
                    if (chooser.getSelectedFile() != null && !chooser.getSelectedFile().getName().equals("")) {
                        NodeTypePopupMenu.this.resourcesPath = chooser.getCurrentDirectory().toString();
                        NodeTypePopupMenu.this.imageFileName = chooser.getSelectedFile().getName();
                        NodeTypePopupMenu.this.comboBox.setTypeResourcesPath(NodeTypePopupMenu.this.resourcesPath);
                        NodeTypePopupMenu.this.comboBox.setTypeImageFileName(NodeTypePopupMenu.this.imageFileName);
                    } else {
                        NodeTypePopupMenu.this.resourcesPath = System.getProperty("user.dir");
                        NodeTypePopupMenu.this.imageFileName = "";
                    }
                }
            }
        });
        this.addSeparator();
        this.mi = this.add(new JMenuItem("Delete"));
        this.mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeTypePopupMenu.this.comboBox.deleteType();
            }
        });
        this.addSeparator();
        this.redefinecmi = cmi = (JCheckBoxMenuItem)this.add(new JCheckBoxMenuItem("Redefine"));
        cmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeTypePopupMenu.this.comboBox.setRedefineMode(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        this.pack();
        this.setBorderPainted(true);
    }

    public Color getSelectedColor() {
        return this.nodeTypeColor;
    }

    public void setSelectedColorIndex(int indx) {
        this.color.getItem(indx).setSelected(true);
        this.nodeTypeColor = NodeTypePopupMenu.getTypeColor(this.color.getItem(indx).getText());
        this.color.setIcon(new ColoredSquare(this.nodeTypeColor));
    }

    public void setSelectedColor(Color col) {
        if (col.equals(Color.black)) {
            this.color.getItem(0).setSelected(true);
            this.nodeTypeColor = Color.black;
        } else if (col.equals(Color.orange)) {
            this.color.getItem(1).setSelected(true);
            this.nodeTypeColor = Color.orange;
        } else if (col.equals(Color.blue)) {
            this.color.getItem(2).setSelected(true);
            this.nodeTypeColor = Color.blue;
        } else if (col.equals(Color.red)) {
            this.color.getItem(3).setSelected(true);
            this.nodeTypeColor = Color.red;
        } else if (col.equals(Color.pink)) {
            this.color.getItem(4).setSelected(true);
            this.nodeTypeColor = Color.pink;
        }
        this.color.setIcon(new ColoredSquare(this.nodeTypeColor));
    }

    public int getSelectedShape() {
        return this.nodeTypeShape;
    }

    public void setSelectedShapeIndex(int indx) {
        this.shape.getItem(indx).setSelected(true);
        this.nodeTypeShape = NodeTypePopupMenu.getNodeTypeShape(this.shape.getItem(indx).getText());
        switch (this.nodeTypeShape) {
            case 51: {
                this.shape.setIcon(new RectShapeIcon(Color.black));
                break;
            }
            case 54: {
                this.shape.setIcon(new RoundRectShapeIcon(Color.black));
                break;
            }
            case 53: {
                this.shape.setIcon(new RoundRectShapeIcon(Color.black));
                break;
            }
            case 52: {
                this.shape.setIcon(new CircleShapeIcon(Color.black));
                break;
            }
        }
    }

    public void setSelectedShape(int sh) {
        switch (sh) {
            case 51: {
                this.shape.getItem(0).setSelected(true);
                this.nodeTypeShape = 51;
                this.shape.setIcon(new RectShapeIcon(Color.black));
                break;
            }
            case 54: {
                this.shape.getItem(1).setSelected(true);
                this.nodeTypeShape = 54;
                this.shape.setIcon(new RoundRectShapeIcon(Color.black));
                break;
            }
            case 53: {
                this.shape.getItem(2).setSelected(true);
                this.nodeTypeShape = 53;
                this.shape.setIcon(new OvalShapeIcon(Color.black));
                break;
            }
            case 52: {
                this.shape.getItem(3).setSelected(true);
                this.nodeTypeShape = 52;
                this.shape.setIcon(new CircleShapeIcon(Color.black));
                break;
            }
        }
    }

    public void setTypeIconLabel(JLabel l) {
        this.typeIconLabel = l;
    }

    public void setComboBox(NodeTypeComboBox box) {
        this.comboBox = box;
    }

    public boolean invoked(int x, int y) {
        return this.typeIconLabel.contains(x, y);
    }

    public void setImageFileName(String fname) {
        this.imageFileName = fname;
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public void setResourcesPath(String path) {
        this.resourcesPath = path;
    }

    public String getResourcesPath() {
        return this.resourcesPath;
    }

    public void setFrame(JFrame f) {
        this.parentAppl = f;
    }

    public void setRedefine(boolean b) {
        this.redefinecmi.setSelected(false);
        this.comboBox.setRedefineMode(false);
    }

    public static Color getTypeColor(String col) {
        if (col.equals("Red")) {
            return Color.red;
        }
        if (col.equals("Blue")) {
            return Color.blue;
        }
        if (col.equals("White")) {
            return Color.white;
        }
        if (col.equals("Yellow")) {
            return Color.yellow;
        }
        if (col.equals("Orange")) {
            return Color.orange;
        }
        if (col.equals("Pink")) {
            return Color.pink;
        }
        if (col.equals("Black")) {
            return Color.black;
        }
        return Color.red;
    }

    public static int getNodeTypeShape(String shape) {
        if (shape.equals("Rectangle")) {
            return 51;
        }
        if (shape.equals("Circle")) {
            return 52;
        }
        if (shape.equals("Oval")) {
            return 53;
        }
        return 54;
    }

    public static Icon getNodeTypeIcon(int shape, Color color) {
        Icon icon = null;
        switch (shape) {
            case 51: {
                icon = new RectShapeIcon(color);
                break;
            }
            case 54: {
                icon = new RoundRectShapeIcon(color);
                break;
            }
            case 52: {
                icon = new CircleShapeIcon(color);
                break;
            }
            case 53: {
                icon = new OvalShapeIcon(color);
                break;
            }
        }
        return icon;
    }
}

