/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.gui.AbstractOptionGUI;
import agg.gui.parser.event.StatusMessageEvent;
import agg.gui.parser.event.StatusMessageListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OptionGUI
extends JDialog
implements ActionListener,
ChangeListener {
    private Vector listener;
    private JButton closeButton;
    private JTabbedPane tabbedPane;
    private JPanel dialogPanel;
    private WindowAdapter wl;

    public OptionGUI(JFrame parent, String title, boolean modal) {
        this.setModal(modal);
        this.setTitle(title);
        this.setSize(420, 650);
        this.setLocation(200, 100);
        this.listener = new Vector();
        this.wl = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                OptionGUI.this.setVisible(false);
            }
        };
        this.addWindowListener(this.wl);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.dialogPanel = new JPanel(new BorderLayout());
        this.dialogPanel.setBackground(Color.cyan);
        this.dialogPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.dialogPanel.add((Component)this.tabbedPane, "Center");
        this.dialogPanel.add((Component)this.closeButton, "South");
        this.dialogPanel.setPreferredSize(new Dimension(420, 640));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.dialogPanel, "Center");
        this.pack();
    }

    public void addGUI(AbstractOptionGUI gui, int pos) {
        if (pos < 0) {
            this.tabbedPane.addTab(gui.getTabTitle(), gui.getIcon(), gui, gui.getTabTip());
        } else {
            this.tabbedPane.insertTab(gui.getTabTitle(), gui.getIcon(), gui, gui.getTabTip(), pos);
        }
        this.pack();
        this.validate();
    }

    public void addGUI(AbstractOptionGUI gui) {
        this.addGUI(gui, -1);
        this.pack();
    }

    public void removeGUI(AbstractOptionGUI gui) {
        this.tabbedPane.remove(gui);
        this.pack();
        this.validate();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.setVisible(false);
        }
    }

    public void addStatusMessageListener(StatusMessageListener sml) {
        this.listener.addElement(sml);
    }

    public void removeStatusMessageListener(StatusMessageListener sml) {
        this.listener.removeElement(sml);
    }

    private void fireStatusMessageEvent(StatusMessageEvent sme) {
        for (int i = 0; i < this.listener.size(); ++i) {
            ((StatusMessageListener)this.listener.elementAt(i)).newMessage(sme);
        }
    }

    private void updateAllTabs() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            ((AbstractOptionGUI)this.tabbedPane.getComponentAt(i)).update();
        }
    }

    public void stateChanged(ChangeEvent e) {
        JTabbedPane source = (JTabbedPane)e.getSource();
        ((AbstractOptionGUI)this.tabbedPane.getSelectedComponent()).update();
    }
}

