/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.gui.LoadSaveStatus;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressBar
extends Thread
implements Observer {
    private static final String TOOLTIPTEXT = "Load / Save Status";
    private JFrame statusFrame;
    private JPanel contentPanel = new JPanel();
    private JLabel label;
    private JProgressBar statusbar;
    private String statusname;
    private boolean finishAppend;
    private String finishText;
    private double oldPercentage = 0.0;

    public ProgressBar(String name) {
        super(name);
        this.contentPanel.setName("JFrameContentPane");
        this.contentPanel.setToolTipText(TOOLTIPTEXT);
        this.contentPanel.setPreferredSize(new Dimension(600, 50));
        this.contentPanel.setLayout(new BorderLayout());
        this.statusbar = new JProgressBar();
        this.statusbar.setName("ProgressBar");
        this.statusbar.setToolTipText(TOOLTIPTEXT);
        this.statusbar.setDoubleBuffered(true);
        this.statusbar.setBounds(1, 1, 600, 14);
        this.statusbar.setForeground(new Color(0, 255, 127));
        this.statusbar.setBorderPainted(true);
        this.label = new JLabel();
        this.label.setName("Statusname");
        this.label.setToolTipText(TOOLTIPTEXT);
        this.label.setText(this.statusname);
        this.label.setBounds(160, 10, 100, 15);
        this.label.setForeground(new Color(0, 0, 0));
        this.contentPanel.add((Component)new JLabel("Please wait ...   "), "North");
        this.contentPanel.add((Component)this.statusbar, "Center");
        this.contentPanel.add((Component)new JLabel("   "), "South");
        this.finishAppend = true;
        this.finishText = "";
        this.oldPercentage = 0.0;
        LoadSaveStatus.addObserver(this);
    }

    public void start() {
        LoadSaveStatus.reset();
        Thread t = new Thread(this);
        t.start();
    }

    public void quit() {
        try {
            Thread.sleep(1L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void finish() {
        LoadSaveStatus.setValue(LoadSaveStatus.getMaximum());
        if (this.finishAppend) {
            this.statusname = this.statusname + this.finishText;
        }
        this.setLabel(this.statusname);
    }

    public void setLabel(String name) {
        this.statusname = name;
        this.label.setText(this.statusname);
    }

    public void setFinishText(String text) {
        this.finishText = text;
    }

    public void setToolTipText(String tooltip) {
        this.label.setToolTipText(tooltip);
        this.statusbar.setToolTipText(tooltip);
        this.contentPanel.setToolTipText(tooltip);
    }

    public void setFinishAppend(boolean b) {
        this.finishAppend = b;
    }

    public void update(Observable o, Object arg) {
        this.statusbar.setValue(LoadSaveStatus.getValue());
        if (Math.abs(this.oldPercentage - this.statusbar.getPercentComplete()) > 0.1) {
            this.oldPercentage = this.statusbar.getPercentComplete();
            Graphics g = this.statusbar.getGraphics();
            if (g != null) {
                this.statusbar.update(g);
            }
        }
    }

    public void run() {
        this.statusbar.setMaximum(LoadSaveStatus.getMaximum());
        this.statusbar.setMinimum(LoadSaveStatus.getMinimum());
        this.statusbar.setValue(LoadSaveStatus.getValue());
        Graphics g = this.statusFrame.getGraphics();
        if (g != null) {
            this.statusFrame.update(g);
        }
    }

    public Component getContentPanel() {
        return this.contentPanel;
    }

    public void setFrame(JFrame f) {
        this.statusFrame = f;
    }
}

