/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.cons.Formula;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdRule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class RuleConstraintsDialog
extends JDialog
implements ActionListener {
    private JPanel contentPane;
    private JPanel panel;
    private JPanel formulaPanel;
    private JPanel buttonPanel;
    private JScrollPane formulaScrollPane;
    private Vector allFormulas;
    private Vector checkBox;
    private JButton allFormulaButton;
    private JButton closeButton;
    private JButton cancelButton;
    private boolean isCancelled;
    private EdGraGra gragra;
    private EdRule rule;
    private Vector resultFormulas;

    public RuleConstraintsDialog(JFrame parent, EdRule r) {
        super((Frame)parent, true);
        this.setTitle("  Formulas  ");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                RuleConstraintsDialog.this.exitForm(evt);
            }
        });
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        } else {
            this.setLocation(300, 100);
        }
        if (r != null && r.getBasisRule() != null) {
            this.rule = r;
            this.gragra = r.getGraGra();
            this.allFormulas = new Vector();
            Enumeration en = this.gragra.getBasisGraGra().getConstraints();
            while (en.hasMoreElements()) {
                Formula f = (Formula)en.nextElement();
                this.allFormulas.addElement(f);
            }
            this.checkBox = new Vector();
            this.initComponents(r.getBasisRule().getUsedFormulas());
        }
    }

    private void initComponents(Vector formulas) {
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setBackground(Color.lightGray);
        this.panel = new JPanel(new BorderLayout());
        this.panel.setBackground(Color.orange);
        this.panel.setBorder(new TitledBorder("Select Formula"));
        this.formulaPanel = new JPanel(new GridLayout(formulas.size(), 1));
        for (int i = 0; i < this.allFormulas.size(); ++i) {
            Formula f = (Formula)this.allFormulas.elementAt(i);
            JCheckBox cb = new JCheckBox(f.getName(), null, true);
            cb.addActionListener(this);
            if (formulas.contains(f)) {
                cb.setSelected(true);
            } else {
                cb.setSelected(false);
            }
            this.checkBox.addElement(cb);
            this.formulaPanel.add(cb);
        }
        this.formulaScrollPane = new JScrollPane(this.formulaPanel);
        this.formulaScrollPane.setPreferredSize(new Dimension(100, 100));
        this.allFormulaButton = new JButton();
        this.allFormulaButton.setActionCommand("allItems");
        this.allFormulaButton.setText("Select All");
        this.allFormulaButton.addActionListener(this);
        this.panel.add((Component)this.formulaScrollPane, "Center");
        this.panel.add((Component)this.allFormulaButton, "South");
        this.buttonPanel = new JPanel(new GridBagLayout());
        this.closeButton = new JButton();
        this.closeButton.setActionCommand("close");
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.isCancelled = false;
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(this);
        this.constrainBuild(this.buttonPanel, this.closeButton, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 10, 10, 5);
        this.constrainBuild(this.buttonPanel, this.cancelButton, 1, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 10);
        this.contentPane.add((Component)this.panel, "Center");
        this.contentPane.add((Component)this.buttonPanel, "South");
        this.contentPane.revalidate();
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(0);
        this.validate();
        this.pack();
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void showGUI() {
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.allFormulaButton) {
            for (int j = 0; j < this.checkBox.size(); ++j) {
                JCheckBox cb = (JCheckBox)this.checkBox.elementAt(j);
                cb.setSelected(true);
            }
        } else if (source == this.closeButton) {
            this.resultFormulas = new Vector();
            for (int j = 0; j < this.checkBox.size(); ++j) {
                JCheckBox cb = (JCheckBox)this.checkBox.elementAt(j);
                if (!cb.isSelected()) continue;
                this.resultFormulas.addElement((Formula)this.allFormulas.elementAt(j));
            }
            this.setVisible(false);
            this.dispose();
        } else if (source == this.cancelButton) {
            this.isCancelled = true;
            this.setVisible(false);
            this.dispose();
        }
    }

    public void setRule(EdRule rule) {
        this.rule = rule;
        this.gragra = rule.getGraGra();
    }

    public Vector getFormulas() {
        return this.resultFormulas;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }
}

