/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.attribute.gui.AttrTopEditor;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdRule;
import agg.editor.impl.GraphPanel;
import agg.gui.EditPopupMenu;
import agg.gui.EditSelPopupMenu;
import agg.gui.GraGraEditor;
import agg.gui.GraphEditor;
import agg.gui.GraphicsExportJPEG;
import agg.gui.ModePopupMenu;
import agg.xt_basis.Arc;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class RuleEditor
extends JPanel
implements MouseListener,
MouseMotionListener {
    private Toolkit tk;
    private JFrame applFrame;
    private GraGraEditor gragraEditor;
    private GraphEditor graphEditor;
    private AttrTopEditor attrEditor;
    private JLabel title;
    private JLabel titleNAC;
    private String ruleName;
    private String gragraName;
    private String conclusionName;
    private String atomicName;
    private JSplitPane splitPane;
    private int nacDividerLocation;
    private JSplitPane ruleSplitPane;
    private int ruleDividerLocation;
    private JPanel panelRule;
    private JPanel panelNAC;
    private Hashtable dividerLocationSet;
    private GraphPanel leftPanel;
    private GraphPanel rightPanel;
    private GraphPanel nacPanel;
    private GraphPanel activePanel;
    private String lastText;
    private String msg = "";
    private EdGraGra eGra;
    private EdRule eRule;
    private EdNAC eNAC;
    private EdGraph sourceOfCopy;
    private boolean isPopupTrigger = false;
    private ModePopupMenu modePopupMenu;
    private EditPopupMenu editPopupMenu;
    private EditSelPopupMenu editSelPopupMenu;
    private boolean isEditPopupMenu = false;
    private boolean isEditSelPopupMenu = false;
    private EdGraphObject leftObj;
    private EdGraphObject rightObj;
    private EdGraphObject nacObj;
    private EdGraphObject graphObj;
    private int lastEditMode = 0;
    private Cursor lastEditModeCursor;
    private boolean synchronMoveOfMapObjects = true;
    private boolean mapping = false;
    private boolean mouseListenerFromGraphEditorAdded = false;
    private GraphicsExportJPEG exportJPEG;
    private JButton exportJPEGButton;
    private JPanel mainPanel = this;

    public RuleEditor(GraGraEditor anEditor) {
        super(new BorderLayout());
        this.leftPanel = new GraphPanel();
        JPanel lPanel = new JPanel(new BorderLayout());
        lPanel.setPreferredSize(new Dimension(250, 150));
        lPanel.add((Component)this.leftPanel, "Center");
        this.rightPanel = new GraphPanel();
        JPanel rPanel = new JPanel(new BorderLayout());
        rPanel.setPreferredSize(new Dimension(250, 150));
        rPanel.add((Component)this.rightPanel, "Center");
        this.ruleSplitPane = new JSplitPane(1, lPanel, rPanel);
        this.ruleSplitPane.setContinuousLayout(true);
        this.ruleSplitPane.setOneTouchExpandable(true);
        this.ruleDividerLocation = 250;
        this.ruleSplitPane.setDividerLocation(this.ruleDividerLocation);
        this.panelRule = new JPanel(new BorderLayout());
        this.panelRule.setPreferredSize(new Dimension(500, 150));
        this.title = new JLabel("    ");
        this.exportJPEGButton = this.createExportJPEGButton();
        JPanel rtitlePanel = new JPanel(new BorderLayout());
        rtitlePanel.add((Component)this.title, "West");
        rtitlePanel.add((Component)this.exportJPEGButton, "East");
        this.panelRule.add((Component)rtitlePanel, "North");
        this.panelRule.add((Component)this.ruleSplitPane, "Center");
        this.nacPanel = new GraphPanel();
        this.panelNAC = new JPanel(new BorderLayout());
        this.panelNAC.setPreferredSize(new Dimension(150, 150));
        this.titleNAC = new JLabel("");
        this.panelNAC.add((Component)this.titleNAC, "North");
        this.panelNAC.add((Component)this.nacPanel, "Center");
        this.splitPane = new JSplitPane(1, this.panelNAC, this.panelRule);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(0);
        this.nacDividerLocation = 0;
        this.dividerLocationSet = new Hashtable(0);
        this.add((Component)this.splitPane, "Center");
        this.gragraEditor = anEditor;
        if (this.gragraEditor != null && this.gragraEditor.getGraphEditor() instanceof GraphEditor) {
            this.graphEditor = this.gragraEditor.getGraphEditor();
        }
        this.leftPanel.getCanvas().addMouseListener(this);
        this.rightPanel.getCanvas().addMouseListener(this);
        this.nacPanel.getCanvas().addMouseListener(this);
        this.leftPanel.getCanvas().addMouseMotionListener(this);
        this.rightPanel.getCanvas().addMouseMotionListener(this);
        this.nacPanel.getCanvas().addMouseMotionListener(this);
        this.setToolkit();
    }

    private JButton createExportJPEGButton() {
        ImageIcon image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/print.gif"));
        if (image != null) {
            JButton b = new JButton(image);
            b.setToolTipText("Export Rule JPEG");
            b.setMargin(new Insets(-5, 0, -5, 0));
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (RuleEditor.this.exportJPEG != null) {
                        RuleEditor.this.exportJPEG.save(RuleEditor.this.mainPanel);
                    }
                }
            });
            b.setEnabled(false);
            return b;
        }
        return null;
    }

    public void mouseEntered(MouseEvent e) {
        Object source = e.getSource();
        if (this.applFrame == null) {
            return;
        }
        if (source == this.leftPanel.getCanvas()) {
            this.applFrame.setCursor(this.leftPanel.getEditCursor());
        } else if (source == this.rightPanel.getCanvas()) {
            this.applFrame.setCursor(this.leftPanel.getEditCursor());
        } else if (source == this.nacPanel.getCanvas()) {
            this.applFrame.setCursor(this.leftPanel.getEditCursor());
        } else if (source == this.graphEditor.getGraphPanel().getCanvas()) {
            this.applFrame.setCursor(this.leftPanel.getEditCursor());
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(0));
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (this.isEditPopupMenu && this.editPopupMenu.isMapping() || this.isEditSelPopupMenu && this.editSelPopupMenu.isMapping()) {
                this.resetEditModeAfterMapping();
            }
            if (this.eGra != null && this.eGra.getGraph().isEditable()) {
                this.showPopupMenu(e);
            }
            return;
        }
        if (this.activePanel != null) {
            switch (this.activePanel.getEditMode()) {
                case 113: {
                    this.msg = "You have just picked the source of an edge. Click on a node to get the target.";
                    break;
                }
                case 11: {
                    break;
                }
                case 13: {
                    if (this.applFrame == null) break;
                    this.applFrame.setCursor(new Cursor(13));
                    break;
                }
                case 151: {
                    if (this.applFrame == null) break;
                    this.applFrame.setCursor(new Cursor(1));
                    break;
                }
                case 15: {
                    if (this.activePanel.getGraph().getMsg().length() != 0) {
                        this.msg = this.leftPanel.getGraph().getMsg();
                    }
                    if (this.eRule == null) break;
                    if (this.activePanel.getLastEditMode() != 15) {
                        if (this.gragraEditor != null) {
                            this.gragraEditor.setEditMode(this.activePanel.getLastEditMode());
                            this.gragraEditor.resetAfterCopy();
                            if (this.sourceOfCopy != null && !this.activePanel.getGraph().equals(this.sourceOfCopy)) {
                                this.sourceOfCopy.eraseSelected(this.gragraEditor.getPanelOfGraph(this.sourceOfCopy).getCanvas().getGraphics(), this.gragraEditor.getPanelOfGraph(this.sourceOfCopy).getCanvas().getScale(), true);
                                this.sourceOfCopy.deselectAll();
                            }
                            this.gragraEditor.setMsg(this.getMsg());
                        } else {
                            this.setEditMode(this.activePanel.getLastEditMode());
                            this.eRule.getLeft().setGraphToCopy(null);
                            this.eRule.getRight().setGraphToCopy(null);
                            if (this.nacPanel.getGraph() != null) {
                                this.nacPanel.getGraph().setGraphToCopy(null);
                            }
                        }
                        if (this.applFrame != null) {
                            this.applFrame.setCursor(this.activePanel.getLastEditCursor());
                        }
                    } else {
                        if (this.gragraEditor != null) {
                            this.gragraEditor.setEditMode(this.activePanel.getLastEditMode());
                            this.gragraEditor.resetAfterCopy();
                            if (this.sourceOfCopy != null && !this.activePanel.getGraph().equals(this.sourceOfCopy)) {
                                this.sourceOfCopy.eraseSelected(this.gragraEditor.getPanelOfGraph(this.sourceOfCopy).getCanvas().getGraphics(), this.gragraEditor.getPanelOfGraph(this.sourceOfCopy).getCanvas().getScale(), true);
                                this.sourceOfCopy.deselectAll();
                            }
                            this.gragraEditor.setMsg(this.getMsg());
                        } else {
                            this.setEditMode(11);
                            this.eRule.getLeft().setGraphToCopy(null);
                            this.eRule.getRight().setGraphToCopy(null);
                            if (this.nacPanel.getGraph() != null) {
                                this.nacPanel.getGraph().setGraphToCopy(null);
                            }
                        }
                        if (this.applFrame != null) {
                            this.applFrame.setCursor(new Cursor(0));
                        }
                    }
                    this.sourceOfCopy = null;
                    break;
                }
                default: {
                    if (this.applFrame == null) break;
                    this.applFrame.setCursor(this.activePanel.getEditCursor());
                }
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        Object source = e.getSource();
        this.activePanel = this.myActivePanel(source);
        int x = e.getX();
        int y = e.getY();
        if (e.isPopupTrigger()) {
            if (this.isEditPopupMenu && this.editPopupMenu.isMapping() || this.isEditSelPopupMenu && this.editSelPopupMenu.isMapping()) {
                this.resetEditModeAfterMapping();
            }
            if (this.eGra != null && this.eGra.getGraph().isEditable()) {
                this.showPopupMenu(e);
            }
        } else if (SwingUtilities.isMiddleMouseButton(e)) {
            if (this.activePanel != null && this.activePanel.getCanvas().getPickedObject(e.getX(), e.getY(), this.getGraphics().getFontMetrics()) != null && this.applFrame != null) {
                this.applFrame.setCursor(new Cursor(13));
            }
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            if (this.activePanel.getEditMode() != 13 && this.activePanel.getEditMode() != 151 && this.applFrame != null) {
                this.applFrame.setCursor(new Cursor(0));
            }
            EdGraph eg = null;
            switch (this.leftPanel.getEditMode()) {
                case 13: {
                    EdArc ea;
                    EdGraphObject ego;
                    eg = this.activePanel.getGraph();
                    if (eg == null || (ego = eg.getPicked(x, y)) == null || !ego.isArc() || (ea = (EdArc)ego) == null || ea.isLine() || ea.getAnchorID() != 1) break;
                    if (this.applFrame != null) {
                        this.applFrame.setCursor(new Cursor(6));
                        break;
                    }
                    if (ea.getAnchorID() != 2) break;
                    if (this.applFrame != null) {
                        this.applFrame.setCursor(new Cursor(7));
                        break;
                    }
                    if (ea.getAnchorID() != 3) break;
                    if (this.applFrame != null) {
                        this.applFrame.setCursor(new Cursor(5));
                        break;
                    }
                    if (ea.getAnchorID() != 4) break;
                    if (this.applFrame != null) {
                        this.applFrame.setCursor(new Cursor(4));
                        break;
                    }
                    if (ea.getAnchorID() != 0 || this.applFrame == null) break;
                    this.applFrame.setCursor(new Cursor(13));
                    break;
                }
                case 114: {
                    eg = this.activePanel.getGraph();
                    if (eg == null) break;
                    EdGraphObject ego = eg.getPicked(x, y);
                    if (ego != null) {
                        this.getAttrEditor(ego);
                        this.getAttrEditor().enableContextEditor(true);
                        if (this.gragraEditor == null) break;
                        this.gragraEditor.setAttrEditorOnBottom(this.getAttrEditor().getComponent());
                        break;
                    }
                    this.errSound();
                    break;
                }
                case 31: {
                    if (this.eRule == null) break;
                    if (source == this.leftPanel.getCanvas()) {
                        this.leftObj = this.leftPanel.getGraph().getPicked(x, y);
                        if (this.leftObj == null) {
                            this.errSound();
                            this.rightObj = null;
                        }
                    } else if (source == this.rightPanel.getCanvas()) {
                        if (this.leftObj != null) {
                            this.rightObj = this.rightPanel.getGraph().getPicked(x, y);
                            if (this.rightObj == null) {
                                this.errSound();
                            }
                        } else {
                            this.errSound();
                            this.rightObj = null;
                        }
                    }
                    if (this.leftObj == null || this.rightObj == null) break;
                    if (this.applFrame != null) {
                        this.applFrame.setCursor(new Cursor(3));
                    }
                    this.eRule.interactRule(this.leftObj, this.rightObj);
                    if (this.eRule.isBadMapping()) {
                        this.msg = this.eRule.getMsg();
                        this.errSound();
                    } else {
                        this.leftPanel.updateGraphics();
                        this.rightPanel.updateGraphics();
                    }
                    this.leftObj = null;
                    this.rightObj = null;
                    if (this.applFrame == null) break;
                    this.applFrame.setCursor(this.rightPanel.getEditCursor());
                    break;
                }
                case 32: {
                    EdGraphObject lgo;
                    if (this.eRule == null || source != this.leftPanel.getCanvas() || (lgo = this.leftPanel.getGraph().getPicked(x, y)) == null) break;
                    EdGraphObject rgo = this.eRule.getRight().findGraphObject(this.eRule.getBasisRule().getImage(lgo.getBasisObject()));
                    this.eRule.removeRuleMapping(lgo);
                    if (rgo == null) break;
                    this.drawGraphic(null, this.leftPanel, true, true);
                    this.drawGraphic(null, this.rightPanel, true, true);
                    break;
                }
                case 81: {
                    if (this.eRule == null || this.eNAC == null) break;
                    if (source == this.leftPanel.getCanvas()) {
                        this.leftObj = this.leftPanel.getGraph().getPicked(x, y);
                        if (this.leftObj == null) {
                            this.errSound();
                            this.nacObj = null;
                        }
                    } else if (source == this.nacPanel.getCanvas()) {
                        if (this.leftObj != null) {
                            this.nacObj = this.nacPanel.getGraph().getPicked(x, y);
                            if (this.nacObj == null) {
                                this.errSound();
                            }
                        } else {
                            this.errSound();
                            this.nacObj = null;
                        }
                    }
                    if (this.leftObj == null || this.nacObj == null) break;
                    if (this.applFrame != null) {
                        this.applFrame.setCursor(new Cursor(3));
                    }
                    this.eRule.interactNAC(this.leftObj, this.nacObj, this.eNAC.getMorphism());
                    if (this.eRule.isBadMapping()) {
                        this.msg = this.eRule.getMsg();
                        this.errSound();
                    } else {
                        this.leftPanel.updateGraphics();
                        this.nacPanel.updateGraphics();
                    }
                    this.leftObj = null;
                    this.nacObj = null;
                    if (this.applFrame == null) break;
                    this.applFrame.setCursor(this.nacPanel.getEditCursor());
                    break;
                }
                case 82: {
                    EdGraphObject lgo;
                    if (this.eRule == null || this.eNAC == null || source != this.leftPanel.getCanvas() || (lgo = this.leftPanel.getGraph().getPicked(x, y)) == null) break;
                    EdGraphObject ngo = this.eNAC.findGraphObject(this.eNAC.getMorphism().getImage(lgo.getBasisObject()));
                    this.eRule.removeNACMapping(lgo, this.eNAC.getMorphism());
                    if (ngo == null) break;
                    this.drawGraphic(null, this.leftPanel, true, true);
                    this.drawGraphic(null, this.nacPanel, true, true);
                    break;
                }
                case 42: {
                    if (this.eRule == null) break;
                    if (source == this.leftPanel.getCanvas()) {
                        this.leftObj = this.leftPanel.getGraph().getPicked(x, y);
                        if (this.leftObj == null) {
                            this.errSound();
                            this.graphObj = null;
                        }
                    } else if (source == this.graphEditor.getGraphPanel().getCanvas()) {
                        if (this.leftObj != null) {
                            this.graphObj = this.graphEditor.getGraph().getPicked(x, y);
                            if (this.graphObj == null) {
                                this.errSound();
                            }
                        } else {
                            this.errSound();
                            this.graphObj = null;
                        }
                    }
                    if (this.leftObj == null || this.graphObj == null) break;
                    if (this.applFrame != null) {
                        this.applFrame.setCursor(new Cursor(3));
                    }
                    this.eRule.interactMatch(this.leftObj, this.graphObj);
                    if (this.eRule.isBadMapping()) {
                        this.msg = this.eRule.getMsg();
                        this.errSound();
                        JOptionPane.showMessageDialog(null, this.msg, "Cannot map", 0);
                    } else {
                        this.graphEditor.getGraph().update();
                        this.leftPanel.updateGraphics();
                        this.graphEditor.getGraphPanel().updateGraphics();
                    }
                    this.leftObj = null;
                    this.graphObj = null;
                    if (this.applFrame == null) break;
                    this.applFrame.setCursor(this.graphEditor.getGraphPanel().getEditCursor());
                    break;
                }
                case 43: {
                    EdGraphObject lgo;
                    if (this.eRule == null || source != this.leftPanel.getCanvas() || (lgo = this.leftPanel.getGraph().getPicked(x, y)) == null) break;
                    EdGraphObject ggo = this.graphEditor.getGraph().findGraphObject(this.eRule.getMatch().getImage(lgo.getBasisObject()));
                    this.eRule.removeMatchMapping(lgo);
                    this.graphEditor.getGraph().update();
                    if (ggo == null) break;
                    this.drawGraphic(null, this.leftPanel, true, true);
                    this.drawGraphic(null, this.graphEditor.getGraphPanel(), true, true);
                    break;
                }
                case 115: {
                    if (this.eRule == null) break;
                    if (this.isEditPopupMenu && this.editPopupMenu.isMapping()) {
                        this.leftObj = this.editPopupMenu.getPickedObj();
                    }
                    if (source == this.leftPanel.getCanvas()) {
                        if (this.isEditPopupMenu && this.editPopupMenu.isMapping()) {
                            this.mapping = false;
                            this.leftObj = null;
                        } else {
                            this.leftObj = this.leftPanel.getGraph().getPicked(x, y);
                            if (this.leftObj == null) {
                                this.mapping = false;
                            } else if (this.leftObj.isSelected()) {
                                this.setEditMode(117);
                                this.graphEditor.setEditMode(117);
                            }
                        }
                        if (!this.isEditPopupMenu || !this.editPopupMenu.isMapping() || this.mapping) break;
                        this.resetEditModeAfterMapping();
                        break;
                    }
                    if (source == this.rightPanel.getCanvas() && this.rightPanel.getEditMode() == 115) {
                        this.rightObj = this.rightPanel.getGraph().getPicked(x, y);
                        if (this.leftObj != null && this.rightObj != null) {
                            if (this.isEditPopupMenu && this.editPopupMenu.isMapping()) {
                                this.mapping = true;
                            }
                            this.eRule.interactRule(this.leftObj, this.rightObj);
                            if (this.eRule.isBadMapping()) {
                                this.msg = this.eRule.getMsg();
                                this.errSound();
                            } else {
                                this.leftPanel.updateGraphics();
                                this.rightPanel.updateGraphics();
                            }
                        } else {
                            this.mapping = false;
                        }
                        if (!this.isEditPopupMenu || !this.editPopupMenu.isMapping() || this.mapping) break;
                        this.resetEditModeAfterMapping();
                        break;
                    }
                    if (source == this.nacPanel.getCanvas() && this.nacPanel.getEditMode() == 115 && this.nacPanel.getGraph() != null) {
                        this.nacObj = this.nacPanel.getGraph().getPicked(x, y);
                        if (this.leftObj != null && this.nacObj != null) {
                            if (this.isEditPopupMenu && this.editPopupMenu.isMapping()) {
                                this.mapping = true;
                            }
                            this.eRule.interactNAC(this.leftObj, this.nacObj, this.eNAC.getMorphism());
                            if (this.eRule.isBadMapping()) {
                                this.msg = this.eRule.getMsg();
                                this.errSound();
                            } else {
                                this.leftPanel.updateGraphics();
                                this.nacPanel.updateGraphics();
                            }
                        } else {
                            this.mapping = false;
                        }
                        if (!this.isEditPopupMenu || !this.editPopupMenu.isMapping() || this.mapping) break;
                        this.resetEditModeAfterMapping();
                        break;
                    }
                    if (source != this.graphEditor.getGraphPanel().getCanvas() || this.graphEditor.getGraphPanel().getEditMode() != 115) break;
                    this.graphObj = this.graphEditor.getGraph().getPicked(x, y);
                    if (this.leftObj != null && this.graphObj != null) {
                        if (this.isEditPopupMenu && this.editPopupMenu.isMapping()) {
                            this.mapping = true;
                        }
                        if (!(this.eRule instanceof EdAtomic)) {
                            if (this.eRule.getMatch() == null) {
                                this.eRule.setMatch(this.eRule.getGraGra().getBasisGraGra().createMatch(this.eRule.getBasisRule()));
                            }
                            if (this.gragraEditor != null) {
                                this.eRule.getMatch().setCompletionStrategy(this.gragraEditor.getMorphCompletionStrategy());
                            }
                            this.eRule.interactMatch(this.leftObj, this.graphObj);
                            if (this.eRule.isBadMapping()) {
                                this.msg = this.eRule.getMsg();
                                this.errSound();
                                JOptionPane.showMessageDialog(null, this.msg, "Cannot map", 0);
                            } else {
                                this.graphEditor.getGraph().update();
                                this.leftPanel.updateGraphics();
                                this.graphEditor.getGraphPanel().updateGraphics();
                            }
                        }
                    } else {
                        this.mapping = false;
                    }
                    if (!this.isEditPopupMenu || !this.editPopupMenu.isMapping() || this.mapping) break;
                    this.resetEditModeAfterMapping();
                    break;
                }
                case 116: {
                    if (this.eRule == null) break;
                    if (source == this.leftPanel.getCanvas()) {
                        this.leftObj = this.leftPanel.getGraph().getPicked(x, y);
                        if (this.leftObj == null) {
                            this.errSound();
                        } else if (this.leftObj.isSelected()) {
                            for (int i = 0; i < this.eRule.getLeft().getSelectedObjs().size(); ++i) {
                                EdGraphObject lgo = (EdGraphObject)this.eRule.getLeft().getSelectedObjs().elementAt(i);
                                EdGraphObject rgo = this.eRule.getRight().findGraphObject(this.eRule.getBasisRule().getImage(lgo.getBasisObject()));
                                this.eRule.removeRuleMapping(lgo);
                                this.leftPanel.updateGraphics();
                                if (rgo != null) {
                                    this.rightPanel.updateGraphics();
                                }
                                if (this.eNAC != null) {
                                    EdGraphObject ngo = this.eNAC.findGraphObject(this.eNAC.getMorphism().getImage(lgo.getBasisObject()));
                                    this.eRule.removeNACMapping(lgo, this.eNAC.getMorphism());
                                    if (ngo != null) {
                                        this.nacPanel.updateGraphics();
                                    }
                                }
                                if (this.eRule instanceof EdAtomic || this.eRule.getMatch() == null) continue;
                                EdGraphObject ggo = this.graphEditor.getGraph().findGraphObject(this.eRule.getMatch().getImage(lgo.getBasisObject()));
                                this.eRule.removeMatchMapping(lgo);
                                this.graphEditor.getGraph().update();
                                if (ggo == null) continue;
                                this.graphEditor.getGraphPanel().updateGraphics();
                            }
                        } else {
                            EdGraphObject rgo = this.eRule.getRight().findGraphObject(this.eRule.getBasisRule().getImage(this.leftObj.getBasisObject()));
                            this.eRule.removeRuleMapping(this.leftObj);
                            if (rgo != null) {
                                this.rightPanel.updateGraphics();
                            }
                            if (this.eNAC != null) {
                                EdGraphObject ngo = this.eNAC.findGraphObject(this.eNAC.getMorphism().getImage(this.leftObj.getBasisObject()));
                                this.eRule.removeNACMapping(this.leftObj, this.eNAC.getMorphism());
                                if (ngo != null) {
                                    this.nacPanel.updateGraphics();
                                }
                            }
                            if (!(this.eRule instanceof EdAtomic) && this.eRule.getMatch() != null) {
                                EdGraphObject ggo = this.graphEditor.getGraph().findGraphObject(this.eRule.getMatch().getImage(this.leftObj.getBasisObject()));
                                this.eRule.removeMatchMapping(this.leftObj);
                                this.graphEditor.getGraph().update();
                                if (ggo != null) {
                                    this.graphEditor.getGraphPanel().updateGraphics();
                                }
                            }
                            this.leftPanel.updateGraphics();
                        }
                        this.leftObj = null;
                        break;
                    }
                    if (source == this.rightPanel.getCanvas()) {
                        this.rightObj = this.rightPanel.getGraph().getPicked(x, y);
                        if (this.rightObj == null) {
                            this.errSound();
                        } else if (this.rightObj.isSelected()) {
                            for (int i = 0; i < this.eRule.getRight().getSelectedObjs().size(); ++i) {
                                EdGraphObject imageObj = (EdGraphObject)this.eRule.getRight().getSelectedObjs().elementAt(i);
                                this.eRule.removeMapping(imageObj, this.eRule.getBasisRule());
                            }
                            this.drawGraphic(null, this.rightPanel, true, true);
                            this.drawGraphic(null, this.leftPanel, true, true);
                        } else {
                            this.eRule.removeMapping(this.rightObj, this.eRule.getBasisRule());
                            this.drawGraphic(null, this.rightPanel, true, true);
                            this.drawGraphic(null, this.leftPanel, true, true);
                        }
                        this.rightObj = null;
                        break;
                    }
                    if (source == this.nacPanel.getCanvas()) {
                        this.nacObj = this.nacPanel.getGraph().getPicked(x, y);
                        if (this.nacObj == null) {
                            this.errSound();
                        } else if (this.nacObj.isSelected()) {
                            for (int i = 0; i < this.eNAC.getSelectedObjs().size(); ++i) {
                                EdGraphObject imageObj = (EdGraphObject)this.eNAC.getSelectedObjs().elementAt(i);
                                this.eRule.removeMapping(imageObj, this.eNAC.getMorphism());
                            }
                            this.drawGraphic(null, this.nacPanel, true, true);
                            this.drawGraphic(null, this.leftPanel, true, true);
                        } else {
                            this.eRule.removeMapping(this.nacObj, this.eNAC.getMorphism());
                            this.drawGraphic(null, this.nacPanel, true, true);
                            this.drawGraphic(null, this.leftPanel, true, true);
                        }
                        this.nacObj = null;
                        break;
                    }
                    if (source != this.graphEditor.getGraphPanel().getCanvas()) break;
                    if (!(this.eRule instanceof EdAtomic)) {
                        this.graphObj = this.graphEditor.getGraph().getPicked(x, y);
                        if (this.graphObj == null) {
                            this.errSound();
                        } else if (this.graphObj.isSelected()) {
                            for (int i = 0; i < this.graphEditor.getGraph().getSelectedObjs().size(); ++i) {
                                EdGraphObject imageObj = (EdGraphObject)this.graphEditor.getGraph().getSelectedObjs().elementAt(i);
                                this.eRule.removeMapping(imageObj, this.eRule.getMatch());
                            }
                            this.drawGraphic(null, this.graphEditor.getGraphPanel(), true, true);
                            this.drawGraphic(null, this.leftPanel, true, true);
                        } else {
                            this.eRule.removeMapping(this.graphObj, this.eRule.getMatch());
                            this.drawGraphic(null, this.graphEditor.getGraphPanel(), true, true);
                            this.drawGraphic(null, this.leftPanel, true, true);
                        }
                    }
                    this.graphObj = null;
                    break;
                }
                case 1161: {
                    EdGraphObject ego;
                    if (this.eRule == null || source != this.leftPanel.getCanvas() || (ego = this.leftPanel.getGraph().getPicked(x, y)) == null) break;
                    this.eRule.removeRuleMapping(ego);
                    if (this.eNAC != null) {
                        this.eRule.removeNACMapping(ego, this.eNAC.getMorphism());
                    }
                    this.eRule.removeMatchMapping(ego);
                    this.eRule.update();
                    this.drawGraphic(null, this.leftPanel, true, true);
                    this.drawGraphic(null, this.rightPanel, true, true);
                    this.drawGraphic(null, this.nacPanel, true, true);
                    this.drawGraphic(null, this.graphEditor.getGraphPanel(), true, true);
                    break;
                }
                case 1181: {
                    if (this.eRule == null || source != this.leftPanel.getCanvas() || this.leftPanel.getGraph().getPicked(x, y) == null) break;
                    for (int i = 0; i < this.eRule.getLeft().getSelectedObjs().size(); ++i) {
                        this.leftObj = (EdGraphObject)this.eRule.getLeft().getSelectedObjs().elementAt(i);
                        this.eRule.removeRuleMapping(this.leftObj);
                        if (this.eNAC != null) {
                            this.eRule.removeNACMapping(this.leftObj, this.eNAC.getMorphism());
                        }
                        this.eRule.removeMatchMapping(this.leftObj);
                    }
                    this.eRule.update();
                    this.drawGraphic(null, this.leftPanel, true, true);
                    this.drawGraphic(null, this.rightPanel, true, true);
                    this.drawGraphic(null, this.nacPanel, true, true);
                    this.drawGraphic(null, this.graphEditor.getGraphPanel(), true, true);
                    break;
                }
                case 117: {
                    this.leftObj = null;
                    if (source == this.leftPanel.getCanvas()) {
                        if (this.isEditSelPopupMenu && this.editSelPopupMenu.isMapping()) break;
                        this.leftObj = this.leftPanel.getGraph().getPicked(x, y);
                        if (this.leftObj == null || this.leftObj.isSelected()) break;
                        this.setEditMode(115);
                        this.graphEditor.setEditMode(115);
                        break;
                    }
                    if (source == this.rightPanel.getCanvas()) {
                        this.rightObj = this.rightPanel.getGraph().getPicked(x, y);
                        if (this.rightObj != null) {
                            if (this.isEditSelPopupMenu && this.editSelPopupMenu.isMapping()) {
                                this.mapping = true;
                            }
                            for (int i = 0; i < this.eRule.getLeft().getSelectedObjs().size(); ++i) {
                                this.leftObj = (EdGraphObject)this.eRule.getLeft().getSelectedObjs().elementAt(i);
                                this.eRule.interactRule(this.leftObj, this.rightObj);
                            }
                            if (this.eRule.isBadMapping()) {
                                this.msg = this.eRule.getMsg();
                                this.errSound();
                            } else {
                                this.drawGraphic(null, this.leftPanel, true, true);
                                this.drawGraphic(null, this.rightPanel, true, true);
                            }
                            this.rightObj = null;
                        } else {
                            this.mapping = false;
                            this.leftObj = null;
                        }
                        if (this.isEditSelPopupMenu && this.editSelPopupMenu.isMapping() && !this.mapping) {
                            this.resetEditModeAfterMapping();
                            break;
                        }
                        if (this.isEditSelPopupMenu || this.mapping) break;
                        break;
                    }
                    if (source == this.nacPanel.getCanvas() && this.eNAC != null) {
                        this.nacObj = this.nacPanel.getGraph().getPicked(x, y);
                        if (this.nacObj != null) {
                            if (this.isEditSelPopupMenu && this.editSelPopupMenu.isMapping()) {
                                this.mapping = true;
                            }
                            for (int i = 0; i < this.eRule.getLeft().getSelectedObjs().size(); ++i) {
                                this.leftObj = (EdGraphObject)this.eRule.getLeft().getSelectedObjs().elementAt(i);
                                this.eRule.interactNAC(this.leftObj, this.nacObj, this.eNAC.getMorphism());
                            }
                            if (this.eRule.isBadMapping()) {
                                this.msg = this.eRule.getMsg();
                                this.errSound();
                            } else {
                                this.drawGraphic(null, this.leftPanel, true, true);
                                this.drawGraphic(null, this.nacPanel, true, true);
                            }
                            this.nacObj = null;
                        } else {
                            this.mapping = false;
                            this.leftObj = null;
                        }
                        if (this.isEditSelPopupMenu && this.editSelPopupMenu.isMapping() && !this.mapping) {
                            this.resetEditModeAfterMapping();
                            break;
                        }
                        if (this.isEditSelPopupMenu || this.mapping) break;
                        break;
                    }
                    if (source != this.graphEditor.getGraphPanel().getCanvas()) break;
                    this.graphObj = this.graphEditor.getGraphPanel().getGraph().getPicked(x, y);
                    if (this.graphObj != null) {
                        if (this.isEditSelPopupMenu && this.editSelPopupMenu.isMapping()) {
                            this.mapping = true;
                        }
                        for (int i = 0; i < this.eRule.getLeft().getSelectedObjs().size(); ++i) {
                            this.leftObj = (EdGraphObject)this.eRule.getLeft().getSelectedObjs().elementAt(i);
                            if (this.eRule.getMatch() == null) {
                                this.eRule.setMatch(this.eRule.getGraGra().getBasisGraGra().createMatch(this.eRule.getBasisRule()));
                            }
                            if (this.gragraEditor != null) {
                                this.eRule.getMatch().setCompletionStrategy(this.gragraEditor.getMorphCompletionStrategy());
                            }
                            this.eRule.interactMatch(this.leftObj, this.graphObj);
                        }
                        if (this.eRule.isBadMapping()) {
                            this.msg = this.eRule.getMsg();
                            this.errSound();
                            JOptionPane.showMessageDialog(null, this.msg, "Cannot map", 0);
                        } else {
                            this.leftPanel.updateGraphics();
                            this.graphEditor.getGraphPanel().updateGraphics();
                        }
                        this.graphObj = null;
                    } else {
                        this.mapping = false;
                        this.leftObj = null;
                    }
                    if (this.isEditSelPopupMenu && this.editSelPopupMenu.isMapping() && !this.mapping) {
                        this.resetEditModeAfterMapping();
                        break;
                    }
                    if (this.isEditSelPopupMenu || this.mapping) break;
                    break;
                }
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.eRule == null) {
            return;
        }
        if (SwingUtilities.isMiddleMouseButton(e) || this.leftPanel.getEditMode() == 13) {
            if (!this.synchronMoveOfMapObjects) {
                return;
            }
            EdGraphObject go = null;
            if (this.activePanel.getGraph() != null) {
                go = this.activePanel.getCanvas().getDraggedObject();
            }
            if (go == null) {
                return;
            }
            Dimension d = this.activePanel.getCanvas().getDraggedDimension();
            Vector<EdGraphObject> v = null;
            if (go.isSelected()) {
                v = this.activePanel.getGraph().getSelectedObjs();
            } else {
                v = new Vector<EdGraphObject>(1);
                v.add(go);
            }
            if (this.activePanel == this.leftPanel) {
                if (!v.isEmpty()) {
                    Vector images = this.getImages(this.eRule.getRight(), this.eRule.getBasisRule(), v);
                    if (!images.isEmpty()) {
                        this.eRule.getRight().moveObjects(images, d.width, d.height);
                        this.rightPanel.updateGraphics();
                    }
                    if (this.eNAC != null && !(images = this.getImages(this.eNAC, this.eNAC.getMorphism(), v)).isEmpty()) {
                        this.eNAC.moveObjects(images, d.width, d.height);
                        this.nacPanel.updateGraphics();
                    }
                }
            } else if (this.activePanel == this.rightPanel) {
                if (!v.isEmpty()) {
                    Vector imagesNAC;
                    Vector invImages = this.getInverseImages(this.eRule.getLeft(), this.eRule.getBasisRule(), v);
                    if (!invImages.isEmpty()) {
                        this.eRule.getLeft().moveObjects(invImages, d.width, d.height);
                        this.leftPanel.updateGraphics();
                    }
                    if (this.eNAC != null && !(imagesNAC = this.getImages(this.eNAC, this.eNAC.getMorphism(), invImages)).isEmpty()) {
                        this.eNAC.moveObjects(imagesNAC, d.width, d.height);
                        this.nacPanel.updateGraphics();
                    }
                }
            } else if (this.activePanel == this.nacPanel && !v.isEmpty()) {
                Vector images;
                Vector invImages = this.getInverseImages(this.eRule.getLeft(), this.eNAC.getMorphism(), v);
                if (!invImages.isEmpty()) {
                    this.eRule.getLeft().moveObjects(invImages, d.width, d.height);
                    this.leftPanel.updateGraphics();
                }
                if (!(images = this.getImages(this.eRule.getRight(), this.eRule.getBasisRule(), invImages)).isEmpty()) {
                    this.eRule.getRight().moveObjects(images, d.width, d.height);
                    this.rightPanel.updateGraphics();
                }
            }
        }
    }

    public void setSynchronMoveOfMapObjects(boolean b) {
        this.synchronMoveOfMapObjects = b;
    }

    private Vector getImages(EdGraph imageGraph, OrdinaryMorphism morph, Vector objs) {
        Vector<EdGraphObject> res = new Vector<EdGraphObject>(5);
        for (int i = 0; i < objs.size(); ++i) {
            EdGraphObject obj;
            EdGraphObject go = (EdGraphObject)objs.get(i);
            GraphObject img = morph.getImage(go.getBasisObject());
            if (img == null || (obj = imageGraph.findGraphObject(img)) == null) continue;
            if (img instanceof Node) {
                EdArc ea;
                Arc a;
                res.add(obj);
                Enumeration e = ((Node)img).getIncomingArcs();
                while (e.hasMoreElements()) {
                    a = (Arc)e.nextElement();
                    if (!morph.getInverseImage(a).hasMoreElements() || (ea = imageGraph.findArc(a)) == null || !res.contains(ea.getSource()) || res.contains(ea)) continue;
                    res.add(ea);
                }
                e = ((Node)img).getOutgoingArcs();
                while (e.hasMoreElements()) {
                    a = (Arc)e.nextElement();
                    if (!morph.getInverseImage(a).hasMoreElements() || (ea = imageGraph.findArc(a)) == null || !res.contains(ea.getTarget()) || res.contains(ea)) continue;
                    res.add(ea);
                }
                continue;
            }
            if (res.contains(obj)) continue;
            res.add(obj);
        }
        return res;
    }

    private Vector getInverseImages(EdGraph imageGraph, OrdinaryMorphism morph, Vector objs) {
        Vector<EdGraphObject> res = new Vector<EdGraphObject>(5);
        for (int i = 0; i < objs.size(); ++i) {
            EdGraphObject go = (EdGraphObject)objs.get(i);
            Enumeration en = morph.getInverseImage(go.getBasisObject());
            while (en.hasMoreElements()) {
                EdGraphObject obj;
                GraphObject img = (GraphObject)en.nextElement();
                if (img == null || (obj = imageGraph.findGraphObject(img)) == null) continue;
                if (img instanceof Node) {
                    EdArc ea;
                    Arc a;
                    res.add(obj);
                    Enumeration e = ((Node)img).getIncomingArcs();
                    while (e.hasMoreElements()) {
                        a = (Arc)e.nextElement();
                        if (morph.getImage(a) == null || (ea = imageGraph.findArc(a)) == null || !res.contains(ea.getSource()) || res.contains(ea)) continue;
                        res.add(ea);
                    }
                    e = ((Node)img).getOutgoingArcs();
                    while (e.hasMoreElements()) {
                        a = (Arc)e.nextElement();
                        if (morph.getImage(a) == null || (ea = imageGraph.findArc(a)) == null || !res.contains(ea.getTarget()) || res.contains(ea)) continue;
                        res.add(ea);
                    }
                    continue;
                }
                if (res.contains(obj)) continue;
                res.add(obj);
            }
        }
        return res;
    }

    public void keyPressed(KeyEvent e) {
        if (this.leftPanel.getEditMode() == 9) {
            return;
        }
        Object source = e.getSource();
        int keyCode = e.getKeyCode();
        System.out.println(">>>RuleEditor  keyPressed  " + keyCode);
        if (source == this.leftPanel.getCanvas()) {
            switch (keyCode) {
                case 127: {
                    System.out.println("KeyEvent.VK_DELETE");
                    this.removeProc();
                    break;
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.leftPanel.getEditMode() == 9) {
            return;
        }
        Object source = e.getSource();
        int keyCode = e.getKeyCode();
        if (source == this.leftPanel.getCanvas()) {
            switch (keyCode) {
                case 127: {
                    if (this.leftPanel.getEditMode() == 32) {
                        this.leftPanel.setEditMode(31);
                        this.leftPanel.setEditCursor(new Cursor(12));
                        if (this.applFrame == null) break;
                        this.applFrame.setCursor(new Cursor(12));
                        break;
                    }
                    if (this.leftPanel.getEditMode() == 82) {
                        this.leftPanel.setEditMode(81);
                        this.leftPanel.setEditCursor(new Cursor(12));
                        if (this.applFrame == null) break;
                        this.applFrame.setCursor(new Cursor(12));
                        break;
                    }
                    if (this.leftPanel.getEditMode() == 43) {
                        this.leftPanel.setEditMode(42);
                        this.leftPanel.setEditCursor(new Cursor(12));
                        if (this.applFrame == null) break;
                        this.applFrame.setCursor(new Cursor(12));
                        break;
                    }
                    if (this.leftPanel.getEditMode() == 1161) {
                        this.leftPanel.setEditMode(115);
                        this.leftPanel.setEditCursor(new Cursor(12));
                        if (this.applFrame == null) break;
                        this.applFrame.setCursor(new Cursor(12));
                        break;
                    }
                    if (this.leftPanel.getEditMode() != 1181) break;
                    this.leftPanel.setEditMode(117);
                    this.leftPanel.setEditCursor(new Cursor(12));
                    if (this.applFrame == null) break;
                    this.applFrame.setCursor(new Cursor(12));
                    break;
                }
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 150);
    }

    public String getTitle() {
        return this.title.getText();
    }

    public void setTitle(String str) {
        this.title.setText("  " + str);
    }

    public void setRuleTitle(String str1, String str2) {
        if (!str1.equals("") && !str2.equals("")) {
            this.ruleName = str1;
            this.gragraName = str2;
            this.title.setText("  " + this.ruleName + "  of  " + this.gragraName);
        } else if (!str1.equals("") && str2.equals("")) {
            this.ruleName = str1;
            this.title.setText("  " + this.ruleName);
        } else if (str1.equals("") && !str2.equals("")) {
            this.gragraName = str2;
            this.title.setText("  " + this.gragraName);
        } else {
            this.title.setText("     ");
        }
    }

    public void setAtomicTitle(String str1, String str2) {
        if (!str1.equals("") && !str2.equals("")) {
            this.conclusionName = str1;
            this.atomicName = str2;
            this.title.setText("  " + this.atomicName + "  with  " + this.conclusionName);
        } else if (!str1.equals("") && str2.equals("")) {
            this.conclusionName = str1;
            this.title.setText("  " + this.conclusionName);
        } else if (str1.equals("") && !str2.equals("")) {
            this.atomicName = str2;
            this.title.setText("  " + this.atomicName);
        } else {
            this.title.setText("   ");
        }
    }

    public void setNACTitle(String str) {
        this.titleNAC.setText("  " + str);
    }

    public GraphPanel getLeftPanel() {
        return this.leftPanel;
    }

    public GraphPanel getRightPanel() {
        return this.rightPanel;
    }

    public GraphPanel getNACPanel() {
        return this.nacPanel;
    }

    public GraphPanel getActivePanel() {
        return this.activePanel;
    }

    public int getEditMode() {
        return this.leftPanel.getEditMode();
    }

    public EdGraGra getGraGra() {
        return this.eGra;
    }

    public EdRule getRule() {
        return this.eRule;
    }

    public EdAtomic getAtomic() {
        if (this.eRule != null && this.eRule instanceof EdAtomic) {
            return (EdAtomic)this.eRule;
        }
        return null;
    }

    public EdNAC getNAC() {
        return this.eNAC;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String s) {
        this.msg = s;
    }

    public boolean hasRule() {
        return this.eRule != null;
    }

    public boolean isObjMapping() {
        return this.mapping;
    }

    public void setObjMapping(boolean b) {
        this.mapping = b;
    }

    public void setFrame(JFrame f) {
        this.applFrame = f;
    }

    public void setGraphEditor(GraphEditor gEditor) {
        this.graphEditor = gEditor;
    }

    public void setRule(EdRule er) {
        if (this.eRule != null) {
            this.ruleDividerLocation = this.ruleSplitPane.getDividerLocation();
            this.dividerLocationSet.put(this.eRule, new Integer(this.ruleSplitPane.getDividerLocation()));
        }
        this.eRule = er;
        if (this.eRule != null) {
            if (this.exportJPEG != null) {
                this.exportJPEGButton.setEnabled(true);
            }
            this.eGra = this.eRule.getGraGra();
            if (this.eGra != null) {
                this.setRuleTitle(this.eRule.getBasisRule().getName(), this.eGra.getName());
            } else {
                this.setRuleTitle(this.eRule.getBasisRule().getName(), "");
            }
            this.leftPanel.setGraph(this.eRule.getLeft());
            this.rightPanel.setGraph(this.eRule.getRight());
            if (this.attrEditor != null) {
                this.attrEditor.setContext(this.eRule.getBasisRule().getAttrContext());
            }
            if (this.dividerLocationSet.get(this.eRule) != null) {
                this.ruleSplitPane.setDividerLocation((Integer)this.dividerLocationSet.get(this.eRule));
            } else {
                this.ruleSplitPane.setDividerLocation(this.ruleDividerLocation);
            }
        } else {
            this.ruleDividerLocation = this.ruleSplitPane.getDividerLocation();
            this.setTitle("    ");
            this.leftPanel.setGraph(null);
            this.rightPanel.setGraph(null);
            this.setNAC(null);
            this.exportJPEGButton.setEnabled(false);
        }
    }

    public int getRuleDividerLocation() {
        return this.ruleDividerLocation;
    }

    public int getNacDividerLocation() {
        return this.nacDividerLocation;
    }

    public void setDividerLocation(int indx, int i) {
        if (indx == 0) {
            this.splitPane.setDividerLocation(i);
        } else if (indx == 1) {
            this.ruleSplitPane.setDividerLocation(i);
        }
    }

    public void setAtomic(EdAtomic a) {
        if (this.eRule != null) {
            this.ruleDividerLocation = this.ruleSplitPane.getDividerLocation();
            this.dividerLocationSet.put(this.eRule, new Integer(this.ruleSplitPane.getDividerLocation()));
        }
        this.eRule = a;
        if (this.eRule != null) {
            if (!a.getConclusions().isEmpty()) {
                if (this.exportJPEG != null) {
                    this.exportJPEGButton.setEnabled(true);
                }
                this.eGra = this.eRule.getGraGra();
                String s = a.getBasisAtomic().getAtomicName();
                this.setAtomicTitle(this.eRule.getMorph().getName(), s);
                this.leftPanel.setGraph(this.eRule.getLeft());
                this.rightPanel.setGraph(this.eRule.getRight());
                this.attrEditor.setContext(a.getBasisAtomic().getAttrContext());
                this.setNAC(null);
                if (this.dividerLocationSet.get(this.eRule) != null) {
                    this.ruleSplitPane.setDividerLocation((Integer)this.dividerLocationSet.get(this.eRule));
                } else {
                    this.ruleSplitPane.setDividerLocation(this.ruleDividerLocation);
                }
            }
        } else {
            this.ruleDividerLocation = this.ruleSplitPane.getDividerLocation();
            this.setTitle("    ");
            this.leftPanel.setGraph(null);
            this.rightPanel.setGraph(null);
            this.setNAC(null);
            this.exportJPEGButton.setEnabled(false);
        }
    }

    public void setNAC(EdNAC enac) {
        if (this.eNAC != null) {
            this.nacDividerLocation = this.splitPane.getDividerLocation();
            this.dividerLocationSet.put(this.eNAC, new Integer(this.splitPane.getDividerLocation()));
        }
        this.eNAC = enac;
        if (this.eNAC != null) {
            this.setNACTitle(this.eNAC.getBasisGraph().getName());
            this.nacPanel.setGraph(this.eNAC);
            this.showNAC();
        } else {
            this.nacDividerLocation = 0;
            this.nacPanel.setGraph(null);
            this.setNACTitle("");
            this.hideNAC();
        }
    }

    public void showNAC() {
        if (this.dividerLocationSet.get(this.eNAC) != null) {
            this.splitPane.setDividerLocation((Integer)this.dividerLocationSet.get(this.eNAC));
        } else if (this.nacDividerLocation < 10) {
            this.nacDividerLocation = 150;
            this.splitPane.setDividerLocation(this.nacDividerLocation);
            this.dividerLocationSet.put(this.eNAC, new Integer(this.nacDividerLocation));
        } else {
            this.splitPane.setDividerLocation(this.nacDividerLocation);
            this.dividerLocationSet.put(this.eNAC, new Integer(this.nacDividerLocation));
        }
    }

    public void setRuleDividerLocation(int l) {
        this.ruleSplitPane.setDividerLocation(l);
    }

    public void hideNAC() {
        this.splitPane.setDividerLocation(0);
    }

    public boolean hasOneSelection() {
        if (this.eRule == null) {
            return false;
        }
        if (!(!this.leftPanel.getGraph().hasSelection() || this.rightPanel.getGraph().hasSelection() || this.nacPanel.getGraph() != null && this.nacPanel.getGraph().hasSelection())) {
            return true;
        }
        if (!(!this.rightPanel.getGraph().hasSelection() || this.leftPanel.getGraph().hasSelection() || this.nacPanel.getGraph() != null && this.nacPanel.getGraph().hasSelection())) {
            return true;
        }
        return this.nacPanel.getGraph() != null && this.nacPanel.getGraph().hasSelection() && !this.leftPanel.getGraph().hasSelection() && !this.rightPanel.getGraph().hasSelection();
    }

    public boolean hasSelection() {
        if (this.eRule == null) {
            return false;
        }
        return this.leftPanel.getGraph().hasSelection() || this.rightPanel.getGraph().hasSelection() || this.nacPanel.getGraph() != null && this.nacPanel.getGraph().hasSelection();
    }

    public boolean hasSelection(GraphPanel gPanel) {
        if (gPanel.getGraph() == null) {
            return false;
        }
        return gPanel.getGraph().hasSelection();
    }

    public void updateGraphics() {
        this.leftPanel.updateGraphics();
        this.rightPanel.updateGraphics();
        this.nacPanel.updateGraphics();
    }

    public void updateGraphics(boolean graphDimensionCheck) {
        this.leftPanel.updateGraphics(graphDimensionCheck);
        this.rightPanel.updateGraphics(graphDimensionCheck);
        this.nacPanel.updateGraphics(graphDimensionCheck);
    }

    public void saveRuleScrollBarValue() {
        this.leftPanel.getCanvas().saveScrollBarValue();
        this.rightPanel.getCanvas().saveScrollBarValue();
    }

    public void saveScrollBarValue() {
        this.leftPanel.getCanvas().saveScrollBarValue();
        this.rightPanel.getCanvas().saveScrollBarValue();
        this.nacPanel.getCanvas().saveScrollBarValue();
    }

    public void clear() {
        this.setRule(null);
        this.updateGraphics();
    }

    public void clearNAC() {
        this.setNAC(null);
        this.getNACPanel().updateGraphics();
        this.updateGraphics();
    }

    public void setAttrEditor(AttrTopEditor attrEditor) {
        this.attrEditor = attrEditor;
    }

    public AttrTopEditor getAttrEditor() {
        return this.attrEditor;
    }

    public AttrTopEditor getAttrEditor(EdGraphObject ego) {
        EdArc ea;
        if (this.attrEditor == null) {
            return null;
        }
        if (ego.isNode()) {
            EdNode en = (EdNode)ego;
            if (en.getBasisNode() != null) {
                this.attrEditor.setTuple(en.getBasisNode().getAttribute());
                en.setAttrViewSetting(this.attrEditor.getViewSetting());
                if (!en.isAttrObserver()) {
                    this.attrEditor.getViewSetting().addObserver(en, en.getBasisNode().getAttribute());
                    en.setAttrObserver(true);
                }
                en.setGraphPanel(this.getActivePanel());
            }
        } else if (ego.isArc() && (ea = (EdArc)ego).getBasisArc() != null) {
            this.attrEditor.setTuple(ea.getBasisArc().getAttribute());
            ea.setAttrViewSetting(this.attrEditor.getViewSetting());
            if (!ea.isAttrObserver()) {
                this.attrEditor.getViewSetting().addObserver(ea, ea.getBasisArc().getAttribute());
                ea.setAttrObserver(true);
            }
            ea.setGraphPanel(this.getActivePanel());
        }
        return this.attrEditor;
    }

    public void setModePopupMenu(ModePopupMenu pm) {
        this.modePopupMenu = pm;
    }

    public void setEditPopupMenu(EditPopupMenu pm) {
        this.editPopupMenu = pm;
    }

    public void setEditSelPopupMenu(EditSelPopupMenu pm) {
        this.editSelPopupMenu = pm;
    }

    private void drawGraphic(EdGraphObject go, GraphPanel p, boolean map, boolean erase) {
        if (map) {
            Vector v = p.getGraph().getChangedGraphObjects();
            for (int i = 0; i < v.size(); ++i) {
                EdGraphObject o = (EdGraphObject)v.elementAt(i);
                if (erase) {
                    this.eraseGraphic(o, p);
                }
                this.drawGraphic(o, p);
            }
        } else if (go != null) {
            this.drawGraphic(go, p);
        }
    }

    private void drawGraphic(EdGraphObject go, GraphPanel p) {
        if (go.isNode()) {
            int i;
            p.getGraph().drawNode(p.getCanvas().getGraphics(), p.getCanvas().getScale(), (EdNode)go);
            Vector v = p.getGraph().getIncomingArcs((EdNode)go);
            for (i = 0; i < v.size(); ++i) {
                ((EdArc)v.elementAt(i)).drawText(p.getCanvas().getGraphics(), p.getCanvas().getScale());
            }
            v = p.getGraph().getOutgoingArcs((EdNode)go);
            for (i = 0; i < v.size(); ++i) {
                ((EdArc)v.elementAt(i)).drawText(p.getCanvas().getGraphics(), p.getCanvas().getScale());
            }
        } else {
            ((EdArc)go).drawText(p.getCanvas().getGraphics(), p.getCanvas().getScale());
        }
    }

    private void eraseGraphic(EdGraphObject go, GraphPanel p) {
        if (go.isNode()) {
            int i;
            ((EdNode)go).eraseGraphic(p.getCanvas().getGraphics(), p.getCanvas().getScale());
            Vector v = p.getGraph().getIncomingArcs((EdNode)go);
            for (i = 0; i < v.size(); ++i) {
                ((EdArc)v.elementAt(i)).eraseText(p.getCanvas().getGraphics(), p.getCanvas().getScale());
            }
            v = p.getGraph().getOutgoingArcs((EdNode)go);
            for (i = 0; i < v.size(); ++i) {
                ((EdArc)v.elementAt(i)).eraseText(p.getCanvas().getGraphics(), p.getCanvas().getScale());
            }
        } else {
            ((EdArc)go).eraseText(p.getCanvas().getGraphics(), p.getCanvas().getScale());
        }
    }

    public void setEditMode(int mode) {
        this.handleMouseListenerFromGraphEditor(mode);
        if (mode != 42) {
            this.resetEditModeAfterInteractMatch();
        }
        switch (mode) {
            case 11: {
                this.drawModeProc();
                break;
            }
            case 12: {
                this.selectModeProc();
                break;
            }
            case 13: {
                this.moveModeProc();
                break;
            }
            case 114: {
                this.attributesModeProc();
                break;
            }
            case 31: {
                this.ruleDefModeProc();
                break;
            }
            case 81: {
                this.nacDefModeProc();
                break;
            }
            case 42: {
                this.matchDefModeProc();
                break;
            }
            case 15: {
                this.duplicateModeProc();
                break;
            }
            case 115: {
                this.mapModeProc();
                break;
            }
            case 116: {
                this.unmapModeProc();
                break;
            }
            case 117: {
                this.mapselModeProc();
                break;
            }
            case 118: {
                this.unmapselModeProc();
                break;
            }
            case 9: {
                this.viewModeProc();
                break;
            }
        }
    }

    public int getMode() {
        return this.leftPanel.getEditMode();
    }

    public int getPreviousMode() {
        return this.leftPanel.getLastEditMode();
    }

    public void setEditCursor(Cursor cur) {
        this.leftPanel.setEditCursor(cur);
        this.rightPanel.setEditCursor(cur);
        this.nacPanel.setEditCursor(cur);
    }

    public void resetAfterInteractMatch() {
        this.setEditMode(this.leftPanel.getLastEditMode());
    }

    private void resetEditModeAfterInteractMatch() {
        if (this.eRule == null) {
            return;
        }
        if (this.leftPanel.getEditMode() != 42) {
            return;
        }
        if (this.leftPanel.getLastEditMode() == 9) {
            this.graphEditor.setEditMode(this.leftPanel.getLastEditMode());
        } else {
            this.graphEditor.setEditMode(this.leftPanel.getLastEditMode());
        }
    }

    private void drawModeProc() {
        this.setPanelEditMode(11);
        this.setEditCursor(new Cursor(0));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(0));
        }
        this.msg = "Click on the background to get a node / on a source node and a target node to get an edge.";
    }

    private void selectModeProc() {
        this.setPanelEditMode(12);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
        this.msg = "Click on an object to select it.";
    }

    private void moveModeProc() {
        this.setPanelEditMode(13);
        this.setEditCursor(new Cursor(13));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(13));
        }
        this.msg = "Press and drag the button when the cursor points to an object.";
    }

    private void attributesModeProc() {
        this.setPanelEditMode(114);
        this.setEditCursor(new Cursor(0));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(0));
        }
        this.msg = "Click on an object to get the attribute editor.";
    }

    private void ruleDefModeProc() {
        this.setPanelEditMode(31);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
        this.msg = "Click on a source object and a target object to get a mapping pair.";
    }

    private void nacDefModeProc() {
        this.setPanelEditMode(81);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
        this.msg = "Click on a source object and a target object to get a mapping pair.";
    }

    private void matchDefModeProc() {
        if (this.eRule == null) {
            return;
        }
        if (this.graphEditor == null) {
            System.out.println("\nThe instance of GraphEditor is null.\nUse setGraphEditor(GraphEditor editor) to set it.\n");
            return;
        }
        this.setLastEditModeBeforMatch(this.leftPanel);
        this.setPanelEditMode(42);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
        this.graphEditor.setEditMode(42);
        this.graphEditor.setEditCursor(new Cursor(12));
        this.leftObj = null;
        this.graphObj = null;
        this.msg = "Click on a source object and a target object to get a mapping pair.";
    }

    private void mapModeProc() {
        this.setLastEditModeBeforMapping(this.leftPanel);
        this.setPanelEditMode(115);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
        this.msg = "Click on a source object and a target object to get a mapping.";
    }

    private void unmapModeProc() {
        this.setLastEditModeBeforMapping(this.leftPanel);
        this.setPanelEditMode(116);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
        this.msg = "Click on the source of the mapping to destroy it.";
    }

    private void mapselModeProc() {
        if (this.leftPanel.getEditMode() == 117) {
            return;
        }
        this.setLastEditModeBeforMapping(this.leftPanel);
        this.setPanelEditMode(117);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
        this.msg = "Click on a source object and a target object to get a mapping.";
    }

    private void unmapselModeProc() {
        if (this.leftPanel.getEditMode() == 118) {
            return;
        }
        this.setLastEditModeBeforMapping(this.leftPanel);
        this.setPanelEditMode(118);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
        this.msg = "Click on the source object of the mapping to destroy it.";
    }

    private void duplicateModeProc() {
        if (this.eRule == null) {
            return;
        }
        this.saveLastEditMode();
        this.setPanelEditMode(15);
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(1));
        }
        this.msg = "To get a copy click on the background of the same panel.";
    }

    private void saveLastEditMode() {
        this.leftPanel.setLastEditMode(this.leftPanel.getEditMode());
        this.leftPanel.setLastEditCursor(this.leftPanel.getEditCursor());
        this.rightPanel.setLastEditMode(this.rightPanel.getEditMode());
        this.rightPanel.setLastEditCursor(this.rightPanel.getEditCursor());
        if (this.nacPanel.getGraph() != null) {
            this.nacPanel.setLastEditMode(this.nacPanel.getEditMode());
            this.nacPanel.setLastEditCursor(this.nacPanel.getEditCursor());
        }
    }

    private void viewModeProc() {
        this.leftPanel.setEditMode(9);
        this.rightPanel.setEditMode(9);
        this.nacPanel.setEditMode(9);
    }

    public void attrsProc() {
        if (this.leftPanel.getEditMode() == 9 || this.rightPanel.getEditMode() == 9) {
            return;
        }
        if (this.eRule == null) {
            return;
        }
        EdGraphObject ego = null;
        if (this.leftPanel.getGraph().hasOneSelection()) {
            ego = (EdGraphObject)this.leftPanel.getGraph().getSelectedObjs().firstElement();
        } else if (this.rightPanel.getGraph().hasOneSelection()) {
            ego = (EdGraphObject)this.rightPanel.getGraph().getSelectedObjs().firstElement();
        } else if (this.nacPanel.getGraph() != null && this.nacPanel.getGraph().hasOneSelection()) {
            ego = (EdGraphObject)this.nacPanel.getGraph().getSelectedObjs().firstElement();
        }
        if (ego != null) {
            this.getAttrEditor(ego);
            this.getAttrEditor().enableContextEditor(true);
            if (this.gragraEditor != null) {
                this.gragraEditor.setAttrEditorOnBottom(this.getAttrEditor().getComponent());
            }
            this.msg = "";
        } else {
            this.msg = "No object is selected.";
        }
    }

    public boolean deleteProc() {
        if (this.leftPanel.getEditMode() == 9 || this.rightPanel.getEditMode() == 9) {
            return false;
        }
        if (this.eRule == null) {
            return false;
        }
        boolean result = false;
        if (this.hasSelection(this.leftPanel)) {
            this.leftPanel.deleteSelected();
            result = true;
        }
        if (this.hasSelection(this.rightPanel)) {
            this.rightPanel.deleteSelected();
            result = true;
        }
        if (this.hasSelection(this.nacPanel)) {
            this.nacPanel.deleteSelected();
            result = true;
        }
        if (result) {
            this.eRule.update();
            this.leftPanel.updateGraphicsAfterDelete();
            this.rightPanel.updateGraphicsAfterDelete();
            this.nacPanel.updateGraphicsAfterDelete();
            if (this.graphEditor != null) {
                this.graphEditor.getGraphPanel().updateGraphicsAfterDelete();
            }
        }
        return result;
    }

    public void copyProc() {
        if (this.leftPanel.getEditMode() == 9 || this.rightPanel.getEditMode() == 9) {
            return;
        }
        if (!this.hasSelection()) {
            this.msg = "Copy -> No object is selected";
            return;
        }
        this.saveLastEditMode();
        this.msg = "";
        this.setEditMode(15);
    }

    public void selectAllProc() {
        if (this.eRule == null) {
            return;
        }
        this.leftPanel.getGraph().selectAll();
        this.rightPanel.getGraph().selectAll();
        if (this.nacPanel.getGraph() != null) {
            this.nacPanel.getGraph().selectAll();
        }
        this.leftPanel.updateGraphics();
        this.rightPanel.updateGraphics();
        this.nacPanel.updateGraphics();
    }

    public void selectNodeTypeProc() {
        if (this.eRule == null) {
            return;
        }
        if (!this.leftPanel.getGraph().getSelectedArcs().isEmpty() || !this.leftPanel.getGraph().getSelectedNodes().isEmpty()) {
            this.leftPanel.getGraph().eraseSelected(this.leftPanel.getCanvas().getGraphics(), this.leftPanel.getCanvas().getScale(), true);
        }
        if (!this.rightPanel.getGraph().getSelectedArcs().isEmpty() || !this.rightPanel.getGraph().getSelectedNodes().isEmpty()) {
            this.rightPanel.getGraph().eraseSelected(this.rightPanel.getCanvas().getGraphics(), this.rightPanel.getCanvas().getScale(), true);
        }
        if (!(this.nacPanel.getGraph() == null || this.nacPanel.getGraph().getSelectedArcs().isEmpty() && this.nacPanel.getGraph().getSelectedNodes().isEmpty())) {
            this.nacPanel.getGraph().eraseSelected(this.nacPanel.getCanvas().getGraphics(), this.nacPanel.getCanvas().getScale(), true);
        }
        this.leftPanel.getGraph().selectObjectsOfSelectedNodeType();
        if (!this.leftPanel.getGraph().getSelectedNodes().isEmpty()) {
            this.leftPanel.getGraph().drawSelected(this.leftPanel.getCanvas().getGraphics(), this.leftPanel.getCanvas().getScale());
        }
        this.rightPanel.getGraph().selectObjectsOfSelectedNodeType();
        if (!this.rightPanel.getGraph().getSelectedNodes().isEmpty()) {
            this.rightPanel.getGraph().drawSelected(this.rightPanel.getCanvas().getGraphics(), this.rightPanel.getCanvas().getScale());
        }
        if (this.nacPanel.getGraph() != null) {
            this.nacPanel.getGraph().selectObjectsOfSelectedNodeType();
            if (!this.nacPanel.getGraph().getSelectedNodes().isEmpty()) {
                this.nacPanel.getGraph().drawSelected(this.nacPanel.getCanvas().getGraphics(), this.nacPanel.getCanvas().getScale());
            }
        }
    }

    public void selectArcTypeProc() {
        if (this.eRule == null) {
            return;
        }
        if (!this.leftPanel.getGraph().getSelectedNodes().isEmpty() || !this.leftPanel.getGraph().getSelectedArcs().isEmpty()) {
            this.leftPanel.getGraph().eraseSelected(this.leftPanel.getCanvas().getGraphics(), this.leftPanel.getCanvas().getScale(), true);
        }
        if (!this.rightPanel.getGraph().getSelectedNodes().isEmpty() || !this.rightPanel.getGraph().getSelectedArcs().isEmpty()) {
            this.rightPanel.getGraph().eraseSelected(this.rightPanel.getCanvas().getGraphics(), this.rightPanel.getCanvas().getScale(), true);
        }
        if (!(this.nacPanel.getGraph() == null || this.nacPanel.getGraph().getSelectedNodes().isEmpty() && this.nacPanel.getGraph().getSelectedArcs().isEmpty())) {
            this.nacPanel.getGraph().eraseSelected(this.nacPanel.getCanvas().getGraphics(), this.nacPanel.getCanvas().getScale(), true);
        }
        this.leftPanel.getGraph().selectObjectsOfSelectedArcType();
        if (!this.leftPanel.getGraph().getSelectedArcs().isEmpty()) {
            this.leftPanel.getGraph().drawSelected(this.leftPanel.getCanvas().getGraphics(), this.leftPanel.getCanvas().getScale());
        }
        this.rightPanel.getGraph().selectObjectsOfSelectedArcType();
        if (!this.rightPanel.getGraph().getSelectedArcs().isEmpty()) {
            this.rightPanel.getGraph().drawSelected(this.rightPanel.getCanvas().getGraphics(), this.rightPanel.getCanvas().getScale());
        }
        if (this.nacPanel.getGraph() != null) {
            this.nacPanel.getGraph().selectObjectsOfSelectedArcType();
            if (!this.nacPanel.getGraph().getSelectedArcs().isEmpty()) {
                this.nacPanel.getGraph().drawSelected(this.nacPanel.getCanvas().getGraphics(), this.nacPanel.getCanvas().getScale());
            }
        }
    }

    public void deselectAllProc() {
        if (this.eRule == null) {
            return;
        }
        this.leftPanel.getGraph().deselectAll();
        this.rightPanel.getGraph().deselectAll();
        if (this.nacPanel.getGraph() != null) {
            this.nacPanel.getGraph().deselectAll();
        }
        this.leftPanel.updateGraphics();
        this.rightPanel.updateGraphics();
        this.nacPanel.updateGraphics();
    }

    public void straigthenArcsProc() {
        if (this.leftPanel.getEditMode() == 9 || this.rightPanel.getEditMode() == 9) {
            return;
        }
        if (this.eRule == null) {
            return;
        }
        boolean l = true;
        boolean r = true;
        boolean n = true;
        boolean result = false;
        if (this.leftPanel.getGraph().hasSelection()) {
            this.leftPanel.getGraph().eraseSelected(this.leftPanel.getCanvas().getGraphics(), this.leftPanel.getCanvas().getScale(), false);
            this.leftPanel.getGraph().straightSelectedArcs();
            this.leftPanel.getGraph().drawSelected(this.leftPanel.getCanvas().getGraphics(), this.leftPanel.getCanvas().getScale());
            result = true;
        }
        if (this.rightPanel.getGraph().hasSelection()) {
            this.rightPanel.getGraph().eraseSelected(this.rightPanel.getCanvas().getGraphics(), this.rightPanel.getCanvas().getScale(), false);
            this.rightPanel.getGraph().straightSelectedArcs();
            this.rightPanel.getGraph().drawSelected(this.rightPanel.getCanvas().getGraphics(), this.rightPanel.getCanvas().getScale());
            result = true;
        }
        if (this.nacPanel.getGraph() != null && this.nacPanel.getGraph().hasSelection()) {
            this.nacPanel.getGraph().eraseSelected(this.nacPanel.getCanvas().getGraphics(), this.nacPanel.getCanvas().getScale(), false);
            this.nacPanel.getGraph().straightSelectedArcs();
            this.nacPanel.getGraph().drawSelected(this.nacPanel.getCanvas().getGraphics(), this.nacPanel.getCanvas().getScale());
            result = true;
        }
        this.msg = !result ? "Bad selection." : "";
    }

    public void doIdenticRule() {
        if (this.leftPanel.getEditMode() == 9 || this.rightPanel.getEditMode() == 9) {
            return;
        }
        if (this.eRule == null) {
            return;
        }
        this.eRule.identicRule();
        this.leftPanel.updateGraphics();
        this.rightPanel.updateGraphics(true);
        this.msg = this.eRule.getMsg();
    }

    public void doIdenticNAC() {
        if (this.leftPanel.getEditMode() == 9 || this.rightPanel.getEditMode() == 9) {
            return;
        }
        if (this.eRule == null || this.eNAC == null) {
            return;
        }
        this.eRule.identicNAC(this.eNAC);
        this.leftPanel.updateGraphics();
        this.nacPanel.updateGraphics(true);
        this.msg = this.eRule.getMsg();
    }

    public void setGraphToCopy(EdGraph g) {
        if (this.eRule != null) {
            this.eRule.getLeft().setGraphToCopy(g);
            this.eRule.getRight().setGraphToCopy(g);
            if (this.nacPanel.getGraph() != null) {
                this.nacPanel.getGraph().setGraphToCopy(g);
            }
        }
    }

    public EdGraph getSelectedAsGraphCopy() {
        if (this.eRule == null) {
            return null;
        }
        EdGraph g = this.eRule.getLeft().getSelectedAsGraphCopy();
        if (g != null) {
            this.sourceOfCopy = this.eRule.getLeft();
            return g;
        }
        g = this.eRule.getRight().getSelectedAsGraphCopy();
        if (g != null) {
            this.sourceOfCopy = this.eRule.getRight();
            return g;
        }
        if (this.nacPanel.getGraph() != null) {
            g = this.nacPanel.getGraph().getSelectedAsGraphCopy();
            if (g != null) {
                this.sourceOfCopy = this.nacPanel.getGraph();
                return g;
            }
            return null;
        }
        return null;
    }

    public EdGraph getSourceOfCopy() {
        return this.sourceOfCopy;
    }

    public void setSourceOfCopy(EdGraph g) {
        this.sourceOfCopy = g;
    }

    private void setLastEditModeBeforMatch(GraphPanel gp) {
        if (gp.getEditMode() == 11 || gp.getEditMode() == 113 || gp.getEditMode() == 12 || gp.getEditMode() == 13 || gp.getEditMode() == 114 || gp.getEditMode() == 31 || gp.getEditMode() == 81 || gp.getEditMode() == 9) {
            gp.setLastEditMode(gp.getEditMode());
        }
    }

    private void handleMouseListenerFromGraphEditor(int mode) {
        switch (mode) {
            case 11: 
            case 12: 
            case 13: 
            case 31: 
            case 81: 
            case 113: 
            case 114: {
                if (!this.mouseListenerFromGraphEditorAdded) break;
                this.graphEditor.getGraphPanel().getCanvas().removeMouseListener(this);
                this.mouseListenerFromGraphEditorAdded = false;
                break;
            }
            case 42: 
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                if (this.mouseListenerFromGraphEditorAdded || this.graphEditor == null) break;
                this.graphEditor.getGraphPanel().getCanvas().addMouseListener(this);
                this.mouseListenerFromGraphEditorAdded = true;
                break;
            }
        }
    }

    private void removeProc() {
        if (this.leftPanel.getEditMode() == 31) {
            this.removeRuleMappingProc();
        } else if (this.leftPanel.getEditMode() == 81) {
            this.removeNACMappingProc();
        } else if (this.leftPanel.getEditMode() == 42) {
            this.removeMatchMappingProc();
        } else if (this.leftPanel.getEditMode() == 115) {
            this.removeMappingProc();
        } else if (this.leftPanel.getEditMode() == 117) {
            this.removeMappingSelProc();
        }
    }

    private void removeRuleMappingProc() {
        this.leftPanel.setEditMode(32);
        this.leftPanel.setEditCursor(new Cursor(1));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(1));
        }
    }

    private void removeNACMappingProc() {
        this.leftPanel.setEditMode(82);
        this.leftPanel.setEditCursor(new Cursor(1));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(1));
        }
    }

    private void removeMatchMappingProc() {
        this.leftPanel.setEditMode(43);
        this.leftPanel.setEditCursor(new Cursor(1));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(1));
        }
    }

    private void removeMappingProc() {
        this.leftPanel.setEditMode(1161);
        this.leftPanel.setEditCursor(new Cursor(1));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(1));
        }
    }

    private void removeMappingSelProc() {
        this.leftPanel.setEditMode(1181);
        this.leftPanel.setEditCursor(new Cursor(1));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(1));
        }
    }

    public void resetEditModeAfterMapping() {
        this.mapping = false;
        this.isEditPopupMenu = false;
        this.isEditSelPopupMenu = false;
        this.setEditMode(this.leftPanel.getLastEditMode());
        if (this.graphEditor != null) {
            this.graphEditor.setEditMode(this.leftPanel.getLastEditMode());
        }
        if (this.gragraEditor != null) {
            this.gragraEditor.setMsg(this.getMsg());
        }
    }

    public void setExportJPEG(GraphicsExportJPEG jpg) {
        this.exportJPEG = jpg;
    }

    private void setLastEditModeBeforMapping(GraphPanel gp) {
        if (gp.getEditMode() == 11 || gp.getEditMode() == 113 || gp.getEditMode() == 12 || gp.getEditMode() == 13 || gp.getEditMode() == 114 || gp.getEditMode() == 31 || gp.getEditMode() == 81 || gp.getEditMode() == 42 || gp.getEditMode() == 115 || gp.getEditMode() == 116) {
            gp.setLastEditMode(gp.getEditMode());
        }
    }

    private void removeKeyListenerAfterMapping(GraphPanel gp) {
        if (gp.getEditMode() == 31 || gp.getEditMode() == 81 || gp.getEditMode() == 42 || gp.getEditMode() == 115 || gp.getEditMode() == 117) {
            // empty if block
        }
    }

    private void addKeyListenerBeforMapping(GraphPanel gp) {
        if (gp.getEditMode() == 31 || gp.getEditMode() == 81 || gp.getEditMode() == 42 || gp.getEditMode() == 115 || gp.getEditMode() == 117) {
            // empty if block
        }
    }

    private GraphPanel myActivePanel(Object src) {
        if (src.equals(this.leftPanel.getCanvas())) {
            return this.leftPanel;
        }
        if (src.equals(this.rightPanel.getCanvas())) {
            return this.rightPanel;
        }
        if (src.equals(this.nacPanel.getCanvas())) {
            return this.nacPanel;
        }
        if (src.equals(this.graphEditor.getGraphPanel().getCanvas())) {
            return this.graphEditor.getGraphPanel();
        }
        return null;
    }

    private void showPopupMenu(MouseEvent e) {
        GraphPanel gp = this.myActivePanel(e.getSource());
        if (gp == null) {
            return;
        }
        if (this.editPopupMenu != null) {
            this.editPopupMenu.setEditor(this);
            this.editPopupMenu.setParentFrame(this.applFrame);
        }
        if (this.editSelPopupMenu != null) {
            this.editSelPopupMenu.setEditor(this);
            this.editSelPopupMenu.setParentFrame(this.applFrame);
        }
        this.isEditPopupMenu = false;
        this.isEditSelPopupMenu = false;
        if (gp == this.leftPanel) {
            if (this.modePopupMenu != null && this.modePopupMenu.invoked(this, gp, e.getX(), e.getY())) {
                this.modePopupMenu.show(e.getComponent(), e.getX(), e.getY());
            } else if (this.editPopupMenu != null && this.editPopupMenu.invoked(gp, e.getX(), e.getY())) {
                this.isEditPopupMenu = true;
                this.editPopupMenu.setMapEnabled(true);
                this.editPopupMenu.setUnmapEnabled(true);
                this.editPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            } else if (this.editSelPopupMenu != null && this.editSelPopupMenu.invoked(gp, e.getX(), e.getY())) {
                this.isEditSelPopupMenu = true;
                this.editSelPopupMenu.setMapEnabled(true);
                this.editSelPopupMenu.setUnmapEnabled(true);
                this.editSelPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        } else if (gp != null) {
            if (this.modePopupMenu != null && this.modePopupMenu.invoked(this, gp, e.getX(), e.getY())) {
                this.modePopupMenu.show(e.getComponent(), e.getX(), e.getY());
            } else if (this.editPopupMenu != null && this.editPopupMenu.invoked(gp, e.getX(), e.getY())) {
                this.isEditPopupMenu = true;
                this.editPopupMenu.setMapEnabled(false);
                this.editPopupMenu.setUnmapEnabled(true);
                this.editPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            } else if (this.editSelPopupMenu != null && this.editSelPopupMenu.invoked(gp, e.getX(), e.getY())) {
                this.isEditSelPopupMenu = true;
                this.editSelPopupMenu.setMapEnabled(false);
                this.editSelPopupMenu.setUnmapEnabled(true);
                this.editSelPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private void setPanelEditMode(int mode) {
        this.leftPanel.setEditMode(mode);
        this.rightPanel.setEditMode(mode);
        this.nacPanel.setEditMode(mode);
    }

    private void setToolkit() {
        Frame f = new Frame("");
        f.pack();
        this.tk = f.getToolkit();
    }

    private void errSound() {
        this.tk.beep();
    }
}

