/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.gui.AGGParser;
import agg.gui.CriticalPairAnalysis;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import agg.gui.event.LoadEvent;
import agg.gui.event.LoadEventListener;
import agg.gui.event.SaveEvent;
import agg.gui.event.SaveEventListener;
import agg.gui.event.TreeViewEvent;
import agg.gui.event.TreeViewEventListener;
import agg.gui.icons.MatchIcon;
import agg.gui.icons.TextIcon;
import agg.gui.parser.CriticalPairAnalysisGUI;
import agg.gui.parser.event.StatusMessageEvent;
import agg.gui.parser.event.StatusMessageListener;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class StatusBar
extends JPanel
implements SaveEventListener,
LoadEventListener,
TreeViewEventListener,
EditEventListener,
StatusMessageListener,
ParserEventListener {
    private JFrame frame;
    private JLabel mode;
    private JPanel content;
    private JScrollPane statusJSP;
    private JLabel status;
    private String msg = "";
    private String modeStr = "";
    private String lastModeStr = "";
    private String lastMsg = "";

    public StatusBar() {
        super(new BorderLayout(), true);
        this.setBackground(new Color(102, 200, 155));
        JPanel modePanel = new JPanel(new BorderLayout());
        modePanel.setBackground(new Color(102, 200, 155));
        modePanel.setPreferredSize(new Dimension(40, 40));
        modePanel.add((Component)new JLabel("    "), "West");
        this.mode = new JLabel("");
        modePanel.add((Component)this.mode, "Center");
        this.add((Component)modePanel, "West");
        this.content = new JPanel(new BorderLayout());
        this.content.setPreferredSize(new Dimension(550, 40));
        this.content.setBackground(new Color(102, 200, 155));
        this.statusJSP = new JScrollPane(21, 32);
        this.status = new JLabel(this.msg);
        this.status.setForeground(Color.blue);
        this.statusJSP.setViewportView(this.status);
        this.content.add((Component)this.statusJSP, "Center");
        this.add((Component)this.content, "Center");
        this.modeStr = "";
        this.msg = "";
        this.lastModeStr = this.modeStr;
        this.lastMsg = this.msg;
        MouseAdapter ml = new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                StatusBar.this.setMsg(StatusBar.this.mode.getToolTipText());
            }
        };
        this.mode.addMouseListener(ml);
        this.welcome();
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 50);
    }

    public void removeContent() {
        this.content.removeAll();
    }

    public void setContent(Component comp) {
        this.content.removeAll();
        this.content.add(comp, "Center");
        this.frame.validate();
        this.frame.repaint();
    }

    public void resetContent() {
        this.content.removeAll();
        this.content.add((Component)this.statusJSP, "Center");
        this.frame.validate();
        this.frame.repaint();
    }

    public String getMsg() {
        return this.msg;
    }

    public String getMode() {
        return this.modeStr;
    }

    private void doResize(String s) {
        if (s == null) {
            return;
        }
        int l = s.length() * 6;
        if (this.status.getFontMetrics(this.status.getFont()) != null) {
            l = this.status.getFontMetrics(this.status.getFont()).stringWidth(s);
        }
        if (l > this.content.getWidth()) {
            this.status.setSize(new Dimension(l, this.getHeight()));
        }
    }

    public void setMode(String aMode) {
        this.modeStr = aMode;
        Icon icon = this.getImageIcon(this.modeStr);
        if (icon != null) {
            this.mode.setIcon(icon);
        } else {
            this.mode.setIcon(new TextIcon(this.modeStr, true));
        }
        this.mode.setToolTipText("");
    }

    public void setMode(String aMode, String aToolTipText) {
        this.setMode(aMode);
        this.mode.setToolTipText(aToolTipText);
    }

    public void setMode(Icon modeIcon, String aToolTipText) {
        this.mode.setIcon(modeIcon);
        this.mode.setToolTipText(aToolTipText);
    }

    public void setMode(int modekey, String aToolTipText) {
        Icon icon = this.getImageIcon(modekey);
        if (icon != null) {
            this.setMode(icon, aToolTipText);
        }
    }

    public void setMode(Object obj) {
        if (obj instanceof String) {
            this.setMode((String)obj, "");
        } else if (obj instanceof Icon) {
            this.setMode((Icon)obj, "");
        }
    }

    public void setMsg(String aMessage) {
        if (this.msg == null || aMessage == null) {
            return;
        }
        if (!this.msg.equals(aMessage)) {
            this.msg = aMessage;
            this.status.setText(this.msg);
            this.status.setIcon(new TextIcon(" ", true));
            this.doResize(this.msg);
            this.status.invalidate();
            this.status.repaint();
        }
    }

    public void set(String aMode, String aMessage, String aToolTipText) {
        this.modeStr = aMode;
        this.setMode(this.modeStr, aToolTipText);
        this.msg = aMessage;
        this.status.setText(this.msg);
        this.doResize(this.msg);
    }

    public void addMsg(String aMessage) {
        String s;
        this.msg = s = this.msg.concat(" / " + aMessage);
        this.status.setText(this.msg);
        this.doResize(this.msg);
    }

    public void reset() {
        if (this.lastModeStr.equals("Hi!")) {
            this.lastModeStr = "";
            this.lastMsg = "";
        }
        this.setMode(this.lastModeStr);
        this.setMsg(this.lastMsg);
    }

    public void setFrame(JFrame f) {
        this.frame = f;
    }

    public void saveEventOccurred(SaveEvent e) {
        int msgkey = e.getMsg();
        if (msgkey == 0) {
            if (!this.modeStr.equals("Save")) {
                this.setMode(new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/save.gif")), "");
                this.lastModeStr = this.modeStr;
                this.lastMsg = this.msg;
                this.modeStr = "Save";
            }
            this.setMsg(e.getMessage());
            this.revalidate();
        } else {
            if (msgkey == 1) {
                if (e.getUsedComponent() != null) {
                    this.removeContent();
                    this.setContent(e.getUsedComponent());
                }
                return;
            }
            if (msgkey == 2) {
                if (e.getUsedComponent() != null) {
                    this.removeContent();
                    this.resetContent();
                }
                return;
            }
        }
        this.setMsg(e.getMessage());
    }

    public void loadEventOccurred(LoadEvent e) {
        int msgkey = e.getMsg();
        if (msgkey == 0) {
            this.lastModeStr = this.modeStr;
            this.lastMsg = this.msg;
            this.modeStr = "Load";
            this.setMode(new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/open.gif")), "");
            this.setMsg(e.getMessage());
        } else {
            if (msgkey == 1) {
                if (e.getUsedComponent() != null) {
                    this.removeContent();
                    this.setContent(e.getUsedComponent());
                }
                return;
            }
            if (msgkey == 2) {
                this.removeContent();
                this.resetContent();
                return;
            }
        }
        this.setMsg(e.getMessage());
    }

    public void treeViewEventOccurred(TreeViewEvent e) {
        int msgkey = e.getMsg();
        if (msgkey == 12) {
            this.setMsg(e.getMessage());
        }
        if (msgkey == 15) {
            this.setMsg(e.getMessage());
        }
    }

    public void editEventOccurred(EditEvent e) {
        int msgkey = e.getMsg();
        if (msgkey == 11 || msgkey == 12 || msgkey == 13 || msgkey == 114 || msgkey == 115 || msgkey == 116 || msgkey == 42 || msgkey == 9) {
            this.modeStr = e.getMode();
            this.setMode(msgkey, e.getMessage());
            this.setMsg(e.getMessage());
            this.status.invalidate();
            this.status.repaint();
        } else if (msgkey == -1) {
            this.setMsg(e.getMessage());
            this.status.invalidate();
            this.status.repaint();
        } else if (msgkey == -7) {
            this.modeStr = "";
            this.setMode("", "");
            this.setMsg(e.getMessage());
            this.status.invalidate();
            this.status.repaint();
        }
    }

    public void newMessage(StatusMessageEvent e) {
        if (e.getSource() instanceof CriticalPairAnalysisGUI || e.getSource() instanceof CriticalPairAnalysis) {
            if (!this.modeStr.equals("CriticPairs")) {
                this.lastModeStr = this.modeStr;
                this.lastMsg = this.msg;
            }
            this.modeStr = "CriticPairs";
            this.setMode(new TextIcon("CP", true), "");
            String s = "";
            if (e.getMessage().indexOf("finished") != -1) {
                if (e.getMessage().indexOf("Critical") != -1) {
                    s = " You can select rule pairs on the left to see results.";
                    System.out.println(s);
                }
            } else if (e.getMessage().indexOf("back") != -1) {
                this.lastMsg = "";
                this.reset();
            }
            if (e.getMessage() != "") {
                this.setMsg(e.getMessage() + s);
            }
        } else if (e.getSource() instanceof AGGParser) {
            if (!this.modeStr.equals("Parser")) {
                this.lastModeStr = this.modeStr;
                this.lastMsg = this.msg;
            }
            this.modeStr = "Parser";
            this.setMode(new TextIcon("P", true), "");
            String s = "";
            if (e.getMessage().indexOf("finished") != -1) {
                if (e.getMessage().indexOf("Critical") != -1) {
                    s = " Please choice menu  - Parser / Start -  to start parsing.";
                    System.out.println(s);
                }
            } else if (e.getMessage().indexOf("back") != -1) {
                this.lastMsg = "";
                this.reset();
            }
            if (e.getMessage() != "") {
                this.setMsg(e.getMessage() + s);
            }
        }
    }

    public void parserEventOccured(ParserEvent e) {
        if (e.getMessage() != null) {
            String s = "";
            if (e.getMessage().indexOf("Starting") != -1) {
                if (!this.modeStr.equals("Parser") && !this.modeStr.equals("CriticPairs")) {
                    this.lastModeStr = this.modeStr;
                    this.lastMsg = this.msg;
                }
            } else if (e.getMessage().indexOf("Generate") != -1) {
                if (!this.modeStr.equals("Parser") && !this.modeStr.equals("CriticPairs")) {
                    this.lastModeStr = this.modeStr;
                    this.lastMsg = this.msg;
                }
            } else if (e.getMessage().indexOf("loaded") != -1) {
                if (!this.modeStr.equals("Parser") && !this.modeStr.equals("CriticPairs")) {
                    this.lastModeStr = this.modeStr;
                    this.lastMsg = this.msg;
                }
            } else if (e.getMessage().indexOf("finished") != -1) {
                s = this.modeStr.equals("Parser") && e.getMessage().indexOf("Critical") != -1 ? " Please choice menu  - Parser / Start -  to start parsing." : "";
            }
            if (!s.equals("")) {
                this.setMsg(s);
            } else {
                this.setMsg(e.getMessage());
            }
        }
    }

    public void welcome() {
        this.setMode("Hi !", "");
        this.setMsg("    Welcome to AGG - The Attributed Graph Grammar System.");
    }

    private Icon getImageIcon(int modekey) {
        Icon image = null;
        if (modekey == 11) {
            image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/draw_mode.gif"));
        } else if (modekey == 12) {
            image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/select_mode.gif"));
        } else if (modekey == 13) {
            image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/move_mode.gif"));
        } else if (modekey == 114) {
            image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/attributes_mode.gif"));
        } else if (modekey == 115) {
            image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/map_mode.gif"));
        } else if (modekey == 116) {
            image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/unmap_mode.gif"));
        } else if (modekey == 42) {
            MatchIcon matchIcon = new MatchIcon(Color.black);
            matchIcon.setEnabled(true);
            image = matchIcon;
        }
        return image;
    }

    private Icon getImageIcon(String modestr) {
        Icon image = null;
        if (modestr.equals("Draw")) {
            image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/draw_mode.gif"));
        } else if (modestr.equals("Select")) {
            image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/select_mode.gif"));
        } else if (modestr.equals("Move")) {
            image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/move_mode.gif"));
        } else if (modestr.equals("Attributes")) {
            image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/attributes_mode.gif"));
        } else if (modestr.equals("Map")) {
            image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/map_mode.gif"));
        } else if (modestr.equals("Unmap")) {
            image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/unmap_mode.gif"));
        } else if (modestr.equals("Match")) {
            MatchIcon matchIcon = new MatchIcon(Color.black);
            matchIcon.setEnabled(true);
            image = matchIcon;
        } else if (modestr.equals("Load")) {
            image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/open.gif"));
        } else if (modestr.equals("Save")) {
            image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/save.gif"));
        } else if (modestr.equals("Print")) {
            image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/print.gif"));
        } else if (modestr.equals("Parser")) {
            image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/Baustelle.gif"));
        }
        return image;
    }
}

