/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.attribute.AttrConditionTuple;
import agg.attribute.AttrContext;
import agg.attribute.AttrException;
import agg.attribute.AttrVariableTuple;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.VarMember;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdRule;
import agg.gui.GraGraTransform;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import agg.gui.event.TransformEvent;
import agg.xt_basis.CompletionPropertyBits;
import agg.xt_basis.DefaultGraTraImpl;
import agg.xt_basis.GraTra;
import agg.xt_basis.GraTraEvent;
import agg.xt_basis.GraTraEventListener;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Step;
import agg.xt_basis.Type;
import com.objectspace.jgl.Pair;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;

public class TransformDebug
implements GraTraEventListener,
EditEventListener {
    private GraGraTransform gragraTransform;
    private EdRule rule;
    private Match match;
    private OrdinaryMorphism coMorph;
    private Step step;
    private Match lastValidMatch;
    private String lastErrorMsg;
    private MorphCompletionStrategy strategy;
    private boolean matchIsValid;
    private GraTra gratra;
    private int msgGraTra;
    private boolean stepCompleted = false;
    private boolean stepInputParameterNotSet = false;
    private boolean completeInputParameterNotSet = false;
    private AttrContext ac;
    private AttrVariableTuple avt;
    private AttrConditionTuple act;
    private boolean inheritanceWarningSent = false;

    public TransformDebug(GraGraTransform transform) {
        this.gragraTransform = transform;
        this.gratra = new DefaultGraTraImpl();
        this.gratra.addGraTraListener(this);
        this.completeInputParameterNotSet = false;
        this.stepInputParameterNotSet = false;
    }

    public Vector getApplicableRules(EdGraGra gragra) {
        Vector applicableRules = gragra.getApplicableRules(this.strategy);
        Pair test = gragra.getBasisGraGra().isReadyToTransform();
        boolean testg = gragra.getBasisGraGra().isGraphReadyForTransform();
        if (test != null) {
            if (test instanceof Rule) {
                JOptionPane.showMessageDialog(null, "Something is wrong.\nPlease check attribute settings of the rule \"" + ((Rule)((Object)test)).getName() + "\".");
            }
        } else if (!testg) {
            JOptionPane.showMessageDialog(null, "Something is wrong.\nPlease check attribute settings of the host graph.");
        } else {
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 20, applicableRules));
        }
        return applicableRules;
    }

    public Vector getApplicableRules(EdGraGra gragra, boolean applicable) {
        for (int i = 0; i < gragra.getRules().size(); ++i) {
            EdRule r = (EdRule)gragra.getRules().elementAt(i);
            r.setApplicable(applicable);
        }
        this.gragraTransform.fireTransform(new TransformEvent((Object)this, 20, gragra.getRules()));
        return gragra.getRules();
    }

    public void dispose() {
        this.gratra.removeGraTraListener(this);
    }

    public void setCompletionStrategy(MorphCompletionStrategy strat) {
        this.strategy = strat;
        this.gratra.setCompletionStrategy(this.strategy);
    }

    public void setRule(EdRule r) {
        this.rule = r;
        this.ac = null;
        this.avt = null;
        this.act = null;
        if (this.gratra.getGraGra() == null || this.gratra.getGraGra() != null && this.gratra.getGraGra() != this.rule.getGraGra().getBasisGraGra()) {
            this.gratra.setGraGra(this.rule.getGraGra().getBasisGraGra());
            this.gratra.setHostGraph(this.rule.getGraGra().getBasisGraGra().getGraph());
            this.rule.getGraGra().getBasisGraGra().setGraTraOptions(this.strategy);
            this.inheritanceWarningSent = false;
        }
    }

    public Match getMatch() {
        return this.match;
    }

    public void matchDef() {
        if (this.rule == null) {
            return;
        }
        if (!this.checkIfReadyForTransform()) {
            return;
        }
        this.gragraTransform.fireTransform(new TransformEvent(this, 11));
        this.match = this.rule.getMatch();
        if (this.match == null) {
            this.newMatch();
        } else {
            Object[] options = new Object[]{"Clear", "Keep"};
            int answer = JOptionPane.showOptionDialog(null, "Do you want to clear current match?", "Warning", -1, 3, null, options, options[1]);
            if (answer == 0) {
                this.destroyMatch();
                this.gragraTransform.fireTransform(new TransformEvent(this, 5));
                this.newMatch();
            } else {
                this.gragraTransform.fireTransform(new TransformEvent(this, 6));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void nextCompletion() {
        if (this.rule == null) {
            return;
        }
        if (!this.checkIfReadyForTransform()) {
            return;
        }
        this.gragraTransform.fireTransform(new TransformEvent(this, 12));
        this.match = this.rule.getMatch();
        if (this.match == null) {
            this.completeInputParameterNotSet = true;
            this.stepInputParameterNotSet = true;
            this.newMatch();
            if (this.match.canComplete()) {
                if (!this.areAllInputParameterSet(this.rule.getLeft(), true)) return;
                this.completeInputParameterNotSet = false;
                this.matchIsValid = this.doNextCompletion();
            }
        } else if (!this.match.isTotal()) {
            this.matchIsValid = false;
            if (!this.areAllInputParameterSet(this.rule.getLeft(), true)) return;
            this.completeInputParameterNotSet = false;
            this.matchIsValid = this.doNextCompletion();
        } else {
            this.completeInputParameterNotSet = true;
            this.stepInputParameterNotSet = true;
            if (!this.areAllInputParameterSet(this.rule.getLeft(), true)) return;
            this.completeInputParameterNotSet = false;
            if (this.matchIsValid) {
                this.completeInputParameterNotSet = true;
                if (!this.areAllInputParameterSet(this.rule.getLeft(), true)) return;
                this.completeInputParameterNotSet = false;
                this.matchIsValid = this.doNextCompletion();
            } else {
                this.matchIsValid = !this.match.satisfiesAttrConditions() ? this.doNextCompletion() : (!this.match.areNACsSatisfied() ? this.doNextCompletion() : this.match.isValid());
            }
        }
        if (this.matchIsValid) {
            this.rule.update();
            this.lastValidMatch = this.match;
            this.gragraTransform.fireTransform(new TransformEvent(this, 7));
            return;
        } else {
            String msg = "";
            if (this.match != null) {
                msg = this.match.getErrorMsg();
            }
            this.destroyMatch();
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 3, msg));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void step() {
        if (this.rule == null) {
            return;
        }
        if (!this.checkIfReadyForTransform()) {
            return;
        }
        this.gragraTransform.fireTransform(new TransformEvent(this, 13));
        this.gratra.setGraTraOptions(this.gragraTransform.getGraTraOptions());
        this.match = this.rule.getMatch();
        if (this.match == null) {
            this.completeInputParameterNotSet = false;
            this.stepInputParameterNotSet = true;
            this.newMatch();
            if (this.match.canComplete()) {
                if (!this.areAllInputParameterSet(this.rule.getLeft(), true)) return;
                this.stepInputParameterNotSet = false;
                this.matchIsValid = this.doNextCompletion();
            }
        } else if (!this.match.isTotal()) {
            this.matchIsValid = false;
            if (!this.areAllInputParameterSet(this.rule.getLeft(), true)) return;
            this.stepInputParameterNotSet = false;
            this.matchIsValid = this.doNextCompletion();
            if (!this.matchIsValid) {
                String msg = this.match.getErrorMsg();
                this.destroyMatch();
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 4, msg));
                return;
            }
        } else if (this.match.equals(this.lastValidMatch)) {
            this.matchIsValid = true;
        } else {
            boolean totalNotValid = false;
            if (!this.match.areNACsSatisfied()) {
                totalNotValid = true;
            }
            if (!totalNotValid && this.match.isValid()) {
                this.matchIsValid = true;
            }
        }
        if (this.matchIsValid) {
            if (!this.areAllInputParameterSet(this.rule.getRight(), false)) return;
            this.stepInputParameterNotSet = false;
            if (this.isReadyToTransform()) {
                this.coMorph = (OrdinaryMorphism)this.gratra.apply(this.match);
                return;
            } else {
                this.destroyMatch();
            }
            return;
        } else {
            String msg = "Match is failed.";
            if (this.match != null) {
                msg = this.match.getErrorMsg();
            }
            this.destroyMatch();
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 4, msg));
        }
    }

    private void stepMatch() {
        if (this.isReadyToTransform()) {
            this.coMorph = (OrdinaryMorphism)this.gratra.apply(this.match);
        } else {
            this.destroyMatch();
        }
    }

    public void graTraEventOccurred(GraTraEvent e) {
        this.msgGraTra = e.getMessage();
        this.stepCompleted = false;
        if (this.msgGraTra == 2) {
            this.stepCompleted = true;
            this.coMorph = (OrdinaryMorphism)e.getCoMatch();
            this.rule.getGraGra().getGraph().setCoMatch(this.coMorph, this.rule);
            this.rule.getGraGra().getGraph().update();
            if (this.gragraTransform.selectNewAfterStepEnabled()) {
                this.rule.getGraGra().getGraph().updateWithCoMatch();
            }
            this.destroyMatch();
            this.rule.getGraGra().getGraph().setCoMatch(null, null);
            this.rule.getGraGra().getGraph().update();
            this.gragraTransform.fireTransform(new TransformEvent(this, 2));
        } else if (this.msgGraTra == 4) {
            String msg = this.match.getErrorMsg();
            if (this.lastErrorMsg != null && !this.lastErrorMsg.equals("")) {
                msg = msg + "\n(previous match error: \n" + this.lastErrorMsg;
            }
            if (msg.equals("")) {
                msg = e.getMessageText();
            }
            if (msg.equals("")) {
                msg = "Please check attribute values in the RHS of the rule.";
            }
            this.destroyMatch();
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 4, msg));
        } else if (this.msgGraTra == 11) {
            String msg = "Inconsistency of the host graph after the rule < " + this.rule.getBasisRule().getName() + ">  !";
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 19, msg));
        }
    }

    public void editEventOccurred(EditEvent e) {
        if (this.match == null) {
            return;
        }
        if (e.getMsg() == -3) {
            if (this.completeInputParameterNotSet) {
                this.completeInputParameterNotSet = false;
                this.nextCompletion();
            } else if (this.stepInputParameterNotSet) {
                if (!this.matchIsValid) {
                    this.stepInputParameterNotSet = false;
                    this.matchIsValid = this.doNextCompletion();
                } else {
                    this.stepInputParameterNotSet = false;
                }
            }
            if (!this.stepInputParameterNotSet) {
                if (this.matchIsValid) {
                    this.stepMatch();
                } else if (this.match != null) {
                    String msg = this.match.getErrorMsg();
                    this.destroyMatch();
                    this.gragraTransform.fireTransform(new TransformEvent((Object)this, 3, msg));
                }
            }
        }
    }

    private void newMatch() {
        this.match = this.gratra.createMatch(this.rule.getBasisRule());
        this.match.addObserver(this.rule.getLeft());
        this.match.addObserver(this.rule.getGraGra().getGraph());
        this.match.setCompletionStrategy(this.strategy);
        this.rule.setMatch(this.match);
        this.ac = this.match.getAttrContext();
        this.avt = this.ac.getVariables();
        this.act = this.ac.getConditions();
        this.matchIsValid = false;
        this.lastValidMatch = null;
    }

    private boolean doNextCompletion() {
        while (this.match != null && this.match.nextCompletion()) {
            if (this.match.isValid()) {
                this.lastErrorMsg = "";
                return true;
            }
            this.lastErrorMsg = this.match.getErrorMsg();
        }
        return false;
    }

    protected void destroyMatch() {
        if (this.match == null) {
            return;
        }
        this.rule.getGraGra().getBasisGraGra().destroyMatch(this.match);
        this.rule.setMatch(null);
        this.rule.update();
        this.rule.getGraGra().getGraph().update();
        this.match = null;
        this.lastValidMatch = null;
        this.matchIsValid = false;
    }

    private boolean areAllInputParameterSet(EdGraph g, boolean leftOfRule) {
        if (this.match == null) {
            return true;
        }
        this.ac = this.match.getAttrContext();
        this.avt = this.ac.getVariables();
        if (this.avt == null || this.avt.getNumberOfEntries() == 0) {
            return true;
        }
        if (this.avt.areInputParametersSet()) {
            return true;
        }
        this.act = this.ac.getConditions();
        for (int i = 0; i < this.avt.getNumberOfEntries(); ++i) {
            VarMember v = this.avt.getVarMemberAt(i);
            if (!v.isInputParameter() || v.isSet()) continue;
            if (g.isUsingVariable(v)) {
                int answer = this.parameterWarning();
                if (answer == 0) {
                    this.gragraTransform.fireTransform(new TransformEvent((Object)this, 1, this.match));
                }
                return false;
            }
            if (!leftOfRule) continue;
            Enumeration nacs = this.rule.getBasisRule().getNACs();
            while (nacs.hasMoreElements()) {
                OrdinaryMorphism nac = (OrdinaryMorphism)nacs.nextElement();
                if (nac.getTarget().isUsingVariable(v)) {
                    int answer = this.parameterWarning();
                    if (answer == 0) {
                        this.gragraTransform.fireTransform(new TransformEvent((Object)this, 1, this.match));
                    }
                    return false;
                }
                Vector nacVars = nac.getTarget().getVariableNamesOfAttributes();
                for (int j = 0; j < nacVars.size(); ++j) {
                    String varName = (String)nacVars.get(j);
                    for (int k = 0; k < this.act.getNumberOfEntries(); ++k) {
                        CondMember cond = (CondMember)this.act.getMemberAt(k);
                        Vector condVars = cond.getAllVariables();
                        if (!condVars.contains(varName) || !condVars.contains(v.getName())) continue;
                        int answer = this.parameterWarning();
                        if (answer == 0) {
                            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 1, this.match));
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean areAllInputParameterSet() {
        if (this.match != null) {
            this.ac = this.match.getAttrContext();
            this.avt = this.ac.getVariables();
        }
        if (this.avt == null) {
            return true;
        }
        if (!this.avt.areInputParametersSet()) {
            int answer = this.parameterWarning();
            if (answer == 0) {
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 1, this.match));
            }
            return false;
        }
        return true;
    }

    private boolean checkIfReadyForTransform() {
        Type t = this.gratra.getGraGra().doAttrTypesExist();
        if (t != null) {
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 18, "Not all attribute members of the type :  \"" + t.getName() + "\"  are declared correctly."));
            return false;
        }
        Pair p = this.gratra.getGraGra().isInheritedAttributesValid();
        if (p != null) {
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 18, (String)p.second));
            return false;
        }
        if (!this.gratra.getGraGra().getGraph().isReadyForTransform()) {
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 18, "Not all attributes of objects of the host graph are set."));
            return false;
        }
        if (!this.rule.getBasisRule().isReadyToTransform()) {
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 18, this.rule.getBasisRule().getErrorMsg()));
            return false;
        }
        p = this.gratra.getGraGra().isGraphConstraintReadyForTransform();
        if (p != null) {
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 18, (String)p.second));
            return false;
        }
        return true;
    }

    private boolean isReadyToTransform() {
        if (this.match != null) {
            this.ac = this.match.getAttrContext();
            try {
                this.ac.getVariables().getAttrManager().checkIfReadyToTransform(this.ac);
            }
            catch (AttrException ex) {
                String s = ex.getLocalizedMessage();
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 4, s));
                return false;
            }
            return true;
        }
        return false;
    }

    private void outStrategyProperties(MorphCompletionStrategy mcs) {
        System.out.println("TransformDebug.outStrategyProperties of strategy\n");
        BitSet activebits = mcs.getProperties();
        for (int i = 0; i < CompletionPropertyBits.BITNAME.length; ++i) {
            if (!activebits.get(i)) continue;
            System.out.println(CompletionPropertyBits.BITNAME[i]);
        }
    }

    private int parameterWarning() {
        Object[] options = new Object[]{"SET", "CANCEL"};
        int answer = JOptionPane.showOptionDialog(null, "Input parameter not set!\nDo you want to set parameter?", "Warning", -1, 3, null, options, options[0]);
        return answer;
    }

    private void inheritanceWarning() {
        if (this.gratra.getGraGra().getConstraints().hasMoreElements() && this.gratra.getGraGra().getTypeSet().usesInheritance()) {
            if (!this.inheritanceWarningSent) {
                this.gragraTransform.fireTransform(new TransformEvent(this, 21));
                this.inheritanceWarningSent = true;
            }
        } else {
            this.inheritanceWarningSent = false;
        }
    }
}

