/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdRule;
import agg.gui.GraGraTransform;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import agg.gui.event.TransformEvent;
import agg.xt_basis.DefaultGraTraImpl;
import agg.xt_basis.GraTra;
import agg.xt_basis.GraTraEvent;
import agg.xt_basis.GraTraEventListener;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Rule;
import javax.swing.JOptionPane;

public class TransformInterpret
extends Thread
implements GraTraEventListener,
EditEventListener {
    private GraGraTransform gragraTransform;
    private GraTra gratra;
    private int msgGraTra;
    private GraTraEvent event;
    private EdGraGra gragra;
    private EdRule edRule;
    private Rule currentRule;
    private Match currentMatch;
    private boolean inputParameterOK = false;
    private int steps;
    private boolean cancelled = false;
    private boolean stopped = false;
    private boolean showGraphAfterStep;
    private boolean inheritanceWarningSent = false;

    public TransformInterpret(GraGraTransform transform) {
        this.gragraTransform = transform;
        this.gratra = new DefaultGraTraImpl();
        this.gratra.addGraTraListener(this);
    }

    public void dispose() {
        this.gratra.removeGraTraListener(this);
    }

    public void setGraGra(EdGraGra gra) {
        this.gragra = gra;
        this.gratra.setGraGra(this.gragra.getBasisGraGra());
        this.gratra.setHostGraph(this.gragra.getBasisGraGra().getGraph());
        this.inheritanceWarningSent = false;
    }

    public void setCompletionStrategy(MorphCompletionStrategy strat) {
        this.gratra.setCompletionStrategy(strat);
    }

    public void setShowGraphAfterStep(boolean show) {
        this.showGraphAfterStep = show;
    }

    public void run() {
        this.steps = 0;
        this.cancelled = false;
        this.stopped = false;
        this.gragraTransform.fireTransform(new TransformEvent(this, 9));
        this.gratra.setGraTraOptions(this.gragraTransform.getGraTraOptions());
        this.gratra.transform();
        this.gragraTransform.fireTransform(new TransformEvent(this, 10));
    }

    public void stopping() {
        this.stopped = true;
        this.gratra.stop();
    }

    public void graTraEventOccurred(GraTraEvent e) {
        String ruleName = "";
        this.event = e;
        this.msgGraTra = e.getMessage();
        if (this.msgGraTra == 15 || this.msgGraTra == 9 || this.msgGraTra == 14 || this.msgGraTra == 10) {
            String s = e.getMessageText();
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 18, s));
        } else if (this.msgGraTra == 7) {
            this.currentMatch = this.event.getMatch();
            this.currentRule = this.currentMatch.getRule();
            ruleName = this.currentRule.getName();
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 16, " new match of  <" + ruleName + ">  is created"));
        } else if (this.msgGraTra == 1) {
            this.inputParameterOK = false;
            int answer = this.parameterWarning(this.event.getMatch().getRule().getName());
            if (answer == 0) {
                this.currentMatch = this.event.getMatch();
                this.currentRule = this.currentMatch.getRule();
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 1, this.currentMatch));
                while (!this.inputParameterOK) {
                }
            } else if (answer == 1) {
                this.gratra.stopRule();
            } else if (answer == 2) {
                this.gratra.stop();
                this.cancelled = true;
                this.gragraTransform.fireTransform(new TransformEvent(this, 8));
                this.gragraTransform.fireTransform(new TransformEvent(this, 10));
            }
        } else if (this.msgGraTra == 8) {
            this.currentMatch = this.event.getMatch();
            this.currentRule = this.currentMatch.getRule();
            ruleName = this.currentRule.getName();
            if (this.gragraTransform.waitAfterStepEnabled()) {
                this.edRule = this.gragra.getRule(this.currentRule);
                this.edRule.setMatch(this.currentMatch);
                this.edRule.update();
            }
            if (this.gragraTransform.selectNewAfterStepEnabled()) {
                this.gragra.getGraph().updateWithMatch(this.currentMatch);
            }
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 17, "  match of  <" + ruleName + ">  is valid"));
        } else if (this.msgGraTra == 2) {
            ++this.steps;
            this.currentMatch = this.event.getMatch();
            this.currentRule = this.currentMatch.getRule();
            ruleName = this.currentRule.getName();
            if (this.gragraTransform.waitAfterStepEnabled()) {
                this.edRule.setMatch(null);
                this.edRule.update();
            }
            if (this.showGraphAfterStep) {
                this.gragra.getGraph().setCoMatch(this.event.getCoMatch(), this.getRuleOfBasis(this.currentRule));
                this.gragra.getGraph().update();
                if (this.gragraTransform.selectNewAfterStepEnabled()) {
                    this.gragra.getGraph().updateWithCoMatch();
                }
            }
            this.destroyMatch();
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 2, "  <" + ruleName + ">  is applied"));
        } else if (this.msgGraTra == 3) {
            ruleName = this.event.getMatch().getRule().getName();
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 3, "  <" + ruleName + ">  is failed"));
            this.destroyMatch();
        } else if (this.msgGraTra == 6) {
            ruleName = this.event.getMessageText();
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 4, "  <" + ruleName + ">  is failed. \n(Variables / conditions of the attribute context are failed.)"));
        } else if (this.msgGraTra != 4) {
            if (this.msgGraTra == 5) {
                this.gratra.stop();
                if (!this.showGraphAfterStep) {
                    this.gragra.getGraph().update();
                }
                if (this.steps == 0 && !this.cancelled) {
                    this.gragraTransform.fireTransform(new TransformEvent(this, 4));
                }
                this.gragraTransform.fireTransform(new TransformEvent(this, 10));
            } else if (this.msgGraTra == 11) {
                ruleName = this.currentRule.getName();
                String msg = "Graph inconsistency after applying rule < " + ruleName + ">  !";
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 19, msg));
            }
        }
    }

    public void editEventOccurred(EditEvent e) {
        if (e.getMsg() == -3) {
            this.inputParameterOK = true;
        }
    }

    public boolean isSuccessful() {
        return this.steps != 0;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    private void destroyMatch() {
        EdRule r = this.getRuleOfBasis(this.currentRule);
        if (r == null) {
            return;
        }
        r.getGraGra().getBasisGraGra().destroyMatch(this.currentMatch);
        r.setMatch(null);
        r.update();
        r.getGraGra().getGraph().setCoMatch(null, null);
        r.getGraGra().getGraph().update();
    }

    private EdRule getRuleOfBasis(Rule r) {
        for (int i = 0; i < this.gragra.getRules().size(); ++i) {
            EdRule rule = (EdRule)this.gragra.getRules().elementAt(i);
            if (!rule.getBasisRule().equals(r)) continue;
            return rule;
        }
        return null;
    }

    private int parameterWarning(String ruleName) {
        Object[] options = new Object[]{"Set", "Continue", "Cancel"};
        int answer = JOptionPane.showOptionDialog(null, "Input parameter of the rule  \" " + ruleName + " \"  not set!\nDo you want to set parameter?", "Warning", -1, 2, null, options, options[1]);
        return answer;
    }

    private void inheritanceWarning() {
        if (this.gratra.getGraGra().getConstraints().hasMoreElements() && this.gratra.getGraGra().getTypeSet().usesInheritance()) {
            if (!this.inheritanceWarningSent) {
                this.gragraTransform.fireTransform(new TransformEvent(this, 21));
                this.inheritanceWarningSent = true;
            }
        } else {
            this.inheritanceWarningSent = false;
        }
    }
}

