/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdRule;
import agg.gui.GraGraLayerGUI;
import agg.gui.GraGraTransform;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import agg.gui.event.TransformEvent;
import agg.xt_basis.GraTra;
import agg.xt_basis.GraTraEvent;
import agg.xt_basis.GraTraEventListener;
import agg.xt_basis.GraTraOptions;
import agg.xt_basis.LayeredGraTraImpl;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleLayer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class TransformLayered
extends Thread
implements GraTraEventListener,
EditEventListener {
    private JFrame parent;
    private GraGraTransform gragraTransform;
    private GraTra gratra;
    private int msgGraTra;
    private GraTraEvent event;
    private EdGraGra edGragra;
    private EdRule edRule;
    private Rule currentRule;
    private Match currentMatch;
    private boolean inputParameterOK = false;
    private int steps;
    private boolean cancelled = false;
    private boolean stopped = false;
    private RuleLayer rl;
    private int extraRuns = 10;
    private boolean showGraphAfterStep;
    private boolean inheritanceWarningSent = false;

    public TransformLayered(GraGraTransform transform) {
        this.gragraTransform = transform;
        this.gratra = new LayeredGraTraImpl();
        this.gratra.addGraTraListener(this);
    }

    public void dispose() {
        this.gratra.removeGraTraListener(this);
    }

    public void setGraGra(EdGraGra gra) {
        this.edGragra = gra;
        this.gratra.setGraGra(this.edGragra.getBasisGraGra());
        this.gratra.setHostGraph(this.edGragra.getBasisGraGra().getGraph());
        this.inheritanceWarningSent = false;
    }

    public void setCompletionStrategy(MorphCompletionStrategy strat) {
        this.gratra.setCompletionStrategy(strat);
    }

    public void setParentFrame(JFrame f) {
        this.parent = f;
    }

    public void setShowGraphAfterStep(boolean show) {
        this.showGraphAfterStep = show;
    }

    public void run() {
        this.steps = 0;
        this.cancelled = false;
        this.stopped = false;
        ((LayeredGraTraImpl)this.gratra).setStopCurrentLayerOnly(this.gragraTransform.stopLayerEnabled());
        ((LayeredGraTraImpl)this.gratra).setLayeredLoop(this.gragraTransform.layeredLoopEnabled());
        this.gragraTransform.fireTransform(new TransformEvent(this, 9));
        this.layeredTransform();
        this.gragraTransform.fireTransform(new TransformEvent(this, 10));
    }

    public void stopping() {
        if (!this.gragraTransform.stopLayerEnabled()) {
            this.stopped = true;
        }
        ((LayeredGraTraImpl)this.gratra).stop();
    }

    public void nextLayer() {
        ((LayeredGraTraImpl)this.gratra).nextLayer();
    }

    private void layeredTransform() {
        this.gratra.setGraTraOptions(this.gragraTransform.getGraTraOptions());
        GraTraOptions gratraOptions = this.gratra.getGraTraOptions();
        gratraOptions.addOption("layered");
        this.edGragra.getBasisGraGra().setGraTraOptions(this.gragraTransform.getGraTraOptionsList());
        this.rl = new RuleLayer(this.edGragra.getBasisGraGra().getRules());
        if (this.gragraTransform.showLayerEnabled()) {
            GraGraLayerGUI lg = new GraGraLayerGUI(this.parent, this.rl);
            lg.setGraGra(this.edGragra);
            lg.showGUI();
            if (lg.isCancelled()) {
                this.rl = new RuleLayer(this.edGragra.getBasisGraGra().getRules());
            }
        }
        this.edGragra.getBasisGraGra().setRuleLayer(this.rl);
        this.gratra.transform();
    }

    public void graTraEventOccurred(GraTraEvent e) {
        String ruleName = "";
        this.event = e;
        this.msgGraTra = e.getMessage();
        if (this.msgGraTra == 15 || this.msgGraTra == 9 || this.msgGraTra == 14 || this.msgGraTra == 10) {
            String s = e.getMessageText();
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 18, s));
        } else if (this.msgGraTra == 7) {
            this.currentMatch = this.event.getMatch();
            this.currentRule = this.currentMatch.getRule();
            ruleName = this.currentRule.getName();
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 16, " new match of  <" + ruleName + ">  is created"));
        } else if (this.msgGraTra == 1) {
            this.inputParameterOK = false;
            int answer = this.parameterWarning();
            if (answer == 0) {
                this.currentMatch = this.event.getMatch();
                this.currentRule = this.currentMatch.getRule();
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 1, this.currentMatch));
                while (!this.inputParameterOK) {
                }
            } else if (answer == 1) {
                this.gratra.stopRule();
            } else if (answer == 2) {
                this.gratra.stop();
                this.cancelled = true;
                this.gragraTransform.fireTransform(new TransformEvent(this, 8));
                this.gragraTransform.fireTransform(new TransformEvent(this, 10));
            }
        } else if (this.msgGraTra == 8) {
            this.currentMatch = this.event.getMatch();
            this.currentRule = this.currentMatch.getRule();
            ruleName = this.currentRule.getName();
            if (this.gragraTransform.waitAfterStepEnabled()) {
                this.edRule = this.edGragra.getRule(this.currentRule);
                this.edRule.setMatch(this.currentMatch);
                this.edRule.update();
            }
            if (this.gragraTransform.selectNewAfterStepEnabled()) {
                this.edGragra.getGraph().updateWithMatch(this.currentMatch);
            }
            this.gragraTransform.fireTransform(new TransformEvent(this, 17, this.edRule, "  match of  <" + ruleName + ">  is valid"));
        } else if (this.msgGraTra == 2) {
            ++this.steps;
            this.currentMatch = this.event.getMatch();
            this.currentRule = this.currentMatch.getRule();
            ruleName = this.currentRule.getName();
            if (this.gragraTransform.waitAfterStepEnabled()) {
                this.edRule.setMatch(null);
                this.edRule.update();
            }
            if (this.showGraphAfterStep) {
                this.edGragra.getGraph().setCoMatch(this.event.getCoMatch(), this.getRuleOfBase(this.currentRule));
                this.edGragra.getGraph().update();
                if (this.gragraTransform.selectNewAfterStepEnabled()) {
                    this.edGragra.getGraph().updateWithCoMatch();
                }
                this.destroyMatch();
            }
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 2, "  <" + ruleName + ">  is applied"));
        } else if (this.msgGraTra == 3) {
            ruleName = this.event.getMatch().getRule().getName();
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 3, "  <" + ruleName + ">  is failed. \n(Variables / conditions of the rule context failed.)"));
        } else if (this.msgGraTra != 6 && this.msgGraTra != 4) {
            if (this.msgGraTra == 16) {
                this.gragraTransform.fireTransform(new TransformEvent(this, 22));
            } else if (this.msgGraTra == 5) {
                this.gratra.stop();
                if (!this.showGraphAfterStep) {
                    this.edGragra.getGraph().update();
                }
                if (this.steps == 0 && !this.cancelled) {
                    this.gragraTransform.fireTransform(new TransformEvent(this, 4));
                }
                this.gragraTransform.fireTransform(new TransformEvent(this, 10));
            } else if (this.msgGraTra == 11) {
                ruleName = this.currentRule.getName();
                String msg = "Graph inconsistency after applying rule < " + ruleName + ">  !";
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 19, msg));
            }
        }
    }

    public void editEventOccurred(EditEvent e) {
        if (e.getMsg() == -3) {
            this.inputParameterOK = true;
        }
    }

    public boolean isSuccessful() {
        return this.steps != 0;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    private void destroyMatch() {
        EdRule r = this.getRuleOfBase(this.currentRule);
        r.setMatch(null);
        r.update();
        r.getGraGra().getGraph().setCoMatch(null, null);
        r.getGraGra().getGraph().update();
    }

    private EdRule getRuleOfBase(Rule r) {
        for (int i = 0; i < this.edGragra.getRules().size(); ++i) {
            EdRule rule = (EdRule)this.edGragra.getRules().elementAt(i);
            if (!rule.getBasisRule().equals(r)) continue;
            return rule;
        }
        return null;
    }

    private int parameterWarning() {
        Object[] options = new Object[]{"Set", "Continue", "Cancel"};
        int answer = JOptionPane.showOptionDialog(null, "Input parameter not set!\nDo you want to set parameter?", "Warning", -1, 2, null, options, options[1]);
        return answer;
    }

    private void inheritanceWarning() {
        if (this.gratra.getGraGra().getConstraints().hasMoreElements() && this.gratra.getGraGra().getTypeSet().usesInheritance()) {
            if (!this.inheritanceWarningSent) {
                this.gragraTransform.fireTransform(new TransformEvent(this, 21));
                this.inheritanceWarningSent = true;
            }
        } else {
            this.inheritanceWarningSent = false;
        }
    }
}

