/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.xt_basis.Type;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TypeCardinalityGUI
extends JDialog
implements ActionListener,
DocumentListener {
    private JTextField textSrcMin;
    private JTextField textSrcMax;
    private JTextField textTrgMin;
    private JTextField textTrgMax;
    private String stringSrcMin;
    private String stringSrcMax;
    private String stringTrgMin;
    private String stringTrgMax;
    private JButton closeButton;
    private JButton cancelButton;
    private boolean isCanceled;
    private Type type;
    private Type sourceType;
    private Type targetType;
    private int srcMin = 1;
    private int trgMin = 1;
    private int srcMax = 1;
    private int trgMax = 1;
    private String name = "";
    private boolean multiplicityOK;
    private boolean isEdgeType = true;

    public TypeCardinalityGUI(JFrame parent, Type arcType, Type sourceType, Type targetType) {
        super((Frame)parent, true);
        this.isEdgeType = true;
        this.name = arcType.getStringRepr();
        this.multiplicityOK = false;
        if (this.name.equals("")) {
            this.name = "unnamed";
        }
        this.setTitle(" Multiplicity of Edge Type < " + this.name + " > ");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TypeCardinalityGUI.this.exitForm(evt);
            }
        });
        this.type = arcType;
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.srcMax = arcType.getSourceMax(sourceType, targetType);
        this.srcMin = arcType.getSourceMin(sourceType, targetType);
        this.trgMax = arcType.getTargetMax(sourceType, targetType);
        this.trgMin = arcType.getTargetMin(sourceType, targetType);
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(screenSize.width / 2 - 200, screenSize.height / 2 - 200);
        }
        this.initComponentsToEdgeType();
    }

    public TypeCardinalityGUI(JFrame parent, Type nodeType) {
        super((Frame)parent, true);
        this.isEdgeType = false;
        this.name = nodeType.getStringRepr();
        this.multiplicityOK = false;
        if (this.name.equals("")) {
            this.name = "unnamed";
        }
        this.setTitle(" Multiplicity of Node Type < " + this.name + " > ");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TypeCardinalityGUI.this.exitForm(evt);
            }
        });
        this.type = nodeType;
        this.sourceType = null;
        this.targetType = null;
        this.srcMax = nodeType.getSourceMax();
        this.srcMin = nodeType.getSourceMin();
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(screenSize.width / 2 - 200, screenSize.height / 2 - 200);
        }
        this.initComponentsToNodeType();
    }

    private void initComponentsToEdgeType() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBackground(Color.lightGray);
        JPanel multiplicityPanel = new JPanel(new GridBagLayout());
        JPanel panelSrc = new JPanel(new BorderLayout());
        panelSrc.setBorder(new TitledBorder("  Source of < " + this.name + " > "));
        panelSrc.setBackground(Color.orange);
        JPanel contentSrc = new JPanel(new GridBagLayout());
        panelSrc.add(contentSrc);
        JPanel panelSrcMin = new JPanel(new BorderLayout());
        JLabel label = new JLabel(" min ");
        this.textSrcMin = new JTextField(5);
        if (this.srcMin == -1) {
            this.stringSrcMin = "";
            this.textSrcMin.setText(this.stringSrcMin);
        } else {
            this.stringSrcMin = new Integer(this.srcMin).toString();
            this.textSrcMin.setText(this.stringSrcMin);
        }
        this.textSrcMin.addActionListener(this);
        this.textSrcMin.getDocument().addDocumentListener(this);
        panelSrcMin.add((Component)label, "North");
        panelSrcMin.add((Component)this.textSrcMin, "Center");
        JPanel panelSrcMax = new JPanel(new BorderLayout());
        label = new JLabel(" max ");
        this.textSrcMax = new JTextField(5);
        if (this.srcMax == -1) {
            this.stringSrcMax = "";
            this.textSrcMax.setText(this.stringSrcMax);
        } else {
            this.stringSrcMax = new Integer(this.srcMax).toString();
            this.textSrcMax.setText(this.stringSrcMax);
        }
        this.textSrcMax.addActionListener(this);
        this.textSrcMax.getDocument().addDocumentListener(this);
        panelSrcMax.add((Component)label, "North");
        panelSrcMax.add((Component)this.textSrcMax, "Center");
        this.constrainBuild(contentSrc, panelSrcMin, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 10, 10, 10, 5);
        this.constrainBuild(contentSrc, panelSrcMax, 1, 0, 1, 1, 1, 10, 1.0, 0.0, 10, 5, 10, 10);
        JPanel panelTrg = new JPanel(new BorderLayout());
        panelTrg.setBorder(new TitledBorder("  Target of < " + this.name + " > "));
        panelTrg.setBackground(Color.orange);
        JPanel contentTrg = new JPanel(new GridBagLayout());
        panelTrg.add(contentTrg);
        JPanel panelTrgMin = new JPanel(new BorderLayout());
        label = new JLabel(" min ");
        this.textTrgMin = new JTextField(5);
        if (this.trgMin == -1) {
            this.stringTrgMin = "";
            this.textTrgMin.setText(this.stringTrgMin);
        } else {
            this.stringTrgMin = new Integer(this.trgMin).toString();
            this.textTrgMin.setText(this.stringTrgMin);
        }
        this.textTrgMin.addActionListener(this);
        this.textTrgMin.getDocument().addDocumentListener(this);
        panelTrgMin.add((Component)label, "North");
        panelTrgMin.add((Component)this.textTrgMin, "Center");
        JPanel panelTrgMax = new JPanel(new BorderLayout());
        label = new JLabel(" max ");
        this.textTrgMax = new JTextField(5);
        if (this.trgMax == -1) {
            this.stringTrgMax = "";
            this.textTrgMax.setText(this.stringTrgMax);
        } else {
            this.stringTrgMax = new Integer(this.trgMax).toString();
            this.textTrgMax.setText(this.stringTrgMax);
        }
        this.textTrgMax.addActionListener(this);
        this.textTrgMax.getDocument().addDocumentListener(this);
        panelTrgMax.add((Component)label, "North");
        panelTrgMax.add((Component)this.textTrgMax, "Center");
        this.constrainBuild(contentTrg, panelTrgMin, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 10, 10, 10, 5);
        this.constrainBuild(contentTrg, panelTrgMax, 1, 0, 1, 1, 1, 10, 1.0, 0.0, 10, 5, 10, 10);
        this.constrainBuild(multiplicityPanel, panelSrc, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 20, 20, 10, 10);
        this.constrainBuild(multiplicityPanel, panelTrg, 1, 0, 1, 1, 1, 10, 1.0, 0.0, 20, 10, 10, 20);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        this.closeButton = new JButton();
        this.closeButton.setActionCommand("ok");
        this.closeButton.setText("Set");
        this.closeButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.isCanceled = false;
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(this);
        this.constrainBuild(buttonPanel, this.closeButton, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 30, 20, 20);
        this.constrainBuild(buttonPanel, this.cancelButton, 1, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 50, 20, 30);
        contentPane.add((Component)multiplicityPanel, "Center");
        contentPane.add((Component)buttonPanel, "South");
        contentPane.revalidate();
        this.setContentPane(contentPane);
        this.setDefaultCloseOperation(0);
        this.validate();
        this.pack();
    }

    private void initComponentsToNodeType() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBackground(Color.lightGray);
        JPanel multiplicityPanel = new JPanel(new BorderLayout());
        JPanel contentSrc = new JPanel(new GridBagLayout());
        JPanel panelSrcMin = new JPanel(new BorderLayout());
        JLabel labelMin = new JLabel(" min ");
        this.textSrcMin = new JTextField(5);
        if (this.srcMin == -1) {
            this.stringSrcMin = "";
            this.textSrcMin.setText(this.stringSrcMin);
        } else {
            this.stringSrcMin = new Integer(this.srcMin).toString();
            this.textSrcMin.setText(this.stringSrcMin);
        }
        this.textSrcMin.addActionListener(this);
        this.textSrcMin.getDocument().addDocumentListener(this);
        panelSrcMin.add((Component)labelMin, "North");
        panelSrcMin.add((Component)this.textSrcMin, "Center");
        JPanel panelSrcMax = new JPanel(new BorderLayout());
        JLabel labelMax = new JLabel(" max ");
        this.textSrcMax = new JTextField(5);
        if (this.srcMax == -1) {
            this.stringSrcMax = "";
            this.textSrcMax.setText(this.stringSrcMax);
        } else {
            this.stringSrcMax = new Integer(this.srcMax).toString();
            this.textSrcMax.setText(this.stringSrcMax);
        }
        this.textSrcMax.addActionListener(this);
        this.textSrcMax.getDocument().addDocumentListener(this);
        panelSrcMax.add((Component)labelMax, "North");
        panelSrcMax.add((Component)this.textSrcMax, "Center");
        this.constrainBuild(contentSrc, panelSrcMin, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 10, 10, 10, 5);
        this.constrainBuild(contentSrc, panelSrcMax, 1, 0, 1, 1, 1, 10, 1.0, 0.0, 10, 5, 10, 10);
        multiplicityPanel.add((Component)contentSrc, "Center");
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        this.closeButton = new JButton();
        this.closeButton.setActionCommand("ok");
        this.closeButton.setText("Set");
        this.closeButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.isCanceled = false;
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(this);
        this.constrainBuild(buttonPanel, this.closeButton, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 30, 20, 20);
        this.constrainBuild(buttonPanel, this.cancelButton, 1, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 50, 20, 30);
        contentPane.add((Component)multiplicityPanel, "Center");
        contentPane.add((Component)buttonPanel, "South");
        contentPane.revalidate();
        this.setContentPane(contentPane);
        this.setDefaultCloseOperation(0);
        this.validate();
        this.pack();
    }

    public void insertUpdate(DocumentEvent e) {
        if (e.getDocument() == this.textSrcMin.getDocument()) {
            Document d = this.textSrcMin.getDocument();
            try {
                this.stringSrcMin = d.getText(0, d.getLength());
            }
            catch (BadLocationException ex) {}
        } else if (e.getDocument() == this.textSrcMax.getDocument()) {
            Document d = this.textSrcMax.getDocument();
            try {
                this.stringSrcMax = d.getText(0, d.getLength());
            }
            catch (BadLocationException ex) {}
        } else if (e.getDocument() == this.textTrgMin.getDocument()) {
            Document d = this.textTrgMin.getDocument();
            try {
                this.stringTrgMin = d.getText(0, d.getLength());
            }
            catch (BadLocationException ex) {}
        } else if (e.getDocument() == this.textTrgMax.getDocument()) {
            Document d = this.textTrgMax.getDocument();
            try {
                this.stringTrgMax = d.getText(0, d.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (e.getDocument() == this.textSrcMin.getDocument()) {
            Document d = this.textSrcMin.getDocument();
            try {
                this.stringSrcMin = d.getText(0, d.getLength());
            }
            catch (BadLocationException ex) {}
        } else if (e.getDocument() == this.textSrcMax.getDocument()) {
            Document d = this.textSrcMax.getDocument();
            try {
                this.stringSrcMax = d.getText(0, d.getLength());
            }
            catch (BadLocationException ex) {}
        } else if (e.getDocument() == this.textTrgMin.getDocument()) {
            Document d = this.textTrgMin.getDocument();
            try {
                this.stringTrgMin = d.getText(0, d.getLength());
            }
            catch (BadLocationException ex) {}
        } else if (e.getDocument() == this.textTrgMax.getDocument()) {
            Document d = this.textTrgMax.getDocument();
            try {
                this.stringTrgMax = d.getText(0, d.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.textSrcMin) {
            this.srcMin = this.convertTextField(this.textSrcMin, this.stringSrcMin);
        } else if (source == this.textSrcMax) {
            this.srcMax = this.convertTextField(this.textSrcMax, this.stringSrcMax);
        } else if (source == this.textTrgMin) {
            this.trgMin = this.convertTextField(this.textTrgMin, this.stringTrgMin);
        } else if (source == this.textTrgMax) {
            this.trgMax = this.convertTextField(this.textTrgMax, this.stringTrgMax);
        }
        if (source == this.closeButton) {
            this.srcMin = this.convertTextField(this.textSrcMin, this.stringSrcMin);
            this.srcMax = this.convertTextField(this.textSrcMax, this.stringSrcMax);
            this.trgMin = this.convertTextField(this.textTrgMin, this.stringTrgMin);
            this.trgMax = this.convertTextField(this.textTrgMax, this.stringTrgMax);
            if (!(this.srcMin != -1 && this.srcMin < 0 || this.srcMax != -1 && this.srcMax < 0 || this.trgMin != -1 && this.trgMin < 0 || this.trgMax != -1 && this.trgMax < 0)) {
                if (this.isEdgeType) {
                    if (this.srcMin != this.type.getSourceMin(this.sourceType, this.targetType) || this.srcMax != this.type.getSourceMax(this.sourceType, this.targetType) || this.trgMin != this.type.getTargetMin(this.sourceType, this.targetType) || this.trgMax != this.type.getTargetMax(this.sourceType, this.targetType)) {
                        JOptionPane.showMessageDialog(null, "You have changed multiplicity of the edge type.\nPlease do not forget to check your grammar against the type graph. ");
                    }
                    this.type.setSourceMin(this.sourceType, this.targetType, this.srcMin);
                    this.type.setSourceMax(this.sourceType, this.targetType, this.srcMax);
                    this.type.setTargetMin(this.sourceType, this.targetType, this.trgMin);
                    this.type.setTargetMax(this.sourceType, this.targetType, this.trgMax);
                } else {
                    if (this.srcMin != this.type.getSourceMin() || this.srcMax != this.type.getSourceMax()) {
                        int val = this.checkMaxOfParentNode(this.srcMax);
                        if (val != this.srcMax) {
                            JOptionPane.showMessageDialog(null, "Max value of a child node type should not exceed the max value of its parent.");
                            this.srcMax = val;
                        } else {
                            JOptionPane.showMessageDialog(null, "You have changed multiplicity of the node type.\nPlease do not forget to check your grammar against the type graph. ");
                        }
                    }
                    this.type.setSourceMin(this.srcMin);
                    this.type.setSourceMax(this.srcMax);
                }
                this.multiplicityOK = true;
                this.setVisible(false);
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(null, "Bad multiplicity. It has to be >= 0 or empty.");
            }
        } else if (source == this.cancelButton) {
            this.isCanceled = true;
            this.setVisible(false);
            this.dispose();
        }
    }

    private int convertTextField(JTextField textField, String text) {
        String str = text;
        int result = -100;
        if (str == null || str.equals("") || str.equals("*")) {
            result = -1;
        } else {
            try {
                Integer i = new Integer(str);
                result = i;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean isMultiplicitySet() {
        return this.multiplicityOK;
    }

    public JButton getSetButton() {
        return this.closeButton;
    }

    public void showGUI() {
        this.setVisible(true);
    }

    public boolean wasCanceled() {
        return this.isCanceled;
    }

    private int checkMaxOfParentNode(int value) {
        int res = value;
        Vector v = this.type.getAllParents();
        for (int i = 1; i < v.size(); ++i) {
            Type t = (Type)v.get(i);
            if (t.getSourceMax() != -1) {
                if (value != -1) {
                    if (value > t.getSourceMax()) {
                        res = t.getSourceMax();
                    }
                } else {
                    res = t.getSourceMax();
                }
            }
            if (res != value) break;
        }
        return res;
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }
}

