/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdType;
import agg.editor.impl.EdTypeSet;
import agg.gui.ArcTypeComboBox;
import agg.gui.NodeTypeComboBox;
import agg.gui.TypePalette;
import agg.gui.event.TypeEvent;
import agg.gui.event.TypeEventListener;
import agg.gui.icons.CircleShapeIcon;
import agg.gui.icons.ColorDashLineIcon;
import agg.gui.icons.ColorDotLineIcon;
import agg.gui.icons.ColorSolidLineIcon;
import agg.gui.icons.OvalShapeIcon;
import agg.gui.icons.RectShapeIcon;
import agg.gui.icons.RoundRectShapeIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class TypeEditor
extends JPanel
implements TypeEventListener {
    private JFrame applFrame;
    private NodeTypeComboBox nodeTypeBox;
    private ArcTypeComboBox arcTypeBox;
    private EdGraGra gragra;
    private Vector typeEventListeners;
    private TypePalette palette;

    public TypeEditor() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        JPanel p = new JPanel(new GridLayout(0, 2, 2, 2));
        JPanel p1 = new JPanel(new BorderLayout());
        p1.setBorder(new TitledBorder(" Node  Type  Editor "));
        this.nodeTypeBox = new NodeTypeComboBox();
        p1.add((Component)this.nodeTypeBox, "North");
        JPanel p2 = new JPanel(new BorderLayout());
        p2.setBorder(new TitledBorder(" Edge  Type  Editor "));
        this.arcTypeBox = new ArcTypeComboBox();
        p2.add((Component)this.arcTypeBox, "North");
        p.add(p1);
        p.add(p2);
        this.add(p);
        this.palette = new TypePalette(this.applFrame, this);
    }

    public NodeTypeComboBox getNodeTypeBox() {
        return this.nodeTypeBox;
    }

    public ArcTypeComboBox getArcTypeBox() {
        return this.arcTypeBox;
    }

    public TypePalette getTypePalette() {
        return this.palette;
    }

    public void setGraGra(EdGraGra gra) {
        this.gragra = gra;
        this.nodeTypeBox.getCustomModel().removeAllItems();
        this.arcTypeBox.getCustomModel().removeAllItems();
        if (this.gragra == null) {
            return;
        }
        this.gragra.getTypeSet().addTypeEventListener(this);
        this.nodeTypeBox.setGraGra(this.gragra);
        this.arcTypeBox.setGraGra(this.gragra);
        this.reinitializeTypes();
    }

    public void refreshTypes() {
        this.nodeTypeBox.getCustomModel().removeAllItems();
        this.arcTypeBox.getCustomModel().removeAllItems();
        this.reinitializeTypes();
    }

    private void reinitializeTypes() {
        int indx;
        int i;
        EdType et = null;
        if (this.gragra.getNodeTypes().size() != 0) {
            Icon nodeTypeIcon = null;
            for (i = 0; i < this.gragra.getNodeTypes().size(); ++i) {
                et = (EdType)this.gragra.getNodeTypes().elementAt(i);
                nodeTypeIcon = this.getNodeTypeIcon(et);
                this.nodeTypeBox.getCustomModel().addItem(et, new JLabel(et.getName(), nodeTypeIcon, 2), false);
            }
            indx = this.nodeTypeBox.getCustomModel().getSelectedIndex();
            if (indx >= 0 && indx < this.gragra.getNodeTypes().size()) {
                et = (EdType)this.gragra.getNodeTypes().elementAt(indx);
                this.gragra.setSelectedNodeType(et);
            }
            this.nodeTypeBox.getCustom().getEditor().setItem(et.getName());
            this.nodeTypeBox.getPopupMenu().setSelectedColor(et.color);
            this.nodeTypeBox.getPopupMenu().setSelectedShape(et.shape);
            this.nodeTypeBox.getPopupMenu().setImageFileName(et.imageFileName);
            nodeTypeIcon = this.getNodeTypeIcon(et);
            this.nodeTypeBox.setTypeIcon(nodeTypeIcon);
        }
        if (this.gragra.getArcTypes().size() != 0) {
            Icon arcTypeIcon = null;
            for (i = 0; i < this.gragra.getArcTypes().size(); ++i) {
                et = (EdType)this.gragra.getArcTypes().elementAt(i);
                arcTypeIcon = this.getArcTypeIcon(et);
                this.arcTypeBox.getCustomModel().addItem(et, new JLabel(et.getName(), arcTypeIcon, 2), false);
            }
            indx = this.arcTypeBox.getCustomModel().getSelectedIndex();
            if (indx >= 0 && indx < this.gragra.getArcTypes().size()) {
                et = (EdType)this.gragra.getArcTypes().elementAt(indx);
                this.gragra.setSelectedArcType(et);
            }
            this.arcTypeBox.getCustom().getEditor().setItem(et.getName());
            this.arcTypeBox.getPopupMenu().setSelectedColor(et.color);
            this.arcTypeBox.getPopupMenu().setSelectedShape(et.shape);
            arcTypeIcon = this.getArcTypeIcon(et);
            this.arcTypeBox.setTypeIcon(arcTypeIcon);
        }
        this.palette.setTypes(this.nodeTypeBox.getNodeTypes(), this.arcTypeBox.getArcTypes());
        this.nodeTypeBox.setTypePalette(this.palette);
        this.arcTypeBox.setTypePalette(this.palette);
    }

    public synchronized void addTypeEventListener(TypeEventListener l) {
        Vector v;
        Vector vector = v = this.typeEventListeners == null ? new Vector(2) : (Vector)this.typeEventListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.typeEventListeners = v;
        }
        this.nodeTypeBox.addTypeEventListener(l);
        this.arcTypeBox.addTypeEventListener(l);
    }

    public synchronized void removeTypeEventListener(TypeEventListener l) {
        if (this.typeEventListeners != null && this.typeEventListeners.contains(l)) {
            Vector v = (Vector)this.typeEventListeners.clone();
            v.removeElement(l);
            this.typeEventListeners = v;
        }
        this.nodeTypeBox.removeTypeEventListener(l);
        this.arcTypeBox.removeTypeEventListener(l);
    }

    private void fireTypeEvent(TypeEvent e) {
        if (this.typeEventListeners != null) {
            Vector listeners = this.typeEventListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((TypeEventListener)listeners.elementAt(i)).typeEventOccurred(e);
            }
        }
    }

    public void removeAll() {
        this.nodeTypeBox.getCustomModel().removeAllItems();
        this.nodeTypeBox.setGraGra(null);
        this.arcTypeBox.getCustomModel().removeAllItems();
        this.arcTypeBox.setGraGra(null);
        this.palette.clear();
    }

    public void setFrame(JFrame f) {
        this.applFrame = f;
        this.nodeTypeBox.setFrame(f);
    }

    private Icon getNodeTypeIcon(EdType et) {
        Icon icon = null;
        switch (et.shape) {
            case 51: {
                icon = new RectShapeIcon(et.color);
                break;
            }
            case 54: {
                icon = new RoundRectShapeIcon(et.color);
                break;
            }
            case 52: {
                icon = new CircleShapeIcon(et.color);
                break;
            }
            case 53: {
                icon = new OvalShapeIcon(et.color);
                break;
            }
        }
        return icon;
    }

    private Icon getArcTypeIcon(EdType et) {
        Icon icon = null;
        switch (et.shape) {
            case 61: {
                icon = new ColorSolidLineIcon(et.color);
                break;
            }
            case 62: {
                icon = new ColorDashLineIcon(et.color);
                break;
            }
            case 63: {
                icon = new ColorDotLineIcon(et.color);
                break;
            }
        }
        return icon;
    }

    public void typeEventOccurred(TypeEvent e) {
        if (e.getSource() instanceof EdTypeSet && (e.getMsg() == 3 || e.getMsg() == 11)) {
            this.nodeTypeBox.getCustomModel().removeAllItems();
            this.arcTypeBox.getCustomModel().removeAllItems();
            this.reinitializeTypes();
        }
    }
}

