/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.gui.GraGraTreeView;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TypeGraphPopupMenu
extends JPopupMenu {
    private JMenuItem disabled;
    private JMenuItem enabled;
    private JMenuItem enabledMax;
    private JMenuItem enabledMaxMin;
    private GraGraTreeView treeView;

    public TypeGraphPopupMenu(GraGraTreeView tree) {
        super("Type Graph");
        this.treeView = tree;
        ButtonGroup states = new ButtonGroup();
        this.disabled = new JRadioButtonMenuItem("disabled");
        this.disabled.setActionCommand("checkTypeGraph.DISABLED");
        this.disabled.addActionListener(this.treeView);
        states.add(this.disabled);
        this.add(this.disabled);
        this.enabled = new JRadioButtonMenuItem("enabled");
        this.enabled.setActionCommand("checkTypeGraph.ENABLED");
        this.enabled.addActionListener(this.treeView);
        states.add(this.enabled);
        this.add(this.enabled);
        this.enabledMax = new JRadioButtonMenuItem("enabled with max");
        this.enabledMax.setActionCommand("checkTypeGraph.ENABLED_MAX");
        this.enabledMax.addActionListener(this.treeView);
        states.add(this.enabledMax);
        this.add(this.enabledMax);
        this.enabledMaxMin = new JRadioButtonMenuItem("enabled with min and max");
        this.enabledMaxMin.setActionCommand("checkTypeGraph.ENABLED_MAX_MIN");
        this.enabledMaxMin.addActionListener(this.treeView);
        states.add(this.enabledMaxMin);
        this.add(this.enabledMaxMin);
        this.addSeparator();
        JMenuItem mi = this.add(new JMenuItem("Delete                  Delete"));
        mi.setActionCommand("deleteTypeGraph");
        mi.addActionListener(this.treeView);
        this.pack();
        this.setBorderPainted(true);
    }

    public boolean invoked(int x, int y) {
        if (this.treeView == null) {
            return false;
        }
        if (this.treeView.getTree().getRowForLocation(x, y) != -1 && this.treeView.getTree().getPathForLocation(x, y).getPath().length == 3) {
            TreePath path = this.treeView.getTree().getPathForLocation(x, y);
            EdGraph graph = this.treeView.getGraph((DefaultMutableTreeNode)path.getLastPathComponent());
            EdGraGra gragra = this.treeView.getGraGra((DefaultMutableTreeNode)path.getPathComponent(1));
            if (graph != null && graph.isTypeGraph() && gragra != null) {
                int level = gragra.getLevelOfTypeGraphCheck();
                if (level == 0) {
                    this.disabled.setSelected(true);
                } else if (level == 10) {
                    this.enabled.setSelected(true);
                } else if (level == 20) {
                    this.enabledMax.setSelected(true);
                } else if (level == 30) {
                    this.enabledMaxMin.setSelected(true);
                } else {
                    this.disabled.setSelected(false);
                    this.enabled.setSelected(false);
                    this.enabledMax.setSelected(false);
                    this.enabledMaxMin.setSelected(false);
                }
                return true;
            }
        }
        return false;
    }
}

