/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.gui.TypeEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;

public class TypePalette
extends JPanel
implements MouseListener {
    private JFrame parent;
    private Vector nodeTypes;
    private Vector edgeTypes;
    private JList nodeTypeList;
    private JList edgeTypeList;
    JScrollPane scrollPane1;
    JScrollPane scrollPane2;
    JSplitPane splitPane;
    private Hashtable table1;
    private Hashtable table2;
    private TypeEditor typeEditor;
    private int dividerLocation = 0;
    private int width;

    public TypePalette(JFrame parent, TypeEditor typeeditor) {
        this.parent = parent;
        this.typeEditor = typeeditor;
        this.nodeTypes = new Vector();
        this.edgeTypes = new Vector();
        this.table1 = new Hashtable();
        this.table2 = new Hashtable();
        this.splitPane = new JSplitPane(0, null, null);
        this.add((Component)this.splitPane, "Center");
        this.validate();
        ComponentAdapter cl = new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                System.out.println("TypePalette.componentResized ...");
                TypePalette.this.width = TypePalette.this.splitPane.getWidth();
            }
        };
        this.addComponentListener(cl);
    }

    public void setTypes(Vector nodetypes, Vector edgetypes) {
        this.splitPane.setTopComponent(null);
        this.splitPane.setBottomComponent(null);
        this.setNodeTypes(nodetypes);
        this.setEdgeTypes(edgetypes);
        this.nodeTypeList = this.createTypeList(this.table1, nodetypes);
        try {
            this.scrollPane1 = new JScrollPane(this.nodeTypeList, 20, 30);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        this.scrollPane1.setBorder(new TitledBorder("Node Types"));
        this.edgeTypeList = this.createTypeList(this.table2, edgetypes);
        try {
            this.scrollPane2 = new JScrollPane(this.edgeTypeList, 20, 30);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.scrollPane2.setBorder(new TitledBorder("Edge Types"));
        this.nodeTypeList.setSelectedIndex(this.nodeTypeList.getModel().getSize() - 1);
        this.edgeTypeList.setSelectedIndex(this.edgeTypeList.getModel().getSize() - 1);
        this.splitPane.setTopComponent(this.scrollPane1);
        this.splitPane.setBottomComponent(this.scrollPane2);
        this.splitPane.revalidate();
        if (this.dividerLocation == 0) {
            this.splitPane.setDividerLocation(this.getHeight() / 2);
        }
    }

    public boolean isEmpty() {
        return this.nodeTypes.isEmpty() && this.edgeTypes.isEmpty();
    }

    public void clear() {
        this.nodeTypes.clear();
        this.edgeTypes.clear();
        this.table1.clear();
        this.table2.clear();
        this.nodeTypeList.removeAll();
        this.edgeTypeList.removeAll();
        this.splitPane.setTopComponent(null);
        this.splitPane.setBottomComponent(null);
    }

    public void setDividerLocation(int d) {
        this.splitPane.setDividerLocation(d);
        this.dividerLocation = this.splitPane.getDividerLocation();
    }

    public int getDividerLocation() {
        if (this.dividerLocation != 0 && this.dividerLocation != this.splitPane.getDividerLocation()) {
            this.dividerLocation = this.splitPane.getDividerLocation();
        }
        return this.dividerLocation;
    }

    public Component getSplitComponent() {
        return this.splitPane;
    }

    public int getWidthOfPalette() {
        return this.width;
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 500);
    }

    public JList getNodeTypeList() {
        return this.nodeTypeList;
    }

    public JList getEdgeTypeList() {
        return this.edgeTypeList;
    }

    public void setSelectedNodeTypeIndex(int index) {
        this.nodeTypeList.setSelectedIndex(index);
    }

    public void setSelectedEdgeTypeIndex(int index) {
        this.edgeTypeList.setSelectedIndex(index);
    }

    public void addNodeType(JLabel l, int index) {
        this.table1.clear();
        if (index < this.nodeTypeList.getModel().getSize()) {
            this.nodeTypes.add(index, l);
            ((DefaultListModel)this.nodeTypeList.getModel()).add(index, l.getText());
        } else {
            this.nodeTypes.add(l);
            ((DefaultListModel)this.nodeTypeList.getModel()).addElement(l.getText());
        }
        this.putToTable(this.table1, this.nodeTypes);
    }

    public void addEdgeType(JLabel l, int index) {
        this.table2.clear();
        if (index < this.edgeTypeList.getModel().getSize()) {
            this.edgeTypes.add(index, l);
            ((DefaultListModel)this.edgeTypeList.getModel()).add(index, l.getText());
        } else {
            this.edgeTypes.add(l);
            ((DefaultListModel)this.edgeTypeList.getModel()).addElement(l.getText());
        }
        this.putToTable(this.table2, this.edgeTypes);
    }

    public void changeNodeType(JLabel l, int index) {
        this.table1.clear();
        this.putToTable(this.table1, this.nodeTypes);
        if (index < this.nodeTypeList.getModel().getSize()) {
            ((DefaultListModel)this.nodeTypeList.getModel()).remove(index);
            ((DefaultListModel)this.nodeTypeList.getModel()).add(index, l.getText());
        }
    }

    public void changeEdgeType(JLabel l, int index) {
        this.table2.clear();
        this.putToTable(this.table2, this.edgeTypes);
        if (index < this.edgeTypeList.getModel().getSize()) {
            ((DefaultListModel)this.edgeTypeList.getModel()).remove(index);
            ((DefaultListModel)this.edgeTypeList.getModel()).add(index, l.getText());
        }
    }

    public void removeNodeType(JLabel l, int index) {
        int i = this.nodeTypes.indexOf(l);
        if (i != index) {
            return;
        }
        this.nodeTypes.remove(l);
        this.putToTable(this.table1, this.nodeTypes);
        ((DefaultListModel)this.nodeTypeList.getModel()).remove(i);
    }

    public void removeEdgeType(JLabel l, int index) {
        int i = this.edgeTypes.indexOf(l);
        if (i != index) {
            return;
        }
        this.edgeTypes.remove(l);
        this.putToTable(this.table2, this.edgeTypes);
        ((DefaultListModel)this.edgeTypeList.getModel()).remove(i);
    }

    private void setNodeTypes(Vector types) {
        this.table1.clear();
        this.nodeTypes.clear();
        for (int i = 0; i < types.size(); ++i) {
            JLabel l = (JLabel)types.get(i);
            this.nodeTypes.add(l);
            this.putToTable(this.table1, l, i);
        }
    }

    private void setEdgeTypes(Vector types) {
        this.table2.clear();
        this.edgeTypes.clear();
        for (int i = 0; i < types.size(); ++i) {
            JLabel l = (JLabel)types.get(i);
            this.edgeTypes.add(l);
            this.putToTable(this.table2, l, i);
        }
    }

    private void putToTable(Hashtable table, JLabel l, int indx) {
        table.put(new Integer(indx), l.getIcon());
    }

    private void putToTable(Hashtable table, Vector types) {
        for (int i = 0; i < types.size(); ++i) {
            JLabel l = (JLabel)types.get(i);
            table.put(new Integer(i), l.getIcon());
        }
    }

    private JList createTypeList(Hashtable table, Vector types) {
        Vector<String> v = new Vector<String>(types.size());
        for (int i = 0; i < types.size(); ++i) {
            v.add(((JLabel)types.get(i)).getText());
        }
        JList list = new JList();
        list.setModel(new DefaultListModel());
        list.getSelectionModel().setSelectionMode(0);
        for (int i = 0; i < v.size(); ++i) {
            String text = (String)v.get(i);
            ((DefaultListModel)list.getModel()).addElement(text);
        }
        list.setPrototypeCellValue("Index 1234567890");
        MyCellRenderer cellRenderer = new MyCellRenderer();
        list.setCellRenderer(cellRenderer);
        cellRenderer.setImages(table);
        list.addMouseListener(this);
        return list;
    }

    public void mouseClicked(MouseEvent e) {
        if ((JList)e.getSource() == this.nodeTypeList) {
            int index = this.nodeTypeList.locationToIndex(e.getPoint());
            this.typeEditor.getNodeTypeBox().getCustomModel().setSelectedIndex(index);
        } else if ((JList)e.getSource() == this.edgeTypeList) {
            int index = this.edgeTypeList.locationToIndex(e.getPoint());
            this.typeEditor.getArcTypeBox().getCustomModel().setSelectedIndex(index);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        Hashtable imgTable;

        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String str = value.toString();
            if (this.imgTable != null) {
                Icon icon = null;
                Enumeration en = this.imgTable.keys();
                while (en.hasMoreElements()) {
                    Integer key = (Integer)en.nextElement();
                    if (index != key) continue;
                    icon = (Icon)this.imgTable.get(key);
                    break;
                }
                if (icon != null) {
                    this.setIcon(icon);
                }
            }
            this.setText(str);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }

        public void setImages(Hashtable images) {
            this.imgTable = images;
        }
    }
}

