/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.browser.impl;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdTypeSet;
import agg.gui.GraGraLoad;
import agg.gui.GraGraSave;
import agg.gui.GraphEditor;
import agg.gui.ModePopupMenu;
import agg.gui.browser.GraphBrowser;
import agg.gui.event.LoadEvent;
import agg.gui.event.LoadEventListener;
import agg.gui.event.SaveEvent;
import agg.gui.event.SaveEventListener;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GraphBrowserImpl
extends JPanel
implements GraphBrowser,
SaveEventListener,
LoadEventListener {
    static int WIDTH = 500;
    static int HEIGHT = 300;
    private GraphEditor editor;
    private ModePopupMenu modePopupMenu;
    private EdGraGra gragra;
    private EdGraph graph;
    private EdTypeSet types;
    private Object myObject;
    private String msg;

    public GraphBrowserImpl() {
        super(true);
        this.setLayout(new BorderLayout());
        this.editor = new GraphEditor(null);
        this.add((Component)this.editor, "Center");
        this.modePopupMenu = new ModePopupMenu();
        this.modePopupMenu.setViewModel(true);
        this.modePopupMenu.setLabel("Edit Modes");
        this.modePopupMenu.setEditor(this.editor);
        this.editor.setEditMode(12);
        this.editor.setEditCursor(new Cursor(0));
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getSource() == GraphBrowserImpl.this.editor.getGraphPanel().getCanvas() && e.isPopupTrigger() && GraphBrowserImpl.this.modePopupMenu.invoked(GraphBrowserImpl.this.editor, GraphBrowserImpl.this.editor.getGraphPanel(), e.getX(), e.getY())) {
                    GraphBrowserImpl.this.modePopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.getSource() == GraphBrowserImpl.this.editor.getGraphPanel().getCanvas() && e.isPopupTrigger() && GraphBrowserImpl.this.modePopupMenu.invoked(GraphBrowserImpl.this.editor, GraphBrowserImpl.this.editor.getGraphPanel(), e.getX(), e.getY())) {
                    GraphBrowserImpl.this.modePopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.editor.getGraphPanel().getCanvas().addMouseListener(ml);
    }

    public void saveEventOccurred(SaveEvent e) {
        int msgkey = e.getMsg();
        this.msg = "";
        if (msgkey == 1 || msgkey == 2 || msgkey == 6) {
            this.msg = "";
            return;
        }
        this.msg = e.getMessage();
    }

    public void loadEventOccurred(LoadEvent e) {
        int msgkey = e.getMsg();
        this.msg = "";
        if (msgkey == 1 || msgkey == 2 || msgkey == 12) {
            this.msg = "";
            return;
        }
        this.msg = e.getMessage();
    }

    public JPanel getPanel() {
        return this;
    }

    public Object getGraph() {
        return this.myObject;
    }

    public void setGraph(EdGraph g) {
        this.myObject = g;
        this.graph = g;
        this.editor.setGraph(this.graph);
    }

    public void setGraph(Graph g) {
        this.myObject = g;
        this.graph = new EdGraph(g);
        this.editor.setGraph(this.graph);
    }

    public void showGraph() {
        this.graph.update();
        this.editor.getGraphPanel().updateGraphics(true);
    }

    public EdGraGra getGraGra() {
        return this.gragra;
    }

    public GraGra getBaseGraGra() {
        return this.gragra.getBasisGraGra();
    }

    public void setGraGra(EdGraGra gragra) {
        this.gragra = gragra;
        this.types = this.gragra.getTypeSet();
        this.graph = this.gragra.getGraph();
    }

    public void setGraGra(GraGra gragra) {
        this.gragra = new EdGraGra(gragra);
        this.types = this.gragra.getTypeSet();
        this.graph = this.gragra.getGraph();
    }

    public EdGraGra loadGraGra(JFrame frame) {
        String dirName = "";
        String fileName = "";
        GraGraLoad gragraLoad = new GraGraLoad(frame);
        gragraLoad.addLoadEventListener(this);
        gragraLoad.load();
        if (!this.msg.equals("")) {
            dirName = gragraLoad.getDirName();
            JOptionPane.showMessageDialog(frame, this.msg);
        } else if (gragraLoad.getGraGra() != null) {
            dirName = gragraLoad.getDirName();
            fileName = gragraLoad.getFileName();
            this.gragra = gragraLoad.getGraGra();
            this.gragra.update();
            this.types = this.gragra.getTypeSet();
            this.graph = this.gragra.getGraph();
            JOptionPane.showMessageDialog(frame, "Loading is finished");
        }
        return this.gragra;
    }

    public GraGra loadBaseGraGra(JFrame frame) {
        String dirName = "";
        String fileName = "";
        GraGraLoad gragraLoad = new GraGraLoad(frame);
        gragraLoad.addLoadEventListener(this);
        gragraLoad.loadBase();
        if (!this.msg.equals("")) {
            dirName = gragraLoad.getDirName();
            JOptionPane.showMessageDialog(frame, "Loading is failed");
            return null;
        }
        if (gragraLoad.getBaseGraGra() != null) {
            dirName = gragraLoad.getDirName();
            fileName = gragraLoad.getFileName();
            GraGra basis = gragraLoad.getBaseGraGra();
            BaseFactory.theFactory().notify(basis);
            JOptionPane.showMessageDialog(frame, "Loading is finished");
            return basis;
        }
        return null;
    }

    public void saveAs(JFrame frame) {
        GraGraSave gragraSave = new GraGraSave(frame, "", "");
        gragraSave.addSaveEventListener(this);
        gragraSave.setGraGra(this.gragra);
        gragraSave.saveAs();
        if (!this.msg.equals("")) {
            JOptionPane.showMessageDialog(frame, "Saving is failed");
        } else {
            JOptionPane.showMessageDialog(frame, "Saving was successful.");
        }
    }

    public void updateGraphics() {
        if (this.editor.getGraph() != null) {
            this.editor.getGraph().update();
            this.editor.getGraphPanel().updateGraphics(true);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("AGG Graph Browser");
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        frame.addWindowListener(l);
        frame.setBackground(Color.white);
        frame.setCursor(Cursor.getPredefinedCursor(0));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - WIDTH / 2, screenSize.height / 2 - HEIGHT / 2);
        frame.setSize(WIDTH, HEIGHT);
        ImageIcon icon = GraphBrowserImpl.makeIcon("AGG_ICON64.gif");
        if (icon != null) {
            frame.setIconImage(icon.getImage());
        } else {
            System.out.println("AGG_ICON64.gif not found!");
        }
        GraphBrowserImpl browser = new GraphBrowserImpl();
        frame.getContentPane().add((Component)browser, "Center");
        frame.setVisible(true);
    }

    public static ImageIcon makeIcon(String gifFile) {
        byte[] buffer = null;
        try {
            int n;
            Class<?> baseClass = Class.forName("agg.gui.AGGAppl");
            InputStream resource = baseClass.getResourceAsStream(gifFile);
            if (resource == null) {
                System.err.println(baseClass.getName() + "/" + gifFile + " not found.");
                return null;
            }
            BufferedInputStream in = new BufferedInputStream(resource);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            buffer = new byte[1024];
            while ((n = in.read(buffer)) > 0) {
                out.write(buffer, 0, n);
            }
            in.close();
            out.flush();
            buffer = out.toByteArray();
            if (buffer.length == 0) {
                System.err.println("warning: " + gifFile + " is zero-length");
                return null;
            }
        }
        catch (Exception ioe) {
            System.err.println(ioe.toString());
            return null;
        }
        return new ImageIcon(buffer);
    }
}

