/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.cons;

import agg.cons.AtomConstraint;
import agg.editor.impl.EdGraGra;
import agg.gui.cons.RuleConstraint;
import agg.gui.parser.RuleModel;
import agg.gui.parser.RuleTree;
import agg.gui.parser.event.ParserGUIEvent;
import agg.gui.parser.event.ParserGUIListener;
import agg.xt_basis.GraGra;
import agg.xt_basis.Rule;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class ConstraintsGUI
implements ParserGUIListener {
    JSplitPane mainPane;
    RuleTree rtTop;
    RuleTree rtBottom;
    RuleConstraint right;
    EdGraGra eGra;

    public ConstraintsGUI() {
        GraGra gragra = null;
        this.rtTop = new RuleTree(gragra, false, false);
        this.rtTop.addParserGUIListener(this);
        this.rtBottom = new RuleTree(gragra, true, false);
        this.rtBottom.addParserGUIListener(this);
        JSplitPane treePane = new JSplitPane(0);
        treePane.setOneTouchExpandable(true);
        treePane.setContinuousLayout(true);
        JScrollPane tmpPane = new JScrollPane(this.rtTop.getTree());
        tmpPane.setSize(170, 210);
        tmpPane.setPreferredSize(new Dimension(170, 210));
        treePane.setTopComponent(tmpPane);
        tmpPane = new JScrollPane(this.rtBottom.getTree());
        tmpPane.setSize(170, 210);
        tmpPane.setPreferredSize(new Dimension(170, 210));
        treePane.setBottomComponent(tmpPane);
        treePane.getTopComponent().setSize(185, 300);
        treePane.getBottomComponent().setSize(185, 300);
        treePane.resetToPreferredSizes();
        this.right = new RuleConstraint(null);
        this.mainPane = new JSplitPane();
        this.mainPane.setOneTouchExpandable(true);
        this.mainPane.setContinuousLayout(true);
        this.mainPane.setRightComponent(this.right.getComponent());
        this.mainPane.setLeftComponent(treePane);
        this.setGrammar(gragra);
        this.setLayout(null);
    }

    private void setGrammar(GraGra gragra) {
        if (gragra != null) {
            this.rtTop.setGrammar(gragra);
            this.rtBottom.setGrammar(gragra);
        }
    }

    private void setLayout(EdGraGra edgragra) {
        this.eGra = edgragra;
        this.right.setLayout(edgragra);
    }

    public Container getContainer() {
        return this.mainPane;
    }

    public void setGraGra(EdGraGra edgragra) {
        this.eGra = edgragra;
        this.revalidate();
    }

    public void revalidate() {
        this.setLayout(this.eGra);
        this.setGrammar(this.eGra != null ? this.eGra.getBasisGraGra() : null);
        this.right.reset();
        this.mainPane.repaint();
        this.mainPane.validate();
    }

    public void occured(ParserGUIEvent pguie) {
        RuleModel.TreeData td;
        if (pguie.getSource() == this.rtTop) {
            RuleModel.TreeData td2 = (RuleModel.TreeData)pguie.getData();
            if (td2.isRule()) {
                this.right.setRule((Rule)td2.getData());
            }
        } else if (pguie.getSource() == this.rtBottom && (td = (RuleModel.TreeData)pguie.getData()).isAtomic()) {
            AtomConstraint a = (AtomConstraint)td.getData();
            if (this.eGra != null) {
                int index = this.eGra.getBasisGraGra().getAtomicsVec().indexOf(a);
                this.right.setAtomic(a, index);
            } else {
                this.right.setAtomic(null, 0);
            }
        }
        this.mainPane.repaint();
    }
}

