/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.cons;

import agg.cons.AtomApplCond;
import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdRule;
import agg.editor.impl.GraphPanel;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.OrdinaryMorphism;
import com.objectspace.jgl.HashMap;
import com.objectspace.jgl.HashMapIterator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class TwoMorphs
extends JPanel {
    private GraphPanel[] graphs = new GraphPanel[3];
    private JLabel[] titles = new JLabel[3];
    private JPanel[] panels = new JPanel[3];
    private EdGraGra layout;
    private EdRule ruleLayout;
    private OrdinaryMorphism morph1;
    private OrdinaryMorphism morph2;
    private JSplitPane split;
    private JSplitPane main;

    public TwoMorphs() {
        super(new BorderLayout());
        for (int i = 0; i < 3; ++i) {
            this.graphs[i] = new GraphPanel();
            this.titles[i] = new JLabel();
            this.panels[i] = new JPanel(new BorderLayout());
            this.panels[i].add((Component)this.titles[i], "North");
            this.panels[i].add((Component)this.graphs[i], "Center");
            this.graphs[i].setPreferredSize(new Dimension(200, 250));
            this.graphs[i].setEditMode(9);
        }
        this.split = new JSplitPane(1, this.panels[0], this.panels[1]);
        this.split.setOneTouchExpandable(true);
        this.split.setContinuousLayout(true);
        this.main = new JSplitPane(1, this.split, this.panels[2]);
        this.main.setOneTouchExpandable(true);
        this.main.setContinuousLayout(true);
        this.add((Component)this.main, "Center");
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 250);
    }

    public void setMorphisms(OrdinaryMorphism m1, OrdinaryMorphism m2) {
        if (m1 != null && m2 != null && !m1.getImage().equals(m2.getOriginal())) {
            return;
        }
        this.morph1 = m1;
        this.morph2 = m2;
        this.paint();
    }

    public void setAtomApplCond(AtomApplCond cond) {
        if (cond != null) {
            this.setMorphisms(cond.getPreCondition(), cond.getT());
        } else {
            this.setMorphisms(null, null);
        }
    }

    public void reset() {
    }

    public void setGraGra(EdGraGra gra) {
        this.layout = gra;
    }

    public void setRule(EdRule rule) {
        this.ruleLayout = rule;
    }

    public EdGraGra getGraGra() {
        return this.layout;
    }

    public EdRule getRule() {
        return this.ruleLayout;
    }

    private String getGraphName(int i) {
        switch (i) {
            case 0: {
                return "R = right rule side";
            }
            case 1: {
                return "S = overlap R + premise";
            }
            case 2: {
                return "T = pushout";
            }
        }
        return "PANIK-GRAPH";
    }

    private EdGraph setGraph(Graph g, int i) {
        GraphPanel gp = this.graphs[i];
        JLabel title = this.titles[i];
        if (g == null) {
            gp.setGraph(null);
            gp.updateGraphics();
            return null;
        }
        if (this.layout == null) {
            System.err.println("TwoMorph.setGraph: have no EdGraGra");
            return null;
        }
        EdGraph eg = gp.getGraph();
        eg = new EdGraph(g, this.layout.getTypeSet(), true);
        gp.setGraph(eg);
        title.setText("  " + this.getGraphName(i));
        return eg;
    }

    private void copyLayout(EdGraph from, EdGraph to) {
        if (from == null || to == null) {
            return;
        }
        for (int k = 0; k < to.getNodes().size(); ++k) {
            EdNode n = (EdNode)to.getNodes().elementAt(k);
            for (int j = 0; j < from.getNodes().size(); ++j) {
                EdNode en = (EdNode)from.getNodes().elementAt(j);
                if (!en.getBasisNode().getContextUsage().equals(n.getBasisNode().getContextUsage())) continue;
                n.setXY(en.getX(), en.getY());
                j = from.getNodes().size();
            }
        }
    }

    private void addMarks(HashMap h, OrdinaryMorphism m) {
        Enumeration graphObjects = m.getCodomain();
        int i = 0;
        HashMapIterator it = h.begin();
        while (!it.atEnd()) {
            int j = (Integer)it.value();
            if (j > i) {
                i = j;
            }
            it.advance();
        }
        graphObjects = m.getCodomain();
        while (graphObjects.hasMoreElements()) {
            Integer number;
            GraphObject go = (GraphObject)graphObjects.nextElement();
            Enumeration inverse = m.getInverseImage(go);
            GraphObject inv = null;
            if (inverse.hasMoreElements()) {
                inv = (GraphObject)inverse.nextElement();
            }
            if (h.get(go) != null && inv != null) {
                number = (Integer)h.get(go);
                h.add(inv, number);
                while (inverse.hasMoreElements()) {
                    inv = (GraphObject)inverse.nextElement();
                    h.add(inv, number);
                }
                continue;
            }
            if (h.get(go) != null) continue;
            number = null;
            inverse = m.getInverseImage(go);
            while (inverse.hasMoreElements() && (number = (Integer)h.get(inv = (GraphObject)inverse.nextElement())) == null) {
            }
            if (number == null) {
                number = new Integer(++i);
            }
            h.add(go, number);
            inverse = m.getInverseImage(go);
            while (inverse.hasMoreElements()) {
                inv = (GraphObject)inverse.nextElement();
                if (h.get(inv) != null) continue;
                h.add(inv, number);
            }
        }
    }

    private HashMap convertToStringHashMap(HashMap h) {
        HashMap result = new HashMap(true);
        HashMapIterator i = h.begin();
        while (!i.atEnd()) {
            result.add(i.key(), i.value().toString());
            i.advance();
        }
        return result;
    }

    private void paint() {
        if (this.morph1 == null || this.morph2 == null) {
            this.setGraph(null, 0);
            this.setGraph(null, 1);
            this.setGraph(null, 2);
            return;
        }
        if (this.split.getDividerLocation() == 0) {
            this.split.setDividerLocation(this.getSize().width / 2 - 20);
        }
        if (this.main.getDividerLocation() == 0) {
            this.main.setDividerLocation(this.getSize().width / 3 - 20);
        }
        EdGraph g0 = this.setGraph(this.morph1.getOriginal(), 0);
        this.copyLayout(this.ruleLayout.getRight(), g0);
        EdGraph g1 = this.setGraph(this.morph1.getImage(), 1);
        this.copyLayout(this.ruleLayout.getRight(), g1);
        EdGraph g2 = this.setGraph(this.morph2.getImage(), 2);
        for (int i = 0; i < this.layout.getAtomics().size(); ++i) {
            EdAtomic atom = (EdAtomic)this.layout.getAtomics().get(i);
            EdAtomic atomConcl = (EdAtomic)atom.getConclusions().get(0);
            EdGraph premise = atomConcl.getLeft();
            EdGraph concl = atomConcl.getLeft();
            this.copyLayout(premise, g1);
            this.copyLayout(concl, g2);
        }
        this.copyLayout(g1, g2);
        HashMap h = new HashMap(true);
        this.addMarks(h, this.morph1);
        this.addMarks(h, this.morph2);
        HashMap stringmap = this.convertToStringHashMap(h);
        this.graphs[0].getGraph().setMorphismMarks(stringmap, true);
        this.graphs[1].getGraph().setMorphismMarks(stringmap, true);
        this.graphs[2].getGraph().setMorphismMarks(stringmap, true);
        this.graphs[0].updateGraphics();
        this.graphs[1].updateGraphics();
        this.graphs[2].updateGraphics();
    }
}

