/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.parser;

import agg.attribute.AttrType;
import agg.attribute.facade.InformationFacade;
import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.handler.AttrHandler;
import agg.attribute.impl.ValueTuple;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdType;
import agg.gui.GraphicsExportJPEG;
import agg.gui.parser.CriticalPairPanel;
import agg.gui.parser.GraphDesktop;
import agg.gui.parser.PairIOGUI;
import agg.gui.parser.event.CPAEventData;
import agg.gui.parser.event.ParserGUIEvent;
import agg.gui.parser.event.ParserGUIListener;
import agg.layout.Layouter;
import agg.parser.CriticalPairEvent;
import agg.parser.ExcludePairContainer;
import agg.parser.PairContainer;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import agg.parser.ParserFactory;
import agg.xt_basis.Arc;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeSet;
import com.objectspace.jgl.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ConflictsDependenciesGraph
implements ActionListener,
ParserEventListener,
ParserGUIListener {
    PairIOGUI pairIOGUI;
    GraphDesktop graphDesktop;
    ExcludePairContainer conflictCont;
    ExcludePairContainer dependCont;
    GraGra grammar;
    Hashtable conflicts;
    Hashtable dependencies;
    Graph conflictGraph;
    Graph dependGraph;
    Graph combiGraph;
    EdGraph conflictLayout;
    EdGraph dependLayout;
    EdGraph combiLayout;
    EdGraph cpaLayout;
    SelectDialog dialog;
    boolean cancelled;
    boolean conflictAction = true;
    boolean hiddenGraphObject = false;
    GraphicsExportJPEG graphJPG;
    Vector visArcs = new Vector();

    public ConflictsDependenciesGraph(PairIOGUI ioGUI, String fileDirectory) {
        this.pairIOGUI = ioGUI;
        this.pairIOGUI.setDirectoryName(fileDirectory);
        this.dialog = new SelectDialog(null, this);
        this.dialog.toFront();
        this.dialog.setVisible(true);
        if (this.conflictCont == null && this.dependCont == null) {
            return;
        }
        this.initTables();
        this.createGraphs();
        if (this.conflictGraph != null) {
            this.storeVisArcs(this.conflictGraph);
            this.conflictLayout = new EdGraph(this.conflictGraph);
            this.conflictLayout.setCPAgraph(true);
            this.optimizeLayout(this.conflictLayout);
            this.conflictLayout.setRealWidthOfGraphPanel(400);
            this.conflictLayout.doDefaultGraphLayout(true);
            this.conflictCont.addPairEventListener(this);
            this.cpaLayout = this.conflictLayout;
        }
        if (this.dependGraph != null) {
            this.storeVisArcs(this.dependGraph);
            this.dependLayout = new EdGraph(this.dependGraph);
            this.dependLayout.setCPAgraph(true);
            this.optimizeLayout(this.dependLayout);
            this.dependLayout.setRealWidthOfGraphPanel(400);
            this.dependLayout.doDefaultGraphLayout(true);
            this.dependCont.addPairEventListener(this);
            this.cpaLayout = this.dependLayout;
        }
        if (this.combiGraph != null) {
            this.storeVisArcs(this.combiGraph);
            this.combiLayout = new EdGraph(this.combiGraph);
            this.combiLayout.setCPAgraph(true);
            this.optimizeLayout(this.combiLayout);
            this.combiLayout.setRealWidthOfGraphPanel(400);
            this.combiLayout.doDefaultGraphLayout(true);
            this.cpaLayout = this.combiLayout;
        }
    }

    public ConflictsDependenciesGraph(ExcludePairContainer conflictsContainer, ExcludePairContainer dependenciesContainer) {
        this.conflictCont = conflictsContainer;
        this.dependCont = dependenciesContainer;
        this.initTables();
        this.createGraphs();
        if (this.combiGraph != null) {
            this.storeVisArcs(this.combiGraph);
            this.combiLayout = new EdGraph(this.combiGraph);
            this.combiLayout.setCPAgraph(true);
            this.combiLayout.doDefaultGraphLayout(true);
            this.optimizeLayout(this.combiLayout);
            this.straightEdges(this.combiLayout);
            this.cpaLayout = this.combiLayout;
            this.conflictCont.addPairEventListener(this);
            this.dependCont.addPairEventListener(this);
        } else if (this.conflictGraph != null) {
            this.storeVisArcs(this.conflictGraph);
            this.conflictLayout = new EdGraph(this.conflictGraph);
            this.conflictLayout.doDefaultGraphLayout(true);
            this.conflictLayout.setCPAgraph(true);
            this.optimizeLayout(this.conflictLayout);
            this.cpaLayout = this.conflictLayout;
            this.conflictCont.addPairEventListener(this);
        } else if (this.dependGraph != null) {
            this.storeVisArcs(this.dependGraph);
            this.dependLayout = new EdGraph(this.dependGraph);
            this.dependLayout.doDefaultGraphLayout(true);
            this.dependLayout.setCPAgraph(true);
            this.optimizeLayout(this.dependLayout);
            this.cpaLayout = this.dependLayout;
            this.dependCont.addPairEventListener(this);
        }
    }

    public ConflictsDependenciesGraph(ExcludePairContainer conflictsContainer, ExcludePairContainer dependenciesContainer, EdGraph cpaGraph, boolean loaded) {
        this.conflictCont = conflictsContainer;
        this.dependCont = dependenciesContainer;
        this.cpaLayout = cpaGraph;
        this.initTables();
        if (this.cpaLayout != null) {
            if (!loaded) {
                this.updateGraphAlongPairContainer();
            } else {
                this.updatePairsContainerAlongCPAgraph();
            }
            if (this.conflictCont != null && this.dependCont != null) {
                this.combiGraph = this.cpaLayout.getBasisGraph();
                this.combiLayout = this.cpaLayout;
                this.conflictCont.addPairEventListener(this);
                this.dependCont.addPairEventListener(this);
            } else if (this.conflictCont != null) {
                this.conflictGraph = this.cpaLayout.getBasisGraph();
                this.conflictLayout = this.cpaLayout;
                this.conflictCont.addPairEventListener(this);
            } else if (this.dependCont != null) {
                this.dependGraph = this.cpaLayout.getBasisGraph();
                this.dependLayout = this.cpaLayout;
                this.dependCont.addPairEventListener(this);
            }
        }
    }

    public void setGraphDesktop(GraphDesktop desktop) {
        this.graphDesktop = desktop;
    }

    public void setGraphExportJPG(GraphicsExportJPEG jpg) {
        this.graphJPG = jpg;
    }

    public void setConflictPairContainer(PairContainer pc) {
        this.conflictCont = (ExcludePairContainer)pc;
        this.conflicts = this.conflictCont.getExcludeContainer();
        if (this.grammar == null) {
            this.grammar = this.conflictCont.getGrammar();
        }
    }

    public void setDependencyPairContainer(PairContainer pc) {
        this.dependCont = (ExcludePairContainer)pc;
        this.dependencies = this.dependCont.getExcludeContainer();
        if (this.grammar == null) {
            this.grammar = this.dependCont.getGrammar();
        }
    }

    public void parserEventOccured(ParserEvent p) {
        if (p instanceof CriticalPairEvent) {
            Rule r1 = ((CriticalPairEvent)p).getFirstRule();
            Rule r2 = ((CriticalPairEvent)p).getSecondRule();
            if (p.getSource() instanceof ExcludePairContainer) {
                if (((ExcludePairContainer)p.getSource()).isAlive()) {
                    return;
                }
                if (((ExcludePairContainer)p.getSource()).getKindOfConflict() == 0) {
                    if (((CriticalPairEvent)p).getKey() == 7) {
                        if (this.cpaLayout != null) {
                            this.updateGraphAlongPairContainer();
                            if (this.graphDesktop != null) {
                                this.graphDesktop.refreshCPAGraph();
                            }
                        }
                        return;
                    }
                    if (r1 == null || r2 == null) {
                        return;
                    }
                    ExcludePairContainer.Entry entry = this.conflictCont.getEntry(r1, r2);
                    if (entry.getState() == 3) {
                        Node n2;
                        Node n1 = this.getNode(this.cpaLayout.getBasisGraph(), r1);
                        if (n1 == null) {
                            this.createNode(this.cpaLayout.getBasisGraph(), "Rule", r1);
                        }
                        if ((n2 = this.getNode(this.cpaLayout.getBasisGraph(), r2)) == null) {
                            this.createNode(this.cpaLayout.getBasisGraph(), "Rule", r2);
                        }
                        if (entry.isCritical()) {
                            this.createEdge(this.cpaLayout.getBasisGraph(), "c", r1, r2);
                        }
                        this.cpaLayout.update();
                        if (this.graphDesktop != null) {
                            this.graphDesktop.refreshCPAGraph();
                        }
                    }
                    if (((CriticalPairEvent)p).getKey() == 3) {
                        this.showEdge(this.cpaLayout.getBasisGraph(), "c", r1, r2);
                        if (this.cpaLayout != null) {
                            this.cpaLayout.update();
                            if (this.graphDesktop != null) {
                                this.graphDesktop.refreshCPAGraph();
                            }
                        }
                    } else if (((CriticalPairEvent)p).getKey() == 6) {
                        this.removeEdge(this.cpaLayout.getBasisGraph(), "c", r1, r2);
                    }
                } else {
                    if (((CriticalPairEvent)p).getKey() == 7) {
                        if (this.cpaLayout != null) {
                            this.updateGraphAlongPairContainer();
                            if (this.graphDesktop != null) {
                                this.graphDesktop.refreshCPAGraph();
                            }
                        }
                        return;
                    }
                    if (r1 == null || r2 == null) {
                        return;
                    }
                    ExcludePairContainer.Entry entry = this.dependCont.getEntry(r1, r2);
                    if (entry.getState() == 3) {
                        Node n2;
                        Node n1 = this.getNode(this.cpaLayout.getBasisGraph(), r1);
                        if (n1 == null) {
                            this.createNode(this.cpaLayout.getBasisGraph(), "Rule", r1);
                        }
                        if ((n2 = this.getNode(this.cpaLayout.getBasisGraph(), r2)) == null) {
                            this.createNode(this.cpaLayout.getBasisGraph(), "Rule", r2);
                        }
                        if (entry.isCritical()) {
                            Arc a = this.createEdge(this.cpaLayout.getBasisGraph(), "d", r1, r2);
                            this.cpaLayout.update();
                            if (this.graphDesktop != null) {
                                this.graphDesktop.refreshCPAGraph();
                            }
                        }
                    }
                    if (((CriticalPairEvent)p).getKey() == 3) {
                        this.showEdge(this.cpaLayout.getBasisGraph(), "d", r1, r2);
                        if (this.cpaLayout != null) {
                            this.cpaLayout.update();
                            if (this.graphDesktop != null) {
                                this.graphDesktop.refreshCPAGraph();
                            }
                        }
                    } else if (((CriticalPairEvent)p).getKey() == 6) {
                        this.removeEdge(this.cpaLayout.getBasisGraph(), "d", r1, r2);
                    } else if (((CriticalPairEvent)p).getKey() == 7 && this.cpaLayout != null) {
                        this.cpaLayout.update();
                        if (this.graphDesktop != null) {
                            this.graphDesktop.refreshCPAGraph();
                        }
                    }
                }
            }
        }
    }

    public void occured(ParserGUIEvent e) {
        if (e.getSource() instanceof CriticalPairPanel && e.getData() instanceof CPAEventData) {
            if (((CriticalPairPanel)e.getSource()).getKindOfPairContainer() == 0) {
                this.conflictAction = true;
            } else if (((CriticalPairPanel)e.getSource()).getKindOfPairContainer() == 1) {
                this.conflictAction = false;
            }
            CPAEventData d = (CPAEventData)e.getData();
            int kind = d.kind;
            Rule r1 = d.r1;
            Rule r2 = null;
            String t = "";
            if (kind == CPAEventData.SHOW_RULE) {
                t = "Rule";
            }
            if (kind == CPAEventData.SHOW_RELATION) {
                r2 = d.r2;
                t = d.type;
            }
            boolean vis = d.visible;
            if (this.cpaLayout != null) {
                if (!vis) {
                    if (kind == CPAEventData.SHOW_RULE) {
                        this.hideNode(this.cpaLayout.getBasisGraph(), r1, false);
                    } else if (kind == CPAEventData.SHOW_RELATION && t.equals("C")) {
                        this.hideEdge(this.cpaLayout.getBasisGraph(), "c", r1, r2);
                    } else if (kind == CPAEventData.SHOW_RELATION && t.equals("D")) {
                        this.hideEdge(this.cpaLayout.getBasisGraph(), "d", r1, r2);
                    }
                } else if (kind == CPAEventData.SHOW_RULE) {
                    this.showNode(this.cpaLayout.getBasisGraph(), t, r1, false);
                } else if (kind == CPAEventData.SHOW_RELATION && t.equals("C")) {
                    this.showEdge(this.cpaLayout.getBasisGraph(), "c", r1, r2);
                } else if (kind == CPAEventData.SHOW_RELATION && t.equals("D")) {
                    this.showEdge(this.cpaLayout.getBasisGraph(), "d", r1, r2);
                }
                this.cpaLayout.update();
                if (this.graphDesktop != null) {
                    this.graphDesktop.refresh();
                }
            }
        }
    }

    public void updatePairsContainerAlongCPAgraph() {
        if (this.cpaLayout == null) {
            return;
        }
        if (this.conflictCont != null) {
            this.updatePairsContainerAlongCPAgraph(this.conflictCont);
        }
        if (this.dependCont != null) {
            this.updatePairsContainerAlongCPAgraph(this.dependCont);
        }
        this.cpaLayout.update();
    }

    private void updatePairsContainerAlongCPAgraph(PairContainer pc) {
        if (this.cpaLayout == null || pc == null) {
            return;
        }
        Hashtable container = ((ExcludePairContainer)pc).getExcludeContainer();
        Enumeration keys = container.keys();
        while (keys.hasMoreElements()) {
            Rule r1 = (Rule)keys.nextElement();
            Hashtable secondPart = (Hashtable)container.get(r1);
            Enumeration k2 = secondPart.keys();
            block1: while (k2.hasMoreElements()) {
                Object val;
                Node n;
                Vector elems;
                Rule r2 = (Rule)k2.nextElement();
                ExcludePairContainer.Entry entry = ((ExcludePairContainer)pc).getEntry(r1, r2);
                if (entry.isCritical()) {
                    Arc a;
                    if (r1 == r2) {
                        elems = this.cpaLayout.getNodes();
                        for (int i = 0; i < elems.size(); ++i) {
                            n = ((EdNode)elems.get(i)).getBasisNode();
                            val = n.getAttribute().getValueAt("name");
                            if (val == null || !((String)val).equals(r1.getName())) continue;
                            ((ExcludePairContainer)pc).setEntryRuleVisible(r1, r2, n.isVisible(), false, false);
                            break;
                        }
                    }
                    String tn = "c";
                    if (pc.getKindOfConflict() == 1) {
                        tn = "d";
                    }
                    if ((a = this.getArc(this.cpaLayout, tn, r1, r2)) == null) continue;
                    if (r1 == r2) {
                        ((ExcludePairContainer)pc).setEntryRelationVisible(r1, r2, a.isVisible(), true);
                        continue;
                    }
                    ExcludePairContainer.Entry entry2 = ((ExcludePairContainer)pc).getEntry(r2, r1);
                    if (entry2.isCritical()) {
                        Arc a2 = this.getArc(this.cpaLayout, tn, r2, r1);
                        if (a2 == null) continue;
                        if (!a.isVisible() && !a2.isVisible()) {
                            ((ExcludePairContainer)pc).setEntryRelationVisible(r1, r2, false, true);
                            ((ExcludePairContainer)pc).setEntryRelationVisible(r2, r1, false, true);
                            continue;
                        }
                        if (!a2.isDirected() && !a2.isVisible() && a.isDirected() && a.isVisible()) {
                            ((ExcludePairContainer)pc).setEntryRelationVisible(r2, r1, false, true);
                            continue;
                        }
                        if (!a.isDirected() && !a.isVisible() && a2.isDirected() && a2.isVisible()) {
                            ((ExcludePairContainer)pc).setEntryRelationVisible(r1, r2, false, true);
                            continue;
                        }
                        if (a2.isDirected() && !a2.isVisible() && !a.isDirected() && a.isVisible()) {
                            if (this.visArcs.contains(a2)) continue;
                            this.visArcs.add(a2);
                            continue;
                        }
                        if (!a.isDirected() || a.isVisible() || a2.isDirected() || !a2.isVisible() || this.visArcs.contains(a)) continue;
                        this.visArcs.add(a);
                        continue;
                    }
                    ((ExcludePairContainer)pc).setEntryRelationVisible(r1, r2, a.isVisible(), true);
                    continue;
                }
                if (r1 != r2) continue;
                elems = this.cpaLayout.getNodes();
                for (int i = 0; i < elems.size(); ++i) {
                    n = ((EdNode)elems.get(i)).getBasisNode();
                    val = n.getAttribute().getValueAt("name");
                    if (val == null || !((String)val).equals(r1.getName())) continue;
                    ((ExcludePairContainer)pc).setEntryRuleVisible(r1, r2, n.isVisible(), true, false);
                    continue block1;
                }
            }
        }
    }

    private Arc getArc(EdGraph g, String tn, Rule r1, Rule r2) {
        Vector elems = g.getArcs();
        Arc a = null;
        for (int i = 0; i < elems.size(); ++i) {
            a = ((EdArc)elems.get(i)).getBasisArc();
            if (!a.getType().getName().equals(tn)) continue;
            Object src = a.getSource().getAttribute().getValueAt("name");
            Object tar = a.getTarget().getAttribute().getValueAt("name");
            if (src == null || !((String)src).equals(r1.getName()) || tar == null || !((String)tar).equals(r2.getName())) continue;
            return a;
        }
        return null;
    }

    public void updateGraphAlongPairContainer() {
        this.visArcs.clear();
        if (this.conflictCont != null) {
            this.updateGraphAlongPairContainer(this.cpaLayout, this.conflictCont, this.conflicts, "c");
        }
        if (this.dependCont != null) {
            this.updateGraphAlongPairContainer(this.cpaLayout, this.dependCont, this.dependencies, "d");
        }
        if (this.conflictCont != null && this.dependCont != null && this.conflictCont.isEmpty() && this.dependCont.isEmpty()) {
            Enumeration e = this.cpaLayout.getBasisGraph().getNodes();
            while (e.hasMoreElements()) {
                Node n = (Node)e.nextElement();
                try {
                    this.cpaLayout.getBasisGraph().destroyNode(n);
                }
                catch (TypeException typeException) {}
            }
        }
        this.cpaLayout.update();
    }

    private void updateGraphAlongPairContainer(EdGraph g, PairContainer pc, Hashtable table1, String tn) {
        Arc a;
        Enumeration e;
        if (g == null || pc == null || table1 == null) {
            return;
        }
        if (table1.isEmpty()) {
            e = g.getBasisGraph().getArcs();
            while (e.hasMoreElements()) {
                a = (Arc)e.nextElement();
                if (!a.getType().getName().equals(tn)) continue;
                try {
                    g.getBasisGraph().destroyArc(a);
                }
                catch (TypeException exc) {}
            }
        } else {
            e = this.cpaLayout.getBasisGraph().getArcs();
            while (e.hasMoreElements()) {
                Rule r2;
                Rule r1;
                ExcludePairContainer.Entry entry;
                a = (Arc)e.nextElement();
                if (!a.getType().getName().equals(tn) || (entry = ((ExcludePairContainer)pc).getEntry(r1 = this.getRule((Node)a.getSource()), r2 = this.getRule((Node)a.getTarget()))) != null && entry.getState() != 0) continue;
                try {
                    this.cpaLayout.getBasisGraph().destroyArc(a);
                }
                catch (TypeException exc) {
                    // empty catch block
                }
                e = this.cpaLayout.getBasisGraph().getArcs();
            }
        }
        Enumeration keys1 = table1.keys();
        while (keys1.hasMoreElements()) {
            Rule r1 = (Rule)keys1.nextElement();
            Node n1 = this.getNode(this.cpaLayout.getBasisGraph(), r1);
            if (n1 == null) {
                n1 = this.createNode(this.cpaLayout.getBasisGraph(), "Rule", r1);
            }
            Hashtable table2 = (Hashtable)table1.get(r1);
            Enumeration keys2 = table2.keys();
            while (keys2.hasMoreElements()) {
                Rule r2 = (Rule)keys2.nextElement();
                Node n2 = this.getNode(this.cpaLayout.getBasisGraph(), r2);
                if (n2 == null) {
                    n2 = this.createNode(this.cpaLayout.getBasisGraph(), "Rule", r2);
                }
                ExcludePairContainer.Entry entry = ((ExcludePairContainer)pc).getEntry(r1, r2);
                if (r1 == r2) {
                    n1.setVisible(entry.isRuleVisible());
                }
                if (!entry.isCritical()) continue;
                Arc a2 = this.getArc(this.cpaLayout, tn, r1, r2);
                if (a2 != null) {
                    if (r1 == r2) {
                        a2.setVisible(entry.isRelationVisible());
                        continue;
                    }
                    ExcludePairContainer.Entry entry2 = ((ExcludePairContainer)pc).getEntry(r2, r1);
                    if (!entry2.isCritical()) continue;
                    Arc a22 = this.getArc(this.cpaLayout, tn, r2, r1);
                    if (a22 != null) {
                        if (entry.isRelationVisible() && entry2.isRelationVisible()) {
                            if (!a22.isDirected()) {
                                a22.setVisible(true);
                                a2.setVisible(false);
                                if (!this.visArcs.contains(a2)) {
                                    this.visArcs.add(a2);
                                }
                                a2.setDirected(true);
                                continue;
                            }
                            if (!a2.isDirected()) {
                                a2.setVisible(true);
                                a22.setVisible(false);
                                if (!this.visArcs.contains(a22)) {
                                    this.visArcs.add(a22);
                                }
                                a22.setDirected(true);
                                continue;
                            }
                            if (a22.isDirected()) {
                                a22.setVisible(false);
                                if (!this.visArcs.contains(a22)) {
                                    this.visArcs.add(a22);
                                }
                                a2.setVisible(true);
                                a2.setDirected(false);
                                continue;
                            }
                            a2.setVisible(false);
                            if (!this.visArcs.contains(a2)) {
                                this.visArcs.add(a2);
                            }
                            a22.setDirected(false);
                            a22.setVisible(true);
                            continue;
                        }
                        if (entry.isRelationVisible() && entry2.isRelationVisible()) {
                            a2.setVisible(false);
                            a22.setVisible(false);
                            continue;
                        }
                        if (entry.isRelationVisible()) {
                            a2.setVisible(true);
                            a2.setDirected(true);
                            a22.setVisible(false);
                            if (!a22.isDirected()) continue;
                            a22.setDirected(false);
                            continue;
                        }
                        if (!entry2.isRelationVisible()) continue;
                        a22.setVisible(true);
                        a22.setDirected(true);
                        a2.setVisible(false);
                        if (!a2.isDirected()) continue;
                        a2.setDirected(false);
                        continue;
                    }
                    a22 = this.createEdge(this.cpaLayout.getBasisGraph(), tn, r2, r1);
                    continue;
                }
                a2 = this.createEdge(this.cpaLayout.getBasisGraph(), tn, r1, r2);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton) {
            JButton b = (JButton)source;
            if (b == this.dialog.getConflictButton()) {
                boolean fileOK = true;
                GraGra emptyGraGra1 = BaseFactory.theFactory().createGraGra();
                this.conflictCont = (ExcludePairContainer)ParserFactory.createEmptyCriticalPairs(emptyGraGra1, 0, false);
                this.pairIOGUI.setFileFilter(".cpx");
                this.pairIOGUI.setCriticalPairContainer(this.conflictCont);
                Object o = this.pairIOGUI.load();
                if (o == null) {
                    fileOK = false;
                    this.conflictCont = null;
                } else if (this.conflictCont.getKindOfConflict() == 1) {
                    fileOK = false;
                    this.conflictCont = null;
                    String errMsg = "There was not a file with rule conflicts!\n";
                    JOptionPane.showMessageDialog(null, errMsg, "Warning", 2);
                } else {
                    this.dialog.getConflictFileLabel().setText(this.dialog.getConflictFileLabel().getText() + this.pairIOGUI.getFileName());
                }
                this.dialog.toFront();
            } else if (b == this.dialog.getDependButton()) {
                boolean fileOK = true;
                GraGra emptyGraGra2 = BaseFactory.theFactory().createGraGra();
                this.dependCont = (ExcludePairContainer)ParserFactory.createEmptyCriticalPairs(emptyGraGra2, 1, false);
                this.pairIOGUI.setFileFilter(".dpx");
                this.pairIOGUI.setCriticalPairContainer(this.dependCont);
                Object o = this.pairIOGUI.load();
                if (o == null) {
                    fileOK = false;
                    this.dependCont = null;
                } else if (this.dependCont.getKindOfConflict() == 0) {
                    fileOK = false;
                    this.dependCont = null;
                    String errMsg = "There was not a file with rule dependencies!\n";
                    JOptionPane.showMessageDialog(null, errMsg, "Warning", 2);
                } else {
                    this.dialog.getDependFileLabel().setText(this.dialog.getDependFileLabel().getText() + this.pairIOGUI.getFileName());
                }
                this.dialog.toFront();
            } else if (b.getText().equals("Show")) {
                this.dialog.setVisible(false);
            } else if (b.getText().equals("Cancel")) {
                this.cancelled = true;
                this.dialog.setVisible(false);
            }
        } else if (source instanceof JMenuItem) {
            if (((JMenuItem)source).getText().equals("Show Conflicts")) {
                this.setEdgeVisible(this.cpaLayout.getBasisGraph(), "c", true);
                this.setEdgeVisible(this.cpaLayout.getBasisGraph(), "d", false);
                if (this.graphDesktop != null) {
                    this.graphDesktop.refresh();
                }
            } else if (((JMenuItem)source).getText().equals("Show Dependencies")) {
                this.setEdgeVisible(this.cpaLayout.getBasisGraph(), "d", true);
                this.setEdgeVisible(this.cpaLayout.getBasisGraph(), "c", false);
                if (this.graphDesktop != null) {
                    this.graphDesktop.refresh();
                }
            } else if (((JMenuItem)source).getText().equals("Show All")) {
                if (this.hiddenGraphObject) {
                    this.setAllVisible(this.cpaLayout.getBasisGraph());
                    this.hiddenGraphObject = false;
                } else {
                    this.setAllEdgeVisible(this.cpaLayout.getBasisGraph());
                }
                if (this.graphDesktop != null) {
                    this.graphDesktop.refresh();
                }
            } else if (((JMenuItem)source).getText().equals("Hide Node/Edge")) {
                this.hideGraphObject();
                if (this.graphDesktop != null) {
                    this.graphDesktop.refresh();
                }
            } else if (((JMenuItem)source).getText().equals("Straight Edges")) {
                this.straightEdges(this.cpaLayout);
                if (this.graphDesktop != null) {
                    this.graphDesktop.refresh();
                }
            } else if (((JMenuItem)source).getText().equals("Solid Line")) {
                if (((JMenuItem)source).getActionCommand().indexOf("Conflict") != -1) {
                    this.changeStyleOfEdges(this.cpaLayout, "c", 61);
                } else if (((JMenuItem)source).getActionCommand().indexOf("Dependency") != -1) {
                    this.changeStyleOfEdges(this.cpaLayout, "d", 61);
                }
                if (this.graphDesktop != null) {
                    this.graphDesktop.refresh();
                }
            } else if (((JMenuItem)source).getText().equals("Dot Line")) {
                if (((JMenuItem)source).getActionCommand().indexOf("Conflict") != -1) {
                    this.changeStyleOfEdges(this.cpaLayout, "c", 63);
                } else if (((JMenuItem)source).getActionCommand().indexOf("Dependency") != -1) {
                    this.changeStyleOfEdges(this.cpaLayout, "d", 63);
                }
                if (this.graphDesktop != null) {
                    this.graphDesktop.refresh();
                }
            } else if (((JMenuItem)source).getText().equals("Dash Line")) {
                if (((JMenuItem)source).getActionCommand().indexOf("Conflict") != -1) {
                    this.changeStyleOfEdges(this.cpaLayout, "c", 62);
                } else if (((JMenuItem)source).getActionCommand().indexOf("Dependency") != -1) {
                    this.changeStyleOfEdges(this.cpaLayout, "d", 62);
                }
                if (this.graphDesktop != null) {
                    this.graphDesktop.refresh();
                }
            } else if (((JMenuItem)source).getText().equals("Export JPEG")) {
                // empty if block
            }
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public EdGraph getConflictsGraph() {
        return this.conflictLayout;
    }

    public EdGraph getDependenciesGraph() {
        return this.dependLayout;
    }

    public EdGraph getConflictsDependenciesGraph() {
        return this.combiLayout;
    }

    public ExcludePairContainer getConflictsContainer() {
        return this.conflictCont;
    }

    public ExcludePairContainer getDependenciesContainer() {
        return this.dependCont;
    }

    private void setEdgeVisible(Graph g, String tn, boolean vis) {
        Type t = g.getTypeSet().getTypeForName(tn);
        if (t == null) {
            return;
        }
        Enumeration e = g.getArcs();
        while (e.hasMoreElements()) {
            Arc a = (Arc)e.nextElement();
            if (!a.getSource().isVisible() || !a.getTarget().isVisible() || !a.getType().getName().equals(t.getName())) continue;
            if (a.getSource() == a.getTarget()) {
                a.setVisible(vis);
                continue;
            }
            if (vis) {
                a.setVisible(vis);
                Arc a1 = this.getEdge(g, t, (Node)a.getTarget(), (Node)a.getSource());
                if (a1 == null) continue;
                if (a1.isDirected()) {
                    a1.setVisible(false);
                    continue;
                }
                a1.setVisible(true);
                a.setVisible(false);
                continue;
            }
            a.setVisible(vis);
        }
    }

    public void setAllEdgeVisible(Graph g) {
        this.setEdgeVisible(g, "c", true);
        this.setEdgeVisible(g, "d", true);
    }

    private void setAllNodeVisible(Graph g) {
        Enumeration e = g.getElements();
        while (e.hasMoreElements()) {
            GraphObject o = (GraphObject)e.nextElement();
            if (!o.isNode()) continue;
            o.setVisible(true);
        }
    }

    private void setAllVisible(Graph g) {
        this.cpaLayout.deselectAll();
        this.setAllNodeVisible(g);
        this.setAllEdgeVisible(g);
    }

    private void getConflictsDependenciesContainer(String fileDirectory) {
        this.getConflictsFile(fileDirectory);
        this.getDependenciesFile(fileDirectory);
    }

    private void getConflictsFile(String fileDirectory) {
        Object[] options = new Object[]{"Set", "Cancel"};
        int answer = 0;
        boolean fileOK = false;
        String errMsg = "";
        while (answer == 0 && !fileOK) {
            answer = JOptionPane.showOptionDialog(null, errMsg + "Please set a file with rule conflicts.", "Conflicts", -1, 1, null, options, options[0]);
            if (answer != 0) continue;
            GraGra emptyGraGra1 = BaseFactory.theFactory().createGraGra();
            this.conflictCont = (ExcludePairContainer)ParserFactory.createEmptyCriticalPairs(emptyGraGra1, 0, false);
            this.pairIOGUI.setCriticalPairContainer(this.conflictCont);
            this.pairIOGUI.setDirectoryName(fileDirectory);
            Object o = this.pairIOGUI.load();
            if (this.conflictCont.getKindOfConflict() == 1) {
                fileOK = false;
                this.conflictCont = null;
                errMsg = "There was not a file with rule conflicts!\n";
                continue;
            }
            fileOK = true;
        }
    }

    private void getDependenciesFile(String fileDirectory) {
        Object[] options = new Object[]{"Set", "Cancel"};
        int answer = 0;
        boolean fileOK = false;
        String errMsg = "";
        while (answer == 0 && !fileOK) {
            answer = JOptionPane.showOptionDialog(null, errMsg + "Please set a file with rule dependencies.", "Dependencies", -1, 1, null, options, options[0]);
            if (answer != 0) continue;
            GraGra emptyGraGra2 = BaseFactory.theFactory().createGraGra();
            this.dependCont = (ExcludePairContainer)ParserFactory.createEmptyCriticalPairs(emptyGraGra2, 1, false);
            this.pairIOGUI.setCriticalPairContainer(this.dependCont);
            this.pairIOGUI.load();
            if (this.dependCont.getKindOfConflict() == 0) {
                fileOK = false;
                this.dependCont = null;
                errMsg = "There was not a file with rule dependencies!\n";
                continue;
            }
            fileOK = true;
        }
    }

    private void initTables() {
        if (this.conflictCont != null) {
            this.conflicts = this.conflictCont.getExcludeContainer();
            this.grammar = this.conflictCont.getGrammar();
        }
        if (this.dependCont != null) {
            this.dependencies = this.dependCont.getExcludeContainer();
            if (this.grammar == null) {
                this.grammar = this.dependCont.getGrammar();
            }
        }
    }

    private void createGraphs() {
        Arc a;
        Node nr;
        Node nr2;
        boolean rel;
        Pair p;
        Node nr3;
        Node nr1;
        ExcludePairContainer.Entry entry;
        Rule r2;
        Enumeration keys2;
        Hashtable table;
        Rule r1;
        Enumeration keys1;
        if (this.conflicts == null && this.dependencies == null) {
            return;
        }
        Hashtable<String, Node> common = new Hashtable<String, Node>();
        Hashtable<String, Node> local = new Hashtable<String, Node>();
        Graph g = null;
        TypeSet types = null;
        if (this.conflicts != null) {
            this.conflictGraph = new Graph();
            this.conflictGraph.setName("Conflicts of Rules");
            g = this.conflictGraph;
            types = this.conflictGraph.getTypeSet();
        }
        if (this.dependencies != null) {
            this.dependGraph = types != null ? new Graph(types) : new Graph();
            this.dependGraph.setName("Dependencies of Rules");
            if (g == null) {
                g = this.dependGraph;
                types = this.dependGraph.getTypeSet();
            }
        }
        if (this.conflictGraph != null && this.dependGraph != null) {
            this.combiGraph = new Graph(types);
            this.combiGraph.setName("CPA Graph: Conflicts (red) - Dependencies (blue) of Rules");
        }
        Type nodeType = types.createType();
        Type arcTypeConflict = types.createType();
        Type arcTypeDepend = types.createType();
        nodeType.setStringRepr("Rule");
        nodeType.setAdditionalRepr("[NODE]");
        arcTypeConflict.setStringRepr("c");
        arcTypeConflict.setAdditionalRepr(":SOLID_LINE:java.awt.Color[r=255,g=0,b=0]::[EDGE]:");
        arcTypeDepend.setStringRepr("d");
        arcTypeDepend.setAdditionalRepr(":DOT_LINE:java.awt.Color[r=0,g=0,b=255]::[EDGE]:");
        InformationFacade info = DefaultInformationFacade.self();
        AttrHandler javaHandler = info.getJavaHandler();
        AttrType attrType = nodeType.getAttrType();
        attrType.addMember(javaHandler, "String", "name");
        if (this.conflicts != null) {
            keys1 = this.conflicts.keys();
            while (keys1.hasMoreElements()) {
                r1 = (Rule)keys1.nextElement();
                if (!r1.isEnabled()) continue;
                table = (Hashtable)this.conflicts.get(r1);
                keys2 = table.keys();
                while (keys2.hasMoreElements()) {
                    r2 = (Rule)keys2.nextElement();
                    if (!r2.isEnabled()) continue;
                    entry = this.conflictCont.getEntry(r1, r2);
                    nr1 = (Node)local.get(r1.getName());
                    if (nr1 == null) {
                        nr1 = this.createNode(this.conflictGraph, nodeType, r1);
                        local.put(r1.getName(), nr1);
                        if (r1 == r2) {
                            nr1.setVisible(entry.isRuleVisible());
                        }
                    }
                    if (this.combiGraph != null && (nr3 = (Node)common.get(r1.getName())) == null) {
                        nr3 = this.createNode(this.combiGraph, nodeType, r1);
                        common.put(r1.getName(), nr3);
                        if (r1 == r2) {
                            nr3.setVisible(entry.isRuleVisible());
                        }
                    }
                    p = (Pair)table.get(r2);
                    rel = (Boolean)p.first;
                    nr2 = (Node)local.get(r2.getName());
                    if (nr2 == null) {
                        nr2 = this.createNode(this.conflictGraph, nodeType, r2);
                        local.put(r2.getName(), nr2);
                    }
                    if (this.combiGraph != null && (nr = (Node)common.get(r2.getName())) == null) {
                        nr = this.createNode(this.combiGraph, nodeType, r2);
                        common.put(r2.getName(), nr);
                    }
                    if (!rel) continue;
                    a = this.createEdge(this.conflictGraph, arcTypeConflict, r1, r2);
                    if (this.combiGraph == null) continue;
                    Arc a1 = this.createEdge(this.combiGraph, arcTypeConflict, r1, r2);
                }
            }
        }
        if (this.dependencies != null) {
            local.clear();
            keys1 = this.dependencies.keys();
            while (keys1.hasMoreElements()) {
                r1 = (Rule)keys1.nextElement();
                if (!r1.isEnabled()) continue;
                table = (Hashtable)this.dependencies.get(r1);
                keys2 = table.keys();
                while (keys2.hasMoreElements()) {
                    r2 = (Rule)keys2.nextElement();
                    if (!r2.isEnabled()) continue;
                    entry = this.dependCont.getEntry(r1, r2);
                    nr1 = (Node)local.get(r1.getName());
                    if (nr1 == null) {
                        nr1 = this.createNode(this.dependGraph, nodeType, r1);
                        local.put(r1.getName(), nr1);
                        if (r1 == r2) {
                            nr1.setVisible(entry.isRuleVisible());
                        }
                    }
                    if (this.combiGraph != null && (nr3 = (Node)common.get(r1.getName())) == null) {
                        nr3 = this.createNode(this.combiGraph, nodeType, r1);
                        common.put(r1.getName(), nr3);
                        if (r1 == r2) {
                            nr3.setVisible(entry.isRuleVisible());
                        }
                    }
                    p = (Pair)table.get(r2);
                    rel = (Boolean)p.first;
                    nr2 = (Node)local.get(r2.getName());
                    if (nr2 == null) {
                        nr2 = this.createNode(this.dependGraph, nodeType, r2);
                        local.put(r2.getName(), nr2);
                    }
                    if (this.combiGraph != null && (nr = (Node)common.get(r2.getName())) == null) {
                        nr = this.createNode(this.combiGraph, nodeType, r2);
                        common.put(r2.getName(), nr);
                    }
                    if (!rel) continue;
                    a = this.createEdge(this.dependGraph, arcTypeDepend, r1, r2);
                    if (this.combiGraph == null) continue;
                    a = this.createEdge(this.combiGraph, arcTypeDepend, r1, r2);
                }
            }
        }
        common.clear();
        common = null;
        local.clear();
        local = null;
    }

    private void optimizeLayout(EdGraph eg) {
        Enumeration e = eg.getArcs().elements();
        block0: while (e.hasMoreElements()) {
            EdArc a = (EdArc)e.nextElement();
            if (a.getSource() == a.getTarget() || !a.getBasisArc().isDirected()) continue;
            Enumeration e1 = eg.getArcs().elements();
            while (e1.hasMoreElements()) {
                EdArc a1 = (EdArc)e1.nextElement();
                if (a1.getSource() == a1.getTarget() || !a1.getBasisArc().isDirected() || a == a1 || !a.getType().getName().equals(a1.getType().getName()) || a.getSource() != a1.getTarget() || a.getTarget() != a1.getSource()) continue;
                a.getBasisArc().setVisible(false);
                a1.getBasisArc().setDirected(false);
                continue block0;
            }
        }
        eg.update();
        this.layoutGraph(eg);
    }

    private void layoutGraph(EdGraph eg) {
        Layouter layouter = new Layouter(100, null);
        eg.doDefaultEvolutionaryGraphLayout(layouter, 20);
    }

    private void storeVisArcs(Graph g) {
        this.visArcs.clear();
        Enumeration e = g.getArcs();
        while (e.hasMoreElements()) {
            Arc a1;
            Arc a = (Arc)e.nextElement();
            if (a.isDirected() || !a.isVisible() || (a1 = this.getEdge(g, a.getType(), (Node)a.getTarget(), (Node)a.getSource())) == null || this.visArcs.contains(a1)) continue;
            this.visArcs.add(a1);
        }
    }

    private Node showNode(Graph g, String tn, Rule r, boolean changePairContainer) {
        Type t = g.getTypeSet().getTypeForName(tn);
        if (t == null) {
            return null;
        }
        return this.showNode(g, t, r, changePairContainer);
    }

    private Node showNode(Graph g, Type t, Rule r, boolean changePairContainer) {
        Node n = this.getNode(g, r);
        if (n != null && !n.isVisible()) {
            n.setVisible(true);
        }
        return n;
    }

    private Node createNode(Graph g, Type t, Rule r) {
        Node n = this.getNode(g, r);
        if (n == null) {
            try {
                n = g.createNode(t);
                ValueTuple vt = (ValueTuple)n.getAttribute();
                String rname = r.getName();
                vt.getValueMemberAt("name").setExprAsObject(rname);
            }
            catch (TypeException e) {
                // empty catch block
            }
        }
        return n;
    }

    private Node createNode(Graph g, String tn, Rule r) {
        Type t = g.getTypeSet().getTypeForName(tn);
        return this.createNode(g, t, r);
    }

    private Node getNode(Graph g, Rule r) {
        Enumeration e = g.getNodes();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            if (!((String)n.getAttribute().getValueAt("name")).equals(r.getName())) continue;
            return n;
        }
        return null;
    }

    private void hideNode(Graph g, Rule r, boolean changePairContainer) {
        Node n;
        if (this.conflictCont != null && this.dependCont != null) {
            ExcludePairContainer.Entry entryCC = this.conflictCont.getEntry(r, r);
            ExcludePairContainer.Entry entryDC = this.dependCont.getEntry(r, r);
            if (this.conflictAction ? entryDC.getState() == 3 && entryDC.isRuleVisible() : entryCC.getState() == 3 && entryCC.isRuleVisible()) {
                return;
            }
        }
        if ((n = this.getNode(g, r)) != null && n.isVisible()) {
            n.setVisible(false);
        }
    }

    private void hideNodeContext(Graph g, Node n) {
        Arc a;
        Enumeration e = n.getIncomingArcs();
        while (e.hasMoreElements()) {
            a = (Arc)e.nextElement();
            if (!a.isVisible()) continue;
            this.hideEdge(g, a.getType(), (Node)a.getSource(), (Node)a.getTarget());
        }
        e = n.getOutgoingArcs();
        while (e.hasMoreElements()) {
            a = (Arc)e.nextElement();
            if (!a.isVisible()) continue;
            this.hideEdge(g, a.getType(), (Node)a.getSource(), (Node)a.getTarget());
        }
    }

    private Arc showEdge(Graph g, String tn, Rule r1, Rule r2) {
        Type t = g.getTypeSet().getTypeForName(tn);
        if (t == null) {
            return null;
        }
        Node n1 = this.getNode(g, r1);
        Node n2 = this.getNode(g, r2);
        return this.showEdge(g, t, n1, n2);
    }

    private Arc showEdge(Graph g, Type t, Node n1, Node n2) {
        if (t == null || n1 == null || n2 == null) {
            return null;
        }
        Arc a = this.getEdge(g, t, n1, n2);
        if (a != null) {
            a.setVisible(true);
            a.setDirected(true);
            if (a.getSource() == a.getTarget()) {
                return a;
            }
            Arc a1 = this.getEdge(g, t, n2, n1);
            if (a1 != null) {
                if (a1.isVisible()) {
                    a1.setVisible(false);
                    if (!this.visArcs.contains(a1)) {
                        this.visArcs.add(a1);
                    }
                    a.setDirected(false);
                } else if (this.visArcs.contains(a1)) {
                    a.setDirected(false);
                } else if (this.visArcs.contains(a)) {
                    this.visArcs.remove(a);
                }
            }
        }
        return a;
    }

    private Arc createEdge(Graph g, Type t, Node n1, Node n2) {
        if (t == null || n1 == null || n2 == null) {
            return null;
        }
        Arc a = this.getEdge(g, t, n1, n2);
        if (a == null) {
            try {
                Arc a1;
                a = g.createArc(t, n1, n2);
                if (n1 != n2 && (a1 = this.getEdge(g, t, n2, n1)) != null) {
                    a.setDirected(false);
                    a1.setVisible(false);
                    if (!this.visArcs.contains(a1)) {
                        this.visArcs.add(a1);
                    }
                }
            }
            catch (TypeException e) {
                // empty catch block
            }
        }
        return a;
    }

    private Arc createEdge(Graph g, Type t, Rule r1, Rule r2) {
        if (t == null || r1 == null || r2 == null) {
            return null;
        }
        Node n1 = this.getNode(g, r1);
        Node n2 = this.getNode(g, r2);
        return this.createEdge(g, t, n1, n2);
    }

    private Arc createEdge(Graph g, String tn, Rule r1, Rule r2) {
        Type t = g.getTypeSet().getTypeForName(tn);
        return this.createEdge(g, t, r1, r2);
    }

    private Arc getEdge(Graph g, String tn, Rule r1, Rule r2) {
        Type t = g.getTypeSet().getTypeForName(tn);
        Node n1 = this.getNode(g, r1);
        Node n2 = this.getNode(g, r2);
        return this.getEdge(g, t, n1, n2);
    }

    private void removeEdge(Graph g, String tn, Rule r1, Rule r2) {
        Type t = g.getTypeSet().getTypeForName(tn);
        Arc a = this.getEdge(g, t, r1, r2);
        if (a != null) {
            try {
                g.destroyArc(a);
            }
            catch (TypeException exc) {
                // empty catch block
            }
        }
    }

    private Arc getEdge(Graph g, Type t, Rule r1, Rule r2) {
        Node n1 = this.getNode(g, r1);
        Node n2 = this.getNode(g, r2);
        return this.getEdge(g, t, n1, n2);
    }

    private Arc getEdge(Graph g, Type t, Node n1, Node n2) {
        if (t == null || n1 == null || n2 == null) {
            return null;
        }
        Enumeration e = g.getArcs();
        while (e.hasMoreElements()) {
            Arc a = (Arc)e.nextElement();
            if (!a.getType().getName().equals(t.getName())) continue;
            Object src = a.getSource().getAttribute().getValueAt("name");
            Object tar = a.getTarget().getAttribute().getValueAt("name");
            Object name1 = n1.getAttribute().getValueAt("name");
            Object name2 = n2.getAttribute().getValueAt("name");
            if (src == null || !((String)src).equals(name1) || tar == null || !((String)tar).equals(name2)) continue;
            return a;
        }
        return null;
    }

    private boolean hideEdge(Graph g, String tn, Rule r1, Rule r2) {
        Type t = g.getTypeSet().getTypeForName(tn);
        if (t == null) {
            return false;
        }
        Node n1 = this.getNode(g, r1);
        Node n2 = this.getNode(g, r2);
        return this.hideEdge(g, t, n1, n2);
    }

    private boolean hideEdge(Graph g, Type t, Node n1, Node n2) {
        if (t == null || n1 == null || n2 == null) {
            return false;
        }
        Arc a = this.getEdge(g, t, n1, n2);
        if (a != null) {
            Arc a1;
            a.setVisible(false);
            if (a.getSource() == a.getTarget()) {
                return true;
            }
            if (this.visArcs.contains(a)) {
                this.visArcs.remove(a);
            }
            if ((a1 = this.getEdge(g, t, n2, n1)) != null) {
                if (a1.isVisible()) {
                    a1.setDirected(true);
                } else if (this.visArcs.contains(a1)) {
                    this.visArcs.remove(a1);
                    a1.setDirected(true);
                    a1.setVisible(true);
                }
            }
        }
        return false;
    }

    private void hideGraphObject() {
        Vector v = this.cpaLayout.getSelectedObjs();
        for (int i = 0; i < v.size(); ++i) {
            EdGraphObject go = (EdGraphObject)v.elementAt(i);
            go.setSelected(false);
            this.hiddenGraphObject = true;
            go.getBasisObject().setVisible(false);
            if (!go.isNode()) continue;
            Enumeration e = ((Node)go.getBasisObject()).getOutgoingArcs();
            while (e.hasMoreElements()) {
                ((Arc)e.nextElement()).setVisible(false);
            }
            e = ((Node)go.getBasisObject()).getIncomingArcs();
            while (e.hasMoreElements()) {
                ((Arc)e.nextElement()).setVisible(false);
            }
        }
    }

    private Rule getRule(Node n) {
        ValueTuple vt = (ValueTuple)n.getAttribute();
        String rname = (String)vt.getValueMemberAt("name").getExprAsObject();
        return this.grammar.getRule(rname);
    }

    private void straightEdges(EdGraph g) {
        Enumeration e = g.getArcs().elements();
        while (e.hasMoreElements()) {
            EdArc ea = (EdArc)e.nextElement();
            g.straightArc(ea);
        }
        g.update();
    }

    private void changeStyleOfEdges(EdGraph g, String edgeTypeName, int style) {
        Vector arctypes = g.getTypeSet().getArcTypes();
        for (int i = 0; i < arctypes.size(); ++i) {
            EdType et = (EdType)arctypes.get(i);
            if (!et.getBasisType().getName().equals(edgeTypeName)) continue;
            et.setShape(style);
            et.setAdditionalReprOfBasisType();
        }
    }

    public class SelectDialog
    extends JDialog {
        JButton conflictB;
        JLabel conflictFile;
        JButton dependB;
        JLabel dependFile;
        JButton showB;
        JButton cancelB;

        public SelectDialog(JFrame parent, ActionListener actionListener) {
            super((Frame)parent, true);
            this.setTitle("Conflicts  &&  Dependencies");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    SelectDialog.this.setVisible(false);
                    SelectDialog.this.dispose();
                }
            });
            this.setBackground(Color.lightGray);
            if (parent != null) {
                this.setLocationRelativeTo(parent);
                this.setLocation(100, 100);
            } else {
                this.setLocation(10, 10);
            }
            JPanel mainButtonPanel = new JPanel(new GridLayout(0, 1));
            mainButtonPanel.add(new JLabel("    "));
            JLabel l = new JLabel("  Please  choose  what  do  you  want  to  see.");
            mainButtonPanel.add(l);
            mainButtonPanel.add(new JLabel("    "));
            this.conflictB = new JButton("  Click  here  to  get  Rule  Conflicts  ");
            this.conflictB.addActionListener(actionListener);
            mainButtonPanel.add(this.conflictB);
            this.conflictFile = new JLabel("  File :  ");
            mainButtonPanel.add(this.conflictFile);
            mainButtonPanel.add(new JLabel("    "));
            this.dependB = new JButton("  Click  here  to  get  Rule  Dependencies  ");
            this.dependB.addActionListener(actionListener);
            mainButtonPanel.add(this.dependB);
            this.dependFile = new JLabel("  File :  ");
            mainButtonPanel.add(this.dependFile);
            mainButtonPanel.add(new JLabel("    "));
            JPanel buttonPanel = new JPanel(new GridLayout(1, 0));
            buttonPanel.add(new JLabel("    "));
            this.showB = new JButton("Show");
            this.showB.addActionListener(actionListener);
            buttonPanel.add(this.showB);
            buttonPanel.add(new JLabel("    "));
            this.cancelB = new JButton("Cancel");
            this.cancelB.addActionListener(actionListener);
            buttonPanel.add(this.cancelB);
            buttonPanel.add(new JLabel("    "));
            JPanel contentPane = new JPanel(new BorderLayout());
            contentPane.setBackground(Color.lightGray);
            contentPane.add((Component)mainButtonPanel, "Center");
            contentPane.add((Component)buttonPanel, "South");
            contentPane.revalidate();
            this.setContentPane(contentPane);
            this.setDefaultCloseOperation(0);
            this.validate();
            this.pack();
        }

        public JLabel getConflictFileLabel() {
            return this.conflictFile;
        }

        public JLabel getDependFileLabel() {
            return this.dependFile;
        }

        public JButton getConflictButton() {
            return this.conflictB;
        }

        public JButton getDependButton() {
            return this.dependB;
        }
    }
}

