/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.parser;

import agg.editor.impl.EdGraGra;
import agg.gui.parser.CriticalPairPanel;
import agg.gui.parser.GraphBrowser;
import agg.gui.parser.GraphDesktop;
import agg.gui.parser.ParserGUIOption;
import agg.gui.parser.RuleTree;
import agg.gui.parser.event.CPAEventData;
import agg.gui.parser.event.GUIOptionEvent;
import agg.gui.parser.event.GUIOptionListener;
import agg.gui.parser.event.ParserGUIEvent;
import agg.gui.parser.event.ParserGUIListener;
import agg.gui.parser.event.StatusMessageEvent;
import agg.gui.parser.event.StatusMessageListener;
import agg.parser.DependencyPairContainer;
import agg.parser.ExcludePairContainer;
import agg.parser.InvalidAlgorithmException;
import agg.parser.LayeredDependencyPairContainer;
import agg.parser.LayeredExcludePairContainer;
import agg.parser.PairContainer;
import agg.parser.Parser;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import com.objectspace.jgl.Pair;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class CriticalPairAnalysisGUI
implements ParserGUIListener,
ActionListener,
GUIOptionListener {
    public static final String CRITICALPAIRS = "Critical Pairs";
    public static final String CINFLICTSPAIRS = "Minimal Conflicts";
    public static final String DEPENDENCYPAIRS = "Minimal Dependencies";
    public static final String PARSER = "Parser";
    public static final String LOAD = "Load Pairs";
    public static final String SAVE = "Save Pairs";
    public static final String EXCLUDE = "Exclude";
    public static final String BEFORE = "Before";
    JSplitPane parserMainPane;
    JSplitPane treePane;
    JSplitPane graphPane;
    GraGra grammar;
    RuleTree rtTop;
    RuleTree rtBottom;
    GraphBrowser gBrowser;
    GraphDesktop gDesktop;
    Rule links;
    Rule rechts;
    CriticalPairPanel pairPanel;
    CriticalPairPanel pairPanel2;
    boolean isPanel2 = false;
    Thread threadCP;
    boolean threadCPisAlive;
    Vector listener;
    EdGraGra layout;
    Parser parser;
    PairContainer beo;
    PairContainer beo2;
    ParserGUIOption option;

    public CriticalPairAnalysisGUI(ParserGUIOption option) {
        this(null, null, option);
    }

    public CriticalPairAnalysisGUI(GraGra gragra, EdGraGra layout, ParserGUIOption option) {
        this.setGrammar(gragra);
        this.gDesktop = new GraphDesktop(layout, option);
        this.gBrowser = new GraphBrowser(layout);
        this.setLayout(layout);
        this.option = option;
        if (option != null) {
            option.addOptionListener(this);
        }
        this.listener = new Vector();
        this.rtTop = new RuleTree(gragra);
        this.rtTop.addParserGUIListener(this);
        this.rtBottom = new RuleTree(gragra);
        this.rtBottom.addParserGUIListener(this);
        this.links = null;
        this.rechts = null;
        this.treePane = new JSplitPane(0);
        JScrollPane tmpPane = new JScrollPane(this.rtTop.getTree());
        this.treePane.setTopComponent(tmpPane);
        tmpPane = new JScrollPane(this.rtBottom.getTree());
        this.treePane.setBottomComponent(tmpPane);
        if (option != null) {
            this.gDesktop.setOverlappingGraphWindowSize(option.getCriticalPairWindowSize());
        } else {
            this.gDesktop.setOverlappingGraphWindowSize(new Dimension(250, 200));
        }
        this.graphPane = new JSplitPane(0);
        this.graphPane.setOneTouchExpandable(false);
        this.graphPane.setTopComponent(null);
        this.graphPane.setBottomComponent((JScrollPane)this.gDesktop.getComponent());
        this.graphPane.setDividerLocation(0);
        this.parserMainPane = new JSplitPane();
        this.parserMainPane.setOneTouchExpandable(false);
        this.parserMainPane.setLeftComponent(null);
        this.parserMainPane.setRightComponent(this.graphPane);
        this.parserMainPane.setDividerLocation(0);
        this.parserMainPane.revalidate();
    }

    public void addMouseListener(MouseListener ml) {
        this.treePane.addMouseListener(ml);
        this.gBrowser.getLeftComponent().addMouseListener(ml);
        this.gBrowser.getRightComponent().addMouseListener(ml);
        this.gDesktop.getComponent().addMouseListener(ml);
        if (this.pairPanel != null) {
            this.pairPanel.getMainContainer().addMouseListener(ml);
        }
        if (this.pairPanel2 != null) {
            this.pairPanel.getMainContainer().addMouseListener(ml);
        }
    }

    private void setGrammar(GraGra gragra) {
        this.grammar = gragra;
        if (this.grammar != null) {
            this.rtTop.setGrammar(this.grammar);
            this.rtBottom.setGrammar(this.grammar);
        }
    }

    public void setCriticalPairs(PairContainer pairs) {
        if (pairs == null) {
            return;
        }
        if (pairs.getGrammar().getRules() == null) {
            return;
        }
        if (pairs.getKindOfConflict() == 1) {
            this.setCriticalPairs2(pairs);
            return;
        }
        this.beo = pairs;
        if (this.pairPanel == null) {
            String cpTableName = CINFLICTSPAIRS;
            this.pairPanel = this.beo instanceof LayeredExcludePairContainer ? new CriticalPairPanel(this.grammar.getRules(), (ExcludePairContainer)((LayeredExcludePairContainer)this.beo)) : new CriticalPairPanel(this.grammar.getRules(), (ExcludePairContainer)this.beo);
            this.gDesktop.addCriticalPairTable(this.pairPanel, cpTableName);
            this.parserMainPane.revalidate();
            this.parserMainPane.repaint();
            this.pairPanel.addParserGUIListener(this);
            ((ExcludePairContainer)this.beo).addPairEventListener(this.pairPanel);
        } else {
            if (this.beo instanceof LayeredExcludePairContainer) {
                this.pairPanel.setPairContainer((LayeredExcludePairContainer)this.beo);
            } else {
                this.pairPanel.setPairContainer((ExcludePairContainer)this.beo);
            }
            this.gDesktop.removeAllGraphFrames();
            this.gDesktop.removeRuleFrames();
            this.parserMainPane.revalidate();
            this.parserMainPane.repaint();
            ((ExcludePairContainer)this.beo).addPairEventListener(this.pairPanel);
        }
        this.fireStatusMessageEvent(new StatusMessageEvent(this, ""));
    }

    private void setCriticalPairs2(PairContainer pairs) {
        if (pairs == null || pairs.getGrammar().getRules() == null) {
            return;
        }
        this.beo2 = pairs;
        if (this.pairPanel2 == null) {
            String cpTableName = DEPENDENCYPAIRS;
            if (this.beo2 instanceof LayeredDependencyPairContainer) {
                this.pairPanel2 = new CriticalPairPanel(this.grammar.getRules(), (ExcludePairContainer)((LayeredDependencyPairContainer)this.beo2));
            } else if (this.beo2 instanceof DependencyPairContainer) {
                this.pairPanel2 = new CriticalPairPanel(this.grammar.getRules(), (ExcludePairContainer)((DependencyPairContainer)this.beo2));
            }
            this.gDesktop.addCriticalPairTable(this.pairPanel2, cpTableName);
            this.parserMainPane.revalidate();
            this.parserMainPane.repaint();
            this.pairPanel2.addParserGUIListener(this);
            ((ExcludePairContainer)this.beo2).addPairEventListener(this.pairPanel2);
        } else {
            if (this.beo2 instanceof LayeredDependencyPairContainer) {
                this.pairPanel2.setPairContainer((LayeredDependencyPairContainer)this.beo2);
            } else if (this.beo instanceof DependencyPairContainer) {
                this.pairPanel2.setPairContainer((DependencyPairContainer)this.beo2);
            }
            this.gDesktop.removeAllGraphFrames();
            this.gDesktop.removeRuleFrames();
            this.parserMainPane.revalidate();
            this.parserMainPane.repaint();
            ((ExcludePairContainer)this.beo2).addPairEventListener(this.pairPanel2);
        }
        this.fireStatusMessageEvent(new StatusMessageEvent(this, ""));
    }

    public PairContainer getCriticalPairs() {
        return this.beo;
    }

    public PairContainer getCriticalPairs2() {
        return this.beo2;
    }

    public PairContainer getCriticalPairs(int kindOfConflict) {
        if (kindOfConflict == 0) {
            return this.beo;
        }
        if (kindOfConflict == 1) {
            return this.beo2;
        }
        return null;
    }

    private void setLayout(EdGraGra edgragra) {
        this.layout = edgragra;
        this.gDesktop.setLayout(this.layout);
        this.gBrowser.setLayout(this.layout);
    }

    public Container getContainer() {
        return this.parserMainPane;
    }

    public CriticalPairPanel getCriticalPairPanel() {
        return this.pairPanel;
    }

    public CriticalPairPanel getCriticalPairPanel2() {
        return this.pairPanel2;
    }

    public CriticalPairPanel getCriticalPairPanel(int kind) {
        if (kind == 0) {
            return this.pairPanel;
        }
        if (kind == 1) {
            return this.pairPanel2;
        }
        return null;
    }

    public void reinitGraphDesktop() {
        if (this.beo != null) {
            ((ExcludePairContainer)this.beo).removePairEventListener(this.pairPanel);
        }
        if (this.beo2 != null) {
            ((ExcludePairContainer)this.beo2).removePairEventListener(this.pairPanel2);
        }
        this.gDesktop.reinitComponents();
        this.pairPanel = null;
        this.beo = null;
        this.pairPanel2 = null;
        this.beo2 = null;
        this.gDesktop.getDesktop().repaint();
    }

    public GraphDesktop getGraphDesktop() {
        return this.gDesktop;
    }

    public void update() {
        this.gBrowser.refresh();
        this.gDesktop.refresh();
        this.parserMainPane.revalidate();
        this.parserMainPane.repaint();
    }

    public String setGraGra(EdGraGra edgragra) {
        boolean changed = false;
        if (edgragra != null) {
            if (this.grammar == null || edgragra.getBasisGraGra() != this.grammar) {
                this.reinitGraphDesktop();
                this.setGrammar(edgragra.getBasisGraGra());
                changed = true;
                if (this.pairPanel != null) {
                    ((ExcludePairContainer)this.beo).removePairEventListener(this.pairPanel);
                    this.gDesktop.removePairPanelFrame(this.pairPanel);
                    this.pairPanel = null;
                    this.beo = null;
                }
                if (this.pairPanel2 != null) {
                    ((ExcludePairContainer)this.beo2).removePairEventListener(this.pairPanel2);
                    this.gDesktop.removePairPanelFrame(this.pairPanel2);
                    this.pairPanel2 = null;
                    this.beo2 = null;
                }
            }
            this.setLayout(edgragra);
            this.gBrowser.setLeftGraph(null);
            this.links = null;
            this.gBrowser.setRightGraph(null);
            this.rechts = null;
        }
        if (edgragra == null) {
            this.reinitGraphDesktop();
        } else {
            this.gDesktop.removeAllGraphFrames();
            this.gDesktop.removeRuleFrames();
        }
        return "";
    }

    public EdGraGra getGraGra() {
        return this.layout;
    }

    public void setGUIOption(ParserGUIOption option) {
        this.option = option;
        this.gDesktop.setGUIOption(option);
        option.addOptionListener(this);
    }

    public JMenu createMenu() {
        JMenu m = new JMenu("Parse");
        m.add(new JCheckBoxMenuItem(CRITICALPAIRS, false));
        m.add(new JMenuItem(PARSER));
        m.addSeparator();
        JMenuItem load = new JMenuItem(LOAD);
        JMenuItem save = new JMenuItem(SAVE);
        load.setEnabled(false);
        save.setEnabled(false);
        m.add(load);
        m.add(save);
        m.addSeparator();
        JMenu beforeExcludeList = new JMenu("Mode");
        m.add(beforeExcludeList);
        JCheckBoxMenuItem exclude = new JCheckBoxMenuItem(EXCLUDE, true);
        exclude.addActionListener(this);
        JCheckBoxMenuItem before = new JCheckBoxMenuItem(BEFORE, false);
        before.addActionListener(this);
        beforeExcludeList.add(exclude);
        beforeExcludeList.add(before);
        return m;
    }

    public void occured(ParserGUIEvent pguie) {
        if (pguie.getData() instanceof CPAEventData) {
            return;
        }
        if (this.getCriticalPairs() != null && ((ExcludePairContainer)this.getCriticalPairs()).isAlive()) {
            return;
        }
        if (this.getCriticalPairs2() != null && ((ExcludePairContainer)this.getCriticalPairs2()).isAlive()) {
            return;
        }
        if (pguie.getData() == null) {
            this.gDesktop.removeAllGraphFrames();
            this.gDesktop.removeRuleFrames();
            this.parserMainPane.revalidate();
            this.parserMainPane.repaint();
            return;
        }
        if (this.threadCP == null || !this.threadCPisAlive) {
            this.parserMainPane.revalidate();
            this.parserMainPane.repaint();
            if (pguie.getSource() == this.pairPanel) {
                this.gDesktop.setIconOfCPAGraph(true);
                this.gDesktop.setIconOfRules(true);
                if (pguie.getData() instanceof Pair && ((Pair)pguie.getData()).first instanceof Rule && ((Pair)pguie.getData()).second instanceof Rule) {
                    this.isPanel2 = false;
                    this.links = (Rule)((Pair)pguie.getData()).first;
                    this.rechts = (Rule)((Pair)pguie.getData()).second;
                    this.gDesktop.addRule1(this.links, 300, 150);
                    this.gDesktop.addRule2(this.rechts, 300, 150);
                }
            } else if (pguie.getSource() == this.pairPanel2) {
                this.gDesktop.setIconOfCPAGraph(true);
                if (pguie.getData() instanceof Pair && ((Pair)pguie.getData()).first instanceof Rule && ((Pair)pguie.getData()).second instanceof Rule) {
                    this.isPanel2 = true;
                    this.links = (Rule)((Pair)pguie.getData()).first;
                    this.rechts = (Rule)((Pair)pguie.getData()).second;
                    this.gDesktop.addRule1(this.links, 300, 150);
                    this.gDesktop.addRule2(this.rechts, 300, 150);
                }
            }
            this.parserMainPane.revalidate();
            this.parserMainPane.repaint();
            if (this.links != null && this.rechts != null) {
                StatusMessageEvent sme = new StatusMessageEvent(this, "", "Overlapping graphs of rules  [  " + this.links.getName() + "  ,  " + this.rechts.getName() + "  ]");
                this.fireStatusMessageEvent(sme);
                this.gDesktop.removeAllGraphFrames();
                this.parserMainPane.revalidate();
                this.parserMainPane.repaint();
                if (!this.isPanel2) {
                    ((ExcludePairContainer)this.beo).setStop(false);
                } else {
                    ((ExcludePairContainer)this.beo2).setStop(false);
                }
                this.threadCP = new Thread(){

                    public void run() {
                        CriticalPairAnalysisGUI.this.threadCPisAlive = true;
                        CriticalPairAnalysisGUI.this.fireStatusMessageEvent(new StatusMessageEvent(this, "", "Thread  -  Computing overlapping graphs of rules  [  " + CriticalPairAnalysisGUI.this.links.getName() + "  ,  " + CriticalPairAnalysisGUI.this.rechts.getName() + "  ]  -  is running ..."));
                        Vector overlappings = null;
                        try {
                            overlappings = !CriticalPairAnalysisGUI.this.isPanel2 ? (Vector)((ExcludePairContainer)CriticalPairAnalysisGUI.this.beo).getCritical(CriticalPairAnalysisGUI.this.links, CriticalPairAnalysisGUI.this.rechts, 0, true) : (Vector)((ExcludePairContainer)CriticalPairAnalysisGUI.this.beo2).getCritical(CriticalPairAnalysisGUI.this.links, CriticalPairAnalysisGUI.this.rechts, 0, true);
                        }
                        catch (InvalidAlgorithmException iae) {
                            // empty catch block
                        }
                        if (overlappings != null) {
                            if (!CriticalPairAnalysisGUI.this.isPanel2) {
                                if (overlappings.size() > 0) {
                                    if (CriticalPairAnalysisGUI.this.beo instanceof DependencyPairContainer) {
                                        for (int x = 0; x < overlappings.size(); ++x) {
                                            Pair p = (Pair)overlappings.elementAt(x);
                                            Pair p1 = (Pair)p.first;
                                            Graph graph = ((OrdinaryMorphism)p1.first).getImage();
                                            CriticalPairAnalysisGUI.this.gDesktop.addOverlapping(graph, p);
                                            CriticalPairAnalysisGUI.this.gDesktop.addGraph(graph);
                                        }
                                    } else if (CriticalPairAnalysisGUI.this.beo instanceof ExcludePairContainer) {
                                        for (int x = 0; x < overlappings.size(); ++x) {
                                            Pair p = (Pair)overlappings.elementAt(x);
                                            Pair p1 = (Pair)p.first;
                                            Graph graph = ((OrdinaryMorphism)p1.first).getImage();
                                            CriticalPairAnalysisGUI.this.gDesktop.addOverlapping(graph, p);
                                            CriticalPairAnalysisGUI.this.gDesktop.addGraph(graph);
                                        }
                                    }
                                }
                            } else if (overlappings.size() > 0 && CriticalPairAnalysisGUI.this.beo2 instanceof DependencyPairContainer) {
                                for (int x = 0; x < overlappings.size(); ++x) {
                                    Pair p = (Pair)overlappings.elementAt(x);
                                    Pair p1 = (Pair)p.first;
                                    Graph graph = ((OrdinaryMorphism)p1.first).getImage();
                                    CriticalPairAnalysisGUI.this.gDesktop.addOverlapping(graph, p);
                                    CriticalPairAnalysisGUI.this.gDesktop.addGraph(graph);
                                }
                            }
                        } else if (!CriticalPairAnalysisGUI.this.isPanel2) {
                            if (((ExcludePairContainer)CriticalPairAnalysisGUI.this.beo).getEntry(CriticalPairAnalysisGUI.this.links, CriticalPairAnalysisGUI.this.rechts, true).getState() == 3) {
                                CriticalPairAnalysisGUI.this.gDesktop.notCriticFrame(CriticalPairAnalysisGUI.this.links, CriticalPairAnalysisGUI.this.rechts);
                            }
                        } else if (((ExcludePairContainer)CriticalPairAnalysisGUI.this.beo2).getEntry(CriticalPairAnalysisGUI.this.links, CriticalPairAnalysisGUI.this.rechts, true).getState() == 3) {
                            CriticalPairAnalysisGUI.this.gDesktop.notCriticFrame(CriticalPairAnalysisGUI.this.links, CriticalPairAnalysisGUI.this.rechts);
                        }
                        CriticalPairAnalysisGUI.this.fireStatusMessageEvent(new StatusMessageEvent(this, "", "Thread  -  Computing overlapping graphs of rules  [  " + CriticalPairAnalysisGUI.this.links.getName() + "  ,  " + CriticalPairAnalysisGUI.this.rechts.getName() + "  ]  -  finished"));
                        CriticalPairAnalysisGUI.this.threadCPisAlive = false;
                    }
                };
                this.threadCP.setPriority(4);
                this.threadCP.start();
            }
        }
    }

    public boolean isGenerating() {
        if (this.beo != null && ((ExcludePairContainer)this.beo).isAlive()) {
            return true;
        }
        return this.beo2 != null && ((ExcludePairContainer)this.beo2).isAlive();
    }

    public boolean pairsComputed() {
        if (this.beo != null && ((ExcludePairContainer)this.beo).isComputed()) {
            return true;
        }
        return this.beo2 != null && ((ExcludePairContainer)this.beo2).isComputed();
    }

    public boolean isOnePairThreadAlive() {
        return this.threadCP != null && this.threadCPisAlive;
    }

    public PairContainer getActivePairContainer() {
        CriticalPairPanel p = this.gDesktop.getActivePairPanel();
        if (p != null) {
            return p.getPairContainer();
        }
        return null;
    }

    public void stopOnePairThread() {
        if (this.threadCP != null && this.threadCPisAlive) {
            if (this.beo != null) {
                ((ExcludePairContainer)this.beo).setStop(true);
            }
            if (this.beo2 != null) {
                ((ExcludePairContainer)this.beo2).setStop(true);
            }
            this.threadCPisAlive = false;
        }
    }

    public void addStatusMessageListener(StatusMessageListener sml) {
        this.listener.addElement(sml);
    }

    private void fireStatusMessageEvent(StatusMessageEvent sme) {
        for (int i = 0; i < this.listener.size(); ++i) {
            ((StatusMessageListener)this.listener.elementAt(i)).newMessage(sme);
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void optionHasChanged(GUIOptionEvent e) {
        if (e.getChangedOption().equals("CriticalPairWindowSize")) {
            this.gDesktop.setOverlappingGraphWindowSize(this.option.getCriticalPairWindowSize());
        } else if (e.getChangedOption().equals("ParserDisplay") || e.getChangedOption().equals("NumberOfCriticalPair")) {
            // empty if block
        }
    }
}

