/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.parser;

import agg.gui.AbstractOptionGUI;
import agg.gui.IconResource;
import agg.gui.parser.ParserGUIOption;
import agg.parser.CriticalPairOption;
import agg.parser.OptionEventListener;
import agg.parser.ParserOption;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyVetoException;
import java.util.Dictionary;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CriticalPairOptionGUI
extends AbstractOptionGUI
implements ItemListener,
ActionListener,
ChangeListener,
OptionEventListener {
    private CriticalPairOption cpOption;
    JButton displaySwitch;
    JButton generalSwitch;
    private static final int MAX = 20;
    JSlider numberCriticalPairs;
    JInternalFrame virtualGraph;
    JSlider verticalSize;
    JSlider horizontalSize;
    JComboBox algorithms;
    JComboBox additionalAlgorithms;
    JCheckBox layered;
    JComboBox layers;
    JCheckBox complete;
    JCheckBox reduce;
    JCheckBox consistent;
    JPanel firstPriorityOption;
    JPanel secondPriorityOption;
    ParserGUIOption guiOption;
    ParserOption pOption;

    public CriticalPairOptionGUI(CriticalPairOption cpOption, ParserGUIOption guiOption, ParserOption pOption) {
        this.cpOption = cpOption;
        this.guiOption = guiOption;
        this.pOption = pOption;
        this.firstPriorityOption = this.makeFirstPriorityOption();
        this.secondPriorityOption = this.makeSecondPriorityOption();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 1;
        c.anchor = 18;
        c.gridwidth = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.add((Component)this.firstPriorityOption, c);
        this.validate();
    }

    public Dimension getPreferredSize() {
        return new Dimension(350, 400);
    }

    public void setGUIOption(ParserGUIOption pguiOption) {
        this.guiOption = pguiOption;
    }

    public void setParserOption(ParserOption pOption) {
        this.pOption = pOption;
    }

    private JPanel makeFirstPriorityOption() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 18;
        JPanel optionPanel = this.makeInitialOptionPanel(" General Settings", c);
        optionPanel.setBorder(new TitledBorder(""));
        c.fill = 1;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.insets = new Insets(5, 0, 5, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.weighty = 0.0;
        JPanel algorithmP = this.makeCriticalPairAlgorithm();
        optionPanel.add((Component)algorithmP, c);
        c.weighty = 0.0;
        JPanel completeP = this.makeComplete();
        optionPanel.add((Component)completeP, c);
        c.weighty = 0.0;
        JPanel consistentP = this.makeConsistent();
        optionPanel.add((Component)consistentP, c);
        c.weighty = 0.0;
        JPanel reduceP = this.makeReduce();
        c.weightx = 1.0;
        c.weighty = 1.0;
        JPanel placeHolder1 = new JPanel();
        placeHolder1.setPreferredSize(new Dimension(200, 200));
        optionPanel.add((Component)placeHolder1, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        JPanel placeHolder = new JPanel();
        placeHolder.setPreferredSize(new Dimension(200, 200));
        optionPanel.add((Component)placeHolder, c);
        c.weightx = 1.0;
        c.gridwidth = -1;
        JPanel placeHolder2 = new JPanel();
        placeHolder2.setPreferredSize(new Dimension(200, 200));
        optionPanel.add((Component)placeHolder2, c);
        c.gridwidth = 0;
        c.weightx = 0.0;
        this.displaySwitch = new JButton("Display Settings...");
        this.displaySwitch.addActionListener(this);
        optionPanel.add((Component)this.displaySwitch, c);
        return optionPanel;
    }

    private JPanel makeSecondPriorityOption() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 18;
        JPanel optionPanel = this.makeInitialOptionPanel(" Display Settings", c);
        optionPanel.setBorder(new TitledBorder(""));
        c.weightx = 1.0;
        c.weighty = 0.01;
        c.fill = 1;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.insets = new Insets(5, 0, 5, 0);
        c.weighty = 0.0;
        JPanel pairOption = this.makeCriticalPairDisplay();
        pairOption.setBorder(new TitledBorder(""));
        optionPanel.add((Component)pairOption, c);
        c.weighty = 1.0;
        JPanel pairSize = this.makePairSize();
        optionPanel.add((Component)pairSize, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        JPanel placeHolder = new JPanel();
        placeHolder.setPreferredSize(new Dimension(200, 200));
        optionPanel.add((Component)placeHolder, c);
        c.weightx = 1.0;
        c.gridwidth = -1;
        JPanel placeHolder2 = new JPanel();
        placeHolder2.setPreferredSize(new Dimension(200, 200));
        optionPanel.add((Component)placeHolder2, c);
        c.gridwidth = 0;
        c.weightx = 0.0;
        this.generalSwitch = new JButton(" General Settings...");
        this.generalSwitch.addActionListener(this);
        optionPanel.add((Component)this.generalSwitch, c);
        return optionPanel;
    }

    private JPanel makeCriticalPairDisplay() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        JPanel optionPanel = this.makeInitialOptionPanel(" Number of displayed critical pairs", c);
        c.anchor = 17;
        JSlider slider = new JSlider(0, 0, 20, 5);
        optionPanel.add((Component)slider, c);
        slider.setMinorTickSpacing(1);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.setPaintTrack(true);
        slider.setMajorTickSpacing(slider.getMinorTickSpacing() * 5);
        slider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int i = slider.getMinimum(); i < slider.getMaximum(); ++i) {
            if (i % 5 != 0) continue;
            ((Dictionary)labelTable).put(new Integer(i), new JLabel("" + i));
        }
        JLabel all = new JLabel("All");
        ((Dictionary)labelTable).put(new Integer(slider.getMaximum()), all);
        slider.setLabelTable(labelTable);
        JLabel invisible = new JLabel("None");
        ((Dictionary)labelTable).put(new Integer(slider.getMinimum()), invisible);
        slider.setLabelTable(labelTable);
        this.numberCriticalPairs = slider;
        this.numberCriticalPairs.addChangeListener(this);
        return optionPanel;
    }

    private JPanel makePairSize() {
        JPanel optionPanel = this.makeInitialOptionPanel(" Set initial critical pair window size");
        optionPanel.setBorder(new TitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        JDesktopPane virtualDesktop = new JDesktopPane();
        this.virtualGraph = new JInternalFrame("Virtual Overlapping Graph", false, false, false, false);
        this.virtualGraph.setVisible(true);
        ImageIcon internalFrameIcon = IconResource.getIconFromURL(IconResource.getURLOverlapGraph());
        this.virtualGraph.setFrameIcon(internalFrameIcon);
        virtualDesktop.add(this.virtualGraph);
        try {
            this.virtualGraph.setSelected(true);
        }
        catch (PropertyVetoException pve) {
            // empty catch block
        }
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        optionPanel.add((Component)virtualDesktop, c);
        this.verticalSize = new JSlider(1, 80, 500, 200);
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        this.verticalSize.addChangeListener(this);
        this.verticalSize.setInverted(true);
        optionPanel.add((Component)this.verticalSize, c);
        this.horizontalSize = new JSlider(0, 120, 800, 200);
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.horizontalSize.addChangeListener(this);
        optionPanel.add((Component)this.horizontalSize, c);
        this.virtualGraph.setSize(this.horizontalSize.getValue() / 2, this.verticalSize.getValue() / 2);
        optionPanel.add((Component)new JLabel("Scale: 1:2"), c);
        return optionPanel;
    }

    private JPanel makeCriticalPairAlgorithm() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        JPanel optionPanel = this.makeInitialOptionPanel(" Select the kind of critical pairs   &   layer to compute", c);
        optionPanel.setBorder(new TitledBorder(""));
        c.gridwidth = 0;
        c.weightx = 1.0;
        optionPanel.add((Component)new JPanel(), c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        this.algorithms = new JComboBox();
        this.algorithms.addItem("  conflicts  ");
        this.algorithms.addItem("  dependencies  ");
        this.algorithms.addItemListener(this);
        optionPanel.add((Component)this.algorithms, c);
        c.insets = new Insets(0, 20, 0, 0);
        this.layered = new JCheckBox("layered", false);
        this.layered.addActionListener(this);
        optionPanel.add((Component)this.layered, c);
        c.insets = new Insets(0, 20, 0, 0);
        this.layers = new JComboBox();
        this.layers.addActionListener(this);
        this.layers.addItem("All");
        this.layers.setEnabled(false);
        optionPanel.add((Component)this.layers, c);
        c.insets = new Insets(0, 5, 0, 0);
        JLabel lLayers = new JLabel("Layer");
        optionPanel.add((Component)lLayers, c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        optionPanel.add((Component)new JPanel(), c);
        return optionPanel;
    }

    private JPanel makeComplete() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        JPanel optionPanel = this.makeInitialOptionPanel(" Select completeness of critical pairs", c);
        optionPanel.setBorder(new TitledBorder(""));
        c.gridwidth = 0;
        c.weightx = 1.0;
        optionPanel.add((Component)new JPanel(), c);
        c.insets = new Insets(0, 20, 0, 0);
        this.complete = new JCheckBox("complete", true);
        this.cpOption.enableComplete(true);
        this.complete.addActionListener(this);
        optionPanel.add((Component)this.complete, c);
        c.insets = new Insets(5, 0, 5, 0);
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        optionPanel.add((Component)new JLabel(" ( If not selected, search up to first critical match )"), c);
        return optionPanel;
    }

    private JPanel makeReduce() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        JPanel optionPanel = this.makeInitialOptionPanel(" Select essential critical pairs            ", c);
        optionPanel.setBorder(new TitledBorder(""));
        c.gridwidth = 0;
        c.weightx = 1.0;
        optionPanel.add((Component)new JPanel(), c);
        c.insets = new Insets(0, 20, 0, 0);
        this.reduce = new JCheckBox("essential    ( still at the experimental stage )", false);
        this.cpOption.enableReduce(false);
        this.reduce.addActionListener(this);
        optionPanel.add((Component)this.reduce, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        optionPanel.add((Component)new JLabel(" ( An essential critical pair exists for each conflict reason. "), c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        optionPanel.add((Component)new JPanel(), c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        optionPanel.add((Component)new JLabel("   It expresses the conflict caused by exactly this conflict "), c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        optionPanel.add((Component)new JPanel(), c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        optionPanel.add((Component)new JLabel("   reason in a minimal context. The essential critical pairs "), c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        optionPanel.add((Component)new JPanel(), c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        optionPanel.add((Component)new JLabel("   are a subset of the critical pairs. "), c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        optionPanel.add((Component)new JPanel(), c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        optionPanel.add((Component)new JLabel("   If not selected, compute the set of critical pairs. )"), c);
        return optionPanel;
    }

    private JPanel makeConsistent() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        JPanel optionPanel = this.makeInitialOptionPanel(" Select consistency check of critical pairs", c);
        optionPanel.setBorder(new TitledBorder(""));
        c.gridwidth = 0;
        c.weightx = 1.0;
        optionPanel.add((Component)new JPanel(), c);
        c.insets = new Insets(0, 20, 0, 0);
        this.consistent = new JCheckBox("consistent", true);
        this.consistent.addActionListener(this);
        optionPanel.add((Component)this.consistent, c);
        this.cpOption.enableConsistent(true);
        c.insets = new Insets(5, 0, 0, 0);
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        optionPanel.add((Component)new JLabel(" ( If not selected, critical overlappings will not be checked "), c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        optionPanel.add((Component)new JPanel(), c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        optionPanel.add((Component)new JLabel("  against graph consistency constraints of a grammar."), c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        optionPanel.add((Component)new JPanel(), c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        optionPanel.add((Component)new JLabel("  If the grammar does not contain graph constraints,"), c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        optionPanel.add((Component)new JPanel(), c);
        c.insets = new Insets(0, 0, 5, 0);
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        optionPanel.add((Component)new JLabel("  selection has no effect. )"), c);
        return optionPanel;
    }

    public Icon getIcon() {
        return null;
    }

    public String getTabTitle() {
        return "Critical Pairs";
    }

    public String getTabTip() {
        return "Options of Critical Pair Analysis";
    }

    public void initLayers(Vector v) {
        this.layers.removeAllItems();
        this.layers.addItem("All");
        for (int i = 0; i < v.size(); ++i) {
            this.layers.addItem((String)v.get(i));
        }
    }

    public void update() {
        if (this.guiOption == null) {
            this.numberCriticalPairs.setValue(this.numberCriticalPairs.getMaximum());
        } else if (this.guiOption.getNumberOfCriticalPair() == Integer.MAX_VALUE) {
            this.numberCriticalPairs.setValue(this.numberCriticalPairs.getMaximum());
        } else {
            this.numberCriticalPairs.setValue(this.guiOption.getNumberOfCriticalPair());
        }
        if (this.guiOption == null) {
            this.verticalSize.setValue(200);
            this.horizontalSize.setValue(200);
        } else {
            this.verticalSize.setValue((int)this.guiOption.getCriticalPairWindowSize().getHeight());
            this.horizontalSize.setValue((int)this.guiOption.getCriticalPairWindowSize().getWidth());
        }
        if (this.cpOption == null) {
            return;
        }
        if (this.cpOption.getCriticalPairAlgorithm() == 0) {
            this.algorithms.setSelectedItem("  conflicts  ");
        } else if (this.cpOption.getCriticalPairAlgorithm() == 1) {
            this.algorithms.setSelectedItem("  dependencies  ");
        }
        this.layered.setSelected(this.cpOption.layeredEnabled());
        if (this.layered.isSelected()) {
            this.layers.setEnabled(true);
        } else {
            this.layers.setEnabled(false);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.algorithms) {
            if (this.algorithms.getSelectedItem().equals("  conflicts  ")) {
                this.cpOption.setCriticalPairAlgorithm(0);
            } else if (this.algorithms.getSelectedItem().equals("  dependencies  ")) {
                this.cpOption.setCriticalPairAlgorithm(1);
            }
        }
    }

    public void addActionListener(ActionListener l) {
        this.layered.addActionListener(l);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.displaySwitch) || source.equals(this.generalSwitch)) {
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.anchor = 18;
            c.gridwidth = 0;
            c.weighty = 1.0;
            c.weightx = 1.0;
            if (source.equals(this.displaySwitch)) {
                this.remove(this.firstPriorityOption);
                this.add((Component)this.secondPriorityOption, c);
            } else if (source.equals(this.generalSwitch)) {
                this.remove(this.secondPriorityOption);
                this.add((Component)this.firstPriorityOption, c);
            }
            this.revalidate();
            this.secondPriorityOption.repaint();
            this.firstPriorityOption.repaint();
        } else if (source.equals(this.layered)) {
            this.cpOption.enableLayered(this.layered.isSelected());
            if (this.layered.isSelected()) {
                this.layers.setEnabled(true);
            } else {
                this.layers.setEnabled(false);
            }
        } else if (source.equals(this.layers)) {
            if (this.layers.getSelectedItem() != null) {
                String l = this.layers.getSelectedItem().toString();
                if (l.equals("All")) {
                    l = "-1";
                }
                this.cpOption.setLayer(new Integer(l));
            }
        } else if (source.equals(this.complete)) {
            this.cpOption.enableComplete(this.complete.isSelected());
        } else if (source.equals(this.reduce)) {
            this.cpOption.enableReduce(this.reduce.isSelected());
        } else if (source.equals(this.consistent)) {
            this.cpOption.enableConsistent(this.consistent.isSelected());
        } else if (source instanceof JCheckBox && ((JCheckBox)source).getText().equals("layered")) {
            this.layered.setSelected(((JCheckBox)source).isSelected());
            this.cpOption.enableLayered(this.layered.isSelected());
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source.equals(this.verticalSize) || source.equals(this.horizontalSize)) {
            this.virtualGraph.setSize(this.horizontalSize.getValue() / 2, this.verticalSize.getValue() / 2);
            if (this.guiOption == null) {
                this.guiOption.setCriticalPairWindowSize(200, 200);
            } else {
                this.guiOption.setCriticalPairWindowSize(this.horizontalSize.getValue(), this.verticalSize.getValue());
            }
        } else if (source.equals(this.numberCriticalPairs)) {
            int op = this.numberCriticalPairs.getValue();
            if (this.guiOption != null) {
                if (op == 20) {
                    this.guiOption.setNumberOfCriticalPair(Integer.MAX_VALUE);
                } else {
                    this.guiOption.setNumberOfCriticalPair(op);
                }
            }
        }
    }

    public void optionEventOccurred(EventObject e) {
        if (e.getSource() instanceof JCheckBox) {
            JCheckBox cb = (JCheckBox)e.getSource();
            if (cb.getText().equals("layered")) {
                this.cpOption.enableLayered(cb.isSelected());
                this.layered.doClick();
            }
        } else if (e.getSource() instanceof ParserOption) {
            boolean b = ((ParserOption)e.getSource()).layerEnabled();
            this.cpOption.enableLayered(b);
            if (b && !this.layered.isSelected()) {
                this.layered.doClick();
            } else if (!b && this.layered.isSelected()) {
                this.layered.doClick();
            }
            if (this.layered.isSelected()) {
                this.layers.setEnabled(true);
            }
        }
    }
}

